<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
	
		<meta charset="UTF-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
		<meta name="keywords" content="">
		<meta name="author" content="techtune">
		<meta name="description" content="">
		<title><?php echo translate('login'); ?></title>
		<link rel="shortcut icon" href="<?php echo base_url('assets/images/favicon.png'); ?>">
		

    <link href="https://fonts.googleapis.com/css?family=Roboto:300,400&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="<?php echo base_url('assets/login/fonts/icomoon/style.css'); ?>">

    <link rel="stylesheet" href="<?php echo base_url('assets/login/css/owl.carousel.min.css'); ?>">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo base_url('assets/login/css/bootstrap.min.css'); ?>">
    	
	<!-- Sweetalert js/css -->
	<link rel="stylesheet" href="<?php echo base_url('assets/vendor/sweetalert/sweetalert-custom.css'); ?>">
	<script src="<?php echo base_url('assets/vendor/sweetalert/sweetalert.min.js'); ?>"></script>
		
    <!-- Style -->
    <link rel="stylesheet" href="css/style.css">

	<!-- Web Fonts  -->
	<link rel="stylesheet" href="<?php echo base_url('assets/vendor/bootstrap/css/bootstrap.css'); ?>">
	<link rel="stylesheet" href="<?php echo base_url('assets/vendor/font-awesome/css/all.min.css'); ?>">
		
	<script type="text/javascript">
			var base_url = '<?php echo base_url() ?>';
	</script>
	
	 <style>
      .content {
        padding-top: 15vh;
        text-align: center; /* Center align content */
      }
      
      .col-md-6, .col-md-6.contents {
        text-align: left; /* Left align content within these columns */
      }

      /* Media Query for Mobile View */
      @media (max-width: 767px) {
        .content{
            padding-top: 5vh;
        }
      }
    </style>
	
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
	
  </head>
  <body>
  

  <div class="auth-main">
  <div class="content">
    <div class="container">
      <div class="row">
        <div class="col-md-6">
          <img src="<?php echo base_url('assets/login/images/undraw_remotely_2j6y.svg'); ?>" alt="Image" class="img-fluid">
        </div>
        <div class="col-md-6 contents">
          <div class="row justify-content-center">
            <div class="col-md-8">
              <div class="mb-4">
              <h3><?php echo html_escape($global_config['institute_name']); ?></h3>
              <p class="mb-4">Sign In</p>
            </div>
			

            <?php echo form_open($this->uri->uri_string()); ?>
              <div class="form-group <?php if (form_error('username')) echo 'has-error'; ?>">
                <label for="username">Username</label>
                 <div class="input-group input-group-icon">
					<span class="input-group-addon">
					<span class="icon">
						<i class="far fa-user"></i>
					</span>
					</span>
					<input type="text" class="form-control" name="username" id="username" value="<?php echo set_value('username'); ?>" placeholder="<?php echo translate('username'); ?>" />
				</div>
				<span class="error"><?php echo form_error('username'); ?></span>
              </div>

							
               <div class="form-group <?php if (form_error('password')) echo 'has-error'; ?>">
                <label for="password">Password</label>
				   <div class="input-group input-group-icon">
					<span class="input-group-addon">
						<span class="icon"><i class="fas fa-unlock-alt"></i></span>
					</span>
					<input type="password" class="form-control input-rounded" name="password" value="" id="password" placeholder="<?php echo translate('password'); ?>" />
					</div>
					<span class="error"><?php echo form_error('password'); ?></span>
              </div>
              
              <div class="d-flex mb-5 align-items-center">
               <label class="i-checks"><input type="checkbox" name="remember" id="remember"><i></i> <?php echo translate('remember me'); ?></label>
                  <div class="control__indicator"></div>
                </label>
                <span class="ml-auto"><a href="<?php echo base_url('authentication/forgot'); ?>" class="forgot-pass"><?php echo translate('forget password'); ?></a></span> 
              </div>


				<div class="form-group">
				<button type="submit" id="btn_submit" class="btn btn-block btn-primary">
					<?php echo translate('log in'); ?>	<i class="fa fa-sign-in"></i>
				</button>
			</div>
      
            <?php echo form_close(); ?>
			
            </div>
		              </div>
			                
        </div>
        
      </div>
    </div>
  </div>
</div>

  
    <script src="<?php echo base_url('assets/login/js/jquery-3.3.1.min.js'); ?>"></script>
    <script src="<?php echo base_url('assets/login/js/popper.min.js'); ?>"></script>
    <script src="<?php echo base_url('assets/login/js/bootstrap.min.js'); ?>"></script>
    <script src="<?php echo base_url('assets/login/css/js/main.js'); ?>"></script>

		<?php
		$alertclass = "";
		if($this->session->flashdata('alert-message-success')){
			$alertclass = "success";
		} else if ($this->session->flashdata('alert-message-error')){
			$alertclass = "error";
		} else if ($this->session->flashdata('alert-message-info')){
			$alertclass = "info";
		}
		if($alertclass != ''):
			$alert_message = $this->session->flashdata('alert-message-'. $alertclass);
		?>
			<script type="text/javascript">
				swal({
					toast: true,
					position: 'top-end',
					type: '<?php echo $alertclass; ?>',
					title: '<?php echo $alert_message; ?>',
					confirmButtonClass: 'btn btn-default',
					buttonsStyling: false,
					timer: 8000
				})
			</script>
		<?php endif; ?>
		
		  </body>
			  </html>

