#
# TABLE STRUCTURE FOR: accounts
#

DROP TABLE IF EXISTS `accounts`;

CREATE TABLE `accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` text NOT NULL,
  `balance` double(18,2) NOT NULL DEFAULT '0.00',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: ami_config
#

DROP TABLE IF EXISTS `ami_config`;

CREATE TABLE `ami_config` (
  `id` int(11) NOT NULL,
  `created_time` datetime DEFAULT NULL,
  `last_updated` datetime DEFAULT NULL,
  `host` varchar(200) DEFAULT NULL,
  `port` varchar(200) DEFAULT NULL,
  `username` varchar(200) DEFAULT NULL,
  `password` varchar(250) DEFAULT NULL,
  `status` varchar(200) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

INSERT INTO `ami_config` (`id`, `created_time`, `last_updated`, `host`, `port`, `username`, `password`, `status`) VALUES (1, '2023-11-05 00:00:00', '2023-11-29 10:20:09', '127.0.0.1', '5038', 'my_api', '977084d0c93e7ec7489a8ad6a3b04db4', 'Active');


#
# TABLE STRUCTURE FOR: appointment
#

DROP TABLE IF EXISTS `appointment`;

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` varchar(20) NOT NULL,
  `doctor_id` varchar(20) NOT NULL,
  `patient_id` varchar(20) NOT NULL,
  `consultation_fees` varchar(20) NOT NULL,
  `discount` decimal(18,2) NOT NULL,
  `schedule` varchar(50) NOT NULL,
  `remarks` text NOT NULL,
  `appointment_date` date NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: campaign_config
#

DROP TABLE IF EXISTS `campaign_config`;

CREATE TABLE `campaign_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `campaign_id` int(11) DEFAULT NULL,
  `date_time` datetime DEFAULT NULL,
  `l1_type` varchar(200) DEFAULT NULL,
  `l1_value` varchar(200) DEFAULT NULL,
  `layer_2_machine_key` varchar(250) DEFAULT NULL,
  `layer_2_machine_value` varchar(250) DEFAULT NULL,
  `layer_2_human_key` varchar(250) DEFAULT NULL,
  `layer_2_human_value` varchar(250) DEFAULT NULL,
  `advanced_stt_key` varchar(200) DEFAULT NULL,
  `advanced_stt_value` varchar(200) DEFAULT NULL,
  `press_0_key` varchar(200) DEFAULT NULL,
  `press_0_value` varchar(200) DEFAULT NULL,
  `press_1_key` varchar(200) DEFAULT NULL,
  `press_1_value` varchar(200) DEFAULT NULL,
  `press_2_key` varchar(200) DEFAULT NULL,
  `press_2_value` varchar(200) DEFAULT NULL,
  `press_3_key` varchar(200) DEFAULT NULL,
  `press_3_value` varchar(200) DEFAULT NULL,
  `press_4_key` varchar(200) DEFAULT NULL,
  `press_4_value` varchar(200) DEFAULT NULL,
  `press_5_key` varchar(200) DEFAULT NULL,
  `press_5_value` varchar(200) DEFAULT NULL,
  `press_6_key` varchar(200) DEFAULT NULL,
  `press_6_value` varchar(200) DEFAULT NULL,
  `press_7_key` varchar(200) DEFAULT NULL,
  `press_7_value` varchar(200) DEFAULT NULL,
  `press_8_key` varchar(200) DEFAULT NULL,
  `press_8_value` varchar(200) DEFAULT NULL,
  `press_9_key` varchar(200) DEFAULT NULL,
  `press_9_value` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=latin2;

INSERT INTO `campaign_config` (`id`, `campaign_id`, `date_time`, `l1_type`, `l1_value`, `layer_2_machine_key`, `layer_2_machine_value`, `layer_2_human_key`, `layer_2_human_value`, `advanced_stt_key`, `advanced_stt_value`, `press_0_key`, `press_0_value`, `press_1_key`, `press_1_value`, `press_2_key`, `press_2_value`, `press_3_key`, `press_3_value`, `press_4_key`, `press_4_value`, `press_5_key`, `press_5_value`, `press_6_key`, `press_6_value`, `press_7_key`, `press_7_value`, `press_8_key`, `press_8_value`, `press_9_key`, `press_9_value`) VALUES (75, 340, '2023-11-30 17:07:39', 'advanced_campaign', 'advanced_campaign', NULL, NULL, NULL, NULL, 'tts_play', 'This is a test Press Campaign Please press a number after the beep ', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '');
INSERT INTO `campaign_config` (`id`, `campaign_id`, `date_time`, `l1_type`, `l1_value`, `layer_2_machine_key`, `layer_2_machine_value`, `layer_2_human_key`, `layer_2_human_value`, `advanced_stt_key`, `advanced_stt_value`, `press_0_key`, `press_0_value`, `press_1_key`, `press_1_value`, `press_2_key`, `press_2_value`, `press_3_key`, `press_3_value`, `press_4_key`, `press_4_value`, `press_5_key`, `press_5_value`, `press_6_key`, `press_6_value`, `press_7_key`, `press_7_value`, `press_8_key`, `press_8_value`, `press_9_key`, `press_9_value`) VALUES (76, 341, '2023-11-30 22:20:03', 'advanced_campaign', 'advanced_campaign', NULL, NULL, NULL, NULL, 'tts_play', 'How was the Experience at the restaurant Press one if good', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '');
INSERT INTO `campaign_config` (`id`, `campaign_id`, `date_time`, `l1_type`, `l1_value`, `layer_2_machine_key`, `layer_2_machine_value`, `layer_2_human_key`, `layer_2_human_value`, `advanced_stt_key`, `advanced_stt_value`, `press_0_key`, `press_0_value`, `press_1_key`, `press_1_value`, `press_2_key`, `press_2_value`, `press_3_key`, `press_3_value`, `press_4_key`, `press_4_value`, `press_5_key`, `press_5_value`, `press_6_key`, `press_6_value`, `press_7_key`, `press_7_value`, `press_8_key`, `press_8_value`, `press_9_key`, `press_9_value`) VALUES (77, 342, '2023-12-01 20:36:01', 'advanced_campaign', 'advanced_campaign', NULL, NULL, NULL, NULL, 'tts_play', 'How was the Experience at our restaurant  Please tell me your opinion Your opinion is very important to us Thank you', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '');
INSERT INTO `campaign_config` (`id`, `campaign_id`, `date_time`, `l1_type`, `l1_value`, `layer_2_machine_key`, `layer_2_machine_value`, `layer_2_human_key`, `layer_2_human_value`, `advanced_stt_key`, `advanced_stt_value`, `press_0_key`, `press_0_value`, `press_1_key`, `press_1_value`, `press_2_key`, `press_2_value`, `press_3_key`, `press_3_value`, `press_4_key`, `press_4_value`, `press_5_key`, `press_5_value`, `press_6_key`, `press_6_value`, `press_7_key`, `press_7_value`, `press_8_key`, `press_8_value`, `press_9_key`, `press_9_value`) VALUES (78, 343, '2023-12-02 21:52:09', 'advanced_campaign', 'advanced_campaign', NULL, NULL, NULL, NULL, 'tts_play', 'How was the Experience at the restaurant Press one if good', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '');
INSERT INTO `campaign_config` (`id`, `campaign_id`, `date_time`, `l1_type`, `l1_value`, `layer_2_machine_key`, `layer_2_machine_value`, `layer_2_human_key`, `layer_2_human_value`, `advanced_stt_key`, `advanced_stt_value`, `press_0_key`, `press_0_value`, `press_1_key`, `press_1_value`, `press_2_key`, `press_2_value`, `press_3_key`, `press_3_value`, `press_4_key`, `press_4_value`, `press_5_key`, `press_5_value`, `press_6_key`, `press_6_value`, `press_7_key`, `press_7_value`, `press_8_key`, `press_8_value`, `press_9_key`, `press_9_value`) VALUES (79, 344, '2023-12-02 21:54:36', 'advanced_campaign', 'advanced_campaign', NULL, NULL, NULL, NULL, 'audio_play', 'audio-1698867002.wav', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '');
INSERT INTO `campaign_config` (`id`, `campaign_id`, `date_time`, `l1_type`, `l1_value`, `layer_2_machine_key`, `layer_2_machine_value`, `layer_2_human_key`, `layer_2_human_value`, `advanced_stt_key`, `advanced_stt_value`, `press_0_key`, `press_0_value`, `press_1_key`, `press_1_value`, `press_2_key`, `press_2_value`, `press_3_key`, `press_3_value`, `press_4_key`, `press_4_value`, `press_5_key`, `press_5_value`, `press_6_key`, `press_6_value`, `press_7_key`, `press_7_value`, `press_8_key`, `press_8_value`, `press_9_key`, `press_9_value`) VALUES (80, 345, '2023-12-02 21:59:03', 'advanced_campaign', 'advanced_campaign', NULL, NULL, NULL, NULL, 'tts_play', 'Welcome to Solution Hub Technologies This is a sample for Advanced Speech to Text campaign Please Note that your voice will be recorded after the beep Thank You', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '');
INSERT INTO `campaign_config` (`id`, `campaign_id`, `date_time`, `l1_type`, `l1_value`, `layer_2_machine_key`, `layer_2_machine_value`, `layer_2_human_key`, `layer_2_human_value`, `advanced_stt_key`, `advanced_stt_value`, `press_0_key`, `press_0_value`, `press_1_key`, `press_1_value`, `press_2_key`, `press_2_value`, `press_3_key`, `press_3_value`, `press_4_key`, `press_4_value`, `press_5_key`, `press_5_value`, `press_6_key`, `press_6_value`, `press_7_key`, `press_7_value`, `press_8_key`, `press_8_value`, `press_9_key`, `press_9_value`) VALUES (81, 346, '2023-12-02 22:46:29', 'advanced_campaign', 'advanced_campaign', NULL, NULL, NULL, NULL, 'tts_play', 'What do you thinks the chances are of Donald Trump winning the next election ', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '');
INSERT INTO `campaign_config` (`id`, `campaign_id`, `date_time`, `l1_type`, `l1_value`, `layer_2_machine_key`, `layer_2_machine_value`, `layer_2_human_key`, `layer_2_human_value`, `advanced_stt_key`, `advanced_stt_value`, `press_0_key`, `press_0_value`, `press_1_key`, `press_1_value`, `press_2_key`, `press_2_value`, `press_3_key`, `press_3_value`, `press_4_key`, `press_4_value`, `press_5_key`, `press_5_value`, `press_6_key`, `press_6_value`, `press_7_key`, `press_7_value`, `press_8_key`, `press_8_value`, `press_9_key`, `press_9_value`) VALUES (82, 347, '2023-12-03 23:41:55', 'advanced_campaign', 'advanced_campaign', NULL, NULL, NULL, NULL, 'tts_play', 'What is it like working with Everon Say your answer after the tone ', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '');
INSERT INTO `campaign_config` (`id`, `campaign_id`, `date_time`, `l1_type`, `l1_value`, `layer_2_machine_key`, `layer_2_machine_value`, `layer_2_human_key`, `layer_2_human_value`, `advanced_stt_key`, `advanced_stt_value`, `press_0_key`, `press_0_value`, `press_1_key`, `press_1_value`, `press_2_key`, `press_2_value`, `press_3_key`, `press_3_value`, `press_4_key`, `press_4_value`, `press_5_key`, `press_5_value`, `press_6_key`, `press_6_value`, `press_7_key`, `press_7_value`, `press_8_key`, `press_8_value`, `press_9_key`, `press_9_value`) VALUES (83, 348, '2023-12-06 16:42:52', 'tts_play', 'hello', NULL, NULL, NULL, NULL, NULL, NULL, 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '', 'not_applicable', '');


#
# TABLE STRUCTURE FOR: chats
#

DROP TABLE IF EXISTS `chats`;

CREATE TABLE `chats` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `members` varchar(50) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin2;

INSERT INTO `chats` (`id`, `members`, `created_at`, `updated_at`) VALUES ('3', '1,2', '2023-09-28 23:19:38', '2023-09-28 23:19:38');


#
# TABLE STRUCTURE FOR: chemical
#

DROP TABLE IF EXISTS `chemical`;

CREATE TABLE `chemical` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `code` varchar(50) NOT NULL,
  `category_id` int(11) NOT NULL,
  `purchase_unit_id` int(11) NOT NULL,
  `sales_unit_id` int(11) NOT NULL,
  `unit_ratio` varchar(20) DEFAULT '1',
  `purchase_price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `sales_price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `available_stock` varchar(11) NOT NULL DEFAULT '0',
  `photo` varchar(100) DEFAULT NULL,
  `remarks` text NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: chemical_assigned
#

DROP TABLE IF EXISTS `chemical_assigned`;

CREATE TABLE `chemical_assigned` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `chemical_id` varchar(20) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: chemical_category
#

DROP TABLE IF EXISTS `chemical_category`;

CREATE TABLE `chemical_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: chemical_stock
#

DROP TABLE IF EXISTS `chemical_stock`;

CREATE TABLE `chemical_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inovice_no` varchar(25) NOT NULL,
  `chemical_id` varchar(20) NOT NULL,
  `date` date DEFAULT NULL,
  `stock_quantity` varchar(20) NOT NULL,
  `remarks` varchar(255) NOT NULL,
  `stock_by` varchar(20) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: chemical_unit
#

DROP TABLE IF EXISTS `chemical_unit`;

CREATE TABLE `chemical_unit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: ci_sessions
#

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(40) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `data` blob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('00uelp80h28ha66l0hd07glplv5rt8hr', '103.180.244.161', 1701847576, '__ci_last_regenerate|i:1701847576;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0ntoehd79vh0aas764u5m8f2c72652q2', '103.180.244.161', 1701855660, '__ci_last_regenerate|i:1701855660;redirect_url|s:41:\"http://159.89.92.180/contact_center/voice\";name|s:9:\"customer1\";uniqueid|s:7:\"6ff50ae\";logger_photo|s:11:\"defualt.png\";loggedin_id|s:1:\"9\";loggedin_role_id|s:1:\"3\";loggedin_userid|s:1:\"8\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('15rakn0qcs3umfnslma2o3649uu7rmkj', '103.180.244.161', 1701846041, '__ci_last_regenerate|i:1701846041;redirect_url|s:41:\"http://159.89.92.180/contact_center/voice\";name|s:6:\"100010\";uniqueid|s:7:\"2c2e389\";logger_photo|s:11:\"defualt.png\";loggedin_id|s:2:\"11\";loggedin_role_id|s:1:\"3\";loggedin_userid|s:2:\"10\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1mpad4d5rhvs0ifcn8asf77j00251869', '103.180.244.161', 1701859389, '__ci_last_regenerate|i:1701859389;redirect_url|s:41:\"http://159.89.92.180/contact_center/voice\";name|s:9:\"customer1\";uniqueid|s:7:\"6ff50ae\";logger_photo|s:11:\"defualt.png\";loggedin_id|s:1:\"9\";loggedin_role_id|s:1:\"3\";loggedin_userid|s:1:\"8\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('22n7he9mcr3i79t3r8c9pqjtm9na65kh', '103.180.244.161', 1701852984, '__ci_last_regenerate|i:1701852984;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2gmq38h26kf1fim1m0fj44jrv4p1o3ir', '103.180.244.161', 1701859016, '__ci_last_regenerate|i:1701859016;redirect_url|s:41:\"http://159.89.92.180/contact_center/voice\";name|s:9:\"customer1\";uniqueid|s:7:\"6ff50ae\";logger_photo|s:11:\"defualt.png\";loggedin_id|s:1:\"9\";loggedin_role_id|s:1:\"3\";loggedin_userid|s:1:\"8\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2igpfe3pdvvaebd5jbdjh124hd09pm1q', '103.180.244.161', 1701853971, '__ci_last_regenerate|i:1701853971;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('396ckk0r46ftnnjub26ik3p2uur6j7dh', '103.180.244.161', 1701847019, '__ci_last_regenerate|i:1701846946;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:9:\"customer1\";uniqueid|s:7:\"6ff50ae\";logger_photo|s:11:\"defualt.png\";loggedin_id|s:1:\"9\";loggedin_role_id|s:1:\"3\";loggedin_userid|s:1:\"8\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3telr004ae2oct99ammnjh1cm8s0lil1', '103.180.244.161', 1701863347, '__ci_last_regenerate|i:1701863347;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('40k7b964fi7itqae34neb60c1johc5f3', '103.180.244.161', 1701859547, '__ci_last_regenerate|i:1701859547;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('41u03ihsog8mi1bdvkta5str3tiuu9dg', '103.180.244.161', 1701939289, '__ci_last_regenerate|i:1701939288;redirect_url|s:51:\"http://159.89.92.180/contact_center/employee/view/2\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('439n4hrnrs3fi29jq8vlvdhn4lavgk57', '103.180.244.161', 1701854720, '__ci_last_regenerate|i:1701854719;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4ki3nn6uie8uh9dn4q1pcgonorpboshi', '103.180.244.161', 1701849491, '__ci_last_regenerate|i:1701849491;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4llqsb9i2hmgjn2g27tskk4ikl8mg3fu', '103.180.244.161', 1701860484, '__ci_last_regenerate|i:1701860484;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7004dtathpfq2b8pfmioms94fpls3jv9', '203.76.223.7', 1701845450, '__ci_last_regenerate|i:1701845443;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7is7cm6dofqs9evqib2fht3oiv61fhqt', '103.180.244.161', 1701863612, '__ci_last_regenerate|i:1701863347;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7ter22m85mhsg2f53ii07o51n95dbmtp', '103.180.244.161', 1701848245, '__ci_last_regenerate|i:1701848245;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8e6507sqcmlg46v4p8upe2pcvit18n10', '103.180.244.161', 1701852331, '__ci_last_regenerate|i:1701852331;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8shqqs0qg885hu4m9ffij6c0gli39euo', '103.180.244.161', 1701846922, '__ci_last_regenerate|i:1701846922;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('999u1btpjc9c7et2mtv7jp93em8nns58', '103.180.244.161', 1701849852, '__ci_last_regenerate|i:1701849852;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9hm4rtha6o96pr7t959mc1sj9lqmj1nu', '103.180.244.161', 1701929981, '__ci_last_regenerate|i:1701929981;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ahvog7q1ti6pa85jo5i2rp4kfk0asn9d', '103.180.244.161', 1701854296, '__ci_last_regenerate|i:1701854296;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ankk5ls3rf1eap85gqeun2sj0a28nbs0', '103.180.244.161', 1701857934, '__ci_last_regenerate|i:1701857934;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c1k0kcqi0vt7dto19vfjiu65jpa3nmsh', '103.180.244.161', 1701857568, '__ci_last_regenerate|i:1701857568;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cip30286p5oqbvvhqq68upasq0qj7c1b', '103.180.244.161', 1701860043, '__ci_last_regenerate|i:1701860043;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d0hfldr5gc4g5gj9ao3uiqqc2cn57qg9', '103.180.244.161', 1701849120, '__ci_last_regenerate|i:1701849120;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d380haleo3g6bbd3as6mgieua85blbir', '103.180.244.161', 1701845685, '__ci_last_regenerate|i:1701845685;redirect_url|s:41:\"http://159.89.92.180/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f53p02le2mds8e1kricdhf300tdl8dtg', '103.180.244.161', 1701846617, '__ci_last_regenerate|i:1701846617;redirect_url|s:41:\"http://159.89.92.180/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f7hq0a9asl2bc009u2cvhajqjjo7a2m9', '103.180.244.161', 1701846862, '__ci_last_regenerate|i:1701846862;redirect_url|s:41:\"http://159.89.92.180/contact_center/voice\";name|s:6:\"100010\";uniqueid|s:7:\"2c2e389\";logger_photo|s:11:\"defualt.png\";loggedin_id|s:2:\"11\";loggedin_role_id|s:1:\"3\";loggedin_userid|s:2:\"10\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f7opq112fnie18u6eukf557qg666rgh2', '103.180.244.161', 1701853639, '__ci_last_regenerate|i:1701853639;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h8j6slksdhquqhrjm2u3m1vni3f5ri38', '103.180.244.161', 1701856141, '__ci_last_regenerate|i:1701856141;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h9dp0lo2ltslgade0t728v6lj92hduk1', '103.180.244.161', 1701855415, '__ci_last_regenerate|i:1701855415;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('i1o3hgo89g20ktpl3md43reh96l780fr', '103.180.244.161', 1701846451, '__ci_last_regenerate|i:1701846451;redirect_url|s:41:\"http://159.89.92.180/contact_center/voice\";name|s:6:\"100010\";uniqueid|s:7:\"2c2e389\";logger_photo|s:11:\"defualt.png\";loggedin_id|s:2:\"11\";loggedin_role_id|s:1:\"3\";loggedin_userid|s:2:\"10\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('in56vjr5d42hqu9j7597s1cpht3cm9er', '103.180.244.161', 1701858812, '__ci_last_regenerate|i:1701858812;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jbtui05pubo0kv9rdo41shdqpl5ss1nu', '103.180.244.161', 1701845988, '__ci_last_regenerate|i:1701845988;redirect_url|s:41:\"http://159.89.92.180/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jmeg5h6b28006tb6edl61mdhquc2n09b', '103.180.244.161', 1702182393, '__ci_last_regenerate|i:1702182124;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k8j161f33pj3h13aaslj6348grbmqlth', '103.180.244.161', 1701859200, '__ci_last_regenerate|i:1701859200;redirect_url|s:41:\"http://159.89.92.180/contact_center/voice\";name|s:6:\"100010\";uniqueid|s:7:\"2c2e389\";logger_photo|s:11:\"defualt.png\";loggedin_id|s:2:\"11\";loggedin_role_id|s:1:\"3\";loggedin_userid|s:2:\"10\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kk97pdo4h9gba3ol0v5jnq0hi1vdpmuf', '103.180.244.161', 1701929984, '__ci_last_regenerate|i:1701929981;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('krjbg9nngefmgqrk88tqe8g35qut2e5n', '103.180.244.161', 1701859389, '__ci_last_regenerate|i:1701859389;redirect_url|s:41:\"http://159.89.92.180/contact_center/voice\";name|s:9:\"customer1\";uniqueid|s:7:\"6ff50ae\";logger_photo|s:11:\"defualt.png\";loggedin_id|s:1:\"9\";loggedin_role_id|s:1:\"3\";loggedin_userid|s:1:\"8\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kv6f02s860gv9bii1r7jfvjd1oo29ae0', '103.180.244.161', 1702182402, '__ci_last_regenerate|i:1702182179;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l4g6shl0ipb2vb5pu48cvvq1svs8ak33', '103.180.244.161', 1701856538, '__ci_last_regenerate|i:1701856538;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l826aekf42s76dktbrqu4ehl5qph0l14', '103.180.244.161', 1701846862, '__ci_last_regenerate|i:1701846862;redirect_url|s:41:\"http://159.89.92.180/contact_center/voice\";name|s:6:\"100010\";uniqueid|s:7:\"2c2e389\";logger_photo|s:11:\"defualt.png\";loggedin_id|s:2:\"11\";loggedin_role_id|s:1:\"3\";loggedin_userid|s:2:\"10\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('matjrpqhdpddlpjc1rbru364n85bhdq6', '103.180.244.161', 1701848803, '__ci_last_regenerate|i:1701848803;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('n060t0990id4d87rdgtcspo7sj372nmh', '103.180.244.161', 1701855101, '__ci_last_regenerate|i:1701855101;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:28:\"New Trunk Added Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('opbir4n7ttuerc9u31s3lhrc5e84jtjp', '103.180.244.161', 1701853286, '__ci_last_regenerate|i:1701853286;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pd6irjknsbgtjlobil383mp949jjh60g', '103.180.244.161', 1702182179, '__ci_last_regenerate|i:1702182179;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('q09sbspbhtubjfhr4jiah4ai0v2kfq4n', '103.180.244.161', 1701860484, '__ci_last_regenerate|i:1701860484;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qqbcfh8h23smpd27feei6b6t4fqf28fj', '103.180.244.161', 1701858382, '__ci_last_regenerate|i:1701858382;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('r11a885ast4gs0fg65b6i5tkhcb3euag', '103.180.244.161', 1701855717, '__ci_last_regenerate|i:1701855717;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('r3rf54h89evlnvs5sjd8stjc021o5p44', '172.59.8.69', 1701845483, '__ci_last_regenerate|i:1701845480;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sbs043av655m34omdr7ckhs9b4qf65vj', '103.180.244.161', 1701846451, '__ci_last_regenerate|i:1701846451;redirect_url|s:41:\"http://159.89.92.180/contact_center/voice\";name|s:6:\"100010\";uniqueid|s:7:\"2c2e389\";logger_photo|s:11:\"defualt.png\";loggedin_id|s:2:\"11\";loggedin_role_id|s:1:\"3\";loggedin_userid|s:2:\"10\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sg4figtj40g4hajbp36m1ccbpf1cvst8', '103.180.244.161', 1701847265, '__ci_last_regenerate|i:1701847265;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sngu6tn85brkrde0ucmem4i0cb261u5t', '103.180.244.161', 1701850187, '__ci_last_regenerate|i:1701850187;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('snug9l24vu1mt6nflllvpsoknpne7i2q', '103.180.244.161', 1701847916, '__ci_last_regenerate|i:1701847916;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t4euu0u61uur3skgt7vhl8rrt0c7iaq6', '103.180.244.161', 1701857218, '__ci_last_regenerate|i:1701857218;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tb7hu6d8kjnn5agevhs5bo9ve3bt3i65', '103.180.244.161', 1701846013, '__ci_last_regenerate|i:1701845988;redirect_url|s:41:\"http://159.89.92.180/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tdmcda88fce1r0m4ifs7d1e02rf8egrh', '103.180.244.161', 1701846833, '__ci_last_regenerate|i:1701846617;redirect_url|s:41:\"http://159.89.92.180/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tjj5190l8qff3dgckhq0c4bprbkii27r', '103.180.244.161', 1701858667, '__ci_last_regenerate|i:1701858667;redirect_url|s:41:\"http://159.89.92.180/contact_center/voice\";name|s:9:\"customer1\";uniqueid|s:7:\"6ff50ae\";logger_photo|s:11:\"defualt.png\";loggedin_id|s:1:\"9\";loggedin_role_id|s:1:\"3\";loggedin_userid|s:1:\"8\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u8af26rn9ecqerocnl5gq4b7g38i7fov', '103.180.244.161', 1701933356, '__ci_last_regenerate|i:1701933345;redirect_url|s:41:\"http://159.89.92.180/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vl9s33qgg3tsg55fgr85ilm01o7j0krf', '103.180.244.161', 1701852649, '__ci_last_regenerate|i:1701852649;redirect_url|s:45:\"http://159.89.92.180/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"0fa96a4e26f9541d9b10841ecf59f5ba.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');


#
# TABLE STRUCTURE FOR: contact_assign
#

DROP TABLE IF EXISTS `contact_assign`;

CREATE TABLE `contact_assign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_date` datetime DEFAULT NULL,
  `contact_group` varchar(100) DEFAULT NULL,
  `assigned_to` longtext,
  `assigned_customers` longtext,
  `status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO `contact_assign` (`id`, `created_date`, `contact_group`, `assigned_to`, `assigned_customers`, `status`) VALUES (1, '2023-11-29 17:29:58', 'test_group', '{5,9,13}', '{7,8,10}', 'Active');
INSERT INTO `contact_assign` (`id`, `created_date`, `contact_group`, `assigned_to`, `assigned_customers`, `status`) VALUES (4, '2023-11-29 17:34:05', 'New CSV', '{5}', NULL, 'Active');


#
# TABLE STRUCTURE FOR: contact_list
#

DROP TABLE IF EXISTS `contact_list`;

CREATE TABLE `contact_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `name` varchar(20) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `email` varchar(20) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `group_name` varchar(20) DEFAULT NULL,
  `assigned_to` varchar(20) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin2;

INSERT INTO `contact_list` (`id`, `datetime`, `last_modified`, `name`, `phone`, `email`, `address`, `group_name`, `assigned_to`, `status`) VALUES (1, '2023-11-29 17:29:58', NULL, 'Everon', '12076927722', 'tanvir@sohub.com.bd', 'USA', 'test_group', '1', NULL);
INSERT INTO `contact_list` (`id`, `datetime`, `last_modified`, `name`, `phone`, `email`, `address`, `group_name`, `assigned_to`, `status`) VALUES (2, '2023-11-29 17:29:58', NULL, 'Neil', '18768426621', 'muyed@sohub.com.bd', 'USA', 'test_group', '1', NULL);
INSERT INTO `contact_list` (`id`, `datetime`, `last_modified`, `name`, `phone`, `email`, `address`, `group_name`, `assigned_to`, `status`) VALUES (7, '2023-11-29 17:34:05', NULL, 'Tanvir Islam', '18457101010', 'tanvir@sohub.com.bd', 'Mohammadpur', 'New CSV', '5', NULL);
INSERT INTO `contact_list` (`id`, `datetime`, `last_modified`, `name`, `phone`, `email`, `address`, `group_name`, `assigned_to`, `status`) VALUES (8, '2023-11-29 17:34:05', NULL, 'Muyed Moktadir ', '18457999009', 'muyed@sohub.com.bd', 'Mohammadpur', 'New CSV', '5', NULL);
INSERT INTO `contact_list` (`id`, `datetime`, `last_modified`, `name`, `phone`, `email`, `address`, `group_name`, `assigned_to`, `status`) VALUES (9, '2023-12-06 16:41:42', NULL, 'Sakib Shahriar', '18457999009', 'sakibshahriar02@gmai', 'Mohammadpur', 'New CSV', '10', NULL);


#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(200) DEFAULT NULL,
  `email_protocol` varchar(10) NOT NULL,
  `smtp_host` varchar(25) NOT NULL,
  `smtp_user` varchar(25) DEFAULT NULL,
  `smtp_pass` text NOT NULL,
  `smtp_port` varchar(100) NOT NULL,
  `smtp_encryption` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin2;

INSERT INTO `email_config` (`id`, `email`, `email_protocol`, `smtp_host`, `smtp_user`, `smtp_pass`, `smtp_port`, `smtp_encryption`) VALUES (1, 'example@gmail.com', 'sendmail', 'smtp.gmail.com', 'example@gmail.com', '1234', '25', 'ssl');


#
# TABLE STRUCTURE FOR: email_templates
#

DROP TABLE IF EXISTS `email_templates`;

CREATE TABLE `email_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email_type` varchar(200) NOT NULL,
  `subject` varchar(250) NOT NULL,
  `template_body` longtext NOT NULL,
  `tags` longtext NOT NULL,
  `notified` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin2;

INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (1, 'account_registered', 'Account Registered', '', '{institute_name}, {name}, {username}, {password}, {user_role}, {login_url}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (2, 'forgot_password', 'Forgot Password', '', '{institute_name}, {name}, {username}, {reset_url}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (5, 'payslip_generated', 'Payslip generated', '', '{institute_name}, {name}, {month_year}, {payslip_no}, {payslip_url}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (6, 'absent', 'Absent Notice', '', '{institute_name}, {name}, {date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (7, 'leave_approve', 'Your leave request has been approved', '', '{institute_name}, {name}, {admin_comments}, {start_date}, {end_date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (8, 'leave_reject', 'Your leave request has been reject', '', '{institute_name}, {name}, {admin_comments}, {start_date}, {end_date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (9, 'appointment_confirmation', 'Appointment Confirmation', '', '{institute_name}, {patient_name}, {doctor_name}, {consultation_fees}, {schedule_time}, {appointment_date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (10, 'appointment_canceled', 'Appointment Canceled', '', '{institute_name}, {patient_name}, {doctor_name}, {consultation_fees}, {schedule_time}, {appointment_date}', 0);


#
# TABLE STRUCTURE FOR: front_cms_about
#

DROP TABLE IF EXISTS `front_cms_about`;

CREATE TABLE `front_cms_about` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `page_title` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `about_image` varchar(255) NOT NULL,
  `elements` mediumtext NOT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin2;

INSERT INTO `front_cms_about` (`id`, `title`, `subtitle`, `page_title`, `content`, `banner_image`, `about_image`, `elements`, `meta_description`, `meta_keyword`) VALUES (1, 'Welcome to Hospitals', 'Best Medical &amp; Healthcare Needs to Our Patients', 'About Us', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut volutpat rutrum eros amet sollicitudin interdum. Suspendisse pulvinar, velit nec pharetra interdum, ante tellus ornare mi, et mollis tellus neque vitae elit. Mauris adipiscing mauris fringilla turpis interdum sed pulvinar nisi malesuada. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>\r\n\r\n<p>Donec sed odio dui. Nulla vitae elit libero, a pharetra augue. Nullam id dolor id nibh ultricies vehicula ut id elit. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Duis mollis, est non commodo luctus, nisi erat porttitor ligula. Mauris sit amet neque nec nunc gravida.</p>\r\n\r\n<div class=\"row\">\r\n<div class=\"col-sm-6 col-12\">\r\n<ul class=\"list-unstyled list-style-3\">\r\n	<li><a href=\"#\">Cardiothoracic Surgery</a></li>\r\n	<li><a href=\"#\">Cardiovascular Diseases</a></li>\r\n	<li><a href=\"#\">Ophthalmology</a></li>\r\n	<li><a href=\"#\">Dermitology</a></li>\r\n</ul>\r\n</div>\r\n\r\n<div class=\"col-sm-6 col-12\">\r\n<ul class=\"list-unstyled list-style-3\">\r\n	<li><a href=\"#\">Cardiothoracic Surgery</a></li>\r\n	<li><a href=\"#\">Cardiovascular Diseases</a></li>\r\n	<li><a href=\"#\">Ophthalmology</a></li>\r\n</ul>\r\n</div>\r\n</div>', 'about.jpg', 'about.jpg', '{\"cta_title\":\"Get in touch to join our community\",\"button_text\":\"Contact Our Office\",\"button_url\":\"contact\"}', '', '');


#
# TABLE STRUCTURE FOR: front_cms_appointment
#

DROP TABLE IF EXISTS `front_cms_appointment`;

CREATE TABLE `front_cms_appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin2;

INSERT INTO `front_cms_appointment` (`id`, `title`, `description`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'Make An Appoinment', '<p><span style=\"color: rgb(156, 156, 156); font-family: Poppins, sans-serif; font-size: 14px; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;\">Lorem ipsum dolor sit amet, eum illum dolore concludaturque ex, ius latine adipisci no. Pro at nullam laboramus definitiones. Mandamusconceptam omittantur cu cum. Brute appetere it scriptorem ei eam, ne vim velit novum nominati. Causae volutpat percipitur at sed ne.</span></p>\r\n', 'Appointment', 'appointment.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_contact
#

DROP TABLE IF EXISTS `front_cms_contact`;

CREATE TABLE `front_cms_contact` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `box_title` varchar(255) DEFAULT NULL,
  `box_description` varchar(500) DEFAULT NULL,
  `box_image` varchar(255) DEFAULT NULL,
  `form_title` varchar(355) DEFAULT NULL,
  `address` varchar(355) DEFAULT NULL,
  `phone` varchar(355) DEFAULT NULL,
  `email` varchar(355) DEFAULT NULL,
  `submit_text` varchar(355) NOT NULL,
  `map_iframe` text,
  `page_title` varchar(255) NOT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin2;

INSERT INTO `front_cms_contact` (`id`, `box_title`, `box_description`, `box_image`, `form_title`, `address`, `phone`, `email`, `submit_text`, `map_iframe`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'WE\'D LOVE TO HEAR FROM YOU', 'Fusce convallis diam vitae velit tempus rutrum. Donec nisl nisl, vulputate eu sapien sed, adipiscing vehicula massa. Mauris eget commodo neque, id molestie enim.', 'contact-info-box.png', 'Get in touch by filling the form below', '4896  Romrog Way, LOS ANGELES,\r\nCalifornia', '954-648-1802, \r\n963-612-1782', 'info@example.com\r\nsupport@example.com', 'Send', '<iframe width=\"100%\" height=\"350\" id=\"gmap_canvas\" src=\"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3313.3833161665298!2d-118.03745848530627!3d33.85401093559897!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x80dd2c6c97f8f3ed%3A0x47b1bde165dcc056!2sOak+Dr%2C+La+Palma%2C+CA+90623%2C+USA!5e0!3m2!1sen!2sbd!4v1544238752504\" frameborder=\"0\" scrolling=\"no\" marginheight=\"0\" marginwidth=\"0\"></iframe>', 'Contact Us', 'contact.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_doctor_bio
#

DROP TABLE IF EXISTS `front_cms_doctor_bio`;

CREATE TABLE `front_cms_doctor_bio` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `doctor_id` varchar(20) NOT NULL,
  `biography` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: front_cms_doctors
#

DROP TABLE IF EXISTS `front_cms_doctors`;

CREATE TABLE `front_cms_doctors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin2;

INSERT INTO `front_cms_doctors` (`id`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'Doctors', 'doctors.jpg', '', '');
INSERT INTO `front_cms_doctors` (`id`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (2, 'Doctor Profile', 'doctor_profile.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_faq
#

DROP TABLE IF EXISTS `front_cms_faq`;

CREATE TABLE `front_cms_faq` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin2;

INSERT INTO `front_cms_faq` (`id`, `title`, `description`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'Frequently Asked Questions', '<p>Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident.</p>\r\n\r\n<p>Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven&#39;t heard of them accusamus labore sustainable VHS.</p>', 'Faq', 'faq.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_faq_list
#

DROP TABLE IF EXISTS `front_cms_faq_list`;

CREATE TABLE `front_cms_faq_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin2;

INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (1, 'Any Information you provide on applications for disability, life or accidental insurance ?', '<p>\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.\r\n</p>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet, consectetur adipisicing elit.</li>\r\n<li>Sed do eiusmod tempor incididunt ut labore et dolore magna aliq.</li>\r\n<li>Ut enim ad minim veniam, quis nostrud exercitation ullamco quat. It is a long established fact.</li>\r\n<li>That a reader will be distracted by the readable content of a page when looking at its layout.</li>\r\n<li>Lorem ipsum dolor sit amet, consectetur adipisicing elit.</li>\r\n<li>Eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.</li>\r\n<li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n<li>Readable content of a page when looking at its layout.</li>\r\n<li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n<li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n</ul>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (2, 'Readable content of a page when looking at its layout ?', '<p>\r\n                                Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven\'t heard of them accusamus labore sustainable VHS.\r\n                            </p>\r\n                            <ol>\r\n                                <li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n                                <li>Readable content of a page when looking at its layout.</li>\r\n                                <li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n                                <li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n                            </ol>\r\n                            <p>\r\n                                Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\r\n                            </p>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (3, 'Opposed to using \'Content here, content here\', making it look like readable English ?', '<p>\r\n                                Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven\'t heard of them accusamus labore sustainable VHS.\r\n                            </p>\r\n                            <ol>\r\n                                <li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n                                <li>Readable content of a page when looking at its layout.</li>\r\n                                <li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n                                <li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n                            </ol>\r\n                            <p>\r\n                                Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\r\n                            </p>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (4, 'Readable content of a page when looking at its layout ?', '<p>\r\n                                Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven\'t heard of them accusamus labore sustainable VHS.\r\n                            </p>\r\n                            <ol>\r\n                                <li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n                                <li>Readable content of a page when looking at its layout.</li>\r\n                                <li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n                                <li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n                            </ol>\r\n                            <p>\r\n                                Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\r\n                            </p>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (5, 'What types of documents are required to travel?', '<p><strong>Lorem ipsum</strong> dolor sit amet, an labores explicari qui, eu nostrum copiosae argumentum has. Latine propriae quo no, unum ridens expetenda id sit, at usu eius eligendi singulis. Sea ocurreret principes ne. At nonumy aperiri pri, nam quodsi copiosae intellegebat et, ex deserunt euripidis usu. Per ad ullum lobortis. Duo volutpat imperdiet ut, postea salutatus imperdiet ut per, ad utinam debitis invenire has.</p>\r\n\r\n<ol>\r\n	<li>labores explicari qui</li>\r\n	<li>labores explicari qui</li>\r\n	<li>labores explicari quilabores explicari qui</li>\r\n	<li>labores explicari qui</li>\r\n</ol>');


#
# TABLE STRUCTURE FOR: front_cms_home
#

DROP TABLE IF EXISTS `front_cms_home`;

CREATE TABLE `front_cms_home` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `item_type` varchar(20) NOT NULL,
  `description` text NOT NULL,
  `elements` mediumtext NOT NULL,
  `active` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin2;

INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (1, 'We Offer Fast &amp; Reliable', 'Medical &amp; Healthcare Needs', 'wellcome', 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using content.\r\n\r\nMaking it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).', '{\"image\":\"wellcome.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (2, 'Experience Doctor Team', NULL, 'doctors', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident.', '{\"doctor_start\":\"1\",\"image\":\"featured-parallax.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (3, 'Our Best Medical Services', NULL, 'services', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.', '', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (4, 'Online Hassle Free Appointment Booking', 'Medical Services', 'cta', '', '{\"mobile_no\":\"+2484-398-8987\",\"button_text\":\"Book your Appointment\",\"button_url\":\"appointment\",\"image\":\"appointment-booking-img.png\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (5, 'Best <span>Digital</span> Experience', NULL, 'slider', 'Lorem Ipsum is simply dummy text printer took a galley of type and scrambled it to make a type specimen book.', '{\"position\":\"c-left\",\"button_text1\":\"View Services\",\"button_url1\":\"#\",\"button_text2\":\"Learn More\",\"button_url2\":\"#\",\"image\":\"home-slider-1578743357.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (6, 'Main Heading <span>Some Caption</span> Here', NULL, 'slider', 'Lorem Ipsum is simply dummy text printer took a galley of type and scrambled it to make a type specimen book.', '{\"position\":\"c-center\",\"button_text1\":\"Read More\",\"button_url1\":\"#\",\"button_text2\":\"Get Started\",\"button_url2\":\"#\",\"image\":\"home-slider-1578743366.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (7, 'Here creative & professional <span>PHP</span> template', NULL, 'slider', 'Lorem Ipsum is simply dummy text printer took a galley of type and scrambled it to make a type specimen book.', '{\"position\":\"c-right\",\"button_text1\":\"Read More\",\"button_url1\":\"#\",\"button_text2\":\"Contact us\",\"button_url2\":\"contact\",\"image\":\"home-slider-1578743373.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (8, 'Qualified Doctors', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"fas fa-user-md\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (9, 'Regular Checkup', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"fas fa-stethoscope\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (10, 'Neurosurgeon', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"fas fa-vial\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (11, '24 Hours  Service', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"far fa-clock\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (12, 'Our Happy Patients Opinion', NULL, 'testimonial', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.', '', 0);


#
# TABLE STRUCTURE FOR: front_cms_home_seo
#

DROP TABLE IF EXISTS `front_cms_home_seo`;

CREATE TABLE `front_cms_home_seo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) NOT NULL,
  `meta_keyword` text NOT NULL,
  `meta_description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin2;

INSERT INTO `front_cms_home_seo` (`id`, `page_title`, `meta_keyword`, `meta_description`) VALUES (1, 'Home', '', '');


#
# TABLE STRUCTURE FOR: front_cms_menu
#

DROP TABLE IF EXISTS `front_cms_menu`;

CREATE TABLE `front_cms_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `alias` varchar(100) NOT NULL,
  `ordering` int(11) NOT NULL,
  `parent_id` int(11) DEFAULT '0',
  `open_new_tab` int(11) NOT NULL DEFAULT '0',
  `ext_url` int(11) NOT NULL DEFAULT '0',
  `ext_url_address` text,
  `publish` int(11) NOT NULL,
  `system` varchar(10) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin2;

INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (1, 'Home', 'index', 1, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (2, 'Appointment', 'appointment', 3, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (3, 'Doctors', 'doctors', 2, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (4, 'About Us', 'about', 4, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (5, 'FAQ', 'faq', 5, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (6, 'Contact Us', 'contact', 6, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');


#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `menu_id` int(11) NOT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: front_cms_services
#

DROP TABLE IF EXISTS `front_cms_services`;

CREATE TABLE `front_cms_services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `parallax_image` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin2;

INSERT INTO `front_cms_services` (`id`, `title`, `subtitle`, `parallax_image`) VALUES (1, 'Get Well Soon', 'Our Hosptial <span>Services</span>', 'service_parallax.jpg');


#
# TABLE STRUCTURE FOR: front_cms_services_list
#

DROP TABLE IF EXISTS `front_cms_services_list`;

CREATE TABLE `front_cms_services_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `icon` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin2;

INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (1, 'First Aid', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text.', 'fas fa-medal');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (2, 'Dental Care', 'Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover.', 'fas fa-heartbeat');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (3, '24x7 Ambulance', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model.', 'fas fa-ambulance');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (4, 'Qualified Doctors', 'Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will.', 'fas fa-capsules');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (5, 'Medical Pharmacy', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover.', 'fas fa-stethoscope');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (6, 'Pulmonary', 'Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a for \'lorem ipsum\' will uncover.', 'fas fa-medkit');


#
# TABLE STRUCTURE FOR: front_cms_setting
#

DROP TABLE IF EXISTS `front_cms_setting`;

CREATE TABLE `front_cms_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `application_title` varchar(255) NOT NULL,
  `captcha_status` varchar(20) NOT NULL,
  `recaptcha_site_key` varchar(255) NOT NULL,
  `recaptcha_secret_key` varchar(255) NOT NULL,
  `address` varchar(350) NOT NULL,
  `mobile_no` varchar(60) NOT NULL,
  `fax` varchar(60) NOT NULL,
  `receive_contact_email` varchar(255) NOT NULL,
  `email` varchar(60) NOT NULL,
  `footer_text` varchar(255) NOT NULL,
  `fav_icon` varchar(255) NOT NULL,
  `logo` varchar(255) NOT NULL,
  `working_hours` varchar(300) NOT NULL,
  `facebook_url` varchar(100) NOT NULL,
  `twitter_url` varchar(100) NOT NULL,
  `youtube_url` varchar(100) NOT NULL,
  `google_plus` varchar(100) NOT NULL,
  `linkedin_url` varchar(100) NOT NULL,
  `pinterest_url` varchar(100) NOT NULL,
  `instagram_url` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin2;

INSERT INTO `front_cms_setting` (`id`, `application_title`, `captcha_status`, `recaptcha_site_key`, `recaptcha_secret_key`, `address`, `mobile_no`, `fax`, `receive_contact_email`, `email`, `footer_text`, `fav_icon`, `logo`, `working_hours`, `facebook_url`, `twitter_url`, `youtube_url`, `google_plus`, `linkedin_url`, `pinterest_url`, `instagram_url`) VALUES (1, 'Ramom - Diagnostic Management System With CMS', 'disable', '', '', '', '+1-954-648-1802', '001 - 785 987 1234', 'info@example.com', 'info@demo.com', '? 2019 <span>Ramom</span>. All Rights Reserved.', 'fav_icon.ico', 'logo.png', '<span>Hours : </span>  Mon To Fri - 9:00 - 20:00,  Sunday Closed', 'https://facebook.com', 'https://twitter.com', 'https://youtube.com', 'https://google.com', 'https://linkedin.com', 'https://pinterest.com', 'https://instagram.com');


#
# TABLE STRUCTURE FOR: front_cms_testimonial
#

DROP TABLE IF EXISTS `front_cms_testimonial`;

CREATE TABLE `front_cms_testimonial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_name` varchar(255) NOT NULL,
  `surname` varchar(355) NOT NULL,
  `image` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `rank` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin2;

INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (1, 'Gartrell Wright', 'Los Angeles', 'defualt.png', 'Intexure have done an excellent job presenting the analysis & insights. I am confident in saying  have helped encounter  is to be welcomed and every pain avoided?.', 1, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (2, 'Clifton Hyde', 'Newyork City', 'defualt.png', '?Owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted always holds?.', 4, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (3, 'Emily Lemus', 'Los Angeles', 'defualt.png', '?Intexure have done an excellent job presenting the analysis & insights. I am confident in saying  have helped encounter  is to be welcomed and every pain avoided?.', 5, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (4, 'Michel Jhon', 'CEO', 'defualt.png', '?Owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted always holds?.', 3, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (5, 'Hilda Howard', 'Chicago City', 'defualt.png', '?Owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted always holds?.', 4, 1, '2019-08-23 18:26:42');


#
# TABLE STRUCTURE FOR: global_settings
#

DROP TABLE IF EXISTS `global_settings`;

CREATE TABLE `global_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `institute_name` varchar(255) NOT NULL,
  `institute_email` varchar(100) NOT NULL,
  `address` text NOT NULL,
  `mobileno` varchar(50) NOT NULL,
  `currency` varchar(50) NOT NULL,
  `currency_symbol` varchar(50) NOT NULL,
  `translation` varchar(20) NOT NULL,
  `footer_text` text NOT NULL,
  `animations` varchar(50) NOT NULL,
  `timezone` varchar(30) NOT NULL,
  `date_format` varchar(20) NOT NULL,
  `facebook_url` varchar(255) NOT NULL,
  `twitter_url` varchar(255) NOT NULL,
  `linkedin_url` varchar(255) NOT NULL,
  `youtube_url` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin2;

INSERT INTO `global_settings` (`id`, `institute_name`, `institute_email`, `address`, `mobileno`, `currency`, `currency_symbol`, `translation`, `footer_text`, `animations`, `timezone`, `date_format`, `facebook_url`, `twitter_url`, `linkedin_url`, `youtube_url`, `created_at`, `updated_at`) VALUES (1, 'Contact Center', 'Ramom@example.com', 'Mohammadpur, Dhaka', '+8809678076482', 'BDT', '?', 'english', 'Contact Center', 'fadeInUp', 'Asia/Dhaka', '%d-%b-%Y', '', '', '', '', '2018-10-22 15:07:49', '2023-11-02 00:57:22');


#
# TABLE STRUCTURE FOR: lab_report_template
#

DROP TABLE IF EXISTS `lab_report_template`;

CREATE TABLE `lab_report_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `template` longtext NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: lab_test
#

DROP TABLE IF EXISTS `lab_test`;

CREATE TABLE `lab_test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `name` varchar(155) NOT NULL,
  `patient_price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `production_cost` decimal(18,2) NOT NULL DEFAULT '0.00',
  `test_code` varchar(20) NOT NULL,
  `date` date NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: lab_test_category
#

DROP TABLE IF EXISTS `lab_test_category`;

CREATE TABLE `lab_test_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: labtest_bill
#

DROP TABLE IF EXISTS `labtest_bill`;

CREATE TABLE `labtest_bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(10) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `referral_id` int(11) NOT NULL,
  `total` decimal(18,2) NOT NULL DEFAULT '0.00',
  `discount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `tax_amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `commission` decimal(18,2) DEFAULT '0.00',
  `paid` decimal(18,2) NOT NULL DEFAULT '0.00',
  `due` decimal(18,2) NOT NULL DEFAULT '0.00',
  `status` tinyint(1) NOT NULL,
  `date` date DEFAULT NULL,
  `hash` varchar(50) NOT NULL,
  `prepared_by` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: labtest_bill_details
#

DROP TABLE IF EXISTS `labtest_bill_details`;

CREATE TABLE `labtest_bill_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `labtest_bill_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `test_id` int(11) NOT NULL,
  `price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `discount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `commission_amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: labtest_payment_history
#

DROP TABLE IF EXISTS `labtest_payment_history`;

CREATE TABLE `labtest_payment_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `labtest_bill_id` int(11) NOT NULL,
  `collect_by` int(11) DEFAULT NULL,
  `amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `method_id` int(11) NOT NULL,
  `remarks` text NOT NULL,
  `paid_on` date NOT NULL,
  `coll_type` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: labtest_report
#

DROP TABLE IF EXISTS `labtest_report`;

CREATE TABLE `labtest_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `labtest_bill_id` int(11) NOT NULL,
  `reporting_date` date DEFAULT NULL,
  `delivery_date` date DEFAULT NULL,
  `delivery_time` time DEFAULT NULL,
  `report_description` longtext,
  `report_remarks` text,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: language_list
#

DROP TABLE IF EXISTS `language_list`;

CREATE TABLE `language_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `lang_field` varchar(100) NOT NULL,
  `status` varchar(11) NOT NULL DEFAULT '1',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=latin2;

INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (1, 'English', 'english', '1', '2018-11-15 17:36:31', '2020-01-09 11:45:23');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (2, 'Bengali', 'bengali', '0', '2018-11-15 17:36:31', '2020-01-11 18:11:42');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (3, 'Arabic', 'arabic', '0', '2018-11-15 17:36:31', '2020-01-07 13:22:02');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (4, 'German', 'german', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:26');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (5, 'Greek', 'greek', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:28');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (6, 'Spanish', 'spanish', '1', '2018-11-15 17:36:31', '2023-09-23 13:54:04');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (7, 'French', 'french', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:31');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (8, 'Hindi', 'hindi', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:33');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (9, 'Hungarian', 'hungarian', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:34');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (10, 'Indonesian', 'indonesian', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:35');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (11, 'Italian', 'italian', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:37');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (12, 'Japanese', 'japanese', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:38');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (13, 'Korean', 'korean', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:40');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (14, 'Latin', 'latin', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:41');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (15, 'Dutch', 'dutch', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:43');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (16, 'Portuguese', 'portuguese', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:44');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (17, 'Russian', 'russian', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:46');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (18, 'Thai', 'thai', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:47');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (19, 'Turkish', 'turkish', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:49');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (20, 'Urdu', 'urdu', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:50');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (21, 'Chinese', 'chinese', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:51');


#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `word` varchar(100) NOT NULL,
  `english` varchar(100) NOT NULL,
  `bengali` varchar(100) NOT NULL,
  `arabic` varchar(100) NOT NULL,
  `german` varchar(100) NOT NULL,
  `greek` varchar(100) NOT NULL,
  `spanish` varchar(100) NOT NULL,
  `french` varchar(100) NOT NULL,
  `hindi` varchar(100) NOT NULL,
  `hungarian` varchar(100) NOT NULL,
  `indonesian` varchar(100) NOT NULL,
  `italian` varchar(100) NOT NULL,
  `japanese` varchar(100) NOT NULL,
  `korean` varchar(100) NOT NULL,
  `latin` varchar(100) NOT NULL,
  `dutch` varchar(100) NOT NULL,
  `portuguese` varchar(100) NOT NULL,
  `russian` varchar(100) NOT NULL,
  `thai` varchar(100) NOT NULL,
  `turkish` varchar(100) NOT NULL,
  `urdu` varchar(100) NOT NULL,
  `chinese` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=628 DEFAULT CHARSET=latin2;

INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (1, 'dashboard', 'Dashboard', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (2, 'create', 'Create', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (3, 'patient', 'Patient', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (4, 'test', 'Test', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (5, 'bill', 'Bill', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (6, 'commission', 'Commission', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (7, 'withdrawal', 'Withdrawal', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (8, 'appointment', 'Appointment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (9, 'voucher', 'Voucher', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (10, 'income_vs_expense', 'Income Vs Expense', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (11, 'search', 'Search', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (12, 'visit_home_page', 'Visit Home Page', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (13, 'language', 'Language', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (14, 'logout', 'Logout', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (15, 'profile', 'Profile', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (16, 'reset_password', 'Reset Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (17, 'global', 'Global', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (18, 'settings', 'Settings', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (19, 'frontend', 'Frontend', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (20, 'setting', 'Setting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (21, 'menu', 'Menu', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (22, 'page', 'Page', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (23, 'section', 'Section', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (24, 'manage', 'Manage', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (25, 'slider', 'Slider', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (26, 'features', 'Features', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (27, 'testimonial', 'Testimonial', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (28, 'service', 'Service', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (29, 'faq', 'Faq', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (30, 'details', 'Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (31, 'list', 'List', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (32, 'category', 'Category', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (33, 'login_deactivate', 'Login Deactivate', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (34, 'inventory', 'Inventory', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (35, 'chemical', 'Chemical', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (36, 'supplier', 'Supplier', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (37, 'unit', 'Unit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (38, 'purchase', 'Purchase', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (39, 'stock', 'Stock', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (40, 'reagent', 'Reagent', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (41, 'assigned', 'Assigned', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (42, 'reports', 'Reports', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (43, 'report', 'Report', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (44, 'payment', 'Payment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (45, 'schedule', 'Schedule', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (46, 'add', 'Add', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (47, 'requested_list', 'Requested List', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (48, 'employee', 'Employee', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (49, 'department', 'Department', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (50, 'designation', 'Designation', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (51, 'hrm', 'Human Resource', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (52, 'payroll', 'Payroll', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (53, 'salary', 'Salary', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (54, 'template', 'Template', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (55, 'assign', 'Assign', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (56, 'summary', 'Summary', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (57, 'leaves', 'Leaves', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (58, 'my_leave', 'My Leave', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (59, 'leave_manage', 'Leave Manage', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (60, 'attendance', 'Attendance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (61, 'set', 'Set', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (62, 'pathology', 'Pathology', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (63, 'lab', 'Lab', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (64, 'refer_manager', 'Refer Manager', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (65, 'referral', 'Referral', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (66, 'my_commission', 'My Commission', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (67, 'statement', 'Statement', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (68, 'payout', 'Payout', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (69, 'office_accounting', 'Office Accounting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (70, 'account', 'Account', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (71, 'head', 'Head', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (72, 'income', 'Income', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (73, 'repots', 'Repots', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (74, 'expense', 'Expense', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (75, 'transitions', 'Transitions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (76, 'balance', 'Balance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (77, 'sheet', 'Sheet', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (78, 'billing', 'Billing', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (79, 'due', 'Due', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (80, 'paid', 'Paid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (81, 'collect', 'Collect', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (82, 'investigation', 'Investigation', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (83, 'sms', 'Sms', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (84, 'email', 'Email', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (85, 'role', 'Role', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (86, 'permission', 'Permission', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (87, 'database', 'Database', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (88, 'backup', 'Backup', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (89, 'invoice', 'Invoice', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (90, 'today_total', 'Today Total', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (91, 'annual', 'Annual', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (92, 'total_strength', 'Total Strength', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (93, 'doctor', 'Doctor', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (94, 'pending', 'Pending', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (95, 'request', 'Request', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (96, 'fees', 'Fees', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (97, 'net', 'Net', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (98, 'payable', 'Payable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (99, 'total', 'Total', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (100, 'this_value_is_required', 'This Value Is Required', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (101, 'enter_valid_email', 'Enter Valid Email', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (102, 'are_you_sure', 'Are You Sure', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (103, 'delete_this_information', 'Delete This Information', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (104, 'yes_continue', 'Yes Continue', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (105, 'cancel', 'Cancel', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (106, 'deleted_note', '*Note : This Data Will Be Permanently Deleted', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (107, 'deleted', 'Deleted', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (108, 'information_deleted', 'Information Deleted', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (109, 'website', 'Website', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (110, 'application', 'Application', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (111, 'name', 'Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (112, 'receive_email_to', 'Receive Email To', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (113, 'captcha_status', 'Captcha Status', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (114, 'select', 'Select', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (115, 'disable', 'Disable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (116, 'enable', 'Enable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (117, 'recaptcha_site_key', 'Recaptcha Site Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (118, 'recaptcha_secret_key', 'Recaptcha Secret Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (119, 'working_hours', 'Working Hours', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (120, 'logo', 'Logo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (121, 'fav_icon', 'Fav Icon', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (122, 'address', 'Address', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (123, 'mobile_no', 'Mobile No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (124, 'fax', 'Fax', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (125, 'footer_text', 'Footer Text', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (126, 'facebook_url', 'Facebook Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (127, 'twitter_url', 'Twitter Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (128, 'youtube_url', 'Youtube Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (129, 'google_plus', 'Google Plus', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (130, 'linkedin_url', 'Linkedin Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (131, 'pinterest_url', 'Pinterest Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (132, 'instagram_url', 'Instagram Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (133, 'save', 'Save', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (134, 'website_page', 'Website Page', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (135, 'welcome', 'Welcome', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (136, 'message', 'Message', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (137, 'doctors', 'Doctors', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (138, 'services', 'Services', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (139, 'call_to_action_section', 'Call To Action Section', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (140, 'options', 'Options', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (141, 'title', 'Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (142, 'subtitle', 'Subtitle', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (143, 'description', 'Description', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (144, 'photo', 'Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (145, 'cta', 'Cta', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (146, 'button_text', 'Button Text', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (147, 'button_url', 'Button Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (148, '_title', ' Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (149, 'meta', 'Meta', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (150, 'keyword', 'Keyword', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (151, 'banner_photo', 'Banner Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (152, 'about', 'About', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (153, 'content', 'Content', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (154, 'about_photo', 'About Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (155, 'parallax_photo', 'Parallax Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (156, 'sl', 'Sl', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (157, 'url', 'Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (158, 'action', 'Action', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (159, 'my_appointment', 'My Appointment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (160, 'appointment_status', 'Appointment Status', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (161, 'date', 'Date', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (162, 'time_slot', 'Time Slot', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (163, 'consultation_fees', 'Consultation Fees', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (164, 'discount', 'Discount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (165, 'remarks', 'Remarks', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (166, 'exploring', 'Exploring', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (167, 'no_schedule_found', 'No Schedule Found', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (168, 'information_has_been_saved_successfully', 'Information Has Been Saved Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (169, 'id', 'Id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (170, 'consultation', 'Consultation', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (171, 'serial', 'Serial', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (172, 'status', 'Status', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (173, 'confirmed', 'Confirmed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (174, 'available', 'Available', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (175, 'staff_id', 'Staff Id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (176, 'general', 'General', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (177, 'theme', 'Theme', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (178, 'institute_name', 'Institute Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (179, 'currency', 'Currency', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (180, 'currency_symbol', 'Currency Symbol', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (181, 'timezone', 'Timezone', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (182, 'date_format', 'Date Format', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (183, 'system_logo', 'System Logo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (184, 'text_logo', 'Text Logo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (185, 'upload', 'Upload', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (186, 'select_ground', 'Select Ground', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (187, 'filter', 'Filter', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (188, 'bill_no', 'Bill No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (189, 'delivery', 'Delivery', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (190, 'lab_test', 'Lab Test', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (191, 'edit', 'Edit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (192, 'code', 'Code', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (193, 'purchase_unit', 'Purchase Unit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (194, 'sale_unit', 'Sale Unit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (195, 'unit_ratio', 'Unit Ratio', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (196, 'purchase_price', 'Purchase Price', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (197, 'sales_price', 'Sales Price', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (198, 'all_select', 'All Select', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (199, 'unpaid', 'Unpaid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (200, 'partly_paid', 'Partly Paid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (201, 'total_paid', 'Total Paid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (202, 'type', 'Type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (203, 'ref_no', 'Ref No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (204, 'pay_via', 'Pay Via', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (205, 'amount', 'Amount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (206, 'dr', 'Dr', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (207, 'cr', 'Cr', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (208, 'ref', 'Ref', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (209, 'attachment', 'Attachment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (210, 'login', 'Login', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (211, 'welcome_to', 'Welcome To', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (212, 'username', 'Username', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (213, 'password', 'Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (214, 'remember', 'Remember', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (215, 'lose_your_password', 'Lose Your Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (216, 'position', 'Position', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (217, 'publish', 'Publish', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (218, 'target_new_window', 'Target New Window', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (219, 'external_url', 'External Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (220, 'external_link', 'External Link', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (221, 'successfully', 'Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (222, 'access_denied', 'Access Denied', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (223, 'username_has_already_been_used', 'Username Has Already Been Used', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (224, 'week_day', 'Week Day', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (225, 'time_start', 'Time Start', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (226, 'time_end', 'Time End', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (227, 'per_patient_duration', 'Per Patient Duration', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (228, 'make_closed', 'Make Closed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (229, 'the_consultation_completed', 'The Consultation Completed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (230, 'done', 'Done', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (231, 'the_consultation_has_been_closed', 'The Consultation Has Been Closed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (232, 'requested', 'Requested', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (233, 'create_at', 'Create At', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (234, 'canceled', 'Canceled', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (235, 'apply', 'Apply', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (236, 'close', 'Close', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (237, 'information_has_been_updated_successfully', 'Information Has Been Updated Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (238, 'birthday', 'Birthday', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (239, 'joining_date', 'Joining Date', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (240, 'basic_details', 'Basic Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (241, 'gender', 'Gender', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (242, 'male', 'Male', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (243, 'female', 'Female', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (244, 'religion', 'Religion', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (245, 'blood_group', 'Blood Group', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (246, 'marital_status', 'Marital Status', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (247, 'single', 'Single', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (248, 'married', 'Married', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (249, 'profile_picture', 'Profile Picture', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (250, 'login_details', 'Login Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (251, 'office_details', 'Office Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (252, 'qualification', 'Qualification', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (253, 'social_links', 'Social Links', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (254, 'update', 'Update', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (255, 'patient_id', 'Patient Id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (256, 'guardian', 'Guardian', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (257, 'authentication', 'Authentication', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (258, 'basic', 'Basic', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (259, 'age', 'Age', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (260, 'blood_pressure', 'Blood Pressure', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (261, 'height', 'Height', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (262, 'weight', 'Weight', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (263, 'emergency_contact', 'Emergency Contact', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (264, 'relationship', 'Relationship', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (265, 'history', 'History', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (266, 'completed', 'Completed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (267, 'undelivered', 'Undelivered', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (268, 'login_authentication_deactivate', 'Login Authentication Deactivate', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (269, 'deactivate_account', 'Deactivate Account', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (270, 'authentication_activate', 'Authentication Activate', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (271, 'referred_by', 'Referred By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (272, 'time', 'Time', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (273, 'price', 'Price', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (274, 'add_rows', 'Add Rows', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (275, 'sub_total', 'Sub Total', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (276, 'tax', 'Tax', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (277, 'received', 'Received', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (278, 'enter_payment_amount', 'Enter Payment Amount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (279, 'write_your_remarks', 'Write Your Remarks', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (280, 'roles', 'Roles', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (281, 'system_role', 'System Role', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (282, 'yes', 'Yes', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (283, 'role_permission_for', 'Role Permission For', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (284, 'feature', 'Feature', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (285, 'view', 'View', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (286, 'delete', 'Delete', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (287, 'ordered', 'Ordered', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (288, 'quantity', 'Quantity', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (289, 'net_total', 'Net Total', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (290, 'bill_view', 'Bill View', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (291, 'add_payment', 'Add Payment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (292, 'to', 'To', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (293, 'company', 'Company', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (294, 'sub', 'Sub', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (295, 'paid_amount', 'Paid Amount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (296, 'prepared_by', 'Prepared By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (297, 'authorised_by', 'Authorised By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (298, 'print', 'Print', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (299, 'paid_on', 'Paid On', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (300, 'attach_document', 'Attach Document', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (301, 'the_configuration_has_been_updated', 'The Configuration Has Been Updated', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (302, 'retype_password', 'Retype Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (303, 'contact_number', 'Contact Number', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (304, 'company_name', 'Company Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (305, 'product', 'Product', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (306, 'stock_by', 'Stock By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (307, 'inovice_no', 'Inovice No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (308, 'sales_unit', 'Sales Unit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (309, 'for', 'For', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (310, 'select_multiple_chemical', 'Select Multiple Chemical', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (311, 'payment_history', 'Payment History', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (312, 'sex', 'Sex', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (313, 'from', 'From', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (314, 'net_payable', 'Net Payable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (315, 'collect_by', 'Collect By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (316, 'unpublished_on_website', 'Unpublished On Website', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (317, 'published_on_website', 'Published On Website', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (318, 'grade', 'Grade', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (319, 'overtime', 'Overtime', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (320, 'allowances', 'Allowances', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (321, 'name_of_allowance', 'Name Of Allowance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (322, 'deductions', 'Deductions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (323, 'name_of_deductions', 'Name Of Deductions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (324, 'allowance', 'Allowance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (325, 'deduction', 'Deduction', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (326, 'salary_details', 'Salary Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (327, 'no_information_available', 'No Information Available', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (328, 'transactions', 'Transactions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (329, 'sms_config', 'Sms Config', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (330, 'sms_template', 'Sms Template', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (331, 'select_a_sms_service', 'Select A Sms Service', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (332, 'disabled', 'Disabled', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (333, 'clickatell_username', 'Clickatell Username', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (334, 'clickatell_password', 'Clickatell Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (335, 'clickatell_api_key', 'Clickatell Api Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (336, 'registered_number', 'Registered Number', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (337, 'account_sid', 'Account Sid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (338, 'auth_token', 'Auth Token', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (339, 'account_registered', 'Account Registered', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (340, 'notify_enable', 'Notify Enable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (341, 'body', 'Body', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (342, 'appointment_confirmation', 'Appointment Confirmation', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (343, 'appointment_canceled', 'Appointment Canceled', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (344, 'appointment_request', 'Appointment Request', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (345, 'reporting', 'Reporting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (346, 'button_text_1', 'Button Text 1', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (347, 'button_url_1', 'Button Url 1', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (348, 'button_text_2', 'Button Text 2', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (349, 'button_url_2', 'Button Url 2', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (350, 'left', 'Left', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (351, 'center', 'Center', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (352, 'right', 'Right', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (353, 'icon', 'Icon', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (354, 'surname', 'Surname', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (355, 'rank', 'Rank', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (356, 'staff', 'Staff', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (357, 'paid_by', 'Paid By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (358, 'user', 'User', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (359, 'payslip', 'Payslip', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (360, 'add_employee', 'Add Employee', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (361, 'bank_details', 'Bank Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (362, 'skipped_bank_details', 'Skipped Bank Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (363, 'bank_name', 'Bank Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (364, 'holder_name', 'Holder Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (365, 'bank', 'Bank', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (366, 'branch', 'Branch', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (367, 'ifsc_code', 'Ifsc Code', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (368, 'account_no', 'Account No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (369, 'restore', 'Restore', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (370, 'create_backup', 'Create Backup', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (371, 'file', 'File', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (372, 'backup_size', 'Backup Size', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (373, 'file_upload', 'File Upload', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (374, 'flag', 'Flag', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (375, 'stats', 'Stats', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (376, 'created_at', 'Created At', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (377, 'updated_at', 'Updated At', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (378, 'edit_word', 'Edit Word', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (379, 'flag_icon', 'Flag Icon', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (380, 'language_unpublished', 'Language Unpublished', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (381, 'language_published', 'Language Published', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (382, 'transaction', 'Transaction', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (383, 'month_of_salary', 'Month Of Salary', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (384, 'basic_salary', 'Basic Salary', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (385, 'payment_type', 'Payment Type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (386, 'bank_account', 'Bank Account', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (387, 'actions', 'Actions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (388, 'document', 'Document', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (389, 'download', 'Download', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (390, 'opening_balance', 'Opening Balance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (391, 'total_dr', 'Total Dr', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (392, 'total_cr', 'Total Cr', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (393, 'contact', 'Contact', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (394, 'box_title', 'Box Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (395, 'box_description', 'Box Description', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (396, 'box_photo', 'Box Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (397, 'form_title', 'Form Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (398, 'phone', 'Phone', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (399, 'submit_button_text', 'Submit Button Text', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (400, 'map_iframe', 'Map Iframe', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (401, 'system_name', 'System Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (402, 'month', 'Month', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (403, 'patient_price', 'Patient Price', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (404, 'production_cost', 'Production Cost', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (405, 'created_by', 'Created By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (406, 'test_category', 'Test Category', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (407, 'test_name', 'Test Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (408, 'test_code', 'Test Code', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (409, 'staff_name', 'Staff Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (410, 'percentage', 'Percentage', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (411, 'salary_assign', 'Salary Assign', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (412, 'pay_now', 'Pay Now', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (413, 'overtime_total_hour', 'Overtime Total Hour', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (414, 'overtime_amount', 'Overtime Amount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (415, 'leave_category', 'Leave Category', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (416, 'days', 'Days', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (417, 'leave', 'Leave', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (418, 'date_of_start', 'Date Of Start', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (419, 'date_of_end', 'Date Of End', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (420, 'leave_type', 'Leave Type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (421, 'reason', 'Reason', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (422, 'comments', 'Comments', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (423, 'accepted', 'Accepted', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (424, 'start_date', 'Start Date', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (425, 'end_date', 'End Date', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (426, 'approved', 'Approved', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (427, 'reject', 'Reject', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (428, 'select_all', 'Select All', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (429, 'not_selected', 'Not Selected', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (430, 'present', 'Present', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (431, 'absent', 'Absent', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (432, 'holiday', 'Holiday', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (433, 'late', 'Late', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (434, 'current_balance', 'Current Balance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (435, 'no', 'No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (436, 'current', 'Current', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (437, 'qty', 'Qty', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (438, 'payment_successfull', 'Payment Successfull', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (439, 'payment_by', 'Payment By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (440, 'chemical_wise_stock', 'Chemical Wise Stock', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (441, 'sale', 'Sale', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (442, 'in_qty', 'In Qty', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (443, 'out_qty', 'Out Qty', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (444, 'sale_profit', 'Sale Profit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (445, 'paid_via', 'Paid Via', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (446, 'collected_by', 'Collected By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (447, 'all', 'All', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (448, 'add_short_bio', 'Add Short Bio', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (449, 'email_config', 'Email Config', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (450, 'email_triggers', 'Email Triggers', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (451, 'system_email', 'System Email', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (452, 'subject', 'Subject', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (453, 'forgot_password', 'Forgot Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (454, 'payslip_generated', 'Payslip Generated', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (455, 'leave_approve', 'Leave Approve', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (456, 'leave_reject', 'Leave Reject', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (457, 'username_password_incorrect', 'Username Password Incorrect', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (458, 'change', 'Change', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (459, 'current_password', 'Current Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (460, 'new_password', 'New Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (461, 'confirm_password', 'Confirm Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (462, 'cdr_list', 'Cdr List', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (463, 'call_report', 'Call Report', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (464, 'password_restoration', 'Password Restoration', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (465, 'forgot', 'Forgot', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (466, 'back_to_login', 'Back To Login', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (467, 'Users', 'Users', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (468, 'add_user', 'Add User', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (469, 'Extension No.', 'Extension No.', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (470, 'Active', 'Active', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (471, 'Inactive', 'Inactive', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (472, 'Administrator', 'Administrator', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (473, 'self', 'Self', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (474, 'Room Manager', 'Room Manager', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (475, 'create_user', 'Create User', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (476, 'user_id', 'User Id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (477, 'extension', 'Extension', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (478, 'room_manager', 'Room Manager', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (479, 'remember me', 'Remember Me', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (480, 'forget password', 'Forget Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (481, 'log in', 'Log In', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (482, 'SMS API', 'SMS API', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (483, 'SMS Templates', 'SMS Templates', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (484, 'SMS Campaign', 'SMS Campaign', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (485, 'SMS Reports', 'SMS Reports', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (486, 'Email API', 'Email API', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (487, 'Email Templates', 'Email Templates', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (488, 'Email Campaign', 'Email Campaign', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (489, 'Email Reports', 'Email Reports', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (490, 'Voice', 'Voice', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (491, 'Quick Call', 'Quick Call', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (492, 'trunk\'s', 'Trunk\'s', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (493, 'Caller ID\'s', 'Caller ID\'s', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (494, 'sound_file\'s', 'Sound File\'s', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (495, 'Text to Speech', 'Text To Speech', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (496, 'user management', 'User Management', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (497, 'Contacts', 'Contacts', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (498, 'campaign', 'Campaign', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (499, 'created_time', 'Created Time', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (500, 'campaign_name', 'Campaign Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (501, 'call_group', 'Call Group', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (502, 'caller_id', 'Caller Id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (503, 'call_count', 'Call Count', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (504, 'play_type', 'Play Type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (505, 'play', 'Play', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (506, 'campaign_start_time', 'Campaign Start Time', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (507, 'last_run_time', 'Last Run Time', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (508, 'Trunk', 'Trunk', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (509, 'created time', 'Created Time', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (510, 'trunk_name', 'Trunk Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (511, 'CLID Name', 'CLID Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (512, 'Trunk Type', 'Trunk Type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (513, 'Contact List', 'Contact List', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (514, 'information', 'Information', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (515, 'datetime', 'Datetime', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (516, 'Group', 'Group', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (517, 'select CSV', 'Select CSV', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (518, 'call to', 'Call To', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (519, 'Caller ID', 'Caller ID', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (520, 'Start Call', 'Start Call', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (521, 'Quick Call Lists', 'Quick Call Lists', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (522, 'date_time', 'Date Time', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (523, 'call_to', 'Call To', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (524, 'New Trunk added successfully', 'New Trunk Added Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (525, 'CallerID\'s', 'CallerID\'s', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (526, 'CallerID', 'CallerID', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (527, 'channels', 'Channels', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (528, 'New CallerID added successfully', 'New CallerID Added Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (529, 'Sounds', 'Sounds', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (530, 'Sound', 'Sound', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (531, 'sound_name', 'Sound Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (532, 'Sound File', 'Sound File', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (533, 'New Sound added successfully', 'New Sound Added Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (534, 'TTS', 'TTS', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (535, 'TTS Text', 'TTS Text', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (536, 'New TTS added successfully', 'New TTS Added Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (537, 'Call Initiated successfully', 'Call Initiated Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (538, 'New Campaign created successfully', 'New Campaign Created Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (539, 'Config CMP.', 'Config CMP.', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (540, 'Config', 'Config', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (541, 'Cmp', 'Cmp', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (542, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (543, 'Ami', 'Ami', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (544, 'Ami Config', 'Ami Config', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (545, 'last updated', 'Last Updated', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (546, 'host', 'Host', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (547, 'port', 'Port', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (548, 'Data', 'Data', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (549, ' Updated successfully', ' Updated Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (550, 'Edit campaign', 'Edit Campaign', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (551, 'Campaign updated successfully', 'Campaign Updated Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (552, 'time_range', 'Time Range', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (553, 'time_range(From-To)', 'Time Range(From-To)', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (554, 'Campaign config updated successfully', 'Campaign Config Updated Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (555, 'Call Re-Initiated successfully', 'Call Re-Initiated Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (556, 'configure', 'Configure', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (557, 'Info', 'Info', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (558, 'Detail', 'Detail', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (559, 'Campaign Id', 'Campaign Id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (560, 'Date Time', 'Date Time', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (561, 'L1 Type', 'L1 Type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (562, 'L1 Value', 'L1 Value', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (563, 'For Machine', 'For Machine', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (564, 'For Human', 'For Human', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (565, 'Press 0 Key', 'Press 0 Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (566, 'Press 0 Value', 'Press 0 Value', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (567, 'Press 1 Key', 'Press 1 Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (568, 'Press 1 Value', 'Press 1 Value', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (569, 'Press 2 Key', 'Press 2 Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (570, 'Press 3 Key', 'Press 3 Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (571, 'Press 4 Key', 'Press 4 Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (572, 'Press 5 Key', 'Press 5 Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (573, 'Press 6 Key', 'Press 6 Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (574, 'Press 7 Key', 'Press 7 Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (575, 'Press 8 Key', 'Press 8 Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (576, 'Press 8 Value', 'Press 8 Value', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (577, 'Press 9 Key', 'Press 9 Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (578, 'Press 9 Value', 'Press 9 Value', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (579, 'Layer', 'Layer', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (580, '1', '1', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (581, '2', '2', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (582, 'Campaign Type', 'Campaign Type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (583, 'Channel', 'Channel', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (584, 'Updated successfully', 'Updated Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (585, 'total_contact', 'Total Contact', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (586, 'Campaign Strategy', 'Campaign Strategy', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (587, 'Running Status', 'Running Status', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (588, 'running_status', 'Running Status', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (589, 'Running', 'Running', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (590, 'group_count', 'Group Count', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (591, 'status/Config', 'Status/Config', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (592, 'group_name', 'Group Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (593, 'campaign_id', 'Campaign Id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (594, 'press_value', 'Press Value', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (595, 'last_called_datetime', 'Last Called Datetime', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (596, 'call_initiate_datetime', 'Call Initiate Datetime', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (597, 'call_ringing_datetime', 'Call Ringing Datetime', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (598, 'call_answered_datetime', 'Call Answered Datetime', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (599, 'call_hangup_datetime', 'Call Hangup Datetime', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (600, 'Called Time', 'Called Time', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (601, 'campaign_strategy', 'Campaign Strategy', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (602, 'Source', 'Source', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (603, 'Destination', 'Destination', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (604, 'cdr_disposition', 'Cdr Disposition', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (605, 'cdr_bill_second', 'Cdr Bill Second', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (606, 'merchant number', 'Merchant Number', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (607, 'assigned admin', 'Assigned Admin', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (608, 'Add User', 'Add User', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (609, 'Max Con-Current Call', 'Max Con-Current Call', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (610, 'Contact Details', 'Contact Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (611, 'Destination No', 'Destination No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (612, 'contact management', 'Contact Management', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (613, 'Assign To', 'Assign To', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (614, 'Result', 'Result', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (615, 'Assign Contact\'s', 'Assign Contact\'s', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (616, 'Groups', 'Groups', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (617, 'Contact Group', 'Contact Group', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (618, 'Total Contacts', 'Total Contacts', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (619, 'Contact Assign', 'Contact Assign', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (620, 'Quick Call Test', 'Quick Call Test', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (621, 'Assign Agent', 'Assign Agent', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (622, 'Assign Contacts', 'Assign Contacts', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (623, 'Assigned To', 'Assigned To', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (624, 'Assigned Agent', 'Assigned Agent', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (625, 'customer number', 'Customer Number', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (626, 'Customer', 'Customer', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (627, 'Set CallerId/Trunk', 'Set CallerId/Trunk', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');


#
# TABLE STRUCTURE FOR: leave_application
#

DROP TABLE IF EXISTS `leave_application`;

CREATE TABLE `leave_application` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `category_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `leave_days` varchar(20) NOT NULL DEFAULT '0',
  `status` varchar(10) NOT NULL DEFAULT '1',
  `apply_date` datetime NOT NULL,
  `orig_file_name` varchar(255) NOT NULL,
  `enc_file_name` varchar(255) NOT NULL,
  `approved_by` longtext NOT NULL,
  `comments` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: leave_category
#

DROP TABLE IF EXISTS `leave_category`;

CREATE TABLE `leave_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `days` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: login_credential
#

DROP TABLE IF EXISTS `login_credential`;

CREATE TABLE `login_credential` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `username` varchar(100) NOT NULL,
  `password` varchar(250) NOT NULL,
  `role` int(11) NOT NULL,
  `active` int(11) NOT NULL COMMENT '1(active) 0(deactivate)',
  `last_login` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin2;

INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (1, 1, 'superman', '$2y$10$Fc88bs4Y1qcPDm8qQ9ms5ORx/PgdBQOiiJBN.tbu9rtLjwL5FKUaa', 1, 1, '2023-12-10 10:22:59', '2023-06-27 17:28:08', '2023-11-14 19:30:47');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (3, 2, 'admin1', '$2y$10$.66FwghNAGrUgYyr9pcBYeQYG/HXVYnRPG6uLeLYvqf32q9Vy/KXy', 10, 1, NULL, '2023-09-23 15:23:10', '2023-09-23 15:23:10');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (5, 4, 'agente01', '$2y$10$r4MVnWXOSjXtT4qbVSiJO.I05vu2xT66rlGF/ZyKWd.9g9k.9r6g.', 10, 1, NULL, '2023-10-02 10:53:03', '2023-10-02 10:53:03');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (6, 5, 'test_admin', '$2y$10$ddCc60AtrWSR/p/WjWkojul/PQSwGfPni3M5g5gKFDpqJYUAUTaJ6', 2, 1, '2023-12-03 17:08:48', NULL, NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (8, 7, 'neil', '$2y$10$nGzl4oyCXHXN11nGV3IcdeOURWdPicV2A/uCHaOEUZib260AYRDAK', 3, 1, '2023-11-29 21:33:33', NULL, NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (9, 8, 'customer1', '$2y$10$pBPtP6B59YaDmabhutZDMe7Wx/pEvW1qCrvoJ2qL6gLMTgCzK8MHi', 3, 1, '2023-12-06 15:34:49', NULL, NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (10, 9, 'admin', '$2y$10$jjegrw0Hr.MRE2LafddB1OOg7aC7oDesi973D2K1ud/mEe3oCU/wS', 2, 1, NULL, NULL, NULL);
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (11, 10, '100010', '$2y$10$Bp8vpeKE3UMU3TQOysvdV.h/GGDh1IvR8s5Th9Vhyh5tDDR08U0rC', 3, 1, '2023-12-06 16:44:53', NULL, NULL);


#
# TABLE STRUCTURE FOR: messages
#

DROP TABLE IF EXISTS `messages`;

CREATE TABLE `messages` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `chat_id` int(11) DEFAULT NULL,
  `to_id` int(11) DEFAULT NULL,
  `from_id` int(11) DEFAULT NULL,
  `attachment_url` text,
  `message` text,
  `type` text,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=latin2;

INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('43', 3, 2, 1, '', 'Hello', 'text', '2023-10-05 18:52:59', '2023-10-05 18:52:59');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('44', 3, 2, 1, '', 'are you there?', 'text', '2023-10-05 18:55:16', '2023-10-05 18:55:16');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('45', 3, 1, 2, '', 'Yes', 'text', '2023-10-05 18:58:04', '2023-10-05 18:58:04');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('46', 3, 1, 2, '', 'Hi', 'text', '2023-10-05 18:58:29', '2023-10-05 18:58:29');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('47', 3, 2, 1, '', 'hello', 'text', '2023-10-05 18:58:32', '2023-10-05 18:58:32');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('48', 3, 1, 2, '', 'How are you? ', 'text', '2023-10-05 18:58:36', '2023-10-05 18:58:36');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('49', 3, 2, 1, '', 'what was the issue?', 'text', '2023-10-05 18:58:39', '2023-10-05 18:58:39');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('50', 3, 1, 2, '', 'Very slow rendering ', 'text', '2023-10-05 18:58:49', '2023-10-05 18:58:49');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('51', 3, 2, 1, '', 'the time is showing 8 hours ago', 'text', '2023-10-05 18:58:50', '2023-10-05 18:58:50');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('52', 3, 2, 1, '', 'ya', 'text', '2023-10-05 18:58:54', '2023-10-05 18:58:54');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('53', 3, 1, 2, '', 'I have found something ', 'text', '2023-10-05 18:58:59', '2023-10-05 18:58:59');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('54', 3, 2, 1, '', 'what is it?', 'text', '2023-10-05 18:59:09', '2023-10-05 18:59:09');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('55', 3, 1, 2, '', 'This 8 hours are server time ', 'text', '2023-10-05 18:59:10', '2023-10-05 18:59:10');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('56', 3, 2, 1, '', 'ok', 'text', '2023-10-05 18:59:39', '2023-10-05 18:59:39');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('57', 3, 1, 2, '', 'More we need to make it live on http for calling ', 'text', '2023-10-05 18:59:49', '2023-10-05 18:59:49');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('58', 3, 2, 1, '', 'you mean https', 'text', '2023-10-05 19:00:06', '2023-10-05 19:00:06');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('59', 3, 1, 2, '', 'On whatsapp', 'text', '2023-10-05 19:00:40', '2023-10-05 19:00:40');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('60', 3, 1, 2, '', '', 'text', '2023-10-20 08:48:14', '2023-10-20 08:48:14');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('61', 3, 1, 2, '', '', 'text', '2023-10-20 10:12:44', '2023-10-20 10:12:44');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('62', 3, 1, 2, '', '', 'text', '2023-10-28 16:11:47', '2023-10-28 16:11:47');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('63', 3, 1, 2, '', '', 'text', '2023-10-28 16:12:30', '2023-10-28 16:12:30');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('64', 3, 1, 2, '', '', 'text', '2023-10-28 16:25:11', '2023-10-28 16:25:11');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('65', 3, 1, 2, 'https://api-cc.sohub.com.bd/server/api/index.php?action=view&filename=653d366366396_5f5c67053340e033.jpg', '', 'image', '2023-10-28 16:27:16', '2023-10-28 16:27:16');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('66', 3, 1, 2, 'https://api-cc.sohub.com.bd/server/api/index.php?action=view&filename=653d368ddce18_2a9ae11ea4dcf36d.jpg', '', 'image', '2023-10-28 16:27:59', '2023-10-28 16:27:59');


#
# TABLE STRUCTURE FOR: patient
#

DROP TABLE IF EXISTS `patient`;

CREATE TABLE `patient` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `patient_id` varchar(10) NOT NULL,
  `category_id` int(11) NOT NULL,
  `birthday` date NOT NULL,
  `sex` varchar(10) NOT NULL,
  `blood_group` varchar(10) NOT NULL,
  `blood_pressure` varchar(100) NOT NULL,
  `height` varchar(10) NOT NULL,
  `weight` varchar(10) NOT NULL,
  `marital_status` varchar(10) NOT NULL,
  `age` varchar(10) DEFAULT NULL,
  `address` text NOT NULL,
  `mobileno` varchar(30) NOT NULL,
  `email` varchar(200) NOT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `guardian` varchar(200) NOT NULL,
  `relationship` varchar(200) NOT NULL,
  `gua_mobileno` varchar(30) NOT NULL,
  `source` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: patient_category
#

DROP TABLE IF EXISTS `patient_category`;

CREATE TABLE `patient_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin2;

INSERT INTO `patient_category` (`id`, `name`) VALUES (1, 'Test');


#
# TABLE STRUCTURE FOR: patient_documents
#

DROP TABLE IF EXISTS `patient_documents`;

CREATE TABLE `patient_documents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `type` varchar(100) NOT NULL,
  `remarks` text NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `enc_name` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: payment_type
#

DROP TABLE IF EXISTS `payment_type`;

CREATE TABLE `payment_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: payout_commission
#

DROP TABLE IF EXISTS `payout_commission`;

CREATE TABLE `payout_commission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `bill_no` varchar(11) NOT NULL,
  `before_payout` decimal(18,2) NOT NULL DEFAULT '0.00',
  `amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `pay_via` int(11) NOT NULL,
  `remarks` text,
  `paid_by` int(11) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: payslip
#

DROP TABLE IF EXISTS `payslip`;

CREATE TABLE `payslip` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `month` varchar(20) DEFAULT NULL,
  `year` varchar(20) NOT NULL,
  `basic_salary` decimal(18,2) NOT NULL DEFAULT '0.00',
  `total_allowance` decimal(18,2) NOT NULL DEFAULT '0.00',
  `total_deduction` decimal(18,2) NOT NULL DEFAULT '0.00',
  `net_salary` decimal(18,2) NOT NULL DEFAULT '0.00',
  `bill_no` varchar(25) NOT NULL,
  `remarks` text NOT NULL,
  `pay_via` tinyint(1) NOT NULL,
  `hash` varchar(255) DEFAULT NULL,
  `paid_by` int(11) NOT NULL,
  `payment_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: payslip_details
#

DROP TABLE IF EXISTS `payslip_details`;

CREATE TABLE `payslip_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payslip_id` varchar(20) NOT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `type` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: permission
#

DROP TABLE IF EXISTS `permission`;

CREATE TABLE `permission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `prefix` varchar(100) NOT NULL,
  `show_view` tinyint(4) DEFAULT '1',
  `show_add` tinyint(4) DEFAULT '1',
  `show_edit` tinyint(4) DEFAULT '1',
  `show_delete` tinyint(4) DEFAULT '1',
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=latin2;

INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (1, 2, 'Patient', 'patient', 1, 1, 1, 1, '2019-05-27 16:28:52');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (2, 2, 'Patient Category', 'patient_category', 1, 1, 1, 1, '2019-05-27 16:28:52');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (3, 6, 'Employee', 'employee', 1, 1, 1, 1, '2019-05-27 16:28:52');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (4, 6, 'Department', 'department', 1, 1, 1, 1, '2019-05-27 16:28:52');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (5, 6, 'Designation', 'designation', 1, 1, 1, 1, '2019-05-27 16:28:52');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (6, 6, 'Login Deactivate', 'employee_disable_authentication', 1, 0, 1, 0, '2019-05-27 23:56:59');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (7, 7, 'Salary Template', 'salary_template', 1, 1, 1, 1, '2019-05-27 17:09:28');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (8, 7, 'Salary Assign', 'salary_assign', 1, 1, 0, 0, '2019-05-27 17:09:34');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (9, 8, 'Lab Test', 'lab_test', 1, 1, 1, 1, '2019-05-27 16:28:52');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (10, 8, 'Test Category', 'test_category', 1, 1, 1, 1, '2019-05-27 16:28:53');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (11, 12, 'Test Report', 'test_report', 1, 1, 1, 0, '2019-05-27 16:28:53');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (12, 12, 'Test Report Template', 'test_report_template', 1, 1, 1, 1, '2019-05-27 16:28:53');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (13, 11, 'Lab Test Bill', 'lab_test_bill', 1, 1, 0, 1, '2019-05-27 23:12:14');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (14, 11, 'Test Bill Report', 'test_bill_report', 1, 0, 0, 0, '2019-05-27 23:12:28');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (15, 11, 'Test Bill Payment', 'test_bill_payment', 1, 1, 0, 0, '2019-05-27 23:12:28');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (16, 9, 'Referral Assign', 'referral_assign', 1, 1, 1, 1, '2019-05-27 23:34:50');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (17, 9, 'Commission Withdrawal', 'commission_withdrawal', 1, 1, 0, 1, '2019-05-27 23:34:59');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (18, 9, 'Referral Reports', 'referral_reports', 1, 0, 0, 0, '2019-05-27 23:35:02');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (19, 2, 'Login Deactivate', 'patient_disable_authentication', 1, 0, 1, 0, '2019-05-27 16:28:52');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (20, 3, 'Purchase Payment', 'purchase_payment', 1, 1, 0, 0, '2019-05-28 01:02:18');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (21, 13, 'Global Setting', 'global_setting', 1, 1, 0, 0, '2019-05-28 02:28:04');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (22, 13, 'Email Setting', 'email_setting', 1, 1, 0, 0, '2019-05-29 12:42:40');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (23, 13, 'Language', 'language', 1, 1, 1, 1, '2019-05-29 01:10:08');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (24, 13, 'Database Backup', 'database_backup', 1, 1, 0, 1, '2019-05-28 12:54:40');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (25, 13, 'Database Restore', 'database_restore', 0, 1, 0, 0, '2019-05-28 13:07:49');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (26, 7, 'Salary Payment', 'salary_payment', 1, 1, 0, 0, '2019-05-30 14:27:03');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (27, 7, 'Salary Summary Report', 'salary_summary_report', 1, 0, 0, 0, '2019-05-31 19:46:17');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (28, 7, 'Leave Category', 'leave_category', 1, 1, 1, 1, '2019-06-02 01:12:59');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (29, 7, 'My Leave', 'my_leave', 1, 1, 0, 1, '2019-06-03 21:01:42');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (30, 7, 'Leave Manage', 'leave_manage', 1, 1, 0, 1, '2019-06-04 14:40:20');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (31, 7, 'Staff Attendance', 'staff_attendance', 1, 1, 0, 0, '2019-06-05 01:53:37');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (32, 10, 'Account', 'account', 1, 1, 1, 1, '2019-06-07 16:58:38');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (33, 10, 'Voucher', 'voucher', 1, 1, 1, 1, '2019-06-09 01:17:14');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (34, 10, 'Voucher Head', 'voucher_head', 1, 1, 1, 1, '2019-06-08 19:00:33');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (35, 10, 'Accounting Reports', 'accounting_reports', 1, 0, 0, 0, '2019-06-09 20:56:59');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (36, 4, 'Schedule', 'schedule', 1, 1, 1, 1, '2019-06-13 05:47:17');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (37, 5, 'Appointment', 'appointment', 1, 1, 1, 1, '2019-06-13 05:56:41');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (38, 5, 'Appointment Request', 'appointment_request', 1, 0, 1, 1, '2019-06-14 16:21:02');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (39, 1, 'Today Invoice Widget', 'today_invoice_widget', 1, 0, 0, 0, '2019-06-17 00:02:40');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (40, 1, 'Today Commission Widget', 'today_commission_widget', 1, 0, 0, 0, '2019-06-17 00:02:40');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (41, 1, 'Today Income Widget', 'today_income_widget', 1, 0, 0, 0, '2019-06-17 00:02:40');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (42, 1, 'Today Expense Widget', 'today_expense_widget', 1, 0, 0, 0, '2019-06-17 00:02:40');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (43, 1, 'Annual Income Vs Expense Chart', 'annual_income_vs_expense_chart', 1, 0, 0, 0, '2019-06-17 00:27:47');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (44, 1, 'Patient Count Widget', 'patient_count_widget', 1, 0, 0, 0, '2019-06-17 00:38:33');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (45, 1, 'Doctor Count Widget', 'doctor_count_widget', 1, 0, 0, 0, '2019-06-17 00:38:33');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (46, 1, 'Employee Count Widget', 'employee_count_widget', 1, 0, 0, 0, '2019-06-17 00:38:33');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (47, 1, 'Appointment Count Widget', 'appointment_count_widget', 1, 0, 0, 0, '2019-06-17 00:38:33');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (48, 1, 'Pathology Fees Summary Chart', 'pathology_fees_summary_chart', 1, 0, 0, 0, '2019-06-17 00:48:28');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (49, 14, 'Frontend Setting', 'frontend_setting', 1, 1, 0, 0, '2019-09-11 03:24:07');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (50, 14, 'Frontend Menu', 'frontend_menu', 1, 1, 1, 1, '2019-09-11 04:03:39');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (51, 14, 'Frontend Section', 'frontend_section', 1, 1, 0, 0, '2019-09-11 04:26:11');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (52, 14, 'Manage Page', 'manage_page', 1, 1, 1, 1, '2019-09-11 05:54:08');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (53, 14, 'Frontend Slider', 'frontend_slider', 1, 1, 1, 1, '2019-09-11 06:12:31');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (54, 14, 'Frontend Features', 'frontend_features', 1, 1, 1, 1, '2019-09-11 06:47:51');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (55, 14, 'Frontend Testimonial', 'frontend_testimonial', 1, 1, 1, 1, '2019-09-11 06:54:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (56, 14, 'Frontend Services', 'frontend_services', 1, 1, 1, 1, '2019-09-11 07:01:44');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (57, 14, 'Frontend Faq', 'frontend_faq', 1, 1, 1, 1, '2019-09-11 07:06:16');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (58, 13, 'Sms Setting', 'sms_setting', 1, 1, 0, 0, '2019-09-13 11:41:37');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (59, 14, 'Doctor Short Bio', 'doctor_short_bio', 0, 1, 0, 0, '2019-09-17 20:13:12');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (60, 1, 'Appointment Status Chart', 'appointment_status_chart', 1, 0, 0, 0, '2019-06-17 00:48:28');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (61, 9, 'My Commission', 'my_commission', 1, 0, 0, 0, '2019-06-17 00:48:28');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (62, 15, 'Campaigns', 'campaigns', 1, 1, 1, 1, '2023-11-28 00:00:00');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (63, 15, 'Quick Call', 'quick_call', 1, 1, 1, 1, '2023-11-28 00:00:00');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (64, 15, 'Trunk\'s', 'trunks', 1, 1, 1, 1, '2023-11-28 00:00:00');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (65, 15, 'Caller ID\'s', 'caller_ids', 1, 1, 1, 1, '2023-11-28 00:00:00');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (66, 15, 'Sound File\'s', 'sound_files', 1, 1, 1, 1, '2023-11-28 00:00:00');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (67, 15, 'Text To Speech', 'text_to_speech', 1, 1, 1, 1, '2023-11-28 00:00:00');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (68, 16, 'Contacts List', 'contacts_list', 1, 1, 1, 1, '2023-11-29 00:00:00');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (69, 16, 'Assign To', 'assign_to', 1, 1, 1, 1, '2023-11-29 00:00:00');


#
# TABLE STRUCTURE FOR: permission_modules
#

DROP TABLE IF EXISTS `permission_modules`;

CREATE TABLE `permission_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `prefix` varchar(50) NOT NULL,
  `system` tinyint(1) NOT NULL,
  `sorted` tinyint(4) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin2;

INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (1, 'Dashboard', 'dashboard', 1, 1, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (2, 'Patient Details', 'patient_details', 1, 3, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (4, 'Schedule', 'schedule', 1, 5, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (5, 'Appointment', 'appointment', 1, 6, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (6, 'Employee', 'employee', 1, 7, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (7, 'Human Resources', 'human_resources', 1, 8, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (8, 'Pathology', 'test_manager', 1, 9, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (9, 'Refer Manager', 'refer_manager', 1, 10, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (10, 'Office Accounting', 'office_accounting', 1, 11, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (11, 'Pathology Billing', 'billing', 1, 12, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (12, 'Investigation Report', 'investigation_report', 1, 13, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (13, 'Settings', 'settings', 1, 14, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (14, 'Website', 'website', 1, 2, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (15, 'Voice', 'voice', 1, 4, '2023-11-28 00:00:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (16, 'Contacts', 'contacts', 1, 15, '2023-11-29 00:00:00');


#
# TABLE STRUCTURE FOR: purchase_bill
#

DROP TABLE IF EXISTS `purchase_bill`;

CREATE TABLE `purchase_bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(200) NOT NULL,
  `supplier_id` int(11) NOT NULL,
  `remarks` text NOT NULL,
  `total` decimal(18,2) NOT NULL DEFAULT '0.00',
  `discount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `paid` decimal(18,2) NOT NULL DEFAULT '0.00',
  `due` decimal(18,2) NOT NULL DEFAULT '0.00',
  `payment_status` int(11) NOT NULL,
  `purchase_status` int(11) NOT NULL,
  `hash` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `prepared_by` int(11) DEFAULT NULL,
  `modifier_id` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: purchase_bill_details
#

DROP TABLE IF EXISTS `purchase_bill_details`;

CREATE TABLE `purchase_bill_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purchase_bill_id` int(11) NOT NULL,
  `chemical_id` varchar(20) NOT NULL,
  `unit_price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `quantity` varchar(20) NOT NULL,
  `discount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `sub_total` decimal(18,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: purchase_payment_history
#

DROP TABLE IF EXISTS `purchase_payment_history`;

CREATE TABLE `purchase_payment_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purchase_bill_id` varchar(11) NOT NULL,
  `payment_by` int(11) DEFAULT NULL,
  `amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `pay_via` varchar(25) NOT NULL,
  `remarks` text NOT NULL,
  `attach_orig_name` varchar(255) DEFAULT NULL,
  `attach_file_name` varchar(255) DEFAULT NULL,
  `paid_on` date DEFAULT NULL,
  `coll_type` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: referral_commission
#

DROP TABLE IF EXISTS `referral_commission`;

CREATE TABLE `referral_commission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `test_id` int(11) NOT NULL,
  `percentage` varchar(10) NOT NULL,
  `assign_by` int(11) NOT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: reset_password
#

DROP TABLE IF EXISTS `reset_password`;

CREATE TABLE `reset_password` (
  `key` longtext NOT NULL,
  `username` varchar(100) NOT NULL,
  `login_credential_id` varchar(100) NOT NULL,
  `created_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: roles
#

DROP TABLE IF EXISTS `roles`;

CREATE TABLE `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `prefix` varchar(50) DEFAULT NULL,
  `is_system` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin2;

INSERT INTO `roles` (`id`, `name`, `prefix`, `is_system`) VALUES (1, 'Super Admin', 'superadmin', '1');
INSERT INTO `roles` (`id`, `name`, `prefix`, `is_system`) VALUES (2, 'Admin', 'admin', '1');
INSERT INTO `roles` (`id`, `name`, `prefix`, `is_system`) VALUES (3, 'Customers', 'customers', '1');


#
# TABLE STRUCTURE FOR: salary_template
#

DROP TABLE IF EXISTS `salary_template`;

CREATE TABLE `salary_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `basic_salary` decimal(18,2) NOT NULL DEFAULT '0.00',
  `overtime_salary` varchar(100) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: salary_template_details
#

DROP TABLE IF EXISTS `salary_template_details`;

CREATE TABLE `salary_template_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `salary_template_id` varchar(20) NOT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `type` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: schedule
#

DROP TABLE IF EXISTS `schedule`;

CREATE TABLE `schedule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `day` varchar(100) NOT NULL,
  `doctor_id` varchar(11) NOT NULL,
  `time_start` time NOT NULL,
  `time_end` time NOT NULL,
  `per_patient_time` varchar(50) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `consultation_fees` decimal(18,2) DEFAULT '0.00',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: sms_config
#

DROP TABLE IF EXISTS `sms_config`;

CREATE TABLE `sms_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clickatell_username` varchar(255) NOT NULL,
  `clickatell_password` varchar(255) NOT NULL,
  `clickatell_api_key` varchar(255) NOT NULL,
  `clickatell_number` varchar(255) NOT NULL,
  `twilio_account_sid` varchar(255) NOT NULL,
  `twilio_auth_token` varchar(255) NOT NULL,
  `twilio_number` varchar(255) NOT NULL,
  `active_gateway` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin2;

INSERT INTO `sms_config` (`id`, `clickatell_username`, `clickatell_password`, `clickatell_api_key`, `clickatell_number`, `twilio_account_sid`, `twilio_auth_token`, `twilio_number`, `active_gateway`) VALUES (1, '', '', '', '', '', '', '', 'disabled');


#
# TABLE STRUCTURE FOR: sms_templates
#

DROP TABLE IF EXISTS `sms_templates`;

CREATE TABLE `sms_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sms_type` varchar(200) NOT NULL,
  `subject` varchar(250) NOT NULL,
  `template_body` longtext NOT NULL,
  `tags` longtext NOT NULL,
  `notified` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin2;

INSERT INTO `sms_templates` (`id`, `sms_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (1, 'account_registered', '', '', '{institute_name}, {name}, {username}, {password}, {user_role}, {login_url}', 0);
INSERT INTO `sms_templates` (`id`, `sms_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (2, 'appointment_confirmation', '', '', '{institute_name}, {patient_name}, {doctor_name}, {appointment_id}, {schedule_time}, {appointment_date}', 0);
INSERT INTO `sms_templates` (`id`, `sms_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (3, 'appointment_canceled', '', '', '{institute_name}, {patient_name}, {doctor_name}, {appointment_id}, {schedule_time}, {appointment_date}', 0);
INSERT INTO `sms_templates` (`id`, `sms_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (4, 'appointment_request', '', '', '{institute_name}, {patient_name}, {doctor_name}, {appointment_id}, {schedule_time}, {appointment_date}', 0);


#
# TABLE STRUCTURE FOR: staff
#

DROP TABLE IF EXISTS `staff`;

CREATE TABLE `staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` varchar(10) NOT NULL,
  `merchant_no` varchar(200) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `status` varchar(200) DEFAULT NULL,
  `extension` varchar(200) DEFAULT NULL,
  `admin` varchar(200) DEFAULT NULL,
  `room_manager` varchar(200) DEFAULT NULL,
  `department` int(11) DEFAULT NULL,
  `qualification` varchar(200) DEFAULT NULL,
  `designation` int(11) DEFAULT NULL,
  `joining_date` date DEFAULT NULL,
  `gender` varchar(12) DEFAULT NULL,
  `religion` varchar(200) DEFAULT NULL,
  `marital_status` varchar(10) DEFAULT NULL,
  `address` mediumtext,
  `state` varchar(255) DEFAULT NULL,
  `city` varchar(200) DEFAULT NULL,
  `mobileno` varchar(30) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `assigned_admin` varchar(200) DEFAULT NULL,
  `caller_id` longtext,
  `trunk` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin2;

INSERT INTO `staff` (`id`, `staff_id`, `merchant_no`, `name`, `status`, `extension`, `admin`, `room_manager`, `department`, `qualification`, `designation`, `joining_date`, `gender`, `religion`, `marital_status`, `address`, `state`, `city`, `mobileno`, `email`, `photo`, `created_at`, `updated_at`, `assigned_admin`, `caller_id`, `trunk`) VALUES (1, 'b195808', '90931', 'Super Admin', 'Active', NULL, NULL, NULL, 0, '', 0, '2023-06-27', '', '', '2', '', '', '', '+8801744733133', 'tanvirislam.dev@gmail.com', '0fa96a4e26f9541d9b10841ecf59f5ba.png', '2023-06-27 17:28:07', '2023-09-23 15:21:50', NULL, NULL, NULL);
INSERT INTO `staff` (`id`, `staff_id`, `merchant_no`, `name`, `status`, `extension`, `admin`, `room_manager`, `department`, `qualification`, `designation`, `joining_date`, `gender`, `religion`, `marital_status`, `address`, `state`, `city`, `mobileno`, `email`, `photo`, `created_at`, `updated_at`, `assigned_admin`, `caller_id`, `trunk`) VALUES (2, '74b749e', NULL, 'agent1', 'Active', '101', 'self', 'self', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '12345', 'agent1@callwave.pro', 'defualt.png', '2023-09-23 15:23:10', '2023-09-23 16:22:08', NULL, NULL, NULL);
INSERT INTO `staff` (`id`, `staff_id`, `merchant_no`, `name`, `status`, `extension`, `admin`, `room_manager`, `department`, `qualification`, `designation`, `joining_date`, `gender`, `religion`, `marital_status`, `address`, `state`, `city`, `mobileno`, `email`, `photo`, `created_at`, `updated_at`, `assigned_admin`, `caller_id`, `trunk`) VALUES (4, '930ea2d', NULL, 'agente01', 'Active', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', 'agente01@test.com', 'defualt.png', '2023-10-02 10:53:03', '2023-10-02 10:53:03', NULL, NULL, NULL);
INSERT INTO `staff` (`id`, `staff_id`, `merchant_no`, `name`, `status`, `extension`, `admin`, `room_manager`, `department`, `qualification`, `designation`, `joining_date`, `gender`, `religion`, `marital_status`, `address`, `state`, `city`, `mobileno`, `email`, `photo`, `created_at`, `updated_at`, `assigned_admin`, `caller_id`, `trunk`) VALUES (5, '8ece71c', '09023', 'Test Admin', 'Active', NULL, NULL, NULL, NULL, NULL, NULL, '2023-11-28', 'male', NULL, '', NULL, NULL, NULL, '123456', 'testadmin@gmail.com', 'defualt.png', NULL, NULL, '', '{+12076927722}', '{3}');
INSERT INTO `staff` (`id`, `staff_id`, `merchant_no`, `name`, `status`, `extension`, `admin`, `room_manager`, `department`, `qualification`, `designation`, `joining_date`, `gender`, `religion`, `marital_status`, `address`, `state`, `city`, `mobileno`, `email`, `photo`, `created_at`, `updated_at`, `assigned_admin`, `caller_id`, `trunk`) VALUES (7, '1113252', '100007', 'neil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '123456', 'neil@email.com', 'defualt.png', NULL, NULL, '', NULL, NULL);
INSERT INTO `staff` (`id`, `staff_id`, `merchant_no`, `name`, `status`, `extension`, `admin`, `room_manager`, `department`, `qualification`, `designation`, `joining_date`, `gender`, `religion`, `marital_status`, `address`, `state`, `city`, `mobileno`, `email`, `photo`, `created_at`, `updated_at`, `assigned_admin`, `caller_id`, `trunk`) VALUES (8, '6ff50ae', '100008', 'customer1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Dhaka, Bangladesh', NULL, NULL, '123456', 'customer1@gmail.com', 'defualt.png', NULL, NULL, '09023', NULL, NULL);
INSERT INTO `staff` (`id`, `staff_id`, `merchant_no`, `name`, `status`, `extension`, `admin`, `room_manager`, `department`, `qualification`, `designation`, `joining_date`, `gender`, `religion`, `marital_status`, `address`, `state`, `city`, `mobileno`, `email`, `photo`, `created_at`, `updated_at`, `assigned_admin`, `caller_id`, `trunk`) VALUES (9, 'f5a47e8', '100009', 'Admin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1122334455', 'admin@gmail.com', 'defualt.png', NULL, NULL, '', '{+120769277}', '{3}');
INSERT INTO `staff` (`id`, `staff_id`, `merchant_no`, `name`, `status`, `extension`, `admin`, `room_manager`, `department`, `qualification`, `designation`, `joining_date`, `gender`, `religion`, `marital_status`, `address`, `state`, `city`, `mobileno`, `email`, `photo`, `created_at`, `updated_at`, `assigned_admin`, `caller_id`, `trunk`) VALUES (10, '2c2e389', '100010', '100010', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '100010', '100010@asd.cc', 'defualt.png', NULL, NULL, '100009', NULL, NULL);


#
# TABLE STRUCTURE FOR: staff_attendance
#

DROP TABLE IF EXISTS `staff_attendance`;

CREATE TABLE `staff_attendance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` varchar(20) NOT NULL,
  `status` varchar(2) DEFAULT NULL,
  `remark` varchar(255) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: staff_balance
#

DROP TABLE IF EXISTS `staff_balance`;

CREATE TABLE `staff_balance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin2;

INSERT INTO `staff_balance` (`id`, `staff_id`, `amount`, `created_at`, `updated_at`) VALUES (1, 0, '0.00', '2023-09-23 14:53:17', '2023-09-23 14:53:17');
INSERT INTO `staff_balance` (`id`, `staff_id`, `amount`, `created_at`, `updated_at`) VALUES (2, 2, '0.00', '2023-09-23 15:23:10', '2023-09-23 15:23:10');
INSERT INTO `staff_balance` (`id`, `staff_id`, `amount`, `created_at`, `updated_at`) VALUES (4, 4, '0.00', '2023-10-02 10:53:03', '2023-10-02 10:53:03');
INSERT INTO `staff_balance` (`id`, `staff_id`, `amount`, `created_at`, `updated_at`) VALUES (5, 5, '0.00', NULL, NULL);
INSERT INTO `staff_balance` (`id`, `staff_id`, `amount`, `created_at`, `updated_at`) VALUES (7, 7, '0.00', NULL, NULL);
INSERT INTO `staff_balance` (`id`, `staff_id`, `amount`, `created_at`, `updated_at`) VALUES (8, 8, '0.00', NULL, NULL);
INSERT INTO `staff_balance` (`id`, `staff_id`, `amount`, `created_at`, `updated_at`) VALUES (9, 9, '0.00', NULL, NULL);
INSERT INTO `staff_balance` (`id`, `staff_id`, `amount`, `created_at`, `updated_at`) VALUES (10, 10, '0.00', NULL, NULL);


#
# TABLE STRUCTURE FOR: staff_bank_account
#

DROP TABLE IF EXISTS `staff_bank_account`;

CREATE TABLE `staff_bank_account` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `bank_name` varchar(200) NOT NULL,
  `holder_name` varchar(255) NOT NULL,
  `bank_branch` varchar(255) NOT NULL,
  `bank_address` varchar(255) NOT NULL,
  `ifsc_code` varchar(200) NOT NULL,
  `account_no` varchar(200) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: staff_department
#

DROP TABLE IF EXISTS `staff_department`;

CREATE TABLE `staff_department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: staff_designation
#

DROP TABLE IF EXISTS `staff_designation`;

CREATE TABLE `staff_designation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: staff_documents
#

DROP TABLE IF EXISTS `staff_documents`;

CREATE TABLE `staff_documents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `category_id` varchar(20) NOT NULL,
  `remarks` text NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `enc_name` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: staff_privileges
#

DROP TABLE IF EXISTS `staff_privileges`;

CREATE TABLE `staff_privileges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  `is_add` tinyint(1) NOT NULL,
  `is_edit` tinyint(1) NOT NULL,
  `is_view` tinyint(1) NOT NULL,
  `is_delete` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=370 DEFAULT CHARSET=latin2;

INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (1, 2, 39, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (2, 2, 40, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (3, 2, 41, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (4, 2, 42, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (5, 2, 43, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (6, 2, 44, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (7, 2, 45, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (8, 2, 46, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (9, 2, 47, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (10, 2, 48, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (11, 2, 49, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (12, 2, 50, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (13, 2, 51, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (14, 2, 52, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (15, 2, 53, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (16, 2, 54, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (17, 2, 55, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (18, 2, 56, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (19, 2, 57, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (20, 2, 59, 1, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (21, 2, 1, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (22, 2, 2, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (23, 2, 19, 0, 1, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (24, 2, 36, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (25, 2, 37, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (26, 2, 38, 0, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (27, 2, 3, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (28, 2, 4, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (29, 2, 5, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (30, 2, 6, 0, 1, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (31, 2, 7, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (32, 2, 8, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (33, 2, 26, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (34, 2, 27, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (35, 2, 28, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (36, 2, 29, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (37, 2, 30, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (38, 2, 31, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (39, 2, 9, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (40, 2, 10, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (41, 2, 16, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (42, 2, 17, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (43, 2, 18, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (44, 2, 32, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (45, 2, 33, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (46, 2, 34, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (47, 2, 35, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (48, 2, 13, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (49, 2, 14, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (50, 2, 15, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (51, 2, 11, 1, 1, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (52, 2, 12, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (53, 2, 21, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (54, 2, 22, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (55, 2, 23, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (56, 2, 24, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (57, 2, 25, 1, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (58, 2, 58, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (59, 3, 39, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (60, 3, 40, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (61, 3, 41, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (62, 3, 42, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (63, 3, 43, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (64, 3, 44, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (65, 3, 45, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (66, 3, 46, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (67, 3, 47, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (68, 3, 48, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (69, 3, 49, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (70, 3, 50, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (71, 3, 51, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (72, 3, 52, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (73, 3, 53, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (74, 3, 54, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (75, 3, 55, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (76, 3, 56, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (77, 3, 57, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (78, 3, 59, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (79, 3, 1, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (80, 3, 2, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (81, 3, 19, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (82, 3, 36, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (83, 3, 37, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (84, 3, 38, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (85, 3, 3, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (86, 3, 4, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (87, 3, 5, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (88, 3, 6, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (89, 3, 7, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (90, 3, 8, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (91, 3, 26, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (92, 3, 27, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (93, 3, 28, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (94, 3, 29, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (95, 3, 30, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (96, 3, 31, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (97, 3, 9, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (98, 3, 10, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (99, 3, 16, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (100, 3, 17, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (101, 3, 18, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (102, 3, 32, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (103, 3, 33, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (104, 3, 34, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (105, 3, 35, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (106, 3, 13, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (107, 3, 14, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (108, 3, 15, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (109, 3, 11, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (110, 3, 12, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (111, 3, 21, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (112, 3, 22, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (113, 3, 23, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (114, 3, 24, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (115, 3, 25, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (116, 3, 58, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (117, 4, 39, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (118, 4, 40, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (119, 4, 41, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (120, 4, 42, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (121, 4, 43, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (122, 4, 44, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (123, 4, 45, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (124, 4, 46, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (125, 4, 47, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (126, 4, 48, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (127, 4, 49, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (128, 4, 50, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (129, 4, 51, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (130, 4, 52, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (131, 4, 53, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (132, 4, 54, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (133, 4, 55, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (134, 4, 56, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (135, 4, 57, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (136, 4, 59, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (137, 4, 1, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (138, 4, 2, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (139, 4, 19, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (140, 4, 36, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (141, 4, 37, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (142, 4, 38, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (143, 4, 3, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (144, 4, 4, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (145, 4, 5, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (146, 4, 6, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (147, 4, 7, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (148, 4, 8, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (149, 4, 26, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (150, 4, 27, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (151, 4, 28, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (152, 4, 29, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (153, 4, 30, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (154, 4, 31, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (155, 4, 9, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (156, 4, 10, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (157, 4, 16, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (158, 4, 17, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (159, 4, 18, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (160, 4, 32, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (161, 4, 33, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (162, 4, 34, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (163, 4, 35, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (164, 4, 13, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (165, 4, 14, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (166, 4, 15, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (167, 4, 11, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (168, 4, 12, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (169, 4, 21, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (170, 4, 22, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (171, 4, 23, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (172, 4, 24, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (173, 4, 25, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (174, 4, 58, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (175, 5, 39, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (176, 5, 40, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (177, 5, 41, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (178, 5, 42, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (179, 5, 43, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (180, 5, 44, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (181, 5, 45, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (182, 5, 46, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (183, 5, 47, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (184, 5, 48, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (185, 5, 49, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (186, 5, 50, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (187, 5, 51, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (188, 5, 52, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (189, 5, 53, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (190, 5, 54, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (191, 5, 55, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (192, 5, 56, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (193, 5, 57, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (194, 5, 59, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (195, 5, 1, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (196, 5, 2, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (197, 5, 19, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (198, 5, 36, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (199, 5, 37, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (200, 5, 38, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (201, 5, 3, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (202, 5, 4, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (203, 5, 5, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (204, 5, 6, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (205, 5, 7, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (206, 5, 8, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (207, 5, 26, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (208, 5, 27, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (209, 5, 28, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (210, 5, 29, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (211, 5, 30, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (212, 5, 31, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (213, 5, 9, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (214, 5, 10, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (215, 5, 16, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (216, 5, 17, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (217, 5, 18, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (218, 5, 32, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (219, 5, 33, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (220, 5, 34, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (221, 5, 35, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (222, 5, 13, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (223, 5, 14, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (224, 5, 15, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (225, 5, 11, 1, 1, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (226, 5, 12, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (227, 5, 21, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (228, 5, 22, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (229, 5, 23, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (230, 5, 24, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (231, 5, 25, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (232, 5, 58, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (233, 6, 39, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (234, 6, 40, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (235, 6, 41, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (236, 6, 42, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (237, 6, 43, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (238, 6, 44, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (239, 6, 45, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (240, 6, 46, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (241, 6, 47, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (242, 6, 48, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (243, 6, 49, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (244, 6, 50, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (245, 6, 51, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (246, 6, 52, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (247, 6, 53, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (248, 6, 54, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (249, 6, 55, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (250, 6, 56, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (251, 6, 57, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (252, 6, 59, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (253, 6, 1, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (254, 6, 2, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (255, 6, 19, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (256, 6, 36, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (257, 6, 37, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (258, 6, 38, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (259, 6, 3, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (260, 6, 4, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (261, 6, 5, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (262, 6, 6, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (263, 6, 7, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (264, 6, 8, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (265, 6, 26, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (266, 6, 27, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (267, 6, 28, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (268, 6, 29, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (269, 6, 30, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (270, 6, 31, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (271, 6, 9, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (272, 6, 10, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (273, 6, 16, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (274, 6, 17, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (275, 6, 18, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (276, 6, 32, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (277, 6, 33, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (278, 6, 34, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (279, 6, 35, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (280, 6, 13, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (281, 6, 14, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (282, 6, 15, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (283, 6, 11, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (284, 6, 12, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (285, 6, 21, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (286, 6, 22, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (287, 6, 23, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (288, 6, 24, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (289, 6, 25, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (290, 6, 58, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (291, 7, 39, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (292, 7, 40, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (293, 7, 41, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (294, 7, 42, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (295, 7, 43, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (296, 7, 44, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (297, 7, 45, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (298, 7, 46, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (299, 7, 47, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (300, 7, 48, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (301, 7, 49, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (302, 7, 50, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (303, 7, 51, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (304, 7, 52, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (305, 7, 53, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (306, 7, 54, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (307, 7, 55, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (308, 7, 56, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (309, 7, 57, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (310, 7, 59, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (311, 7, 1, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (312, 7, 2, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (313, 7, 19, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (314, 7, 36, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (315, 7, 37, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (316, 7, 38, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (317, 7, 3, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (318, 7, 4, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (319, 7, 5, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (320, 7, 6, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (321, 7, 7, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (322, 7, 8, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (323, 7, 26, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (324, 7, 27, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (325, 7, 28, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (326, 7, 29, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (327, 7, 30, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (328, 7, 31, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (329, 7, 9, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (330, 7, 10, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (331, 7, 16, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (332, 7, 17, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (333, 7, 18, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (334, 7, 32, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (335, 7, 33, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (336, 7, 34, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (337, 7, 35, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (338, 7, 13, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (339, 7, 14, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (340, 7, 15, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (341, 7, 11, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (342, 7, 12, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (343, 7, 21, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (344, 7, 22, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (345, 7, 23, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (346, 7, 24, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (347, 7, 25, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (348, 7, 58, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (349, 2, 60, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (350, 7, 60, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (351, 3, 60, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (352, 3, 61, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (353, 2, 61, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (354, 2, 62, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (355, 2, 63, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (356, 2, 64, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (357, 2, 65, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (358, 2, 66, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (359, 2, 67, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (360, 3, 62, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (361, 3, 63, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (362, 3, 64, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (363, 3, 65, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (364, 3, 66, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (365, 3, 67, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (366, 2, 68, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (367, 2, 69, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (368, 3, 68, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (369, 3, 69, 0, 0, 0, 0);


#
# TABLE STRUCTURE FOR: supplier
#

DROP TABLE IF EXISTS `supplier`;

CREATE TABLE `supplier` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `address` text NOT NULL,
  `mobileno` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `company_name` varchar(200) NOT NULL,
  `product_list` mediumtext NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: theme_settings
#

DROP TABLE IF EXISTS `theme_settings`;

CREATE TABLE `theme_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `border_mode` varchar(20) NOT NULL,
  `dark_skin` varchar(20) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin2;

INSERT INTO `theme_settings` (`id`, `border_mode`, `dark_skin`, `created_at`, `updated_at`) VALUES (1, 'true', 'false', '2019-12-23 22:59:38', '2023-11-02 00:58:21');


#
# TABLE STRUCTURE FOR: transactions
#

DROP TABLE IF EXISTS `transactions`;

CREATE TABLE `transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_id` varchar(20) NOT NULL,
  `voucher_head_id` varchar(200) NOT NULL,
  `type` varchar(100) NOT NULL,
  `category` varchar(20) NOT NULL,
  `ref` varchar(255) NOT NULL,
  `amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `dr` decimal(18,2) NOT NULL DEFAULT '0.00',
  `cr` decimal(18,2) NOT NULL DEFAULT '0.00',
  `bal` decimal(18,2) NOT NULL DEFAULT '0.00',
  `date` date NOT NULL,
  `pay_via` varchar(20) NOT NULL,
  `description` text NOT NULL,
  `attachments` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: users
#

DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `display_name` text,
  `sip_extension` text,
  `sip_password` text,
  `state` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `email` text,
  `password` text,
  `display_picture` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin2;

INSERT INTO `users` (`id`, `display_name`, `sip_extension`, `sip_password`, `state`, `created_at`, `updated_at`, `email`, `password`, `display_picture`) VALUES ('1', 'MD Nahid', '905', '6fd9d726ded5a376713b8a874959bcc5', 'active', '2023-09-28 15:01:35', '2023-09-28 23:47:33', 'nahid@sohub.com', '12345678', 'https://images.pexels.com/photos/45853/grey-crowned-crane-bird-crane-animal-45853.jpeg?auto=compress&cs=tinysrgb&dpr=1&w=500');
INSERT INTO `users` (`id`, `display_name`, `sip_extension`, `sip_password`, `state`, `created_at`, `updated_at`, `email`, `password`, `display_picture`) VALUES ('2', 'Zaman Rajpoot', '906', '76c432a55e77ca38ee9585db9122d101', 'active', '2023-09-28 15:01:35', '2023-09-28 23:47:18', 'zaman@sohub.com', '12345678', 'https://www.planetware.com/wpimages/2020/02/france-in-pictures-beautiful-places-to-photograph-eiffel-tower.jpg');
INSERT INTO `users` (`id`, `display_name`, `sip_extension`, `sip_password`, `state`, `created_at`, `updated_at`, `email`, `password`, `display_picture`) VALUES ('3', 'Helpline', '904', '76c432a55e77ca38ee9585db9122d101', 'active', '2023-09-28 15:01:35', '2023-09-28 23:43:10', 'user3@sohub.com', '12345678', 'https://cdn.pixabay.com/photo/2015/04/23/22/00/tree-736885_1280.jpg');
INSERT INTO `users` (`id`, `display_name`, `sip_extension`, `sip_password`, `state`, `created_at`, `updated_at`, `email`, `password`, `display_picture`) VALUES ('4', 'John Doe', '1001', 's3cr3t', NULL, '2023-10-09 20:47:05', '2023-10-09 20:47:05', 'john@example.com', 'hashed_password', 'https://example.com/profile-picture.jpg');


#
# TABLE STRUCTURE FOR: vb_blacklist
#

DROP TABLE IF EXISTS `vb_blacklist`;

CREATE TABLE `vb_blacklist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_time` datetime DEFAULT NULL,
  `number` varchar(50) DEFAULT NULL,
  `status` varchar(50) NOT NULL,
  `assign_to` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

#
# TABLE STRUCTURE FOR: vb_callerid
#

DROP TABLE IF EXISTS `vb_callerid`;

CREATE TABLE `vb_callerid` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_time` datetime DEFAULT NULL,
  `trunk_id` varchar(20) DEFAULT NULL,
  `caller_id` varchar(50) DEFAULT NULL,
  `channels` varchar(50) DEFAULT '0',
  `status` varchar(50) NOT NULL,
  `assign_to` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin2;

INSERT INTO `vb_callerid` (`id`, `date_time`, `trunk_id`, `caller_id`, `channels`, `status`, `assign_to`) VALUES (9, '2023-11-30 13:14:33', NULL, '+12076927722', '5', 'Active', '1');


#
# TABLE STRUCTURE FOR: vb_quick_play
#

DROP TABLE IF EXISTS `vb_quick_play`;

CREATE TABLE `vb_quick_play` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_time` datetime DEFAULT NULL,
  `call_to` varchar(200) DEFAULT NULL,
  `caller_id` varchar(20) DEFAULT NULL,
  `trunk_id` int(11) DEFAULT NULL,
  `trunk_name` varchar(250) DEFAULT NULL,
  `trunk_channelid` varchar(250) DEFAULT NULL,
  `sound` varchar(200) DEFAULT NULL,
  `status` varchar(200) DEFAULT 'Pending',
  `voice_name` varchar(100) DEFAULT NULL,
  `count` int(11) DEFAULT '0',
  `last_play_date_time` datetime DEFAULT NULL,
  `assigned_to` varchar(20) NOT NULL,
  `play_type` varchar(20) DEFAULT NULL,
  `play` longtext CHARACTER SET latin1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=218 DEFAULT CHARSET=latin2;

INSERT INTO `vb_quick_play` (`id`, `date_time`, `call_to`, `caller_id`, `trunk_id`, `trunk_name`, `trunk_channelid`, `sound`, `status`, `voice_name`, `count`, `last_play_date_time`, `assigned_to`, `play_type`, `play`) VALUES (215, '2023-11-29 10:22:14', '1234', '8766766957', 3, NULL, NULL, NULL, NULL, NULL, 0, NULL, '1', 'tts', 'How was the Experience at the restaurant Press one if good');
INSERT INTO `vb_quick_play` (`id`, `date_time`, `call_to`, `caller_id`, `trunk_id`, `trunk_name`, `trunk_channelid`, `sound`, `status`, `voice_name`, `count`, `last_play_date_time`, `assigned_to`, `play_type`, `play`) VALUES (216, '2023-12-02 21:49:32', '8768426621', '+12076927722', 3, NULL, NULL, NULL, NULL, NULL, 0, NULL, '1', 'tts', 'How was the Experience at the restaurant Press one if good');
INSERT INTO `vb_quick_play` (`id`, `date_time`, `call_to`, `caller_id`, `trunk_id`, `trunk_name`, `trunk_channelid`, `sound`, `status`, `voice_name`, `count`, `last_play_date_time`, `assigned_to`, `play_type`, `play`) VALUES (217, '2023-12-06 16:38:03', '18457999009', '+12076927722', 3, NULL, NULL, NULL, NULL, NULL, 0, NULL, '10', 'tts', 'hello');


#
# TABLE STRUCTURE FOR: vb_schedule_play
#

DROP TABLE IF EXISTS `vb_schedule_play`;

CREATE TABLE `vb_schedule_play` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `date_time` datetime DEFAULT NULL,
  `last_play_date_time` datetime DEFAULT NULL,
  `caller_id` varchar(20) NOT NULL,
  `trunk_id` int(11) DEFAULT NULL,
  `play_type` varchar(50) CHARACTER SET latin1 DEFAULT NULL,
  `play` longtext CHARACTER SET latin1,
  `call_group` varchar(200) NOT NULL,
  `count_call` int(11) NOT NULL,
  `count` int(11) DEFAULT '0',
  `status` varchar(200) DEFAULT NULL,
  `campaign_type` varchar(250) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `retries` int(11) DEFAULT '0',
  `assigned_to` varchar(20) NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `campaign_config` longtext CHARACTER SET latin1,
  `fixed_channels` varchar(20) CHARACTER SET latin1 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=349 DEFAULT CHARSET=latin2;

INSERT INTO `vb_schedule_play` (`id`, `name`, `date_time`, `last_play_date_time`, `caller_id`, `trunk_id`, `play_type`, `play`, `call_group`, `count_call`, `count`, `status`, `campaign_type`, `date`, `retries`, `assigned_to`, `start_time`, `end_time`, `campaign_config`, `fixed_channels`) VALUES (340, 'First Campaign', '2023-11-30 17:07:25', NULL, '+12076927722', 3, NULL, '', 'sohub_group', 0, 0, 'Done', 'voice_broadcast', '2023-11-30', 0, '1', '00:00:00', '23:59:00', NULL, '0');
INSERT INTO `vb_schedule_play` (`id`, `name`, `date_time`, `last_play_date_time`, `caller_id`, `trunk_id`, `play_type`, `play`, `call_group`, `count_call`, `count`, `status`, `campaign_type`, `date`, `retries`, `assigned_to`, `start_time`, `end_time`, `campaign_config`, `fixed_channels`) VALUES (341, 'Test-sentiment', '2023-11-30 22:19:36', NULL, '+12076927722', 3, NULL, '', 'test_group', 0, 0, 'Done', 'voice_broadcast', '2023-11-30', 0, '1', '00:00:00', '23:59:00', NULL, '0');
INSERT INTO `vb_schedule_play` (`id`, `name`, `date_time`, `last_play_date_time`, `caller_id`, `trunk_id`, `play_type`, `play`, `call_group`, `count_call`, `count`, `status`, `campaign_type`, `date`, `retries`, `assigned_to`, `start_time`, `end_time`, `campaign_config`, `fixed_channels`) VALUES (342, 'STT-2', '2023-12-01 20:35:15', NULL, '+12076927722', 3, NULL, '', 'test_group', 0, 0, 'Done', 'voice_broadcast', '2023-12-01', 0, '1', '00:00:00', '23:59:00', NULL, '0');
INSERT INTO `vb_schedule_play` (`id`, `name`, `date_time`, `last_play_date_time`, `caller_id`, `trunk_id`, `play_type`, `play`, `call_group`, `count_call`, `count`, `status`, `campaign_type`, `date`, `retries`, `assigned_to`, `start_time`, `end_time`, `campaign_config`, `fixed_channels`) VALUES (343, 'Neil test', '2023-12-02 21:50:46', NULL, '+12076927722', 3, NULL, '', 'test_group', 0, 0, 'Done', 'voice_broadcast', '2023-12-02', 0, '1', '00:00:00', '23:59:00', NULL, '0');
INSERT INTO `vb_schedule_play` (`id`, `name`, `date_time`, `last_play_date_time`, `caller_id`, `trunk_id`, `play_type`, `play`, `call_group`, `count_call`, `count`, `status`, `campaign_type`, `date`, `retries`, `assigned_to`, `start_time`, `end_time`, `campaign_config`, `fixed_channels`) VALUES (344, 'STT', '2023-12-02 21:52:09', NULL, '+12076927722', 3, NULL, '', 'test_group', 0, 0, 'Done', 'voice_broadcast', '2023-12-02', 0, '1', '00:00:00', '23:59:00', NULL, '0');
INSERT INTO `vb_schedule_play` (`id`, `name`, `date_time`, `last_play_date_time`, `caller_id`, `trunk_id`, `play_type`, `play`, `call_group`, `count_call`, `count`, `status`, `campaign_type`, `date`, `retries`, `assigned_to`, `start_time`, `end_time`, `campaign_config`, `fixed_channels`) VALUES (345, 'STT', '2023-12-02 21:56:03', NULL, '+12076927722', 3, NULL, '', 'test_group', 0, 0, 'Done', 'voice_broadcast', '2023-12-02', 0, '1', '00:00:00', '23:59:00', NULL, '0');
INSERT INTO `vb_schedule_play` (`id`, `name`, `date_time`, `last_play_date_time`, `caller_id`, `trunk_id`, `play_type`, `play`, `call_group`, `count_call`, `count`, `status`, `campaign_type`, `date`, `retries`, `assigned_to`, `start_time`, `end_time`, `campaign_config`, `fixed_channels`) VALUES (346, 'Trump campaign', '2023-12-02 22:45:39', NULL, '+12076927722', 3, NULL, '', 'test_group', 0, 0, 'Done', 'voice_broadcast', '2023-12-02', 0, '1', '00:00:00', '23:59:00', NULL, '0');
INSERT INTO `vb_schedule_play` (`id`, `name`, `date_time`, `last_play_date_time`, `caller_id`, `trunk_id`, `play_type`, `play`, `call_group`, `count_call`, `count`, `status`, `campaign_type`, `date`, `retries`, `assigned_to`, `start_time`, `end_time`, `campaign_config`, `fixed_channels`) VALUES (347, 'Everon', '2023-12-03 23:40:20', NULL, '+12076927722', 3, NULL, '', 'test_group', 0, 0, 'Done', 'voice_broadcast', '2023-12-03', 0, '1', '00:00:00', '23:59:00', NULL, '0');
INSERT INTO `vb_schedule_play` (`id`, `name`, `date_time`, `last_play_date_time`, `caller_id`, `trunk_id`, `play_type`, `play`, `call_group`, `count_call`, `count`, `status`, `campaign_type`, `date`, `retries`, `assigned_to`, `start_time`, `end_time`, `campaign_config`, `fixed_channels`) VALUES (348, 'test', '2023-12-06 16:42:03', NULL, '+12076927722', 3, NULL, '', 'New CSV', 0, 0, 'Done', 'voice_broadcast', '2023-12-06', 0, '10', '00:00:00', '23:59:00', NULL, '0');


#
# TABLE STRUCTURE FOR: vb_sounds
#

DROP TABLE IF EXISTS `vb_sounds`;

CREATE TABLE `vb_sounds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_time` datetime DEFAULT NULL,
  `sound_name` varchar(50) DEFAULT NULL,
  `directory` varchar(50) NOT NULL,
  `file_name` varchar(50) DEFAULT NULL,
  `status` varchar(50) NOT NULL,
  `assign_to` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin2;

INSERT INTO `vb_sounds` (`id`, `date_time`, `sound_name`, `directory`, `file_name`, `status`, `assign_to`) VALUES (1, '2023-11-02 01:29:40', 'Sohub test', '', 'audio-1698867002.wav', 'Active', '1');


#
# TABLE STRUCTURE FOR: vb_trunks
#

DROP TABLE IF EXISTS `vb_trunks`;

CREATE TABLE `vb_trunks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_time` datetime DEFAULT NULL,
  `trunk_name` varchar(50) DEFAULT NULL,
  `trunk_type` varchar(50) DEFAULT NULL,
  `trunk_clid_name` varchar(50) DEFAULT '0',
  `status` varchar(50) NOT NULL,
  `assign_to` longtext,
  `trunk_channel_limit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin2;

INSERT INTO `vb_trunks` (`id`, `date_time`, `trunk_name`, `trunk_type`, `trunk_clid_name`, `status`, `assign_to`, `trunk_channel_limit`) VALUES (3, '2023-11-28 15:52:37', 'zadarma-trunk-552586', 'PJSIP', '+18766766957', 'Active', '1', 5);


#
# TABLE STRUCTURE FOR: vb_tts
#

DROP TABLE IF EXISTS `vb_tts`;

CREATE TABLE `vb_tts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_time` datetime DEFAULT NULL,
  `tts_name` varchar(50) DEFAULT NULL,
  `tts_text` longtext NOT NULL,
  `status` varchar(50) DEFAULT NULL,
  `assign_to` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin2;

INSERT INTO `vb_tts` (`id`, `date_time`, `tts_name`, `tts_text`, `status`, `assign_to`) VALUES (2, '2023-11-27 16:35:22', 'Press 1 Campaign', 'This is a test Press Campaign Please press a number after the beep ', 'Active', '1');
INSERT INTO `vb_tts` (`id`, `date_time`, `tts_name`, `tts_text`, `status`, `assign_to`) VALUES (4, '2023-11-28 02:16:04', 'How was the Experience', 'How was the Experience at the restaurant Press one if good', 'Active', '1');
INSERT INTO `vb_tts` (`id`, `date_time`, `tts_name`, `tts_text`, `status`, `assign_to`) VALUES (6, '2023-11-29 14:04:17', 'Advanced STT', 'Welcome to Solution Hub Technologies This is a sample for Advanced Speech to Text campaign Please Note that your voice will be recorded after the beep Thank You', 'Active', '1');
INSERT INTO `vb_tts` (`id`, `date_time`, `tts_name`, `tts_text`, `status`, `assign_to`) VALUES (7, '2023-12-01 20:33:42', 'How was the Experience STT', 'How was the Experience at our restaurant  Please tell me your opinion Your opinion is very important to us Thank you', 'Active', '1');
INSERT INTO `vb_tts` (`id`, `date_time`, `tts_name`, `tts_text`, `status`, `assign_to`) VALUES (8, '2023-12-02 22:08:08', 'Trump', 'What do you thinks the chances are of Donald Trump winning the next election ', 'Active', '1');
INSERT INTO `vb_tts` (`id`, `date_time`, `tts_name`, `tts_text`, `status`, `assign_to`) VALUES (9, '2023-12-03 23:39:34', 'Everon', 'What is it like working with Everon Say your answer after the tone ', 'Active', '1');
INSERT INTO `vb_tts` (`id`, `date_time`, `tts_name`, `tts_text`, `status`, `assign_to`) VALUES (10, '2023-12-06 16:37:47', 'test', 'hello', 'Active', '10');


#
# TABLE STRUCTURE FOR: voucher_head
#

DROP TABLE IF EXISTS `voucher_head`;

CREATE TABLE `voucher_head` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin2;

