#
# TABLE STRUCTURE FOR: accounts
#

DROP TABLE IF EXISTS `accounts`;

CREATE TABLE `accounts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` text NOT NULL,
  `balance` double(18,2) NOT NULL DEFAULT '0.00',
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: ami_config
#

DROP TABLE IF EXISTS `ami_config`;

CREATE TABLE `ami_config` (
  `id` int NOT NULL,
  `created_time` datetime DEFAULT NULL,
  `last_updated` datetime DEFAULT NULL,
  `host` varchar(200) DEFAULT NULL,
  `port` varchar(200) DEFAULT NULL,
  `username` varchar(200) DEFAULT NULL,
  `password` varchar(250) DEFAULT NULL,
  `status` varchar(200) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

INSERT INTO `ami_config` (`id`, `created_time`, `last_updated`, `host`, `port`, `username`, `password`, `status`) VALUES (1, '2023-11-05 00:00:00', '2023-11-07 21:01:40', '202.59.208.113', '5038', 'my_api', '977084d0c93e7ec7489a8ad6a3b04db4', 'Active');


#
# TABLE STRUCTURE FOR: appointment
#

DROP TABLE IF EXISTS `appointment`;

CREATE TABLE `appointment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `appointment_id` varchar(20) NOT NULL,
  `doctor_id` varchar(20) NOT NULL,
  `patient_id` varchar(20) NOT NULL,
  `consultation_fees` varchar(20) NOT NULL,
  `discount` decimal(18,2) NOT NULL,
  `schedule` varchar(50) NOT NULL,
  `remarks` text NOT NULL,
  `appointment_date` date NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: campaign_config
#

DROP TABLE IF EXISTS `campaign_config`;

CREATE TABLE `campaign_config` (
  `id` int NOT NULL AUTO_INCREMENT,
  `campaign_id` int DEFAULT NULL,
  `date_time` datetime DEFAULT NULL,
  `l1_type` varchar(200) DEFAULT NULL,
  `l1_value` varchar(200) DEFAULT NULL,
  `for_machine` varchar(200) DEFAULT NULL,
  `for_human` varchar(200) DEFAULT NULL,
  `press_0` varchar(200) DEFAULT NULL,
  `press_1` varchar(200) DEFAULT NULL,
  `press_2` varchar(200) DEFAULT NULL,
  `press_3` varchar(200) DEFAULT NULL,
  `press_4` varchar(200) DEFAULT NULL,
  `press_5` varchar(200) DEFAULT NULL,
  `press_6` varchar(200) DEFAULT NULL,
  `press_7` varchar(200) DEFAULT NULL,
  `press_8` varchar(200) DEFAULT NULL,
  `press_9` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

#
# TABLE STRUCTURE FOR: chats
#

DROP TABLE IF EXISTS `chats`;

CREATE TABLE `chats` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `members` varchar(50) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

INSERT INTO `chats` (`id`, `members`, `created_at`, `updated_at`) VALUES ('3', '1,2', '2023-09-29 05:19:38', '2023-09-29 05:19:38');


#
# TABLE STRUCTURE FOR: chemical
#

DROP TABLE IF EXISTS `chemical`;

CREATE TABLE `chemical` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `code` varchar(50) NOT NULL,
  `category_id` int NOT NULL,
  `purchase_unit_id` int NOT NULL,
  `sales_unit_id` int NOT NULL,
  `unit_ratio` varchar(20) DEFAULT '1',
  `purchase_price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `sales_price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `available_stock` varchar(11) NOT NULL DEFAULT '0',
  `photo` varchar(100) DEFAULT NULL,
  `remarks` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: chemical_assigned
#

DROP TABLE IF EXISTS `chemical_assigned`;

CREATE TABLE `chemical_assigned` (
  `id` int NOT NULL AUTO_INCREMENT,
  `test_id` int NOT NULL,
  `chemical_id` varchar(20) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: chemical_category
#

DROP TABLE IF EXISTS `chemical_category`;

CREATE TABLE `chemical_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: chemical_stock
#

DROP TABLE IF EXISTS `chemical_stock`;

CREATE TABLE `chemical_stock` (
  `id` int NOT NULL AUTO_INCREMENT,
  `inovice_no` varchar(25) NOT NULL,
  `chemical_id` varchar(20) NOT NULL,
  `date` date DEFAULT NULL,
  `stock_quantity` varchar(20) NOT NULL,
  `remarks` varchar(255) NOT NULL,
  `stock_by` varchar(20) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: chemical_unit
#

DROP TABLE IF EXISTS `chemical_unit`;

CREATE TABLE `chemical_unit` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: ci_sessions
#

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(40) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int unsigned NOT NULL DEFAULT '0',
  `data` blob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('00teaugk8vp3nce46vcbd67bvgt16r7j', '103.180.244.161', 1699383783, '__ci_last_regenerate|i:1699383783;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('03m5j4vr3jg3ked9quh6j4h7ptd5gvvm', '103.180.244.161', 1698868787, '__ci_last_regenerate|i:1698868787;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:34:\"The Configuration Has Been Updated\";__ci_vars|a:2:{s:21:\"alert-message-success\";s:3:\"old\";s:6:\"active\";s:3:\"old\";}active|i:3;file_data|a:6:{i:0;a:4:{i:0;s:12:\"Tanvir Islam\";i:1;s:13:\"8801744733133\";i:2;s:11:\"Mohammadpur\";i:3;s:19:\"tanvir@sohub.com.bd\";}i:1;a:4:{i:0;s:15:\"Muyed Moktadir \";i:1;s:13:\"8801738505555\";i:2;s:11:\"Mohammadpur\";i:3;s:18:\"muyed@sohub.com.bd\";}i:2;a:4:{i:0;s:12:\"Ariful Islam\";i:1;s:13:\"8801789825487\";i:2;s:5:\"Badda\";i:3;s:17:\"rafi@sohub.com.bd\";}i:3;a:4:{i:0;s:9:\"Sagor Mia\";i:1;s:13:\"8801977255355\";i:2;s:9:\"Dhanmondi\";i:3;s:18:\"sagor@sohub.com.bd\";}i:4;a:4:{i:0;s:10:\"Sohel Rana\";i:1;s:13:\"8801929622723\";i:2;s:13:\"Bosila Bridge\";i:3;s:18:\"sohel@sohub.com.bd\";}i:5;a:4:{i:0;s:14:\"Sakib Shahriar\";i:1;s:13:\"8801517088093\";i:2;s:11:\"Mohammadpur\";i:3;s:18:\"sakib@sohub.com.bd\";}}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('03rbn8ualb1bonkoebkm612podhlq0v9', '103.180.244.161', 1699374061, '__ci_last_regenerate|i:1699374061;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('046ls8dk42a6sb3qnu7b44jomsb05ldu', '103.180.244.161', 1699218488, '__ci_last_regenerate|i:1699217933;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('04jm9a4rh45a6kj8a0kpkipe76iv0eaj', '103.180.244.161', 1699195364, '__ci_last_regenerate|i:1699195364;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('07ipmpb9t37s7vr1d834if8qjfgs9162', '37.111.194.187', 1695477252, '__ci_last_regenerate|i:1695477252;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0arsjm7o5b2lu1q38n6cp204kssp3vtt', '37.111.228.176', 1699813112, '__ci_last_regenerate|i:1699813112;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:30:\"Call Re-Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0cse2h9s8eip2pg2of06adi1u4s5of0l', '103.180.244.161', 1698944200, '__ci_last_regenerate|i:1698944200;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0odp62eh23rb716vk17tnuk05scfukl3', '103.180.244.161', 1699802830, '__ci_last_regenerate|i:1699802830;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('10e6k4eca5ld4anv5jgdeomsngf8ia2i', '103.180.244.161', 1699194275, '__ci_last_regenerate|i:1699194275;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('10nfi178qv9jfjtk334rt528l7h0so3e', '103.180.244.161', 1699366528, '__ci_last_regenerate|i:1699366528;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('11m960jsudug3qk56c8jir4cu9rbj21g', '103.180.244.161', 1699302079, '__ci_last_regenerate|i:1699302079;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('14hab1v04f5eh915dp1ibrr1h8lli5oa', '103.180.244.161', 1699218400, '__ci_last_regenerate|i:1699218399;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:21:\" Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('16f4i1dcsda4s508qe0t9s6r31cl7fjh', '103.180.244.161', 1699472949, '__ci_last_regenerate|i:1699472949;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1774842ga933lmvjl91vviilecku6dmf', '103.180.244.161', 1698869303, '__ci_last_regenerate|i:1698869244;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('17daokp9biq0kc6uemua6bvn98kn3iqt', '103.197.204.175', 1688283168, '__ci_last_regenerate|i:1688283040;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('17rpclqv7qli97n40r8cmi4aorfqn0ei', '103.180.244.161', 1699372408, '__ci_last_regenerate|i:1699372408;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:33:\"New Campaign Created Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('199jum7v96vd16dorpet029abd26geg8', '103.180.244.161', 1699209423, '__ci_last_regenerate|i:1699209423;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1acbijd9aaemgmqddnp86gbt2t488lbs', '103.180.244.161', 1699295302, '__ci_last_regenerate|i:1699295302;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1alrpgr2a57rtud79j81n0j68rpomer9', '59.153.100.221', 1699317782, '__ci_last_regenerate|i:1699317780;redirect_url|s:62:\"http://202.59.208.112/web_apps/contact_center/voice/quick_call\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1df41ga4qr498lcag2nn2tmc9kvn3n7s', '103.180.244.161', 1699388175, '__ci_last_regenerate|i:1699388175;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1fp7e6hqtrdee7iktfcbcc6pmdbosbth', '103.180.244.161', 1698956087, '__ci_last_regenerate|i:1698956087;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1gcb0q9hvhdi04b9av7uvi4gvlfv94d7', '103.180.244.161', 1699197911, '__ci_last_regenerate|i:1699197911;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1m2jv2colpntn52k7kp3rp8hnbo0c3id', '103.180.244.161', 1699474392, '__ci_last_regenerate|i:1699474392;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1snufil0tbegsrkf2887il5k556bl1ci', '103.180.244.161', 1699366371, '__ci_last_regenerate|i:1699366371;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('20keihhrovlbldsk7claseor4fp5sh3p', '103.180.244.161', 1699206958, '__ci_last_regenerate|i:1699206958;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('232j1njbdmuflj21qrg4dnnlpn9etpl3', '103.180.244.161', 1699281192, '__ci_last_regenerate|i:1699281192;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('23fkikl7uss8m25s4k4l6nrh8cj2uco0', '103.180.244.161', 1699389481, '__ci_last_regenerate|i:1699389481;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('23rfv3288r3bkd02cu5nkmg7islcl70k', '103.180.244.161', 1699209604, '__ci_last_regenerate|i:1699209604;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('25ddiijtpilt3qrnod7sl5qs2q988faq', '103.180.244.161', 1699800187, '__ci_last_regenerate|i:1699800187;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2c9ocgdeg3hahctb5hjgguqediurcr6j', '103.180.244.161', 1699208056, '__ci_last_regenerate|i:1699208056;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2cjtlbcdjpquva1ia98l3lnuju5i2npp', '103.180.244.161', 1699471571, '__ci_last_regenerate|i:1699471571;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2h8mtpgman8uc6pf465g55qlqkrn19g4', '103.180.244.161', 1699369175, '__ci_last_regenerate|i:1699369175;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2i1d58fkm4ios7gt3ed2a3288r3b85u8', '103.180.244.161', 1690265375, '__ci_last_regenerate|i:1690265350;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2iab4igm4qhgtacugdkcm608u0ohabjp', '37.111.226.24', 1687889512, '__ci_last_regenerate|i:1687889512;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2iiehuddft0kurd8mjur86ttc4uacmc2', '103.180.244.161', 1699386249, '__ci_last_regenerate|i:1699386249;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2rqvmo53ees8t0vmv3aivbu6ep8k0iao', '103.180.244.161', 1699369125, '__ci_last_regenerate|i:1699369125;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2sbg8blo4pikuiq55ept2rlo70i1l0dr', '103.180.244.161', 1699205376, '__ci_last_regenerate|i:1699205376;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2trcp02q0gs37ltit2mmagti8mms85tv', '103.180.244.161', 1699459136, '__ci_last_regenerate|i:1699459136;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2u94ls3e5ufetfj8jmg3ljvd9lbg1t0f', '103.180.244.161', 1699202669, '__ci_last_regenerate|i:1699202669;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('2vqujqfn0o3gc54o7shbdpqvse5qkos6', '103.180.244.161', 1699370987, '__ci_last_regenerate|i:1699370973;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('32avrs2ealsl6fpp50sh0b1pe3f5q5qi', '103.180.244.161', 1688643287, '__ci_last_regenerate|i:1688643287;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('33v77af07tufbp117656ecs4bs7m30f2', '103.180.244.161', 1698944878, '__ci_last_regenerate|i:1698944878;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3bdf6qmdrlre31jg7uj072f1m28ts1f5', '103.180.244.161', 1699211123, '__ci_last_regenerate|i:1699211123;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3blrcnniurjbbe9ptcu1381jh5lmpkia', '103.180.244.161', 1699206228, '__ci_last_regenerate|i:1699206228;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3dvr0qhnt7arbjptu7dis7nfhi0u7qm5', '103.180.244.161', 1699449966, '__ci_last_regenerate|i:1699449966;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3e91h4v9mb6u7i87hi5fnnqaioq96gs8', '103.180.244.161', 1699538437, '__ci_last_regenerate|i:1699538385;redirect_url|s:55:\"http://202.59.208.112/web_apps/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3g7n5lm58skepbrj7192lbu4bnobtafu', '103.180.244.161', 1699360286, '__ci_last_regenerate|i:1699360286;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3jegc4h5s3b516jvm2j47t7aha9mjth9', '103.180.244.161', 1699453449, '__ci_last_regenerate|i:1699453449;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3l7anjoicot1jip4etd7mqit3k2i5h73', '103.180.244.161', 1690265641, '__ci_last_regenerate|i:1690265452;redirect_url|s:48:\"http://202.59.208.112/cdc/frontend/section/index\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3m7ku6te83jfnnra7n3osiru97o8fnlj', '43.250.82.230', 1688683241, '__ci_last_regenerate|i:1688683240;redirect_url|s:43:\"http://cdc.tolpar.com.bd/inventory/category\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3mahmll5lel3daq971kosi4q4admur3s', '103.180.244.161', 1699451207, '__ci_last_regenerate|i:1699451207;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3pduiubt6p69utquh4mob323581elb4i', '37.111.194.187', 1695484261, '__ci_last_regenerate|i:1695484261;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3pr2jbqglvg0aaiue0q97e7i5jrj1m87', '103.180.244.161', 1699210805, '__ci_last_regenerate|i:1699210805;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3trl8t4r1rbhdhv5n8f9km16b6vijl7b', '103.197.204.175', 1688281027, '__ci_last_regenerate|i:1688281027;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3vnrhh02cumglo3lgusu5cc75e8rc82n', '103.180.244.161', 1698952154, '__ci_last_regenerate|i:1698952154;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3vnvp35aa26thir6083ec8lbrr7kmsg6', '103.180.244.161', 1699201456, '__ci_last_regenerate|i:1699201456;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('40aiukrc07771ln6rfufchsn9r3tvigq', '103.180.244.161', 1699186438, '__ci_last_regenerate|i:1699186438;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('41bccghdmegd9vn5pt11t4t3e0f8b8rk', '103.180.244.161', 1699200789, '__ci_last_regenerate|i:1699200789;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('455s28tv90v75uph7h9hjqf9fsnp0edo', '59.153.100.195', 1695483256, '__ci_last_regenerate|i:1695483256;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('460uteg6n5sh0no7ddkd12nb5hlm5dhk', '103.197.204.175', 1688298244, '__ci_last_regenerate|i:1688298231;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('47q1eeeendckp1t4moiarf0e09j7vf14', '103.180.244.161', 1699378379, '__ci_last_regenerate|i:1699378358;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('493ho5tliiue0fh87g9m2rsgf48551bo', '103.180.244.161', 1699475833, '__ci_last_regenerate|i:1699475833;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4ldnjuu6ibimq6igmgkhfsg1i1i2lflu', '59.153.100.221', 1699575991, '__ci_last_regenerate|i:1699575898;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4m0ispa5misbbrbhphqq7j8udgfkcsp4', '176.98.217.113', 1696246910, '__ci_last_regenerate|i:1696246910;name|s:5:\"admin\";uniqueid|s:7:\"05b009a\";logger_photo|s:11:\"defualt.png\";loggedin_id|s:1:\"4\";loggedin_role_id|s:1:\"2\";loggedin_userid|s:1:\"3\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"spanish\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4miuf18kt24aeh9grdtiatfd0b27ict8', '103.180.244.161', 1698867942, '__ci_last_regenerate|i:1698867942;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4sftb6clqbq4oonofel78hrjvrekqr1q', '103.180.244.161', 1699209129, '__ci_last_regenerate|i:1699209129;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('51oap87b7i9m8c213av1qvdof4g184p6', '103.180.244.161', 1699792226, '__ci_last_regenerate|i:1699792226;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('523cpq78qpii3o7qk56r7s5a7tni9hbk', '202.134.8.143', 1699803605, '__ci_last_regenerate|i:1699803605;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:30:\"Call Re-Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('52s8hpu837llj4ecfdv7n065nb5buvt0', '103.180.244.161', 1699791496, '__ci_last_regenerate|i:1699791496;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('530fdh81e9g5q43hc18hkojjjg9n75jr', '103.180.244.161', 1698956825, '__ci_last_regenerate|i:1698956825;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('53bl1ni35cnblieda30573tpur2mkdv3', '103.180.244.161', 1698951529, '__ci_last_regenerate|i:1698951529;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5446hrlv5bcntiadp60hf4sosbpaf62h', '103.180.244.161', 1699385058, '__ci_last_regenerate|i:1699385058;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('54994uj5274i25lcldbpdi4sql37e92b', '103.181.42.122', 1688682417, '__ci_last_regenerate|i:1688682417;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('55u2juckjnia0oo2ru91s3ecnd33tis1', '103.180.244.161', 1699369990, '__ci_last_regenerate|i:1699369990;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('564ctvaf4to5c4nmun0rk87kch39ghbu', '103.180.244.161', 1699479407, '__ci_last_regenerate|i:1699479399;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('57r4d34pbik1nboa399j6itko67ffalb', '103.180.244.161', 1699292827, '__ci_last_regenerate|i:1699292827;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('58ec9ri12dpufjd7vbkflikai8rup1ie', '103.180.244.161', 1698950450, '__ci_last_regenerate|i:1698950450;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('58j4tjdni04kbkdb0o388uv0pbc91nv5', '103.180.244.161', 1699381890, '__ci_last_regenerate|i:1699381890;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5jsch4a0c6jr0qh5s107n6s2f4mmloo7', '103.180.244.161', 1699470200, '__ci_last_regenerate|i:1699470200;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5k4vpg3mittu9um9ems6agqlcnnmb4bd', '103.180.244.161', 1699212547, '__ci_last_regenerate|i:1699212547;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5q2hndvak814s0356u8ebjuohrkn93vf', '103.197.204.175', 1688296295, '__ci_last_regenerate|i:1688296295;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5sgdfv3hafpb2sf5lkhjj4at28mj8gp7', '103.180.244.161', 1699562312, '__ci_last_regenerate|i:1699562312;redirect_url|s:55:\"http://202.59.208.112/web_apps/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('63cerjo501pqbhfp4li6o2ltuq9e18b0', '103.181.42.122', 1699323338, '__ci_last_regenerate|i:1699323336;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('64j22544dsrms3agf5ijk9qc0sug69vd', '103.180.244.161', 1699792575, '__ci_last_regenerate|i:1699792575;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6i099357lqma9kbld3gm2cu7tmdba259', '103.180.244.161', 1699385946, '__ci_last_regenerate|i:1699385946;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6msfv7q6ho1amgkltb0hdj38rkjl4tpm', '103.180.244.161', 1699215870, '__ci_last_regenerate|i:1699215870;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6qa4jr5qcu4091a912g9c4l59bf196k4', '103.180.244.161', 1699217933, '__ci_last_regenerate|i:1699217933;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6qlvnsaaemogb2b2vms8e07ru54c0cu4', '103.180.244.161', 1698865465, '__ci_last_regenerate|i:1698865465;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:34:\"The Configuration Has Been Updated\";__ci_vars|a:2:{s:21:\"alert-message-success\";s:3:\"old\";s:6:\"active\";s:3:\"old\";}active|i:3;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6qtssvcs7o8id5ohke04n0j420a7fltt', '103.180.244.161', 1699366775, '__ci_last_regenerate|i:1699366775;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('707i726ph65fp4fp80iifb5b5hnsu14j', '103.197.204.175', 1688279866, '__ci_last_regenerate|i:1688279609;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('71ias6je981ghgpnvfhcatmcjh2r7r3b', '103.180.244.161', 1699375151, '__ci_last_regenerate|i:1699375151;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:29:\"Campaign Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('72n6d4icbcgve7k2p5vjps2bf9mhgmed', '103.180.244.161', 1699276649, '__ci_last_regenerate|i:1699276649;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('74aulih526t43k1qfm9mcu99pq376bfb', '103.180.244.161', 1699366535, '__ci_last_regenerate|i:1699366535;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('753eg5r8qi86u1oj9c9sgo4n941b5gpq', '103.180.244.161', 1699460028, '__ci_last_regenerate|i:1699460028;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('76vg6njmi83ap2hcp14gs2o1g9n8imlg', '103.180.244.161', 1698952975, '__ci_last_regenerate|i:1698952975;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('79lu0pplg0pdjal3ele95nk48rf6vt7h', '103.180.244.161', 1699377129, '__ci_last_regenerate|i:1699377129;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7en6hpuq2tcim6u8l350obrb081jgg91', '103.180.244.161', 1699459672, '__ci_last_regenerate|i:1699459672;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7g68s79p8m8vmiougcj4nqkkrqu3dsku', '59.153.100.214', 1699141853, '__ci_last_regenerate|i:1699141853;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7g960vdj8kuaa51f8r7rckb0o5bvfs9v', '103.180.244.161', 1699278905, '__ci_last_regenerate|i:1699278905;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7gr4tkrki76a6b177k1o2tbkomdlu11o', '103.180.244.161', 1699456691, '__ci_last_regenerate|i:1699456691;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7ml6op01lg4hsg2kieiol4m7c63164f7', '103.180.244.161', 1699377028, '__ci_last_regenerate|i:1699377028;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:29:\"Campaign Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7o101pva6tf72a7jkp0ucb9bu06l2e1h', '103.180.244.161', 1699186094, '__ci_last_regenerate|i:1699186094;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7o3vfuhsr3l2rffq2v1t8f1idbbbiq7l', '103.180.244.161', 1699368666, '__ci_last_regenerate|i:1699368666;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7o51sptdt6gd47mj3akvgres9gr343oo', '103.180.244.161', 1699367499, '__ci_last_regenerate|i:1699367499;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7ohhssieitaefgbhiiqogg0chfm2un0n', '103.180.244.161', 1699218068, '__ci_last_regenerate|i:1699218068;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7or1oei6gdghuab1ed30qcde0qm5qs4f', '59.153.100.214', 1688799789, '__ci_last_regenerate|i:1688799789;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7pgbuf7999c0m44kfvgfqa3anphan9ud', '103.180.244.161', 1698868787, '__ci_last_regenerate|i:1698868787;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:34:\"The Configuration Has Been Updated\";__ci_vars|a:2:{s:21:\"alert-message-success\";s:3:\"old\";s:6:\"active\";s:3:\"old\";}active|i:3;file_data|a:6:{i:0;a:4:{i:0;s:12:\"Tanvir Islam\";i:1;s:13:\"8801744733133\";i:2;s:11:\"Mohammadpur\";i:3;s:19:\"tanvir@sohub.com.bd\";}i:1;a:4:{i:0;s:15:\"Muyed Moktadir \";i:1;s:13:\"8801738505555\";i:2;s:11:\"Mohammadpur\";i:3;s:18:\"muyed@sohub.com.bd\";}i:2;a:4:{i:0;s:12:\"Ariful Islam\";i:1;s:13:\"8801789825487\";i:2;s:5:\"Badda\";i:3;s:17:\"rafi@sohub.com.bd\";}i:3;a:4:{i:0;s:9:\"Sagor Mia\";i:1;s:13:\"8801977255355\";i:2;s:9:\"Dhanmondi\";i:3;s:18:\"sagor@sohub.com.bd\";}i:4;a:4:{i:0;s:10:\"Sohel Rana\";i:1;s:13:\"8801929622723\";i:2;s:13:\"Bosila Bridge\";i:3;s:18:\"sohel@sohub.com.bd\";}i:5;a:4:{i:0;s:14:\"Sakib Shahriar\";i:1;s:13:\"8801517088093\";i:2;s:11:\"Mohammadpur\";i:3;s:18:\"sakib@sohub.com.bd\";}}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7v5m332ml9ajfq3jlailjpbvujfkg8u9', '103.180.244.161', 1699294072, '__ci_last_regenerate|i:1699294072;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7v8f77s9ufnattim82rclpggnaj9ma9o', '103.180.244.161', 1698933182, '__ci_last_regenerate|i:1698933182;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('833ujpa1toeab843q2ab6479d6sfnl4a', '103.180.244.161', 1699458358, '__ci_last_regenerate|i:1699458358;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('84tdj35h93p05g3j535l2on786kjm4ph', '103.180.244.161', 1698952650, '__ci_last_regenerate|i:1698952650;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('870clbor1q6ut4fg5npcge9fm182kmco', '37.111.228.176', 1699813112, '__ci_last_regenerate|i:1699813112;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:30:\"Call Re-Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('880p8tnshq6i5gron6c86775qcl19bna', '103.83.240.105', 1699505181, '__ci_last_regenerate|i:1699505180;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('89e84vc7sv7ecagkjdt8h97dsb8dcm1b', '103.180.244.161', 1699460342, '__ci_last_regenerate|i:1699460342;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8afqq5c9p8vntj4j31voatjqigk1h5od', '103.180.244.161', 1690803940, '__ci_last_regenerate|i:1690803654;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8assgrhejg9n840dfasnu5qa1gcgf7ec', '103.180.244.161', 1699456347, '__ci_last_regenerate|i:1699456347;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8bd4tt9a7r533up31cm1ukdeffa62hm4', '59.153.100.195', 1695476463, '__ci_last_regenerate|i:1695476463;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:34:\"The Configuration Has Been Updated\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8ctvahuomsj0a7t31mcqnmiqj6qcbqbt', '103.180.244.161', 1699203138, '__ci_last_regenerate|i:1699203138;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8d1rfr40utu2pt9ne68ti5dhv2lan3gf', '103.180.244.161', 1699368975, '__ci_last_regenerate|i:1699368975;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8dghdvg65lv5afv6hlivrsccph1acsc3', '103.170.139.42', 1691569762, '__ci_last_regenerate|i:1691569762;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8dmrf1oajg2q33bg6ac8cpcrpac88jhc', '103.180.244.161', 1699371210, '__ci_last_regenerate|i:1699371210;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:33:\"New Campaign Created Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8eg3mlnrpsgsk3u0kdl4qmg68mh538ga', '103.180.244.161', 1690266418, '__ci_last_regenerate|i:1690266335;redirect_url|s:41:\"http://202.59.208.112/cdc/frontend/slider\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8ekdnd0pod6iavjvtpr0q5oqtoi2co1c', '103.180.244.161', 1699473257, '__ci_last_regenerate|i:1699473257;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8eqee33ibcb5ergpo9bb300uj4sipnke', '103.180.244.161', 1699082657, '__ci_last_regenerate|i:1699082648;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8kov3k1alqken79jv3ogl06tgn9ccbf1', '103.180.244.161', 1699453093, '__ci_last_regenerate|i:1699453093;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8lodt8cgtjsfv1kd5oghnsuks5dmlbf3', '103.180.244.161', 1699457114, '__ci_last_regenerate|i:1699457114;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8mse2tlo860t6646b9jdn00f9g46np5v', '103.180.244.161', 1690785812, '__ci_last_regenerate|i:1690785812;redirect_url|s:35:\"http://202.59.208.112/cdc/dashboard\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8ne2mph0r7dlgq3b758d80vf9scaomo5', '103.180.244.161', 1699205947, '__ci_last_regenerate|i:1699205947;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8okl3i4rc68pselb6gdii8v7h4pk8uso', '37.111.194.187', 1695476875, '__ci_last_regenerate|i:1695476875;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8patrfnirv7rp0n1edr8shaibv15tnbv', '103.180.244.161', 1699287357, '__ci_last_regenerate|i:1699287357;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8s0nqqmdmhu1c90g9drtu5pki1lpmk6g', '37.111.194.187', 1695480226, '__ci_last_regenerate|i:1695480226;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8ssuct2eltj80ksolq59rup1l6rnve62', '103.180.244.161', 1699193533, '__ci_last_regenerate|i:1699193533;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('913hufo9mjkvsof42tr2pb7d2h9ht06m', '103.180.244.161', 1699386885, '__ci_last_regenerate|i:1699386885;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('929pi6albi00348ritlulk5lr7qpggcb', '103.180.244.161', 1698949499, '__ci_last_regenerate|i:1698949499;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('96e833tct23fcnlo9a08r2qb28j43hs9', '103.181.42.122', 1687888461, '__ci_last_regenerate|i:1687888461;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9705fa3qb68nmoi3rugoi1inmvs51shp', '59.153.100.195', 1695482944, '__ci_last_regenerate|i:1695482944;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9ek8122iobvpq9figm854ujvv5tarmlp', '103.180.244.161', 1688648521, '__ci_last_regenerate|i:1688648521;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9hrucdkf20m6846ed3h18hehecb8s17k', '103.180.244.161', 1699455624, '__ci_last_regenerate|i:1699455624;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9jmaq7qedjin4633oobibinjbmj1kdbs', '103.180.244.161', 1699465426, '__ci_last_regenerate|i:1699465426;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9o75kiujkkk7s847afs9snieurk7pr22', '103.180.244.161', 1699283169, '__ci_last_regenerate|i:1699283169;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9qmu1ppar9kug1qikh5rcip8d0hbmsn2', '103.180.244.161', 1699206784, '__ci_last_regenerate|i:1699206784;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9s1pnud9sftro2848equbb3u521b5235', '37.111.194.187', 1695479249, '__ci_last_regenerate|i:1695479249;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9sc04bam41iukupeku8kuhvsrv6qu63r', '103.180.244.161', 1699186828, '__ci_last_regenerate|i:1699186828;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9seja6gsi1jsnrc4cm4smrk0kn168qph', '103.180.244.161', 1699377524, '__ci_last_regenerate|i:1699377524;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9skkbjatgbe540o2gu2qlbbg322he2ie', '103.180.244.161', 1699363693, '__ci_last_regenerate|i:1699363693;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9v2j8kp7fkk9v8lk0829atmtk43jpqpq', '103.180.244.161', 1688648521, '__ci_last_regenerate|i:1688648521;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a1cbm1o34t7rf961fsa69ukkm10mdekk', '103.180.244.161', 1699374770, '__ci_last_regenerate|i:1699374770;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:29:\"Campaign Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a9m17ss6845nki55q0qevomqmuqvklm1', '37.111.194.187', 1695477558, '__ci_last_regenerate|i:1695477558;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('abdghtfh5q7st70sq3htbee9r7eluqbe', '103.180.244.161', 1699205627, '__ci_last_regenerate|i:1699205627;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('abkcsc5s6gmpkunhtshqrtfueimpg3l8', '37.111.228.176', 1699812118, '__ci_last_regenerate|i:1699812118;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aepqrhd7m37t681p265239ikjfjqqvl2', '103.180.244.161', 1699472638, '__ci_last_regenerate|i:1699472638;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ai59o7gmpgp7451j7s7221o5huiq3rb2', '103.180.244.161', 1688623169, '__ci_last_regenerate|i:1688622930;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ajt682j5nhu29pluje23atqsq3vg3549', '103.180.244.161', 1699799733, '__ci_last_regenerate|i:1699799733;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('an19ovql4aekt1o7ujgh4j9fml9m4k0g', '103.180.244.161', 1698865607, '__ci_last_regenerate|i:1698865607;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"spanish\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ane9jirmrbk1cqlon5u0n2enigpj4936', '103.180.244.161', 1698949159, '__ci_last_regenerate|i:1698949159;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('anmdvpqjfsjo1l6jnr1ec749s9ne9fgi', '176.98.217.113', 1696247807, '__ci_last_regenerate|i:1696247807;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('anqe6kpf01ceckarqfheonri4b062c0b', '103.180.244.161', 1699376372, '__ci_last_regenerate|i:1699376372;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:29:\"Campaign Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('apo1l694ag0s0avtg89oitb8f6q1f2s7', '103.180.244.161', 1699389864, '__ci_last_regenerate|i:1699389864;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aq93jp70siqbksmvi6alcmi083m2fr8q', '103.180.244.161', 1699362263, '__ci_last_regenerate|i:1699362263;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aqk22qeep0nahh976lk9m9pg69dlq7rf', '37.111.194.187', 1695478530, '__ci_last_regenerate|i:1695478530;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('arpt6q3nsaq3picd7ev689rcucfvd6he', '103.180.244.161', 1699470519, '__ci_last_regenerate|i:1699470519;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('at69fne70se0ml6sk3egouv7n39lrjc5', '103.180.244.161', 1699561324, '__ci_last_regenerate|i:1699561324;redirect_url|s:55:\"http://202.59.208.112/web_apps/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('atqrgopnlgdv1da0qurvnaotgtbqu1ck', '103.181.42.122', 1687888461, '__ci_last_regenerate|i:1687888461;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('au28dcl0dh35dfk7ber88n1uuunga055', '103.180.244.161', 1698935975, '__ci_last_regenerate|i:1698935975;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:33:\"New Campaign Created Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}file_data|a:8:{i:0;a:4:{i:0;s:12:\"Tanvir Islam\";i:1;s:11:\"8.80174E+12\";i:2;s:11:\"Mohammadpur\";i:3;s:19:\"tanvir@sohub.com.bd\";}i:1;a:4:{i:0;s:15:\"Muyed Moktadir \";i:1;s:11:\"8.80174E+12\";i:2;s:11:\"Mohammadpur\";i:3;s:18:\"muyed@sohub.com.bd\";}i:2;a:4:{i:0;s:12:\"Ariful Islam\";i:1;s:11:\"8.80179E+12\";i:2;s:5:\"Badda\";i:3;s:17:\"rafi@sohub.com.bd\";}i:3;a:4:{i:0;s:9:\"Sagor Mia\";i:1;s:11:\"8.80198E+12\";i:2;s:9:\"Dhanmondi\";i:3;s:18:\"sagor@sohub.com.bd\";}i:4;a:4:{i:0;s:10:\"Sohel Rana\";i:1;s:11:\"8.80193E+12\";i:2;s:13:\"Bosila Bridge\";i:3;s:18:\"sohel@sohub.com.bd\";}i:5;a:4:{i:0;s:14:\"Sakib Shahriar\";i:1;s:11:\"8.80152E+12\";i:2;s:11:\"Mohammadpur\";i:3;s:18:\"sakib@sohub.com.bd\";}i:6;a:4:{i:0;s:15:\"Mahabub Hossain\";i:1;s:11:\"8.80176E+12\";i:2;s:11:\"Mohammadpur\";i:3;s:20:\"mahabub@sohub.com.bd\";}i:7;a:4:{i:0;s:14:\"Sajibur Rahman\";i:1;s:11:\"8.80172E+12\";i:2;s:16:\"Kaderbad Housing\";i:3;s:18:\"sajib@sohub.com.bd\";}}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b0dos3o4i4d6v2kf9hu37ut1tt44f2so', '103.180.244.161', 1699212159, '__ci_last_regenerate|i:1699212159;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b0mpaf6pj7ag4mobb8bujddfqpapc0q6', '103.181.42.122', 1687889310, '__ci_last_regenerate|i:1687889071;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b24s3dasc1lh7e9u6uknrdalvquaiqht', '103.180.244.161', 1699217178, '__ci_last_regenerate|i:1699217178;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b4qgkjbb6oqa4r9b6bos0j20nmag2hrd', '103.180.244.161', 1699368197, '__ci_last_regenerate|i:1699368197;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b5k292ao9864skj5v12ro2diat64l2q8', '103.180.244.161', 1699479399, '__ci_last_regenerate|i:1699479399;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b7jgokqd40bg0p26lufi3716sujnsid7', '103.180.244.161', 1699212307, '__ci_last_regenerate|i:1699212307;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bc7nnsi8svc2t1kc4c9cpdac50vtatqh', '103.180.244.161', 1699370356, '__ci_last_regenerate|i:1699370356;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bk7i8o2c9u1f95qmd36g24nv79i3867c', '103.180.244.161', 1699361457, '__ci_last_regenerate|i:1699361457;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bl7df3g19opoh68noc3a9te6no8u0gtt', '103.197.204.175', 1688283040, '__ci_last_regenerate|i:1688283040;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bnth37ikg9qii2rjh6tphcb6otiu3lri', '103.180.244.161', 1699364199, '__ci_last_regenerate|i:1699364199;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bpo6nm642du3saa9m58bb8nl7ki48803', '103.180.244.161', 1699464339, '__ci_last_regenerate|i:1699464339;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bsfno4ndhm8o3k745rs3d7rnttbbfjrk', '103.180.244.161', 1698934425, '__ci_last_regenerate|i:1698934425;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('bt5c3icffnang6nv2a2skpufm3kq16qr', '103.180.244.161', 1699372821, '__ci_last_regenerate|i:1699372821;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c0bm0ncf3m669g7v2gh2g7ddoesjdpko', '103.180.244.161', 1699281628, '__ci_last_regenerate|i:1699281628;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:21:\" Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c0nv3e7hkmvu2b16e5ia2salsiqmp76g', '103.180.244.161', 1688635271, '__ci_last_regenerate|i:1688635271;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c1869lv8i134k5lghj2gmam2a29bljg7', '103.180.244.161', 1699386861, '__ci_last_regenerate|i:1699385911;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:29:\"Campaign Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c1qgg3v7iga4lp122rqdam8fgeqn4n3m', '103.180.244.161', 1699208490, '__ci_last_regenerate|i:1699208490;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c2hgpbcn7078qrml4l2rkk3g9telvvge', '103.180.244.161', 1690268898, '__ci_last_regenerate|i:1690268859;redirect_url|s:34:\"http://202.59.208.112/cdc/schedule\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c3t8md9crltg8t6poe2lusgcuvtmj28h', '103.180.244.161', 1698954152, '__ci_last_regenerate|i:1698954152;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c4mle4rg0iipimitc568alos80efg7mh', '103.180.244.161', 1699465898, '__ci_last_regenerate|i:1699465898;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c4ulikdtsobmn1nlnndnobm444nqog4u', '59.153.100.214', 1698878787, '__ci_last_regenerate|i:1698878787;redirect_url|s:62:\"http://202.59.208.112/web_apps/contact_center/voice/quick_call\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c5u24n6g88in5svqlh0867vqjht4ru9k', '103.180.244.161', 1699302439, '__ci_last_regenerate|i:1699302439;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c6aih156npoih0ceha0ui9uq8ga39s28', '103.180.244.161', 1699195824, '__ci_last_regenerate|i:1699195824;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c6rd1pupnnfirh78sh0o37dbt02vkg5e', '59.153.100.221', 1699488859, '__ci_last_regenerate|i:1699488858;redirect_url|s:60:\"http://202.59.208.112/web_apps/contact_center/voice/edit/148\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c7f3vqlartcagj546rct5r3fp4sgkcb2', '103.180.244.161', 1690268724, '__ci_last_regenerate|i:1690268693;redirect_url|s:39:\"http://202.59.208.112/cdc/employee/view\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c7nj3k3p67gmsq4uvrlklcrf1t3ne04g', '59.153.100.214', 1699146675, '__ci_last_regenerate|i:1699146675;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c89etuo9plbf9u226r8q3e22hufjlqni', '103.180.244.161', 1699384514, '__ci_last_regenerate|i:1699384498;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c95e54gpa3jubm6ph66858jq5uq6mr2b', '103.180.244.161', 1699463332, '__ci_last_regenerate|i:1699463332;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cf7cku9aabr7e0nh32dqijj8ao0floim', '103.180.244.161', 1698936343, '__ci_last_regenerate|i:1698936343;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:33:\"New Campaign Created Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cg3l9j4rjt3khr49fhqg2f5jb7pviol5', '103.180.244.161', 1699205230, '__ci_last_regenerate|i:1699205230;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ck5knrrv1q579a35c38ahdheik7gjcu0', '103.180.244.161', 1699470695, '__ci_last_regenerate|i:1699470695;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ckoqut7tiv7km171gbj3118b8muf05dv', '103.180.244.161', 1699455001, '__ci_last_regenerate|i:1699455001;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ckvbb3q1i6kq8ov8d2h3g8khc8pl4f92', '59.153.100.214', 1688796663, '__ci_last_regenerate|i:1688796663;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cljcv954cgg6oihl0mr4ko7vk92c41rv', '103.180.244.161', 1698951228, '__ci_last_regenerate|i:1698951228;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cpv33qta2jieqb4js9013vjmae7ln4da', '103.180.244.161', 1699385221, '__ci_last_regenerate|i:1699385221;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:33:\"New Campaign Created Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cr1sdlnj102bigin3fgdgjo3q31brldj', '59.153.100.214', 1699146675, '__ci_last_regenerate|i:1699146675;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cr74fi1ccjbos1bbll7gd2aoj469p9g2', '59.153.100.221', 1699402150, '__ci_last_regenerate|i:1699402150;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('crfff8lunltbijh258am9ifvelsuhn4s', '103.180.244.161', 1698947616, '__ci_last_regenerate|i:1698947616;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('crir8328tl7gc3nqic9j6kdsh5dke8e9', '103.180.244.161', 1698956441, '__ci_last_regenerate|i:1698956441;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d8b3480vqsekor8llpb1jl74bgslu6ce', '103.180.244.161', 1699378358, '__ci_last_regenerate|i:1699378358;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d9asje3pcnkllu9djsem0nksl0qgn30r', '103.180.244.161', 1699792680, '__ci_last_regenerate|i:1699792678;redirect_url|s:55:\"http://202.59.208.112/web_apps/contact_center/dashboard\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('da65hegu7d9qikvt3e396cri9nvllu4r', '103.180.244.161', 1698935015, '__ci_last_regenerate|i:1698935015;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dbdj3dcjvg9kfsbrdopkkg4lpmtf9ljs', '103.180.244.161', 1699202292, '__ci_last_regenerate|i:1699202292;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dci6ge3uirmrncm4j5ebq0kgkbk586es', '103.180.244.161', 1699451118, '__ci_last_regenerate|i:1699451118;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dci6ph9ov0ntqcu0k5hn0bf0tu4frpfr', '103.180.244.161', 1699384005, '__ci_last_regenerate|i:1699384005;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:29:\"Campaign Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dcmm8rnkn77939lctr33s9csclvl48as', '103.180.244.161', 1699218399, '__ci_last_regenerate|i:1699218399;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ddlnds9g1f0vsvak60ji89i42s59qulv', '103.180.244.161', 1699216256, '__ci_last_regenerate|i:1699216256;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('det3cfq73iso2k2r4harsoikfr6j8pn1', '103.180.244.161', 1699475375, '__ci_last_regenerate|i:1699475375;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dfc70ouu65vdkaqp08ivs4o8atbuehgq', '103.197.204.175', 1688298231, '__ci_last_regenerate|i:1688298231;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dgfqr5ournvks715nce2m68mfeoj9e8o', '103.180.244.161', 1699215569, '__ci_last_regenerate|i:1699215569;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dhtndt6s9ih4258ouabare50b904t4gk', '103.180.244.161', 1699188092, '__ci_last_regenerate|i:1699188092;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dnq2p0l5ekidheqnoe8keqru95hpelct', '103.180.244.161', 1699206291, '__ci_last_regenerate|i:1699206291;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('dovjof3ecqqqssr435a0rq924m2e6b2j', '37.111.194.187', 1695478872, '__ci_last_regenerate|i:1695478872;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e07fuq5st1q5d3qd8tl9nj73b2ed0mhq', '103.180.244.161', 1699372161, '__ci_last_regenerate|i:1699372161;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e0cvq3dj3qp6g130jlvqmcobs55pktlm', '103.180.244.161', 1699474595, '__ci_last_regenerate|i:1699474595;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e2j4mr0sosq0jfvsht9l11p6gom0ur0q', '43.245.232.69', 1691582001, '__ci_last_regenerate|i:1691582001;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e3qso7klchpmj8laj9rvk461lds3ijsh', '103.180.244.161', 1690803654, '__ci_last_regenerate|i:1690803654;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e4q36j5pnqim16dfpg9pot2b5i9fsvgo', '37.111.226.24', 1687889817, '__ci_last_regenerate|i:1687889817;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e5em653blklls5oqalg67ec2b2tfk66m', '103.180.244.161', 1698947996, '__ci_last_regenerate|i:1698947996;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e90309ec1ja2hj37pl3b5jldibiejut8', '103.180.244.161', 1699800505, '__ci_last_regenerate|i:1699800505;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e96jngqc7095krccgi480dnna4ivr5bg', '103.180.244.161', 1699361966, '__ci_last_regenerate|i:1699361966;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e975o5hir4eg4crn5rrbkfu8lrc64vv8', '103.180.244.161', 1699373185, '__ci_last_regenerate|i:1699373185;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e9taaiv068tec08n308shpdqboao2tt5', '103.180.244.161', 1699371481, '__ci_last_regenerate|i:1699371481;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ea71galh339m8nfhnt6g77jkqtmen66k', '103.180.244.161', 1699463365, '__ci_last_regenerate|i:1699463365;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('eb74vni3som5cuqrce2n65n9gdc5er7r', '103.180.244.161', 1698867736, '__ci_last_regenerate|i:1698867736;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:34:\"The Configuration Has Been Updated\";__ci_vars|a:2:{s:21:\"alert-message-success\";s:3:\"old\";s:6:\"active\";s:3:\"old\";}active|i:3;file_data|a:6:{i:0;a:4:{i:0;s:12:\"Tanvir Islam\";i:1;s:13:\"8801744733133\";i:2;s:11:\"Mohammadpur\";i:3;s:19:\"tanvir@sohub.com.bd\";}i:1;a:4:{i:0;s:15:\"Muyed Moktadir \";i:1;s:13:\"8801738505555\";i:2;s:11:\"Mohammadpur\";i:3;s:18:\"muyed@sohub.com.bd\";}i:2;a:4:{i:0;s:12:\"Ariful Islam\";i:1;s:13:\"8801789825487\";i:2;s:5:\"Badda\";i:3;s:17:\"rafi@sohub.com.bd\";}i:3;a:4:{i:0;s:9:\"Sagor Mia\";i:1;s:13:\"8801977255355\";i:2;s:9:\"Dhanmondi\";i:3;s:18:\"sagor@sohub.com.bd\";}i:4;a:4:{i:0;s:10:\"Sohel Rana\";i:1;s:13:\"8801929622723\";i:2;s:13:\"Bosila Bridge\";i:3;s:18:\"sohel@sohub.com.bd\";}i:5;a:4:{i:0;s:14:\"Sakib Shahriar\";i:1;s:13:\"8801517088093\";i:2;s:11:\"Mohammadpur\";i:3;s:18:\"sakib@sohub.com.bd\";}}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ehrpba7jecruf5hqell5c1spuao2mqsh', '103.180.244.161', 1699282826, '__ci_last_regenerate|i:1699282826;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ekk5cefs4u89tele6n4iavs3a2330leh', '103.180.244.161', 1699795452, '__ci_last_regenerate|i:1699795452;redirect_url|s:55:\"http://202.59.208.112/web_apps/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;file_data|a:6:{i:0;a:4:{i:0;s:12:\"Tanvir Islam\";i:1;s:13:\"8801744733133\";i:2;s:11:\"Mohammadpur\";i:3;s:19:\"tanvir@sohub.com.bd\";}i:1;a:4:{i:0;s:15:\"Muyed Moktadir \";i:1;s:13:\"8801738505555\";i:2;s:11:\"Mohammadpur\";i:3;s:18:\"muyed@sohub.com.bd\";}i:2;a:4:{i:0;s:12:\"Ariful Islam\";i:1;s:13:\"8801789825487\";i:2;s:5:\"Badda\";i:3;s:17:\"rafi@sohub.com.bd\";}i:3;a:4:{i:0;s:9:\"Sagor Mia\";i:1;s:13:\"8801977255355\";i:2;s:9:\"Dhanmondi\";i:3;s:18:\"sagor@sohub.com.bd\";}i:4;a:4:{i:0;s:10:\"Sohel Rana\";i:1;s:13:\"8801929622723\";i:2;s:13:\"Bosila Bridge\";i:3;s:18:\"sohel@sohub.com.bd\";}i:5;a:4:{i:0;s:14:\"Sakib Shahriar\";i:1;s:13:\"8801517088093\";i:2;s:11:\"Mohammadpur\";i:3;s:18:\"sakib@sohub.com.bd\";}}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('el7im7l70cedrlq2el9h0ndcrrrt2e7l', '37.111.228.176', 1699815991, '__ci_last_regenerate|i:1699815991;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:30:\"Call Re-Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('encqs9tovchforjmd30cbqeh4111f52k', '103.170.139.42', 1691568967, '__ci_last_regenerate|i:1691568967;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('enka7n6pfrgu7n497sud1t0im44qb5bu', '103.180.244.161', 1698934108, '__ci_last_regenerate|i:1698934108;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('eptek984djvmqk6klofmrbfuq5qbs3jc', '103.180.244.161', 1699203877, '__ci_last_regenerate|i:1699203877;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('erfqcmnvam28o8jt8ueg7so3d8057scd', '103.180.244.161', 1699194636, '__ci_last_regenerate|i:1699194636;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('evsqdf1omuf9qrpthtifodo73qbuoe3r', '103.180.244.161', 1698954922, '__ci_last_regenerate|i:1698954922;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f024f08acki2qcc2rguvfr6rjh083ng2', '103.180.244.161', 1699448009, '__ci_last_regenerate|i:1699448009;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f030095d6fl8e2sgue4bpfau5ap634jr', '176.98.217.113', 1696247867, '__ci_last_regenerate|i:1696247807;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"spanish\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f2sj5gjema265p46v6td0fv5sipc375d', '103.180.244.161', 1699207781, '__ci_last_regenerate|i:1699207781;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f77e0jpglgbrugptcioeu9gvbqpavfab', '103.180.244.161', 1698947454, '__ci_last_regenerate|i:1698947453;redirect_url|s:61:\"http://202.59.208.112/web_apps/contact_center/voice/callerids\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f8ps0uj9qgadeh1eqgq1np3fhmh93ljb', '103.180.244.161', 1699374337, '__ci_last_regenerate|i:1699374337;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:29:\"Campaign Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f9hvc9kpnlivvqaj5ml93b2h7javboks', '103.180.244.161', 1699538043, '__ci_last_regenerate|i:1699538043;redirect_url|s:55:\"http://202.59.208.112/web_apps/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fa64rlshuu74m216hgeum3b68jj2v1qb', '103.180.244.161', 1699465784, '__ci_last_regenerate|i:1699465784;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fa6p3fs388dulo8k2vnl9tnekbmt1mrk', '103.180.244.161', 1699200419, '__ci_last_regenerate|i:1699200419;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ffc3jfa4v6s9006ris5u5q7sp2fle910', '103.180.244.161', 1692255657, '__ci_last_regenerate|i:1692255620;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ffggpe054t9e3erjvt5dd90on6ocmldf', '103.180.244.161', 1699795124, '__ci_last_regenerate|i:1699795124;redirect_url|s:55:\"http://202.59.208.112/web_apps/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;file_data|a:6:{i:0;a:4:{i:0;s:12:\"Tanvir Islam\";i:1;s:13:\"8801744733133\";i:2;s:11:\"Mohammadpur\";i:3;s:19:\"tanvir@sohub.com.bd\";}i:1;a:4:{i:0;s:15:\"Muyed Moktadir \";i:1;s:13:\"8801738505555\";i:2;s:11:\"Mohammadpur\";i:3;s:18:\"muyed@sohub.com.bd\";}i:2;a:4:{i:0;s:12:\"Ariful Islam\";i:1;s:13:\"8801789825487\";i:2;s:5:\"Badda\";i:3;s:17:\"rafi@sohub.com.bd\";}i:3;a:4:{i:0;s:9:\"Sagor Mia\";i:1;s:13:\"8801977255355\";i:2;s:9:\"Dhanmondi\";i:3;s:18:\"sagor@sohub.com.bd\";}i:4;a:4:{i:0;s:10:\"Sohel Rana\";i:1;s:13:\"8801929622723\";i:2;s:13:\"Bosila Bridge\";i:3;s:18:\"sohel@sohub.com.bd\";}i:5;a:4:{i:0;s:14:\"Sakib Shahriar\";i:1;s:13:\"8801517088093\";i:2;s:11:\"Mohammadpur\";i:3;s:18:\"sakib@sohub.com.bd\";}}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fg6qdpn50435dmhovha3uph849k53m1a', '103.180.244.161', 1699473407, '__ci_last_regenerate|i:1699473407;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fgie0he90pqin9j2h8vo7d9me8d6mgh4', '103.197.204.175', 1687936505, '__ci_last_regenerate|i:1687936505;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fgtcvk0rl5b2n8nt4kpknmknajs675jl', '103.180.244.161', 1699470202, '__ci_last_regenerate|i:1699470202;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fh20ug4ajbsul3bgb80vm2tondop04e7', '103.180.244.161', 1699451945, '__ci_last_regenerate|i:1699451945;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fiso58mbhglcpo8oggdsg7kf2l276ovf', '103.180.244.161', 1699465774, '__ci_last_regenerate|i:1699465774;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('flqo0t5uv0phghbjbucj65r2v041rh0e', '103.180.244.161', 1699465126, '__ci_last_regenerate|i:1699465126;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fno4h99e93b5s54q5g15jcpdiu68avtg', '103.180.244.161', 1699463043, '__ci_last_regenerate|i:1699463043;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fos2hb755btb75qsgkdf6nt4iso54gt4', '103.180.244.161', 1699377415, '__ci_last_regenerate|i:1699377415;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:29:\"Campaign Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fpkanulhs4qehvl272jhceg7245rs7dc', '37.111.194.187', 1695478166, '__ci_last_regenerate|i:1695478166;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fu3pplumnbv7omtcjifd0bgou2s0pu1j', '103.180.244.161', 1699451950, '__ci_last_regenerate|i:1699451950;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fvnh6vl6kqid8b3o55k1e977ckf42quv', '103.180.244.161', 1699204203, '__ci_last_regenerate|i:1699204203;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('g0fvt0jvuplqanb35ak8a81dvs8no2gj', '37.111.194.187', 1695483959, '__ci_last_regenerate|i:1695483959;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('g2enh3rngtual3kdqev5qm5vj297oo7a', '103.180.244.161', 1698865931, '__ci_last_regenerate|i:1698865931;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"spanish\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('g68t12h4gci2mu7ojv2h9av2v3e7pn54', '202.173.120.132', 1691570481, '__ci_last_regenerate|i:1691570481;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('g6lletv4kors39esab2me7305nl9el8d', '103.180.244.161', 1699377920, '__ci_last_regenerate|i:1699377920;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('g7jgc26658irnssue4gh96u6kdmr998s', '59.153.100.221', 1699306265, '__ci_last_regenerate|i:1699306253;redirect_url|s:62:\"http://202.59.208.112/web_apps/contact_center/voice/quick_call\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gc75h5v67kl8kadscuo37t669jabhjo7', '103.180.244.161', 1698936364, '__ci_last_regenerate|i:1698936364;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('geutbp20jhda7i5ptrth2mgdsqp7v14k', '103.180.244.161', 1699370792, '__ci_last_regenerate|i:1699370792;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:21:\" Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ggdocrbahnsi2rnr2p5bn97lvr3npql2', '103.180.244.161', 1699478212, '__ci_last_regenerate|i:1699478212;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ggvn7m3al6s16j4r6t51nbg1l7rddrh3', '59.153.100.204', 1695488786, '__ci_last_regenerate|i:1695488786;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ghhpse60n3qjbnd9254lml8ap2i02525', '103.180.244.161', 1699209491, '__ci_last_regenerate|i:1699209491;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gj10eqma7tk5ed4h0dgm3s4ip5i067ri', '103.181.42.122', 1699323336, '__ci_last_regenerate|i:1699323336;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gk039d4m0drum4ocv4iivteklg5oopsp', '103.180.244.161', 1699206959, '__ci_last_regenerate|i:1699206959;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gk8e2i69o58243bttra5g4pu3g06f0kh', '103.180.244.161', 1699449658, '__ci_last_regenerate|i:1699449658;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gqkfbpksfgi4oaq6t9htoj2rfdit6nst', '103.180.244.161', 1699217815, '__ci_last_regenerate|i:1699217815;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:21:\" Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gscb6u791s10kk3t6niqthdn3jnldbv5', '103.180.244.161', 1699452642, '__ci_last_regenerate|i:1699452642;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('gtpat448dn4sfjc172tdek056067rard', '103.180.244.161', 1699472337, '__ci_last_regenerate|i:1699472337;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h1jteijpm9rcv0vgj4p8mud34adf2mhe', '103.180.244.161', 1699291775, '__ci_last_regenerate|i:1699291590;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h4m4j75gnrvi4cs5922vr3tmrqbt0es0', '103.180.244.161', 1699206204, '__ci_last_regenerate|i:1699206204;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h65fgcu2befmgjpt1hf2gocdlejou912', '103.180.244.161', 1699471246, '__ci_last_regenerate|i:1699471246;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h6bn7d6amvea23ia2g7hjuvipkd0ceup', '103.180.244.161', 1699456828, '__ci_last_regenerate|i:1699456828;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hc8rjf9q9ih9m7hoas2msi6kpigp0fbb', '103.180.244.161', 1699452263, '__ci_last_regenerate|i:1699452263;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('he9ii6csig614550altfdhnma08qnvi5', '103.180.244.161', 1699194937, '__ci_last_regenerate|i:1699194937;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('heotr187n7vv8h1q1jtgpgi3um0ntk1e', '103.180.244.161', 1699371517, '__ci_last_regenerate|i:1699371517;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:33:\"New Campaign Created Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hfof08v664ojb9ig2cmrv7heatoegmg6', '103.180.244.161', 1695569409, '__ci_last_regenerate|i:1695569341;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hgftlrdu7vl8ho7vajud6e134g8j51le', '103.180.244.161', 1699800816, '__ci_last_regenerate|i:1699800816;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hgs7u8g2n3ur8n1q10bu47uq5mr813ql', '103.180.244.161', 1699206650, '__ci_last_regenerate|i:1699206650;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hh14ngjdeuc6gv6ndeir7cjd4bvhasol', '103.180.244.161', 1698955783, '__ci_last_regenerate|i:1698955783;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hhcc9nedjrc5l0dct01sbmh6oagb6ao6', '103.180.244.161', 1698865221, '__ci_last_regenerate|i:1698865221;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"spanish\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hhl8av02tf37p5dpaql6k3n8lqk3v694', '103.180.244.161', 1699203445, '__ci_last_regenerate|i:1699203445;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hiv6i1e4dkadi9lmrgqbts1jis85lk51', '103.180.244.161', 1699293561, '__ci_last_regenerate|i:1699293561;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hkcagpa55ojj3657v1vl17k72a9b0e1d', '103.180.244.161', 1698939543, '__ci_last_regenerate|i:1698939543;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hm3sc9kgtv1vifc7rn2p4cjeqq5s6u99', '103.180.244.161', 1699376723, '__ci_last_regenerate|i:1699376723;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:29:\"Campaign Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hpd87m96nhp4ddcfp01p4ft3lula4tmr', '103.180.244.161', 1699204739, '__ci_last_regenerate|i:1699204739;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hrlfa4sdco7buproo2h0snfugtc71jts', '103.180.244.161', 1698953777, '__ci_last_regenerate|i:1698953777;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('hvv0il3bgaufgo57edn734iv16anvhue', '103.180.244.161', 1699471315, '__ci_last_regenerate|i:1699471315;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('i0bsml0vvgvunfrb7melm72ua0duvmfi', '103.180.244.161', 1699463979, '__ci_last_regenerate|i:1699463979;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('i19tbik1l4leh7gj9gmfv0m0ar83l8bn', '103.180.244.161', 1699466095, '__ci_last_regenerate|i:1699466095;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('i23t3h2u2capq8027u33pun0m09h1773', '103.180.244.161', 1699383273, '__ci_last_regenerate|i:1699383273;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:29:\"Campaign Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('i3ukto0763v9ikbloab2e1blfv838v9v', '103.180.244.161', 1699538385, '__ci_last_regenerate|i:1699538385;redirect_url|s:55:\"http://202.59.208.112/web_apps/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('i4t27si0q4dnf5866l8gao0upbd7dlg8', '103.180.244.161', 1699474595, '__ci_last_regenerate|i:1699474595;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('i5h3k7due3gnbj64l0jjd3ai2t644grm', '103.180.244.161', 1699301225, '__ci_last_regenerate|i:1699301217;redirect_url|s:55:\"http://202.59.208.112/web_apps/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('i9drugg6hbcrneu2i625484kt9s592q8', '103.180.244.161', 1699385578, '__ci_last_regenerate|i:1699385578;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:33:\"New Campaign Created Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('iarkm02ert9cmc8p24aul53i6hqhrj7m', '103.180.244.161', 1699282504, '__ci_last_regenerate|i:1699282504;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('icpkjkrehk1bsgf3bqcrtj6c7icin4i9', '103.180.244.161', 1699370417, '__ci_last_regenerate|i:1699370417;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:21:\" Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('iehctq4jn1km69nb67p3bjpludqqaulb', '103.180.244.161', 1699294962, '__ci_last_regenerate|i:1699294962;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('iem5vr3p3lp0i55vl94hd5urqgj81gqk', '103.180.244.161', 1699197001, '__ci_last_regenerate|i:1699197001;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('if9j0r31ej0ccebl0ckmgma62h9sf6dv', '103.180.244.161', 1699455323, '__ci_last_regenerate|i:1699455323;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ifp4a7tcba9c7f652f2upp1baa6s06ql', '103.180.244.161', 1699382733, '__ci_last_regenerate|i:1699382733;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:29:\"Campaign Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ijf765rnuknt3ovo2cfpr04pr68a16qb', '103.180.244.161', 1698943022, '__ci_last_regenerate|i:1698943022;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ikmt950702501f7l8hb7e59d5pr5acva', '103.180.244.161', 1699450078, '__ci_last_regenerate|i:1699450078;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ilkrkvck2vlibdu2bviabqd48i86ou60', '103.180.244.161', 1699207729, '__ci_last_regenerate|i:1699207729;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('in6n794i44qevasnf940p7ffek89mcqr', '103.180.244.161', 1699794890, '__ci_last_regenerate|i:1699794808;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:33:\"New Campaign Created Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ipgsjlugc1l76n0vvpuagegnjvcf5p38', '103.180.244.161', 1699799155, '__ci_last_regenerate|i:1699799155;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ipkm83eb47kdbkdl892q826khj82bbgk', '103.180.244.161', 1699467606, '__ci_last_regenerate|i:1699467606;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('iqejtia60hskp9nmm59om4c7dfnurs64', '103.180.244.161', 1699360913, '__ci_last_regenerate|i:1699360913;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('is18441oao2uvbdr1nvfgbnvml1armnc', '103.180.244.161', 1699201869, '__ci_last_regenerate|i:1699201610;redirect_url|s:62:\"http://202.59.208.112/web_apps/contact_center/voice/quick_call\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('is1ov03c5j6g8e12phd46vltrro6lg8t', '103.180.244.161', 1699302481, '__ci_last_regenerate|i:1699302439;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('isgqlr78vodln7adt38n6fbe18kn8cfe', '103.180.244.161', 1698866964, '__ci_last_regenerate|i:1698866964;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"spanish\";loggedin|b:1;file_data|a:8:{i:0;a:2:{i:0;s:13:\"8801738505555\";i:1;s:20:\"test_voice_broadcast\";}i:1;a:2:{i:0;s:13:\"8801922036882\";i:1;s:20:\"test_voice_broadcast\";}i:2;a:2:{i:0;s:13:\"8801918562760\";i:1;s:20:\"test_voice_broadcast\";}i:3;a:2:{i:0;s:13:\"8801789825487\";i:1;s:20:\"test_voice_broadcast\";}i:4;a:2:{i:0;s:13:\"8801744733133\";i:1;s:20:\"test_voice_broadcast\";}i:5;a:2:{i:0;s:13:\"8801718768245\";i:1;s:20:\"test_voice_broadcast\";}i:6;a:2:{i:0;s:13:\"8801517088093\";i:1;s:20:\"test_voice_broadcast\";}i:7;a:2:{i:0;s:13:\"8801977255355\";i:1;s:20:\"test_voice_broadcast\";}}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('it0gjv9j89maiiq84d4a81n4jmuua7tf', '103.180.244.161', 1699467185, '__ci_last_regenerate|i:1699467185;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('iunll7669ugm8mhc6iacbuubjr2lvlim', '103.180.244.161', 1699383299, '__ci_last_regenerate|i:1699383299;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('j0qcmgv3sh060h6tt90v91tdgfdaketo', '103.180.244.161', 1698943797, '__ci_last_regenerate|i:1698943797;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('j5q1d3fhpn02p46d09mqbts5n7rlotvq', '103.180.244.161', 1699205780, '__ci_last_regenerate|i:1699205780;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('j89m0bjns9re8v19g8q2r5ncs5hakcqa', '103.180.244.161', 1688466054, '__ci_last_regenerate|i:1688466026;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ja6i0a93d45jsc9fk39blopc1aphvf5r', '103.180.244.161', 1699369487, '__ci_last_regenerate|i:1699369487;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jajb4h65csr8g4un4prlr4acj0gtlc75', '103.180.244.161', 1698937624, '__ci_last_regenerate|i:1698937624;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jamhunq5eok43r402gl29rbmemv2p2qq', '103.180.244.161', 1698935672, '__ci_last_regenerate|i:1698935672;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:33:\"New Campaign Created Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('je319otpieakhhdagque91h8u2sl82j6', '103.180.244.161', 1699278164, '__ci_last_regenerate|i:1699278164;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jfrgq0p64bjddohkk5ea23eab1cqtfnd', '103.180.244.161', 1698950880, '__ci_last_regenerate|i:1698950880;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jjdqn8srtcstjtctph3hs9r0745qjd47', '103.180.244.161', 1691473795, '__ci_last_regenerate|i:1691473499;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jju774v5d2bptstbg8thnpfsv1tmpovl', '59.153.100.221', 1699635181, '__ci_last_regenerate|i:1699635178;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jluuigegutaglaveloehm6l2einbc1ko', '103.180.244.161', 1688638237, '__ci_last_regenerate|i:1688638237;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jng3i3fhbr1lu0sm9h8pnsuqv8cjt9ea', '103.180.244.161', 1699299646, '__ci_last_regenerate|i:1699299646;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jpehg8o91brpjt02a92ls0262arlneaa', '103.180.244.161', 1699369661, '__ci_last_regenerate|i:1699369661;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jqj7sdr6ed9fe40ts5q1vhm3fbvgtlj7', '103.180.244.161', 1699370973, '__ci_last_regenerate|i:1699370973;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('js57fecrt52jc76blrs24pbrem9c838c', '103.180.244.161', 1699385911, '__ci_last_regenerate|i:1699385911;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:33:\"New Campaign Created Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jtp206ore6bkjt1v6c3egfu8trjicdni', '103.180.244.161', 1699213346, '__ci_last_regenerate|i:1699213346;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k09lo8sabcjm4jkgsb3ut5sal469tutt', '37.111.221.77', 1687889380, '__ci_last_regenerate|i:1687889368;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k1khf0q1evidlah67926nqbslvib127u', '103.180.244.161', 1699214949, '__ci_last_regenerate|i:1699214949;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k2t67btifc0nmv9c8i41fd49r9dvudij', '103.180.244.161', 1699299189, '__ci_last_regenerate|i:1699299189;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k2vuv277otr67rtok6k3mg9oogp7bme9', '103.180.244.161', 1699364002, '__ci_last_regenerate|i:1699364002;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k6ik3c90bojj0lh9vmvm0nffo6umd5cq', '103.181.42.122', 1688683151, '__ci_last_regenerate|i:1688683151;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k97m215jladrcikltnrqf3ivalmg8q5q', '59.153.100.214', 1688793113, '__ci_last_regenerate|i:1688793085;redirect_url|s:48:\"http://202.59.208.112/call_buffer_v2/call_report\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('k9abjdoi243rdq4m4gj44copdsqgbigt', '103.180.244.161', 1699448866, '__ci_last_regenerate|i:1699448866;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kapdr1ef6r5050q78flfd6lnumubjeln', '103.180.244.161', 1698869244, '__ci_last_regenerate|i:1698869244;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kc8anhof71acrg9fes6jr4td2rkhm4q5', '103.180.244.161', 1699389864, '__ci_last_regenerate|i:1699389864;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kcb56fb13fn9e7kbuh2ievgu2b896u9q', '103.180.244.161', 1699477069, '__ci_last_regenerate|i:1699477069;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('keprd3ipbt64oq8l7bf962va3gdk8crh', '103.180.244.161', 1699469665, '__ci_last_regenerate|i:1699469665;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('keuutjeg2e2lkblcqkbmeb3h4di9nbjb', '103.180.244.161', 1699367139, '__ci_last_regenerate|i:1699367139;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kf4qqn0i9bf20ol8hn1k9kkgsajhc8bk', '103.180.244.161', 1699791815, '__ci_last_regenerate|i:1699791815;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kg50em1ob3uav00e9a8240tadbkirkp8', '103.180.244.161', 1699188957, '__ci_last_regenerate|i:1699188957;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ki5l6sjdch3kunf10fmcg5uli6jh6oep', '103.180.244.161', 1699469654, '__ci_last_regenerate|i:1699469654;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ktv650igg8tdfcjpr0le9bpalu1nkshf', '103.180.244.161', 1699286330, '__ci_last_regenerate|i:1699286330;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('kvcm2e81muua9siigvr01tb4spm016bg', '103.180.244.161', 1698953406, '__ci_last_regenerate|i:1698953406;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l3eis7l3srofb7rojvbu7mn7iskmlp15', '103.180.244.161', 1699456046, '__ci_last_regenerate|i:1699456046;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('l42vn8j11n9f7t6i0q8dj7m1cab943lf', '103.180.244.161', 1699472616, '__ci_last_regenerate|i:1699472616;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('las3qtq8gfhqacuvc36b6e0ho7fjkur7', '103.180.244.161', 1698945996, '__ci_last_regenerate|i:1698945996;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('le6ji43e4jq3l59hhgkinjs7k5gfkdpi', '103.180.244.161', 1699369295, '__ci_last_regenerate|i:1699369295;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('llcia2a58vna25utrd3bqkub9mi991c5', '103.180.244.161', 1699791224, '__ci_last_regenerate|i:1699791224;redirect_url|s:55:\"http://202.59.208.112/web_apps/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lm2b84nom8ec2hspvl24nk0r3eioqc6a', '103.180.244.161', 1699461220, '__ci_last_regenerate|i:1699461220;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lnicg4ejmdm3ndgl5vrilbo8398kldss', '103.180.244.161', 1699211928, '__ci_last_regenerate|i:1699211928;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ltaq4d5kkdleesrgu02daai56qnn3uks', '103.180.244.161', 1698940770, '__ci_last_regenerate|i:1698940770;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lupd2isvttb9dcl9hfihjbukd7mgc4h4', '103.180.244.161', 1698949830, '__ci_last_regenerate|i:1698949830;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('luskf2o5o5u4ga2lmv8dt461hllth72n', '103.180.244.161', 1699561870, '__ci_last_regenerate|i:1699561870;redirect_url|s:55:\"http://202.59.208.112/web_apps/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lvbsbtilm18alujn1usjjq8mindrojon', '103.180.244.161', 1698945357, '__ci_last_regenerate|i:1698945357;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('m02s6v417bdmbmgl3krm04cnreo946ah', '103.180.244.161', 1699466398, '__ci_last_regenerate|i:1699466398;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('m1lbnea302o9nvge97lnpa6fj383ugpb', '103.180.244.161', 1699368649, '__ci_last_regenerate|i:1699368649;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('m2r1d029loht1ro6b3teu4j5mqjagl9i', '103.180.244.161', 1699371825, '__ci_last_regenerate|i:1699371825;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:33:\"New Campaign Created Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('m5nkbvoc5fkvllbubpr80e9d4berph7e', '37.111.221.77', 1687889368, '__ci_last_regenerate|i:1687889368;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('m5va8gj62k2m0d2r0sr09moi26pk5t9a', '103.180.244.161', 1699802064, '__ci_last_regenerate|i:1699802064;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('m79sp8268ktf1ov38q63ibqbfnkm52t2', '103.180.244.161', 1699549236, '__ci_last_regenerate|i:1699549235;redirect_url|s:62:\"http://202.59.208.112/web_apps/contact_center/voice/quick_call\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('m80a72qrici3s41v1fhgq7fh61hbimll', '103.130.118.6', 1691594718, '__ci_last_regenerate|i:1691594717;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('m8u7qdis0dvv4lasl64g65baoss98kq8', '103.180.244.161', 1699217105, '__ci_last_regenerate|i:1699217105;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mao16dgnqmjmka9vef1v9q8dgiom21ja', '103.180.244.161', 1699375713, '__ci_last_regenerate|i:1699375713;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:29:\"Campaign Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mbcpqt3c13abqri97ir56b63rk3ra82a', '103.180.244.161', 1699537738, '__ci_last_regenerate|i:1699537738;redirect_url|s:55:\"http://202.59.208.112/web_apps/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mbgngke4a0b0c46949vbqfikbnnvj97t', '103.180.244.161', 1698956945, '__ci_last_regenerate|i:1698956825;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('me116t9fmgaeggdjob3pkkcn5srksh2n', '103.180.244.161', 1699208603, '__ci_last_regenerate|i:1699208603;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mg9fii15pjqg2ecci4o5o2f0hohf9v1r', '103.180.244.161', 1699468014, '__ci_last_regenerate|i:1699468014;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mgpq19efmt7av9req5e6p4urt621vi2g', '103.180.244.161', 1699209844, '__ci_last_regenerate|i:1699209844;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mjf322auc3o2uloda0f6ketvtpqp2o91', '103.180.244.161', 1698946301, '__ci_last_regenerate|i:1698946301;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mo6jhbc4ce5lmu6f8o9rkvpe93p2gqk4', '103.180.244.161', 1699793003, '__ci_last_regenerate|i:1699793003;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mpo75b3191078kg7mj9m81ob851k2q37', '103.180.244.161', 1699385465, '__ci_last_regenerate|i:1699385465;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mq0f86s3hv6vigebj96n607s4krp4dgf', '103.180.244.161', 1698868462, '__ci_last_regenerate|i:1698868462;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:34:\"The Configuration Has Been Updated\";__ci_vars|a:2:{s:21:\"alert-message-success\";s:3:\"old\";s:6:\"active\";s:3:\"old\";}active|i:3;file_data|a:6:{i:0;a:4:{i:0;s:12:\"Tanvir Islam\";i:1;s:13:\"8801744733133\";i:2;s:11:\"Mohammadpur\";i:3;s:19:\"tanvir@sohub.com.bd\";}i:1;a:4:{i:0;s:15:\"Muyed Moktadir \";i:1;s:13:\"8801738505555\";i:2;s:11:\"Mohammadpur\";i:3;s:18:\"muyed@sohub.com.bd\";}i:2;a:4:{i:0;s:12:\"Ariful Islam\";i:1;s:13:\"8801789825487\";i:2;s:5:\"Badda\";i:3;s:17:\"rafi@sohub.com.bd\";}i:3;a:4:{i:0;s:9:\"Sagor Mia\";i:1;s:13:\"8801977255355\";i:2;s:9:\"Dhanmondi\";i:3;s:18:\"sagor@sohub.com.bd\";}i:4;a:4:{i:0;s:10:\"Sohel Rana\";i:1;s:13:\"8801929622723\";i:2;s:13:\"Bosila Bridge\";i:3;s:18:\"sohel@sohub.com.bd\";}i:5;a:4:{i:0;s:14:\"Sakib Shahriar\";i:1;s:13:\"8801517088093\";i:2;s:11:\"Mohammadpur\";i:3;s:18:\"sakib@sohub.com.bd\";}}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mquab12r14t12pfr9a5d7ah3guef6n3k', '103.180.244.161', 1699187152, '__ci_last_regenerate|i:1699187152;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mribg65i7n6umbgja56d23hmu9mgffa8', '103.180.244.161', 1698950136, '__ci_last_regenerate|i:1698950136;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mu9eqn996odf5019mqs4ku8lq1fepvmq', '103.180.244.161', 1699473876, '__ci_last_regenerate|i:1699473876;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('n08qbv2h3e7nium8dhbcm8juu7ajfgq8', '103.181.42.122', 1688683238, '__ci_last_regenerate|i:1688683151;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('n2jrc258g9k9ersoja23ops0ghqtprtq', '59.153.100.221', 1699402150, '__ci_last_regenerate|i:1699402150;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('n3os2jgmkqpbd2dec6hh863ses0dug75', '37.111.194.187', 1695477865, '__ci_last_regenerate|i:1695477865;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('n63ivlqjn4481fkn1rl5p025v1dfmc9t', '103.180.244.161', 1699798268, '__ci_last_regenerate|i:1699798268;redirect_url|s:55:\"http://202.59.208.112/web_apps/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('n9149ogi996vrptbu27um52c4h6tuovt', '103.180.244.161', 1699281971, '__ci_last_regenerate|i:1699281971;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('na90ltf6dqvtd8ft13gjat3gh67k7f8b', '103.180.244.161', 1699454298, '__ci_last_regenerate|i:1699454298;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nf347d2pbvci2q9h1mr05io294saarjb', '103.180.244.161', 1699299950, '__ci_last_regenerate|i:1699299950;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nfegnj4nprkvjn5t2h66lmdsuass7c5p', '103.180.244.161', 1699283487, '__ci_last_regenerate|i:1699283487;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nggnc3km9m7a347resr538s3mmpnbed9', '103.187.94.109', 1696090655, '__ci_last_regenerate|i:1696090478;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nj98b5fog251fehutcltvvktpicri8vm', '103.180.244.161', 1699384827, '__ci_last_regenerate|i:1699384827;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:29:\"Campaign Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nksu33licadr4k2hog9a2uatt0k751t8', '103.180.244.161', 1699217816, '__ci_last_regenerate|i:1699217815;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:21:\" Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nmndek3j6momhpst4gqh96q8qgfq6ia4', '103.197.204.175', 1688284055, '__ci_last_regenerate|i:1688284055;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nr6a92vi0bee678purjcvug2hm4129m1', '202.134.8.143', 1699816164, '__ci_last_regenerate|i:1699815991;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:30:\"Call Re-Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ns44641d9l7jo7v8ged317gtr6rk1vro', '103.180.244.161', 1699365891, '__ci_last_regenerate|i:1699365891;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nt3pj8037a8rmajri49lsrl41paui2e8', '103.197.204.175', 1688282482, '__ci_last_regenerate|i:1688282482;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nupu0vsj180dr0423pfi3qu2u914imen', '103.180.244.161', 1699278573, '__ci_last_regenerate|i:1699278573;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nurv0svfnaq630hlqg8mh8icn6bgr8tp', '37.111.194.187', 1695479593, '__ci_last_regenerate|i:1695479593;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('o0am90qua1ab6cus9h9tne384stnru3q', '103.180.244.161', 1699451433, '__ci_last_regenerate|i:1699451433;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('o186a57k64pnnsg7ijbpnjkepl9ardhq', '103.180.244.161', 1699533419, '__ci_last_regenerate|i:1699533419;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('o2qt7oh5182po9g5puviklvdgoens72s', '103.180.244.161', 1699562315, '__ci_last_regenerate|i:1699562312;redirect_url|s:55:\"http://202.59.208.112/web_apps/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('o3kiet84ji7rh81p93c49ng0321p46no', '103.180.244.161', 1690798504, '__ci_last_regenerate|i:1690798462;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('o4cq9ie921j8ts2tfiodkd1p5oq1cuf3', '59.153.100.214', 1696002802, '__ci_last_regenerate|i:1696002802;redirect_url|s:50:\"http://202.59.208.114/callwave_pro/employee/view/2\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('o70orobm6pij2msmpnfnql02obv41t19', '103.180.244.161', 1699362895, '__ci_last_regenerate|i:1699362895;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('o89t049o7q0t1c1efk1qnm0bkovh2e29', '103.180.244.161', 1698948369, '__ci_last_regenerate|i:1698948369;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('o9tth52hs85nt0firof9sh3rplaerb1r', '103.180.244.161', 1699298008, '__ci_last_regenerate|i:1699298008;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('oat8rq877ia7qb534o6edki5rpmejbts', '103.180.244.161', 1699214976, '__ci_last_regenerate|i:1699214976;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('oauf7qji3bnnesscld2etmkfsehd8bu9', '202.134.8.143', 1699810266, '__ci_last_regenerate|i:1699810266;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('odralkv003chf4aboffc93fdvd71qlm4', '103.180.244.161', 1699386433, '__ci_last_regenerate|i:1699386252;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('oeb9mteqmp8ss0pktgf4hlnkds62urjc', '103.180.244.161', 1698944537, '__ci_last_regenerate|i:1698944537;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ogbls1vdl20ijfadjjvu3kphkoto4phg', '103.180.244.161', 1699455175, '__ci_last_regenerate|i:1699455175;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('oi8c0nl68v9l97km6e44ugmpbpqrem0g', '103.180.244.161', 1699371858, '__ci_last_regenerate|i:1699371858;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('oln70h4aeu9r6j9e2cjh8j44i3njale5', '103.180.244.161', 1698866919, '__ci_last_regenerate|i:1698866919;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:34:\"The Configuration Has Been Updated\";__ci_vars|a:2:{s:21:\"alert-message-success\";s:3:\"old\";s:6:\"active\";s:3:\"old\";}active|i:3;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('onfi9962jc069dlc63ct06ti6hishtsl', '103.180.244.161', 1699471903, '__ci_last_regenerate|i:1699471903;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('oqk744s89gbuqgin8omdpa75dpoj2ne1', '59.153.100.195', 1695483561, '__ci_last_regenerate|i:1695483561;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('oqr9h9klf847jm9sg73scnkt0cc2nf90', '103.180.244.161', 1699280000, '__ci_last_regenerate|i:1699280000;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:21:\" Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('or9duk3mo4p4kjuoofhttra2cr9ak8sv', '103.197.204.175', 1688280510, '__ci_last_regenerate|i:1688280510;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ou3h77met2l435di15e70j2sb9nknhcp', '103.180.244.161', 1699204859, '__ci_last_regenerate|i:1699204859;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ouk00ah2t130gg8diqa4hdqa8h7lgvt7', '103.180.244.161', 1699463391, '__ci_last_regenerate|i:1699463391;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ousd7uf63koufpg8c3epoe5ohkhgu4o0', '103.180.244.161', 1699279739, '__ci_last_regenerate|i:1699279739;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p3shqa9dl0fpeg8kdp2gb6evr6ekejm1', '103.180.244.161', 1699450933, '__ci_last_regenerate|i:1699450933;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p4od4avsqfqucgt0beba2kcu8au050jj', '103.187.94.109', 1696090478, '__ci_last_regenerate|i:1696090478;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p6c05pfqfa9aclm2v8bid9ri42jonofk', '59.153.100.221', 1699621331, '__ci_last_regenerate|i:1699621331;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p701jd6u0vre54bpb9s2ibaj0i6mo95b', '103.180.244.161', 1699389004, '__ci_last_regenerate|i:1699389004;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p8d0rviainjojllpo08shvlhpv26usdl', '103.180.244.161', 1699201850, '__ci_last_regenerate|i:1699201850;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p8mpk6vvlr1hukmg8pbf18atlsrg5q30', '103.180.244.161', 1699465450, '__ci_last_regenerate|i:1699465450;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pc1tpjt6lcuqq3aato5pbthhsi69gdae', '59.153.100.221', 1699399344, '__ci_last_regenerate|i:1699399344;redirect_url|s:74:\"http://202.59.208.112/web_apps/contact_center/voice/get_config_cmp_details\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pk6anhkj983ud9proq123djdl0fjccbk', '103.180.244.161', 1699197589, '__ci_last_regenerate|i:1699197589;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('plfhefpgs3kbdb21iesr5ikehd25t62b', '59.153.100.221', 1699652918, '__ci_last_regenerate|i:1699652918;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pp7o3frnov6nun2lirvu0t5lfa4o4efk', '59.153.100.214', 1688799789, '__ci_last_regenerate|i:1688799789;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pr7d4ho1l96kv5774nfeusrv7o8ub6cv', '202.173.122.4', 1691567267, '__ci_last_regenerate|i:1691567267;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('prjc9122q3u47a2ojse5m25ubnl9vsev', '103.180.244.161', 1698948800, '__ci_last_regenerate|i:1698948800;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('prtfjvpt84v8597idit63cvbocb12913', '103.180.244.161', 1698936374, '__ci_last_regenerate|i:1698936343;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:33:\"New Campaign Created Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('psece5g70e7jafdq0thfgugud0eed0r5', '103.180.244.161', 1688646979, '__ci_last_regenerate|i:1688646979;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pt1qcm5tfer6gq0khp2a95td9amehdbm', '103.180.244.161', 1699365975, '__ci_last_regenerate|i:1699365975;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('pveg38idkhptaq0bmvenmjo223h8qpji', '103.180.244.161', 1699362285, '__ci_last_regenerate|i:1699362285;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('q222d3mght4n9u0mlrf1r3jniikvhepa', '103.180.244.161', 1699373559, '__ci_last_regenerate|i:1699373559;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('q2ntuij1lb1nb0b82o2b1pcad3th0pog', '103.180.244.161', 1699533419, '__ci_last_regenerate|i:1699533419;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('q2vupa3n594h4plpjre3fp9b3pjhi3jt', '103.180.244.161', 1688634777, '__ci_last_regenerate|i:1688634777;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('q4b3ehuimusbok978f02mh5aip9da4it', '103.180.244.161', 1698941427, '__ci_last_regenerate|i:1698941427;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('q89utela44637a01lnfddo6lbfroug54', '103.180.244.161', 1699270478, '__ci_last_regenerate|i:1699270477;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('q9l7mmubvoar3fh5qe8v09gqng8ivb3l', '103.180.244.161', 1699465297, '__ci_last_regenerate|i:1699465297;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qakfg51nqkikcc24m6foac52hqhjs1jg', '103.180.244.161', 1699188479, '__ci_last_regenerate|i:1699188479;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qbon63r7caifu302551dq8hnhapldt3i', '103.180.244.161', 1699466504, '__ci_last_regenerate|i:1699466504;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qh8na3pl2dtonfljr1gauh7p8fpk5vmp', '103.180.244.161', 1699367500, '__ci_last_regenerate|i:1699367500;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qlm9r1b2q614nhbl3t76qptlun3fekon', '103.170.139.42', 1691567262, '__ci_last_regenerate|i:1691567262;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qm8qpuii1k6a43767e8h4sacm2sr92ra', '103.180.244.161', 1699208134, '__ci_last_regenerate|i:1699208134;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qmphkh2qqio0s8mi8bja5n1b69k9cab6', '103.180.244.161', 1699374395, '__ci_last_regenerate|i:1699374395;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qobbcomum9e5abimg9n4grlk6arnnvg6', '37.111.194.187', 1695480598, '__ci_last_regenerate|i:1695480598;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qpps9pulvqvakum7ve3jtq93vu7ff0nh', '103.180.244.161', 1699378160, '__ci_last_regenerate|i:1699378160;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:29:\"Campaign Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qv59vlpijleol92ba2qn68h25vjp9sab', '103.180.244.161', 1699211884, '__ci_last_regenerate|i:1699211884;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('qvqjujfr5h8apr28utf5khoi3bemofph', '59.153.100.195', 1695482533, '__ci_last_regenerate|i:1695482533;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('r0kj6bt8orlpfkffr1r2idjafiu9qpve', '103.180.244.161', 1699277219, '__ci_last_regenerate|i:1699277219;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('r4b62lqsg7ljh22bkndn9a5tu6rk559h', '103.180.244.161', 1699468731, '__ci_last_regenerate|i:1699468731;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('r5togvrk6l23vt6j3d3hn36oqsfu4fkn', '103.180.244.161', 1699208920, '__ci_last_regenerate|i:1699208920;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('r70a18riuq2bpna431cfrvcedt9m162m', '103.180.244.161', 1699301219, '__ci_last_regenerate|i:1699301219;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('r8rp02ulitudlq1tk63h88osl74690j3', '103.180.244.161', 1699370729, '__ci_last_regenerate|i:1699370729;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ratsefl3qi9nluvedm0dgqbfapgmlrad', '103.180.244.161', 1699210502, '__ci_last_regenerate|i:1699210502;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rba0h4j2alekkrlaeuhnfdc0oqq0krel', '103.180.244.161', 1699361891, '__ci_last_regenerate|i:1699361891;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rd1e5qf40pacfnrslbbjf6jsc4893ndv', '103.180.244.161', 1699384188, '__ci_last_regenerate|i:1699384188;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rmcjrggkofagc61880m1sc1tf5tv6uan', '103.180.244.161', 1699459782, '__ci_last_regenerate|i:1699459782;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rmn1l31uk301l2iu97aldtunulltve8f', '103.180.244.161', 1698954482, '__ci_last_regenerate|i:1698954482;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ro837njcjd88q1g2sgak7he9b87tekb5', '103.180.244.161', 1699448320, '__ci_last_regenerate|i:1699448320;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rofvprv3l1cbtbq5e2b9jk0h6f7hkqkb', '59.153.100.221', 1699652918, '__ci_last_regenerate|i:1699652918;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rp0s54cvh3pafghfjglrlvu6m668abrf', '103.180.244.161', 1698941783, '__ci_last_regenerate|i:1698941783;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rp7uhm07d5kdu6nm25nsofvlaimahn54', '103.170.139.42', 1691569391, '__ci_last_regenerate|i:1691569391;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rr1q9v8afrl1kacnoitcq9gt4s3ordsc', '103.180.244.161', 1699454683, '__ci_last_regenerate|i:1699454683;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('rtvneqmnlo0ac537a2ogu4phd10tu8nh', '103.180.244.161', 1699471095, '__ci_last_regenerate|i:1699465774;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ru618h5c0pro6fut3mn78rgmn4t8tkei', '103.180.244.161', 1699215262, '__ci_last_regenerate|i:1699215262;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ruhj7ac7lcta29fsqkia6k2kldejtiin', '103.180.244.161', 1699466732, '__ci_last_regenerate|i:1699466732;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('s0nd6rkdpq0s86u8i8m3gui226k2ksm6', '103.180.244.161', 1699453502, '__ci_last_regenerate|i:1699453502;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('s0vuks9ftpi0buf3f6v47v0nm357knf2', '103.180.244.161', 1699217512, '__ci_last_regenerate|i:1699217512;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:21:\" Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('s3h1lmv8bomv4s02cbbi5pv1hitgjgpf', '202.134.8.143', 1699803134, '__ci_last_regenerate|i:1699803134;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:30:\"Call Re-Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('s3u6va4r9opbor8lt9kpdoeb4pl2j0ik', '103.180.244.161', 1699214181, '__ci_last_regenerate|i:1699214181;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('s6t6k1gau76bn9lo9jlqg8l51roqbl64', '59.153.100.221', 1699400803, '__ci_last_regenerate|i:1699400803;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('s6ud2ikj08pnou3732mgp8j97tk9crqu', '103.180.244.161', 1690266889, '__ci_last_regenerate|i:1690266754;redirect_url|s:53:\"http://202.59.208.112/cdc/referral/commission_history\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('s8bjlfhcuqj5u58de2sn2q69998fqctn', '176.98.217.113', 1696097341, '__ci_last_regenerate|i:1696097290;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sa7femitktr2cue6kfka6kounang4bcv', '103.180.244.161', 1691475622, '__ci_last_regenerate|i:1691475621;redirect_url|s:35:\"http://202.59.208.112/cdc/dashboard\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sc4te929kcp9ikvcbnmt88priuvhlt7u', '103.180.244.161', 1699386561, '__ci_last_regenerate|i:1699386561;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('se4s8tmf2ma6rvccrhoc88dlgpokrc4n', '103.180.244.161', 1699450933, '__ci_last_regenerate|i:1699450933;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('se9hq2abtoi2f1i1tdlsmcoq19fhr1ib', '103.180.244.161', 1699474958, '__ci_last_regenerate|i:1699474958;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sgp76ceqqgeapcgvvp8p0kn4sum1ap04', '103.180.244.161', 1698947301, '__ci_last_regenerate|i:1698947301;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sja8slqh9aik7k5cj1cgch8rh0f99mss', '59.153.100.204', 1695488911, '__ci_last_regenerate|i:1695488786;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sjsphtbk77do3js6kgh1qukbpo0b9t15', '103.180.244.161', 1699277626, '__ci_last_regenerate|i:1699277626;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('snflkbm5cm9iut46av2ocggonek7efoi', '103.180.244.161', 1698946662, '__ci_last_regenerate|i:1698946662;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('st8rmor7u1g8mufv4eohvmvq804cpo2p', '103.180.244.161', 1699791753, '__ci_last_regenerate|i:1699791753;redirect_url|s:55:\"http://202.59.208.112/web_apps/contact_center/dashboard\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('su1vmr96l6l4cg11g5omdrfcm9iq2ijm', '103.180.244.161', 1699464594, '__ci_last_regenerate|i:1699464594;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:36:\"Campaign Config Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('sue3nhikmoug5hn2d9c58423i3v3imkv', '103.180.244.161', 1699471879, '__ci_last_regenerate|i:1699471879;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t1t158ea3m6c25hihlut9b2cbijpusr3', '103.180.244.161', 1698941073, '__ci_last_regenerate|i:1698941073;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t2a7sb601sa3snif5alkps6j2sm7it72', '103.180.244.161', 1699476400, '__ci_last_regenerate|i:1699476400;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t2j3icf9d3qog9fcro3elcq4qpjojp1c', '103.180.244.161', 1699388492, '__ci_last_regenerate|i:1699388492;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t4apjl5f2un33e98k3doef7694romm6p', '103.180.244.161', 1699214585, '__ci_last_regenerate|i:1699214585;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t7l6bcb4dupnsq998tud4kd1p5l4q12u', '59.153.100.214', 1695971793, '__ci_last_regenerate|i:1695971688;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t8g6f4513p3r1bp10fa9kf5h0li3ai65', '103.180.244.161', 1698867065, '__ci_last_regenerate|i:1698866964;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"spanish\";loggedin|b:1;file_data|a:8:{i:0;a:2:{i:0;s:13:\"8801738505555\";i:1;s:20:\"test_voice_broadcast\";}i:1;a:2:{i:0;s:13:\"8801922036882\";i:1;s:20:\"test_voice_broadcast\";}i:2;a:2:{i:0;s:13:\"8801918562760\";i:1;s:20:\"test_voice_broadcast\";}i:3;a:2:{i:0;s:13:\"8801789825487\";i:1;s:20:\"test_voice_broadcast\";}i:4;a:2:{i:0;s:13:\"8801744733133\";i:1;s:20:\"test_voice_broadcast\";}i:5;a:2:{i:0;s:13:\"8801718768245\";i:1;s:20:\"test_voice_broadcast\";}i:6;a:2:{i:0;s:13:\"8801517088093\";i:1;s:20:\"test_voice_broadcast\";}i:7;a:2:{i:0;s:13:\"8801977255355\";i:1;s:20:\"test_voice_broadcast\";}}alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('t9153jai5kssb8lrrg5rt2srard31lec', '103.180.244.161', 1699368623, '__ci_last_regenerate|i:1699368623;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ta0d6leui5qs8sd6te8lj933pgjc7n8g', '103.180.244.161', 1690798946, '__ci_last_regenerate|i:1690798945;redirect_url|s:46:\"http://202.59.208.112/cdc/frontend/menu/edit/1\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('te1uogu0onuh5k60jq2hdnso98p00o3g', '103.170.139.42', 1691569806, '__ci_last_regenerate|i:1691569762;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ti480u92geg83bp617gfejm69hhtq9aq', '103.180.244.161', 1699283528, '__ci_last_regenerate|i:1699283487;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tif8ck23ajots6jttotbes0c9s8sn3jp', '103.180.244.161', 1699794808, '__ci_last_regenerate|i:1699794808;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tjh9mso5f9r839sa1lvdljnnccpt8jr8', '103.180.244.161', 1699198639, '__ci_last_regenerate|i:1699198639;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tnavecnkfs5upus275uoqorv885lvv92', '103.180.244.161', 1699216818, '__ci_last_regenerate|i:1699216818;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tnpssjhi5t5kr5e2dekvsn687gve8hha', '103.180.244.161', 1698865835, '__ci_last_regenerate|i:1698865835;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:34:\"The Configuration Has Been Updated\";__ci_vars|a:2:{s:21:\"alert-message-success\";s:3:\"old\";s:6:\"active\";s:3:\"old\";}active|i:3;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('to251ti1ul3i3okprcg5suh0qign4c73', '103.180.244.161', 1699206967, '__ci_last_regenerate|i:1699206967;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('topmhi225frhtsqvct59fhc7ntom7hm9', '191.101.237.76', 1687888996, '__ci_last_regenerate|i:1687888996;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('toui0k1somtnmeh5kkg3uhituf89b98s', '103.197.204.175', 1688284057, '__ci_last_regenerate|i:1688284055;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tplf5444c0q4r8bekcbicmn7e6gips6g', '103.180.244.161', 1688638856, '__ci_last_regenerate|i:1688638856;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ts0i66f0sjujb2qf8hflanhbcmjen0iv', '37.111.194.187', 1695486128, '__ci_last_regenerate|i:1695486128;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tsvohesjh4v4al8j625t0gsm0f0rvogj', '59.153.100.214', 1698968637, '__ci_last_regenerate|i:1698968636;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('tvs9nbgdbfme5aoaa3nfd039dou94dn3', '103.180.244.161', 1699387656, '__ci_last_regenerate|i:1699387656;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u1in7755g43b14molta5e3g5d5m96v0c', '59.153.100.195', 1695475993, '__ci_last_regenerate|i:1695475993;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u5pmdscnt180mjmie2j16gbos7cm58b9', '103.180.244.161', 1699298366, '__ci_last_regenerate|i:1699298366;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u5vi4u4nsieadds8e2ei9rq5lv0v15c8', '103.180.244.161', 1699364825, '__ci_last_regenerate|i:1699364825;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u6gd1j18md7pua5plfa6kcldt3mfij5e', '103.180.244.161', 1699387225, '__ci_last_regenerate|i:1699387225;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('u93bc5sqoptmkn9fo9602v946dajr6gd', '103.180.244.161', 1699298809, '__ci_last_regenerate|i:1699298809;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ua2t18uob5n68g42ejdcd65q5kdnfuju', '103.180.244.161', 1688466026, '__ci_last_regenerate|i:1688466026;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ucvhf4q5asn9mc2rquvt0s1hleunv3gc', '103.180.244.161', 1699300912, '__ci_last_regenerate|i:1699300912;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ueu1q0clufndg4q7aadaig4fvgkcn185', '103.180.244.161', 1699213845, '__ci_last_regenerate|i:1699213845;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('uj276piq5b3okqr2fvmjca2fg91efcuh', '103.180.244.161', 1699187683, '__ci_last_regenerate|i:1699187683;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ul3rljrflqepl01qbupg0jgofpue2j96', '103.180.244.161', 1699296570, '__ci_last_regenerate|i:1699296570;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('un0gqt2emglsk156cssqflcothjkfnq4', '103.180.244.161', 1699369790, '__ci_last_regenerate|i:1699369790;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('us0uloeaacka2ipki0i2a2i0odna880f', '103.181.42.122', 1687889071, '__ci_last_regenerate|i:1687889071;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('uscseri9me46rqt6762238sv1e26h070', '103.180.244.161', 1699210945, '__ci_last_regenerate|i:1699210945;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('uuphg5ggs09viivllvoso3352quiasm4', '103.180.244.161', 1699211770, '__ci_last_regenerate|i:1699211770;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('v084ttvei6ugrlepim3tfvrko1gkktod', '103.180.244.161', 1698955265, '__ci_last_regenerate|i:1698955265;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('v0jpfva44vbnautnfjg1r6kdspq2qg0l', '103.180.244.161', 1699464776, '__ci_last_regenerate|i:1699464776;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('v5srfv1aj05s2olvefjd92dncj1ancde', '103.180.244.161', 1699376026, '__ci_last_regenerate|i:1699376026;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:29:\"Campaign Updated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('v9ikb13qmfd89oud8fjpj89mui15o912', '202.173.122.4', 1699272668, '__ci_last_regenerate|i:1699272662;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('va22e02ff85b0foeq9vcj8vg7ckmpab8', '103.181.42.122', 1688673454, '__ci_last_regenerate|i:1688673441;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ve2c0bkv6a2rjhbj2m62mhb6tjav6cge', '202.40.187.253', 1696747393, '__ci_last_regenerate|i:1696747177;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"spanish\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vicqq79v5p7emnk6eo952urdvkjtu6bt', '103.180.244.161', 1698943400, '__ci_last_regenerate|i:1698943400;alert-message-error|s:27:\"Username Password Incorrect\";__ci_vars|a:1:{s:19:\"alert-message-error\";s:3:\"old\";}name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vjedsn6u5cjf37a7iav742bk6ia5au94', '103.180.244.161', 1699372484, '__ci_last_regenerate|i:1699372484;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vl97tfnb7s2ffmjqm8gitel8e1fhpe2r', '59.153.100.195', 1695480935, '__ci_last_regenerate|i:1695480935;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vlthdngb11n2nmpqpk4r4mk8ver3que0', '103.180.244.161', 1699364703, '__ci_last_regenerate|i:1699364703;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vmns4jvuir6qb9blgcftnoggebm80hqp', '37.111.228.176', 1699812760, '__ci_last_regenerate|i:1699812760;redirect_url|s:56:\"http://202.59.208.112/web_apps/contact_center/ami/config\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:30:\"Call Re-Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vo7e067362117ao9vhmcf2274em3mg9r', '37.111.219.185', 1699621331, '__ci_last_regenerate|i:1699621331;redirect_url|s:51:\"http://202.59.208.112/web_apps/contact_center/voice\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('voj6v75msebqpqin9tnbof4h0d02nfe8', '37.111.226.24', 1687890010, '__ci_last_regenerate|i:1687889817;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vp4il4siv511cs53i0d2t27r9kinn22v', '103.180.244.161', 1699462504, '__ci_last_regenerate|i:1699462504;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vq3f40n6irk2mm9vqh26lt4enfpua7td', '103.180.244.161', 1699466822, '__ci_last_regenerate|i:1699466822;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vq9kp7rah8ts2bda2csr4uo11e9pesk5', '59.153.100.214', 1688727808, '__ci_last_regenerate|i:1688727647;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|N;loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vr42t2hahn6ckevkrupj0kan9bibj9mh', '103.180.244.161', 1699801739, '__ci_last_regenerate|i:1699801739;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;alert-message-success|s:27:\"Call Initiated Successfully\";__ci_vars|a:1:{s:21:\"alert-message-success\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vta3g0imqb29j5nm3brjpoe59ihthbc5', '103.180.244.161', 1699457437, '__ci_last_regenerate|i:1699457437;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vuncl2fdb1spc5pqncah6mcf8pnqk2m0', '103.180.244.161', 1699207829, '__ci_last_regenerate|i:1699207829;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vuuq8olb8n7qtl6iksfv33ccf6bac741', '103.180.244.161', 1699468426, '__ci_last_regenerate|i:1699468426;name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('vvqv7i45cbjcgf010g15ego2a8k93lrm', '103.180.244.161', 1699201610, '__ci_last_regenerate|i:1699201610;redirect_url|s:62:\"http://202.59.208.112/web_apps/contact_center/voice/quick_call\";name|s:11:\"Super Admin\";uniqueid|s:7:\"b195808\";logger_photo|s:36:\"320c2097d077e5d97049da98118d2477.png\";loggedin_id|s:1:\"1\";loggedin_role_id|s:1:\"1\";loggedin_userid|s:1:\"1\";date_format|s:8:\"%d-%b-%Y\";set_lang|s:7:\"english\";loggedin|b:1;');


#
# TABLE STRUCTURE FOR: contact_list
#

DROP TABLE IF EXISTS `contact_list`;

CREATE TABLE `contact_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `datetime` datetime DEFAULT NULL,
  `last_modified` datetime DEFAULT NULL,
  `name` varchar(20) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `email` varchar(20) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `group_name` varchar(20) DEFAULT NULL,
  `assigned_to` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

INSERT INTO `contact_list` (`id`, `datetime`, `last_modified`, `name`, `phone`, `email`, `address`, `group_name`, `assigned_to`) VALUES (9, '2023-11-12 19:24:37', NULL, 'Tanvir Islam', '8801744733133', 'tanvir@sohub.com.bd', 'Mohammadpur', 'sohub_group', '1');
INSERT INTO `contact_list` (`id`, `datetime`, `last_modified`, `name`, `phone`, `email`, `address`, `group_name`, `assigned_to`) VALUES (10, '2023-11-12 19:24:37', NULL, 'Muyed Moktadir ', '8801738505555', 'muyed@sohub.com.bd', 'Mohammadpur', 'sohub_group', '1');
INSERT INTO `contact_list` (`id`, `datetime`, `last_modified`, `name`, `phone`, `email`, `address`, `group_name`, `assigned_to`) VALUES (11, '2023-11-12 19:24:37', NULL, 'Ariful Islam', '8801789825487', 'rafi@sohub.com.bd', 'Badda', 'sohub_group', '1');
INSERT INTO `contact_list` (`id`, `datetime`, `last_modified`, `name`, `phone`, `email`, `address`, `group_name`, `assigned_to`) VALUES (12, '2023-11-12 19:24:37', NULL, 'Sagor Mia', '8801977255355', 'sagor@sohub.com.bd', 'Dhanmondi', 'sohub_group', '1');
INSERT INTO `contact_list` (`id`, `datetime`, `last_modified`, `name`, `phone`, `email`, `address`, `group_name`, `assigned_to`) VALUES (13, '2023-11-12 19:24:37', NULL, 'Sohel Rana', '8801929622723', 'sohel@sohub.com.bd', 'Bosila Bridge', 'sohub_group', '1');
INSERT INTO `contact_list` (`id`, `datetime`, `last_modified`, `name`, `phone`, `email`, `address`, `group_name`, `assigned_to`) VALUES (14, '2023-11-12 19:24:37', NULL, 'Sakib Shahriar', '8801517088093', 'sakib@sohub.com.bd', 'Mohammadpur', 'sohub_group', '1');


#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int NOT NULL AUTO_INCREMENT,
  `email` varchar(200) DEFAULT NULL,
  `email_protocol` varchar(10) NOT NULL,
  `smtp_host` varchar(25) NOT NULL,
  `smtp_user` varchar(25) DEFAULT NULL,
  `smtp_pass` text NOT NULL,
  `smtp_port` varchar(100) NOT NULL,
  `smtp_encryption` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `email_config` (`id`, `email`, `email_protocol`, `smtp_host`, `smtp_user`, `smtp_pass`, `smtp_port`, `smtp_encryption`) VALUES (1, 'example@gmail.com', 'sendmail', 'smtp.gmail.com', 'example@gmail.com', '1234', '25', 'ssl');


#
# TABLE STRUCTURE FOR: email_templates
#

DROP TABLE IF EXISTS `email_templates`;

CREATE TABLE `email_templates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `email_type` varchar(200) NOT NULL,
  `subject` varchar(250) NOT NULL,
  `template_body` longtext NOT NULL,
  `tags` longtext NOT NULL,
  `notified` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3;

INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (1, 'account_registered', 'Account Registered', '', '{institute_name}, {name}, {username}, {password}, {user_role}, {login_url}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (2, 'forgot_password', 'Forgot Password', '', '{institute_name}, {name}, {username}, {reset_url}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (5, 'payslip_generated', 'Payslip generated', '', '{institute_name}, {name}, {month_year}, {payslip_no}, {payslip_url}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (6, 'absent', 'Absent Notice', '', '{institute_name}, {name}, {date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (7, 'leave_approve', 'Your leave request has been approved', '', '{institute_name}, {name}, {admin_comments}, {start_date}, {end_date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (8, 'leave_reject', 'Your leave request has been reject', '', '{institute_name}, {name}, {admin_comments}, {start_date}, {end_date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (9, 'appointment_confirmation', 'Appointment Confirmation', '', '{institute_name}, {patient_name}, {doctor_name}, {consultation_fees}, {schedule_time}, {appointment_date}', 0);
INSERT INTO `email_templates` (`id`, `email_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (10, 'appointment_canceled', 'Appointment Canceled', '', '{institute_name}, {patient_name}, {doctor_name}, {consultation_fees}, {schedule_time}, {appointment_date}', 0);


#
# TABLE STRUCTURE FOR: front_cms_about
#

DROP TABLE IF EXISTS `front_cms_about`;

CREATE TABLE `front_cms_about` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `page_title` varchar(255) NOT NULL,
  `content` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `about_image` varchar(255) NOT NULL,
  `elements` mediumtext NOT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_about` (`id`, `title`, `subtitle`, `page_title`, `content`, `banner_image`, `about_image`, `elements`, `meta_description`, `meta_keyword`) VALUES (1, 'Welcome to Hospitals', 'Best Medical &amp; Healthcare Needs to Our Patients', 'About Us', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut volutpat rutrum eros amet sollicitudin interdum. Suspendisse pulvinar, velit nec pharetra interdum, ante tellus ornare mi, et mollis tellus neque vitae elit. Mauris adipiscing mauris fringilla turpis interdum sed pulvinar nisi malesuada. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>\r\n\r\n<p>Donec sed odio dui. Nulla vitae elit libero, a pharetra augue. Nullam id dolor id nibh ultricies vehicula ut id elit. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Duis mollis, est non commodo luctus, nisi erat porttitor ligula. Mauris sit amet neque nec nunc gravida.</p>\r\n\r\n<div class=\"row\">\r\n<div class=\"col-sm-6 col-12\">\r\n<ul class=\"list-unstyled list-style-3\">\r\n	<li><a href=\"#\">Cardiothoracic Surgery</a></li>\r\n	<li><a href=\"#\">Cardiovascular Diseases</a></li>\r\n	<li><a href=\"#\">Ophthalmology</a></li>\r\n	<li><a href=\"#\">Dermitology</a></li>\r\n</ul>\r\n</div>\r\n\r\n<div class=\"col-sm-6 col-12\">\r\n<ul class=\"list-unstyled list-style-3\">\r\n	<li><a href=\"#\">Cardiothoracic Surgery</a></li>\r\n	<li><a href=\"#\">Cardiovascular Diseases</a></li>\r\n	<li><a href=\"#\">Ophthalmology</a></li>\r\n</ul>\r\n</div>\r\n</div>', 'about.jpg', 'about.jpg', '{\"cta_title\":\"Get in touch to join our community\",\"button_text\":\"Contact Our Office\",\"button_url\":\"contact\"}', '', '');


#
# TABLE STRUCTURE FOR: front_cms_appointment
#

DROP TABLE IF EXISTS `front_cms_appointment`;

CREATE TABLE `front_cms_appointment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_appointment` (`id`, `title`, `description`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'Make An Appoinment', '<p><span style=\"color: rgb(156, 156, 156); font-family: Poppins, sans-serif; font-size: 14px; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: start; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;\">Lorem ipsum dolor sit amet, eum illum dolore concludaturque ex, ius latine adipisci no. Pro at nullam laboramus definitiones. Mandamusconceptam omittantur cu cum. Brute appetere it scriptorem ei eam, ne vim velit novum nominati. Causae volutpat percipitur at sed ne.</span></p>\r\n', 'Appointment', 'appointment.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_contact
#

DROP TABLE IF EXISTS `front_cms_contact`;

CREATE TABLE `front_cms_contact` (
  `id` int NOT NULL AUTO_INCREMENT,
  `box_title` varchar(255) DEFAULT NULL,
  `box_description` varchar(500) DEFAULT NULL,
  `box_image` varchar(255) DEFAULT NULL,
  `form_title` varchar(355) DEFAULT NULL,
  `address` varchar(355) DEFAULT NULL,
  `phone` varchar(355) DEFAULT NULL,
  `email` varchar(355) DEFAULT NULL,
  `submit_text` varchar(355) NOT NULL,
  `map_iframe` text,
  `page_title` varchar(255) NOT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_contact` (`id`, `box_title`, `box_description`, `box_image`, `form_title`, `address`, `phone`, `email`, `submit_text`, `map_iframe`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'WE\'D LOVE TO HEAR FROM YOU', 'Fusce convallis diam vitae velit tempus rutrum. Donec nisl nisl, vulputate eu sapien sed, adipiscing vehicula massa. Mauris eget commodo neque, id molestie enim.', 'contact-info-box.png', 'Get in touch by filling the form below', '4896  Romrog Way, LOS ANGELES,\r\nCalifornia', '954-648-1802, \r\n963-612-1782', 'info@example.com\r\nsupport@example.com', 'Send', '<iframe width=\"100%\" height=\"350\" id=\"gmap_canvas\" src=\"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3313.3833161665298!2d-118.03745848530627!3d33.85401093559897!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x80dd2c6c97f8f3ed%3A0x47b1bde165dcc056!2sOak+Dr%2C+La+Palma%2C+CA+90623%2C+USA!5e0!3m2!1sen!2sbd!4v1544238752504\" frameborder=\"0\" scrolling=\"no\" marginheight=\"0\" marginwidth=\"0\"></iframe>', 'Contact Us', 'contact.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_doctor_bio
#

DROP TABLE IF EXISTS `front_cms_doctor_bio`;

CREATE TABLE `front_cms_doctor_bio` (
  `id` int NOT NULL AUTO_INCREMENT,
  `doctor_id` varchar(20) NOT NULL,
  `biography` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: front_cms_doctors
#

DROP TABLE IF EXISTS `front_cms_doctors`;

CREATE TABLE `front_cms_doctors` (
  `id` int NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_doctors` (`id`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'Doctors', 'doctors.jpg', '', '');
INSERT INTO `front_cms_doctors` (`id`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (2, 'Doctor Profile', 'doctor_profile.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_faq
#

DROP TABLE IF EXISTS `front_cms_faq`;

CREATE TABLE `front_cms_faq` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `page_title` varchar(255) DEFAULT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_faq` (`id`, `title`, `description`, `page_title`, `banner_image`, `meta_description`, `meta_keyword`) VALUES (1, 'Frequently Asked Questions', '<p>Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident.</p>\r\n\r\n<p>Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven&#39;t heard of them accusamus labore sustainable VHS.</p>', 'Faq', 'faq.jpg', '', '');


#
# TABLE STRUCTURE FOR: front_cms_faq_list
#

DROP TABLE IF EXISTS `front_cms_faq_list`;

CREATE TABLE `front_cms_faq_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (1, 'Any Information you provide on applications for disability, life or accidental insurance ?', '<p>\r\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.\r\n</p>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet, consectetur adipisicing elit.</li>\r\n<li>Sed do eiusmod tempor incididunt ut labore et dolore magna aliq.</li>\r\n<li>Ut enim ad minim veniam, quis nostrud exercitation ullamco quat. It is a long established fact.</li>\r\n<li>That a reader will be distracted by the readable content of a page when looking at its layout.</li>\r\n<li>Lorem ipsum dolor sit amet, consectetur adipisicing elit.</li>\r\n<li>Eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.</li>\r\n<li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n<li>Readable content of a page when looking at its layout.</li>\r\n<li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n<li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n</ul>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (2, 'Readable content of a page when looking at its layout ?', '<p>\r\n                                Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven\'t heard of them accusamus labore sustainable VHS.\r\n                            </p>\r\n                            <ol>\r\n                                <li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n                                <li>Readable content of a page when looking at its layout.</li>\r\n                                <li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n                                <li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n                            </ol>\r\n                            <p>\r\n                                Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\r\n                            </p>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (3, 'Opposed to using \'Content here, content here\', making it look like readable English ?', '<p>\r\n                                Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven\'t heard of them accusamus labore sustainable VHS.\r\n                            </p>\r\n                            <ol>\r\n                                <li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n                                <li>Readable content of a page when looking at its layout.</li>\r\n                                <li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n                                <li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n                            </ol>\r\n                            <p>\r\n                                Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\r\n                            </p>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (4, 'Readable content of a page when looking at its layout ?', '<p>\r\n                                Nihil anim keffiyeh helvetica, craft beer labore wes anderson cred nesciunt sapiente ea proident. Ad vegan excepteur butcher vice lomo. Leggings occaecat craft beer farm-to-table, raw denim aesthetic synth nesciunt you probably haven\'t heard of them accusamus labore sustainable VHS.\r\n                            </p>\r\n                            <ol>\r\n                                <li>Quis nostrud exercitation ullamco quat. It is a long established fact that a reader will be distracted.</li>\r\n                                <li>Readable content of a page when looking at its layout.</li>\r\n                                <li>The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters.</li>\r\n                                <li>Opposed to using \'Content here, content here\', making it look like readable English.</li>\r\n                            </ol>\r\n                            <p>\r\n                                Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\r\n                            </p>');
INSERT INTO `front_cms_faq_list` (`id`, `title`, `description`) VALUES (5, 'What types of documents are required to travel?', '<p><strong>Lorem ipsum</strong> dolor sit amet, an labores explicari qui, eu nostrum copiosae argumentum has. Latine propriae quo no, unum ridens expetenda id sit, at usu eius eligendi singulis. Sea ocurreret principes ne. At nonumy aperiri pri, nam quodsi copiosae intellegebat et, ex deserunt euripidis usu. Per ad ullum lobortis. Duo volutpat imperdiet ut, postea salutatus imperdiet ut per, ad utinam debitis invenire has.</p>\r\n\r\n<ol>\r\n	<li>labores explicari qui</li>\r\n	<li>labores explicari qui</li>\r\n	<li>labores explicari quilabores explicari qui</li>\r\n	<li>labores explicari qui</li>\r\n</ol>');


#
# TABLE STRUCTURE FOR: front_cms_home
#

DROP TABLE IF EXISTS `front_cms_home`;

CREATE TABLE `front_cms_home` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `item_type` varchar(20) NOT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `elements` mediumtext NOT NULL,
  `active` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (1, 'We Offer Fast &amp; Reliable', 'Medical &amp; Healthcare Needs', 'wellcome', 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using content.\r\n\r\nMaking it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).', '{\"image\":\"wellcome.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (2, 'Experience Doctor Team', NULL, 'doctors', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident.', '{\"doctor_start\":\"1\",\"image\":\"featured-parallax.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (3, 'Our Best Medical Services', NULL, 'services', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.', '', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (4, 'Online Hassle Free Appointment Booking', 'Medical Services', 'cta', '', '{\"mobile_no\":\"+2484-398-8987\",\"button_text\":\"Book your Appointment\",\"button_url\":\"appointment\",\"image\":\"appointment-booking-img.png\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (5, 'Best <span>Digital</span> Experience', NULL, 'slider', 'Lorem Ipsum is simply dummy text printer took a galley of type and scrambled it to make a type specimen book.', '{\"position\":\"c-left\",\"button_text1\":\"View Services\",\"button_url1\":\"#\",\"button_text2\":\"Learn More\",\"button_url2\":\"#\",\"image\":\"home-slider-1578743357.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (6, 'Main Heading <span>Some Caption</span> Here', NULL, 'slider', 'Lorem Ipsum is simply dummy text printer took a galley of type and scrambled it to make a type specimen book.', '{\"position\":\"c-center\",\"button_text1\":\"Read More\",\"button_url1\":\"#\",\"button_text2\":\"Get Started\",\"button_url2\":\"#\",\"image\":\"home-slider-1578743366.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (7, 'Here creative & professional <span>PHP</span> template', NULL, 'slider', 'Lorem Ipsum is simply dummy text printer took a galley of type and scrambled it to make a type specimen book.', '{\"position\":\"c-right\",\"button_text1\":\"Read More\",\"button_url1\":\"#\",\"button_text2\":\"Contact us\",\"button_url2\":\"contact\",\"image\":\"home-slider-1578743373.jpg\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (8, 'Qualified Doctors', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"fas fa-user-md\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (9, 'Regular Checkup', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"fas fa-stethoscope\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (10, 'Neurosurgeon', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"fas fa-vial\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (11, '24 Hours  Service', NULL, 'features', 'Nulla metus metus ullamcorper vel tincidunt sed euismod nibh Quisque volutpat condimentum velit class aptent taciti sociosqu.', '{\"button_text\":\"Read More\",\"button_url\":\"#\",\"icon\":\"far fa-clock\"}', 0);
INSERT INTO `front_cms_home` (`id`, `title`, `subtitle`, `item_type`, `description`, `elements`, `active`) VALUES (12, 'Our Happy Patients Opinion', NULL, 'testimonial', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.', '', 0);


#
# TABLE STRUCTURE FOR: front_cms_home_seo
#

DROP TABLE IF EXISTS `front_cms_home_seo`;

CREATE TABLE `front_cms_home_seo` (
  `id` int NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) NOT NULL,
  `meta_keyword` text NOT NULL,
  `meta_description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_home_seo` (`id`, `page_title`, `meta_keyword`, `meta_description`) VALUES (1, 'Home', '', '');


#
# TABLE STRUCTURE FOR: front_cms_menu
#

DROP TABLE IF EXISTS `front_cms_menu`;

CREATE TABLE `front_cms_menu` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `alias` varchar(100) NOT NULL,
  `ordering` int NOT NULL,
  `parent_id` int DEFAULT '0',
  `open_new_tab` int NOT NULL DEFAULT '0',
  `ext_url` int NOT NULL DEFAULT '0',
  `ext_url_address` text,
  `publish` int NOT NULL,
  `system` varchar(10) NOT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (1, 'Home', 'index', 1, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (2, 'Appointment', 'appointment', 3, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (3, 'Doctors', 'doctors', 2, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (4, 'About Us', 'about', 4, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (5, 'FAQ', 'faq', 5, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');
INSERT INTO `front_cms_menu` (`id`, `title`, `alias`, `ordering`, `parent_id`, `open_new_tab`, `ext_url`, `ext_url_address`, `publish`, `system`, `created_at`) VALUES (6, 'Contact Us', 'contact', 6, 0, 0, 0, '', 1, '1', '2019-08-09 18:18:54');


#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `page_title` varchar(255) NOT NULL,
  `content` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `menu_id` int NOT NULL,
  `banner_image` varchar(255) DEFAULT NULL,
  `meta_description` text NOT NULL,
  `meta_keyword` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: front_cms_services
#

DROP TABLE IF EXISTS `front_cms_services`;

CREATE TABLE `front_cms_services` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `subtitle` varchar(255) DEFAULT NULL,
  `parallax_image` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_services` (`id`, `title`, `subtitle`, `parallax_image`) VALUES (1, 'Get Well Soon', 'Our Hosptial <span>Services</span>', 'service_parallax.jpg');


#
# TABLE STRUCTURE FOR: front_cms_services_list
#

DROP TABLE IF EXISTS `front_cms_services_list`;

CREATE TABLE `front_cms_services_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `icon` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (1, 'First Aid', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text.', 'fas fa-medal');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (2, 'Dental Care', 'Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover.', 'fas fa-heartbeat');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (3, '24x7 Ambulance', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model.', 'fas fa-ambulance');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (4, 'Qualified Doctors', 'Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will.', 'fas fa-capsules');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (5, 'Medical Pharmacy', 'Making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for \'lorem ipsum\' will uncover.', 'fas fa-stethoscope');
INSERT INTO `front_cms_services_list` (`id`, `title`, `description`, `icon`) VALUES (6, 'Pulmonary', 'Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a for \'lorem ipsum\' will uncover.', 'fas fa-medkit');


#
# TABLE STRUCTURE FOR: front_cms_setting
#

DROP TABLE IF EXISTS `front_cms_setting`;

CREATE TABLE `front_cms_setting` (
  `id` int NOT NULL AUTO_INCREMENT,
  `application_title` varchar(255) NOT NULL,
  `captcha_status` varchar(20) NOT NULL,
  `recaptcha_site_key` varchar(255) NOT NULL,
  `recaptcha_secret_key` varchar(255) NOT NULL,
  `address` varchar(350) NOT NULL,
  `mobile_no` varchar(60) NOT NULL,
  `fax` varchar(60) NOT NULL,
  `receive_contact_email` varchar(255) NOT NULL,
  `email` varchar(60) NOT NULL,
  `footer_text` varchar(255) NOT NULL,
  `fav_icon` varchar(255) NOT NULL,
  `logo` varchar(255) NOT NULL,
  `working_hours` varchar(300) NOT NULL,
  `facebook_url` varchar(100) NOT NULL,
  `twitter_url` varchar(100) NOT NULL,
  `youtube_url` varchar(100) NOT NULL,
  `google_plus` varchar(100) NOT NULL,
  `linkedin_url` varchar(100) NOT NULL,
  `pinterest_url` varchar(100) NOT NULL,
  `instagram_url` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_setting` (`id`, `application_title`, `captcha_status`, `recaptcha_site_key`, `recaptcha_secret_key`, `address`, `mobile_no`, `fax`, `receive_contact_email`, `email`, `footer_text`, `fav_icon`, `logo`, `working_hours`, `facebook_url`, `twitter_url`, `youtube_url`, `google_plus`, `linkedin_url`, `pinterest_url`, `instagram_url`) VALUES (1, 'Ramom - Diagnostic Management System With CMS', 'disable', '', '', '', '+1-954-648-1802', '001 - 785 987 1234', 'info@example.com', 'info@demo.com', '© 2019 <span>Ramom</span>. All Rights Reserved.', 'fav_icon.ico', 'logo.png', '<span>Hours : </span>  Mon To Fri - 9:00 - 20:00,  Sunday Closed', 'https://facebook.com', 'https://twitter.com', 'https://youtube.com', 'https://google.com', 'https://linkedin.com', 'https://pinterest.com', 'https://instagram.com');


#
# TABLE STRUCTURE FOR: front_cms_testimonial
#

DROP TABLE IF EXISTS `front_cms_testimonial`;

CREATE TABLE `front_cms_testimonial` (
  `id` int NOT NULL AUTO_INCREMENT,
  `patient_name` varchar(255) NOT NULL,
  `surname` varchar(355) NOT NULL,
  `image` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `rank` int NOT NULL,
  `created_by` int NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (1, 'Gartrell Wright', 'Los Angeles', 'defualt.png', 'Intexure have done an excellent job presenting the analysis & insights. I am confident in saying  have helped encounter  is to be welcomed and every pain avoided”.', 1, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (2, 'Clifton Hyde', 'Newyork City', 'defualt.png', '“Owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted always holds”.', 4, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (3, 'Emily Lemus', 'Los Angeles', 'defualt.png', '“Intexure have done an excellent job presenting the analysis & insights. I am confident in saying  have helped encounter  is to be welcomed and every pain avoided”.', 5, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (4, 'Michel Jhon', 'CEO', 'defualt.png', '“Owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted always holds”.', 3, 1, '2019-08-23 18:26:42');
INSERT INTO `front_cms_testimonial` (`id`, `patient_name`, `surname`, `image`, `description`, `rank`, `created_by`, `created_at`) VALUES (5, 'Hilda Howard', 'Chicago City', 'defualt.png', '“Owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted always holds”.', 4, 1, '2019-08-23 18:26:42');


#
# TABLE STRUCTURE FOR: global_settings
#

DROP TABLE IF EXISTS `global_settings`;

CREATE TABLE `global_settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `institute_name` varchar(255) NOT NULL,
  `institute_email` varchar(100) NOT NULL,
  `address` text NOT NULL,
  `mobileno` varchar(50) NOT NULL,
  `currency` varchar(50) NOT NULL,
  `currency_symbol` varchar(50) NOT NULL,
  `translation` varchar(20) NOT NULL,
  `footer_text` text NOT NULL,
  `animations` varchar(50) NOT NULL,
  `timezone` varchar(30) NOT NULL,
  `date_format` varchar(20) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `facebook_url` varchar(255) NOT NULL,
  `twitter_url` varchar(255) NOT NULL,
  `linkedin_url` varchar(255) NOT NULL,
  `youtube_url` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `global_settings` (`id`, `institute_name`, `institute_email`, `address`, `mobileno`, `currency`, `currency_symbol`, `translation`, `footer_text`, `animations`, `timezone`, `date_format`, `facebook_url`, `twitter_url`, `linkedin_url`, `youtube_url`, `created_at`, `updated_at`) VALUES (1, 'Contact Center', 'Ramom@example.com', 'Mohammadpur, Dhaka', '+8809678076482', 'BDT', '৳', 'english', 'Contact Center', 'fadeInUp', 'Asia/Dhaka', '%d-%b-%Y', '', '', '', '', '2018-10-22 15:07:49', '2023-11-02 00:57:22');


#
# TABLE STRUCTURE FOR: lab_report_template
#

DROP TABLE IF EXISTS `lab_report_template`;

CREATE TABLE `lab_report_template` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `template` longtext NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: lab_test
#

DROP TABLE IF EXISTS `lab_test`;

CREATE TABLE `lab_test` (
  `id` int NOT NULL AUTO_INCREMENT,
  `category_id` int NOT NULL,
  `name` varchar(155) NOT NULL,
  `patient_price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `production_cost` decimal(18,2) NOT NULL DEFAULT '0.00',
  `test_code` varchar(20) NOT NULL,
  `date` date NOT NULL,
  `created_by` int NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: lab_test_category
#

DROP TABLE IF EXISTS `lab_test_category`;

CREATE TABLE `lab_test_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: labtest_bill
#

DROP TABLE IF EXISTS `labtest_bill`;

CREATE TABLE `labtest_bill` (
  `id` int NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(10) NOT NULL,
  `patient_id` int NOT NULL,
  `referral_id` int NOT NULL,
  `total` decimal(18,2) NOT NULL DEFAULT '0.00',
  `discount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `tax_amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `commission` decimal(18,2) DEFAULT '0.00',
  `paid` decimal(18,2) NOT NULL DEFAULT '0.00',
  `due` decimal(18,2) NOT NULL DEFAULT '0.00',
  `status` tinyint(1) NOT NULL,
  `date` date DEFAULT NULL,
  `hash` varchar(50) NOT NULL,
  `prepared_by` int NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: labtest_bill_details
#

DROP TABLE IF EXISTS `labtest_bill_details`;

CREATE TABLE `labtest_bill_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `labtest_bill_id` int NOT NULL,
  `category_id` int NOT NULL,
  `test_id` int NOT NULL,
  `price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `discount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `commission_amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: labtest_payment_history
#

DROP TABLE IF EXISTS `labtest_payment_history`;

CREATE TABLE `labtest_payment_history` (
  `id` int NOT NULL AUTO_INCREMENT,
  `labtest_bill_id` int NOT NULL,
  `collect_by` int DEFAULT NULL,
  `amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `method_id` int NOT NULL,
  `remarks` text NOT NULL,
  `paid_on` date NOT NULL,
  `coll_type` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: labtest_report
#

DROP TABLE IF EXISTS `labtest_report`;

CREATE TABLE `labtest_report` (
  `id` int NOT NULL AUTO_INCREMENT,
  `labtest_bill_id` int NOT NULL,
  `reporting_date` date DEFAULT NULL,
  `delivery_date` date DEFAULT NULL,
  `delivery_time` time DEFAULT NULL,
  `report_description` longtext,
  `report_remarks` text,
  `status` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: language_list
#

DROP TABLE IF EXISTS `language_list`;

CREATE TABLE `language_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `lang_field` varchar(100) NOT NULL,
  `status` varchar(11) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb3;

INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (1, 'English', 'english', '1', '2018-11-15 17:36:31', '2020-01-09 11:45:23');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (2, 'Bengali', 'bengali', '0', '2018-11-15 17:36:31', '2020-01-11 18:11:42');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (3, 'Arabic', 'arabic', '0', '2018-11-15 17:36:31', '2020-01-07 13:22:02');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (4, 'German', 'german', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:26');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (5, 'Greek', 'greek', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:28');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (6, 'Spanish', 'spanish', '1', '2018-11-15 17:36:31', '2023-09-23 13:54:04');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (7, 'French', 'french', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:31');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (8, 'Hindi', 'hindi', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:33');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (9, 'Hungarian', 'hungarian', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:34');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (10, 'Indonesian', 'indonesian', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:35');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (11, 'Italian', 'italian', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:37');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (12, 'Japanese', 'japanese', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:38');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (13, 'Korean', 'korean', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:40');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (14, 'Latin', 'latin', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:41');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (15, 'Dutch', 'dutch', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:43');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (16, 'Portuguese', 'portuguese', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:44');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (17, 'Russian', 'russian', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:46');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (18, 'Thai', 'thai', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:47');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (19, 'Turkish', 'turkish', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:49');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (20, 'Urdu', 'urdu', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:50');
INSERT INTO `language_list` (`id`, `name`, `lang_field`, `status`, `created_at`, `updated_at`) VALUES (21, 'Chinese', 'chinese', '0', '2018-11-15 17:36:31', '2019-06-17 03:05:51');


#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `word` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `english` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `bengali` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `arabic` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `german` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `greek` varchar(100) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `spanish` varchar(100) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `french` varchar(100) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `hindi` varchar(100) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `hungarian` varchar(100) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `indonesian` varchar(100) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `italian` varchar(100) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `japanese` varchar(100) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `korean` varchar(100) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `latin` varchar(100) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `dutch` varchar(100) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `portuguese` varchar(100) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `russian` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `thai` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `turkish` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `urdu` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `chinese` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=556 DEFAULT CHARSET=utf32 COLLATE=utf32_unicode_ci;

INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (1, 'dashboard', 'Dashboard', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (2, 'create', 'Create', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (3, 'patient', 'Patient', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (4, 'test', 'Test', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (5, 'bill', 'Bill', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (6, 'commission', 'Commission', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (7, 'withdrawal', 'Withdrawal', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (8, 'appointment', 'Appointment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (9, 'voucher', 'Voucher', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (10, 'income_vs_expense', 'Income Vs Expense', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (11, 'search', 'Search', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (12, 'visit_home_page', 'Visit Home Page', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (13, 'language', 'Language', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (14, 'logout', 'Logout', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (15, 'profile', 'Profile', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (16, 'reset_password', 'Reset Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (17, 'global', 'Global', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (18, 'settings', 'Settings', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (19, 'frontend', 'Frontend', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (20, 'setting', 'Setting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (21, 'menu', 'Menu', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (22, 'page', 'Page', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (23, 'section', 'Section', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (24, 'manage', 'Manage', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (25, 'slider', 'Slider', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (26, 'features', 'Features', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (27, 'testimonial', 'Testimonial', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (28, 'service', 'Service', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (29, 'faq', 'Faq', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (30, 'details', 'Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (31, 'list', 'List', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (32, 'category', 'Category', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (33, 'login_deactivate', 'Login Deactivate', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (34, 'inventory', 'Inventory', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (35, 'chemical', 'Chemical', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (36, 'supplier', 'Supplier', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (37, 'unit', 'Unit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (38, 'purchase', 'Purchase', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (39, 'stock', 'Stock', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (40, 'reagent', 'Reagent', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (41, 'assigned', 'Assigned', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (42, 'reports', 'Reports', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (43, 'report', 'Report', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (44, 'payment', 'Payment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (45, 'schedule', 'Schedule', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (46, 'add', 'Add', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (47, 'requested_list', 'Requested List', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (48, 'employee', 'Employee', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (49, 'department', 'Department', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (50, 'designation', 'Designation', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (51, 'hrm', 'Human Resource', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (52, 'payroll', 'Payroll', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (53, 'salary', 'Salary', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (54, 'template', 'Template', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (55, 'assign', 'Assign', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (56, 'summary', 'Summary', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (57, 'leaves', 'Leaves', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (58, 'my_leave', 'My Leave', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (59, 'leave_manage', 'Leave Manage', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (60, 'attendance', 'Attendance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (61, 'set', 'Set', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (62, 'pathology', 'Pathology', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (63, 'lab', 'Lab', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (64, 'refer_manager', 'Refer Manager', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (65, 'referral', 'Referral', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (66, 'my_commission', 'My Commission', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (67, 'statement', 'Statement', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (68, 'payout', 'Payout', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (69, 'office_accounting', 'Office Accounting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (70, 'account', 'Account', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (71, 'head', 'Head', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (72, 'income', 'Income', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (73, 'repots', 'Repots', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (74, 'expense', 'Expense', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (75, 'transitions', 'Transitions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (76, 'balance', 'Balance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (77, 'sheet', 'Sheet', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (78, 'billing', 'Billing', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (79, 'due', 'Due', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (80, 'paid', 'Paid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (81, 'collect', 'Collect', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (82, 'investigation', 'Investigation', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (83, 'sms', 'Sms', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (84, 'email', 'Email', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (85, 'role', 'Role', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (86, 'permission', 'Permission', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (87, 'database', 'Database', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (88, 'backup', 'Backup', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (89, 'invoice', 'Invoice', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (90, 'today_total', 'Today Total', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (91, 'annual', 'Annual', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (92, 'total_strength', 'Total Strength', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (93, 'doctor', 'Doctor', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (94, 'pending', 'Pending', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (95, 'request', 'Request', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (96, 'fees', 'Fees', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (97, 'net', 'Net', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (98, 'payable', 'Payable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (99, 'total', 'Total', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (100, 'this_value_is_required', 'This Value Is Required', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (101, 'enter_valid_email', 'Enter Valid Email', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (102, 'are_you_sure', 'Are You Sure', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (103, 'delete_this_information', 'Delete This Information', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (104, 'yes_continue', 'Yes Continue', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (105, 'cancel', 'Cancel', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (106, 'deleted_note', '*Note : This Data Will Be Permanently Deleted', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (107, 'deleted', 'Deleted', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (108, 'information_deleted', 'Information Deleted', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (109, 'website', 'Website', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (110, 'application', 'Application', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (111, 'name', 'Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (112, 'receive_email_to', 'Receive Email To', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (113, 'captcha_status', 'Captcha Status', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (114, 'select', 'Select', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (115, 'disable', 'Disable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (116, 'enable', 'Enable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (117, 'recaptcha_site_key', 'Recaptcha Site Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (118, 'recaptcha_secret_key', 'Recaptcha Secret Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (119, 'working_hours', 'Working Hours', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (120, 'logo', 'Logo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (121, 'fav_icon', 'Fav Icon', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (122, 'address', 'Address', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (123, 'mobile_no', 'Mobile No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (124, 'fax', 'Fax', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (125, 'footer_text', 'Footer Text', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (126, 'facebook_url', 'Facebook Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (127, 'twitter_url', 'Twitter Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (128, 'youtube_url', 'Youtube Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (129, 'google_plus', 'Google Plus', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (130, 'linkedin_url', 'Linkedin Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (131, 'pinterest_url', 'Pinterest Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (132, 'instagram_url', 'Instagram Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (133, 'save', 'Save', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (134, 'website_page', 'Website Page', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (135, 'welcome', 'Welcome', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (136, 'message', 'Message', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (137, 'doctors', 'Doctors', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (138, 'services', 'Services', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (139, 'call_to_action_section', 'Call To Action Section', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (140, 'options', 'Options', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (141, 'title', 'Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (142, 'subtitle', 'Subtitle', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (143, 'description', 'Description', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (144, 'photo', 'Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (145, 'cta', 'Cta', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (146, 'button_text', 'Button Text', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (147, 'button_url', 'Button Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (148, '_title', ' Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (149, 'meta', 'Meta', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (150, 'keyword', 'Keyword', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (151, 'banner_photo', 'Banner Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (152, 'about', 'About', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (153, 'content', 'Content', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (154, 'about_photo', 'About Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (155, 'parallax_photo', 'Parallax Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (156, 'sl', 'Sl', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (157, 'url', 'Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (158, 'action', 'Action', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (159, 'my_appointment', 'My Appointment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (160, 'appointment_status', 'Appointment Status', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (161, 'date', 'Date', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (162, 'time_slot', 'Time Slot', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (163, 'consultation_fees', 'Consultation Fees', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (164, 'discount', 'Discount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (165, 'remarks', 'Remarks', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (166, 'exploring', 'Exploring', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (167, 'no_schedule_found', 'No Schedule Found', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (168, 'information_has_been_saved_successfully', 'Information Has Been Saved Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (169, 'id', 'Id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (170, 'consultation', 'Consultation', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (171, 'serial', 'Serial', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (172, 'status', 'Status', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (173, 'confirmed', 'Confirmed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (174, 'available', 'Available', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (175, 'staff_id', 'Staff Id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (176, 'general', 'General', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (177, 'theme', 'Theme', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (178, 'institute_name', 'Institute Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (179, 'currency', 'Currency', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (180, 'currency_symbol', 'Currency Symbol', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (181, 'timezone', 'Timezone', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (182, 'date_format', 'Date Format', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (183, 'system_logo', 'System Logo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (184, 'text_logo', 'Text Logo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (185, 'upload', 'Upload', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (186, 'select_ground', 'Select Ground', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (187, 'filter', 'Filter', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (188, 'bill_no', 'Bill No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (189, 'delivery', 'Delivery', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (190, 'lab_test', 'Lab Test', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (191, 'edit', 'Edit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (192, 'code', 'Code', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (193, 'purchase_unit', 'Purchase Unit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (194, 'sale_unit', 'Sale Unit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (195, 'unit_ratio', 'Unit Ratio', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (196, 'purchase_price', 'Purchase Price', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (197, 'sales_price', 'Sales Price', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (198, 'all_select', 'All Select', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (199, 'unpaid', 'Unpaid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (200, 'partly_paid', 'Partly Paid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (201, 'total_paid', 'Total Paid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (202, 'type', 'Type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (203, 'ref_no', 'Ref No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (204, 'pay_via', 'Pay Via', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (205, 'amount', 'Amount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (206, 'dr', 'Dr', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (207, 'cr', 'Cr', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (208, 'ref', 'Ref', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (209, 'attachment', 'Attachment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (210, 'login', 'Login', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (211, 'welcome_to', 'Welcome To', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (212, 'username', 'Username', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (213, 'password', 'Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (214, 'remember', 'Remember', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (215, 'lose_your_password', 'Lose Your Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (216, 'position', 'Position', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (217, 'publish', 'Publish', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (218, 'target_new_window', 'Target New Window', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (219, 'external_url', 'External Url', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (220, 'external_link', 'External Link', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (221, 'successfully', 'Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (222, 'access_denied', 'Access Denied', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (223, 'username_has_already_been_used', 'Username Has Already Been Used', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (224, 'week_day', 'Week Day', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (225, 'time_start', 'Time Start', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (226, 'time_end', 'Time End', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (227, 'per_patient_duration', 'Per Patient Duration', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (228, 'make_closed', 'Make Closed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (229, 'the_consultation_completed', 'The Consultation Completed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (230, 'done', 'Done', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (231, 'the_consultation_has_been_closed', 'The Consultation Has Been Closed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (232, 'requested', 'Requested', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (233, 'create_at', 'Create At', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (234, 'canceled', 'Canceled', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (235, 'apply', 'Apply', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (236, 'close', 'Close', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (237, 'information_has_been_updated_successfully', 'Information Has Been Updated Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (238, 'birthday', 'Birthday', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (239, 'joining_date', 'Joining Date', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (240, 'basic_details', 'Basic Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (241, 'gender', 'Gender', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (242, 'male', 'Male', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (243, 'female', 'Female', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (244, 'religion', 'Religion', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (245, 'blood_group', 'Blood Group', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (246, 'marital_status', 'Marital Status', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (247, 'single', 'Single', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (248, 'married', 'Married', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (249, 'profile_picture', 'Profile Picture', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (250, 'login_details', 'Login Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (251, 'office_details', 'Office Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (252, 'qualification', 'Qualification', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (253, 'social_links', 'Social Links', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (254, 'update', 'Update', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (255, 'patient_id', 'Patient Id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (256, 'guardian', 'Guardian', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (257, 'authentication', 'Authentication', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (258, 'basic', 'Basic', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (259, 'age', 'Age', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (260, 'blood_pressure', 'Blood Pressure', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (261, 'height', 'Height', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (262, 'weight', 'Weight', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (263, 'emergency_contact', 'Emergency Contact', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (264, 'relationship', 'Relationship', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (265, 'history', 'History', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (266, 'completed', 'Completed', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (267, 'undelivered', 'Undelivered', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (268, 'login_authentication_deactivate', 'Login Authentication Deactivate', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (269, 'deactivate_account', 'Deactivate Account', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (270, 'authentication_activate', 'Authentication Activate', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (271, 'referred_by', 'Referred By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (272, 'time', 'Time', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (273, 'price', 'Price', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (274, 'add_rows', 'Add Rows', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (275, 'sub_total', 'Sub Total', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (276, 'tax', 'Tax', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (277, 'received', 'Received', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (278, 'enter_payment_amount', 'Enter Payment Amount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (279, 'write_your_remarks', 'Write Your Remarks', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (280, 'roles', 'Roles', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (281, 'system_role', 'System Role', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (282, 'yes', 'Yes', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (283, 'role_permission_for', 'Role Permission For', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (284, 'feature', 'Feature', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (285, 'view', 'View', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (286, 'delete', 'Delete', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (287, 'ordered', 'Ordered', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (288, 'quantity', 'Quantity', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (289, 'net_total', 'Net Total', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (290, 'bill_view', 'Bill View', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (291, 'add_payment', 'Add Payment', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (292, 'to', 'To', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (293, 'company', 'Company', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (294, 'sub', 'Sub', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (295, 'paid_amount', 'Paid Amount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (296, 'prepared_by', 'Prepared By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (297, 'authorised_by', 'Authorised By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (298, 'print', 'Print', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (299, 'paid_on', 'Paid On', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (300, 'attach_document', 'Attach Document', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (301, 'the_configuration_has_been_updated', 'The Configuration Has Been Updated', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (302, 'retype_password', 'Retype Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (303, 'contact_number', 'Contact Number', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (304, 'company_name', 'Company Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (305, 'product', 'Product', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (306, 'stock_by', 'Stock By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (307, 'inovice_no', 'Inovice No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (308, 'sales_unit', 'Sales Unit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (309, 'for', 'For', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (310, 'select_multiple_chemical', 'Select Multiple Chemical', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (311, 'payment_history', 'Payment History', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (312, 'sex', 'Sex', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (313, 'from', 'From', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (314, 'net_payable', 'Net Payable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (315, 'collect_by', 'Collect By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (316, 'unpublished_on_website', 'Unpublished On Website', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (317, 'published_on_website', 'Published On Website', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (318, 'grade', 'Grade', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (319, 'overtime', 'Overtime', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (320, 'allowances', 'Allowances', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (321, 'name_of_allowance', 'Name Of Allowance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (322, 'deductions', 'Deductions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (323, 'name_of_deductions', 'Name Of Deductions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (324, 'allowance', 'Allowance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (325, 'deduction', 'Deduction', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (326, 'salary_details', 'Salary Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (327, 'no_information_available', 'No Information Available', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (328, 'transactions', 'Transactions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (329, 'sms_config', 'Sms Config', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (330, 'sms_template', 'Sms Template', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (331, 'select_a_sms_service', 'Select A Sms Service', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (332, 'disabled', 'Disabled', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (333, 'clickatell_username', 'Clickatell Username', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (334, 'clickatell_password', 'Clickatell Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (335, 'clickatell_api_key', 'Clickatell Api Key', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (336, 'registered_number', 'Registered Number', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (337, 'account_sid', 'Account Sid', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (338, 'auth_token', 'Auth Token', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (339, 'account_registered', 'Account Registered', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (340, 'notify_enable', 'Notify Enable', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (341, 'body', 'Body', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (342, 'appointment_confirmation', 'Appointment Confirmation', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (343, 'appointment_canceled', 'Appointment Canceled', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (344, 'appointment_request', 'Appointment Request', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (345, 'reporting', 'Reporting', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (346, 'button_text_1', 'Button Text 1', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (347, 'button_url_1', 'Button Url 1', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (348, 'button_text_2', 'Button Text 2', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (349, 'button_url_2', 'Button Url 2', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (350, 'left', 'Left', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (351, 'center', 'Center', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (352, 'right', 'Right', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (353, 'icon', 'Icon', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (354, 'surname', 'Surname', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (355, 'rank', 'Rank', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (356, 'staff', 'Staff', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (357, 'paid_by', 'Paid By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (358, 'user', 'User', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (359, 'payslip', 'Payslip', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (360, 'add_employee', 'Add Employee', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (361, 'bank_details', 'Bank Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (362, 'skipped_bank_details', 'Skipped Bank Details', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (363, 'bank_name', 'Bank Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (364, 'holder_name', 'Holder Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (365, 'bank', 'Bank', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (366, 'branch', 'Branch', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (367, 'ifsc_code', 'Ifsc Code', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (368, 'account_no', 'Account No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (369, 'restore', 'Restore', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (370, 'create_backup', 'Create Backup', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (371, 'file', 'File', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (372, 'backup_size', 'Backup Size', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (373, 'file_upload', 'File Upload', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (374, 'flag', 'Flag', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (375, 'stats', 'Stats', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (376, 'created_at', 'Created At', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (377, 'updated_at', 'Updated At', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (378, 'edit_word', 'Edit Word', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (379, 'flag_icon', 'Flag Icon', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (380, 'language_unpublished', 'Language Unpublished', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (381, 'language_published', 'Language Published', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (382, 'transaction', 'Transaction', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (383, 'month_of_salary', 'Month Of Salary', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (384, 'basic_salary', 'Basic Salary', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (385, 'payment_type', 'Payment Type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (386, 'bank_account', 'Bank Account', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (387, 'actions', 'Actions', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (388, 'document', 'Document', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (389, 'download', 'Download', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (390, 'opening_balance', 'Opening Balance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (391, 'total_dr', 'Total Dr', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (392, 'total_cr', 'Total Cr', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (393, 'contact', 'Contact', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (394, 'box_title', 'Box Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (395, 'box_description', 'Box Description', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (396, 'box_photo', 'Box Photo', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (397, 'form_title', 'Form Title', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (398, 'phone', 'Phone', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (399, 'submit_button_text', 'Submit Button Text', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (400, 'map_iframe', 'Map Iframe', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (401, 'system_name', 'System Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (402, 'month', 'Month', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (403, 'patient_price', 'Patient Price', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (404, 'production_cost', 'Production Cost', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (405, 'created_by', 'Created By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (406, 'test_category', 'Test Category', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (407, 'test_name', 'Test Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (408, 'test_code', 'Test Code', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (409, 'staff_name', 'Staff Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (410, 'percentage', 'Percentage', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (411, 'salary_assign', 'Salary Assign', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (412, 'pay_now', 'Pay Now', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (413, 'overtime_total_hour', 'Overtime Total Hour', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (414, 'overtime_amount', 'Overtime Amount', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (415, 'leave_category', 'Leave Category', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (416, 'days', 'Days', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (417, 'leave', 'Leave', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (418, 'date_of_start', 'Date Of Start', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (419, 'date_of_end', 'Date Of End', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (420, 'leave_type', 'Leave Type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (421, 'reason', 'Reason', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (422, 'comments', 'Comments', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (423, 'accepted', 'Accepted', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (424, 'start_date', 'Start Date', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (425, 'end_date', 'End Date', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (426, 'approved', 'Approved', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (427, 'reject', 'Reject', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (428, 'select_all', 'Select All', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (429, 'not_selected', 'Not Selected', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (430, 'present', 'Present', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (431, 'absent', 'Absent', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (432, 'holiday', 'Holiday', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (433, 'late', 'Late', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (434, 'current_balance', 'Current Balance', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (435, 'no', 'No', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (436, 'current', 'Current', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (437, 'qty', 'Qty', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (438, 'payment_successfull', 'Payment Successfull', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (439, 'payment_by', 'Payment By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (440, 'chemical_wise_stock', 'Chemical Wise Stock', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (441, 'sale', 'Sale', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (442, 'in_qty', 'In Qty', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (443, 'out_qty', 'Out Qty', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (444, 'sale_profit', 'Sale Profit', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (445, 'paid_via', 'Paid Via', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (446, 'collected_by', 'Collected By', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (447, 'all', 'All', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (448, 'add_short_bio', 'Add Short Bio', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (449, 'email_config', 'Email Config', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (450, 'email_triggers', 'Email Triggers', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (451, 'system_email', 'System Email', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (452, 'subject', 'Subject', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (453, 'forgot_password', 'Forgot Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (454, 'payslip_generated', 'Payslip Generated', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (455, 'leave_approve', 'Leave Approve', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (456, 'leave_reject', 'Leave Reject', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (457, 'username_password_incorrect', 'Username Password Incorrect', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (458, 'change', 'Change', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (459, 'current_password', 'Current Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (460, 'new_password', 'New Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (461, 'confirm_password', 'Confirm Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (462, 'cdr_list', 'Cdr List', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (463, 'call_report', 'Call Report', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (464, 'password_restoration', 'Password Restoration', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (465, 'forgot', 'Forgot', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (466, 'back_to_login', 'Back To Login', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (467, 'Users', 'Users', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (468, 'add_user', 'Add User', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (469, 'Extension No.', 'Extension No.', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (470, 'Active', 'Active', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (471, 'Inactive', 'Inactive', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (472, 'Administrator', 'Administrator', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (473, 'self', 'Self', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (474, 'Room Manager', 'Room Manager', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (475, 'create_user', 'Create User', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (476, 'user_id', 'User Id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (477, 'extension', 'Extension', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (478, 'room_manager', 'Room Manager', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (479, 'remember me', 'Remember Me', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (480, 'forget password', 'Forget Password', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (481, 'log in', 'Log In', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (482, 'SMS API', 'SMS API', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (483, 'SMS Templates', 'SMS Templates', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (484, 'SMS Campaign', 'SMS Campaign', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (485, 'SMS Reports', 'SMS Reports', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (486, 'Email API', 'Email API', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (487, 'Email Templates', 'Email Templates', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (488, 'Email Campaign', 'Email Campaign', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (489, 'Email Reports', 'Email Reports', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (490, 'Voice', 'Voice', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (491, 'Quick Call', 'Quick Call', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (492, 'trunk\'s', 'Trunk\'s', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (493, 'Caller ID\'s', 'Caller ID\'s', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (494, 'sound_file\'s', 'Sound File\'s', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (495, 'Text to Speech', 'Text To Speech', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (496, 'user management', 'User Management', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (497, 'Contacts', 'Contacts', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (498, 'campaign', 'Campaign', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (499, 'created_time', 'Created Time', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (500, 'campaign_name', 'Campaign Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (501, 'call_group', 'Call Group', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (502, 'caller_id', 'Caller Id', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (503, 'call_count', 'Call Count', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (504, 'play_type', 'Play Type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (505, 'play', 'Play', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (506, 'campaign_start_time', 'Campaign Start Time', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (507, 'last_run_time', 'Last Run Time', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (508, 'Trunk', 'Trunk', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (509, 'created time', 'Created Time', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (510, 'trunk_name', 'Trunk Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (511, 'CLID Name', 'CLID Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (512, 'Trunk Type', 'Trunk Type', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (513, 'Contact List', 'Contact List', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (514, 'information', 'Information', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (515, 'datetime', 'Datetime', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (516, 'Group', 'Group', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (517, 'select CSV', 'Select CSV', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (518, 'call to', 'Call To', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (519, 'Caller ID', 'Caller ID', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (520, 'Start Call', 'Start Call', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (521, 'Quick Call Lists', 'Quick Call Lists', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (522, 'date_time', 'Date Time', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (523, 'call_to', 'Call To', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (524, 'New Trunk added successfully', 'New Trunk Added Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (525, 'CallerID\'s', 'CallerID\'s', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (526, 'CallerID', 'CallerID', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (527, 'channels', 'Channels', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (528, 'New CallerID added successfully', 'New CallerID Added Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (529, 'Sounds', 'Sounds', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (530, 'Sound', 'Sound', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (531, 'sound_name', 'Sound Name', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (532, 'Sound File', 'Sound File', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (533, 'New Sound added successfully', 'New Sound Added Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (534, 'TTS', 'TTS', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (535, 'TTS Text', 'TTS Text', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (536, 'New TTS added successfully', 'New TTS Added Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (537, 'Call Initiated successfully', 'Call Initiated Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (538, 'New Campaign created successfully', 'New Campaign Created Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (539, 'Config CMP.', 'Config CMP.', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (540, 'Config', 'Config', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (541, 'Cmp', 'Cmp', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (542, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (543, 'Ami', 'Ami', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (544, 'Ami Config', 'Ami Config', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (545, 'last updated', 'Last Updated', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (546, 'host', 'Host', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (547, 'port', 'Port', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (548, 'Data', 'Data', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (549, ' Updated successfully', ' Updated Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (550, 'Edit campaign', 'Edit Campaign', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (551, 'Campaign updated successfully', 'Campaign Updated Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (552, 'time_range', 'Time Range', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (553, 'time_range(From-To)', 'Time Range(From-To)', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (554, 'Campaign config updated successfully', 'Campaign Config Updated Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO `languages` (`id`, `word`, `english`, `bengali`, `arabic`, `german`, `greek`, `spanish`, `french`, `hindi`, `hungarian`, `indonesian`, `italian`, `japanese`, `korean`, `latin`, `dutch`, `portuguese`, `russian`, `thai`, `turkish`, `urdu`, `chinese`) VALUES (555, 'Call Re-Initiated successfully', 'Call Re-Initiated Successfully', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');


#
# TABLE STRUCTURE FOR: leave_application
#

DROP TABLE IF EXISTS `leave_application`;

CREATE TABLE `leave_application` (
  `id` int NOT NULL AUTO_INCREMENT,
  `staff_id` int NOT NULL,
  `category_id` varchar(20) NOT NULL,
  `reason` text CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `leave_days` varchar(20) NOT NULL DEFAULT '0',
  `status` varchar(10) NOT NULL DEFAULT '1',
  `apply_date` datetime NOT NULL,
  `orig_file_name` varchar(255) NOT NULL,
  `enc_file_name` varchar(255) NOT NULL,
  `approved_by` longtext NOT NULL,
  `comments` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: leave_category
#

DROP TABLE IF EXISTS `leave_category`;

CREATE TABLE `leave_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf32 COLLATE utf32_unicode_ci NOT NULL,
  `days` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: login_credential
#

DROP TABLE IF EXISTS `login_credential`;

CREATE TABLE `login_credential` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `username` varchar(100) NOT NULL,
  `password` varchar(250) NOT NULL,
  `role` int NOT NULL,
  `active` int NOT NULL COMMENT '1(active) 0(deactivate)',
  `last_login` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (1, 1, 'superman', '$2y$10$Fc88bs4Y1qcPDm8qQ9ms5ORx/PgdBQOiiJBN.tbu9rtLjwL5FKUaa', 1, 1, '2023-11-12 23:36:40', '2023-06-27 17:28:08', '2023-11-12 23:36:40');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (3, 2, 'admin1', '$2y$10$.66FwghNAGrUgYyr9pcBYeQYG/HXVYnRPG6uLeLYvqf32q9Vy/KXy', 10, 1, NULL, '2023-09-23 15:23:10', '2023-09-23 15:23:10');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (4, 3, 'admin', '$2y$10$cGMZ1DhMAEeCP6Z0/m8C3.GQN.AdNu/t45MV2r69dOGHr0D9j/HyW', 2, 1, '2023-10-02 12:52:02', '2023-10-02 10:49:05', '2023-10-02 10:52:02');
INSERT INTO `login_credential` (`id`, `user_id`, `username`, `password`, `role`, `active`, `last_login`, `created_at`, `updated_at`) VALUES (5, 4, 'agente01', '$2y$10$r4MVnWXOSjXtT4qbVSiJO.I05vu2xT66rlGF/ZyKWd.9g9k.9r6g.', 10, 1, NULL, '2023-10-02 10:53:03', '2023-10-02 10:53:03');


#
# TABLE STRUCTURE FOR: messages
#

DROP TABLE IF EXISTS `messages`;

CREATE TABLE `messages` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `chat_id` int DEFAULT NULL,
  `to_id` int DEFAULT NULL,
  `from_id` int DEFAULT NULL,
  `attachment_url` text CHARACTER SET ascii COLLATE ascii_general_ci,
  `message` text,
  `type` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=latin1;

INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('43', 3, 2, 1, '', 'Hello', 'text', '2023-10-06 00:52:59', '2023-10-06 00:52:59');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('44', 3, 2, 1, '', 'are you there?', 'text', '2023-10-06 00:55:16', '2023-10-06 00:55:16');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('45', 3, 1, 2, '', 'Yes', 'text', '2023-10-06 00:58:04', '2023-10-06 00:58:04');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('46', 3, 1, 2, '', 'Hi', 'text', '2023-10-06 00:58:29', '2023-10-06 00:58:29');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('47', 3, 2, 1, '', 'hello', 'text', '2023-10-06 00:58:32', '2023-10-06 00:58:32');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('48', 3, 1, 2, '', 'How are you? ', 'text', '2023-10-06 00:58:36', '2023-10-06 00:58:36');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('49', 3, 2, 1, '', 'what was the issue?', 'text', '2023-10-06 00:58:39', '2023-10-06 00:58:39');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('50', 3, 1, 2, '', 'Very slow rendering ', 'text', '2023-10-06 00:58:49', '2023-10-06 00:58:49');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('51', 3, 2, 1, '', 'the time is showing 8 hours ago', 'text', '2023-10-06 00:58:50', '2023-10-06 00:58:50');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('52', 3, 2, 1, '', 'ya', 'text', '2023-10-06 00:58:54', '2023-10-06 00:58:54');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('53', 3, 1, 2, '', 'I have found something ', 'text', '2023-10-06 00:58:59', '2023-10-06 00:58:59');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('54', 3, 2, 1, '', 'what is it?', 'text', '2023-10-06 00:59:09', '2023-10-06 00:59:09');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('55', 3, 1, 2, '', 'This 8 hours are server time ', 'text', '2023-10-06 00:59:10', '2023-10-06 00:59:10');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('56', 3, 2, 1, '', 'ok', 'text', '2023-10-06 00:59:39', '2023-10-06 00:59:39');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('57', 3, 1, 2, '', 'More we need to make it live on http for calling ', 'text', '2023-10-06 00:59:49', '2023-10-06 00:59:49');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('58', 3, 2, 1, '', 'you mean https', 'text', '2023-10-06 01:00:06', '2023-10-06 01:00:06');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('59', 3, 1, 2, '', 'On whatsapp', 'text', '2023-10-06 01:00:40', '2023-10-06 01:00:40');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('60', 3, 1, 2, '', '', 'text', '2023-10-20 14:48:14', '2023-10-20 14:48:14');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('61', 3, 1, 2, '', '', 'text', '2023-10-20 16:12:44', '2023-10-20 16:12:44');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('62', 3, 1, 2, '', '', 'text', '2023-10-28 22:11:47', '2023-10-28 22:11:47');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('63', 3, 1, 2, '', '', 'text', '2023-10-28 22:12:30', '2023-10-28 22:12:30');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('64', 3, 1, 2, '', '', 'text', '2023-10-28 22:25:11', '2023-10-28 22:25:11');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('65', 3, 1, 2, 'https://api-cc.sohub.com.bd/server/api/index.php?action=view&filename=653d366366396_5f5c67053340e033.jpg', '', 'image', '2023-10-28 22:27:16', '2023-10-28 22:27:16');
INSERT INTO `messages` (`id`, `chat_id`, `to_id`, `from_id`, `attachment_url`, `message`, `type`, `created_at`, `updated_at`) VALUES ('66', 3, 1, 2, 'https://api-cc.sohub.com.bd/server/api/index.php?action=view&filename=653d368ddce18_2a9ae11ea4dcf36d.jpg', '', 'image', '2023-10-28 22:27:59', '2023-10-28 22:27:59');


#
# TABLE STRUCTURE FOR: patient
#

DROP TABLE IF EXISTS `patient`;

CREATE TABLE `patient` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `patient_id` varchar(10) NOT NULL,
  `category_id` int NOT NULL,
  `birthday` date NOT NULL,
  `sex` varchar(10) NOT NULL,
  `blood_group` varchar(10) NOT NULL,
  `blood_pressure` varchar(100) NOT NULL,
  `height` varchar(10) NOT NULL,
  `weight` varchar(10) NOT NULL,
  `marital_status` varchar(10) NOT NULL,
  `age` varchar(10) DEFAULT NULL,
  `address` text NOT NULL,
  `mobileno` varchar(30) NOT NULL,
  `email` varchar(200) NOT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `guardian` varchar(200) NOT NULL,
  `relationship` varchar(200) NOT NULL,
  `gua_mobileno` varchar(30) NOT NULL,
  `source` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: patient_category
#

DROP TABLE IF EXISTS `patient_category`;

CREATE TABLE `patient_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

INSERT INTO `patient_category` (`id`, `name`) VALUES (1, 'Test');


#
# TABLE STRUCTURE FOR: patient_documents
#

DROP TABLE IF EXISTS `patient_documents`;

CREATE TABLE `patient_documents` (
  `id` int NOT NULL AUTO_INCREMENT,
  `patient_id` int NOT NULL,
  `title` varchar(255) NOT NULL,
  `type` varchar(100) NOT NULL,
  `remarks` text NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `enc_name` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: payment_type
#

DROP TABLE IF EXISTS `payment_type`;

CREATE TABLE `payment_type` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: payout_commission
#

DROP TABLE IF EXISTS `payout_commission`;

CREATE TABLE `payout_commission` (
  `id` int NOT NULL AUTO_INCREMENT,
  `staff_id` int NOT NULL,
  `bill_no` varchar(11) NOT NULL,
  `before_payout` decimal(18,2) NOT NULL DEFAULT '0.00',
  `amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `pay_via` int NOT NULL,
  `remarks` text,
  `paid_by` int NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: payslip
#

DROP TABLE IF EXISTS `payslip`;

CREATE TABLE `payslip` (
  `id` int NOT NULL AUTO_INCREMENT,
  `staff_id` int NOT NULL,
  `month` varchar(20) DEFAULT NULL,
  `year` varchar(20) NOT NULL,
  `basic_salary` decimal(18,2) NOT NULL DEFAULT '0.00',
  `total_allowance` decimal(18,2) NOT NULL DEFAULT '0.00',
  `total_deduction` decimal(18,2) NOT NULL DEFAULT '0.00',
  `net_salary` decimal(18,2) NOT NULL DEFAULT '0.00',
  `bill_no` varchar(25) NOT NULL,
  `remarks` text NOT NULL,
  `pay_via` tinyint(1) NOT NULL,
  `hash` varchar(255) DEFAULT NULL,
  `paid_by` int NOT NULL,
  `payment_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: payslip_details
#

DROP TABLE IF EXISTS `payslip_details`;

CREATE TABLE `payslip_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `payslip_id` varchar(20) NOT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `type` tinyint NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: permission
#

DROP TABLE IF EXISTS `permission`;

CREATE TABLE `permission` (
  `id` int NOT NULL AUTO_INCREMENT,
  `module_id` int NOT NULL,
  `name` varchar(100) NOT NULL,
  `prefix` varchar(100) NOT NULL,
  `show_view` tinyint DEFAULT '1',
  `show_add` tinyint DEFAULT '1',
  `show_edit` tinyint DEFAULT '1',
  `show_delete` tinyint DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb3;

INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (1, 2, 'Patient', 'patient', 1, 1, 1, 1, '2019-05-27 16:28:52');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (2, 2, 'Patient Category', 'patient_category', 1, 1, 1, 1, '2019-05-27 16:28:52');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (3, 6, 'Employee', 'employee', 1, 1, 1, 1, '2019-05-27 16:28:52');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (4, 6, 'Department', 'department', 1, 1, 1, 1, '2019-05-27 16:28:52');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (5, 6, 'Designation', 'designation', 1, 1, 1, 1, '2019-05-27 16:28:52');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (6, 6, 'Login Deactivate', 'employee_disable_authentication', 1, 0, 1, 0, '2019-05-27 23:56:59');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (7, 7, 'Salary Template', 'salary_template', 1, 1, 1, 1, '2019-05-27 17:09:28');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (8, 7, 'Salary Assign', 'salary_assign', 1, 1, 0, 0, '2019-05-27 17:09:34');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (9, 8, 'Lab Test', 'lab_test', 1, 1, 1, 1, '2019-05-27 16:28:52');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (10, 8, 'Test Category', 'test_category', 1, 1, 1, 1, '2019-05-27 16:28:53');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (11, 12, 'Test Report', 'test_report', 1, 1, 1, 0, '2019-05-27 16:28:53');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (12, 12, 'Test Report Template', 'test_report_template', 1, 1, 1, 1, '2019-05-27 16:28:53');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (13, 11, 'Lab Test Bill', 'lab_test_bill', 1, 1, 0, 1, '2019-05-27 23:12:14');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (14, 11, 'Test Bill Report', 'test_bill_report', 1, 0, 0, 0, '2019-05-27 23:12:28');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (15, 11, 'Test Bill Payment', 'test_bill_payment', 1, 1, 0, 0, '2019-05-27 23:12:28');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (16, 9, 'Referral Assign', 'referral_assign', 1, 1, 1, 1, '2019-05-27 23:34:50');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (17, 9, 'Commission Withdrawal', 'commission_withdrawal', 1, 1, 0, 1, '2019-05-27 23:34:59');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (18, 9, 'Referral Reports', 'referral_reports', 1, 0, 0, 0, '2019-05-27 23:35:02');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (19, 2, 'Login Deactivate', 'patient_disable_authentication', 1, 0, 1, 0, '2019-05-27 16:28:52');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (20, 3, 'Purchase Payment', 'purchase_payment', 1, 1, 0, 0, '2019-05-28 01:02:18');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (21, 13, 'Global Setting', 'global_setting', 1, 1, 0, 0, '2019-05-28 02:28:04');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (22, 13, 'Email Setting', 'email_setting', 1, 1, 0, 0, '2019-05-29 12:42:40');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (23, 13, 'Language', 'language', 1, 1, 1, 1, '2019-05-29 01:10:08');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (24, 13, 'Database Backup', 'database_backup', 1, 1, 0, 1, '2019-05-28 12:54:40');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (25, 13, 'Database Restore', 'database_restore', 0, 1, 0, 0, '2019-05-28 13:07:49');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (26, 7, 'Salary Payment', 'salary_payment', 1, 1, 0, 0, '2019-05-30 14:27:03');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (27, 7, 'Salary Summary Report', 'salary_summary_report', 1, 0, 0, 0, '2019-05-31 19:46:17');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (28, 7, 'Leave Category', 'leave_category', 1, 1, 1, 1, '2019-06-02 01:12:59');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (29, 7, 'My Leave', 'my_leave', 1, 1, 0, 1, '2019-06-03 21:01:42');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (30, 7, 'Leave Manage', 'leave_manage', 1, 1, 0, 1, '2019-06-04 14:40:20');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (31, 7, 'Staff Attendance', 'staff_attendance', 1, 1, 0, 0, '2019-06-05 01:53:37');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (32, 10, 'Account', 'account', 1, 1, 1, 1, '2019-06-07 16:58:38');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (33, 10, 'Voucher', 'voucher', 1, 1, 1, 1, '2019-06-09 01:17:14');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (34, 10, 'Voucher Head', 'voucher_head', 1, 1, 1, 1, '2019-06-08 19:00:33');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (35, 10, 'Accounting Reports', 'accounting_reports', 1, 0, 0, 0, '2019-06-09 20:56:59');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (36, 4, 'Schedule', 'schedule', 1, 1, 1, 1, '2019-06-13 05:47:17');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (37, 5, 'Appointment', 'appointment', 1, 1, 1, 1, '2019-06-13 05:56:41');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (38, 5, 'Appointment Request', 'appointment_request', 1, 0, 1, 1, '2019-06-14 16:21:02');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (39, 1, 'Today Invoice Widget', 'today_invoice_widget', 1, 0, 0, 0, '2019-06-17 00:02:40');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (40, 1, 'Today Commission Widget', 'today_commission_widget', 1, 0, 0, 0, '2019-06-17 00:02:40');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (41, 1, 'Today Income Widget', 'today_income_widget', 1, 0, 0, 0, '2019-06-17 00:02:40');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (42, 1, 'Today Expense Widget', 'today_expense_widget', 1, 0, 0, 0, '2019-06-17 00:02:40');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (43, 1, 'Annual Income Vs Expense Chart', 'annual_income_vs_expense_chart', 1, 0, 0, 0, '2019-06-17 00:27:47');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (44, 1, 'Patient Count Widget', 'patient_count_widget', 1, 0, 0, 0, '2019-06-17 00:38:33');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (45, 1, 'Doctor Count Widget', 'doctor_count_widget', 1, 0, 0, 0, '2019-06-17 00:38:33');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (46, 1, 'Employee Count Widget', 'employee_count_widget', 1, 0, 0, 0, '2019-06-17 00:38:33');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (47, 1, 'Appointment Count Widget', 'appointment_count_widget', 1, 0, 0, 0, '2019-06-17 00:38:33');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (48, 1, 'Pathology Fees Summary Chart', 'pathology_fees_summary_chart', 1, 0, 0, 0, '2019-06-17 00:48:28');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (49, 14, 'Frontend Setting', 'frontend_setting', 1, 1, 0, 0, '2019-09-11 03:24:07');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (50, 14, 'Frontend Menu', 'frontend_menu', 1, 1, 1, 1, '2019-09-11 04:03:39');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (51, 14, 'Frontend Section', 'frontend_section', 1, 1, 0, 0, '2019-09-11 04:26:11');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (52, 14, 'Manage Page', 'manage_page', 1, 1, 1, 1, '2019-09-11 05:54:08');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (53, 14, 'Frontend Slider', 'frontend_slider', 1, 1, 1, 1, '2019-09-11 06:12:31');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (54, 14, 'Frontend Features', 'frontend_features', 1, 1, 1, 1, '2019-09-11 06:47:51');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (55, 14, 'Frontend Testimonial', 'frontend_testimonial', 1, 1, 1, 1, '2019-09-11 06:54:30');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (56, 14, 'Frontend Services', 'frontend_services', 1, 1, 1, 1, '2019-09-11 07:01:44');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (57, 14, 'Frontend Faq', 'frontend_faq', 1, 1, 1, 1, '2019-09-11 07:06:16');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (58, 13, 'Sms Setting', 'sms_setting', 1, 1, 0, 0, '2019-09-13 11:41:37');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (59, 14, 'Doctor Short Bio', 'doctor_short_bio', 0, 1, 0, 0, '2019-09-17 20:13:12');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (60, 1, 'Appointment Status Chart', 'appointment_status_chart', 1, 0, 0, 0, '2019-06-17 00:48:28');
INSERT INTO `permission` (`id`, `module_id`, `name`, `prefix`, `show_view`, `show_add`, `show_edit`, `show_delete`, `created_at`) VALUES (61, 9, 'My Commission', 'my_commission', 1, 0, 0, 0, '2019-06-17 00:48:28');


#
# TABLE STRUCTURE FOR: permission_modules
#

DROP TABLE IF EXISTS `permission_modules`;

CREATE TABLE `permission_modules` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `prefix` varchar(50) NOT NULL,
  `system` tinyint(1) NOT NULL,
  `sorted` tinyint NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3;

INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (1, 'Dashboard', 'dashboard', 1, 1, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (2, 'Patient Details', 'patient_details', 1, 3, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (4, 'Schedule', 'schedule', 1, 5, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (5, 'Appointment', 'appointment', 1, 6, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (6, 'Employee', 'employee', 1, 7, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (7, 'Human Resources', 'human_resources', 1, 8, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (8, 'Pathology', 'test_manager', 1, 9, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (9, 'Refer Manager', 'refer_manager', 1, 10, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (10, 'Office Accounting', 'office_accounting', 1, 11, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (11, 'Pathology Billing', 'billing', 1, 12, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (12, 'Investigation Report', 'investigation_report', 1, 13, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (13, 'Settings', 'settings', 1, 14, '2019-05-27 04:23:00');
INSERT INTO `permission_modules` (`id`, `name`, `prefix`, `system`, `sorted`, `created_at`) VALUES (14, 'Website', 'website', 1, 2, '2019-05-27 04:23:00');


#
# TABLE STRUCTURE FOR: purchase_bill
#

DROP TABLE IF EXISTS `purchase_bill`;

CREATE TABLE `purchase_bill` (
  `id` int NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(200) NOT NULL,
  `supplier_id` int NOT NULL,
  `remarks` text NOT NULL,
  `total` decimal(18,2) NOT NULL DEFAULT '0.00',
  `discount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `paid` decimal(18,2) NOT NULL DEFAULT '0.00',
  `due` decimal(18,2) NOT NULL DEFAULT '0.00',
  `payment_status` int NOT NULL,
  `purchase_status` int NOT NULL,
  `hash` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `prepared_by` int DEFAULT NULL,
  `modifier_id` int DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: purchase_bill_details
#

DROP TABLE IF EXISTS `purchase_bill_details`;

CREATE TABLE `purchase_bill_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `purchase_bill_id` int NOT NULL,
  `chemical_id` varchar(20) NOT NULL,
  `unit_price` decimal(18,2) NOT NULL DEFAULT '0.00',
  `quantity` varchar(20) NOT NULL,
  `discount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `sub_total` decimal(18,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: purchase_payment_history
#

DROP TABLE IF EXISTS `purchase_payment_history`;

CREATE TABLE `purchase_payment_history` (
  `id` int NOT NULL AUTO_INCREMENT,
  `purchase_bill_id` varchar(11) NOT NULL,
  `payment_by` int DEFAULT NULL,
  `amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `pay_via` varchar(25) NOT NULL,
  `remarks` text NOT NULL,
  `attach_orig_name` varchar(255) DEFAULT NULL,
  `attach_file_name` varchar(255) DEFAULT NULL,
  `paid_on` date DEFAULT NULL,
  `coll_type` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: referral_commission
#

DROP TABLE IF EXISTS `referral_commission`;

CREATE TABLE `referral_commission` (
  `id` int NOT NULL AUTO_INCREMENT,
  `staff_id` int NOT NULL,
  `test_id` int NOT NULL,
  `percentage` varchar(10) NOT NULL,
  `assign_by` int NOT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: reset_password
#

DROP TABLE IF EXISTS `reset_password`;

CREATE TABLE `reset_password` (
  `key` longtext NOT NULL,
  `username` varchar(100) NOT NULL,
  `login_credential_id` varchar(100) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: roles
#

DROP TABLE IF EXISTS `roles`;

CREATE TABLE `roles` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `prefix` varchar(50) DEFAULT NULL,
  `is_system` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3;

INSERT INTO `roles` (`id`, `name`, `prefix`, `is_system`) VALUES (1, 'Super Admin', 'superadmin', '1');
INSERT INTO `roles` (`id`, `name`, `prefix`, `is_system`) VALUES (2, 'Administrator', 'administrator', '1');
INSERT INTO `roles` (`id`, `name`, `prefix`, `is_system`) VALUES (8, 'Room Manager', 'roommanager', '1');
INSERT INTO `roles` (`id`, `name`, `prefix`, `is_system`) VALUES (10, 'Agent', 'agent', '1');
INSERT INTO `roles` (`id`, `name`, `prefix`, `is_system`) VALUES (11, 'Salesperson', 'salesperson', '1');


#
# TABLE STRUCTURE FOR: salary_template
#

DROP TABLE IF EXISTS `salary_template`;

CREATE TABLE `salary_template` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `basic_salary` decimal(18,2) NOT NULL DEFAULT '0.00',
  `overtime_salary` varchar(100) NOT NULL DEFAULT '0',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: salary_template_details
#

DROP TABLE IF EXISTS `salary_template_details`;

CREATE TABLE `salary_template_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `salary_template_id` varchar(20) NOT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `type` tinyint NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: schedule
#

DROP TABLE IF EXISTS `schedule`;

CREATE TABLE `schedule` (
  `id` int NOT NULL AUTO_INCREMENT,
  `day` varchar(100) NOT NULL,
  `doctor_id` varchar(11) NOT NULL,
  `time_start` time NOT NULL,
  `time_end` time NOT NULL,
  `per_patient_time` varchar(50) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `consultation_fees` decimal(18,2) DEFAULT '0.00',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: sms_config
#

DROP TABLE IF EXISTS `sms_config`;

CREATE TABLE `sms_config` (
  `id` int NOT NULL AUTO_INCREMENT,
  `clickatell_username` varchar(255) NOT NULL,
  `clickatell_password` varchar(255) NOT NULL,
  `clickatell_api_key` varchar(255) NOT NULL,
  `clickatell_number` varchar(255) NOT NULL,
  `twilio_account_sid` varchar(255) NOT NULL,
  `twilio_auth_token` varchar(255) NOT NULL,
  `twilio_number` varchar(255) NOT NULL,
  `active_gateway` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `sms_config` (`id`, `clickatell_username`, `clickatell_password`, `clickatell_api_key`, `clickatell_number`, `twilio_account_sid`, `twilio_auth_token`, `twilio_number`, `active_gateway`) VALUES (1, '', '', '', '', '', '', '', 'disabled');


#
# TABLE STRUCTURE FOR: sms_templates
#

DROP TABLE IF EXISTS `sms_templates`;

CREATE TABLE `sms_templates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sms_type` varchar(200) NOT NULL,
  `subject` varchar(250) NOT NULL,
  `template_body` longtext NOT NULL,
  `tags` longtext NOT NULL,
  `notified` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `sms_templates` (`id`, `sms_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (1, 'account_registered', '', '', '{institute_name}, {name}, {username}, {password}, {user_role}, {login_url}', 0);
INSERT INTO `sms_templates` (`id`, `sms_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (2, 'appointment_confirmation', '', '', '{institute_name}, {patient_name}, {doctor_name}, {appointment_id}, {schedule_time}, {appointment_date}', 0);
INSERT INTO `sms_templates` (`id`, `sms_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (3, 'appointment_canceled', '', '', '{institute_name}, {patient_name}, {doctor_name}, {appointment_id}, {schedule_time}, {appointment_date}', 0);
INSERT INTO `sms_templates` (`id`, `sms_type`, `subject`, `template_body`, `tags`, `notified`) VALUES (4, 'appointment_request', '', '', '{institute_name}, {patient_name}, {doctor_name}, {appointment_id}, {schedule_time}, {appointment_date}', 0);


#
# TABLE STRUCTURE FOR: staff
#

DROP TABLE IF EXISTS `staff`;

CREATE TABLE `staff` (
  `id` int NOT NULL AUTO_INCREMENT,
  `staff_id` varchar(10) NOT NULL,
  `name` varchar(255) NOT NULL,
  `status` varchar(200) NOT NULL DEFAULT 'Active',
  `extension` varchar(200) DEFAULT NULL,
  `admin` varchar(200) DEFAULT NULL,
  `room_manager` varchar(200) DEFAULT NULL,
  `department` int DEFAULT NULL,
  `qualification` varchar(200) DEFAULT NULL,
  `designation` int DEFAULT NULL,
  `joining_date` date DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `gender` varchar(12) DEFAULT NULL,
  `religion` varchar(200) DEFAULT NULL,
  `blood_group` varchar(11) DEFAULT NULL,
  `marital_status` varchar(10) DEFAULT NULL,
  `address` mediumtext,
  `state` varchar(255) DEFAULT NULL,
  `city` varchar(200) DEFAULT NULL,
  `mobileno` varchar(30) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `salary_template_id` int DEFAULT '0',
  `photo` varchar(255) DEFAULT NULL,
  `nid` varchar(200) DEFAULT NULL,
  `facebook_url` varchar(255) DEFAULT NULL,
  `linkedin_url` varchar(255) DEFAULT NULL,
  `twitter_url` varchar(255) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `staff` (`id`, `staff_id`, `name`, `status`, `extension`, `admin`, `room_manager`, `department`, `qualification`, `designation`, `joining_date`, `birthday`, `gender`, `religion`, `blood_group`, `marital_status`, `address`, `state`, `city`, `mobileno`, `email`, `salary_template_id`, `photo`, `nid`, `facebook_url`, `linkedin_url`, `twitter_url`, `created_at`, `updated_at`) VALUES (1, 'b195808', 'Super Admin', 'Active', NULL, NULL, NULL, 0, '', 0, '2023-06-27', '1996-09-18', '', '', 'O-', '2', '', '', '', '+8801744733133', 'tanvirislam.dev@gmail.com', 0, '320c2097d077e5d97049da98118d2477.png', '', '', '', '', '2023-06-27 17:28:07', '2023-09-23 15:21:50');
INSERT INTO `staff` (`id`, `staff_id`, `name`, `status`, `extension`, `admin`, `room_manager`, `department`, `qualification`, `designation`, `joining_date`, `birthday`, `gender`, `religion`, `blood_group`, `marital_status`, `address`, `state`, `city`, `mobileno`, `email`, `salary_template_id`, `photo`, `nid`, `facebook_url`, `linkedin_url`, `twitter_url`, `created_at`, `updated_at`) VALUES (2, '74b749e', 'agent1', 'Active', '101', 'self', 'self', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '12345', 'agent1@callwave.pro', 0, 'defualt.png', NULL, NULL, NULL, NULL, '2023-09-23 15:23:10', '2023-09-23 16:22:08');
INSERT INTO `staff` (`id`, `staff_id`, `name`, `status`, `extension`, `admin`, `room_manager`, `department`, `qualification`, `designation`, `joining_date`, `birthday`, `gender`, `religion`, `blood_group`, `marital_status`, `address`, `state`, `city`, `mobileno`, `email`, `salary_template_id`, `photo`, `nid`, `facebook_url`, `linkedin_url`, `twitter_url`, `created_at`, `updated_at`) VALUES (3, '05b009a', 'admin', 'Active', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', 'admin@test.com', 0, 'defualt.png', NULL, NULL, NULL, NULL, '2023-10-02 10:49:05', '2023-10-02 10:49:05');
INSERT INTO `staff` (`id`, `staff_id`, `name`, `status`, `extension`, `admin`, `room_manager`, `department`, `qualification`, `designation`, `joining_date`, `birthday`, `gender`, `religion`, `blood_group`, `marital_status`, `address`, `state`, `city`, `mobileno`, `email`, `salary_template_id`, `photo`, `nid`, `facebook_url`, `linkedin_url`, `twitter_url`, `created_at`, `updated_at`) VALUES (4, '930ea2d', 'agente01', 'Active', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, '', 'agente01@test.com', 0, 'defualt.png', NULL, NULL, NULL, NULL, '2023-10-02 10:53:03', '2023-10-02 10:53:03');


#
# TABLE STRUCTURE FOR: staff_attendance
#

DROP TABLE IF EXISTS `staff_attendance`;

CREATE TABLE `staff_attendance` (
  `id` int NOT NULL AUTO_INCREMENT,
  `staff_id` varchar(20) NOT NULL,
  `status` varchar(2) DEFAULT NULL,
  `remark` varchar(255) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: staff_balance
#

DROP TABLE IF EXISTS `staff_balance`;

CREATE TABLE `staff_balance` (
  `id` int NOT NULL AUTO_INCREMENT,
  `staff_id` int NOT NULL,
  `amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3;

INSERT INTO `staff_balance` (`id`, `staff_id`, `amount`, `created_at`, `updated_at`) VALUES (1, 0, '0.00', '2023-09-23 14:53:17', '2023-09-23 14:53:17');
INSERT INTO `staff_balance` (`id`, `staff_id`, `amount`, `created_at`, `updated_at`) VALUES (2, 2, '0.00', '2023-09-23 15:23:10', '2023-09-23 15:23:10');
INSERT INTO `staff_balance` (`id`, `staff_id`, `amount`, `created_at`, `updated_at`) VALUES (3, 3, '0.00', '2023-10-02 10:49:05', '2023-10-02 10:49:05');
INSERT INTO `staff_balance` (`id`, `staff_id`, `amount`, `created_at`, `updated_at`) VALUES (4, 4, '0.00', '2023-10-02 10:53:03', '2023-10-02 10:53:03');


#
# TABLE STRUCTURE FOR: staff_bank_account
#

DROP TABLE IF EXISTS `staff_bank_account`;

CREATE TABLE `staff_bank_account` (
  `id` int NOT NULL AUTO_INCREMENT,
  `staff_id` int NOT NULL,
  `bank_name` varchar(200) NOT NULL,
  `holder_name` varchar(255) NOT NULL,
  `bank_branch` varchar(255) NOT NULL,
  `bank_address` varchar(255) NOT NULL,
  `ifsc_code` varchar(200) NOT NULL,
  `account_no` varchar(200) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: staff_department
#

DROP TABLE IF EXISTS `staff_department`;

CREATE TABLE `staff_department` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: staff_designation
#

DROP TABLE IF EXISTS `staff_designation`;

CREATE TABLE `staff_designation` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: staff_documents
#

DROP TABLE IF EXISTS `staff_documents`;

CREATE TABLE `staff_documents` (
  `id` int NOT NULL AUTO_INCREMENT,
  `staff_id` int NOT NULL,
  `title` varchar(255) NOT NULL,
  `category_id` varchar(20) NOT NULL,
  `remarks` text NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `enc_name` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: staff_privileges
#

DROP TABLE IF EXISTS `staff_privileges`;

CREATE TABLE `staff_privileges` (
  `id` int NOT NULL AUTO_INCREMENT,
  `role_id` int NOT NULL,
  `permission_id` int NOT NULL,
  `is_add` tinyint(1) NOT NULL,
  `is_edit` tinyint(1) NOT NULL,
  `is_view` tinyint(1) NOT NULL,
  `is_delete` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=353 DEFAULT CHARSET=utf8mb3;

INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (1, 2, 39, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (2, 2, 40, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (3, 2, 41, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (4, 2, 42, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (5, 2, 43, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (6, 2, 44, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (7, 2, 45, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (8, 2, 46, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (9, 2, 47, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (10, 2, 48, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (11, 2, 49, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (12, 2, 50, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (13, 2, 51, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (14, 2, 52, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (15, 2, 53, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (16, 2, 54, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (17, 2, 55, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (18, 2, 56, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (19, 2, 57, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (20, 2, 59, 1, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (21, 2, 1, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (22, 2, 2, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (23, 2, 19, 0, 1, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (24, 2, 36, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (25, 2, 37, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (26, 2, 38, 0, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (27, 2, 3, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (28, 2, 4, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (29, 2, 5, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (30, 2, 6, 0, 1, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (31, 2, 7, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (32, 2, 8, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (33, 2, 26, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (34, 2, 27, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (35, 2, 28, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (36, 2, 29, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (37, 2, 30, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (38, 2, 31, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (39, 2, 9, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (40, 2, 10, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (41, 2, 16, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (42, 2, 17, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (43, 2, 18, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (44, 2, 32, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (45, 2, 33, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (46, 2, 34, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (47, 2, 35, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (48, 2, 13, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (49, 2, 14, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (50, 2, 15, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (51, 2, 11, 1, 1, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (52, 2, 12, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (53, 2, 21, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (54, 2, 22, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (55, 2, 23, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (56, 2, 24, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (57, 2, 25, 1, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (58, 2, 58, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (59, 3, 39, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (60, 3, 40, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (61, 3, 41, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (62, 3, 42, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (63, 3, 43, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (64, 3, 44, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (65, 3, 45, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (66, 3, 46, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (67, 3, 47, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (68, 3, 48, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (69, 3, 49, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (70, 3, 50, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (71, 3, 51, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (72, 3, 52, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (73, 3, 53, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (74, 3, 54, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (75, 3, 55, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (76, 3, 56, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (77, 3, 57, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (78, 3, 59, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (79, 3, 1, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (80, 3, 2, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (81, 3, 19, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (82, 3, 36, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (83, 3, 37, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (84, 3, 38, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (85, 3, 3, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (86, 3, 4, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (87, 3, 5, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (88, 3, 6, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (89, 3, 7, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (90, 3, 8, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (91, 3, 26, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (92, 3, 27, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (93, 3, 28, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (94, 3, 29, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (95, 3, 30, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (96, 3, 31, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (97, 3, 9, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (98, 3, 10, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (99, 3, 16, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (100, 3, 17, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (101, 3, 18, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (102, 3, 32, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (103, 3, 33, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (104, 3, 34, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (105, 3, 35, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (106, 3, 13, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (107, 3, 14, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (108, 3, 15, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (109, 3, 11, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (110, 3, 12, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (111, 3, 21, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (112, 3, 22, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (113, 3, 23, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (114, 3, 24, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (115, 3, 25, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (116, 3, 58, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (117, 4, 39, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (118, 4, 40, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (119, 4, 41, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (120, 4, 42, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (121, 4, 43, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (122, 4, 44, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (123, 4, 45, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (124, 4, 46, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (125, 4, 47, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (126, 4, 48, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (127, 4, 49, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (128, 4, 50, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (129, 4, 51, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (130, 4, 52, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (131, 4, 53, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (132, 4, 54, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (133, 4, 55, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (134, 4, 56, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (135, 4, 57, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (136, 4, 59, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (137, 4, 1, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (138, 4, 2, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (139, 4, 19, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (140, 4, 36, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (141, 4, 37, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (142, 4, 38, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (143, 4, 3, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (144, 4, 4, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (145, 4, 5, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (146, 4, 6, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (147, 4, 7, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (148, 4, 8, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (149, 4, 26, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (150, 4, 27, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (151, 4, 28, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (152, 4, 29, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (153, 4, 30, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (154, 4, 31, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (155, 4, 9, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (156, 4, 10, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (157, 4, 16, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (158, 4, 17, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (159, 4, 18, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (160, 4, 32, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (161, 4, 33, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (162, 4, 34, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (163, 4, 35, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (164, 4, 13, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (165, 4, 14, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (166, 4, 15, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (167, 4, 11, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (168, 4, 12, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (169, 4, 21, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (170, 4, 22, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (171, 4, 23, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (172, 4, 24, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (173, 4, 25, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (174, 4, 58, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (175, 5, 39, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (176, 5, 40, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (177, 5, 41, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (178, 5, 42, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (179, 5, 43, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (180, 5, 44, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (181, 5, 45, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (182, 5, 46, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (183, 5, 47, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (184, 5, 48, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (185, 5, 49, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (186, 5, 50, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (187, 5, 51, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (188, 5, 52, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (189, 5, 53, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (190, 5, 54, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (191, 5, 55, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (192, 5, 56, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (193, 5, 57, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (194, 5, 59, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (195, 5, 1, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (196, 5, 2, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (197, 5, 19, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (198, 5, 36, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (199, 5, 37, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (200, 5, 38, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (201, 5, 3, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (202, 5, 4, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (203, 5, 5, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (204, 5, 6, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (205, 5, 7, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (206, 5, 8, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (207, 5, 26, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (208, 5, 27, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (209, 5, 28, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (210, 5, 29, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (211, 5, 30, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (212, 5, 31, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (213, 5, 9, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (214, 5, 10, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (215, 5, 16, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (216, 5, 17, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (217, 5, 18, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (218, 5, 32, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (219, 5, 33, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (220, 5, 34, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (221, 5, 35, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (222, 5, 13, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (223, 5, 14, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (224, 5, 15, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (225, 5, 11, 1, 1, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (226, 5, 12, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (227, 5, 21, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (228, 5, 22, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (229, 5, 23, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (230, 5, 24, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (231, 5, 25, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (232, 5, 58, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (233, 6, 39, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (234, 6, 40, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (235, 6, 41, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (236, 6, 42, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (237, 6, 43, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (238, 6, 44, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (239, 6, 45, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (240, 6, 46, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (241, 6, 47, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (242, 6, 48, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (243, 6, 49, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (244, 6, 50, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (245, 6, 51, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (246, 6, 52, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (247, 6, 53, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (248, 6, 54, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (249, 6, 55, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (250, 6, 56, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (251, 6, 57, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (252, 6, 59, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (253, 6, 1, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (254, 6, 2, 1, 1, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (255, 6, 19, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (256, 6, 36, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (257, 6, 37, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (258, 6, 38, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (259, 6, 3, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (260, 6, 4, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (261, 6, 5, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (262, 6, 6, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (263, 6, 7, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (264, 6, 8, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (265, 6, 26, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (266, 6, 27, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (267, 6, 28, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (268, 6, 29, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (269, 6, 30, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (270, 6, 31, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (271, 6, 9, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (272, 6, 10, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (273, 6, 16, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (274, 6, 17, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (275, 6, 18, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (276, 6, 32, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (277, 6, 33, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (278, 6, 34, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (279, 6, 35, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (280, 6, 13, 1, 0, 1, 1);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (281, 6, 14, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (282, 6, 15, 1, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (283, 6, 11, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (284, 6, 12, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (285, 6, 21, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (286, 6, 22, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (287, 6, 23, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (288, 6, 24, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (289, 6, 25, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (290, 6, 58, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (291, 7, 39, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (292, 7, 40, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (293, 7, 41, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (294, 7, 42, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (295, 7, 43, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (296, 7, 44, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (297, 7, 45, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (298, 7, 46, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (299, 7, 47, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (300, 7, 48, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (301, 7, 49, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (302, 7, 50, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (303, 7, 51, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (304, 7, 52, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (305, 7, 53, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (306, 7, 54, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (307, 7, 55, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (308, 7, 56, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (309, 7, 57, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (310, 7, 59, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (311, 7, 1, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (312, 7, 2, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (313, 7, 19, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (314, 7, 36, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (315, 7, 37, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (316, 7, 38, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (317, 7, 3, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (318, 7, 4, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (319, 7, 5, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (320, 7, 6, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (321, 7, 7, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (322, 7, 8, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (323, 7, 26, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (324, 7, 27, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (325, 7, 28, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (326, 7, 29, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (327, 7, 30, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (328, 7, 31, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (329, 7, 9, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (330, 7, 10, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (331, 7, 16, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (332, 7, 17, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (333, 7, 18, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (334, 7, 32, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (335, 7, 33, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (336, 7, 34, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (337, 7, 35, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (338, 7, 13, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (339, 7, 14, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (340, 7, 15, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (341, 7, 11, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (342, 7, 12, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (343, 7, 21, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (344, 7, 22, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (345, 7, 23, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (346, 7, 24, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (347, 7, 25, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (348, 7, 58, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (349, 2, 60, 0, 0, 1, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (350, 7, 60, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (351, 3, 60, 0, 0, 0, 0);
INSERT INTO `staff_privileges` (`id`, `role_id`, `permission_id`, `is_add`, `is_edit`, `is_view`, `is_delete`) VALUES (352, 3, 61, 0, 0, 1, 0);


#
# TABLE STRUCTURE FOR: supplier
#

DROP TABLE IF EXISTS `supplier`;

CREATE TABLE `supplier` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `address` text NOT NULL,
  `mobileno` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `company_name` varchar(200) NOT NULL,
  `product_list` mediumtext NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: theme_settings
#

DROP TABLE IF EXISTS `theme_settings`;

CREATE TABLE `theme_settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `border_mode` varchar(20) NOT NULL,
  `dark_skin` varchar(20) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `theme_settings` (`id`, `border_mode`, `dark_skin`, `created_at`, `updated_at`) VALUES (1, 'true', 'false', '2019-12-23 22:59:38', '2023-11-02 00:58:21');


#
# TABLE STRUCTURE FOR: transactions
#

DROP TABLE IF EXISTS `transactions`;

CREATE TABLE `transactions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `account_id` varchar(20) NOT NULL,
  `voucher_head_id` varchar(200) NOT NULL,
  `type` varchar(100) NOT NULL,
  `category` varchar(20) NOT NULL,
  `ref` varchar(255) NOT NULL,
  `amount` decimal(18,2) NOT NULL DEFAULT '0.00',
  `dr` decimal(18,2) NOT NULL DEFAULT '0.00',
  `cr` decimal(18,2) NOT NULL DEFAULT '0.00',
  `bal` decimal(18,2) NOT NULL DEFAULT '0.00',
  `date` date NOT NULL,
  `pay_via` varchar(20) NOT NULL,
  `description` text NOT NULL,
  `attachments` varchar(255) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: users
#

DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `display_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `sip_extension` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `sip_password` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `state` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `email` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `password` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `display_picture` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `users` (`id`, `display_name`, `sip_extension`, `sip_password`, `state`, `created_at`, `updated_at`, `email`, `password`, `display_picture`) VALUES ('1', 'MD Nahid', '905', '6fd9d726ded5a376713b8a874959bcc5', 'active', '2023-09-28 21:01:35', '2023-09-29 05:47:33', 'nahid@sohub.com', '12345678', 'https://images.pexels.com/photos/45853/grey-crowned-crane-bird-crane-animal-45853.jpeg?auto=compress&cs=tinysrgb&dpr=1&w=500');
INSERT INTO `users` (`id`, `display_name`, `sip_extension`, `sip_password`, `state`, `created_at`, `updated_at`, `email`, `password`, `display_picture`) VALUES ('2', 'Zaman Rajpoot', '906', '76c432a55e77ca38ee9585db9122d101', 'active', '2023-09-28 21:01:35', '2023-09-29 05:47:18', 'zaman@sohub.com', '12345678', 'https://www.planetware.com/wpimages/2020/02/france-in-pictures-beautiful-places-to-photograph-eiffel-tower.jpg');
INSERT INTO `users` (`id`, `display_name`, `sip_extension`, `sip_password`, `state`, `created_at`, `updated_at`, `email`, `password`, `display_picture`) VALUES ('3', 'Helpline', '904', '76c432a55e77ca38ee9585db9122d101', 'active', '2023-09-28 21:01:35', '2023-09-29 05:43:10', 'user3@sohub.com', '12345678', 'https://cdn.pixabay.com/photo/2015/04/23/22/00/tree-736885_1280.jpg');
INSERT INTO `users` (`id`, `display_name`, `sip_extension`, `sip_password`, `state`, `created_at`, `updated_at`, `email`, `password`, `display_picture`) VALUES ('4', 'John Doe', '1001', 's3cr3t', NULL, '2023-10-10 02:47:05', '2023-10-10 02:47:05', 'john@example.com', 'hashed_password', 'https://example.com/profile-picture.jpg');


#
# TABLE STRUCTURE FOR: vb_blacklist
#

DROP TABLE IF EXISTS `vb_blacklist`;

CREATE TABLE `vb_blacklist` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date_time` datetime DEFAULT NULL,
  `number` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `assign_to` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: vb_callerid
#

DROP TABLE IF EXISTS `vb_callerid`;

CREATE TABLE `vb_callerid` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date_time` datetime DEFAULT NULL,
  `trunk_id` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `caller_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `channels` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '0',
  `status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `assign_to` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `vb_callerid` (`id`, `date_time`, `trunk_id`, `caller_id`, `channels`, `status`, `assign_to`) VALUES (6, '2023-11-02 01:29:31', NULL, '09678076482', '5', 'Active', '1');


#
# TABLE STRUCTURE FOR: vb_quick_play
#

DROP TABLE IF EXISTS `vb_quick_play`;

CREATE TABLE `vb_quick_play` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date_time` datetime DEFAULT NULL,
  `call_to` varchar(200) DEFAULT NULL,
  `caller_id` varchar(20) DEFAULT NULL,
  `trunk_id` int DEFAULT NULL,
  `trunk_name` varchar(250) DEFAULT NULL,
  `trunk_channelid` varchar(250) DEFAULT NULL,
  `sound` varchar(200) DEFAULT NULL,
  `status` varchar(200) DEFAULT 'Pending',
  `voice_name` varchar(100) DEFAULT NULL,
  `count` int DEFAULT '0',
  `last_play_date_time` datetime DEFAULT NULL,
  `assigned_to` varchar(20) NOT NULL,
  `play_type` varchar(20) DEFAULT NULL,
  `play` longtext CHARACTER SET latin1 COLLATE latin1_swedish_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=208 DEFAULT CHARSET=latin1;

INSERT INTO `vb_quick_play` (`id`, `date_time`, `call_to`, `caller_id`, `trunk_id`, `trunk_name`, `trunk_channelid`, `sound`, `status`, `voice_name`, `count`, `last_play_date_time`, `assigned_to`, `play_type`, `play`) VALUES (205, '2023-11-12 21:31:42', '702', '09678076482', 1, NULL, NULL, NULL, NULL, NULL, 0, NULL, '1', 'tts', 'Welcome to Solution Hub Technologies This is a test message for TTS');
INSERT INTO `vb_quick_play` (`id`, `date_time`, `call_to`, `caller_id`, `trunk_id`, `trunk_name`, `trunk_channelid`, `sound`, `status`, `voice_name`, `count`, `last_play_date_time`, `assigned_to`, `play_type`, `play`) VALUES (206, '2023-11-12 21:36:13', '01744733133', '09678076482', 1, NULL, NULL, NULL, NULL, NULL, 0, NULL, '1', 'tts', 'Welcome to Solution Hub Technologies This is a test message for TTS');


#
# TABLE STRUCTURE FOR: vb_schedule_play
#

DROP TABLE IF EXISTS `vb_schedule_play`;

CREATE TABLE `vb_schedule_play` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `date_time` datetime DEFAULT NULL,
  `last_play_date_time` datetime DEFAULT NULL,
  `caller_id` varchar(20) NOT NULL,
  `trunk_id` int DEFAULT NULL,
  `play_type` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `play` longtext CHARACTER SET latin1 COLLATE latin1_swedish_ci,
  `call_group` varchar(200) NOT NULL,
  `count_call` int NOT NULL,
  `count` int DEFAULT '0',
  `status` varchar(200) DEFAULT 'Inactive',
  `date` datetime DEFAULT NULL,
  `retries` int DEFAULT '0',
  `assigned_to` varchar(20) NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `campaign_config` longtext CHARACTER SET latin1 COLLATE latin1_swedish_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=153 DEFAULT CHARSET=latin1;

INSERT INTO `vb_schedule_play` (`id`, `name`, `date_time`, `last_play_date_time`, `caller_id`, `trunk_id`, `play_type`, `play`, `call_group`, `count_call`, `count`, `status`, `date`, `retries`, `assigned_to`, `start_time`, `end_time`, `campaign_config`) VALUES (148, 'First Campaign', '2023-11-07 23:20:20', NULL, '09678076482', NULL, NULL, '', 'abc', 0, 0, 'Active', '2023-11-06 11:42:00', 0, '1', '00:00:00', '00:00:00', '{\"id\":\"148\",\"firstDropdown\":\"transfer_call\",\"layer_1_transfer\":\"\",\"layer_1_tts\":\"\",\"layer_1_voice\":\"\",\"layer_2_human\":\"tts_play\",\"layer_2_human_0\":\"\",\"layer_2_human_press_0\":\"Open this select menu\",\"layer_2_human_press_0_transfer\":\"Open this select menu\",\"layer_2_human_press_0_digit\":\"\",\"layer_2_machine_0\":\"tts_play\",\"layer_2_machine_value_0\":\"\",\"camp_submit\":\"submit\"}');
INSERT INTO `vb_schedule_play` (`id`, `name`, `date_time`, `last_play_date_time`, `caller_id`, `trunk_id`, `play_type`, `play`, `call_group`, `count_call`, `count`, `status`, `date`, `retries`, `assigned_to`, `start_time`, `end_time`, `campaign_config`) VALUES (152, 'Second Campaign', '2023-11-12 19:13:58', NULL, '09678076482', NULL, NULL, '', 'abc', 0, 0, 'Inactive', '2023-11-12 11:28:00', 0, '1', '11:28:00', '23:59:00', NULL);


#
# TABLE STRUCTURE FOR: vb_sounds
#

DROP TABLE IF EXISTS `vb_sounds`;

CREATE TABLE `vb_sounds` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date_time` datetime DEFAULT NULL,
  `sound_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `directory` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `file_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `assign_to` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `vb_sounds` (`id`, `date_time`, `sound_name`, `directory`, `file_name`, `status`, `assign_to`) VALUES (1, '2023-11-02 01:29:40', 'Sohub test', '', 'audio-1698867002.wav', 'Active', '1');


#
# TABLE STRUCTURE FOR: vb_trunks
#

DROP TABLE IF EXISTS `vb_trunks`;

CREATE TABLE `vb_trunks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date_time` datetime DEFAULT NULL,
  `trunk_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `trunk_type` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `trunk_clid_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '0',
  `status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `assign_to` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `vb_trunks` (`id`, `date_time`, `trunk_name`, `trunk_type`, `trunk_clid_name`, `status`, `assign_to`) VALUES (1, '2023-11-02 01:15:44', 'Link3_Sohub_482', 'PJSIP', '09678076482', 'Active', '1');


#
# TABLE STRUCTURE FOR: vb_tts
#

DROP TABLE IF EXISTS `vb_tts`;

CREATE TABLE `vb_tts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date_time` datetime DEFAULT NULL,
  `tts_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `tts_text` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `assign_to` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `vb_tts` (`id`, `date_time`, `tts_name`, `tts_text`, `status`, `assign_to`) VALUES (1, '2023-11-02 01:30:06', 'Test TTS', 'Welcome to Solution Hub Technologies This is a test message for TTS', 'Active', '1');


#
# TABLE STRUCTURE FOR: voucher_head
#

DROP TABLE IF EXISTS `voucher_head`;

CREATE TABLE `voucher_head` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

