<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Connectivity Information</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        /* Full page background */
        body {
            background-color: #fff; /* Set the background to white */
            height: 100vh;
            margin: 0;
            font-family: Arial, sans-serif;
            color: #333;
        }

        .container-box {
            background: rgba(255, 255, 255, 0.9); /* Light background with transparency */
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            max-width: 1200px;
            margin: 20px auto;
            position: relative;
            top: 20px;
        }

        h4 {
            text-align: center;
            font-size: 2.5rem;
            font-weight: bold;
            background: linear-gradient(45deg, #ff00ff, #00ffff);
            color: transparent;
            -webkit-background-clip: text;
            margin-bottom: 30px;
        }

        /* Information Box */
        .info-box {
            background: rgba(255, 255, 255, 0.15);
            padding: 20px;
            border-radius: 15px;
            text-align: center;
            box-shadow: 2px 2px 10px rgba(0, 0, 0, 0.3);
            transition: all 0.3s ease-in-out;
            margin-bottom: 15px;
        }

        .info-box:hover {
            background: #ff00ff;
            color: white;
            transform: translateY(-5px);
            box-shadow: 0 6px 12px rgba(255, 0, 255, 0.3);
        }

        /* Live Traffic Container */
        .live-traffic-container {
            background-color: #d4edda; /* Light green background */
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
            width: 100%;
            margin-top: 30px;
        }

        .live-traffic-container h5 {
            font-size: 2rem;
            font-weight: bold;
            margin-bottom: 20px;
            color: #333;
        }

        /* Chart Container */
        .chart-container {
            width: 100%;
            height: 500px; /* Full height for traffic graph */
        }
    </style>
</head>

<body>

    <!-- Main Container -->
    <div class="container-box">
        <h4>Connectivity Information</h4>

        <div class="row g-3 mt-3">
            <div class="col-md-3">
                <div class="info-box"><i class="fas fa-clock"></i> Uptime: 3d6h33m11s</div>
            </div>
            <div class="col-md-3">
                <div class="info-box"><i class="fas fa-server"></i> PPPOE ID: *80025787</div>
            </div>
            <div class="col-md-3">
                <div class="info-box"><i class="fas fa-network-wired"></i> MAC: 00:1D:80:DF:1A:E2</div>
            </div>
            <div class="col-md-3">
                <div class="info-box"><i class="fas fa-microchip"></i> Device:Beijing Huahuan </div>
            </div>
            <div class="col-md-3">
                <div class="info-box"><i class="fas fa-hdd"></i> Total Downloaded: 0 MB</div>
            </div>
            <div class="col-md-3">
                <div class="info-box"><i class="fas fa-upload"></i> Total Uploaded: 0 MB</div>
            </div>
            <div class="col-md-3">
                <div class="info-box"><i class="fas fa-arrow-up"></i> Upload Speed: 0 bps</div>
            </div>
            <div class="col-md-3">
                <div class="info-box"><i class="fas fa-arrow-down"></i> Download Speed: 0 bps</div>
            </div>
            <div class="col-md-4">
                <div class="info-box"><i class="fas fa-sign-out-alt"></i> Last Logout: feb/13/2025 </div>
            </div>
            <div class="col-md-4">
                <div class="info-box d-flex justify-content-between align-items-center p-3 rounded-3 shadow-lg transition-all ease-in-out">
                    <div class="d-flex align-items-center gap-2">
                        <i class="fas fa-signal fa-2x text-primary"></i>
                        <span class="fw-bold">OLT DBM</span>
                    </div>
                    <button class="btn btn-outline-primary rounded-pill py-2 px-4">
                        <i class="fas fa-bolt"></i> Check DBM
                    </button>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box d-flex justify-content-between align-items-center p-3 rounded-3 shadow-lg transition-all ease-in-out">
                    <div class="d-flex align-items-center gap-2">
                        <i class="fas fa-wifi fa-2x text-success"></i>
                        <span class="fw-bold">IP: 192.168.100.253</span>
                    </div>
                    <button class="btn btn-outline-success rounded-pill py-2 px-4">
                        <i class="fas fa-bolt"></i> Ping
                    </button>
                </div>
            </div>
        </div>

        <!-- Live Traffic Section -->
        <div class="live-traffic-container">
            <h5>Live Traffic</h5>
            <div class="chart-container">
                <canvas id="trafficChart"></canvas>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        // Setup for Chart.js live graph
        const ctx = document.getElementById('trafficChart').getContext('2d');
        const trafficChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: [], // time labels for x-axis (seconds)
                datasets: [{
                    label: 'Upload Speed (bps)',
                    borderColor: 'rgb(54, 162, 235)',
                    backgroundColor: 'rgba(54, 162, 235, 0.2)',
                    fill: false,
                    data: [],
                    tension: 0.1
                }, {
                    label: 'Download Speed (bps)',
                    borderColor: 'rgb(255, 99, 132)',
                    backgroundColor: 'rgba(255, 99, 132, 0.2)',
                    fill: false,
                    data: [],
                    tension: 0.1
                }]
            },
            options: {
                scales: {
                    x: {
                        type: 'linear',
                        position: 'bottom'
                    }
                }
            }
        });

        // Function to simulate traffic data (replace with real data)
        let time = 0;
        function updateChart() {
            const uploadSpeed = Math.floor(Math.random() * 1000);  // Random upload speed
            const downloadSpeed = Math.floor(Math.random() * 1000);  // Random download speed

            if (trafficChart.data.labels.length >= 30) {
                trafficChart.data.labels.shift();  // Remove first element to keep the chart moving
                trafficChart.data.datasets[0].data.shift(); // Remove first data point for upload
                trafficChart.data.datasets[1].data.shift(); // Remove first data point for download
            }

            // Add new data point
            trafficChart.data.labels.push(time);
            trafficChart.data.datasets[0].data.push(uploadSpeed);
            trafficChart.data.datasets[1].data.push(downloadSpeed);

            // Update chart
            trafficChart.update();

            time++; // Increment time for the next second
        }

        // Update the chart every second
        setInterval(updateChart, 1000);
    </script>

</body>

</html>
