<div class="row">
    <?php if (get_permission('zone', 'is_add')) { ?>
        <div class="col-md-5">
            <section class="panel">
                <header class="panel-heading">
                    <h4 class="panel-title">
                        <i class="far fa-edit"></i>
                        <?php if (($action ?? null) == 'edit'): ?>
                            <?= translate('Edit Branch') ?>
                        <?php else: ?>
                            <?= translate('Add Branch') ?>
                        <?php endif; ?>
                    </h4>
                </header>
                <?= form_open($this->uri->uri_string()); ?>
                <div class="panel-body">

                    <div class="form-group mb-md">
                        <label for="name" class="control-label">
                            <?= translate('Branch') ?>
                            <span class="required">*</span>
                        </label>
                        <input type="text" class="form-control <?= form_error('name') ? 'has-error' : null ?>"
                            name="name" id="name" value="<?= set_value('name', $thisZone->name ?? null) ?>" required />
                        <span class="error"><?= form_error('name') ?></span>
                    </div>

                    <!-- manager -->
                    <div class="form-group mb-md <?= form_error('manager_id') ? 'has-error' : null ?>">

                        <label for="manager_id" class="control-label">
                            <?= translate('Manager') ?>
                            <span class="required">*</span>
                        </label>
                        <select class="form-control" data-plugin-selectTwo name="manager_id" id="manager_id"
                            required <?= ($action ?? null) == 'edit' ? 'disabled' : null ?>>
                            <?php /** @var array<array> $nasList */ ?>
                            <?php if (empty($employees)): ?>
                                <option><?= translate('No manager Found'); ?></option>
                            <?php else: ?>
                                <option><?= translate('Select A manager') ?></option>
                                <?php foreach ($employees as $employee): ?>
                                    <?php $nas = (object)$employee ?>
                                    <option value="<?= $employee->id ?>"
                                        <?= set_select('manager_id', $employee->id, ($thisZone->manager_id ?? null) == $employee->id) ?>>
                                        <?= html_escape($employee->name) ?> (<?= html_escape($employee->role_name) ?>)
                                    </option>


                                <?php endforeach; ?>
                            <?php endif; ?>

                        </select>
                        <span class="error"><?= form_error('manager_id'); ?></span>
                    </div>

                </div>
                <div class="panel-footer">
                    <div class="row">
                        <div class="col-md-12">
                            <button class="btn btn-default pull-right" type="submit">
                                <i class="fas fa-plus-circle"></i>
                                <?php if (($action ?? null) == 'edit'): ?>
                                    <?= translate('update') ?>
                                <?php else: ?>
                                    <?= translate('save') ?>
                                <?php endif; ?>
                            </button>
                        </div>
                    </div>
                </div>
                <?= form_close(); ?>
            </section>
        </div>
    <?php } ?>
    <div <?php if (get_permission('zone', 'is_add')) { ?> class="col-md-7" <?php } else { ?> class="col-md-12" <?php } ?>>
        <section class="panel">
            <header class="panel-heading">
                <h4 class="panel-title"><i class="fas fa-list-ul"></i> <?= translate('Branch List'); ?>
                </h4>
            </header>
            <div class="panel-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover table-condensed mb-none">
                        <thead>
                            <tr>
                                <th><?= translate('sl'); ?></th>
                                <th><?= translate('name'); ?></th>
                                <th><?= translate('Manager') ?></th>
                                <th><?= translate('action'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($zones)) : ?>
                                <?php foreach ($zones as $index => $zone): ?>
                                    <tr>
                                        <td><?= $index + 1; ?></td>
                                        <td><?= html_escape($zone->name); ?></td>
                                        <td><?= html_escape($zone->manager_name) ?></td>
                                        <td>
                                            <?php if ($zone->editable): ?>
                                                <?php if (get_permission('zone', 'is_edit')) { ?>
                                                    <a href="<?= base_url('zone/edit/' . $zone->id); ?>"
                                                        class="btn btn-circle icon btn-default" data-toggle="tooltip"
                                                        data-original-title="<?= translate('edit') ?>">
                                                        <i class="fas fa-pen-nib"></i>
                                                    </a>
                                                <?php } ?>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="3">
                                        <h5 class="text-danger text-center"><?= translate('no_information_available.') ?></h5>
                                    </td>
                                </tr>

                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
    </div>
</div>