<div class="row">

	<div class="col-md-4">
		<section class="panel">
			<header class="panel-heading">
				<h4 class="panel-title"><i class="far fa-edit"></i> <?php echo translate('add') . " " . translate('Trunk'); ?></h4>
			</header>
            <?php echo form_open($this->uri->uri_string()); ?>
				<div class="panel-body">
					<input type="hidden" name="date_time" value="<?php echo date('Y-m-d H:i:s'); ?>" >
					<input type="hidden" name="user_id" value="<?php echo get_loggedin_user_id();?>">
				
				
					<div class="form-group mb-md">
						<label class="control-label">Trunk Name<span class="required">*</span></label>
						<input type="text" class="form-control" name="trunk_name" value="" required />
					</div>
					
					
					<div class="form-group mb-md">
						<label class="control-label">Trunk Number<span class="required">*</span></label>
						<input type="number" class="form-control" name="trunk_clid_name" value="" required />
					</div>
					
					<div class="form-group mb-md">
						<label class="control-label">Max Con-Current Call<span class="required">*</span></label>
						<input type="text" class="form-control" name="trunk_channel_limit" value="1" required />
					</div>
					
					<div class="form-group mb-md">
						<label class="control-label">Trunk Type<span class="required">*</span></label>
						
						<select class='form-control' name="trunk_type" data-width='100%' required>
							  <option value="SIP">SIP</option>
							  <option value="PJSIP">PJSIP</option>
						</select>
					
					
					</div>
					
					<div class="form-group mb-md">
						<div class="form-group <?php if (form_error('assigned_admin')) echo 'has-error'; ?>">
							<label class "control-label"><?php echo translate('Assigned Admin'); ?></label>
							<?php 
								$all_admins_list = ["" => "Select Admin..."];
								foreach ($all_admins as $alist) {
									$admin_id = $alist->id;
									$admin_name = $alist->name;
									$all_admins_list[$admin_id] = $admin_name;
								}
								echo form_dropdown("assigned_admin", $all_admins_list, '',"name='assigned_admin' class='form-control' id='assigned_admin'  data-plugin-selectTwo data-width='100%'");
							?>
							<span class="error"><?php echo form_error('assigned_admin'); ?></span>
						</div>
					</div>
					
					<div class="form-group mb-md">
						<label class="control-label">Status<span class="required">*</span></label>
						<div class="col-md">
							<?php
								$status = ["Active" =>"Active","Inactive" =>"Inactive"];
								echo form_dropdown("status", $status, 'Active', "class='form-control' data-plugin-selectTwo data-width='100%'");
							?>
						</div>
					</div>
					
					
					
					
					
					
				</div>
				<div class="panel-footer">
					<div class="row">
						<div class="col-md-12">
							<button class="btn btn-default pull-right" type="submit" name="category" value="1"><i class="fas fa-plus-circle"></i> <?php echo translate('save'); ?></button>
						</div>	
					</div>
				</div>
			<?php echo form_close(); ?>
		</section>
	</div>

	<div class="col-md-<?php if (get_permission('trunks', 'is_add')){ echo "8"; }else{echo "12";} ?>">
		<section class="panel">
			<header class="panel-heading">
				<h4 class="panel-title"><i class="fas fa-list-ul"></i> <?php echo translate('Trunk') . " " . translate('list'); ?></h4>
			</header>
			<div class="panel-body">
				<div class="table-responsive">
					<table class="table table-bordered table-hover table-condensed mb-none">
						<thead>
							<tr>
								<th><?php echo translate('sl'); ?></th>
								<th><?php echo translate('created time'); ?></th>
								<th><?php echo translate('trunk_name'); ?></th>
								<th><?php echo translate('Trunk Number'); ?></th>
								<th><?php echo translate('Max Con-Current Call'); ?></th>
								<th><?php echo translate('Trunk Type'); ?></th>
								<th><?php echo translate('Assigned_to'); ?></th>
								<th><?php echo translate('status'); ?></th>
								<th><?php echo translate('action'); ?></th>
							</tr>
						</thead>
						<tbody>
						<?php
						$count = 1;
						if (!empty($trunk_list)){
							foreach ($trunk_list as $row):
							?>
							<tr>
								<td><?php echo $count++; ?></td>
								<td><?php echo html_escape($row['date_time']); ?></td>
								<td><?php echo html_escape($row['trunk_name']); ?></td>
								<td><?php echo html_escape($row['trunk_clid_name']); ?></td>
								<td><?php echo html_escape($row['trunk_channel_limit']); ?></td>
								<td><?php echo html_escape($row['trunk_type']); ?></td>
								<td><?php echo html_escape($row['staff_name']); ?></td>
								<td><?php echo html_escape($row['status']); ?></td>
								<td>
									<a class="btn btn-default btn-circle icon" href="javascript:void(0);" data-toggle="tooltip" data-original-title="<?php echo translate('edit');?>"
									onclick="getTrunk('<?php echo html_escape($row['id']); ?>')">
										<i class="fas fa-pen-nib"></i>
									</a>
									<?php echo btn_delete('voice/trunk_delete/' . $row['id']); ?>
								</td>
							</tr>
						<?php
								endforeach;
							}else{
								echo '<tr><td colspan="6"><h5 class="text-danger text-center">' . translate('no_information_available') . '</td></tr>';
							}
						?>
						</tbody>
					</table>
				</div>
			</div>
		</section>
	</div>
</div>


<div class="zoom-anim-dialog modal-block modal-block-primary mfp-hide" id="modal">
	<section class="panel">
		<header class="panel-heading">
			<h4 class="panel-title">
				<i class="far fa-edit"></i> <?php echo translate('edit') . " " . translate('Trunk'); ?>
			</h4>
		</header>
		
		
		<?php echo form_open(base_url('voice/trunks'), array('class' => 'validate')); ?>
			<div class="panel-body">
				<input type="hidden" name="trunk_id" id="etrunk_id" value="" />
				<input type="hidden" name="date_time" id="edate_time" value="" />
				<input type="hidden" name="user_id" id="euser_id" value="" />
				<div class="form-group mb-md">
					<label class="control-label">Trunk Name<span class="required">*</span></label>
					<input type="text" class="form-control" required  value="" name="trunk_name" id="etrunk_name" />
				</div>
				
				<div class="form-group mb-md">
					<label class="control-label">CLID Name<span class="required">*</span></label>
					<input type="text" class="form-control" required  value="" name="trunk_clid_name" id="etrunk_clid_name" />
				</div>
				
				<div class="form-group mb-md">
					<label class="control-label">Max Con-Current Call<span class="required">*</span></label>
					<input type="text" class="form-control" required  value="" name="trunk_channel_limit" id="etrunk_channel_limit" />
				</div>
				
				
				<div class="form-group mb-md">
					<label class="control-label">Trunk Type<span class="required">*</span></label>
					<select class='form-control' name="trunk_type" id="etrunk_type" data-width='100%'>
							  <option value="SIP">SIP</option>
							  <option value="PJSIP">PJSIP</option>
						</select>
				</div>
				
				
				<div class="form-group mb-md">
					<label class="control-label">Status<span class="required">*</span></label>
					
					<select class='form-control' name="status" id="estatus" data-width='100%'>
							  <option value="Active">Active</option>
							  <option value="Inactive">Inactive</option>
					</select>

				</div>

			</div>
			<footer class="panel-footer">
				<div class="row">
					<div class="col-md-12 text-right">
						<button type="submit" class="btn btn-default"><?php echo translate('update'); ?></button>
						<button class="btn btn-default modal-dismiss"><?php echo translate('cancel'); ?></button>
					</div>
				</div>
			</footer>
		<?php echo form_close(); ?>
	</section>
</div>