<div class="row">

	<div class="col-md-4">
		<section class="panel">
			<header class="panel-heading">
				<h4 class="panel-title"><i class="far fa-edit"></i> <?php echo translate('add') . " " . translate('Sound'); ?></h4>
			</header>
            <?php echo form_open_multipart($this->uri->uri_string()); ?>

				<div class="panel-body">
					<input type="hidden" name="date_time" value="<?php echo date('Y-m-d H:i:s'); ?>" >
					<input type="hidden" name="user_id" value="<?php echo get_loggedin_user_id();?>">
					<input type="hidden" name="status" value="Under Observation">
				
				
					<div class="form-group mb-md">
						<label class="control-label">Sound Name<span class="required">*</span></label>
						<input type="text" class="form-control" name="sound_name" value="" />
					</div>
					
					
					<div class="form-group mb-md">
						<label class="control-label">Audio File<span class="required">*</span></label>
						<input type="file" name="audio" class="dropify" data-height="150" required />

					</div>
					
					
				</div>
				<div class="panel-footer">
					<div class="row">
						<div class="col-md-12">
							<button class="btn btn-default pull-right" type="submit" name="category" value="1"><i class="fas fa-plus-circle"></i> <?php echo translate('save'); ?></button>
						</div>	
					</div>
				</div>
			<?php echo form_close(); ?>
		</section>
	</div>

	<div class="col-md-<?php if (get_permission('sound_files', 'is_add')){ echo "8"; }else{echo "12";} ?>">
		<section class="panel">
			<header class="panel-heading">
				<h4 class="panel-title"><i class="fas fa-list-ul"></i> <?php echo translate('Sound') . " " . translate('list'); ?></h4>
			</header>
			<div class="panel-body">
				<div class="table-responsive">
					<table class="table table-bordered table-hover table-condensed mb-none">
						<thead>
							<tr>
								<th><?php echo translate('sl'); ?></th>
								<th><?php echo translate('created time'); ?></th>
								<th><?php echo translate('sound_name'); ?></th>
								<th><?php echo translate('Sound File'); ?></th>
								<th><?php echo translate('Assigned To'); ?></th>
								<th><?php echo translate('status'); ?></th>
								<?php 
								if($RoleID!=4){
								?>
								<th><?php echo translate('verify'); ?></th>
								<?php }?>
								<th><?php echo translate('action'); ?></th>
							</tr>
						</thead>
						<tbody>
						<?php
						$count = 1;
						if (!empty($sounds_list)){
							foreach ($sounds_list as $row):
							?>
							<tr>
								<td><?php echo $count++; ?></td>
								<td><?php echo html_escape($row['date_time']); ?></td>
								<td><?php echo html_escape($row['sound_name']); ?></td>
								<td>
									<audio controls>
										<source src="/contact_center/uploads/audio/<?php echo $row['file_name']; ?>" type="audio/wav">
										Your browser does not support the audio element.
									</audio>
								</td>
								<td><?php echo html_escape($row['staff_name']); ?></td>
								<td><?php echo html_escape($row['status']); ?></td>
								<?php 
								if($RoleID!=4){
								?>
								<td>
									<?php 
									
									if($row['status']=='Active'){
										echo btn_unverify('voice/sound_unverify/' . $row['id']);
									}
									else{
										echo btn_verify('voice/sound_verify/' . $row['id']);
									}
									
									; ?>
								</td>
								<?php }?>
								<td>
									<?php echo btn_delete('voice/sound_delete/' . $row['id']); ?>
								</td>
							</tr>
						<?php
								endforeach;
							}else{
								echo '<tr><td colspan="8"><h5 class="text-danger text-center">' . translate('no_information_available') . '</td></tr>';
							}
						?>
						</tbody>
					</table>
				</div>
			</div>
		</section>
	</div>
</div>


