<!DOCTYPE html>
<html>
<head>
    <title>Data from CouchDB</title>
</head>
<body>
    <table>
        <thead>
            <tr>
                <th>Phone</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php
require __DIR__ . '/ami_api/php_ami/CouchDB/vendor/autoload.php';

use PHPOnCouch\CouchClient;

// CouchDB connection parameters
$couchHost = 'http://admin:passw0rd@localhost:5984/';
$campaignId = '176';
$groupName = 'sohub_group';
$couchDatabase = 'campaign_' . $campaignId;

// Create a new CouchDB client for the specific database
$couchClient = new CouchClient($couchHost, $couchDatabase);

try {
    // Retrieve all documents from the CouchDB database
    $allDocs = $couchClient->getAllDocs();

    if (!empty($allDocs->rows)) {
        // Iterate through the retrieved documents and display information
        foreach ($allDocs->rows as $row) {
            $docId = $row->id;
            $doc = $couchClient->getDoc($docId);

            echo '<tr>';
            echo '<td>' . (isset($doc->phone) ? $doc->phone : '') . '</td>';
            echo '<td>' . (isset($doc->status) ? $doc->status : '') . '</td>';
            echo '</tr>';
        }
    } else {
        echo '<tr><td colspan="2">No documents found in CouchDB for group ' . $groupName . '.</td></tr>';
    }

} catch (Exception $e) {
    // Handle exceptions
    echo '<tr><td colspan="2">Error: ' . $e->getMessage() . '</td></tr>';
}
?>
        </tbody>
    </table>
</body>
</html>