<?php $currency_symbol = $global_config['currency_symbol']; ?>
<section class="panel">
    <header class="panel-heading">
        <h4 class="panel-title"> <?php echo translate('select_ground'); ?></h4>
    </header>
    <?php echo form_open($this->uri->uri_string()); ?>
    <div class="panel-body">
        <div class="" style="display : flex; justify-content: space-between; gap: 20px;">
            <div class="form-group" style="width: 50%!important;">
                <label class="control-label"><?php echo translate('date'); ?> <span class="required">*</span></label>
                <div class="input-group">
                    <span class="input-group-addon"><i class="fas fa-calendar-check"></i></span>
                    <input type="text" class="form-control daterange" name="daterange" value="<?php echo set_value('daterange', date("Y/m/d") . ' - ' . date("Y/m/d")); ?>" required />
                </div>
            </div>

            <div class="form-group" style="width: 50%!important;">
                <label class="control-label"><?php echo translate('Campaign'); ?> <span class="required">*</span></label>
                
                    <select class="form-control" name="camp_id" id="campaign-dropdown">
                         <option value=""><?php echo translate('select_campaign'); ?></option>
                    <?php
                    foreach ($campaigns as $campaign) {
                        echo "<option value='{$campaign['id']}'>{$campaign['name']}</option>";
                    }
                    ?>
                    </select>
            </div>
        </div>
    </div>
    <footer class="panel-footer">
        <div class="row">
            <div class="col-md-offset-10 col-md-2">
                <button type="submit" name="search" value="1" class="btn btn btn-default btn-block"> <i class="fas fa-filter"></i> <?php echo translate('filter'); ?></button>
            </div>
        </div>
    </footer>
    <?php echo form_close(); ?>
</section>

<?php 
if (!empty($campaign_result)) {
?>

<!-- Table Section -->
<section class="panel" id="table-section" >
        <div class="form-group">
            <div class="col-md-8">
                <!-- Display campaign details here if needed -->
                <h5><b>Campaign Strategy : <?php echo translate($campaign_result[0]['campaign_strategy']);?></b></h5>
                <h5><b>Caller ID : <?php echo translate($campaign_result[0]['cdr_src']);?></b></h5>
            </div>
        </div>
        <div class="tab-content">
        <table class="table table-bordered table-hover table-condensed" cellspacing="0" width="100%" id="table-export">
                <thead>
                    <tr>
                        <th><?php echo translate('sl') . '&nbsp;'; ?></th>
                        <th><?php echo translate('Destination No'); ?></th>
                        <th><?php echo translate('Called Time'); ?></th>
                        <th><?php echo translate('call_duration'); ?></th>
                        <th><?php echo translate('call_cost'); ?></th>
                        <th><?php echo translate('press_value'); ?></th>
                        <th><?php echo translate('statement'); ?></th>
                        <th><?php echo translate('call_disposition'); ?></th>
                        <th><?php echo translate('call_recording'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $count = 1;
                    if (!empty($campaign_result)) {
                        foreach ($campaign_result as $row):
                        ?>
                        <tr>
                            <td><?php echo $count++; ?></td>
                            <td><a href="<?php echo base_url('contacts/contact_details/' . $row['id']); ?>" target="_blank" class="" data-toggle="tooltip">
                                  <?php echo $row['phone']; ?>
                               </a>
                            </td>
                            <td><?php echo $row['cdr_start_time']; ?></td>
                            <td><?php echo $row['cdr_bill_second']; ?></td>
                            <td><?php echo $row['call_cost']; ?></td>
                            <td><?php echo $row['press_value']; ?></td>
                            <td><?php echo $row['stt_sentiment']; ?></td>
                            <td><?php echo $row['cdr_disposition']; ?></td>
                            <td>
                                <audio controls>
                                    <source src="/contact_center/google/uploads/<?php echo $row['stt_recordfile']; ?>" type="audio/wav">
                                    Your browser does not support the audio element.
                                </audio>
                            </td>
                        </tr>
                        <?php endforeach;
                    }?>
                </tbody>
            </table>
        </div>
</section>
<?php } ?>
