<script>
	function toggleDropdowns() {
		var selection = document.getElementById("firstDropdown").value;
		var soundDropdown = document.getElementById("soundDropdown");
		var ttsDropdown = document.getElementById("ttsDropdown");

		if (selection === "sound") {
			soundDropdown.style.display = "block";
			ttsDropdown.style.display = "none";
			soundDropdown.required = true;
			ttsDropdown.required = false;
		} else if (selection === "tts") {
			soundDropdown.style.display = "none";
			ttsDropdown.style.display = "block";
			soundDropdown.required = false;
			ttsDropdown.required = true;
		} else {
			soundDropdown.style.display = "none";
			ttsDropdown.style.display = "none";
			soundDropdown.required = false;
			ttsDropdown.required = false;
		}
	}
</script>

<section class="panel">
	<div class="tabs-custom">
		<div class="tab-content">
			<div id="list" class="tab-pane <?php echo (!isset($validation_error) ? 'active' : ''); ?>">
				<div class="tab-pane <?php echo (isset($validation_error) ? 'active' : ''); ?>" id="qc">
				<div class="row">
					<div class="col-md-12">
						<section class="panel">
							<header class="panel-heading">
								<h4 class="panel-title">Quick Call</h4>
							</header>
							
							<?php echo form_open($this->uri->uri_string()); ?>
							<input type="hidden" name="datetime" value="<?php echo date('Y-m-d H:i:s'); ?>" id="datetime" >
							<input type="hidden" name="user_id" value="<?php echo get_loggedin_user_id();?>" id="user_id" >
			
			
								<div class="panel-body">
									<div class="row mb-sm">
										<div class="col-md-4 mb-sm">
											<div class="form-group">
												<label class="control-label"><?php echo translate('call to'); ?> <span class="required">*</span></label>
												<input type="text" class="form-control" name="call_to" value="" required />
											</div>
										</div>
										<div class="col-md-4 mb-sm">
											<div class="form-group">
												<label class="control-label"><?php echo translate('trunk'); ?> <span class="required">*</span></label>
												<?php
														//$all_trunk = ["" =>"Select Trunk..."];

														foreach ($trunk_list as $var) {
															$trunk_name = $var['trunk_name'];
															$trunk_id = $var['id'];
															$all_trunk[$trunk_id] = $trunk_name;
														} 
														
														echo form_dropdown("trunk", $all_trunk, '', "class='form-control' data-plugin-selectTwo data-width='100%' required");
													?>
											</div>
										</div>
										<div class="col-md-4 mb-sm">
											<div class="form-group">
												<label class="control-label"><?php echo translate('Caller ID'); ?> <span class="required">*</span></label>
												<?php
														//$cid_list = ["" =>"Select Caller ID..."];

														foreach ($callerid_list as $cid) {
															$cids = $cid['caller_id'];
															$cid_list[$cids] = $cids;
														} 
														
														echo form_dropdown("caller_id", $cid_list, '', "class='form-control' data-plugin-selectTwo data-width='100%' required");
													?>
											</div>
										</div>
										
									</div>
									
									<div class="row mb-sm">			
										<div class="col-md-4 mb-sm" >
											<div class="form-group" for="firstDropdown">
												<label class="control-label" for="soundFile">Select Play Type<span class="required">*</span></label>
												<select class='form-control' name="firstDropdown" id="firstDropdown" data-width='100%' onchange="toggleDropdowns()" required>
												  <option value="">Select Play Type</option>
												  <option value="sound">Sound File</option>
												  <option value="tts">Text To Speech (TTS)</option>
												</select>
											</div>
										</div>
										
										

										<div class="col-md-4 mb-sm" id="soundDropdown"  style="display: none;">
											<div class="form-group">
												<label class="control-label">Select Sound File<span class="required">*</span></label>
												<select class='form-control' name="soundFile" id="soundFile" data-width='100%'  data-plugin-selectTwo >
														 <option value="">Select Sound File........</option>
														<?php
															foreach ($sounds_list as $var) {
																$sound_name = $var['sound_name'];
																$sound_id = $var['id'];
																echo "<option value=".$sound_id.">$sound_name</option>";
															}
														?>
													</select>
											</div>
										</div>
										
										
										<div class="col-md-4 mb-sm" id="ttsDropdown"  style="display: none;">
											<div class="form-group">
												<label class="control-label">Select TTS<span class="required">*</span></label>
												<select class='form-control' name="ttsFile" id="ttsFile" data-width='100%'  data-plugin-selectTwo >
														 <option value="">Select TTS........</option>
														<?php
															foreach ($tts_list as $var) {
																$tts_name = $var['tts_name'];
																$tts_text = $var['tts_text'];
																echo "<option value='$tts_text'>$tts_name</option>";
															}
														?>
													</select>
											</div>
										</div>
										
									</div>
									
									
									<div class="row">
										<div class="col-md-offset-10 col-md-2">
											<button type="submit" name="save" value="1" class="btn btn btn-success btn-block"><i class="fas fa-play"></i> <?php echo translate('Start Call'); ?></button>
										</div>
									</div>
								
								
								</div>
								
								
								
							<?php echo form_close(); ?>
						</section>
					
						<?php if (isset($quick_call_list)): ?>
							<section class="panel">
	
									<header class="panel-heading">
										<h4 class="panel-title"><i class="fas fa-users" aria-hidden="true"></i> <?php echo translate('Quick Call Lists'); ?></h4>
									</header>
									<div class="panel-body">
										<div class="table-responsive mt-md mb-lg">
											<table class="table table-bordered table-condensed mb-none">
												<thead>
													<tr>
														<th><?php echo translate('sl'); ?></th>
														<th><?php echo translate('date_time'); ?></th>
														<th><?php echo translate('call_to'); ?></th>
														<th><?php echo translate('caller_id'); ?></th>
														<th><?php echo translate('play_type'); ?></th>
														<th><?php echo translate('play'); ?></th>
														<th><?php echo translate('status'); ?></th>
														<th><?php echo translate('action'); ?></th>
													</tr>
												</thead>
												<tbody>
													<?php 
													$i = 1;
													if (count($quick_call_list)) {
														foreach ($quick_call_list as $key): ?>
													<tr>
														<td><?php echo $i++; ?></td>
														<td><?php echo $key['date_time']; ?></td>
														<td><?php echo $key['call_to']; ?></td>
														<td><?php echo $key['caller_id']; ?></td>
														<td><?php echo $key['play_type']; ?></td>
														<td><?php echo $key['play']; ?></td>
														<td><?php echo "Initiated" ?></td>
														<td class="min-w-xs">
															<a href="javascript:void(0);"  class="btn btn-default btn-circle icon" data-toggle="tooltip" onclick="getQuickCall('<?php echo ($key['id']); ?>')" >
																<i class="fas fa-sync-alt"></i>
															</a>
															<?php
																echo btn_delete('voice/qc_delete/' . $key['id']);
															?>
														</td>

													</tr>
													<?php
														endforeach;
													}else{
														echo '<tr><td colspan="8"><h5 class="text-danger text-center">' . translate('no_information_available') . '</td></tr>';
													}
													?>
												</tbody>
											</table>
										</div>
									</div>
								
							</section>
						<?php endif; ?>
					</div>
				</div>
			</div>
			</div>
	
		</div>
	</div>
</section>
