<!-- Basic Information -->
<section class="panel" style="border-color: transparent; ">
    <div class="tabs-custom">
        <ul class="nav nav-tabs">
            <li class="active">
                <a href="#create" data-toggle="tab"><i class="far fa-edit"></i> <?php echo translate('Basic') . " " . translate('Info'); ?></a>
            </li>
        </ul>

        <div class="tab-content">
            <div class="tab-pane active" id="create">
                <?php echo form_open_multipart($this->uri->uri_string(), array('class' => 'form-horizontal form-bordered')); ?>
                <div class="row">
                    <div class="col-md-6">
                        <!-- First Column -->
                        <div class="form-group">
                            <label class="col-md-4 control-label"><?php echo translate('Campaign') . " " . translate('name'); ?></label>
                            <div class="col-md-8">
                                <input type="text" class="form-control" name="campaign_name" readonly style="border: none; border-bottom: 4px solid #ccc;" value="<?php echo $schedule_campaign_detail[0]['name']; ?>" />
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-md-4 control-label">Select Call Group</label>
                            <div class="col-md-8">
                                <input type="text" class="form-control" name="group_list" value="<?php echo $schedule_campaign_detail[0]['call_group']; ?>" readonly style="border: none; border-bottom: 4px solid #ccc;" />
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-md-4 control-label">Caller ID</label>
                            <div class="col-md-8">
                                <input type="text" class="form-control" name="caller_id" value="<?php echo $schedule_campaign_detail[0]['caller_id']; ?>" readonly style="border: none; border-bottom: 4px solid #ccc;" />
                            </div>
                        </div>

                    </div>

                    <div class="col-md-6">
                        <!-- Second Column -->
                        <div class="form-group">
                            <label class="col-md-4 control-label">Schedule Date</label>
                            <div class="col-md-8">
                                <input type="datetime-local" class="form-control" name="schedule_date" value="<?php echo $schedule_campaign_detail[0]['date']; ?>" readonly style="border: none; border-bottom: 4px solid #ccc;" />
                            </div>
                        </div>

                        <div class="form-group">
							<label class="col-md-4 control-label">Time Slot</label>
							<div class="col-md-8">
								<?php
								$start_time_12hr = date("h:i A", strtotime($schedule_campaign_detail[0]['start_time']));
								$end_time_12hr = date("h:i A", strtotime($schedule_campaign_detail[0]['end_time']));
								?>
								<input type="text" class="form-control" name="time_slot" id="timeSlot" value="<?php echo $start_time_12hr . ' - ' . $end_time_12hr; ?>" readonly style="border: none; border-bottom: 4px solid #ccc;" />
							</div>
						</div>



                        <div class="form-group">
                            <label class="col-md-4 control-label">Status</label>
                            <div class="col-md-8">
                                <input type="text" class="form-control" name="status" value="<?php echo $schedule_campaign_detail[0]['status']; ?>" readonly style="border: none; border-bottom: 4px solid #ccc;" />
                            </div>
                        </div>

                    </div>
                </div>
				<ul class="nav nav-tabs">
					<li class="">
						<a href="#create" data-toggle="tab"></a>
					</li>
				</ul>

				<div class="row">
					<div class="col-md-6">
						<!-- First Column -->
						<div class="form-group">
							<label class="col-md-4 control-label">Campaign Strategy</label>
							<div class="col-md-8">
								<?php
								$l1_type = $config_detail[0]['l1_type'];
								$label_text = '';

								switch ($l1_type) {
									case 'press1':
										$label_text = 'Press 1 Campaign';
										break;
									case 'tts_play':
										$label_text = 'Simple Text-To-Speech Message (TTS)';
										break;
									case 'audio_play':
										$label_text = 'Simple Audio Play';
										break;
									// Add more cases if needed

									default:
										$label_text = $l1_type; // Display the original value if not recognized
										break;
								}
								?>
								<input type="text" class="form-control" name="l1_type" value="<?php echo $label_text; ?>" readonly style="border: none; border-bottom: 4px solid #ccc;" />
							</div>
						</div>
					</div>

					<div class="col-md-6">
						<!-- Second Column -->
						<div class="form-group">
							<label class="col-md-4 control-label">Campaign Value</label>
							<div class="col-md-8">
								<?php
								$l1_value = $config_detail[0]['l1_value'];

								if ($l1_type === 'press1') {
									// Modify l1_value display for Press1
									// Example: concatenate "(Press 1 Campaign)" to l1_value
									$l1_value = 'Press 1 Campaign';
								}

								?>
								<input type="text" class="form-control" name="l1_value" value="<?php echo $l1_value; ?>" readonly style="border: none; border-bottom: 4px solid #ccc;" />
							</div>
						</div>
					</div>
				</div>

				<ul class="nav nav-tabs">
					<li class="active">
						<a href="#create" data-toggle="tab"><i class="fas fa-voicemail fa-flip-vertical"></i> For Answering Machine Detection</a>
					</li>
				</ul>
				<div class="row">
					<div class="col-md-8">
						<div class="form-group">
							<div class="col-md-8">
								<?php
								$layer_2_machine_key = $config_detail[0]['layer_2_machine_key'];
								$layer_2_machine_value = $config_detail[0]['layer_2_machine_value'];

								$display_text = '';

								switch ($layer_2_machine_key) {
									case 'audio_play':
										$sound_id = $layer_2_machine_value;
										$sound_name = $this->voice_model->get_sound_name($sound_id);
										$display_text = 'Simple Audio Play -> ' . $sound_name;
										break;
									case 'tts_play':
										$tts_text = $layer_2_machine_value;
										$tts_name = $this->voice_model->get_tts_name($tts_text);
										$display_text = 'Simple Text-To-Speech (TTS) -> ' . $tts_name;
										break;
									case 'transfer_to':
										$display_text = 'Transfer To -> ' . $layer_2_machine_value;
										break;
									// Add more cases if needed
									default:
										$display_text = $layer_2_machine_key . ' -> ' . $layer_2_machine_value;
										break;
								}
								?>
								<input type="text" class="form-control" name="layer_2_machine_value" value="<?php echo $display_text; ?>" readonly style="border: none; border-bottom: 4px solid #ccc;" />
							</div>
						</div>
					</div>
				</div>

				<ul class="nav nav-tabs">
					<li class="active">
						<a href="#create" data-toggle="tab"><i class="fas fa-list-ul"></i> List Of Action</a>
					</li>
				</ul>
				<div class="row">
					<div class="col-md-8">
						<div class="form-group">
							<div class="col-md-8">
								<?php
								$layer_2_human_key = $config_detail[0]['layer_2_human_key'];
								$layer_2_human_value = $config_detail[0]['layer_2_human_value'];

								$display_text = '';

								switch ($layer_2_human_key) {
									case 'audio_play':
										$sound_id = $layer_2_human_value;
										$sound_name = $this->voice_model->get_sound_name($sound_id);
										$display_text = 'Simple Audio Play -> ' . $sound_name;
										break;
									case 'tts_play':
										$tts_text = $layer_2_human_value;
										$tts_name = $this->voice_model->get_tts_name($tts_text);
										$display_text = 'Simple Text-To-Speech (TTS) -> ' . $tts_name;
										break;
									case 'transfer_to':
										$display_text = 'Transfer To -> ' . $layer_2_human_value;
										break;
									// Add more cases if needed
									default:
										$display_text = $layer_2_human_key . ' -> ' . $layer_2_human_value;
										break;
								}
								?>
								<input type="text" class="form-control" name="layer_2_human_value" value="<?php echo $display_text; ?>" readonly style="border: none; border-bottom: 4px solid #ccc;" />
							</div>
						</div>
					</div>
				</div>

				<ul class="nav nav-tabs">
					<li class="active">
						<a href="#create" data-toggle="tab"><i class="fas fa-users-cog"></i> Press Settings (DTMF)</a>
					</li>
				</ul>

				<div class="row">
					<div class="col-md-6">
						<?php for ($i = 0; $i <= 4; $i++): ?>
							<?php $key = 'press_' . $i; ?>
							<?php if (!empty($config_detail[0][$key . '_key']) && !empty($config_detail[0][$key . '_value'])): ?>
								<div class="form-group">
									<label class="col-md-4 control-label"><?php echo 'Press ' . $i; ?></label>
									<div class="col-md-8">
										<?php
										switch ($config_detail[0][$key . '_key']) {
											case 'transfer_to':
												echo '<input type="text" class="form-control" name="' . $key . '_value" value="Transfer To->' . $config_detail[0][$key . '_value'] . '" readonly style="border: none; border-bottom: 4px solid #ccc;" />';
												break;
											case 'audio':
												$sound_id = $config_detail[0][$key . '_value'];
												$sound_name = $this->voice_model->get_sound_name($sound_id);
												echo '<input type="text" class="form-control" name="' . $key . '_value" value="Simple Audio Play ->' . $sound_name . '" readonly style="border: none; border-bottom: 4px solid #ccc;" />';
												break;
											case 'tts':
												$tts_text = $config_detail[0][$key . '_value'];
												$tts_name = $this->voice_model->get_tts_name($tts_text);
												echo '<input type="text" class="form-control" name="' . $key . '_value" value="Simple Text-To-Speech (TTS)->' . $tts_name . '" readonly style="border: none; border-bottom: 4px solid #ccc;" />';
												break;
											// Add more cases for other types if needed
											default:
												break;
										}
										?>
									</div>
								</div>
							<?php endif; ?>
						<?php endfor; ?>
					</div>

					<div class="col-md-6">
						<?php for ($i = 5; $i <= 9; $i++): ?>
							<?php $key = 'press_' . $i; ?>
							<?php if (!empty($config_detail[0][$key . '_key']) && !empty($config_detail[0][$key . '_value'])): ?>
								<div class="form-group">
									<label class="col-md-4 control-label"><?php echo 'Press ' . $i; ?></label>
									<div class="col-md-8">
										<?php
										switch ($config_detail[0][$key . '_key']) {
											case 'transfer_to':
												echo '<input type="text" class="form-control" name="' . $key . '_value" value="Transfer To->' . $config_detail[0][$key . '_value'] . '" readonly style="border: none; border-bottom: 4px solid #ccc;" />';
												break;
											case 'audio':
												$sound_id = $config_detail[0][$key . '_value'];
												$sound_name = $this->voice_model->get_sound_name($sound_id);
												echo '<input type="text" class="form-control" name="' . $key . '_value" value="Simple Audio Play->' . $sound_name . '" readonly style="border: none; border-bottom: 4px solid #ccc;" />';
												break;
											case 'tts':
												$tts_text = $config_detail[0][$key . '_value'];
												$tts_name = $this->voice_model->get_tts_name($tts_text);
												echo '<input type="text" class="form-control" name="' . $key . '_value" value="Simple Text-To-Speech (TTS)->' . $tts_name . '" readonly style="border: none; border-bottom: 4px solid #ccc;" />';
												break;
											// Add more cases for other types if needed
											default:
												break;
										}
										?>
									</div>
								</div>
							<?php endif; ?>
						<?php endfor; ?>
					</div>

			</div>



    </div>

                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</section>


