<div class="row">

	<div class="col-md-5">
		<section class="panel">
			<header class="panel-heading">
				<h4 class="panel-title"><i class="far fa-edit"></i> <?php echo translate('add') . " " . translate('CallerID'); ?></h4>
			</header>
            <?php echo form_open($this->uri->uri_string()); ?>
				<div class="panel-body">
					<input type="hidden" name="date_time" value="<?php echo date('Y-m-d H:i:s'); ?>" >
					<input type="hidden" name="user_id" value="<?php echo get_loggedin_user_id();?>">
					
					<div class="form-group mb-md">
						<div class="form-group">
												<label class="control-label"><?php echo translate('Select trunk'); ?> <span class="required">*</span></label>
												<?php
														 
														foreach ($trunk_list as $var) {
															$trunk_name = $var['trunk_name'];
															$trunk_id = $var['id'];
															$all_trunk[$trunk_id] = $trunk_name;
														} 
														
														echo form_dropdown("trunk", $all_trunk, '', "class='form-control' data-plugin-selectTwo data-width='100%' required");
													?>
											</div>
					</div>
				
					<div class="form-group mb-md">
						<label class="control-label">Caller ID<span class="required">*</span></label>
						<input type="text" class="form-control" name="caller_id" value="" />
					</div>
					
					
					<div class="form-group mb-md">
						<label class="control-label">Channels<span class="required">*</span></label>
						<input type="text" class="form-control" name="channels" value="" />
					</div>
					
					
					<div class="form-group mb-md">
						<label class="control-label">Status<span class="required">*</span></label>
						<div class="col-md">
							<?php
								$status = ["Active" =>"Active","Inactive" =>"Inactive"];
								echo form_dropdown("status", $status, 'Active', "class='form-control' data-plugin-selectTwo data-width='100%'");
							?>
						</div>
					</div>
					
					
					
				</div>
				<div class="panel-footer">
					<div class="row">
						<div class="col-md-12">
							<button class="btn btn-default pull-right" type="submit" name="category" value="1"><i class="fas fa-plus-circle"></i> <?php echo translate('save'); ?></button>
						</div>	
					</div>
				</div>
			<?php echo form_close(); ?>
		</section>
	</div>

	<div class="col-md-<?php if (get_permission('caller_ids', 'is_add')){ echo "7"; }else{echo "12";} ?>">
		<section class="panel">
			<header class="panel-heading">
				<h4 class="panel-title"><i class="fas fa-list-ul"></i> <?php echo translate('CallerID') . " " . translate('list'); ?></h4>
			</header>
			<div class="panel-body">
				<div class="table-responsive">
					<table class="table table-bordered table-hover table-condensed mb-none">
						<thead>
							<tr>
								<th><?php echo translate('sl'); ?></th>
								<th><?php echo translate('created time'); ?></th>
								<th><?php echo translate('Trunk Name'); ?></th>
								<th><?php echo translate('caller_id'); ?></th>
								<th><?php echo translate('channels'); ?></th>
								<th><?php echo translate('status'); ?></th>
								<th><?php echo translate('action'); ?></th>
							</tr>
						</thead>
						<tbody>
						<?php
						$count = 1;
						if (!empty($callerid_list)){
							foreach ($callerid_list as $row):
							?>
							<tr>
								<td><?php echo $count++; ?></td>
								<td><?php echo html_escape($row['date_time']); ?></td>
								<td><?php echo html_escape($row['trunk_name']); ?></td>
								<td><?php echo html_escape($row['caller_id']); ?></td>
								<td><?php echo html_escape($row['channels']); ?></td>
								<td><?php echo html_escape($row['status']); ?></td>
								<td>
									<a class="btn btn-default btn-circle icon" href="javascript:void(0);" data-toggle="tooltip" data-original-title="<?php echo translate('edit');?>"
									onclick="getCallerid('<?php echo html_escape($row['id']); ?>')">
										<i class="fas fa-pen-nib"></i>
									</a>
									<?php echo btn_delete('voice/callerid_delete/' . $row['id']); ?>
								</td>
							</tr>
						<?php
								endforeach;
							}else{
								echo '<tr><td colspan="6"><h5 class="text-danger text-center">' . translate('no_information_available') . '</td></tr>';
							}
						?>
						</tbody>
					</table>
				</div>
			</div>
		</section>
	</div>
</div>


<div class="zoom-anim-dialog modal-block modal-block-primary mfp-hide" id="modal">
	<section class="panel">
		<header class="panel-heading">
			<h4 class="panel-title">
				<i class="far fa-edit"></i> <?php echo translate('edit') . " " . translate('CallerID'); ?>
			</h4>
		</header>
		
		
		<?php echo form_open(base_url('voice/callerids'), array('class' => 'validate')); ?>
			<div class="panel-body">
				<input type="hidden" name="callerid_id" id="ecallerid_id" value="" />
				<input type="hidden" name="date_time" id="edate_time" value="" />
				<input type="hidden" name="user_id" id="euser_id" value="" />
				<div class="form-group mb-md">
					<label class="control-label">Caller ID<span class="required">*</span></label>
					<input type="text" class="form-control" required  value="" name="caller_id" id="ecaller_id" />
				</div>
				
				<div class="form-group mb-md">
					<label class="control-label">Channels<span class="required">*</span></label>
					<input type="text" class="form-control" required  value="" name="channels" id="echannels" />
				</div>
				
				<div class="form-group mb-md">
					<label class="control-label">Status<span class="required">*</span></label>
					
					<select class='form-control' name="status" id="estatus" data-width='100%'>
							  <option value="Active">Active</option>
							  <option value="Inactive">Inactive</option>
					</select>

				</div>

			</div>
			<footer class="panel-footer">
				<div class="row">
					<div class="col-md-12 text-right">
						<button type="submit" class="btn btn-default"><?php echo translate('update'); ?></button>
						<button class="btn btn-default modal-dismiss"><?php echo translate('cancel'); ?></button>
					</div>
				</div>
			</footer>
		<?php echo form_close(); ?>
	</section>
</div>