<div class="row">
    <div class="col-md-12">
        <section class="panel">
            <div class="panel-heading">
                <div class="panel-title">
                    <i class="fa fa-server"></i> <?= translate('support_history'); ?>
                </div>
                <div class="text-right">
                    <a href="<?= base_url('client_support/create'); ?>" class="btn btn-default ">
                        <i class="fa fa-plus"></i>
                        <?= translate('Add'); ?>
                    </a>
                </div>
            </div>

            <div class="panel-body">
                <table class="table table-bordered table-hover table-condensed table_default">
                    <thead>
                    <tr>
                        <th>SL</th>
                        <th>Client Name</th>
                        <th>Problem Category</th>
                        <th>Problem Priority</th>
                        <th>Complained Number</th>
                        <th>Assigned To</th>
                        <th>Problem Description</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php if (empty($client_supports)): ?>
                        <tr>
                            <td colspan="8" class="text-center"><?= translate('no_data_found'); ?></td>
                        </tr>
                    <?php else: ?>

                        <?php foreach ($client_supports as $index => $client_support): ?>
                            <tr>
                                <td><?= $index + 1 ?></td>
                                <td>
                                    <?= $client_support->client_name ?>

                                </td>

                                <td>
                                    <span>
                                    <?= $client_support->problem_category_name ?>
                                    </span>
                                    <!-- change with ajax button -->
                                    <button type="button" class="btn btn-xs pull-right problem-category-change-button"
                                            data-support-id="<?= $client_support->id ?>"
                                            data-problem-category-id="<?= $client_support->problem_category ?>">
                                        <i class="fa fa-edit"> </i>
                                    </button>
                                </td>
                                <td><?= $client_support->problem_priority ?></td>
                                <td><?= $client_support->complained_number ?></td>
                                <td><?= $client_support->assign_to_name ?></td>
                                <td id="problem_description"><?= $client_support->problem_description ?></td>
                                <td style="vertical-align: middle;text-align: center;">
                                    <!-- a button to pop up a modal to chat -->
                                    <a href="#" class="btn btn-default btn-xs support-chat-button"
                                       data-support-id="<?= $client_support->id ?>" style="color: #ff04ff;">
                                        <i class="fa fa-comments"></i>
                                        <?= translate('chat'); ?>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>

        </section>
    </div>
</div>

<div id="modalContainer"></div>

<script>


    $(document).ready(function () {
        // support chat button click event
        $('.support-chat-button').on('click', function () {
            let supportId = $(this).data('support-id');
            $.ajax({
                url: `<?= base_url('support_chat') ?>`,
                type: 'GET',
                data: {
                    'support_id': supportId,
                },
                success: function (data) {
                    // Inject the data into the modal container
                    $('#modalContainer').html(data);
                    // Trigger the modal to show
                    $('#modal').modal('show');
                },
                error: function (error) {
                    console.error(error);
                }
            });
        });

        // problem category select change event
        $('.problem-category-change-button').on('click', function () {

            let supportId = $(this).data('support-id');
            let problemCategoryId = $(this).data('problem-category-id');
            $('#modalContainer').html('');
            $.ajax({
                url: `<?= base_url('client_support/problem_category_change_modal') ?>`,
                type: 'GET',
                data: {
                    'client_support_id': supportId,
                    'problem_category': problemCategoryId
                },
                success: function (data) {

                    // Inject the data into the modal container
                    $('#modalContainer').html(data);
                    // Trigger the modal to show
                    $('#modal').modal('show');
                },
                error: function (error) {
                    console.error(error);
                }
            });
        });
    });
</script>



