<style>
    .right-side-modal .modal-dialog {
        position: fixed;
        margin: auto;
        width: 500px;
        #height: 100%;
        right: 5px;
        top: 5px;
    }

    .right-side-modal .modal-content {
        height: 100%;
        overflow: auto;
    }

    #chatMessages {
        background-color: #f8f8f8; /* Light grey background */
        border: 1px solid #ddd; /* Grey border */
        padding: 10px; /* Some padding */
        margin-bottom: 15px; /* Bottom margin */
        height: 450px; /* Set a specific height */
        overflow-y: scroll; /* Add scroll if content is too large */
    }

    .chat-message {
        border: 1px solid #ddd; /* Grey border */
        padding: 10px; /* Some padding */
        margin-bottom: 15px; /* Bottom margin */
    }

    .chat-message-header {
        display: flex;
        justify-content: space-between;
        margin-bottom: 10px;
    }

    .chat-message-from {
        font-weight: bold;
    }

    .chat-message-date {
        font-size: 0.8em;
        color: #888;
    }

    .chat-message-body {
        font-size: 1em;
    }
</style>
<!-- chat modal -->
<div class="modal fade right-side-modal" id="modal" tabindex="-1" role="dialog" aria-labelledby="modalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalLabel">
                    <?= translate('chat') . " <b>$client_support->client_name</b>" ?>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </h5>

            </div>
            <div class="modal-body">
                <?= form_open('support_chat', "id='chatForm'"); ?>
                <?= form_hidden('support_id', $client_support->id) ?>
                <div class="form-group">
                    <!-- Previous Messages -->
                    <div id="chatMessages">
                        <?php if (!empty($chatMessages)): ?>
                            <?php foreach ($chatMessages as $chatMessage): ?>
                                <div class="chat-message">
                                    <div class="chat-message-header">
                                        <span class="chat-message-from">
                                            <?= $chatMessage->sender_name ?>
                                        </span>
                                        <span class="chat-message-date">
                                            <?= $chatMessage->created_at ?>
                                        </span>
                                    </div>
                                    <div class="chat-message-body">
                                        <?= $chatMessage->message ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                    <label for="message"><?= translate('message'); ?></label>
                    <textarea name="message" id="message" class="form-control" rows="3"></textarea>
                </div>
                <div class="form-group">
                    <button type="submit" id="MyButton" class="btn btn-primary pull-right">
                        <i class="fa fa-paper-plane"></i>
                        <?= translate('send'); ?>
                    </button>
                </div>
                <?= form_close(); ?>
            </div>
        </div>
    </div>
</div>

<script>
window.setInterval(function() {
  var elem = document.getElementById('chatMessages');
  elem.scrollTop = elem.scrollHeight;
}, 1000);

</script>


<script>
    $('#chatForm').on('submit', function (event) {
        console.log('Form submitted');
        event.preventDefault();

        const formData = $(this).serialize();

        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            success: function (response) {
                console.log(response);
                // close this modal
                $('#modal').modal('hide');
                if (response.status === 'success') {
					
                    // Display a success message
                    notify({message: response.message, type: 'success'});    // notify is a custom function
                } else if (response.status === 'error') {
                    // Display error message
                    notify({message: response.message, type: 'error'});    // notify is a custom function
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                // Handle the error here
                console.error(textStatus, errorThrown);
            }
        });
    });
</script>
