<div class="row">
    <div class="col-md-12">
        <!-- SMS Sending Section -->
        <section class="panel">
            <header class="panel-heading">
                <h4 class="panel-title"><i class="far fa-edit"></i> <?= translate('Send SMS to OLT'); ?></h4>
            </header>
            <?= form_open($this->uri->uri_string()); ?>
            <div class="panel-body">
                <div class="form-group mb-md">
                    <label class="control-label">OLT<span class="required">*</span></label>
                    <div class="input-group">
                        <span class="input-group-addon"><i class="fas fa-network-wired"></i></span>
                        <select class="form-control" data-plugin-selectTwo data-width="100%" name="olt[]" id="olt" multiple required>
                            <?php if (empty($olts)) : ?>
                                <option value=""><?= translate('No OLT Found'); ?></option>
                            <?php else : ?>
                                <option value=""><?= translate('Select OLT') ?></option>
                                <?php foreach ($olts as $olt) : ?>
                              
                                        <option value="<?= $olt->id ?>" <?= set_select('olt[]', $olt->id) ?>>
                                            <?= html_escape($olt->name) ?> (<?= html_escape($olt->manager_name ?? 'N/A') ?>)
                                        </option>
                           

                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                        <span class="error"><?= form_error('olt[]'); ?></span>
                    </div>
                </div>
                <div class="form-group mb-md mt-lg">
                    <label class="control-label">Message<span class="required">*</span></label>
                    <textarea class="form-control" name="message" rows="5" required></textarea>
                </div>
            </div>
            <div class="panel-footer">
                <div class="row">
                    <div class="col-md-12">
                        <button class="btn btn-default pull-right" type="submit" name="send_sms" value="1">
                            <i class="fas fa-paper-plane"></i> <?= translate('Send'); ?>
                        </button>
                    </div>
                </div>
            </div>
            <?= form_close(); ?>
        </section>
    </div>
</div>