<div class="row">
    <div class="col-md-12">
        <!-- Existing Client Selection and SMS Sending Section -->
        <section class="panel">
            <header class="panel-heading">
                <h4 class="panel-title"><i class="far fa-edit"></i> <?php echo translate('select') . " " . translate('Student'); ?></h4>
            </header>
            <?php echo form_open($this->uri->uri_string()); ?>
            <div class="panel-body">
                <div class="form-group mb-md">
                    <label class="control-label">Student<span class="required">*</span></label>
                    <div class="input-group">
                        <span class="input-group-addon"><i class="fas fa-users"></i></span>
                        <select class="form-control" data-plugin-selectTwo data-width="100%" name="client_id[]" id="client_id" multiple required>
                            <?php if (empty($client_id_list)) : ?>
                                <option value=""><?= translate('No Clients Found'); ?></option>
                            <?php else : ?>
                                <option value=""><?= translate('Select A Client') ?></option>
                                <?php foreach ($client_id_list as $client_id) : ?>
                                    <option value="<?= $client_id->id ?>" <?= set_select('client_id[]', $client_id->id) ?>>
                                        <?= html_escape($client_id->staff_id . '--' . $client_id->name) ?>
                                    </option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                        <span class="error"><?= form_error('client_id'); ?></span>
                    </div>
                </div>
                <div class="form-group mb-md mt-lg">
                    <label class="control-label">Message<span class="required">*</span></label>
                    <textarea class="form-control" name="message" rows="5" required></textarea>
                </div>
            </div>
            <div class="panel-footer">
                <div class="row">
                    <div class="col-md-12">
                        <button class="btn btn-default pull-right" type="submit" name="send_sms" value="1">
                            <i class="fas fa-paper-plane"></i> <?php echo translate('send'); ?>
                        </button>
                    </div>
                </div>
            </div>
            <?php echo form_close(); ?>
        </section>
    </div>
</div>
