<div class="row">
    <div class="col-md-12">
        <section class="panel">
            <header class="panel-heading">
                <h4>Food Shop</h4>
            </header>
            <div class="panel-body">
                <?php echo form_open('food_shop/save', ['class' => 'form-horizontal', 'id' => 'shopForm']); ?>

                <!-- Manager -->
                <div class="form-group">
                    <label class="col-md-2 control-label">Manager <span class="required">*</span></label>
                    <div class="col-md-6">
                        <select name="manager_id" class="form-control" required>
                            <option value="">Select</option>
                            <?php foreach ($managers as $manager) { ?>
                                <option value="<?= $manager['id']; ?>"><?= $manager['name']; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <!-- Food Items -->
                <div id="shopItemWrapper">
                    <div class="form-group shop-item-row">
                        <label class="col-md-2 control-label">Food Item <span class="required">*</span></label>
                        <div class="col-md-4">
                            <select name="food_items[]" class="form-control" required>
                                <option value="">Select</option>
                                <?php foreach ($food_items as $item) { ?>
                                    <option value="<?= $item['id']; ?>"><?= $item['name']; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <input type="number" name="quantities[]" class="form-control" placeholder="Quantity" min="1" required>
                        </div>
                        <div class="col-md-2">
                            <button type="button" class="btn btn-success add-shop-item"><i class="fas fa-plus"></i></button>
                        </div>
                    </div>
                </div>

                <!-- Submit -->
                <div class="form-group mt-4">
                    <div class="col-md-offset-2 col-md-6">
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </div>

                <?php echo form_close(); ?>
            </div>
        </section>
    </div>
</div>

<script>
    $(document).on('click', '.add-shop-item', function () {
        var row = $(this).closest('.shop-item-row').clone();
        row.find('select, input').val('');
        row.find('.add-shop-item')
            .removeClass('btn-success add-shop-item')
            .addClass('btn-danger remove-shop-item')
            .html('<i class="fas fa-trash-alt"></i>');
        $('#shopItemWrapper').append(row);
    });

    $(document).on('click', '.remove-shop-item', function () {
        $(this).closest('.shop-item-row').remove();
    });
</script>
