<?php $roleID = loggedin_role_id(); ?>

<div class="row">
    <div class="col-md-12">
        <section class="panel">
            <header class="panel-heading">
                <h4 class="panel-title"><?= translate('Rules List'); ?></h4>
            </header>
            <div class="panel-body">
                <table id="rulesTable" class="table table-bordered table-hover table-condensed">
                    <thead>
                        <tr>
                            <th><?= translate('Rules Number'); ?></th>
                            <th><?= translate('Description'); ?></th>
                            <?php if ($roleID != 4): ?>
                                <th><?= translate('Created'); ?></th>
                            <?php endif; ?>
                            <?php if ($roleID != 4): ?>
                                <th><?= translate('Action'); ?></th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($logs)) : ?>
                            <?php foreach ($logs as $log) : ?>
                                <tr>
                                    <td><?= htmlspecialchars($log->rules_number); ?></td>
                                    <td><?= nl2br(htmlspecialchars($log->description)); ?></td>

                                    <?php if ($roleID != 4): ?>
                                        <td><?= htmlspecialchars($log->created_by_name); ?></td>
                                    <?php endif; ?>
                                    <?php if ($roleID != 4): ?>
                                        <td>
                                            <button type="button"
                                                class="btn btn-danger btn-sm delete-rule-btn"
                                                data-url="<?= base_url('rules/delete/' . $log->id); ?>"
                                                data-toggle="modal"
                                                data-target="#deleteRuleModal">
                                                <i class="fas fa-trash-alt"></i> <?= translate('Delete'); ?>
                                            </button>

                                        </td>
                                    <?php endif; ?>
                                </tr>
                            <?php endforeach; ?>
                        <?php else : ?>
                            <tr>
                                <td colspan="<?= $roleID != 4 ? 3 : 2 ?>" class="text-center"><?= translate('No records found'); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </section>
    </div>
</div>
<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteRuleModal" tabindex="-1" role="dialog" aria-labelledby="deleteRuleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title" id="deleteRuleModalLabel">Confirm Delete</h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this rule?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <a href="#" class="btn btn-info" id="confirmDeleteBtn">Delete</a>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $('.delete-rule-btn').on('click', function() {
            var url = $(this).data('url');
            $('#confirmDeleteBtn').attr('href', url);
        });
    });
    
</script>