<div class="row">

	<div class="col-md-5">
		<section class="panel">
			<header class="panel-heading">
				<h4 class="panel-title"><i class="far fa-edit"></i> <?php echo translate('add') . " " . translate('Voice Rate'); ?></h4>
			</header>
            <?php echo form_open($this->uri->uri_string()); ?>
				<div class="panel-body">
					<input type="hidden" name="user_id" value="<?php echo get_loggedin_user_id();?>">
					<input type="hidden" class="form-control" name="type" value="voice" required />
					<input type="hidden" class="form-control" name="prefix" value="" required />

					<div class="form-group mb-md">
						<label class="control-label">Name<span class="required">*</span></label>
						<input type="text" class="form-control" name="name" value="" required />
					</div>
					
					<div class="form-group mb-md">
						<label class="control-label">Bill Type<span class="required">*</span></label>
						<select class='form-control' id="bill_type" name="bill_type" data-width='100%' required>
							<option value="">Select Bill Type....</option>
							<option value="by_rate">By Rate</option>
							<option value="by_submission">By Submission</option>
						</select>
					</div>

					<div class="form-group mb-md dynamic-field" id="rate_field" style="display:none">
						<label class="control-label">Rate (In <?php echo $global_config['currency_symbol'];?>)<span class="required">*</span></label>
						<input type="text" class="form-control" name="rate" value="0.0" required />
					</div>

					<div class="form-group mb-md dynamic-field" id="pulse_field" style="display:none">
						<label class="control-label">Pulse ( In Second )<span class="required">*</span></label>
						<input type="text" class="form-control" name="pulse" value="60" required />
					</div>

					<div class="form-group mb-md dynamic-field" id="max_duration_field" style="display:none">
						<label class="control-label">Maximum Duration  ( In Second )<span class="required">*</span></label>
						<input type="text" class="form-control" name="max_duration" value="120" required />
					</div>
					
					
					
				</div>
				<div class="panel-footer">
					<div class="row">
						<div class="col-md-12">
							<button class="btn btn-default pull-right" type="submit" name="category" value="1"><i class="fas fa-plus-circle"></i> <?php echo translate('save'); ?></button>
						</div>	
					</div>
				</div>
			<?php echo form_close(); ?>
		</section>
	</div>

	<div class="col-md-<?php if (get_permission('rate_profile', 'is_add')){ echo "7"; }else{echo "12";} ?>">
		<section class="panel">
			<header class="panel-heading">
				<h4 class="panel-title"><i class="fas fa-list-ul"></i> <?php echo translate('Voice Rate Profiles'); ?></h4>
			</header>
			<div class="panel-body">
				<div class="table-responsive">
					<table class="table table-bordered table-hover table-condensed mb-none">
						<thead>
							<tr>
								<th><?php echo translate('sl'); ?></th>
								<th><?php echo translate('name'); ?></th>
								<th><?php echo translate('Bill Type'); ?></th>
								<th><?php echo translate('Rate'); ?></th>
								<th><?php echo translate('Pulse/Max-duration'); ?></th>
								<th><?php echo translate('Assign_to'); ?></th>
								<th><?php echo translate('action'); ?></th>
							</tr>
						</thead>
						<tbody>
						<?php
						$count = 1;
						if (!empty($rateprofile)){
							foreach ($rateprofile as $row):
							?>
							<tr>
								<td><?php echo $count++; ?></td>
								<td><?php echo translate($row['name']); ?></td>
								<td><?php echo translate($row['bill_type']); ?></td>
								<td><?php echo $global_config['currency_symbol']. translate($row['rate']); ?></td>
								<td><?php 
								
								if($row['bill_type']=='by_rate'){
									echo translate($row['pulse']). " Sec.";
								}
								else{
									echo translate($row['max_duration']). " Sec.";
								}
								
								?></td>
								<td><?php echo translate($row['staff_name']); ?></td>
								<td>
									<!--
									<a class="btn btn-default btn-circle icon" href="javascript:void(0);" data-toggle="tooltip" data-original-title="<?php echo translate('edit');?>"
									onclick="getRateProfile('<?php echo html_escape($row['id']); ?>')">
										<i class="fas fa-pen-nib"></i>
									</a>
									-->
									<?php echo btn_delete('rateprofile/rateprofile_delete/' . $row['id']); ?>
								</td>
							</tr>
						<?php
								endforeach;
							}else{
								echo '<tr><td colspan="6"><h5 class="text-danger text-center">' . translate('no_information_available') . '</td></tr>';
							}
						?>
						</tbody>
					</table>
				</div>
			</div>
		</section>
	</div>
</div>


<div class="zoom-anim-dialog modal-block modal-block-primary mfp-hide" id="modal">
	<section class="panel">
		<header class="panel-heading">
			<h4 class="panel-title">
				<i class="far fa-edit"></i> <?php echo translate('edit') . " " . translate('Rate Profile'); ?>
			</h4>
		</header>
		
		
		<?php echo form_open(base_url('rateprofile/voice_rate'), array('class' => 'validate')); ?>
			<div class="panel-body">
				<input type="hidden" name="id" id="eid" value="" />
				<input type="hidden" name="type" id="etype" value="" />
				<input type="hidden" name="bill_type" id="ebill_type" value="" />
				
				<div class="form-group mb-md">
					<label class="control-label">Name<span class="required">*</span></label>
					<input type="text" class="form-control" required  value="" name="name" id="ename" />
				</div>
				
				<div class="form-group mb-md">
					<label class="control-label">Rate<span class="required">*</span></label>
					<input type="text" class="form-control" required  value="" name="rate" id="erate" />
				</div>
				
				<div class="form-group mb-md">
					<label class="control-label">Pulse/sec.<span class="required">*</span></label>
					<input type="text" class="form-control" required  value="" name="pulse" id="epulse" />
				</div>
				
				<div class="form-group mb-md">
					<label class="control-label">Max_duration<span class="required">*</span></label>
					<input type="text" class="form-control" required  value="" name="max_duration" id="emax_duration" />
				</div>
				
				
				

			</div>
			<footer class="panel-footer">
				<div class="row">
					<div class="col-md-12 text-right">
						<button type="submit" class="btn btn-default"><?php echo translate('update'); ?></button>
						<button class="btn btn-default modal-dismiss"><?php echo translate('cancel'); ?></button>
					</div>
				</div>
			</footer>
		<?php echo form_close(); ?>
	</section>
</div>



 <script>
        $(document).ready(function () {
            // Initial check on page load
            checkBillType();

            // Bind change event to the "Bill Type" dropdown
            $('#bill_type').change(function () {
                checkBillType();
            });

            function checkBillType() {
                var selectedBillType = $('#bill_type').val();

                // Hide all related fields by default
                $('.dynamic-field').hide();
                $('#rate_field').hide();

                // Show the appropriate fields based on the selected "Bill Type"
                if (selectedBillType === 'by_rate') {
                    $('#rate_field, #pulse_field').show();
                    $('#rate_field input, #pulse_field input').prop('required', true);
                } else if (selectedBillType === 'by_submission') {
                    $('#rate_field, #max_duration_field').show();
                    $('#rate_field input, #max_duration_field input').prop('required', true);
                }
            }
        });
    </script>