<?php 
$currency_symbol = $global_config['currency_symbol']; 
?>
<div class="row">
    <div class="col-md-12 mb-lg">
        <div class="profile-head social">
            <div class="col-md-12 col-lg-4 col-xl-3">
                <div class="image-content-center user-pro">
                    <div class="preview">
                        <ul class="social-icon-one">
                            <li>
                                <a href="<?= (empty($staff['facebook_url']) ? '#' : $staff['facebook_url']); ?>">
                                    <span class="fab fa-facebook-f"></span>
                                </a>
                            </li>
                            <li>
                                <a href="<?= (empty($staff['twitter_url']) ? '#' : $staff['twitter_url']); ?>">
                                    <span class="fab fa-twitter"></span>
                                </a>
                            </li>
                            <li>
                                <a href="<?= (empty($staff['linkedin_url']) ? '#' : $staff['linkedin_url']); ?>">
                                    <span class="fab fa-linkedin-in"></span>
                                </a>
                            </li>
                        </ul>
                        <img src="<?= $this->app_lib->get_image_url('staff/' . $staff['photo']); ?>">
                    </div>
                </div>
            </div>
            <div class="col-md-12 col-lg-8 col-xl-8">
                <h5><?= html_escape($staff['name']); ?> / <?= html_escape($staff['username']) ?></h5>
                <p><?= ucfirst($staff['role']); ?> / <?= html_escape($staff['designation_name']); ?></p>
                <ul>
                    <li class="row mb-xs">
                        <!-- customer_number-->
                        <div class="col-md-4">
                            <div class="icon-holder" data-toggle="tooltip"
                                data-original-title="<?= translate('customer number'); ?>">
                                <i class="fas fa-link"></i>
                            </div> <?= html_escape(!empty($staff['merchant_no']) ? $staff['merchant_no'] : 'N/A'); ?>
                        </div>

                        <!-- mobile_no -->
                        <div class="col-md-4">
                            <div class="icon-holder" data-toggle="tooltip"
                                data-original-title="<?= translate('mobile_no'); ?>"><i class="fas fa-phone"></i>
                            </div> <?= html_escape(!empty($staff['mobileno']) ? $staff['mobileno'] : 'N/A'); ?>

                        </div>

                        <!-- email -->
                        <div class="col-md-4">
                            <div class="icon-holder" data-toggle="tooltip"
                                data-original-title="<?= translate('email'); ?>"><i class="far fa-envelope"></i>
                            </div> <?= html_escape($staff['email']); ?>
                        </div>
                    </li>

                    <li class="row mb-xs">
                        <!-- client_type -->
                        <div class="col-md-4">
                            <div class="icon-holder" data-toggle="tooltip"
                                data-original-title="<?= translate('client_type'); ?>"><i class="fas fa-user-tie"></i>
                            </div> <?= html_escape(ucfirst($staff['client_type'])); ?>
                        </div>

                        <!-- package -->
                        <div class="col-md-4">
                            <div class="icon-holder" data-toggle="tooltip"
                                data-original-title="<?= translate('package'); ?>"><i class="fas fa-box"></i>
                            </div> <?= html_escape($staff['package_name']); ?>
                        </div>

                        <!-- expire_date -->
                        <div class="col-md-4">
                            <div class="icon-holder" data-toggle="tooltip"
                                data-original-title="<?= translate('expire_date'); ?>"><i
                                    class="fas fa-calendar-alt"></i>
                            </div> <?= html_escape($staff['expire_date']); ?>
                        </div>
                    </li>

                    <li class="row mb-xs">
                        <!-- server -->
                        <div class="col-md-4">
                            <div class="icon-holder" data-toggle="tooltip"
                                data-original-title="<?= translate('server'); ?>"><i class="fas fa-server"></i>
                            </div> <?= html_escape($staff['nas_name']); ?>
                        </div>

                        <!-- connection_type -->
                        <div class="col-md-4">
                            <div class="icon-holder" data-toggle="tooltip"
                                data-original-title="<?= translate('connection_type'); ?>"><i class="fas fa-plug"></i>
                            </div> <?= html_escape($staff['connection_type']); ?>
                        </div>

                        <!-- referenced_by -->
                        <div class="col-md-4">
                            <div class="icon-holder" data-toggle="tooltip"
                                data-original-title="<?= translate('reference_by'); ?>"><i
                                    class="fas fa-user-friends"></i>
                            </div> <?= html_escape($staff['reference_by']); ?>
                        </div>
                    </li>

                    <li class="row mb-xs">
                        <!-- server_username -->
                        <div class="col-md-4">
                            <div class="icon-holder" data-toggle="tooltip"
                                data-original-title="<?= translate('server_username'); ?>"><i class="fas fa-user"></i>
                            </div> <?= html_escape($staff['server_username']); ?>
                        </div>

                        <!-- server_password -->
                        <div class="col-md-4">
                            <div class="icon-holder" data-toggle="tooltip"
                                data-original-title="<?= translate('server_password'); ?>"><i class="fas fa-key"></i>
                            </div> <?= html_escape($staff['server_password']); ?>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <div class="col-md-12">
        <div class="panel-group" id="accordion">
            <div class="panel panel-accordion">
                <div class="panel-heading">
                    <h4 class="panel-title">
                        <div class="auth-pan">
                            <button class="btn btn-default btn-circle" id="authentication_btn">
                                <i class="fas fa-unlock-alt"></i> <?= translate('authentication'); ?>
                            </button>
                        </div>
                        <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#profile">
                            <i class="fas fa-user-edit"></i> <?= translate('Details Information'); ?>
                        </a>
                    </h4>
                </div>
                <div id="profile"
                    class="accordion-body collapse <?= ($this->session->flashdata('profile_tab') ? 'in' : ''); ?>">
                    <?= form_open_multipart(current_url()); ?>
                    <?= form_hidden('user_role', $staff['role_id']) ?>
                    <?= form_hidden('assign_to', $staff['assign_to']) ?>
                    <div class="panel-body">
                        <fieldset>
                            <input type="hidden" name="staff_id" id="staff_id"
                                value="<?= html_escape($staff['id']); ?>">
                            <!-- Employee Details -->
                            <div class="headers-line mt-md"><i
                                    class="fas fa-user-check"></i> <?= translate('basic_details'); ?></div>
                            <div class="row">
                                <!-- Name -->
                                <div class="col-md-6 mb-sm">
                                    <div class="form-group <?php if (form_error('name')) echo 'has-error'; ?>">
                                        <label class="control-label"><?= translate('name'); ?> <span
                                                class="required">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-addon"><i class="far fa-user"></i></span>
                                            <input type="text" class="form-control" name="name"
                                                value="<?= set_value('name', $staff['name']); ?>" />
                                        </div>
                                        <span class="error"><?= form_error('name'); ?></span>
                                    </div>
                                </div>

                                <!-- gender -->
                                <div class="col-md-6 mb-sm">
                                    <div class="form-group">
                                        <label class="control-label"><?= translate('gender'); ?></label>
                                        <?php
                                        $gender_array = array(
                                            "" => translate('select'),
                                            "male" => translate('male'),
                                            "female" => translate('female')
                                        );
                                        echo form_dropdown("gender", $gender_array, set_value('gender', $staff['gender']), "class='form-control' data-plugin-selectTwo data-width='100%'
												data-minimum-results-for-search='Infinity'");
                                        ?>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <!-- birthdate -->
                                <div class="col-md-6 mb-sm">
                                    <div class="form-group">
                                        <label class="control-label"><?= translate('Registration Date'); ?></label>
                                        <div class="input-group">
                                            <span class="input-group-addon"><i class="fas fa-calendar-alt"></i></span>
                                            <input class="form-control" name="birthday" id="patient_birthday"
                                                value="<?= set_value('birthday', $staff['birthday']) ?>"
                                                data-plugin-datepicker
                                                data-plugin-options='{ "startView": 2 }' type="text">
                                        </div>
                                    </div>
                                </div>
                                <!-- martial_status-->
                                <div class="col-md-6 mb-sm">
                                    <div class="form-group">
                                        <label class="control-label"><?= translate('marital_status'); ?></label>
                                        <?= form_dropdown(
                                            "marital_status",
                                            $maritalStatus,
                                            $staff['marital_status'],
                                            "class='form-control' data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity'"
                                        );
                                        ?>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <!-- mobileno -->
                                <div class="col-md-6 mb-sm">
                                    <div class="form-group <?php if (form_error('mobile_no')) echo 'has-error'; ?>">
                                        <label class="control-label"><?= translate('mobile_no'); ?></label>
                                        <div class="input-group">
                                            <span class="input-group-addon"><i class="fas fa-phone-volume"></i></span>
                                            <input class="form-control" name="mobile_no" type="text"
                                                value="<?= set_value('mobile_no', $staff['mobileno']); ?>">
                                        </div>
                                        <span class="error"><?= form_error('mobile_no'); ?></span>
                                    </div>
                                </div>
                                <!-- email -->
                                <div class="col-md-6 mb-sm">
                                    <div class="form-group <?php if (form_error('email')) echo 'has-error'; ?>">
                                        <label class="control-label"><?= translate('email'); ?> <span
                                                class="required">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-addon"><i class="far fa-envelope-open"></i></span>
                                            <input type="text" class="form-control" name="email" id="email"
                                                value="<?= set_value('email', $staff['email']); ?>" />
                                        </div>
                                        <span class="error"><?= form_error('email'); ?></span>
                                    </div>
                                </div>
                            </div>


                            <!--  address -->
                            <div class="row">
                                <div class="col-md-12 mb-sm">
                                    <div class="form-group">
                                        <label class="control-label"><?= translate('address'); ?></label>
                                        <textarea class="form-control" rows="2" name="address"
                                            placeholder="<?= translate('address'); ?>"><?= set_value('address', $staff['address']); ?></textarea>
                                    </div>
                                </div>
                            </div>

                            <!-- photo -->
                            <div class="row mb-md">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="input-file-now"><?= translate('profile_picture'); ?></label>
                                        <input type="file" name="user_photo" class="dropify"
                                            data-allowed-file-extensions="jpg png"
                                            data-default-file="<?= $this->app_lib->get_image_url('staff/' . $staff['photo']); ?>" />
                                    </div>
                                </div>
                                <input type="hidden" name="old_user_photo"
                                    value="<?= html_escape($staff['photo']); ?>" />
                            </div>

                            <!-- Network & Product Information -->
                            <section>
                                <div class="headers-line">
                                    <i class="fas fa-wifi"></i> <?= translate('Network & Product Information'); ?>
                                </div>
                                <div class="row">

                                    <!-- zone -->
                                    <div class="col-sm-4 mb-sm">
                                        <div class="form-group">
                                            <label for="zone_id" class="control-label">
                                                <?= translate('zone') ?>
                                                <span class="required">*</span>
                                            </label>
                                            <select name="zone_id" id="zone_id" class='form-control'
                                                data-plugin-selectTwo
                                                data-width='100%' data-minimum-results-for-search='Infinity'>
                                                <option value=""><?= translate('select') ?></option>
                                                <?php if (!empty($zones)): ?>
                                                    <?php foreach ($zones as $zone): ?>
                                                        <option value="<?= $zone->id ?>" <?= set_select('zone_id', $zone->id, ($staff['zone_id'] ?? null) == $zone->id) ?>><?= $zone->name ?></option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <!-- olt -->
                                    <div class="col-sm-4 mb-sm">
                                        <div class="form-group">
                                            <label for="olt_id" class="control-label">
                                                <?= translate('olt') ?>
                                                <span class="required">*</span>
                                            </label>
                                            <select name="olt_id" id="olt_id" class='form-control'
                                                data-plugin-selectTwo
                                                data-width='100%' data-minimum-results-for-search='Infinity'>
                                                <option value=""><?= translate('select') ?></option>
                                                <?php if (!empty($olts)): ?>
                                                    <?php foreach ($olts as $olt): ?>
                                                        <option value="<?= $olt->id ?>" <?= set_select('olt_id', $olt->id, ($staff['olt_id'] ?? null) == $olt->id) ?>><?= $olt->name ?></option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>

                                    <!-- box -->
                                    <div class="col-sm-4 mb-sm">
                                        <div class="form-group">
                                            <label for="box"
                                                class="control-label"><?= translate('box'); ?></label>
                                            <input class="form-control" name="box" id="box" type="text"
                                                value="<?= set_value('box', $staff['box']); ?>">
                                        </div>
                                    </div>
                                </div>

                                <div class="row">

                                    <div class="col-sm-3 mb-sm">
                                        <div class="form-group">
                                            <label for="cable_requirement"
                                                class="control-label"><?= translate('cable_requirement_in_metre'); ?></label>
                                            <input class="form-control" name="cable_requirement" id="cable_requirement"
                                                type="number"
                                                value="<?= set_value('cable_requirement', $staff['cable_requirement']); ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-3 mb-sm">
                                        <div class="form-group">
                                            <label for="fiber_code"
                                                class="control-label"><?= translate('fiber_code'); ?></label>
                                            <input class="form-control" name="fiber_code" id="fiber_code" type="text"
                                                value="<?= set_value('fiber_code', $staff['fiber_code']); ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-3 mb-sm">
                                        <div class="form-group">
                                            <label for="number_of_core"
                                                class="control-label"><?= translate('number_of_core'); ?></label>
                                            <input class="form-control" name="number_of_core" id="number_of_core"
                                                type="number"
                                                value="<?= set_value('number_of_core', $staff['number_of_core']); ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-3 mb-sm">
                                        <div class="form-group">
                                            <label for="core_color"
                                                class="control-label"><?= translate('core_color'); ?></label>
                                            <input class="form-control" name="core_color" id="core_color" type="text"
                                                value="<?= set_value('core_color', $staff['core_color']); ?>">
                                        </div>
                                    </div>
                                </div>
                            </section>
                        </fieldset>
                    </div>
                    <div class="panel-footer">
                        <div class="row">
                            <div class="col-md-offset-9 col-md-3">
                                <button type="submit" name="submit" value="update" class="btn btn-default btn-block">
                                    <?= translate('update'); ?>
                                </button>
                            </div>
                        </div>
                    </div>
                    <?= form_close(); ?>
                </div>
            </div>

            <?php if (get_permission('billing', 'is_view')) { ?>
                <div class="panel panel-accordion">
                    <div class="panel-heading">
                        <h4 class="panel-title">
                            <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#diagnostic"><i class="fas fa-money-check"></i> <?php echo translate('bill') . " " . translate('history'); ?></a>
                        </h4>
                    </div>
                    <div id="diagnostic" class="accordion-body collapse">
                        <div class="panel-body">
                            <div class="export_title"><?php echo html_escape($staff['name']); ?> - Bill History</div>
                            <table class="table table-bordered table-hover table-condensed" cellspacing="0" width="100%" id="table-export">
                                <thead>
                                    <tr>
                                        <th><?php echo translate('sl'); ?></th>
                                        <th><?php echo translate('bill_no'); ?></th>
                                        <th><?php echo translate('bill') . " " . translate('date'); ?></th>
                                        <th><?php echo translate('due') . " " . translate('date'); ?></th>
                                        <th><?php echo translate('payment') . " " . translate('status'); ?></th>
                                        <th><?php echo translate('net') . " " . translate('payable'); ?></th>
                                        <th><?php echo translate('paid'); ?></th>
                                        <th><?php echo translate('due'); ?></th>
                                        <th width="130"><?php echo translate('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $count = 1;
                                    if (!empty($billlist)) {
                                        foreach ($billlist as $row):
                                    ?>
                                            <tr>
                                                <td><?php echo $count++; ?></td>
                                                <td><?php echo html_escape($row['bill_no']); ?></td>
                                                <td><?= html_escape(_d($row['date'])); ?></td>
                                                <td><?= html_escape(_d($row['due_date'])); ?></td>

                                                <td>
                                                    <?php
                                                    $labelMode = "";
                                                    $status = $row['status'];
                                                    if ($status == 1) {
                                                        $status = translate('unpaid');
                                                        $labelMode = 'label-danger-custom';
                                                    } elseif ($status == 2) {
                                                        $status = translate('partly_paid');
                                                        $labelMode = 'label-info-custom';
                                                    } elseif ($status == 3 || $row['total_due'] == 0) {
                                                        $status = translate('total_paid');
                                                        $labelMode = 'label-success-custom';
                                                    }
                                                    echo "<span class='label " . $labelMode . "'>" . $status . "</span>";
                                                    ?>
                                                </td>
                                                <td><?php echo html_escape($currency_symbol . number_format($row['net_amount'], 2, '.', '')); ?></td>
                                                <td><?php echo html_escape($currency_symbol . number_format($row['paid'], 2, '.', '')); ?></td>
                                                <td><?php echo html_escape($currency_symbol . number_format($row['due'], 2, '.', '')); ?></td>
                                                <td class="min-w-c">
                                                    <a href="<?php echo base_url('billing/invoice/' . html_escape($row['id']) . "/" . html_escape($row['hash'])); ?>" class="btn btn-circle btn-default"> <i class="fas fa-eye"></i>
                                                        <?php echo translate('invoice'); ?>
                                                    </a>

                                                    <?php if (get_permission('billing', 'is_delete')): ?>
                                                        <?php echo btn_delete('billing/test_bill_delete/' . $row['id']); ?>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                    <?php endforeach;
                                    } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php } ?>

            <?php if (get_permission('payment_logs', 'is_view')) { ?>
                <div class="panel panel-accordion">
                    <div class="panel-heading">
                        <h4 class="panel-title">
                            <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#payment_logs"><i class="fas fa-money-check"></i> <?php echo translate('Payment') . " " . translate('history'); ?></a>
                        </h4>
                    </div>
                    <div id="payment_logs" class="accordion-body collapse">
                        <div class="panel-body">
                            <div class="export_title"><?php echo html_escape($staff['name']); ?> - Payment History</div>
                            <table class="table table-bordered table-hover table-condensed" cellspacing="0" width="100%" id="table-export">
                                <thead>
                                    <tr>
                                        <th><?php echo translate('Id'); ?></th>
                                        <th><?php echo translate('bill id'); ?></th>
                                        <th><?php echo translate('date') . " " . translate('time'); ?></th>
                                        <th><?php echo translate('payment') . " " . translate('method'); ?></th>
                                        <th><?php echo translate('Transaction') . " " . translate('Id'); ?></th>
                                        <th><?php echo translate('Payment') . " " . translate('From'); ?></th>
                                        <th><?php echo translate('Payment') . " " . translate('For'); ?></th>
                                        <th><?php echo translate('Credit') . " " . translate('Amount'); ?></th>
                                        <th><?php echo translate('Debit') . " " . translate('Amount'); ?></th>
                                        <th><?php echo translate('Status'); ?></th>
                                        <th><?php echo translate('Remarks'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $count = 1;
                                    if (!empty($paymentlist)) {
                                        foreach ($paymentlist as $row):
                                    ?>
                                            <tr>
                                                <td><?php echo $count++; ?></td>
                                                <td><?php echo html_escape($row['bill_id']); ?></td>
                                                <td><?= html_escape(_d($row['datetime'])); ?></td>
                                                <td><?= html_escape($row['payment_method']); ?></td>
                                                <td><?= html_escape($row['pay_id']); ?></td>
                                                <td><?= html_escape($row['payment_from']); ?></td>
                                                <td><?= html_escape($row['payment_for']); ?></td>
                                                <td><?php echo html_escape($currency_symbol . number_format($row['credit_in'], 2, '.', '')); ?></td>
                                                <td><?php echo html_escape($currency_symbol . number_format($row['credit_out'], 2, '.', '')); ?></td>
                                                <td>
                                                    <?php
                                                    $status = $row['status'];
                                                    if ($status != 'success') {
                                                        $status = translate('pending');
                                                        $labelMode = 'label-warning-custom';
                                                    } elseif ($status == 'success') {
                                                        $status = translate('complete');
                                                        $labelMode = 'label-success-custom';
                                                    }
                                                    echo "<span class='label " . $labelMode . "'>" . $status . "</span>";
                                                    ?>
                                                </td>
                                                <td><?php echo html_escape($row['remarks']); ?></td>

                                            </tr>
                                    <?php endforeach;
                                    } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php } ?>
            <?php if (get_permission('package_change_history', 'is_view')) { ?>
            <div class="panel panel-accordion">
                <div class="panel-heading">
                    <h4 class="panel-title">
                        <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#package_change_history">
                            <i class="fas fa-folder-open"></i> <?php echo translate('Package Change') . " " . translate('History'); ?>
                        </a>
                    </h4>
                </div>
                <div id="package_change_history" class="accordion-body collapse <?php echo ($this->session->flashdata('documents_details') == 1 ? 'in' : ''); ?>">
                    <div class="panel-body">
                        <div class="table-responsive mb-md">
                        <table class="table table-bordered table-hover table-condensed table_default">
                        <thead>
                            <tr>
                                <th><?php echo translate('Id'); ?></th>
                                <th><?= translate('From Package') ?></th>
                                <th><?= translate('To Package') ?></th>
                                <th><?= translate('created Name') ?></th>   
                                <th><?= translate('created At') ?></th>   

                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($package_change_history)) : ?>
                                <?php foreach ($package_change_history as $change_history): ?>
                                    <tr>
                                        <td><?php echo $count++; ?></td>
                                        <td><?= html_escape($change_history['from_package_name']); ?></td>
                                        <td><?= html_escape($change_history['to_package_name']); ?></td>
                                        <td><?= html_escape($change_history['created_by_name']); ?></td> 
                                        <td><?= html_escape($change_history['created_at']); ?></td> 

                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                        </div>
                    </div>
                </div>
            </div>
            <?php } ?>
            <?php if (get_permission('sms_history', 'is_view')) { ?>
            <div class="panel panel-accordion">
                <div class="panel-heading">
                    <h4 class="panel-title">
                        <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#sms_history">
                            <i class="fas fa-sms"></i> <?php echo translate('Sms') . " " . translate('History'); ?>
                        </a>
                    </h4>
                </div>
                <div id="sms_history" class="accordion-body collapse <?php echo ($this->session->flashdata('documents_details') == 1 ? 'in' : ''); ?>">
                    <div class="panel-body">
                        <div class="table-responsive mb-md">
                        <table class="table table-bordered table-hover table-condensed table_default">
                        <thead>
                            <tr>
                            <th class="sorting_disabled" rowspan="1" colspan="1" style="text-align: center;">Id</th>
                            <th class="sorting_disabled" rowspan="1" colspan="1" style="text-align: center;">Sms text</th>
                            <th class="sorting_disabled" rowspan="1" colspan="1" style="text-align: center;">Created at</th>
                            <th class="sorting_disabled" rowspan="1" colspan="1" style="text-align: center;">Status</th>
                            <th class="sorting_disabled" rowspan="1" colspan="1" style="text-align: center;">Created by</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($sms_history)) : ?>
                                <?php foreach ($sms_history as $change_history): ?>
                                    <tr>
                                        <td><?php echo $count++; ?></td>
                                        <td><?= html_escape($change_history['sms_text']); ?></td>
                                        <td><?= html_escape($change_history['created_at']); ?></td>
                                        <td><div style="padding: 10px;">
                                        <div style="background-color: #f0f8ff; border-radius: 10px; padding: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);"><?= html_escape($change_history['status']); ?></td>
                                        <td><?= html_escape($change_history['creation_by']); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                        </div>
                    </div>
                </div>
            </div>
            <?php } ?>
            <div class="panel panel-accordion">
                <div class="panel-heading">
                    <h4 class="panel-title">
                        <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#documents_details">
                            <i class="fas fa-folder-open"></i> <?php echo translate('document') . " " . translate('details'); ?>
                        </a>
                    </h4>
                </div>
                <div id="documents_details" class="accordion-body collapse <?php echo ($this->session->flashdata('documents_details') == 1 ? 'in' : ''); ?>">
                    <div class="panel-body">
                        <div class="text-right mb-sm">
                            <a href="javascript:void(0);" id="addStaffDocuments" class="btn btn-circle btn-default mb-sm">
                                <i class="fas fa-plus-circle"></i> <?php echo translate('add') . " " . translate('document'); ?>
                            </a>
                        </div>
                        <div class="table-responsive mb-md">
                            <table class="table table-bordered table-hover table-condensed mb-none">
                                <thead>
                                    <tr>
                                        <th><?php echo translate('sl'); ?></th>
                                        <th><?php echo translate('title'); ?></th>
                                        <th><?php echo translate('document') . " " . translate('type'); ?></th>
                                        <th><?php echo translate('file'); ?></th>
                                        <th><?php echo translate('remarks'); ?></th>
                                        <th><?php echo translate('created_at'); ?></th>
                                        <th><?php echo translate('actions'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $count = 1;
                                    $this->db->where('staff_id', $staff['id']);
                                    $documents = $this->db->get('staff_documents')->result();
                                    if (count($documents)) {
                                        foreach ($documents as $row):
                                    ?>
                                            <tr>
                                                <td><?php echo $count++ ?></td>
                                                <td><?php echo html_escape($row->title); ?></td>
                                                <td><?php echo html_escape($categorylist[$row->category_id]); ?></td>
                                                <td><?php echo html_escape($row->file_name); ?></td>
                                                <td><?php echo html_escape($row->remarks); ?></td>
                                                <td><?php echo html_escape(_d($row->created_at)); ?></td>
                                                <td class="min-w-c">
                                                    <a href="<?php echo base_url('client/documents_download?file=' . $row->enc_name); ?>" class="btn btn-default btn-circle icon" data-toggle="tooltip" data-original-title="<?php echo translate('download'); ?>">
                                                        <i class="fas fa-cloud-download-alt"></i>
                                                    </a>
                                                    <a href="javascript:void(0);" data-id="<?php echo html_escape($row->id); ?>" class="btn btn-circle icon btn-default" onclick="editStaffDocument('<?php echo html_escape($row->id); ?>')">
                                                        <i class="fas fa-pen-nib"></i>
                                                    </a>
                                                    <?php echo btn_delete('client/document_delete/' . $row->id); ?>
                                                </td>
                                            </tr>
                                    <?php
                                        endforeach;
                                    } else {
                                        echo '<tr> <td colspan="7"> <h5 class="text-danger text-center">' . translate('no_information_available') . '</h5> </td></tr>';
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Login Authentication And Account Inactive Modal -->
<div id="authentication_modal" class="zoom-anim-dialog modal-block modal-block-primary mfp-hide">
    <section class="panel">
        <header class="panel-heading">
            <h4 class="panel-title">
                <i class="fas fa-unlock-alt"></i> <?= translate('authentication'); ?>
            </h4>
        </header>
        <div class="panel-body">
            <div class="form-group">
                <label for="password" class="control-label"><?= translate('password'); ?> <span
                        class="required">*</span></label>
                <div class="input-group">
                    <input type="password" class="form-control password" name="password" id="reset_password" />
                    <span class="input-group-addon">
                        <a href="javascript:void(0);" id="showPassword"><i class="fa fa-eye"></i></a>
                    </span>
                </div>
                <span class="control-label" id="password-msg"></span>
            </div>
            <div class="form-group mb-md">
                <div class="checkbox-replace">
                    <label class="i-checks">
                        <input type="checkbox" name="authentication" id="cb_authentication">
                        <i></i> <?= translate('login_authentication_deactivate'); ?>
                    </label>
                </div>
            </div>
        </div>
        <footer class="panel-footer">
            <div class="text-right">
                <button class="btn btn-default mr-xs" id="staffPassUpdate"
                    data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing"><?= translate('update'); ?></button>
                <button class="btn btn-default modal-dismiss"><?= translate('close'); ?></button>
            </div>
        </footer>
    </section>
</div>

<!-- Documents Details Add Modal -->
<div id="add_documents_modal" class="zoom-anim-dialog modal-block modal-block-primary mfp-hide">
    <section class="panel">
        <div class="panel-heading">
            <h4 class="panel-title"><i class="fas fa-plus-circle"></i> <?php echo translate('add') . " " . translate('document'); ?></h4>
        </div>
        <?php echo form_open_multipart(base_url('employee/document_create'), array('class' => 'form-horizontal', 'id' => 'docaddfrm')); ?>
        <div class="panel-body">
            <input type="hidden" name="staff_id" value="<?php echo html_escape($staff['id']); ?>">
            <div class="form-group mt-md">
                <label class="col-md-3 control-label"><?php echo translate('title'); ?> <span class="required">*</span></label>
                <div class="col-md-9">
                    <input type="text" class="form-control" name="document_title" id="adocument_title" value="" />
                    <span class="error"></span>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3 control-label"><?php echo translate('category'); ?> <span class="required">*</span></label>
                <div class="col-md-9">
                    <?php
                    echo form_dropdown("document_category", $categorylist, set_value('document_category'), "class='form-control' data-plugin-selectTwo
                        data-width='100%' id='adocument_category' data-minimum-results-for-search='Infinity' ");
                    ?>
                    <span class="error"></span>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3 control-label"><?php echo translate('document') . " " . translate('file'); ?> <span class="required">*</span></label>
                <div class="col-md-9">
                    <input type="file" name="document_file" class="dropify" data-height="110" data-default-file="" id="adocument_file" />
                    <span class="error"></span>
                </div>
            </div>
            <div class="form-group mb-md">
                <label class="col-md-3 control-label"><?php echo translate('remarks'); ?></label>
                <div class="col-md-9">
                    <textarea class="form-control valid" rows="2" name="remarks"></textarea>
                </div>
            </div>
        </div>
        <footer class="panel-footer">
            <div class="row">
                <div class="col-md-12 text-right">
                    <button type="submit" id="docsavebtn" class="btn btn-default" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
                        <i class="fas fa-plus-circle"></i> <?php echo translate('save'); ?>
                    </button>
                    <button class="btn btn-default modal-dismiss"><?php echo translate('cancel'); ?></button>
                </div>
            </div>
        </footer>
        <?php echo form_close(); ?>
    </section>
</div>

<!-- Documents Details Edit Modal -->
<div id="editDocModal" class="zoom-anim-dialog modal-block modal-block-primary mfp-hide">
    <section class="panel">
        <div class="panel-heading">
            <h4 class="panel-title"><i class="far fa-edit"></i> <?php echo translate('edit') . " " . translate('document'); ?></h4>
        </div>
        <?php echo form_open_multipart(base_url('employee/document_update'), array('class' => 'form-horizontal', 'id' => 'doceditfrm')); ?>
        <div class="panel-body">
            <input type="hidden" name="document_id" id="edocument_id" value="">
            <div class="form-group mt-md">
                <label class="col-md-3 control-label"><?php echo translate('title'); ?> <span class="required">*</span></label>
                <div class="col-md-9">
                    <input type="text" class="form-control" name="document_title" id="edocument_title" value="" />
                    <span class="error"></span>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3 control-label"><?php echo translate('category'); ?> <span class="required">*</span></label>
                <div class="col-md-9">
                    <?php
                    echo form_dropdown("document_category", $categorylist, set_value('document_category'), "class='form-control' data-plugin-selectTwo id='edocument_category'
                            data-width='100%' data-minimum-results-for-search='Infinity' ");
                    ?>
                    <span class="error"></span>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3 control-label"><?php echo translate('document') . " " . translate('file'); ?> <span class="required">*</span></label>
                <div class="col-md-9">
                    <input type="file" name="document_file" class="dropify" data-height="120" data-default-file="">
                    <input type="hidden" name="exist_file_name" id="exist_file_name" value="">
                </div>
            </div>
            <div class="form-group mb-md">
                <label class="col-md-3 control-label"><?php echo translate('remarks'); ?></label>
                <div class="col-md-9">
                    <textarea class="form-control valid" rows="2" name="remarks" id="edocuments_remarks"></textarea>
                </div>
            </div>
        </div>
        <footer class="panel-footer">
            <div class="row">
                <div class="col-md-12 text-right">
                    <button type="submit" class="btn btn-default" id="doceditbtn" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
                        <?php echo translate('update'); ?>
                    </button>
                    <button class="btn btn-default modal-dismiss"><?php echo translate('cancel'); ?></button>
                </div>
            </div>
        </footer>
        <?php echo form_close(); ?>
    </section>
</div>


<script type="text/javascript">
    $(document).ready(function() {
        // user authentication modal show
        $('#authentication_btn').on('click', function() {
            var status = "<?= html_escape($staff['active']); ?>";
            if (status === '0') {
                $('#cb_authentication').prop('checked', true);
                $('#cb_authentication').prop('disabled', true);
                $('#reset_password').val("");
                $('#reset_password').prop('disabled', true);
            } else {
                $('#cb_authentication').prop('checked', false);
                $('#cb_authentication').prop('disabled', false);
                $('#reset_password').val("");
                $('#reset_password').prop('disabled', false);
            }
            mfp_modal('#authentication_modal');
        });
    });
</script>

<!-- <script>
    $(document).ready(function () {
        var roleDropdown = $("select[name='user_role']");
        var assignedAdmin = $("#assigned_admin");

        // Function to toggle the visibility of the Assigned Admin field
        function toggleAssignedAdmin() {
            var selectedRole = roleDropdown.val();
            if (selectedRole === "3") {
                assignedAdmin.show();
                assignedAdmin.find("select").prop("", true); // Make it required
            } else {
                assignedAdmin.hide().val('');
                assignedAdmin.find("select").prop("required", false); // Make it not required
            }
        }

        // Initial toggle based on the selected role
        toggleAssignedAdmin();

        // Attach an event listener to the role dropdown to toggle visibility on change
        roleDropdown.on("change", function () {
            toggleAssignedAdmin();
        });
    });
</script> -->