<section class="panel">
    <div class="tabs-custom">
        <ul class="nav nav-tabs">
            <li class="<?= (empty(validation_errors()) && (($action ?? null) != 'edit')) ? 'active' : null ?>">
                <a
                    <?php if (($action ?? null) == 'edit') : ?>
                    href="<?= base_url('package'); ?>"
                    <?php else: ?>
                    href="#list" data-toggle="tab"
                    <?php endif; ?>>
                    <i class="fas fa-list-ul"></i>
                    <?= translate('Packages') ?>
                </a>
            </li>
            <?php if (get_permission('package', 'is_add')): ?>
                <li class="<?= (!empty(validation_errors()) || (($action ?? null) == 'edit')) ? 'active' : null ?>">
                    <a href="#create" data-toggle="tab">
                        <i class="far fa-edit"></i>
                        <?php if (($action ?? null) == 'edit'): ?>
                            <?= translate('Edit Package') ?>
                        <?php else: ?>
                            <?= translate('Add Package') ?>
                        <?php endif; ?>
                    </a>
                </li>
            <?php endif; ?>
        </ul>
        <div class="tab-content">

            <!-- Package List -->
            <div id="list"
                class="tab-pane <?= (empty(validation_errors()) && (($action ?? null) != 'edit')) ? 'active' : null ?>">
                <div class="mb-md">
                    <table class="table table-bordered table-hover table-condensed table_default">
                        <thead>
                            <tr>
                                <th><?= translate('id'); ?></th>
                                <th><?= translate('Package Name') ?></th>
                                <th><?= translate('Branch') ?></th>
                                <th><?= translate('Branch ID') ?></th>

                                <th><?= translate('package_Type') ?></th>
                                <th><?= translate('Food_Item') ?></th>
                                <th><?= translate('breakfast_cost') ?></th>
                                <th><?= translate('lunch_cost') ?></th>
                                <th><?= translate('dinner_cost') ?></th>
                                <th><?= translate('Meal_price') ?></th>
                                <th><?= translate('action') ?></th>

                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($packages)) : ?>
                                <?php foreach ($packages as $index => $thisPackage): ?>
                                    <tr>
                                        <td><?= $thisPackage->id ?></td>
                                        <td><?= html_escape($thisPackage->name) ?></td>
                                        <td><?= $thisPackage->manager_name ?></td>
                                        <td><?= $thisPackage->manager_merchant_no ?></td>

                                        <td><?= translate($thisPackage->type) ?></td>
                                        <td><?= $thisPackage->food_item ?></td>
                                        <td><?= $thisPackage->breakfast_cost ?></td>
                                        <td><?= $thisPackage->lunch_cost ?></td>
                                        <td><?= $thisPackage->dinner_cost ?></td>
                                        <td><?= $thisPackage->sale_price ?></td>

                                        <td>
                                            <?php if (get_permission('package', 'is_edit')): ?>
                                                <a href="<?php echo base_url('package/edit/' . $thisPackage->id); ?>"
                                                    class="btn btn-circle icon btn-default" data-toggle="tooltip"
                                                    data-original-title="<?php echo translate('edit'); ?>">
                                                    <i class="fas fa-pen-nib"></i>
                                                </a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php
            if (($action ?? null) == 'edit') {
                $can = 'is_edit';
            } else {
                $can = 'is_add';
            }
            ?>
            <?php if (get_permission('package', $can)) : ?>
                <?php if (get_permission('package', $can)) : ?>
                    <div id="create" class="tab-pane <?= (!empty(validation_errors()) || (($action ?? null) == 'edit')) ? 'active' : null ?>">
                        <?= form_open($this->uri->uri_string(), ['class' => 'form-horizontal']); ?>

                        <div class="panel-body">
                            <div class="form-group <?= form_error('name') ? 'has-error' : null ?>">
                                <label for="name" class="control-label col-sm-3">
                                    <?= translate('package_name'); ?> <span class="required">*</span>
                                </label>
                                <div class="col-sm-6">
                                <input type="text" class="form-control" name="name" id="name"
    value="<?= set_value('name', $package->name ?? null) ?>"
    minlength="3" maxlength="255" required
    placeholder="e.g., Weekly Standard Package">
                                    <span class="error"><?= form_error('name'); ?></span>
                                </div>
                            </div>

                            <div class="form-group <?= form_error('type') ? 'has-error' : null ?>">
                                <label for="type" class="control-label col-sm-3">
                                    <?= translate('package_type'); ?> <span class="required">*</span>
                                </label>
                                <div class="col-sm-6">
                                    <select class="form-control" data-plugin-selectTwo name="type" id="type" required>
                                        <?php if (empty($packageTypeList)): ?>
                                            <option value=""><?= translate('no_privacy_found'); ?></option>
                                        <?php else: ?>
                                            <option value=""><?= translate('select_package_type'); ?></option>
                                            <?php foreach ($packageTypeList as $package_type): ?>
                                                <option value="<?= $package_type ?>" <?= set_select('type', $package_type, ($package->type ?? null) == $package_type) ?>>
                                                    <?= translate($package_type) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                    <span class="error"><?= form_error('type'); ?></span>
                                </div>
                            </div>

                            <?php $userID = get_loggedin_user_id(); ?>
                            <div class="form-group <?= form_error('manager_id') ? 'has-error' : null ?>">
                                <label for="manager_id" class="control-label col-sm-3">
                                    <?= translate('Branch'); ?> <span class="required">*</span>
                                </label>
                                <div class="col-sm-6">
                                    <?php if ($userID == 1): ?>
                                        <select class="form-control" data-plugin-selectTwo name="manager_id" id="manager_id" required>
                                            <option><?= translate('Select A Branch') ?></option>
                                            <?php foreach ($employees as $employee): ?>
                                                <option value="<?= $employee->id ?>" <?= set_select('manager_id', $employee->id, ($thisZone->manager_id ?? null) == $employee->id) ?>>
                                                    <?= html_escape($employee->name) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    <?php else: ?>
                                        <input type="hidden" name="manager_id" value="<?= $userID ?>">
                                        <input type="text" class="form-control" value="<?= html_escape($manager_name) ?>" disabled>
                                    <?php endif; ?>
                                    <span class="error"><?= form_error('manager_id'); ?></span>
                                </div>
                            </div>

                            <div class="form-group <?= form_error('product') ? 'has-error' : null ?>">
                                <label for="product" class="control-label col-sm-3">
                                    <?= translate('food_item'); ?> <span class="required">*</span>
                                </label>
                                <div class="col-sm-6">
                                <input type="text" class="form-control" name="food_item" id="food_item"
    value="<?= set_value('food_item'); ?>"
    required
    placeholder="e.g., Chicken Biryani + Salad">
                                    <span class="error"><?= form_error('food_item'); ?></span>
                                </div>
                            </div>

                            <div class="form-group <?= form_error('breakfast_cost') ? 'has-error' : null ?>">
                                <label for="breakfast_cost" class="control-label col-sm-3">
                                    <?= translate('breakfast_cost'); ?> <span class="required">*</span>
                                </label>
                                <div class="col-sm-6">
                                    <input type="number" class="form-control" name="breakfast_cost" id="breakfast_cost"
                                        value="<?= set_value('breakfast_cost', $package->breakfast_cost ?? null) ?>"
                                        step="0.01" min="0.0" required>
                                    <span class="error"><?= form_error('breakfast_cost'); ?></span>
                                </div>
                            </div>

                            <div class="form-group <?= form_error('lunch_cost') ? 'has-error' : null ?>">
                                <label for="lunch_cost" class="control-label col-sm-3">
                                    <?= translate('lunch_price'); ?> <span class="required">*</span>
                                </label>
                                <div class="col-sm-6">
                                    <input type="number" class="form-control" name="lunch_cost" id="lunch_cost"
                                        value="<?= set_value('lunch_cost', $package->lunch_cost ?? null) ?>"
                                        step="0.01" min="0.0" required>
                                    <span class="error"><?= form_error('lunch_cost'); ?></span>
                                </div>
                            </div>

                            <div class="form-group <?= form_error('dinner_cost') ? 'has-error' : null ?>">
                                <label for="dinner_cost" class="control-label col-sm-3">
                                    <?= translate('dinner_price'); ?> <span class="required">*</span>
                                </label>
                                <div class="col-sm-6">
                                    <input type="number" class="form-control" name="dinner_cost" id="dinner_cost"
                                        value="<?= set_value('dinner_cost', $package->dinner_cost ?? null) ?>"
                                        step="0.01" min="0.0" required>
                                    <span class="error"><?= form_error('dinner_cost'); ?></span>
                                </div>
                            </div>

                            <script>
                                function calculateTotalMealPrice() {
                                    const breakfast = parseFloat(document.getElementById('breakfast_cost').value) || 0;
                                    const lunch = parseFloat(document.getElementById('lunch_cost').value) || 0;
                                    const dinner = parseFloat(document.getElementById('dinner_cost').value) || 0;
                                    const total = (breakfast + lunch + dinner).toFixed(2);
                                    document.getElementById('sale_price').value = total;
                                }

                                document.addEventListener('DOMContentLoaded', function() {
                                    document.getElementById('breakfast_cost').addEventListener('input', calculateTotalMealPrice);
                                    document.getElementById('lunch_cost').addEventListener('input', calculateTotalMealPrice);
                                    document.getElementById('dinner_cost').addEventListener('input', calculateTotalMealPrice);
                                    calculateTotalMealPrice();
                                });
                            </script>

                            <div class="form-group <?= form_error('sale_price') ? 'has-error' : null ?>">
                                <label for="sale_price" class="control-label col-sm-3">
                                    <?= translate('total_meal_price'); ?> <span class="required">*</span>
                                </label>
                                <div class="col-sm-6">
                                    <input type="number" class="form-control" name="sale_price" id="sale_price"
                                        value="<?= set_value('sale_price', $package->sale_price ?? null) ?>"
                                        step="0.01" min="0.0" required>
                                    <span class="error"><?= form_error('sale_price'); ?></span>
                                </div>
                            </div>

                            <!-- Submit Button -->
                            <div class="form-group">
                                <div class="col-sm-offset-3 col-sm-6">
                                    <button type="button" id="packageSubmitBtn" class="btn btn-default btn-block">
                                        <i class="fas fa-plus-circle"></i>
                                        <?php if (($action ?? null) == 'edit'): ?>
                                            <?= translate('update') ?>
                                        <?php else: ?>
                                            <?= translate('save') ?>
                                        <?php endif; ?>
                                    </button>
                                </div>
                            </div>

                        </div>

                        <?= form_close(); ?>
                    </div>
                <?php endif; ?>




            <?php endif; ?>
        </div>
    </div>
</section>
<script>
    $(document).ready(function() {
        var isStaffActive = false;
        var isChecked = false;

        $.ajax({
            url: '<?= base_url("package/check_staff_status"); ?>',
            type: 'POST',
            data: {
                id: <?= get_loggedin_user_id(); ?>
            },
            dataType: 'json',
            success: function(res) {
                isChecked = true;
                if (res.status && res.status.toLowerCase() === 'active') {
                    isStaffActive = true;
                } else {
                    $('#packageSubmitBtn').hide();
                    showInactiveModal("You are inactive. You cannot create or update packages.");
                }
            },
            error: function() {
                isChecked = true;
                showInactiveModal("Unable to verify your status.");
                $('#packageSubmitBtn').hide();
            }
        });

        $('#packageSubmitBtn').on('click', function() {
            if (!isChecked) {
                showInactiveModal("Checking your status, please wait...");
                return;
            }

            if (!isStaffActive) {
                showInactiveModal("You are inactive. Cannot submit.");
                return;
            }

            // Submit the form manually here
            $(this).closest('form').submit();
        });
    });

    function showInactiveModal(message) {
        $('#inactiveModalMessage').text(message);
        $('#inactiveModalWrapper').fadeIn();
    }

    function closeInactiveModal() {
        $('#inactiveModalWrapper').fadeOut();
    }
</script>

<div class="inactive-modal-wrapper" id="inactiveModalWrapper" style="display: none; position: fixed; z-index: 99999; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.5);">
    <div class="inactive-modal-content" style="background: #fff0f0; border-left: 6px solid #e74c3c; margin: 120px auto; padding: 25px 20px; border-radius: 10px; width: 90%; max-width: 420px; box-shadow: 0 10px 30px rgba(231,76,60,0.3); position: relative;">
        <span class="inactive-modal-close" onclick="closeInactiveModal()" style="position: absolute; top: 10px; right: 15px; font-size: 20px; color: #e74c3c; cursor: pointer;">&times;</span>
        <p id="inactiveModalMessage" style="margin-top: 30px; font-size: 16px; color: #b30000; text-align: center;"></p>
    </div>
</div>




<script>
    // Get and Set NAS Packages based on NAS
    $(document).ready(function() {
        const nas = $('#nas_id');

        function getSetNasPackage(nas_id) {
            $.ajax({
                url: `<?= base_url('package/ajax_nas_packages') ?>/${nas_id}`,
                method: 'GET',
                dataType: 'json',
                beforeSend: function() {
                    $('#nas_package').html('<option value="">Loading...</option>');
                    // disable the full form
                    $('#create').find('input, select, button').attr('disabled', true);
                },
                success: function(data) {
                    let options = '<option value="">Select NAS Package</option>';
                    const packages = data.packages;

                    for (let i = 0; i < packages.length; i++) {
                        options += `<option value="${packages[i].name}">${packages[i].name}</option>`;
                    }
                    $('#nas_package').html(options);
                    setDefaultNasPackage();

                },
                complete: function() {
                    // enable the full form
                    $('#create').find('input, select, button').attr('disabled', false);
                },
                error: function(jqXHR) {
                    const errorData = JSON.parse(jqXHR.responseText);
                    // Show sweetalert
                    Swal.fire({
                        title: 'Oops...',
                        text: errorData.message,
                    });

                    // remove the options
                    $('#nas_package').html('<option value="">No NAS Package Found</option>');
                }
            });
        }

        function setDefaultNasPackage() {
            // if there is a nas_package in $package set selected nas package
            const nas_package = '<?= $package->nas_package ?? null ?>';
            if (nas_package) {
                $('#nas_package').val(nas_package);
            }

        }

        // if nas.val() not nan or null then getSetNasPackage
        if (nas.val()) {
            getSetNasPackage(nas.val());
        }

        nas.change(function() {
            let nas_id = nas.val();

            // change nas_id to integer
            nas_id = parseInt(nas_id);

            // if nas_id is integer then request
            if (isNaN(nas_id)) {
                $('#nas_package').html('<option value="">No NAS Package Found</option>');
            } else {
                getSetNasPackage(nas_id);
            }
        });
    });
</script>