<div class="row">
    <?php if (get_permission('olt', 'is_add')) { ?>
        <div class="col-md-5">
            <section class="panel">
                <header class="panel-heading">
                    <h4 class="panel-title">
                        <i class="far fa-edit"></i>
                        <?php if (($action ?? null) == 'edit'): ?>
                            <?= translate('Edit Sub Branch') ?>
                        <?php else: ?>
                            <?= translate('Add Sub Branch') ?>
                        <?php endif; ?>
                    </h4>
                </header>
                <?= form_open($this->uri->uri_string()); ?>
                <div class="panel-body">

                    <div class="form-group mb-md">
                        <label for="name" class="control-label">
                            <?= translate('Name') ?>
                            <span class="required">*</span>
                        </label>
                        <input type="text" class="form-control <?= form_error('name') ? 'has-error' : null ?>"
                            name="name" id="name" value="<?= set_value('name', $thisOlt->name ?? null) ?>" required />
                        <span class="error"><?= form_error('name') ?></span>
                    </div>
             

                    <div class="form-group mb-md <?= form_error('manager_id') ? 'has-error' : null ?>">
                        <label for="manager_id" class="control-label">
                            <?= translate('Assign To') ?>
                            <span class="required">*</span>
                        </label>
                        <select class="form-control"
                            data-plugin-selectTwo
                            name="manager_id"
                            id="manager_id"
                            required
                            <?= ($action ?? null) == 'edit' ? 'disabled' : '' ?>>
                            <?php if (empty($employees)): ?>
                                <option><?= translate('No Admin Found'); ?></option>
                            <?php else: ?>
                                <option><?= translate('Select An Admin') ?></option>
                                <?php foreach ($employees as $employee): ?>
                                    <option value="<?= $employee->id ?>"
                                        <?= set_select('manager_id', $employee->id, ($thisZone->manager_id ?? null) == $employee->id) ?>>
                                        <?= html_escape($employee->name) ?> (<?= html_escape($employee->role_name) ?>)
                                    </option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                        <span class="error"><?= form_error('manager_id') ?></span>
                    </div>


                </div>
                <div class="panel-footer">
                    <div class="row">
                        <div class="col-md-12">
                            <button class="btn btn-default pull-right" type="submit">
                                <i class="fas fa-plus-circle"></i>
                                <?php if (($action ?? null) == 'edit'): ?>
                                    <?= translate('Update') ?>
                                <?php else: ?>
                                    <?= translate('Save') ?>
                                <?php endif; ?>
                            </button>
                        </div>
                    </div>
                </div>
                <?= form_close(); ?>
            </section>
        </div>
    <?php } ?>
    <div <?php if (get_permission('olt', 'is_add')) { ?> class="col-md-7" <?php } else { ?> class="col-md-12" <?php } ?>>
        <section class="panel">
            <header class="panel-heading">
                <h4 class="panel-title"><i class="fas fa-list-ul"></i> <?= translate('Sub Branch List'); ?>
                </h4>
            </header>
            <div class="panel-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover table-condensed mb-none">
                        <thead>
                            <tr>
                                <th><?= translate('ID') ?></th>
                                <th><?= translate('Name') ?></th>
                               
                                <th><?= translate('Sub Manager') ?></th>
                                <th><?= translate('Action') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($olts)) : ?>
                                <?php foreach ($olts as $index => $olt): ?>
                                    <tr>
                                        <td><?= $olt->id ?></td>
                                        <td><?= html_escape($olt->name) ?></td>
                                      
                                        <td><?= html_escape($olt->manager_name) ?></td>
                                        <td>
                                            <?php if ($olt->editable): ?>
                                                <?php if (get_permission('olt', 'is_edit')) { ?>
                                                    <a href="<?= base_url('olt/edit/' . $olt->id); ?>"
                                                        class="btn btn-circle icon btn-default" data-toggle="tooltip"
                                                        data-original-title="<?= translate('edit') ?>">
                                                        <i class="fas fa-pen-nib"></i>
                                                    </a>
                                                <?php } ?>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="6">
                                        <h5 class="text-danger text-center"><?= translate('no_information_available.') ?></h5>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
    </div>
</div>