<?php $currency_symbol = $global_config['currency_symbol']; ?>

<?php
// Step 1: Collect all unique selected_dates from $naslist
$all_dates = [];
foreach ($naslist as $row) {
    if (!empty($row['selected_dates'])) {
        $dates = explode(',', $row['selected_dates']);
        foreach ($dates as $d) {
            $trimmed = trim($d);
            if (!in_array($trimmed, $all_dates)) {
                $all_dates[] = $trimmed;
            }
        }
    }
}
sort($all_dates); // sort dates ascending
?>

<section class="panel">
    <header class="panel-heading">
        <div class="row">
            <div class="col-md-8">
                <h4 class="panel-title"><i class="fas fa-list-ul"></i> <?php echo translate('Branch Booking') . " " . translate('list'); ?></h4>
            </div>
        </div>
    </header>
    <div class="panel-body">
        <div class="export_title"><?php echo translate('Booking') . " " . translate('list'); ?></div>
        <table class="table table-bordered table-hover table-condensed" cellspacing="0" width="100%" id="table-export">
            <thead style="background: linear-gradient(90deg, #e0f7fa, #f1f8e9); box-shadow: 0 2px 5px rgba(0,0,0,0.1);">
                <tr style="font-weight: bold; font-size: 14px; color: #333;">
                    <th style="background-color: #f5f5f5; color: #5956ea;text-align: center;">User ID</th>
                    <th style="background-color: #f5f5f5; color: #5956ea;text-align: center;"><?php echo translate('Client name'); ?></th>
                    <th style="background-color: #f5f5f5; color: #5956ea;text-align: center;"><?php echo translate('Client ID'); ?></th>
                


                    <?php foreach ($all_dates as $date): ?>
                        <th colspan="3" style="
                text-align: center; 
                background-color: #e8fdf0; 
                color: #388e3c; 
                border-left: 1px solid #c8e6c9;
                border-right: 1px solid #c8e6c9;
            ">
                            <?php echo date('d-M-Y', strtotime($date)); ?>
                        </th>
                    <?php endforeach; ?>

                    <th style="background-color: #fff3e0; color: #ef6c00; text-align: center;"><?php echo translate('total_breakfast'); ?></th>
                    <th style="background-color: #fff3e0; color: #ef6c00; text-align: center;"><?php echo translate('total_lunch'); ?></th>
                    <th style="background-color: #fff3e0; color: #ef6c00; text-align: center;"><?php echo translate('total_dinner'); ?></th>
                    <th style="background-color: #ede7f6; color: #5e35b1; text-align: center;"><?php echo translate('total_meal '); ?></th>
                    <th style="background-color: #fce4ec; color: #c2185b; text-align: center;"><?php echo translate('total_meal cost'); ?></th>

                    <!-- <th style="background-color: #e1f5fe; color: #0288d1;"><?php echo translate('Payment Status'); ?></th> -->
                    <th style="background-color: #f5f5f5; color: #5956ea;text-align: center;"><?php echo translate('Branch Name'); ?></th>
                    <th style="background-color: #f5f5f5; color: #5956ea;text-align: center;"><?php echo translate('Branch ID'); ?></th>
                </tr>

                <tr style="font-size: 13px;">
                    <th colspan="3" style="background-color: #fafafa;"></th>

                    <?php
                    // Grand total row
                    $grand_total_breakfast = 0;
                    $grand_total_lunch = 0;
                    $grand_total_dinner = 0;
                    $grand_total_meal = 0;
                    $grand_total_cost = 0;

                    foreach ($naslist as $row) {
                        $grand_total_breakfast += (int) $row['selected_total_breakfast'];
                        $grand_total_lunch += (int) $row['selected_total_lunch'];
                        $grand_total_dinner += (int) $row['selected_total_dinner'];
                        $grand_total_meal += (int) $row['total_meal_count'];
                        $grand_total_cost += (float) $row['total_amount'];
                    }

                    $staticCols = 3;
                    $mealCols = count($all_dates) * 3;
                    ?>
                    <?php foreach ($all_dates as $date): ?>
                        <?php
                        // Grand total row

                        $formatted_date = date('Y-m-d', strtotime($date));
                        $breakfastCount = $mealCounts['breakfast'][$formatted_date] ?? 0;
                        $lunchCount     = $mealCounts['lunch'][$formatted_date] ?? 0;
                        $dinnerCount    = $mealCounts['dinner'][$formatted_date] ?? 0;
                        ?>
                        <th style="text-align: center; background-color: #ffffff; color:rgb(20, 164, 231);">
                            <?= translate('Breakfast'); ?> (<?= $breakfastCount; ?>)
                        </th>
                        <th style="text-align: center; background-color: #ffffff; color:rgb(181, 32, 208);">
                            <?= translate('Lunch'); ?> (<?= $lunchCount; ?>)
                        </th>
                        <th style="text-align: center; background-color: #ffffff; color:rgb(201, 125, 10);">
                            <?= translate('Dinner'); ?> (<?= $dinnerCount; ?>)
                        </th>

                    <?php endforeach; ?>
                    <th style="text-align: center; background-color: #fff8e1; color: #ef6c00;">
                        <?= translate('total'); ?> (<?= $grand_total_breakfast; ?>)
                    </th>
                    <th style="text-align: center; background-color: #fff8e1; color: #ef6c00;">
                        <?= translate('total'); ?> (<?= $grand_total_lunch; ?>)
                    </th>
                    <th style="text-align: center; background-color: #fff8e1; color: #ef6c00;">
                        <?= translate('total'); ?> (<?= $grand_total_dinner; ?>)
                    </th>
                    <th style="text-align: center; background-color: #ede7f6; color:#5e35b1;">
                        <?= translate('total'); ?> (<?= $grand_total_meal; ?>)
                    </th>
                    <th style="text-align: center; background-color: #fce4ec; color:#c2185b;">
                        <?= translate('total'); ?> (<?= $grand_total_cost; ?>)
                    </th>
                    <th colspan="6" style="background-color: #fafafa;"></th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($naslist)) {
                    foreach ($naslist as $row): ?>
                        <tr>
                            <td style="color: blue;"><?php echo html_escape($row['id']); ?></td>
                            <td><?php echo html_escape($row['student_name']); ?></td>
                            <td><?php echo html_escape($row['idd']); ?></td>
               

                            <?php
                            foreach ($all_dates as $date) {
                                $meals = isset($row['meals'][$date]) ? $row['meals'][$date] : [
                                    'breakfast' => [],
                                    'lunch' => [],
                                    'dinner' => [],
                                ];

                                // Display breakfast packages or empty
                                $breakfast_display = !empty($meals['breakfast'])
                                    ? '<div style="text-align: center; color: green;">' . implode(', ', array_map('html_escape', $meals['breakfast'])) . '</div>'
                                    : '<div style="text-align: center;">-</div>';

                                // Display lunch packages or empty
                                $lunch_display = !empty($meals['lunch'])
                                    ? '<div style="text-align: center; color: orange;">' . implode(', ', array_map('html_escape', $meals['lunch'])) . '</div>'
                                    : '<div style="text-align: center;">-</div>';

                                // Display dinner packages or empty
                                $dinner_display = !empty($meals['dinner'])
                                    ? '<div style="text-align: center; color: red;">' . implode(', ', array_map('html_escape', $meals['dinner'])) . '</div>'
                                    : '<div style="text-align: center;">-</div>';

                                echo "<td>$breakfast_display</td>";
                                echo "<td>$lunch_display</td>";
                                echo "<td>$dinner_display</td>";
                            }
                            ?>
                            <td style="text-align: center;"><?php echo html_escape($row['selected_total_breakfast']); ?></td>
                            <td style="text-align: center;"><?php echo html_escape($row['selected_total_lunch']); ?></td>
                            <td style="text-align: center;"><?php echo html_escape($row['selected_total_dinner']); ?></td>
                            <td style="text-align: center;"><?php echo html_escape($row['total_meal_count']); ?></td>
                            <td style="text-align: center;"><?php echo html_escape($row['total_amount']); ?></td>
                            <td><?php echo html_escape($row['branch_name']); ?></td>
                            <td><?php echo html_escape($row['branch_merchant_no']); ?></td>
                        </tr>
                <?php endforeach;
                } ?>
            </tbody>



        </table>

    </div>
</section>