<div class="row">
    <div class="col-md-12">
        <section class="panel">
            <?php echo form_open_multipart($this->uri->uri_string()); ?>
            <div class="panel-heading">
                <h4 class="panel-title">
                    <i class="fas fa-utensils" style="color: #0643b4;"></i> <?php echo translate('Meal Summary'); ?>
                </h4>
            </div>
            <div class="panel-body">
                <div class="row">
                    <div class="col-sm-4 mb-sm">
                        <div class="form-group">
                            <label for="selectMonth">Select Month:</label>
                            <select id="selectMonth" class="form-control">
                                <?php
                                $currentMonth = isset($_GET['month']) ? $_GET['month'] : date('m');
                                $currentYear = isset($_GET['year']) ? $_GET['year'] : date('Y');
                                $startMonth = date('m');
                                $startYear = date('Y');

                                for ($i = 0; $i < 2; $i++) {
                                    $monthValue = date('m', strtotime("+$i month", strtotime("$startYear-$startMonth-01")));
                                    $monthText = date('F', strtotime("+$i month", strtotime("$startYear-$startMonth-01")));

                                    if ($monthValue >= $startMonth) {
                                        echo "<option value='$monthValue' " . ($monthValue == $currentMonth ? 'selected' : '') . ">$monthText</option>";
                                    }
                                }
                                ?>
                            </select>
                        </div>
                    </div>

                    <div class="col-sm-4 mb-sm">
                        <div class="form-group">
                            <label for="selectYear">Select Year:</label>
                            <select id="selectYear" class="form-control">
                                <?php
                                for ($i = 0; $i < 1; $i++) {
                                    $yearValue = date('Y') + $i;
                                    echo "<option value='$yearValue' " . ($yearValue == $currentYear ? 'selected' : '') . ">$yearValue</option>";
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-4 mb-sm">
                        <div class="form-group">
                            <label for="package_id" class="control-label">
                                <?= translate('Package') ?>
                                <span class="required">*</span>
                            </label>
                            <select name="package_id" id="package_id" class="form-control" data-plugin-selectTwo
                                data-width="100%" data-minimum-results-for-search="Infinity"
                                onchange="updatePackageName()">
                                <option value=""><?= translate('Select') ?></option>
                                <?php if (!empty($packages)): ?>
                                    <?php foreach ($packages as $package): ?>
                                        <option value="<?= $package->id ?>"
                                            data-breakfast="<?= $package->breakfast_cost ?>"
                                            data-lunch="<?= $package->lunch_cost ?>"
                                            data-dinner="<?= $package->dinner_cost ?>"
                                            data-name="<?= $package->name ?>">
                                            <?= $package->name ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                            <input type="hidden" name="package_name" id="package_name">
                        </div>
                    </div>

                    <?php
                    $CI = &get_instance();
                    $userID = get_loggedin_user_id();

                    $staff = $CI->db->select('idd, name,user_balance, created_by')->where('id', $userID)->get('staff')->row();

                    if (!empty($staff)) {
                        $idd = $staff->idd;
                        $student_name = $staff->name;
                        $created_by = $staff->created_by;

                        // Get manager username
                        $manager = $CI->db->select('username')->where('user_id', $created_by)->get('login_credential')->row();
                        $manager_name = $manager->username ?? 'N/A';
                    ?>

                        <div class="col-sm-4 mb-sm">
                            <label for="idd" class="form-label">Client ID</label>
                            <input type="text" id="idd" name="idd" class="form-control" value="<?= $idd ?>" readonly>
                        </div>

                        <div class="col-sm-4 mb-sm">
                            <label for="student_name" class="form-label">Client Name</label>
                            <input type="text" id="student_name" name="student_name" class="form-control" value="<?= $student_name ?>" readonly>
                        </div>

                        <div class="col-sm-4 mb-sm">
                            <label for="manager_name" class="form-label">Branch Name</label>
                            <input type="text" id="manager_name" name="manager_name" class="form-control" value="<?= $manager_name ?>" readonly>
                        </div>


                    <?php
                    } else {
                        echo '<div class="alert alert-danger">Login data not found or staff data missing.</div>';
                    }
                    ?>
                    <script>
                        function updatePackageName() {
                            const select = document.getElementById('package_id');
                            const selectedOption = select.options[select.selectedIndex];
                            const packageName = selectedOption.getAttribute('data-name') || '';
                            document.getElementById('package_name').value = packageName;
                        }
                    </script>

                    <div class="col-md-4 mb-sm">
                        <div class="form-group">
                            <label for="breakfast_cost" class="control-label">
                                <?= translate('Breakfast Cost') ?>
                            </label>
                            <input type="text" name="breakfast_cost" id="breakfast_cost" class="form-control" value="" readonly>
                        </div>
                    </div>

                    <div class="col-md-4 mb-sm">
                        <div class="form-group">
                            <label for="lunch_cost" class="control-label">
                                <?= translate('Lunch Cost') ?>
                            </label>
                            <input type="text" name="lunch_cost" id="lunch_cost" class="form-control" value="" readonly>
                        </div>
                    </div>

                    <div class="col-md-4 mb-sm">
                        <div class="form-group">
                            <label for="dinner_cost" class="control-label">
                                <?= translate('Dinner Cost') ?>
                            </label>
                            <input type="text" name="dinner_cost" id="dinner_cost" class="form-control" value="" readonly>
                        </div>
                    </div>
                    <script>
                        $(document).ready(function() {
                            $('#package_id').change(function() {
                                var packageId = $(this).val();

                                if (packageId) {
                                    $.ajax({
                                        url: "<?= base_url('nas/get_package_details') ?>",
                                        type: "POST",
                                        data: {
                                            package_id: packageId
                                        },
                                        dataType: "json",
                                        success: function(response) {
                                            if (response.status) {
                                                $('#breakfast_cost').val(response.breakfast_cost);
                                                $('#lunch_cost').val(response.lunch_cost);
                                                $('#dinner_cost').val(response.dinner_cost);
                                            } else {
                                                $('#breakfast_cost').val('');
                                                $('#lunch_cost').val('');
                                                $('#dinner_cost').val('');
                                            }
                                        }
                                    });
                                } else {
                                    $('#breakfast_cost').val('');
                                    $('#lunch_cost').val('');
                                    $('#dinner_cost').val('');
                                }
                            });
                        });
                    </script>
                </div>
                <div class="panel-body" style="background-color: rgb(222 ,245, 255); padding: 25px; border-radius: 15px; margin-top: 20px; box-shadow: 0 4px 8px rgba(89, 67, 211, 0.2);">
                    <h4 style="color: rgb(0, 74, 186); text-align: center; font-family: 'Arial', sans-serif; font-size: 24px;">Meal Summary</h4>

                    <div class="row" style="margin-top: 20px;">
                        <div class="col-md-3 mb-sm">
                            <div class="form-group" style="background-color: rgb(255, 255, 255); padding: 15px; border-radius: 10px; box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);">
                                <label style="color: rgb(45, 45, 45); font-weight: bold;">Total Breakfast</label>
                                <input type="number" class="form-control" id="total_breakfast" name="total_breakfast" readonly value="0" style="background-color: rgb(224, 238, 255); border: 1px solid rgb(144, 225, 238);">
                            </div>
                        </div>

                        <div class="col-md-3 mb-sm">
                            <div class="form-group" style="background-color: rgb(255, 255, 255); padding: 15px; border-radius: 10px; box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);">
                                <label style="color: rgb(45, 45, 45); font-weight: bold;">Total Lunch</label>
                                <input type="number" class="form-control" id="total_lunch" name="total_lunch" readonly value="0" style="background-color: rgb(224, 238, 255); border: 1px solid rgb(144, 225, 238);">
                            </div>
                        </div>

                        <div class="col-md-3 mb-sm">
                            <div class="form-group" style="background-color: rgb(255, 255, 255); padding: 15px; border-radius: 10px; box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);">
                                <label style="color: rgb(45, 45, 45); font-weight: bold;">Total Dinner</label>
                                <input type="number" class="form-control" id="total_dinner" name="total_dinner" readonly value="0" style="background-color: rgb(224, 238, 255); border: 1px solid rgb(144, 225, 238);">
                            </div>
                        </div>

                        <div class="col-md-3 mb-sm">
                            <div class="form-group" style="background-color: rgb(255, 255, 255); padding: 15px; border-radius: 10px; box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);">
                                <label style="color: rgb(45, 45, 45); font-weight: bold;">Total Amount</label>
                                <input type="number" class="form-control" id="total_amount" name="total_amount" readonly value="0" style="background-color: rgb(224, 238, 255); border: 1px solid rgb(144, 225, 238);">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="panel-body" style="background-color:rgb(222 ,245, 255) padding: 20px; border-radius: 15px; margin-top: 20px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);">
                    <h4 style="color:rgb(0, 74, 186); text-align: center; font-family: 'Arial', sans-serif; font-size: 24px;">Meal Selection</h4>
                    <table class="table table-bordered text-center" style="background-color: white; border-radius: 10px;">
                        <thead style="background-color: rgb(233, 250, 255); color: black;">
                            <tr>
                                <th class="text-center" style="width: 80px; background-color: rgb(207 139 255); color: white; ">Day</th>
                                <th class="text-center" style="width: 100px; background-color: rgb(0 130 154); color: white; ">Date</th>
                                <th class="text-center" style="background-color: rgb(60, 179, 64); color: white; ">Breakfast <br>
                                    <input type="checkbox" id="select_all_breakfast">
                                    <label for="select_all_breakfast" style="color: white;">Select All</label>
                                </th>
                                <th class="text-center" style="background-color: rgb(135, 206, 235); color: white; ">Lunch <br>
                                    <input type="checkbox" id="select_all_lunch">
                                    <label for="select_all_lunch" style="color: white;">Select All</label>
                                </th>
                                <th class="text-center" style="background-color: rgb(255, 105, 180); color: white; ">Dinner <br>
                                    <input type="checkbox" id="select_all_dinner">
                                    <label for="select_all_dinner" style="color: white;">Select All</label>
                                </th>

                            </tr>
                        </thead>
                        <tbody id="dateRows">
                            <?php
                            $govHolidays = ['2025-03-26'];

                            $selectedMonth = isset($_GET['month']) ? $_GET['month'] : date('m');
                            $selectedYear = isset($_GET['year']) ? $_GET['year'] : date('Y');

                            $today = date('Y-m-d');
                            $todayDay = date('d');
                            $selectedDay = isset($_GET['day']) ? $_GET['day'] : 1;
                            $isCurrentMonth = ($selectedYear == date('Y') && $selectedMonth == date('m'));
                            if ($isCurrentMonth && $selectedDay <= $todayDay) {
                                // Prevent showing next month if today is the last day
                                $lastDayOfMonth = cal_days_in_month(CAL_GREGORIAN, $selectedMonth, $selectedYear);
                                if ($todayDay == $lastDayOfMonth) {
                                    $remainingDays = []; // no days left to show
                                } else {
                                    $remainingDays = range($todayDay + 1, $lastDayOfMonth);
                                }
                            } else {
                                $remainingDays = range(1, cal_days_in_month(CAL_GREGORIAN, $selectedMonth, $selectedYear));
                            }


                            foreach ($remainingDays as $day) {
                                $date = "$selectedYear-$selectedMonth-" . str_pad($day, 2, "0", STR_PAD_LEFT);
                                $dayName = date('l', strtotime($date));
                                $formattedDate = date('d/m/Y', strtotime($date));

                                $isGovHoliday = in_array($date, $govHolidays);
                                $rowStyle = $isGovHoliday ? 'background-color: #F0E68C;' : '';

                                $dayStyle = ($dayName == 'Friday' || $dayName == 'Saturday')
                                    ? "background-color: rgb(242, 36, 36); color: white;"
                                    : "background-color:rgb(207 139 255); color: white;";

                                $dateStyle = ($dayName == 'Friday' || $dayName == 'Saturday')
                                    ? "background-color: rgb(242, 36, 36); color: white;"
                                    : "background-color:rgb(0 130 154); color: white;";
                                echo "<tr style='$rowStyle'>
                                    <td style='$dayStyle'>$dayName</td>
                                    <td style='$dateStyle'>$formattedDate</td>
                                    <td><input type='checkbox' class='meal-checkbox breakfast' data-day='$date'></td>
                                    <td><input type='checkbox' class='meal-checkbox lunch' data-day='$date'></td>
                                    <td><input type='checkbox' class='meal-checkbox dinner' data-day='$date'></td>
                                </tr>";
                            }
                            ?>
                        </tbody>

                    </table>

                </div>


            </div>
        </section>
    </div>

    <input type="hidden" name="selected_dates" id="selectedDatesInput">
    <input type="hidden" name="selected_breakfast" id="selectedBreakfastInput">
    <input type="hidden" name="selected_lunch" id="selectedLunchInput">
    <input type="hidden" name="selected_dinner" id="selectedDinnerInput">

    <!-- This wrapper will be hidden -->
    <div id="mealSelectionSection" style="display: none;">
        <div class="col-md-3 mb-sm">
            <div class="form-group">
                <label>Selected Dates</label>
                <div id="selectedDates" style="min-height: 30px;"></div>
            </div>
        </div>

        <div class="col-md-3 mb-sm">
            <div class="form-group">
                <label>Selected Breakfast</label>
                <div id="selectedBreakfast" style="min-height: 30px;"></div>
            </div>
        </div>


        <div class="col-md-3 mb-sm">
            <div class="form-group">
                <label>Selected Lunch</label>
                <div id="selectedLunch" style="min-height: 30px;"></div>
            </div>
        </div>

        <div class="col-md-3 mb-sm">
            <div class="form-group">
                <label>Selected Dinner</label>
                <div id="selectedDinner" style="min-height: 30px;"></div>
            </div>
        </div>
    </div>
    <input type="hidden" id="user_balance" value="<?= $staff->user_balance ?>">
    <input type="hidden" id="check_meal_ordered_url" value="<?= base_url('nas/check_meal_ordered') ?>">

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const selectedDatesDiv = document.getElementById("selectedDates");
            const selectedBreakfastDiv = document.getElementById("selectedBreakfast");
            const selectedLunchDiv = document.getElementById("selectedLunch");
            const selectedDinnerDiv = document.getElementById("selectedDinner");

            const checkMealOrderedUrl = document.getElementById('check_meal_ordered_url').value;

            async function checkAllMeals() {
                const allCheckboxes = document.querySelectorAll('.meal-checkbox');

                for (const checkbox of allCheckboxes) {
                    const date = checkbox.getAttribute('data-day');
                    const meal = checkbox.classList.contains('breakfast') ? 'Breakfast' :
                        checkbox.classList.contains('lunch') ? 'Lunch' :
                        'Dinner';

                    const response = await fetch(checkMealOrderedUrl, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({
                            date: date,
                            meal: meal
                        })
                    });

                    const result = await response.json();

                    // If the meal has already been ordered
                    if (result.status === false) {
                        checkbox.disabled = true;
                        if (result.status === false) {
                            checkbox.style.display = 'none'; // hide checkbox completely

                            if (!checkbox.nextElementSibling || !checkbox.nextElementSibling.classList.contains('ordered-cross')) {
                                const cross = document.createElement('span');
                                cross.textContent = "✅"; // Green check
                                cross.style.color = "green";
                                cross.classList.add('ordered-cross');
                                checkbox.insertAdjacentElement('afterend', cross); // Insert check after checkbox
                            }

                            checkbox.parentElement.title = "Already Booked";
                        }


                    } else {
                        // If the meal isn't ordered yet, ensure the checkmark isn't there
                        const existingCheck = checkbox.nextElementSibling;
                        if (existingCheck && existingCheck.classList.contains('ordered-cross')) {
                            existingCheck.remove();
                        }
                    }
                }
            }

            // Initial check on page load
            checkAllMeals();

            // Meal checkbox change event listener
            document.querySelectorAll(".meal-checkbox").forEach(mealCheckbox => {
                mealCheckbox.addEventListener("change", function() {
                    const fullDate = this.getAttribute("data-day");
                    const mealType = this.classList.contains("breakfast") ? "Breakfast" :
                        this.classList.contains("lunch") ? "Lunch" :
                        "Dinner";

                    const mealDiv = mealType === "Breakfast" ? selectedBreakfastDiv :
                        mealType === "Lunch" ? selectedLunchDiv :
                        selectedDinnerDiv;

                    // Handle checkbox state
                    if (this.checked) {
                        const newDiv = document.createElement("div");
                        newDiv.classList.add("selected-meal-item");
                        newDiv.textContent = `${fullDate} - ${mealType}`;
                        newDiv.setAttribute("data-day", fullDate);
                        newDiv.setAttribute("data-meal", mealType);
                        mealDiv.appendChild(newDiv);
                    } else {
                        document.querySelector(`.selected-meal-item[data-day='${fullDate}'][data-meal='${mealType}']`)?.remove();
                    }

                    // Update selected dates div
                    updateSelectedDatesDiv();
                });
            });

            // Update selected dates div
            function updateSelectedDatesDiv() {
                const allCheckedMeals = document.querySelectorAll('.meal-checkbox:checked');
                const selectedDates = Array.from(new Set(Array.from(allCheckedMeals).map(cb => cb.getAttribute('data-day'))));

                selectedDatesDiv.innerHTML = '';
                selectedDates.forEach(date => {
                    const newDiv = document.createElement("div");
                    newDiv.classList.add("selected-date-item");
                    newDiv.textContent = date;
                    newDiv.setAttribute("data-day", date);
                    selectedDatesDiv.appendChild(newDiv);
                });
            }

            // Form submit event
            document.querySelector('form').addEventListener('submit', function(e) {
                e.preventDefault();

                const form = this;
                const totalAmount = parseFloat(document.getElementById('total_amount').value) || 0;
                const userBalance = parseFloat(document.getElementById('user_balance').value) || 0;

                if (totalAmount > userBalance) {
                    showPopup("Sorry, you don't have enough balance.");
                    return;
                }

                const selectedItems = document.querySelectorAll('.selected-meal-item');
                const selectedMeals = Array.from(selectedItems).map(item => ({
                    date: item.getAttribute('data-day'),
                    meal: item.getAttribute('data-meal')
                }));

                if (selectedMeals.length === 0) {
                    showPopup("Please select at least one meal.");
                    return;
                }

                async function checkBeforeSubmit() {
                    let alreadyOrdered = [];

                    const groupedMeals = {};
                    selectedMeals.forEach(item => {
                        if (!groupedMeals[item.date]) {
                            groupedMeals[item.date] = {
                                breakfast: 0,
                                lunch: 0,
                                dinner: 0
                            };
                        }
                        if (item.meal === 'Breakfast') groupedMeals[item.date].breakfast = 1;
                        if (item.meal === 'Lunch') groupedMeals[item.date].lunch = 1;
                        if (item.meal === 'Dinner') groupedMeals[item.date].dinner = 1;
                    });

                    for (const item of selectedMeals) {
                        const response = await fetch(checkMealOrderedUrl, {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            body: JSON.stringify({
                                date: item.date,
                                meal: item.meal
                            })
                        });

                        const result = await response.json();
                        if (result.status === false) {
                            alreadyOrdered.push(`${item.date} - ${item.meal}`);
                        }
                    }

                    if (alreadyOrdered.length > 0) {
                        showPopup("Already ordered meals:\n\n" + alreadyOrdered.join("\n"));
                        return;
                    }

                    for (const [date, meals] of Object.entries(groupedMeals)) {
                        const formData = new FormData(form);
                        formData.set('selected_dates', date);
                        formData.set('selected_breakfast', meals.breakfast ? 1 : '');
                        formData.set('selected_lunch', meals.lunch ? 1 : '');
                        formData.set('selected_dinner', meals.dinner ? 1 : '');

                        await fetch(form.action, {
                                method: form.method,
                                body: formData
                            })
                            .then(response => response.text())
                            .then(result => {
                                console.log(`Submitted for ${date}:`, result);
                            })
                            .catch(error => {
                                console.error(`Error submitting for ${date}:`, error);
                            });
                    }

                    setTimeout(() => {
                        window.location.href = "<?= base_url('nas/index'); ?>";
                    }, 300);
                }

                checkBeforeSubmit();
            });

            function showPopup(message) {
                const modal = document.getElementById("popupModal");
                const messageEl = document.getElementById("modalMessage");
                const closeBtn = document.querySelector("#popupModal .close");

                messageEl.textContent = message;
                modal.style.display = "block";

                closeBtn.onclick = () => modal.style.display = "none";
                window.onclick = event => {
                    if (event.target === modal) modal.style.display = "none";
                };
            }


        });
    </script>
    <!-- Add hidden field to track submitted meals -->
    <input type="hidden" id="submitted_meals" value="[]">

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const selectedDatesDiv = document.getElementById("selectedDates");
            const submittedMealsInput = document.getElementById("submitted_meals");

            // Parse previously submitted meals into a Set for quick lookup
            let submittedMeals = new Set(JSON.parse(submittedMealsInput.value));

            // Modify updateSelectedDatesDiv to only show new (non-submitted) dates
            function updateSelectedDatesDiv() {
                const allCheckedMeals = document.querySelectorAll('.meal-checkbox:checked');
                const selectedDates = Array.from(new Set(Array.from(allCheckedMeals)
                    .map(cb => cb.getAttribute('data-day'))
                    .filter(date => {
                        // Check if any of the meals for this date are not submitted
                        return ['Breakfast', 'Lunch', 'Dinner'].some(meal => {
                            return !submittedMeals.has(`${date}-${meal}`);
                        });
                    })
                ));

                selectedDatesDiv.innerHTML = '';
                selectedDates.forEach(date => {
                    const newDiv = document.createElement("div");
                    newDiv.classList.add("selected-date-item");
                    newDiv.textContent = date;
                    newDiv.setAttribute("data-day", date);
                    selectedDatesDiv.appendChild(newDiv);
                });
            }

            // Modify prepareMealData to only submit new (non-submitted) meals
            function prepareMealData() {
                const allCheckedMeals = document.querySelectorAll('.meal-checkbox:checked');
                const mealData = [];
                const totalAmount = document.getElementById('total_amount').value;

                allCheckedMeals.forEach(checkbox => {
                    const date = checkbox.getAttribute('data-day');
                    const mealType = checkbox.classList.contains('breakfast') ? 'Breakfast' :
                        checkbox.classList.contains('lunch') ? 'Lunch' : 'Dinner';

                    const key = `${date}-${mealType}`;
                    if (!submittedMeals.has(key)) {
                        const mealCost = mealType === 'Breakfast' ? parseFloat(document.getElementById('breakfast_cost').value) :
                            mealType === 'Lunch' ? parseFloat(document.getElementById('lunch_cost').value) :
                            parseFloat(document.getElementById('dinner_cost').value);

                        mealData.push({
                            date: date,
                            mealType: mealType,
                            mealCost: mealCost
                        });
                    }
                });

                if (mealData.length === 0) {
                    alert('No new meal selections to submit.');
                    return;
                }

                // Send to server
                $.ajax({
                    url: 'nas/add',
                    type: 'POST',
                    data: {
                        mealData: JSON.stringify(mealData),
                        totalAmount: totalAmount
                    },
                    success: function(response) {
                        if (response.success) {
                            alert('Meal booking saved successfully!');

                            // Update submitted meals set and hidden input
                            mealData.forEach(item => {
                                const key = `${item.date}-${item.mealType}`;
                                submittedMeals.add(key);
                            });
                            submittedMealsInput.value = JSON.stringify(Array.from(submittedMeals));
                            updateSelectedDatesDiv();
                        } else {
                            alert('Error: ' + response.error);
                        }
                    },
                    error: function(error) {
                        alert('There was an error with the request: ' + error);
                    }
                });
            }

            document.getElementById('submit').addEventListener('click', prepareMealData);
        });
    </script>


    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const selectedDatesDiv = document.getElementById("selectedDates");
            const selectedBreakfastDiv = document.getElementById("selectedBreakfast");
            const selectedLunchDiv = document.getElementById("selectedLunch");
            const selectedDinnerDiv = document.getElementById("selectedDinner");

            const checkboxes = document.querySelectorAll('.meal-checkbox');

            checkboxes.forEach(checkbox => {
                checkbox.addEventListener('change', function() {
                    updateMealTotals();
                    updateMealSelection(this);
                });
            });

            function updateMealSelection(checkbox) {
                const fullDate = checkbox.getAttribute("data-day");
                const mealType = checkbox.classList.contains("breakfast") ? "Breakfast" :
                    checkbox.classList.contains("lunch") ? "Lunch" : "Dinner";

                const mealDiv = mealType === "Breakfast" ? selectedBreakfastDiv :
                    mealType === "Lunch" ? selectedLunchDiv : selectedDinnerDiv;

                if (checkbox.checked) {
                    if (!document.querySelector(`.selected-meal-item[data-day='${fullDate}'][data-meal='${mealType}']`)) {
                        const newDiv = document.createElement("div");
                        newDiv.classList.add("selected-meal-item");
                        newDiv.textContent = `${fullDate} - ${mealType}`;
                        newDiv.setAttribute("data-day", fullDate);
                        newDiv.setAttribute("data-meal", mealType);
                        mealDiv.appendChild(newDiv);
                    }
                } else {
                    document.querySelector(`.selected-meal-item[data-day='${fullDate}'][data-meal='${mealType}']`)?.remove();
                }

                updateSelectedDatesDiv();
            }

            function updateSelectedDatesDiv() {
                const allCheckedMeals = document.querySelectorAll('.meal-checkbox:checked');
                const selectedDates = Array.from(new Set(Array.from(allCheckedMeals).map(cb => cb.getAttribute('data-day'))));

                selectedDatesDiv.innerHTML = '';
                selectedDates.forEach(date => {
                    const newDiv = document.createElement("div");
                    newDiv.classList.add("selected-date-item");
                    newDiv.textContent = date;
                    newDiv.setAttribute("data-day", date);
                    selectedDatesDiv.appendChild(newDiv);
                });
            }

            function updateMealTotals() {
                const totalBreakfast = Array.from(document.querySelectorAll('.breakfast:checked')).filter(cb => cb.style.display !== 'none').length;
                const totalLunch = Array.from(document.querySelectorAll('.lunch:checked')).filter(cb => cb.style.display !== 'none').length;
                const totalDinner = Array.from(document.querySelectorAll('.dinner:checked')).filter(cb => cb.style.display !== 'none').length;

                const breakfastCost = parseFloat(document.getElementById('breakfast_cost').value) || 0;
                const lunchCost = parseFloat(document.getElementById('lunch_cost').value) || 0;
                const dinnerCost = parseFloat(document.getElementById('dinner_cost').value) || 0;

                document.getElementById('total_breakfast').value = totalBreakfast;
                document.getElementById('total_lunch').value = totalLunch;
                document.getElementById('total_dinner').value = totalDinner;

                const totalAmount = (totalBreakfast * breakfastCost) + (totalLunch * lunchCost) + (totalDinner * dinnerCost);
                document.getElementById('total_amount').value = totalAmount.toFixed(2);
            }

            function toggleSelectAll(mealType, selectAllId) {
                const selectAllCheckbox = document.getElementById(selectAllId);

                selectAllCheckbox.addEventListener('change', function() {
                    const checkboxes = document.querySelectorAll('.' + mealType);
                    checkboxes.forEach(checkbox => {
                        if (checkbox.style.display !== 'none') {
                            checkbox.checked = selectAllCheckbox.checked;
                            updateMealSelection(checkbox);
                        }
                    });
                    updateMealTotals();
                });

                document.querySelectorAll('.' + mealType).forEach(checkbox => {
                    checkbox.addEventListener('change', function() {
                        const visibleCheckboxes = Array.from(document.querySelectorAll('.' + mealType)).filter(cb => cb.style.display !== 'none');
                        const checkedVisible = visibleCheckboxes.filter(cb => cb.checked).length;

                        selectAllCheckbox.checked = checkedVisible === visibleCheckboxes.length;
                        updateMealTotals();
                    });
                });
            }

            toggleSelectAll('breakfast', 'select_all_breakfast');
            toggleSelectAll('lunch', 'select_all_lunch');
            toggleSelectAll('dinner', 'select_all_dinner');

            function prepareMealData() {
                const allCheckedMeals = Array.from(document.querySelectorAll('.meal-checkbox:checked')).filter(cb => cb.style.display !== 'none');
                const mealData = [];
                const totalAmount = document.getElementById('total_amount').value;

                allCheckedMeals.forEach(checkbox => {
                    const date = checkbox.getAttribute('data-day');
                    const mealType = checkbox.classList.contains('breakfast') ? 'Breakfast' :
                        checkbox.classList.contains('lunch') ? 'Lunch' : 'Dinner';

                    const mealCost = mealType === 'Breakfast' ? parseFloat(document.getElementById('breakfast_cost').value) :
                        mealType === 'Lunch' ? parseFloat(document.getElementById('lunch_cost').value) :
                        parseFloat(document.getElementById('dinner_cost').value);

                    mealData.push({
                        date,
                        mealType,
                        mealCost
                    });
                });

                $.ajax({
                    url: 'nas/add',
                    type: 'POST',
                    data: {
                        mealData: JSON.stringify(mealData),
                        totalAmount: totalAmount
                    },
                    success: function(response) {
                        if (response.success) {
                            alert('Meal booking saved successfully!');
                        } else {
                            alert('Error: ' + response.error);
                        }
                    },
                    error: function(error) {
                        alert('There was an error with the request: ' + error);
                    }
                });
            }

            document.getElementById('submit').addEventListener('click', prepareMealData);
        });
    </script>





    <script>
        document.getElementById('selectMonth').addEventListener('change', function() {
            reloadPage();
        });

        document.getElementById('selectYear').addEventListener('change', function() {
            reloadPage();
        });

        function reloadPage() {
            let selectedMonth = document.getElementById('selectMonth').value;
            let selectedYear = document.getElementById('selectYear').value;
            window.location.href = "?month=" + selectedMonth + "&year=" + selectedYear;
        }
    </script>
    <footer class="panel-footer">
        <div class="row">
            <div class="col-md-offset-10 col-md-2">
                <button type="submit" name="submit" value="save" class="btn btn-default btn-block" id="submitBtn">
                    <i class="fas fa-plus-circle"></i> <?php echo translate('save'); ?>
                </button>
            </div>
        </div>
    </footer>
    <!-- Unique Inactive Staff Modal -->
    <!-- Warning Modal -->
    <div class="inactive-modal-wrapper" id="inactiveModalWrapper">
        <div class="inactive-modal-content">
            <span class="inactive-modal-close" onclick="closeInactiveModal()">&times;</span>
            <p id="inactiveModalMessage">
                <i class="fas fa-exclamation-triangle" style="font-size: 26px; color: #e74c3c;"></i><br><br>
                You are <strong>inactive</strong>.<br>Please contact your branch admin.
            </p>
        </div>
    </div>
    <script>
        if (!window.staffInactiveModalHandled) {
            window.staffInactiveModalHandled = true;

            $(document).ready(function() {
                var staffId = <?php echo get_loggedin_user_id(); ?>;

                $.ajax({
                    url: '<?php echo base_url("nas/check_staff_status"); ?>',
                    type: 'POST',
                    data: {
                        id: staffId
                    },
                    dataType: 'json',
                    success: function(response) {
                        if (response.status.toLowerCase() === 'inactive') {
                            $('#submitBtn').hide();
                            showInactiveModal(response.message || 'You are inactive. Please contact your branch admin.');
                        }
                    },
                    error: function() {
                        console.error('Error checking staff status.');
                    }
                });
            });

            function showInactiveModal(message) {
                $('#inactiveModalMessage').html(`
                <i class="fas fa-exclamation-triangle" style="font-size: 26px; color: #e74c3c;"></i><br><br>
                ${message}
            `);
                $('#inactiveModalWrapper').fadeIn();
            }

            function closeInactiveModal() {
                $('#inactiveModalWrapper').fadeOut();
            }
        }
    </script>

    <style>
        /* Fullscreen dark overlay */
        #inactiveModalWrapper {
            display: none;
            position: fixed;
            z-index: 99999;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.6);
        }

        /* Red-themed modal box */
        .inactive-modal-content {
            background-color: #fff0f0;
            border-left: 6px solid #e74c3c;
            margin: 120px auto;
            padding: 25px 20px;
            border-radius: 10px;
            width: 90%;
            max-width: 420px;
            box-shadow: 0 10px 30px rgba(231, 76, 60, 0.3);
            position: relative;
            animation: modalFadeIn 0.3s ease-out;
        }

        /* Close (X) button */
        .inactive-modal-close {
            position: absolute;
            top: 10px;
            right: 15px;
            font-size: 22px;
            color: #e74c3c;
            cursor: pointer;
            transition: transform 0.2s ease;
        }

        .inactive-modal-close:hover {
            transform: scale(1.2);
        }

        /* Warning message */
        #inactiveModalMessage {
            color: #b30000;
            font-size: 16px;
            font-weight: 600;
            text-align: center;
            line-height: 1.6;
        }

        /* Animation */
        @keyframes modalFadeIn {
            from {
                opacity: 0;
                transform: scale(0.95);
            }

            to {
                opacity: 1;
                transform: scale(1);
            }
        }
    </style>
    <!-- Modal for Warning -->
    <div class="modal" id="warningModal">
        <div class="modal-content">
            <span class="close" onclick="closeModal()">&times;</span>
            <p>Please select a package before submitting.</p>
        </div>
    </div>

    <script>
        document.getElementById('submitBtn').addEventListener('click', function(e) {
            var packageId = document.getElementById('package_id')?.value;
            if (!packageId) {
                e.preventDefault();
                document.getElementById('warningModal').style.display = 'block';
            }
        });

        function closeModal() {
            document.getElementById('warningModal').style.display = 'none';
        }

        window.onclick = function(event) {
            var modal = document.getElementById('warningModal');
            if (event.target === modal) {
                modal.style.display = 'none';
            }
        }
    </script>
    <style>
        /* Red Modal Styling */
        .modal {
            display: none;
            position: fixed;
            z-index: 999;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            animation: fadeIn 0.3s ease-out;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        .modal-content {
            background: #ffebee;
            color: #b71c1c;
            border-left: 5px solid #d32f2f;
            margin: 10% auto;
            padding: 25px;
            width: 320px;
            border-radius: 10px;
            text-align: center;
            position: relative;
            box-shadow: 0 10px 30px rgba(211, 47, 47, 0.4);
            animation: scaleIn 0.3s ease-out;
        }

        @keyframes scaleIn {
            from {
                transform: scale(0.8);
                opacity: 0;
            }

            to {
                transform: scale(1);
                opacity: 1;
            }
        }

        .modal-content p {
            font-size: 16px;
            line-height: 1.5;
            margin: 0;
        }

        .close {
            position: absolute;
            right: 14px;
            top: 10px;
            font-size: 22px;
            color: #d32f2f;
            font-weight: bold;
            cursor: pointer;
        }

        .close:hover {
            color: #b71c1c;
        }
    </style>


    <!-- Popup Modal -->
    <div id="popupModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <p id="modalMessage"></p>
        </div>
    </div>

    <?php echo form_close(); ?>