<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="keyword" content="<?php echo $page_data['meta_keyword']; ?>">
    <meta name="description" content="<?php echo $page_data['meta_description']; ?>">
    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo base_url('uploads/frontend/images/' . $cms_setting['fav_icon']); ?>">
    <title><?php echo $page_data['page_title'] . " - " . $cms_setting['application_title']; ?></title>

    <!-- Bootstrap -->
    <link href="<?php echo base_url() ?>assets/frontend/css/bootstrap.min.css" rel="stylesheet">
    <!-- Template CSS Files -->
    <link href="<?php echo base_url('assets/vendor/font-awesome/css/all.min.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('assets/frontend/plugins/animate.min.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('assets/frontend/css/style.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('assets/frontend/css/responsive.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('assets/frontend/css/owl.carousel.min.css'); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/vendor/select2/css/select2.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/vendor/bootstrap-datepicker/css/bootstrap-datepicker.standalone.css">
    
    <!-- jQuery -->
    <script src="<?php echo base_url('assets/vendor/jquery/jquery.js'); ?>"></script>

    <!-- Google Font - Montserrat -->
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600&display=swap" rel="stylesheet">

    <!-- Ajax CSRF Setup -->
    <script type="text/javascript">
        var base_url = '<?php echo base_url(); ?>';
        var csrfData = <?php echo json_encode(csrf_jquery_token()); ?>;
        $(function($) {
            $.ajaxSetup({
                data: csrfData
            });
        });
    </script>

    <!-- Preloader CSS -->
    <style>
        .loader-container {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(255, 255, 255, 0.9);
            z-index: 9999;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .lds-dual-ring {
            display: inline-block;
            width: 64px;
            height: 64px;
        }

        .lds-dual-ring:after {
            content: " ";
            display: block;
            width: 46px;
            height: 46px;
            margin: 1px;
            border-radius: 50%;
            border: 5px solid #007bff;
            border-color: #007bff transparent #007bff transparent;
            animation: lds-dual-ring 1.2s linear infinite;
        }

        @keyframes lds-dual-ring {
            0% {
                transform: rotate(0deg);
            }
            100% {
                transform: rotate(360deg);
            }
        }

        body.loaded .loader-container {
            display: none;
        }

        /* Transition Wrapper */
        .transition-wrapper {
            opacity: 0;
            transition: opacity 1s ease-in-out;
        }
        /* Ensures full opacity after loading */
        body.loaded .transition-wrapper {
            opacity: 1;
        }
    </style>
</head>
<body>
    <!-- Preloader -->
    <div class="loader-container">
        <div class="lds-dual-ring"></div>
    </div>

    <!-- Transition Wrapper for Fade-in Effect -->
    <div class="transition-wrapper">
        <!-- Main Content -->
        <?php $this->load->view('home/layout/header'); ?>
        <?php echo $main_contents; ?>
        <?php $this->load->view('home/layout/footer'); ?>
    </div>

    <!-- Scripts -->
    <script src="<?php echo base_url('assets/frontend/js/bootstrap.bundle.min.js'); ?>"></script>
    <script src="<?php echo base_url('assets/frontend/js/owl.carousel.min.js'); ?>"></script>
    <script src="<?php echo base_url('assets/frontend/js/custom.js'); ?>"></script>

    <!-- Page Load Scripts -->
    <script type="text/javascript">
        $(window).on('load', function() {
            $('body').addClass('loaded');
        });
    </script>

    <!-- CSS for Styling and Animation -->

    <!-- Scroll Effect for Sticky Navbar -->
    <script>
        window.addEventListener('scroll', function () {
            const navbar = document.getElementById('navbar');
            navbar.classList.toggle('sticky', window.scrollY > 50);
        });
    </script>
</body>
</html>
