
<!-- Main Slider Section Starts -->
<div>
    <!-- Main Slider Section Starts -->
    <section class="main-slider">
        <div class="container-fluid">
            <ul class="main-slider-carousel owl-carousel owl-theme">
                <?php
                $sliders = $this->db->get_where('front_cms_home', array('item_type' => 'slider'))->result();
                foreach ($sliders as $key => $value) {
                    $elements = json_decode($value->elements, true);
                ?>
                    <li class="slider-wrapper">
                        <div class="image" style="background-image: url(<?php echo base_url('uploads/frontend/slider/' . $elements['image']) ?>)"></div>
                        <div class="slider-caption <?php echo $elements['position']; ?>">
                            <div class="container">
                                <div class="wrap-caption">
                                    <h1><?php echo $value->title; ?></h1>
                                    <div class="text center"><?php echo $value->description; ?></div>
                                    <div class="link-btn">
                                        <a href="<?php echo $elements['button_url1']; ?>" class="btn">
                                            <?php echo $elements['button_text1']; ?>
                                        </a>
                                        <a href="<?php echo $elements['button_url2']; ?>" class="btn btn1">
                                            <?php echo $elements['button_text2']; ?>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                <?php } ?>
            </ul>
        </div>
    </section>
    <style>
        .owl-nav {
            display: none !important;
        }
    </style>
</div>


<!-- Main Slider Section Ends -->
<!-- Main Container Starts -->

<div>
    <style>
        /* Welcome Section */
        .welcome-section {
            background: linear-gradient(294deg, #ffffff, #2990ff);
            color: white;
            padding: 60px 0;
        }

        .welcome-section img {
            max-height: 400px;
            transition: transform 0.3s ease-in-out;
        }

        .welcome-section img:hover {
            transform: scale(1.05);
        }

        .welcome-section h1 {
            font-size: 2.5rem;
        }

        .welcome-section p {
            font-size: 1.1rem;
        }

        /* Features Section */
        .features-section {
            background-color: #f8f9fa;
            padding: 60px 0;
        }

        .features-section .feature-icon {
            background: #007bff;
            color: white;
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            border-radius: 50%;
            transition: transform 0.3s ease-in-out;
        }

        .features-section .feature-icon:hover {
            transform: rotate(360deg);
        }

        .features-section h5 {
            font-size: 1.25rem;
            font-weight: bold;
        }

        .features-section .card {
            border: none;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
            transition: box-shadow 0.3s ease-in-out;
        }

        .features-section .card:hover {
            box-shadow: 0px 8px 20px rgba(0, 0, 0, 0.2);
        }

        .features-section .btn-outline-primary {
            border-color: #007bff;
            color: #007bff;
            transition: background-color 0.3s ease-in-out, color 0.3s ease-in-out;
        }

        .features-section .btn-outline-primary:hover {
            background-color: #007bff;
            color: white;
        }

        /* Buttons */
        .btn-lg {
            padding: 10px 30px;
            font-size: 1.25rem;
            border-radius: 50px;
        }

        /* Responsiveness */
        @media (max-width: 768px) {
            .welcome-section h1 {
                font-size: 2rem;
            }

            .welcome-section img {
                max-height: 300px;
            }

            .features-section .feature-icon {
                width: 50px;
                height: 50px;
            }

            .features-section h5 {
                font-size: 1.1rem;
            }
        }
    </style>
    <div class="welcome-background scroll-animate from-left" style="padding: 60px 0;">

        <!-- Welcome Section Starts -->
        <section class="welcome-section text-white">
            <div class="container">
                <?php
                $wellcome = $this->db->get_where('front_cms_home', array('item_type' => 'wellcome'))->row_array();
                $elements = json_decode($wellcome['elements'], true);
                ?>
                <div class="row align-items-center">
                    <!-- Welcome Content -->
                    <div class="col-md-6 text-center text-md-start">
                        <div class="welcome-content"><br>
                            <h2 class="circular-rainbow-gradient-title" style="color: black;"><?php echo $wellcome['title']; ?></h2>
                            <h3 class="circular-rainbow-gradient-subtitle main-heading2" style="color: white;"><?php echo $wellcome['subtitle']; ?></h3><br>
                            <p style="color: black;"><?php echo nl2br($wellcome['description']); ?></p>
                        </div>
                    </div>
                    <!-- Welcome Image -->
                    <div class="col-md-6 text-center">
                        <div class="wel-img">
                            <img src="<?php echo base_url('uploads/frontend/home_page/' . $elements['image']); ?>" alt="image" class="img-fluid" />
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Welcome Section Ends -->

        <!-- Features Section Starts -->
        <section id="features" class="features-section">
            <div class="container">
                <div class="text-center mb-5">
                    <h2 class="fw-bold text-primary">Our Features</h2>
                    <p class="text-muted">Discover the unique benefits that set us apart from the rest!</p>
                </div>
                <div class="row g-4">
                    <?php
                    $features = $this->db->get_where('front_cms_home', array('item_type' => 'features'))->result();
                    foreach ($features as $feature) {
                        $elements = json_decode($feature->elements, true);
                    ?>
                        <div class="col-lg-4 col-md-6">
                            <div class="card shadow h-100">
                                <div class="card-body text-center">
                                    <div class="feature-icon">
                                        <i class="<?php echo $elements['icon']; ?> fs-1"></i>
                                    </div>
                                    <h5><?php echo $feature->title; ?></h5>
                                    <p class="text-muted"><?php echo $feature->description; ?></p>
                                    <a href="#" class="btn btn-outline-primary btn-sm">Learn More</a>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </section>
        <!-- Features Section Ends -->
    </div>
    <div>
        <section>
            <?php $services = $this->db->get_where('front_cms_home', array('item_type' => 'services'))->row_array(); ?>
            <!-- Main Container Starts -->
            <div class="services-background" style="padding: 60px 0;">
                <div class="container px-md-0">
                    <div class="row">
                        <!-- Title and Description Section -->
                        <div class="col-lg-4 col-md-12 mb-4">
                            <div class="services-description d-flex flex-column justify-content-center align-items-center text-center" style="height: 100%;">
                                <h2 class="fw-bold"><?php echo $services['title']; ?></h2>
                                <p class="text-muted"><?php echo nl2br($services['description']); ?></p>
                                <a href="<?php echo base_url('home/about'); ?>" class="btn btn-primary btn-lg">Explore Services</a>
                            </div>
                        </div>

                        <!-- Service Cards Section -->
                        <div class="col-lg-8 col-md-12">
                            <div class="row g-3">
                                <?php
                                $services_list = $this->db->get('front_cms_services_list')->result_array();
                                $iconColors = ['#FF6F61', '#6B5B93', '#88B04B', '#F7CAC9', '#FFDD44', '#45A1FF']; // Add more colors if needed
                                foreach ($services_list as $key => $value) {
                                    $color = $iconColors[$key % count($iconColors)]; // Cycle through the colors
                                ?>
                                    <div class="col-lg-4 col-md-6 col-sm-12">
                                        <div class="s-card text-center" style="border: 1px solid #e0e0e0; border-radius: 15px; box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1); padding: 20px; background: #ffffff; transition: all 0.3s ease;">
                                            <div class="service-icon d-flex justify-content-center align-items-center mb-3" style="width: 60px; height: 60px; border-radius: 50%; background-color: <?php echo $color; ?>; color: #fff; font-size: 24px;">
                                                <i class="<?php echo $value['icon']; ?>"></i>
                                            </div>
                                            <h5 style="font-size: 18px; font-weight: bold;"><?php echo $value['title']; ?></h5>
                                            <p style="color: #666;"><?php echo (strlen($value['description']) > 50) ? substr($value['description'], 0, 50) . '...' : $value['description']; ?></p>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Styles -->
        <style>
            /* Background for the services section */
            .services-background {
                background: linear-gradient(to bottom, #f3f7fe, #ffffff);
                position: relative;
                padding: 60px 0;
            }

            /* Services Title & Description Section */
            .services-description h2 {
                font-size: 2rem;
                color: #007bff;
                margin-bottom: 15px;
            }

            .services-description p {
                color: #6c757d;
                font-size: 1rem;
                line-height: 1.5;
            }

            .services-description .btn {
                margin-top: 20px;
                border-radius: 50px;
            }

            /* Service Cards */
            .s-card {
                transition: all 0.4s ease;
                border-radius: 15px;
                padding: 20px;
                background: #fff;
                box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
                text-align: center;
                height: 100%;
            }

            .s-card:hover {
                transform: scale(1.05);
                box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
            }

            .s-card .service-icon {
                width: 70px;
                height: 70px;
                border-radius: 50%;
                font-size: 2rem;
                margin-bottom: 15px;
                display: flex;
                justify-content: center;
                align-items: center;
                transition: transform 0.3s ease-in-out;
            }

            .s-card:hover .service-icon {
                transform: scale(1.2);
            }

            .s-card h5 {
                margin-top: 10px;
                font-size: 1.25rem;
                color: #333;
            }

            .s-card p {
                color: #666;
                font-size: 0.9rem;
                margin: 10px 0 0;
            }

            /* Responsive Design */
            @media (max-width: 768px) {
                .services-description h2 {
                    font-size: 1.75rem;
                }

                .s-card {
                    margin-bottom: 20px;
                }
            }
        </style>

        <!-- Script for Animations -->
        <script>
            document.addEventListener("DOMContentLoaded", function() {
                const serviceCards = document.querySelectorAll('.s-card');
                const observer = new IntersectionObserver((entries) => {
                    entries.forEach((entry) => {
                        if (entry.isIntersecting) {
                            entry.target.style.opacity = 1;
                            entry.target.style.transform = 'translateY(0)';
                        }
                    });
                }, {
                    threshold: 0.1
                });

                serviceCards.forEach((card) => {
                    card.style.opacity = 0;
                    card.style.transform = 'translateY(50px)';
                    observer.observe(card);
                });
            });
        </script>
    </div>

    <!-- Team Slider Section -->
    <div class="container my-5" id="team-slider-section">
        <!-- Header Section -->

        <section class="team-slider-section">
            <div class="swiper-container blog-slider">
                <h3 class="main-heading1 text-center"><?php echo $page_data['team_title']; ?></h3>
                <h3 class="main-heading2 text-center"><?php echo $page_data['team_subtitle']; ?></h3>
                <div class="swiper-wrapper">
                    <!-- Team Member Slide Loop Starts -->
                    <?php
                    $team = $this->db->get('front_cms_team_list')->result_array();
                    foreach ($team as $key => $value) {
                        $elements = json_decode($value['elements'], true);
                    ?>
                        <div class="swiper-slide">
                            <div class="team-card-slider d-flex align-items-center p-4">
                                <div class="team-image-wrapper-slider">
                                    <div class="team-image-div">
                                        <img src="<?php echo base_url('uploads/frontend/team/' . $elements['image']); ?>" alt="Team Member" class="team-image-slider">
                                        <br>
                                        <h6><?php echo $value['title']; ?></h6>
                                        <p>ISPM</p>
                                    </div>
                                </div>
                                <div class="team-info-slider ml-4">
                                    <h4 class="team-designation"><?php echo $value['designation']; ?></h4>
                                    <p class="team-description short-description">
                                        <?php echo substr($value['description'], 0, 250); ?>...
                                    </p>
                                    <p class="team-description full-description" style="display: none;">
                                        <?php echo $value['description']; ?>
                                    </p>
                                    <button class="btn btn-primary mt-3 read-more-btn">Read More</button>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    <!-- Team Member Slide Loop Ends -->
                </div>
                <!-- Swiper Pagination -->
                <div class="blog-slider__pagination"></div>
            </div>
            <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Swiper/4.3.5/css/swiper.min.css" />
        </section>
        <style>
            /* General Styling */
            body {
                font-family: 'Arial', sans-serif;
                background-color: #f8f9fa;
                margin: 0;
                padding: 0;
            }

            .team-slider-section {
                padding: 80px 0;
                /* Increased padding for more vertical space */
                background-color: #f8f9fa;
                display: flex;
                justify-content: center;
            }

            .team-card-slider {
                width: 200%;
                /* Set width to 98% */
                position: relative;
                /* Added position relative */
                max-width: 950px;
                /* Set max width to 1050px */
                margin: auto;
                /* Center the card */
                background: #fff;
                /* Background color */
                padding: 35px;
                /* Padding */
                border-radius: 35px;
                height: 400px;
                transition: all 0.3s;
            }

            .team-image-wrapper-slider {
                flex-shrink: 0;
                /* Prevent shrinking */
            }

            .team-image-div {
                text-align: center;
                width: 250px;
                height: 250px;
                flex-shrink: 0;
                background-image: linear-gradient(to right, #70bafe 0%, #998dff 51%, #70bafe 100%);
                /* box-shadow: 4px 13px 30px 1px rgba(170, 113, 38, 0.159); */
                border-radius: 35px;
                transform: translateX(-80px);
                overflow: hidden;
            }

            .team-image-slider {
                width: 150px;
                /* Set width of the image */
                height: 150px;
                /* Set height of the image */
                object-fit: cover;
                /* Ensure the image covers the entire div */
                border-radius: 50%;
                margin-top: 5%;
                margin-bottom: 5%;
                /* Make the image circular */
            }

            .team-info-slider {
                text-align: center;
                padding-right: 80px;
                opacity: 1;
                transform: none;
            }


            .team-info-slider h4 {
                font-size: 1.5rem;
                font-weight: bold;
                margin-bottom: 10px;
                color: #2C2C2C;
            }

            .team-info-slider .team-designation {
                font-size: 1.2rem;
                font-weight: 500;
                color: #000;
                margin-bottom: 10px;
            }

            .team-info-slider .team-description {
                font-size: 15px;
                line-height: 24px;
                font-family: 'Raleway', sans-serif;
                color: #232323;

            }



            .btn-primary {
                display: inline-flex;
                background-image: linear-gradient(147deg, #fe8a39 0%, #fdab38 74%);
                border-color: #fdab38;
                background-color: #fdab38;
                padding: 15px 35px;
                border-radius: 50px;
                color: #fff;
                box-shadow: 0px 14px 80px rgba(252, 56, 56, 0.4);
                text-decoration: none;
                font-size: 11px;
                width: 108px;
                justify-content: center;
                text-align: center;
                letter-spacing: 1px;
            }

            /* Swiper specific styles */
            .swiper-container {
                width: 100%;
                height: 100%;

            }

            .swiper-slide {
                display: flex;
                justify-content: center;

            }

            .blog-slider__pagination {
                position: absolute;
                z-index: 21;
                right: 90px;
                width: 11px !important;
                text-align: center;
                left: auto !important;
                top: 50%;
                bottom: auto !important;
                transform: translateY(-50%);
                line-height: 14px;

            }

            .blog-slider__pagination .swiper-pagination-bullet {
                background: #0000FF;
                opacity: 0.7;
            }

            .blog-slider__pagination .swiper-pagination-bullet-active {
                background: #00FFFF;
                opacity: 1;
            }
        </style>


        <!-- Swiper JS -->
        <script src="https://cdnjs.cloudflare.com/ajax/libs/Swiper/4.3.5/js/swiper.min.js"></script>
        <script>
            var swiper = new Swiper('.blog-slider', {
                spaceBetween: 30,
                effect: 'fade',
                loop: true,
                mousewheel: {
                    invert: false,
                },
                pagination: {
                    el: '.blog-slider__pagination',
                    clickable: true,
                },
                autoplay: {
                    delay: 5000,
                    disableOnInteraction: false,
                },
            });
        </script>

        <style>
            /* Adjust header sizes for responsiveness */
            .main-heading1 {
                font-size: 2.5rem;
                font-weight: 700;
                color: #333;
                margin-bottom: 1rem;
            }

            .main-heading2 {
                font-size: 1.5rem;
                font-weight: 400;
                color: #555;
                margin-bottom: 2rem;
            }

            /* Responsive Design */
            @media (max-width: 768px) {
                .main-heading1 {
                    font-size: 2rem;
                }

                .main-heading2 {
                    font-size: 1.2rem;
                }
            }

            @media (max-width: 480px) {
                .main-heading1 {
                    font-size: 1.75rem;
                }

                .main-heading2 {
                    font-size: 1rem;
                }
            }
        </style>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const readMoreButtons = document.querySelectorAll('.read-more-btn');

                readMoreButtons.forEach(button => {
                    button.addEventListener('click', function() {
                        const fullDescription = this.previousElementSibling; // Get the full description element

                        if (fullDescription.style.display === 'none' || fullDescription.style.display === '') {
                            fullDescription.style.display = 'block'; // Show full description
                            this.innerText = 'Read Less'; // Change button text
                        } else {
                            fullDescription.style.display = 'none'; // Hide full description
                            this.innerText = 'Read More'; // Reset button text
                        }
                    });
                });
            });
        </script>


    </div>
    <div>
        <!-- Meet Our Doctors Section Ends -->
        <!--Start Single Testimonial-->
        <?php $testimonial = $this->db->get_where('front_cms_home', array('item_type' => 'testimonial'))->row_array(); ?>
        <section class="testimonial-wrapper">
            <div class="container px-md-4">
                <div class="sec-title text-center">
                    <h3><?php echo $testimonial['title'] ?></h3>
                    <span><?php echo nl2br($testimonial['description']); ?></span>
                </div>

                <div class="testimonial-carousel owl-carousel owl-theme">
                    <?php
                    $testimonials = $this->db->get('front_cms_testimonial')->result_array();
                    foreach ($testimonials as $value) {
                    ?>
                        <div class="single-testimonial-style">
                            <div class="testimonial-card">
                                <div class="testimonial-card-header">
                                    <div class="testimonial-image-container">
                                        <img class="testimonial-image" src="<?php echo $this->app_lib->get_image_url('testimonial/' . $value['image']); ?>" alt="Client Image">
                                    </div>
                                </div>
                                <div class="testimonial-client-details">
                                    <h4 class="client-name"><?php echo $value['patient_name']; ?></h4>
                                    <p class="client-role"><?php echo $value['surname']; ?></p>
                                </div>

                                <div class="testimonial-body">
                                    <p class="testimonial-text"><?php echo nl2br($value['description']); ?></p>
                                </div>

                                <div class="testimonial-footer">
                                    <div class="testimonial-rating">
                                        <?php
                                        for ($i = 1; $i < 6; $i++) {
                                            echo $i <= $value['rank'] ? '<i class="fas fa-star"></i>' : '<i class="far fa-star"></i>';
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </section>


        <style>
            .testimonial-wrapper {
                padding: 100px 0;
                background: linear-gradient(135deg, #8e44ad, #3498db);
            }

            .sec-title {
                margin-bottom: 40px;
                color: #fff;
            }

            .sec-title h3 {

                font-size: 34px;
                margin-bottom: 12px;
                padding-left: 60px;
                position: relative;
                text-transform: capitalize;
            }

            .sec-title span {
                font-size: 16px;
                font-weight: 400;
                margin-left: 0;
            }

            .testimonial-carousel .single-testimonial-style {
                display: flex;
                justify-content: center;
                margin: 0 15px;
                animation: fadeInUp 0.5s ease-out;
            }

            .testimonial-card {
                background: #fff;
                border-radius: 20px;
                box-shadow: 0 12px 24px rgba(0, 0, 0, 0.1);
                transition: transform 0.3s ease, box-shadow 0.3s ease;
                max-width: 350px;
                padding: 30px;
                position: relative;
                display: flex;
                flex-direction: column;
                justify-content: space-between;
                color: #333;
                overflow: hidden;
            }

            .testimonial-card:hover {
                transform: translateY(-10px);
                box-shadow: 0 25px 50px rgba(0, 0, 0, 0.2);
            }

            .testimonial-card-header {
                display: flex;
                justify-content: center;
                align-items: center;
                margin-bottom: 20px;
                position: relative;
            }

            .testimonial-image-container {
                width: 80px;
                height: 80px;
                border-radius: 50%;
                overflow: hidden;
                position: absolute;
                top: 10px;
                /* Adjusted the position of the image container */
                background-color: #fff;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            }

            .testimonial-image {
                width: 100%;
                height: 100%;
                object-fit: cover;
            }

            .testimonial-client-details {
                text-align: center;
                margin-top: 60px;
            }

            .client-name {
                font-size: 1rem;
                color: #2c3e50;
                font-weight: 600;
                text-align: center;
                margin-bottom: 1px;
                margin-top: 25px;
            }

            .client-role {
                font-size: 14px;
                /* Adjusted font size for better balance */
                color: #00aaff;
                text-align: center;
                /* Center the role text */
                margin-top: 0;
                /* Ensures there’s no top margin */
            }

            .testimonial-body {
                font-size: 16px;
                font-weight: 400;
                line-height: 150%;
                margin: 0 0 15px;
                text-align: center;
                display: flex;
                justify-content: center;
                align-items: center;
                /* Vertically center the content */
                height: 100%;
            }

            .owl-dots span {
                display: none !important;
            }

            .testimonial-footer {
                display: flex;
                justify-content: center;
                align-items: center;
                margin-top: 20px;
            }

            .testimonial-rating {
                color: #f39c12;
                font-size: 18px;
            }

            .testimonial-rating i {
                margin-right: 3px;
            }

            @keyframes fadeInUp {
                0% {
                    opacity: 0;
                    transform: translateY(30px);
                }

                100% {
                    opacity: 1;
                    transform: translateY(0);
                }
            }
        </style>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css">

        <script>
            $(document).ready(function() {
                $(".testimonial-carousel").owlCarousel({
                    loop: true,
                    margin: 20,
                    nav: true,
                    dots: true,
                    autoplay: true,
                    autoplayTimeout: 5000,
                    responsive: {
                        0: {
                            items: 1
                        },
                        768: {
                            items: 2
                        },
                        1024: {
                            items: 3
                        }
                    },
                    navText: [
                        '<i class="fas fa-chevron-left"></i>',
                        '<i class="fas fa-chevron-right"></i>'
                    ]
                });
            });
        </script>
    </div>
    <!--End Single Testimonial-->

    <div>

        <!-- Package Section Starts -->
        <!-- Main Container -->
        <div class="container main-container py-5">
            <div class="elegant-section">
                <h3 class="text-center elegant-heading mb-0">Internet Packages</h3>
            </div>
        </div>

        <!-- Styles -->
        <style>
            .main-container {
                padding: 0;
                margin-top: -32px;
                margin-bottom: -43px;
                /* Make it full width */
                /* Limit width to 1520px */
                margin: 0 auto;
                /* Center the container horizontally */
            }

            /* Elegant Section Styling */
            .elegant-section {
                background: linear-gradient(145deg, #00d4ff, #e6e6e6);
                padding: 0;
                /* Remove extra padding */
                border-radius: 3px;
                position: relative;
                overflow: hidden;
                box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
                transition: box-shadow 0.3s ease, transform 0.3s ease;
                /* Full width within the container */
                height: 127px;
                /* Fixed height */
                display: flex;
                justify-content: center;
                align-items: center;
                flex-direction: column;
            }

            .elegant-section:hover {
                box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
                transform: translateY(-5px);
            }

            /* Diagonal Stripe Decoration */
            .elegant-section:before {
                content: '';
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: repeating-linear-gradient(45deg,
                        rgba(0, 0, 0, 0.02),
                        rgba(0, 0, 0, 0.02) 10px,
                        transparent 10px,
                        transparent 20px);
                z-index: 0;
            }

            /* Content Positioning */
            .elegant-section h3 {
                position: relative;
                z-index: 1;
                margin: 0;
            }

            /* Heading Styling */
            .elegant-heading {
                font-size: 1.5rem;
                /* Adjusted for the smaller height */
                font-weight: 800;
                color: #333;
                text-transform: uppercase;
                letter-spacing: 2px;
                font-family: 'Montserrat', sans-serif;
            }

            /* Responsive Adjustments */
            @media (max-width: 768px) {
                .main-container {
                    margin-top: 0;
                    margin-bottom: 0;
                }

                .elegant-section {
                    height: auto;
                    /* Adjust height for smaller screens */
                    padding: 1rem;
                    /* Add padding for better appearance */
                }

                .elegant-heading {
                    font-size: 1.2rem;
                    /* Smaller font size */
                    letter-spacing: 1px;
                }
            }

            @media (max-width: 768px) {
                .elegant-heading {
                    font-size: 1rem;
                    letter-spacing: 0.5px;
                }
            }
        </style>

        <!-- Package Section -->
        <section class="package-section py-5">
            <div class="container">
                <div class="row">
                    <?php if (!empty($packages)) : ?>
                        <?php foreach ($packages as $thisPackage) : ?>
                            <?php if ($thisPackage->manager_id == 1 && $thisPackage->privacy === 'public') : ?>
                                <div class="col-lg-4 col-md-6 mb-4">
                                    <div class="package-card">
                                        <div class="package-header">
                                            <h5 class="package-title"><?php echo html_escape($thisPackage->name); ?></h5>
                                            <p class="package-price">৳ <?php echo html_escape($thisPackage->retail_price); ?></p>
                                        </div>
                                        <ul class="package-features">
                                            <li><i class="fas fa-check-circle"></i> Connection Charge: Free</li>
                                            <li><i class="fas fa-headset"></i> 24/7 Helpdesk Support</li>
                                            <li><i class="fas fa-network-wired"></i> Fiber Optic Network</li>
                                            <li><i class="fas fa-globe"></i> Real IP on Demand</li>
                                            <li><i class="fas fa-tachometer-alt"></i> Up to 200 Mbps</li>
                                        </ul>
                                        <button class="btn btn-gradient w-100">Subscribe Now</button>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    <?php else : ?>
                        <div class="col-12 text-center">
                            <p class="text-muted">No packages available at this time.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </section>

        <!-- Styles -->
        <style>
            /* Package Card Styling */
            .package-card {
                background: linear-gradient(135deg, #ffffff, #00c8ff);
                /* White to Skyblue gradient */
                border-radius: 10px;
                padding: 25px;
                box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
                transition: transform 0.3s ease, box-shadow 0.3s ease;
                position: relative;
                background-size: 100% 100%;
            }

            .package-card:hover {
                transform: translateY(-8px);
                box-shadow: 0 15px 30px rgba(0, 0, 0, 0.2);
            }

            .package-header {
                margin-bottom: 20px;
                border-bottom: 2px solid #e6e6e6;
                padding-bottom: 15px;
                text-align: center;
            }

            .package-title {
                font-size: 1.4rem;
                font-weight: 600;
                color: #0078FF;
            }

            .package-price {
                font-size: 1.6rem;
                font-weight: bold;
                color: #222;
                margin: 10px 0;
            }

            .package-features {
                list-style: none;
                padding: 0;
                margin: 15px 0 25px;
            }

            .package-features li {
                font-size: 1rem;
                color: #555;
                padding: 10px 0;
                display: flex;
                align-items: center;
            }

            .package-features li i {
                color: #0078FF;
                margin-right: 10px;
            }

            .btn-gradient {
                background: linear-gradient(90deg, #0078FF, #0056D2);
                color: #fff;
                padding: 12px 18px;
                border-radius: 3px;
                font-size: 1rem;
                font-weight: bold;
                text-transform: uppercase;
                transition: background 0.4s ease, transform 0.2s ease;
                border: none;
            }

            .btn-gradient:hover {
                background: linear-gradient(90deg, #0056D2, #0078FF);
                transform: scale(1.05);
            }

            /* Responsive Adjustments */
            @media (max-width: 768px) {
                .package-title {
                    font-size: 1.2rem;
                }

                .package-price {
                    font-size: 1.4rem;
                }

                .package-features li {
                    font-size: 0.9rem;
                }
            }
        </style>

        <!-- JavaScript for Mouse Move Effect -->
        <script>
            document.addEventListener("mousemove", function(e) {
                // Get the mouse position
                var mouseX = e.clientX / window.innerWidth;
                var mouseY = e.clientY / window.innerHeight;

                // Apply a dynamic gradient based on the mouse position
                var gradient = `linear-gradient(135deg, rgba(255, 255, 255, 0.9) ${mouseY * 100}%, rgba(0, 200, 255, 0.8) ${mouseX * 100}%)`;

                // Select the .package-card element
                var packageCards = document.querySelectorAll('.package-card');

                // Apply the gradient background to each package card
                packageCards.forEach(function(card) {
                    card.style.background = gradient;
                });
            });
        </script>

        <!-- Include Google Fonts -->
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;700&family=Roboto:wght@400;500&display=swap" rel="stylesheet">

        <!-- Font Awesome -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

        <!-- Package Section Ends -->
        <div>
            <div class="payment-container">
                <div class="payment-slider" id="paymentSlider">
                    <!-- Payment Card Loop -->
                    <?php
                    $payment = $this->db->get_where('front_cms_payment_list')->result_array();
                    foreach ($payment as $key => $value) {
                        $elements = json_decode($value['elements'], true);
                    ?>
                        <div class="payment-card">
                            <div class="payment-content">
                                <h4><?php echo $value['title']; ?></h4>
                                <img src="<?php echo base_url('uploads/frontend/payment/' . $elements['image']); ?>"
                                    alt="Payment Member" class="payment-image">
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>

            <style>
                /* Container for all payment cards */
                .payment-container {
                    height: 130px;
                    margin: 0 auto;
                    background: white;
                    position: relative;
                    overflow: hidden;
                    border-radius: 3px;
                    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
                }

                /* Slider wrapper for cycling cards */
                .payment-slider {
                    display: flex;
                    position: relative;
                    height: 100%;
                    width: 100%;
                }

                /* Payment card styling */
                .payment-card {
                    flex: 0 0 100%;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    text-align: center;
                    position: absolute;
                    top: 0;
                    left: 0;
                    height: 100%;
                    /* Matches container height */
                    width: 100%;
                    /* Matches container width */
                    opacity: 0;
                    /* Initially hidden */
                    transition: opacity 0.5s ease-in-out;
                    z-index: 0;
                }

                /* Active card styling */
                .payment-card.active {
                    opacity: 1;
                    /* Visible */
                    z-index: 1;
                }

                /* Card content */
                .payment-content {
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    width: 100%;
                    height: 100%;
                    color: #fff;
                    /* White text for visibility */
                    background: linear-gradient(to right, #c4eaff 0%, #2f6fff 51%, #c4eaff 100%);
                    text-transform: uppercase;
                    font-family: 'Montserrat', sans-serif;
                    font-size: 17px;
                    font-weight: bold;
                }

                /* Payment Image Section */
                .payment-image-wrapper {
                    flex: 0 0 70%;
                    height: 100%;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                }

                .payment-image {
                    width: 15%;
                    height: 102%;
                    object-fit: cover;
                }

                /* Responsive design */
                @media (max-width: 768px) {
                    .payment-overlay {
                        font-size: 1rem;
                    }
                }
            </style>
            <script>
                document.addEventListener("DOMContentLoaded", function() {
                    const paymentCards = document.querySelectorAll(".payment-card");
                    let currentIndex = 0;

                    function showNextCard() {
                        // Remove active class from the current card
                        paymentCards[currentIndex].classList.remove("active");

                        // Move to the next card (or loop back to the first)
                        currentIndex = (currentIndex + 1) % paymentCards.length;

                        // Add active class to the new card
                        paymentCards[currentIndex].classList.add("active");
                    }

                    // Initialize the first card as active
                    paymentCards[currentIndex].classList.add("active");

                    // Cycle through the cards every 3 seconds
                    setInterval(showNextCard, 3000);
                });
            </script>

        </div>
    </div>
    <div>
        <div class="container my-5" id="team-section">
            <section class="client-section">
                <div class="row">
                    <!-- Team Member Loop Starts -->
                    <?php
                    $client = $this->db->get('front_cms_client_list')->result_array();
                    foreach ($client as $key => $value) {
                        $elements = json_decode($value['elements'], true);
                    ?>
                        <div class="col-md-3 mb-4">
                            <div class="client-card d-flex flex-column align-items-center p-4">
                                <div class="client-image-wrapper">
                                    <div class="client-image-div">
                                        <img src="<?php echo base_url('uploads/frontend/client/' . $elements['image']); ?>" alt="Client Member" class="client-image">
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    <!-- Team Member Loop Ends -->
                </div>
            </section>
        </div>
        <style>
            /* Cover Background */
            .cover {
                background-color: #5a9cf7;
                padding: 60px 0;
            }

            /* Client Card Styles */
            .client-card {
                padding: 50px 20px;
                transition: all 0.35s cubic-bezier(0.4, 0, 0.2, 1);
                border: 1px solid #c3c3c3;
                background: #fff;
                /* Ensures the card has a white background */
                border-radius: 8px;
                /* Adds rounded corners */
                box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
                /* Subtle default shadow */
            }

            /* Hover Effect */
            .client-card:hover {
                box-shadow: 0 8px 16px rgba(90, 156, 247, 0.6);
                /* Sky blue shadow on hover */
                transform: translateY(-5px);
                /* Adds a slight lift effect */
                transition: all 0.3s ease-in-out;
                /* Smooth animation */
            }

            /* Image Styles */
            .client-image {
                height: 60px; /* Fixed height for the image */
                max-width: 100%;

                vertical-align: top;

            }
 
            /* Container Styling */
            .container {
                max-width: 1200px;
                margin: 0 auto;
            }
        </style>
    </div>

    <div>
        <div class="container px-md-0 main-container">
            <!-- FAQ Section Starts -->
            <div class="faq-section text-center mb-5">
                <!-- Heading with Image -->
                <h2 class="faq-heading" style="font-size: 2.8rem; font-weight: 700; color: #333;">Frequently Asked Questions</h2>
                <p class="faq-subheading" style="font-size: 1.2rem; color: #777;">Your questions answered in one place</p>
            </div>

            <!-- FAQ's Accordions Starts -->
            <div class="accordion faq-section" id="accordion-faqs">
                <div class="container">
                    <div class="row">
                        <?php
                        $faq_list = $this->db->get('front_cms_faq_list')->result_array();
                        foreach ($faq_list as $key => $value) {
                        ?>
                            <div class="col-md-6 mb-4">
                                <div class="card border-0 shadow-sm">
                                    <!-- Card Header Starts -->
                                    <div class="card-header bg-gradient-primary" id="faq<?php echo $key; ?>"
                                        style="padding: 20px; border-radius: 8px 8px 0 0; cursor: pointer; 
                                       background: linear-gradient(45deg, #5a9cf7, #4d8bf5);">
                                        <h5 class="card-title mb-0">
                                            <a class="collapsed text-white" data-bs-toggle="collapse"
                                                data-bs-target="#collapse<?php echo $key; ?>" aria-expanded="false"
                                                aria-controls="collapse<?php echo $key; ?>"
                                                style="text-decoration: none; display: block; font-size: 1.2rem; font-weight: 600;">
                                                <i class="fa fa-question-circle mr-2"></i> <?php echo $value['title'] ?>
                                            </a>
                                        </h5>
                                    </div>
                                    <div id="collapse<?php echo $key; ?>" class="collapse" aria-labelledby="faq<?php echo $key; ?>"
                                        data-bs-parent="#accordion-faqs">
                                        <div class="card-body" style="background-color: #fff; padding: 20px; border-radius: 0 0 8px 8px; font-size: 1rem; color: #555; line-height: 1.6;">
                                            <?php echo $value['description']; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js"></script>
        <style>
            .bg-gradient-primary {
                background: linear-gradient(45deg, #5a9cf7, #4d8bf5);
                color: white;
            }

            .card {
                border: none;
                transition: all 0.3s ease-in-out;
            }

            .card:hover {
                transform: translateY(-5px);
                box-shadow: 0px 10px 20px rgba(0, 0, 0, 0.1);
            }

            .card-body {
                background-color: #f9f9f9;
            }
        </style>
    </div>
    <!-- FAQ's Accordions Ends -->

    <div>

        <section class="footer-top-bar text-center my-5" style="background-color: #f8f9fa; padding: 30px; border-radius: 10px; box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);">
            <div class="container">

                <h3 style="font-size: 1.5rem; color: #2C2C2C; font-weight: bold; margin-bottom: 20px;">
                    <?php
                    $elements = json_decode($page_data['elements'], true);
                    echo $elements['cta_title'];
                    ?>

                </h3>

                <a href="<?php echo $elements['button_url'] ?>" class="btn btn-primary btn-lg text-uppercase" style="background-color: #fe8a39; color: white; padding: 10px 20px; border-radius: 30px;">
                    <?php echo $elements['button_text']; ?>
                </a>
            </div>
        </section>

        <style>
            .btn-primary {

                background-image: linear-gradient(to right, #70bafe 0%, #998dff 51%, #70bafe 100%);
                background-size: 181% auto;
                z-index: 2;
                width: 226px;
                padding: 0px;
                display: inline-block;
                -webkit-transition: all 400ms ease-out;
                -o-transition: all 400ms ease-out;
                transition: all 400ms ease-out;
                text-align: center;
                outline: none !important;
                -webkit-box-shadow: none !important;
                box-shadow: none !important;
                color: #fff;
                font-size: 15px;
                font-family: "Roboto", sans-serif;
                line-height: 25px;
                border: 5px solid rgba(204, 241, 255, 0.5);
                border-radius: 33px;
            }
        </style>
    </div>
</div> <!-- Footer Top Bar Ends -->