<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_data['page_title']; ?></title>
    <style>
        /* Main Banner Styling */
        .main-banner {
            position: relative;
            display: flex;
            justify-content: center;
            align-items: center;
            background: white;
            height: 250px;
            color: white;
            text-align: center;
            overflow: hidden;
        }

        .main-banner h2 {
            font-weight: bold;
            z-index: 2;
            text-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
            position: relative;
            padding: 10px 20px;
            margin-top: -72px;
            margin-bottom: 0;
    font-size: 3rem;
    color: white;
            
        }

        /* Network Canvas */
        #networkCanvas {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            display: block;
            z-index: 1;
        }
    </style>
</head>
<body>

<!-- Main Banner Starts -->
<div class="main-banner">
    <canvas id="networkCanvas"></canvas>
    <h2 class="animate-text"><?php echo $page_data['page_title']; ?></h2>
</div>
<!-- Main Banner Ends -->
<script>
    const canvas = document.getElementById('networkCanvas');
    const ctx = canvas.getContext('2d');

    canvas.width = canvas.offsetWidth;
    canvas.height = canvas.offsetHeight;

    const maxNodes = 100;
    const nodeRadius = 3;
    const connectionDistance = 100;
    const nodeSpeed = 0.3;

    let nodes = [];

    class Node {
        constructor() {
            this.x = Math.random() * canvas.width;
            this.y = Math.random() * canvas.height;
            this.speedX = (Math.random() - 0.5) * nodeSpeed;
            this.speedY = (Math.random() - 0.5) * nodeSpeed;
            this.radius = nodeRadius;
        }

        update() {
            this.x += this.speedX;
            this.y += this.speedY;

            // Bounce nodes off edges
            if (this.x < 0 || this.x > canvas.width) this.speedX *= -1;
            if (this.y < 0 || this.y > canvas.height) this.speedY *= -1;
        }

        draw() {
            // Set node color to 'rgba(0, 123, 255, 0.7)'
            ctx.fillStyle = 'rgba(0, 123, 255, 0.7)';  // Updated color
            ctx.beginPath();
            ctx.arc(this.x, this.y, this.radius, 0, Math.PI * 2);
            ctx.closePath();
            ctx.fill();
        }
    }

    function initNodes() {
        nodes = [];
        for (let i = 0; i < maxNodes; i++) {
            nodes.push(new Node());
        }
    }

    function drawLines() {
        for (let i = 0; i < nodes.length; i++) {
            for (let j = i + 1; j < nodes.length; j++) {
                const dx = nodes[i].x - nodes[j].x;
                const dy = nodes[i].y - nodes[j].y;
                const distance = Math.sqrt(dx * dx + dy * dy);

                if (distance < connectionDistance) {
                    // Set line color to 'rgba(0, 123, 255, 0.5)'
                    ctx.strokeStyle = `rgba(0, 123, 255, ${1 - distance / connectionDistance})`; // Updated line color
                    ctx.lineWidth = 0.5;
                    ctx.beginPath();
                    ctx.moveTo(nodes[i].x, nodes[i].y);
                    ctx.lineTo(nodes[j].x, nodes[j].y);
                    ctx.stroke();
                }
            }
        }
    }

    function animate() {
        ctx.clearRect(0, 0, canvas.width, canvas.height);

        // Set the background color to a light color
        ctx.fillStyle = '#f4f8fb';
        ctx.fillRect(0, 0, canvas.width, canvas.height);

        nodes.forEach(node => {
            node.update();
            node.draw();
        });

        drawLines();
        requestAnimationFrame(animate);
    }

    initNodes();
    animate();

    window.addEventListener('resize', function() {
        canvas.width = canvas.offsetWidth;
        canvas.height = canvas.offsetHeight;
        initNodes();
    });
</script>



</body>
</html>


<div class="breadcrumb">
    <div class="container px-md-0">
        <ul class="list-unstyled list-inline">
            <li class="list-inline-item"><a href="<?php echo base_url('home') ?>">Home</a></li>
            <li class="list-inline-item active"><?php echo $page_data['page_title']; ?></li>
        </ul>
    </div>
</div>
<!-- Main Container Starts -->
<div class="container">
    <section class="team-section">
        <div class="row">
            <!-- Team Member Card Loop Starts -->
            <?php
            $payment = $this->db->get_where('front_cms_payment_list')->result_array();
            foreach ($payment as $key => $value) {
                $elements = json_decode($value['elements'], true);
                $unique_class = "payment-card-" . $key;
            ?>
                <div class="col-12 <?php echo $unique_class; ?>">
                    <div class="payment-card">
                        <!-- First Section: Payment Title -->
                        <div class="payment-title">
                            <h3><?php echo $value['title']; ?></h3>
                        </div>
                        <!-- Second Section: Payment Image -->
                        <div class="payment-image-wrapper">
                            <img src="<?php echo base_url('uploads/frontend/payment/' . $elements['image']); ?>" alt="Payment Member" class="img-fluid payment-image">
                        </div>
                        <!-- Optional Content Section: Description -->
                      
                    </div>
                </div>
                

            <?php } ?>
            <!-- Team Member Card Loop Ends -->
        </div>

    </section>
    <div class="payment-button text-center mt-3">
                            <a href="#" class="btn btn-primary btn-sm">PAY VIA CARD</a>
                        </div>
</div>
<style>
       .payment-button .btn {
        background-color: #007bff;
        color: white;
        font-size: 0.9rem;
        font-weight: 600;
        padding: 8px 16px;
        border-radius: 20px;
        transition: background-color 0.3s ease;
        text-transform: uppercase;
    }

    .payment-button .btn:hover {
        background-color: #0056b3;
    }

/* Payment Card Styling */
.payment-card {
    width: 100%;
    background-color: #fff;
    border-radius: 8px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    margin-bottom: 30px;
    overflow: hidden;
}

/* Payment Title Styling */
.payment-title {
    background-color: rgba(135, 206, 235, 0.8); /* Light blue overlay */
    color: #003366;
    text-align: center;
    padding: 30px 0;
    font-size: 25px;
    font-weight: bold;
}

/* Payment Image Wrapper Styling */
.payment-image-wrapper {
    width: 100%;
    overflow: hidden;
}

.payment-image {
    width: 100%;
    height: 100%;
    object-fit: cover; /* Ensures the image fills the container */
    transition: all 0.3s ease;
}

/* Payment Content Styling (Optional) */
.payment-content {
    padding: 20px;
    background-color: #f8f9fa; /* Light gray background */
    text-align: center;
}

/* Responsive Styles */
@media (max-width: 767px) {
    .payment-title {
        font-size: 1.25rem;
        padding: 20px 0;
    }

    .payment-image-wrapper {
        height: 250px; /* Adjust height for small screens */
    }
}

.col-12 {
    margin-bottom: 30px;
}

</style>
<style>
.breadcrumb {
    background-color: #97d5ff42;

    margin-bottom: 15px; /* Optional: Adds space below the breadcrumb */
    font-size: 1rem; /* Optional: Adjusts font size */
    }
     .contact-section {
        position: relative;
        padding: 4rem 0;
        background-color: #f8f9fa; /* Light background for contrast */
    }

    .main-banner {
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
        color: white;
        padding: 1rem;
    }

    .main-banner h2 {
        font-weight: bold;
        text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.7);
    }
    /* General Styling */
    body {
        font-family: 'Arial', sans-serif;
        background-color: #f4f8fb; /* Light background for contrast */
    }
    </style>