<!-- Main Banner Starts -->
<div class="main-banner animated-banner" style="background: url('<?php echo base_url('uploads/frontend/banners/' . $page_data['banner_image']); ?>') center center; background-size: cover; height: 350px; position: relative;">
    <div class="container h-100 d-flex justify-content-center align-items-center text-center">
        <h2 class="animate-text" style="font-weight: bold; font-size: 3rem; color: #000000;"><?php echo $page_data['page_title']; ?></h2>
    </div>
</div>
<!-- Main Banner Ends -->

<script>
    window.addEventListener('scroll', function() {
        document.querySelector('header').classList.toggle('scrolled', window.scrollY > 50);
    });
</script>
<div class="breadcrumb">
    <div class="container px-md-0">
        <ul class="list-unstyled list-inline">
            <li class="list-inline-item"><a href="<?php echo base_url('home') ?>">Home</a></li>
            <li class="list-inline-item active"><?php echo $page_data['page_title']; ?></li>
        </ul>
    </div>
</div>

<!-- Contact Section Starts -->
<section class="contact-section py-5">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-6 mb-4">
                <div class="col-md-12 d-none d-md-block mb-4">
                    <img src="<?php echo base_url('uploads/frontend/images/' . $page_data['box_image']); ?>" alt="Contact Image" class="img-fluid rounded shadow-lg">
                </div>
                <h2 class="text-primary">Get in Touch</h2>
                <p class="lead text-muted"><?php echo nl2br($page_data['box_description']); ?></p>
                <div class="contact-info">
                    <h4 class="mt-4">Contact Details</h4>
                    <div class="info-item">
                        <i class="fas fa-map-marker-alt"></i>
                        <p><?php echo nl2br($page_data['address']); ?></p>
                    </div>
                    <div class="info-item">
                        <i class="fas fa-phone"></i>
                        <p><?php echo nl2br($page_data['phone']); ?></p>
                    </div>
                    <div class="info-item">
                        <i class="far fa-envelope"></i>
                        <p><?php echo nl2br($page_data['email']); ?></p>
                    </div>
                </div>
                <div class="social-media mt-4">
                    <h5>Follow Us:</h5>
                    <a href="#" class="social-icon"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-twitter"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-instagram"></i></a>
                    <a href="#" class="social-icon"><i class="fab fa-linkedin-in"></i></a>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card contact-form-card shadow animate-card">
                    <div class="card-body">
                        <h3 class="card-title text-center">Contact Us</h3>

                        <!-- Success and Error Messages -->
                        <?php if ($this->session->flashdata('msg_success')): ?>
                            <div class="alert alert-success text-center">
                                <i class="far fa-check-circle"></i> <?php echo $this->session->flashdata('msg_success'); ?>
                            </div>
                        <?php endif; ?>
                        <?php if ($this->session->flashdata('msg_error')): ?>
                            <div class="alert alert-danger text-center">
                                <i class="far fa-times-circle"></i> <?php echo $this->session->flashdata('msg_error'); ?>
                            </div>
                        <?php endif; ?>

                        <!-- Contact Form Starts -->
                        <?php echo form_open($this->uri->uri_string(), array('class' => 'form-horizontal')); ?>
                        <div class="form-group">
                            <input type="text" class="form-control animated-input" placeholder=" " name="name" required />
                            <label class="form-label">Name *</label>
                            <span class="text-danger"><?php echo form_error('name'); ?></span>
                        </div>
                        <div class="form-group">
                            <input type="email" class="form-control animated-input" placeholder=" " name="email" required />
                            <label class="form-label">Email *</label>
                            <span class="text-danger"><?php echo form_error('email'); ?></span>
                        </div>
                        <div class="form-group">
                            <input type="text" class="form-control animated-input" placeholder=" " name="phoneno" required />
                            <label class="form-label">Phone *</label>
                            <span class="text-danger"><?php echo form_error('phoneno'); ?></span>
                        </div>
                        <div class="form-group">
                            <input type="text" class="form-control animated-input" placeholder=" " name="subject" required />
                            <label class="form-label">Subject *</label>
                            <span class="text-danger"><?php echo form_error('subject'); ?></span>
                        </div>
                        <div class="form-group">
                            <textarea class="form-control animated-input" rows="5" placeholder=" " name="message" required></textarea>
                            <label class="form-label">Message *</label>
                            <span class="text-danger"><?php echo form_error('message'); ?></span>
                        </div>
                        <button type="submit" class="btn btn-primary btn-lg btn-block animated-btn"><?php echo $page_data['submit_text']; ?></button>
                        <?php echo form_close(); ?>
                        <!-- Contact Form Ends -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Contact Section Ends -->

<style>
    .breadcrumb {
    background-color: #97d5ff42;

    margin-bottom: 15px; /* Optional: Adds space below the breadcrumb */
    font-size: 1rem; /* Optional: Adjusts font size */
}
    /* Contact Section Styles */
    .contact-section {
        position: relative;
        padding: 4rem 0;
        background-color: #f8f9fa; /* Light background for contrast */
    }

    header {
        position: absolute;
        width: 100%;
        top: 0;
        z-index: 10;
        background: transparent;
        padding: 15px 0; /* Adjust padding as needed */
        transition: background 0.3s ease;
    }

    /* Optional: Change header background on scroll */
    header.scrolled {
        background: rgba(0, 0, 0, 0.7); /* Adjust transparency as needed */
    }
     .contact-section {
        position: relative;
        padding: 4rem 0;
        background-color: #f8f9fa; /* Light background for contrast */
    }

    .main-banner {
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
        color: white;
        padding: 1rem;
    }
    .main-banner h2 {
    font-weight: bold;
    font-size: 55px;
    color: #000000;
    margin-top: 45px;
    margin-bottom: 0;
    }
w

    .contact-info {
        margin-top: 20px;
    }

    .info-item {
        display: flex;
        align-items: center;
        margin-bottom: 15px;
        color: #333; /* Dark text for better readability */
    }

    .info-item i {
        font-size: 1.5rem;
        margin-right: 10px;
        color: #6a11cb;
    }

    .contact-form-card {
        border: none;
        border-radius: 10px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }

    .animate-card {
        animation: float 1.5s ease-in-out infinite;
    }

    @keyframes float {
        0%, 100% {
            transform: translateY(0);
        }
        50% {
            transform: translateY(-10px);
        }
    }

    .animated-input {
        transition: all 0.3s ease;
        border-radius: 5px;
        border: 1px solid #ccc;
        padding: 10px;
    }

    .animated-input:focus {
        border-color: #2575fc;
        box-shadow: 0 0 5px rgba(37, 117, 252, 0.5);
    }

    .animated-btn {
        transition: background-color 0.3s ease, transform 0.3s ease;
        background-color: #2575fc; /* Primary color */
        border: none; /* Remove default border */
    }

    .animated-btn:hover {
        background-color: #0056b3; /* Darker on hover */
        transform: translateY(-2px);
    }

    .social-media {
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .social-icon {
        font-size: 1.5rem;
        color: #6a11cb;
        transition: color 0.3s;
    }

    .social-icon:hover {
        color: #0056b3; /* Change color on hover */
    }
</style>
