
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_data['page_title']; ?></title>
    <style>
        /* Main Banner Styling */
        .main-banner {
            position: relative;
            display: flex;
            justify-content: center;
            align-items: center;
            background: white;
            height: 250px;
            color: white;
            text-align: center;
            overflow: hidden;
        }

        .main-banner h2 {
            font-weight: bold;
            z-index: 2;
            text-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
            position: relative;
            padding: 10px 20px;
            margin-top: -72px;
            margin-bottom: 0;
    font-size: 3rem;
    color: white;
            
        }

        /* Network Canvas */
        #networkCanvas {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            display: block;
            z-index: 1;
        }
    </style>

<!-- Main Banner Starts -->
<div class="main-banner">
    <canvas id="networkCanvas"></canvas>
    <h2 class="animate-text"><?php echo $page_data['page_title']; ?></h2>
</div>

<!-- Main Banner Ends -->
<script>
    const canvas = document.getElementById('networkCanvas');
    const ctx = canvas.getContext('2d');

    canvas.width = canvas.offsetWidth;
    canvas.height = canvas.offsetHeight;

    const maxNodes = 100;
    const nodeRadius = 3;
    const connectionDistance = 100;
    const nodeSpeed = 0.3;

    let nodes = [];

    class Node {
        constructor() {
            this.x = Math.random() * canvas.width;
            this.y = Math.random() * canvas.height;
            this.speedX = (Math.random() - 0.5) * nodeSpeed;
            this.speedY = (Math.random() - 0.5) * nodeSpeed;
            this.radius = nodeRadius;
        }

        update() {
            this.x += this.speedX;
            this.y += this.speedY;

            // Bounce nodes off edges
            if (this.x < 0 || this.x > canvas.width) this.speedX *= -1;
            if (this.y < 0 || this.y > canvas.height) this.speedY *= -1;
        }

        draw() {
            // Set node color to 'rgba(0, 123, 255, 0.7)'
            ctx.fillStyle = 'rgba(0, 123, 255, 0.7)';  // Updated color
            ctx.beginPath();
            ctx.arc(this.x, this.y, this.radius, 0, Math.PI * 2);
            ctx.closePath();
            ctx.fill();
        }
    }

    function initNodes() {
        nodes = [];
        for (let i = 0; i < maxNodes; i++) {
            nodes.push(new Node());
        }
    }

    function drawLines() {
        for (let i = 0; i < nodes.length; i++) {
            for (let j = i + 1; j < nodes.length; j++) {
                const dx = nodes[i].x - nodes[j].x;
                const dy = nodes[i].y - nodes[j].y;
                const distance = Math.sqrt(dx * dx + dy * dy);

                if (distance < connectionDistance) {
                    // Set line color to 'rgba(0, 123, 255, 0.5)'
                    ctx.strokeStyle = `rgba(0, 123, 255, ${1 - distance / connectionDistance})`; // Updated line color
                    ctx.lineWidth = 0.5;
                    ctx.beginPath();
                    ctx.moveTo(nodes[i].x, nodes[i].y);
                    ctx.lineTo(nodes[j].x, nodes[j].y);
                    ctx.stroke();
                }
            }
        }
    }

    function animate() {
        ctx.clearRect(0, 0, canvas.width, canvas.height);

        // Set the background color to a light color
        ctx.fillStyle = '#f4f8fb';
        ctx.fillRect(0, 0, canvas.width, canvas.height);

        nodes.forEach(node => {
            node.update();
            node.draw();
        });

        drawLines();
        requestAnimationFrame(animate);
    }

    initNodes();
    animate();

    window.addEventListener('resize', function() {
        canvas.width = canvas.offsetWidth;
        canvas.height = canvas.offsetHeight;
        initNodes();
    });
</script>



</body>
</html>


<!-- 
<style>
    canvas {
        width: 100% !important;
    }
</style>
<section id="app" class="wave-section">
    <div id="wave"></div>
</section>
<script src="https://sohub.com.bd/assets/js/index.js"></script>
-->
<div class="breadcrumb">
    <div class="container px-md-0">
        <ul class="list-unstyled list-inline">
            <li class="list-inline-item"><a href="<?php echo base_url('home') ?>">Home</a></li>
            <li class="list-inline-item active"><?php echo $page_data['page_title']; ?></li>
        </ul>
    </div>
</div>
<!-- Breadcrumb Ends -->
<!-- Main Container Starts -->

<!-- Package Section Starts -->
<!-- Main Container -->
<div class="container main-container py-5">
    <div class="elegant-section">
        <h3 class="text-center elegant-heading mb-4"><?php echo $page_data['title']; ?></h3>
        <p class="text-center elegant-text"><?php echo $page_data['description']; ?></p>
    </div>
</div>

<!-- Styles -->
<style>
     .main-banner {
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
        color: white;
        padding: 1rem;
    }

    .main-banner h2 {
        font-weight: bold;
        text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.7);
    }
     .breadcrumb {
    background-color: #97d5ff42;

    margin-bottom: 15px; /* Optional: Adds space below the breadcrumb */
    font-size: 1rem; /* Optional: Adjusts font size */
}
       .main-container {
        padding: 0;
        margin-top: -32px;
        margin-bottom: -43px;
    }
    /* Elegant Section Styling */
    .elegant-section {
        background: linear-gradient(145deg, #00d4ff, #e6e6e6);
        padding: 1rem 1.5rem;
        border-radius: 20px;
        position: relative;
        overflow: hidden;
        box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
        transition: box-shadow 0.3s ease, transform 0.3s ease;
        width: 100%;
        height: 100%; /* Full viewport height */
        display: flex;
        justify-content: center;
        align-items: center;
        flex-direction: column;
    }

    .elegant-section:hover {
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
        transform: translateY(-5px);
    }

    /* Diagonal Stripe Decoration */
    .elegant-section:before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: repeating-linear-gradient(
            45deg,
            rgba(0, 0, 0, 0.02),
            rgba(0, 0, 0, 0.02) 10px,
            transparent 10px,
            transparent 20px
        );
        z-index: 0;
    }

    /* Content Positioning */
    .elegant-section h3,
    .elegant-section p {
        position: relative;
        z-index: 1;
    }

    /* Heading Styling */
    .elegant-heading {
        font-size: 2rem;
        font-weight: 800;
        color: #333;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin-bottom: 1rem;
        font-family: 'Montserrat', sans-serif;
    }

    /* Text Styling */
    .elegant-text {
        font-size: 1.1rem;
        font-weight: 400;
        color: #666;
        max-width: 400px;
        margin: 0 auto;
        line-height: 1.8;
        font-family: 'Open Sans', sans-serif;
    }

    /* Responsive Adjustments */
    @media (max-width: 768px) {
        .elegant-heading {
            font-size: 1.8rem;
            letter-spacing: 1px;
        }

        .elegant-text {
            font-size: 1rem;
        }
    }
</style>

<!-- Include Google Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;800&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet">


<!-- Package Section -->
<section class="package-section py-5">
    <div class="container">
        <div class="row">
            <?php if (!empty($packages)) : ?>
                <?php foreach ($packages as $thisPackage) : ?>
                    <?php if ($thisPackage->manager_id == 1 && $thisPackage->privacy === 'public') : ?>
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="package-card">
                                <div class="package-header">
                                    <h5 class="package-title"><?php echo html_escape($thisPackage->name); ?></h5>
                                    <p class="package-price">৳ <?php echo html_escape($thisPackage->retail_price); ?></p>
                                </div>
                                <ul class="package-features">
                                    <li><i class="fas fa-check-circle"></i> Connection Charge: Free</li>
                                    <li><i class="fas fa-headset"></i> 24/7 Helpdesk Support</li>
                                    <li><i class="fas fa-network-wired"></i> Fiber Optic Network</li>
                                    <li><i class="fas fa-globe"></i> Real IP on Demand</li>
                                    <li><i class="fas fa-tachometer-alt"></i> Up to 200 Mbps</li>
                                </ul>
                                <button class="btn btn-gradient w-100">Subscribe Now</button>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
            <?php else : ?>
                <div class="col-12 text-center">
                    <p class="text-muted">No packages available at this time.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<!-- Styles -->
<style>
    /* Package Card Styling */
    .package-card {
        background: linear-gradient(135deg, #ffffff, #00c8ff); /* White to Skyblue gradient */
        border-radius: 10px;
        padding: 25px;
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        position: relative;
        background-size: 100% 100%;
    }

    .package-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 15px 30px rgba(0, 0, 0, 0.2);
    }

    .package-header {
        margin-bottom: 20px;
        border-bottom: 2px solid #e6e6e6;
        padding-bottom: 15px;
        text-align: center;
    }

    .package-title {
        font-size: 1.4rem;
        font-weight: 600;
        color: #0078FF;
    }

    .package-price {
        font-size: 1.6rem;
        font-weight: bold;
        color: #222;
        margin: 10px 0;
    }

    .package-features {
        list-style: none;
        padding: 0;
        margin: 15px 0 25px;
    }

    .package-features li {
        font-size: 1rem;
        color: #555;
        padding: 10px 0;
        display: flex;
        align-items: center;
    }

    .package-features li i {
        color: #0078FF;
        margin-right: 10px;
    }

    .btn-gradient {
        background: linear-gradient(90deg, #0078FF, #0056D2);
        color: #fff;
        padding: 12px 18px;
        border-radius: 3px;
        font-size: 1rem;
        font-weight: bold;
        text-transform: uppercase;
        transition: background 0.4s ease, transform 0.2s ease;
        border: none;
    }

    .btn-gradient:hover {
        background: linear-gradient(90deg, #0056D2, #0078FF);
        transform: scale(1.05);
    }

    /* Responsive Adjustments */
    @media (max-width: 768px) {
        .package-title {
            font-size: 1.2rem;
        }

        .package-price {
            font-size: 1.4rem;
        }

        .package-features li {
            font-size: 0.9rem;
        }
    }
</style>

<!-- JavaScript for Mouse Move Effect -->
<script>
    document.addEventListener("mousemove", function(e) {
        // Get the mouse position
        var mouseX = e.clientX / window.innerWidth;
        var mouseY = e.clientY / window.innerHeight;

        // Apply a dynamic gradient based on the mouse position
        var gradient = `linear-gradient(135deg, rgba(255, 255, 255, 0.9) ${mouseY * 100}%, rgba(0, 200, 255, 0.8) ${mouseX * 100}%)`;

        // Select the .package-card element
        var packageCards = document.querySelectorAll('.package-card');
        
        // Apply the gradient background to each package card
        packageCards.forEach(function(card) {
            card.style.background = gradient;
        });
    });
</script>

<!-- Include Google Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;700&family=Roboto:wght@400;500&display=swap" rel="stylesheet">

<!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

<!-- Package Section Ends -->

<!-- Simplified Package Design CSS -->
