<?php
$service = $this->db->get_where('front_cms_services', array('id' => 1))->row_array();
?>

<!-- Main Banner Starts -->
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_data['page_title']; ?></title>

    <style>
        /* Main Banner Styling */
        .main-banner {
            position: relative;
            display: flex;
            justify-content: center;
            align-items: center;
            background: white;
            height: 250px;
            color: white;
            text-align: center;
            overflow: hidden;
        }

        .main-banner h2 {
            font-weight: bold;
            z-index: 2;
            text-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
            position: relative;
            padding: 10px 20px;
            margin-top: -72px;
            margin-bottom: 0;
            font-size: 3rem;
            color: white;

        }

        /* Network Canvas */
        #networkCanvas {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            display: block;
            z-index: 1;
        }
    </style>
</head>

<body>

    <!-- Main Banner Starts -->
    <div class="main-banner">
        <canvas id="networkCanvas"></canvas>
        <h2 class="animate-text"><?php echo $page_data['page_title']; ?></h2>
    </div>
    <div class="breadcrumb">
        <div class="container px-md-0">
            <ul class="list-unstyled list-inline">
                <li class="list-inline-item"><a href="<?php echo base_url('home') ?>">Home</a></li>
                <li class="list-inline-item active"><?php echo $page_data['page_title']; ?></li>
            </ul>
        </div>
    </div>
    <!-- Main Banner Ends -->
    <script>
        const canvas = document.getElementById('networkCanvas');
        const ctx = canvas.getContext('2d');

        canvas.width = canvas.offsetWidth;
        canvas.height = canvas.offsetHeight;

        const maxNodes = 100;
        const nodeRadius = 3;
        const connectionDistance = 100;
        const nodeSpeed = 0.3;

        let nodes = [];

        class Node {
            constructor() {
                this.x = Math.random() * canvas.width;
                this.y = Math.random() * canvas.height;
                this.speedX = (Math.random() - 0.5) * nodeSpeed;
                this.speedY = (Math.random() - 0.5) * nodeSpeed;
                this.radius = nodeRadius;
            }

            update() {
                this.x += this.speedX;
                this.y += this.speedY;

                // Bounce nodes off edges
                if (this.x < 0 || this.x > canvas.width) this.speedX *= -1;
                if (this.y < 0 || this.y > canvas.height) this.speedY *= -1;
            }

            draw() {
                // Set node color to 'rgba(0, 123, 255, 0.7)'
                ctx.fillStyle = 'rgba(0, 123, 255, 0.7)'; // Updated color
                ctx.beginPath();
                ctx.arc(this.x, this.y, this.radius, 0, Math.PI * 2);
                ctx.closePath();
                ctx.fill();
            }
        }

        function initNodes() {
            nodes = [];
            for (let i = 0; i < maxNodes; i++) {
                nodes.push(new Node());
            }
        }

        function drawLines() {
            for (let i = 0; i < nodes.length; i++) {
                for (let j = i + 1; j < nodes.length; j++) {
                    const dx = nodes[i].x - nodes[j].x;
                    const dy = nodes[i].y - nodes[j].y;
                    const distance = Math.sqrt(dx * dx + dy * dy);

                    if (distance < connectionDistance) {
                        // Set line color to 'rgba(0, 123, 255, 0.5)'
                        ctx.strokeStyle = `rgba(0, 123, 255, ${1 - distance / connectionDistance})`; // Updated line color
                        ctx.lineWidth = 0.5;
                        ctx.beginPath();
                        ctx.moveTo(nodes[i].x, nodes[i].y);
                        ctx.lineTo(nodes[j].x, nodes[j].y);
                        ctx.stroke();
                    }
                }
            }
        }

        function animate() {
            ctx.clearRect(0, 0, canvas.width, canvas.height);

            // Set the background color to a light color
            ctx.fillStyle = '#f4f8fb';
            ctx.fillRect(0, 0, canvas.width, canvas.height);

            nodes.forEach(node => {
                node.update();
                node.draw();
            });

            drawLines();
            requestAnimationFrame(animate);
        }

        initNodes();
        animate();

        window.addEventListener('resize', function() {
            canvas.width = canvas.offsetWidth;
            canvas.height = canvas.offsetHeight;
            initNodes();
        });
    </script>



</body>

</html>

<!-- Main Banner Ends -->

<script>
    window.addEventListener('scroll', function() {
        document.querySelector('header').classList.toggle('scrolled', window.scrollY > 50);
    });
</script>
<!-- Breadcrumb Starts -->

<!-- Breadcrumb Ends -->

<!-- Main Container Starts -->
<div class="container my-5">
    <!-- About Intro Text Starts -->
    <section class="welcome-area about" style="background: url(<?php echo base_url('uploads/frontend/about/' . $page_data['about_image']); ?>) no-repeat right center; background-size: 50%; padding: 50px; border-radius: 25px; box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);">
        <div class="row">
            <div class="col-lg-6 col-sm-12">
                <h3 class="main-heading1"><?php echo $page_data['title']; ?></h3>
                <h3 class="main-heading2"><?php echo $page_data['subtitle']; ?></h3>
                <p><?php echo $page_data['content']; ?></p>
            </div>
            <div class="col-md-6 col-sm-12 d-none d-md-block"></div>
        </div>
    </section>
    <!-- About Intro Text Ends -->
</div>


<div class="col-lg-12 col-sm-12 d-flex justify-content-center flex-column align-items-center text-center mb-5">
    <h3 class="main-heading1"><?php echo $page_data['team_title']; ?></h3>
    <h3 class="main-heading2"><?php echo $page_data['team_subtitle']; ?></h3>
</div>

<div class="container my-5" id="team-section">
    <section class="team-section">
        <div class="row">
            <!-- Team Member Loop Starts -->
            <?php
            $team = $this->db->get('front_cms_team_list')->result_array();
            foreach ($team as $key => $value) {
                $elements = json_decode($value['elements'], true);
            ?>
                <div class="col-md-4 mb-4">
                    <div class="team-card d-flex flex-column align-items-center p-4">
                        <div class="team-image-wrapper">
                            <div class="team-image-div">
                                <img src="<?php echo base_url('uploads/frontend/team/' . $elements['image']); ?>" alt="Team Member" class="team-image">
                            </div>
                            <div class="team-member-name mt-3 text-center">
                                <h6><?php echo $value['title']; ?></h6>
                                <p><?php echo $value['designation']; ?></p>
                            </div>
                        </div>
                        <div class="team-info mt-3 text-center">
                            <p class="team-description short-description">
                                <?php echo substr($value['description'], 0, 40); ?>...
                            </p>
                            <p class="team-description full-description" style="display: none;">
                                <?php echo $value['description']; ?>
                            </p>
                            <button class="btn btn-primary mt-3 read-more-btn">Read More</button>
                        </div>
                    </div>
                </div>
            <?php } ?>
            <!-- Team Member Loop Ends -->
        </div>
    </section>

    <!-- JavaScript for 'Read More' functionality -->
    <script>
        document.querySelectorAll('.read-more-btn').forEach(function(button) {
            button.addEventListener('click', function() {
                let fullDescription = this.previousElementSibling;
                if (fullDescription.style.display === 'none') {
                    fullDescription.style.display = 'block';
                    this.innerHTML = 'Read Less';
                } else {
                    fullDescription.style.display = 'none';
                    this.innerHTML = 'Read More';
                }
            });
        });
    </script>
</div>

    <!-- JavaScript for 'Read More' functionality -->
    <script>
        document.querySelectorAll('.read-more-btn').forEach(function(button) {
            button.addEventListener('click', function() {
                let fullDescription = this.previousElementSibling;
                if (fullDescription.style.display === 'none') {
                    fullDescription.style.display = 'block';
                    this.innerHTML = 'Read Less';
                } else {
                    fullDescription.style.display = 'none';
                    this.innerHTML = 'Read More';
                }
            });
        });
    </script>
</div>

<!-- General Styling -->
<style>
    .breadcrumb {
        background-color: #97d5ff42;

        margin-bottom: 15px;
        /* Optional: Adds space below the breadcrumb */
        font-size: 1rem;
        /* Optional: Adjusts font size */
    }

    .contact-section {
        position: relative;
        padding: 4rem 0;
        background-color: #f8f9fa;
        /* Light background for contrast */
    }

    .main-banner {
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
        color: white;
        padding: 1rem;
    }

    .main-banner h2 {
        font-weight: bold;
        text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.7);
    }

    /* General Styling */
    body {
        font-family: 'Arial', sans-serif;
        background-color: #f4f8fb;
        /* Light background for contrast */
    }

    .team-section {
        padding: 40px;
        background-color: #f8f9fa;
    }

    .team-card {
        width: 100%;
        background: #fff;
        padding: 20px;
        border-radius: 25px;
        transition: all 0.3s ease;
        text-align: center;
        box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
    }

    .team-card:hover {
        transform: translateY(-10px);
        box-shadow: 0px 8px 16px rgba(0, 0, 0, 0.2);
    }

    .team-image-wrapper {
        display: flex;
        flex-direction: column;
        align-items: center;
    }

    .team-image-div {
        width: 200px;
        height: 200px;
        background-color: #fdab38;
        /* Updated solid color */
        border-radius: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        overflow: hidden;
    }

    .team-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        border-radius: 50%;
    }

    .team-member-name {
        margin-top: 15px;
        text-align: center;
    }

    .team-member-name h6 {
        font-size: 1.3rem;
        font-weight: bold;
        color: #2C2C2C;
    }

    .team-member-name p {
        font-size: 1rem;
        color: #FF7058;
    }

    .team-info {
        margin-top: 20px;
    }

    .team-info .team-description {
        font-size: 1rem;
        color: #6c757d;
        margin-bottom: 15px;
    }

    .btn-primary {
        background-color: #007bff;
        border: none;
        color: white;
        padding: 10px 20px;
        font-size: 1rem;
        border-radius: 30px;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }

    .btn-primary:hover {
        background-color: #FFB37A;
    }
</style>

<script>
    function toggleDescription(button) {
        const description = button.nextElementSibling;
        if (description.style.display === "none") {
            description.style.display = "block";
            button.textContent = "Read Less";
        } else {
            description.style.display = "none";
            button.textContent = "Read More";
        }
    }
</script>

<!-- About Featured Section Starts -->
<section class="about-featured parallax" style="background-image: url(<?php echo base_url('uploads/frontend/about/' . $service['parallax_image']); ?>); padding: 50px 0; color: white; text-align: center;">
    <div class="container">
        <h3 class="section-title"><?php echo $service['title']; ?></h3>
        <h2 class="section-subtitle"><?php echo $service['subtitle']; ?></h2>
        <div class="row">
            <?php
            $services_list = $this->db->get('front_cms_services_list')->result_array();
            foreach ($services_list as $key => $value) {
            ?>
                <div class="col-lg-3 col-md-4 col-sm-6 mb-4 d-flex align-items-stretch">
                    <div class="feature-box">
                        <div class="icon-wrapper">
                            <i class="<?php echo $value['icon']; ?> fa-2x"></i>
                        </div>
                        <h4><?php echo $value['title']; ?></h4>
                        <p><?php echo $value['description']; ?></p>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
</section>

<!-- Styles -->
<style>
    /* Parallax Section Styling */
    .about-featured {
        position: relative;
        background-size: cover;
        background-position: center center;
        background-attachment: fixed;
        color: white;
        text-shadow: 0 4px 10px rgba(0, 0, 0, 0.3);
    }

    /* Section Title and Subtitle */
    .section-title {
        font-size: 1.8rem;
        /* Smaller font size */
        font-weight: 700;
        text-transform: uppercase;
        margin-bottom: 10px;
        color: #fff;
        letter-spacing: 1px;
        font-family: 'Roboto', sans-serif;
    }

    .section-subtitle {
        font-size: 1.2rem;
        /* Smaller font size */
        font-weight: 500;
        color: rgba(255, 255, 255, 0.8);
        font-family: 'Open Sans', sans-serif;
    }

    /* Feature Box Styling */
    .feature-box {
        padding: 15px;
        /* Smaller padding */
        border-radius: 10px;
        background: rgba(255, 255, 255, 0.9);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        text-align: center;
        color: #333;
        box-shadow: 0 6px 15px rgba(0, 0, 0, 0.2);
        position: relative;
        overflow: hidden;
        background-color: #f8f9fa;
        border: 1px solid #e0e0e0;
        z-index: 1;
    }

    .feature-box:hover {
        transform: translateY(-5px);
        box-shadow: 0 12px 24px rgba(0, 0, 0, 0.4);
    }

    .icon-wrapper {
        margin-bottom: 15px;
        /* Smaller margin */
        background: linear-gradient(135deg, #007bff, #f8f9fa);
        padding: 12px;
        /* Smaller padding */
        border-radius: 50%;
        display: inline-block;
        box-shadow: 0 6px 15px rgba(0, 0, 0, 0.2);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .icon-wrapper i {
        color: #fff;
    }

    .icon-wrapper:hover {
        transform: scale(1.1);
        box-shadow: 0 12px 24px rgba(0, 0, 0, 0.3);
    }

    .feature-box h4 {
        font-size: 1.1rem;
        /* Smaller heading size */
        font-weight: 600;
        margin-bottom: 10px;
        color: #333;
        font-family: 'Montserrat', sans-serif;
    }

    .feature-box p {
        font-size: 0.9rem;
        /* Smaller font size */
        color: #666;
        line-height: 1.5;
        font-family: 'Open Sans', sans-serif;
    }

    /* Footer Button Styling */
    .footer-top-bar {
        padding: 50px 0;
        background-color: #f8f9fa;
    }

    /* Hover and Active Effects for Cards */
    .feature-box:before {
        content: "";
        position: absolute;
        top: 50%;
        left: 50%;
        width: 130%;
        height: 130%;
        background-color: rgba(0, 0, 0, 0.1);
        border-radius: 50%;
        transform: translate(-50%, -50%) scale(0);
        transition: transform 0.4s ease;
        z-index: 0;
    }

    .feature-box:hover:before {
        transform: translate(-50%, -50%) scale(1);
    }

    /* Responsive Styling for Smaller Devices */
    @media (max-width: 768px) {
        .section-title {
            font-size: 1.6rem;
        }

        .section-subtitle {
            font-size: 1rem;
        }

        .feature-box {
            padding: 12px;
        }

        .feature-box h4 {
            font-size: 1rem;
        }

        .feature-box p {
            font-size: 0.85rem;
        }
    }
</style>

<!-- Include Swiper CSS -->
<link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />

<!-- Include Swiper JS -->
<script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>

<!-- About Featured Section Swiper Initialization -->
<script>
    var swiper = new Swiper('.swiper-container', {
        slidesPerView: 1, // You can adjust this based on how many slides you want visible at once
        spaceBetween: 30, // Space between slides
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
        loop: true, // Set to true if you want looping
        autoplay: {
            delay: 3000, // Auto-slide delay
            disableOnInteraction: false,
        },
        effect: 'slide', // You can change this to other effects like 'fade', 'cube', etc.
    });
</script>