<script src="https://code.jquery.com/jquery.js"></script>
<?php if (loggedin_role_id() != 4) { ?>
    <section class="panel-group" id="accordion">
        <div class="panel panel-accordion">
            <div class="panel-heading">
                <h4 class="panel-title">
                    <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion"
                        href="#client_filter_field"><?php echo translate('Select Grounds For Filter'); ?></a>
                </h4>
            </div>

            <div id="client_filter_field"
                class="accordion-body collapse <?php echo ($this->session->flashdata('active_box') == 1 ? 'in' : ''); ?>">
                <?php echo form_open($this->uri->uri_string()); ?>
                <div class="panel-body">
                    <?php if (in_array(loggedin_role_id(), array(1, 2))) { ?>
                        <div class="col-md-4 mb-lg">
                            <div class="form-group <?= form_error('client_id') ? 'has-error' : null ?>">
                                <label for="client_id" class="control-label">
                                    <?php
                                    echo translate('Client_list');
                                    ?>
                                    <span class="required"></span>
                                </label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fas fa-users"></i></span>
                                    <select class="form-control" data-plugin-selectTwo data-width="100%"
                                        name="client_id"
                                        id="client_id">
                                        <?php /** @var array<array> $nasList */ ?>
                                        <?php if (empty($client_id_list)): ?>
                                            <option value=""><?= translate('No Client Found'); ?></option>
                                        <?php else: ?>
                                            <option value=""><?= translate('Select A Client') ?></option>
                                            <?php foreach ($client_id_list as $client_id): ?>
                                                <option value="<?= $client_id->id ?>" <?= set_select('client_id', $client_id->id) ?>>
                                                    <?= html_escape($client_id->staff_id . '--' . $client_id->name) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>

                                    </select>
                                    <span class="error"><?= form_error('client_id'); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    <div class="col-md-6 mb-lg">
                        <div class="form-group">
                            <label class="control-label" for="daterange"><?php echo translate('date'); ?> <span class="required"></span></label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="fas fa-calendar-check"></i></span>
                                <input type="text" class="form-control daterange" id="daterange" name="daterange"
                                    value="<?php echo set_value('daterange', date("Y/m/1") . ' - ' . date("Y/m/d")); ?>"
                                    required />
                            </div>
                        </div>
                    </div>
                </div>

                <footer class="panel-footer">
                    <div class="row">
                        <div class="col-md-offset-10 col-md-2">
                            <button type="button" name="btn-filter" id="btn-filter" value="1"
                                class="btn btn btn-default btn-block"><i
                                    class="fas fa-filter"></i> <?php echo translate('filter'); ?></button>
                        </div>
                    </div>
                </footer>
                <?php echo form_close(); ?>
            </div>
        </div>
    </section>
<?php } ?>
<section class="panel">
    <div class="tabs-custom">
        <ul class="nav nav-tabs">
            <?php if (get_permission('refund', 'is_view')) { ?>
                <li class="<?php echo (!isset($validation_error) ? 'active' : ''); ?>">
                    <a href="#list" data-toggle="tab"><i
                            class="fas fa-list-ul"></i> <?php echo translate('Meal') . " " . translate('History'); ?>
                    </a>
                </li>
            <?php } ?>
        </ul>

        <div class="tab-content">
            <div id="list" class="tab-pane <?php echo (!isset($validation_error) ? 'active' : ''); ?>">
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive mb-sm mt-xs">
                            <?php $this->datatables->generate('dt_authors'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
    // Datatable ajax
    $("#btn-filter").click(function() {
        erTable_dt_authors.ajax.reload();
    });
</script>
<script type="text/javascript">
    function make_refund(id) {
        $.ajax({
            url: "<?php echo base_url('nas/get_meal/'); ?>" + id,
            type: "GET",
            success: function(response) {
                const data = JSON.parse(response);
                if (data.status === 'success') {
                    let checkboxHtml = '';
                    if (data.meals.breakfast) {
                        checkboxHtml += '<input type="checkbox" id="refund_breakfast" value="breakfast"> <label for="refund_breakfast">Breakfast</label><br>';
                    }
                    if (data.meals.lunch) {
                        checkboxHtml += '<input type="checkbox" id="refund_lunch" value="lunch"> <label for="refund_lunch">Lunch </label><br>';
                    }
                    if (data.meals.dinner) {
                        checkboxHtml += '<input type="checkbox" id="refund_dinner" value="dinner"> <label for="refund_dinner">Dinner </label><br>';
                    }

                    swal({
                        title: "<?php echo translate('select_meals_to_refund'); ?>",
                        html: checkboxHtml,
                        showCancelButton: true,
                        confirmButtonText: "<?php echo translate('yes_continue'); ?>",
                        cancelButtonText: "<?php echo translate('cancel'); ?>",
                        buttonsStyling: false,
                        preConfirm: () => {
                            let selectedMeals = [];
                            if ($('#refund_breakfast').is(':checked')) selectedMeals.push('breakfast');
                            if ($('#refund_lunch').is(':checked')) selectedMeals.push('lunch');
                            if ($('#refund_dinner').is(':checked')) selectedMeals.push('dinner');
                            if (selectedMeals.length === 0) {
                                swal.showValidationMessage('Please select at least one meal.');
                            }
                            return selectedMeals;
                        }
                    }).then((result) => {
                        if (result.value) {
                            $.ajax({
                                url: "<?php echo base_url('nas/refund_client/'); ?>" + id,
                                type: "POST",
                                data: {
                                    meals: result.value
                                },
                                success: function(response) {
                                    const res = JSON.parse(response);
                                    swal({
                                        title: res.status === 'success' ? 'Success' : 'Error',
                                        text: res.message,
                                        type: res.status,
                                        confirmButtonClass: "btn btn-default swal2-btn-default",
                                        buttonsStyling: false
                                    }).then(() => {
                                        if (res.status === 'success') {
                                            window.location.reload(true);
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            }
        });
    }
    function cancel_refund(id) {
    swal({
        title: "Are you sure?",
        text: "Do you want to cancel this refund request?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Yes, cancel it!",
        cancelButtonText: "No, keep it",
        buttonsStyling: false
    }).then((result) => {
        if (result.value) {
            $.ajax({
                url: "<?php echo base_url('nas/cancel_refund/'); ?>" + id,
                type: "POST",
                success: function(response) {
                    const res = JSON.parse(response);
                    swal({
                        title: res.status === 'success' ? 'Cancelled' : 'Error',
                        text: res.message,
                        type: res.status,
                        confirmButtonClass: "btn btn-default swal2-btn-default",
                        buttonsStyling: false
                    }).then(() => {
                        if (res.status === 'success') {
                            window.location.reload(true);
                        }
                    });
                }
            });
        }
    });
}

</script>


<!-- Jquery Datatables JS -->
<script src="<?php echo base_url('assets/vendor/datatables/media/js/jquery.dataTables.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/media/js/dataTables.bootstrap.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/dataTables.buttons.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.bootstrap.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.html5.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.print.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.colVis.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/JSZip-2.5.0/jszip.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/pdfmake-0.1.32/pdfmake.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/pdfmake-0.1.32/vfs_fonts.js'); ?>"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" />

<?php $this->datatables->jquery('dt_authors'); ?>