
<!-- Packages Section Starts -->
<div class="container py-5">
    <div class="row">
        <!-- Loop through each package from the database -->
        <?php foreach ($packages as $package): ?>
            <div class="col-md-4 col-sm-12 mb-4">
                <div class="package-box stylish-package-box">
                    <h3 class="package-title"><?php echo $package['title']; ?></h3>
                    <p class="package-price"><?php echo $package['price']; ?> / month</p>
                    <ul class="package-features list-unstyled">
                        <?php foreach (explode(',', $package['features']) as $feature): ?>
                            <li><i class="fas fa-check"></i> <?php echo $feature; ?></li>
                        <?php endforeach; ?>
                    </ul>
                    <div class="package-button text-center">
                        <a href="<?php echo base_url('purchase/' . $package['id']); ?>" class="btn btn-primary">Get Started</a>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<!-- Custom Styles for Package Page -->
<style>
    .stylish-package-box {
        background-color: #fff;
        border-radius: 8px;
        border: 1px solid #ddd;
        padding: 20px;
        text-align: center;
        transition: all 0.3s ease;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }
    .stylish-package-box:hover {
        box-shadow: 0 6px 12px rgba(0, 0, 0, 0.2);
        transform: translateY(-5px);
    }
    .package-title {
        font-size: 24px;
        font-weight: bold;
        color: #333;
    }
    .package-price {
        font-size: 28px;
        color: #5bc0de;
        margin: 10px 0;
    }
    .package-features {
        padding: 0;
        margin: 15px 0;
    }
    .package-features li {
        margin-bottom: 10px;
        color: #666;
        font-size: 16px;
    }
    .package-features li i {
        color: #5bc0de;
        margin-right: 10px;
    }
    .package-button .btn {
        background-color: #5bc0de;
        border: none;
        transition: background-color 0.3s ease;
    }
    .package-button .btn:hover {
        background-color: #31b0d5;
    }
</style>
