<main class="main">

    <!-- Hero Section -->
    <section id="hero" class="hero section">

        <div class="container">
            <div class="row gy-4">
                <div class="col-lg-6 order-2 order-lg-1 d-flex flex-column justify-content-center">
                    <h1 data-aos="fade-up">We offer modern solutions for growing your business</h1>
                    <p data-aos="fade-up" data-aos-delay="100">We are team of talented designers making websites with Bootstrap</p>
                    <div class="d-flex flex-column flex-md-row" data-aos="fade-up" data-aos-delay="200">
                        <a href="#about" class="btn-get-started">Get Started <i class="bi bi-arrow-right"></i></a>
                        <a href="https://www.youtube.com/watch?v=HDUPCnERYpE" class="glightbox btn-watch-video d-flex align-items-center justify-content-center ms-0 ms-md-4 mt-4 mt-md-0"><i class="bi bi-play-circle"></i><span>Watch Video</span></a>
                    </div>
                </div>
                <div class="col-lg-6 order-1 order-lg-2 hero-img" data-aos="zoom-out">
                    <img src="assets/img/hero-img.png" class="img-fluid animated" alt="">
                </div>
            </div>
        </div>

    </section><!-- /Hero Section -->
    <!-- Features Section -->

    <!-- About Section -->
    <section id="about" class="about section">

        <div class="container" data-aos="fade-up">
            <div class="row gx-0">
                <?php
                $wellcome = $this->db->get_where('front_cms_home', array('item_type' => 'wellcome'))->row_array();
                $elements = json_decode($wellcome['elements'], true);
                ?>

                <div class="col-lg-6 d-flex flex-column justify-content-center" data-aos="fade-up" data-aos-delay="200">
                    <div class="content">
                        <h3><?php echo $wellcome['title']; ?></h3>
                        <h2><?php echo $wellcome['subtitle']; ?></h2>
                        <p><?php echo nl2br($wellcome['description']); ?></p>
                        <div class="text-center text-lg-start">
                            <a href="#" class="btn-read-more d-inline-flex align-items-center justify-content-center align-self-center">
                                <span>Read More</span>
                                <i class="bi bi-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6 d-flex align-items-center" data-aos="zoom-out" data-aos-delay="200">
                    <img src="<?php echo base_url('uploads/frontend/home_page/' . $elements['image']); ?>" class="img-fluid" alt="">
                </div>
                <style>
                    .img-fluid {
                        max-width: 185%;
                        height: auto;
                    }
                </style>

            </div>
        </div>

    </section><!-- /About Section -->


    <!-- Features Section -->
    <section id="values" class="values section">

        <!-- Section Title -->
        <div class="container section-title" data-aos="fade-up">
            <h2>Our Values</h2>
            <p>What we value most<br></p>
        </div><!-- End Section Title -->
        <div class="container">
            <div class="row gy-4">
                <div class="container">
                    <div class="row">
                        <?php
                        $features = $this->db->get_where('front_cms_home', array('item_type' => 'features'))->result();
                        $count = 0; // Counter to track the number of items per row
                        foreach ($features as $feature) {
                            $elements = json_decode($feature->elements, true);

                            // Start a new row if $count is 0
                            if ($count % 3 === 0 && $count !== 0) {
                                echo '</div><div class="row mt-3">';
                            }
                        ?>
                            <div class="col-lg-4 mb-3" data-aos="fade-up" data-aos-delay="100"> <!-- Add margin-bottom for spacing -->
                                <div class="card feature-card text-center">
                                    <div class="feature-icon d-flex align-items-center justify-content-center mx-auto">
                                        <!-- Ensure the icon class is properly set -->
                                        <i class="<?php echo htmlspecialchars($elements['icon']); ?> fs-1 icon-color"></i>
                                    </div>
                                    <h3><?php echo htmlspecialchars($feature->title); ?></h3>
                                    <p><?php echo htmlspecialchars($feature->description); ?></p>
                                </div>
                            </div>
                        <?php
                            $count++; // Increment the counter
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>

        <style>
            /* Default styles for feature cards */
            .feature-card {
                border: none;
                padding: 20px;
                background-color: #f8f9fa;
                border-radius: 8px;
                box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
                transition: transform 0.3s ease, box-shadow 0.3s ease;
            }


            /* Icon container */
            .feature-icon {
                width: 65px;
                height: 65px;
                border-radius: 50%;
                background-color: #007bff;
                /* Default circle color */
                color: #fff;
                display: flex;
                align-items: center;
                justify-content: center;
                margin-bottom: 15px;
                transition: background-color 0.3s ease, transform 0.3s ease;
                font-size: 1.5rem;

            }

            /* Hover effect for icon container */
            .feature-card:hover .feature-icon {
                background-color: #ff5722;
                /* Hover circle color */
                transform: scale(1.1);
            }

            /* Default icon styles */
            .icon-color {
                /* Ensure the icon size is noticeable */
                transition: transform 0.3s ease, color 0.3s ease;
            }

            .feature-card:hover .icon-color {
                color: #fff;
                /* Ensure icon color contrasts with hover background */
            }
        </style>



    </section><!-- /Features Section -->


    <!-- Stats Section -->
    <section id="stats" class="stats section">

        <div class="container" data-aos="fade-up" data-aos-delay="100">

            <div class="row gy-4">

                <div class="col-lg-3 col-md-6">
                    <div class="stats-item d-flex align-items-center w-100 h-100">
                        <i class="bi bi-emoji-smile color-blue flex-shrink-0"></i>
                        <div>
                            <span data-purecounter-start="0" data-purecounter-end="232" data-purecounter-duration="1" class="purecounter"></span>
                            <p>Happy Clients</p>
                        </div>
                    </div>
                </div><!-- End Stats Item -->

                <div class="col-lg-3 col-md-6">
                    <div class="stats-item d-flex align-items-center w-100 h-100">
                        <i class="bi bi-journal-richtext color-orange flex-shrink-0" style="color: #ee6c20;"></i>
                        <div>
                            <span data-purecounter-start="0" data-purecounter-end="521" data-purecounter-duration="1" class="purecounter"></span>
                            <p>Projects</p>
                        </div>
                    </div>
                </div><!-- End Stats Item -->

                <div class="col-lg-3 col-md-6">
                    <div class="stats-item d-flex align-items-center w-100 h-100">
                        <i class="bi bi-headset color-green flex-shrink-0" style="color: #15be56;"></i>
                        <div>
                            <span data-purecounter-start="0" data-purecounter-end="1463" data-purecounter-duration="1" class="purecounter"></span>
                            <p>Hours Of Support</p>
                        </div>
                    </div>
                </div><!-- End Stats Item -->

                <div class="col-lg-3 col-md-6">
                    <div class="stats-item d-flex align-items-center w-100 h-100">
                        <i class="bi bi-people color-pink flex-shrink-0" style="color: #bb0852;"></i>
                        <div>
                            <span data-purecounter-start="0" data-purecounter-end="15" data-purecounter-duration="1" class="purecounter"></span>
                            <p>Hard Workers</p>
                        </div>
                    </div>
                </div><!-- End Stats Item -->

            </div>

        </div>

    </section><!-- /Stats Section -->
    <!-- Services Section -->
    <section id="services" class="services section">
        <div class="container">
            <div class="row gy-4">
                <?php
                $services_list = $this->db->get('front_cms_services_list')->result_array();

                // Define colors for the sections
                $firstColors = ['#0dcaf0', '#fd7e14', '#20c997']; // Colors for the first 3 cards
                $secondColors = ['#ffc107', '#6610f2', '#f3268c']; // Colors for the second 3 cards
                $thirdColors = ['#6f42c1', '#198754', '#df1529']; // Colors for the remaining cards

                foreach ($services_list as $key => $value) {
                    // Determine color scheme based on index
                    if ($key < 3) {
                        $hoverColor = $firstColors[$key];
                    } elseif ($key < 6) {
                        $hoverColor = $secondColors[$key - 3];
                    } else {
                        $hoverColor = $thirdColors[($key - 6) % 3]; // Cycle colors for remaining cards
                    }
                ?>

                    <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="100">
                        <div class="service-item item-cyan position-relative" style="transition: transform 0.3s, background-color 0.3s;">
                            <i class="<?php echo $value['icon']; ?> icon mb-3 fs-2" style="transition: color 0.3s;"></i>
                            <h3><?php echo $value['title']; ?></h3>
                            <p><?php echo $value['description']; ?></p>
                            <a href="#" class="read-more stretched-link">
                                <span>Read More</span> <i class="bi bi-arrow-right"></i>
                            </a>
                        </div>
                    </div><!-- End Service Item -->


                <?php } ?>
            </div>
        </div>
    </section><!-- /Services Section -->

    <!-- Pricing Section -->
    <section id="pricing" class="pricing section">

        <!-- Section Title -->
        <div class="container section-title" data-aos="fade-up">
            <h2>Pricing</h2>
            <p>Check Our Affordable Pricing<br></p>
        </div><!-- End Section Title -->

        <div class="container">


            <div class="row gy-4">
                <?php foreach ($packages as $thisPackage) : ?>
                    <?php if ($thisPackage->manager_id == 1 && $thisPackage->privacy === 'public') : ?>


                        <div class="col-lg-3 col-md-6" data-aos="zoom-in" data-aos-delay="100">
                            <div class="pricing-tem">
                                <h3 style="color: #20c997;"><?php echo html_escape($thisPackage->name); ?></h3>
                                <div class="price"><sup>৳</sup><?php echo html_escape($thisPackage->retail_price); ?><span> / mo</span></div>
                                <div class="icon">
                                    <i class="bi bi-box" style="color: #20c997;"></i>
                                </div>
                                <ul>
                                    <li> Connection Charge: Free</li>
                                    <li> 24/7 Helpdesk Support</li>
                                    <li> Real IP on Demand</li>
                                    <li> Up to 200 Mbps</li>

                                </ul>
                                <a href="#" class="btn-buy">Buy Now</a>
                            </div>
                        </div><!-- End Pricing Item -->
                    <?php endif; ?>
                <?php endforeach; ?>

            </div><!-- End pricing row -->

        </div>

    </section><!-- /Pricing Section -->


    <!-- Team Section -->
    <section id="team" class="team section">

        <!-- Section Title -->
        <div class="container section-title" data-aos="fade-up">
            <h2>Team</h2>
            <p><?php echo $page_data['team_title']; ?></p>
            <h5><?php echo $page_data['team_subtitle']; ?></h5>
            <section class="team-slider-section">
                <div class="swiper-container blog-slider">

                    <div class="swiper-wrapper">
                        <!-- Team Member Slide Loop Starts -->
                        <?php
                        $team = $this->db->get('front_cms_team_list')->result_array();
                        foreach ($team as $key => $value) {
                            $elements = json_decode($value['elements'], true);
                        ?>
                            <div class="swiper-slide">
                                <div class="team-card-slider d-flex align-items-center p-4">
                                    <div class="team-image-wrapper-slider">
                                        <div class="team-image-div">
                                            <img src="<?php echo base_url('uploads/frontend/team/' . $elements['image']); ?>" alt="Team Member" class="team-image-slider">
                                            <br>
                                            <h6><?php echo $value['title']; ?></h6>
                                            <p>ISPM</p>
                                        </div>
                                    </div>
                                    <div class="team-info-slider ml-4">
                                        <h4 class="team-designation"><?php echo $value['designation']; ?></h4>
                                        <p class="team-description short-description">
                                            <?php echo substr($value['description'], 0, 250); ?>...
                                        </p>
                                        <p class="team-description full-description" style="display: none;">
                                            <?php echo $value['description']; ?>
                                        </p>
                                        <button class="btn btn-primary mt-3 read-more-btn" style="margin: -19px;">Read More</button>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                        <!-- Team Member Slide Loop Ends -->
                    </div>
                    <!-- Swiper Pagination -->
                    <div class="blog-slider__pagination"></div>
                </div>
                <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Swiper/4.3.5/css/swiper.min.css" />
            </section>
            <style>
                /* General Styling */
                body {
                    font-family: 'Arial', sans-serif;
                    background-color: #f8f9fa;
                    margin: 0;
                    padding: 0;
                }

                .team-slider-section {
                    padding: 20px 0;
                    /* Increased padding for more vertical space */
                    background-color: #white;
                    display: flex;
                    justify-content: center;
                }

                .team-card-slider {
                    width: 200%;
                    /* Set width to 98% */
                    position: relative;
                    /* Added position relative */
                    max-width: 1025px;
                    /* Set max width to 1050px */
                    margin: auto;
                    /* Center the card */
                    background: #d4eeff;
                    /* Background color */
                    padding: 35px;
                    /* Padding */
                    border-radius: 35px;
                    height: 400px;
                    transition: all 0.3s;
                }

                .team-image-wrapper-slider {
                    flex-shrink: 0;
                    /* Prevent shrinking */
                }

                .team-image-div {
                    text-align: center;
                    width: 250px;
                    height: 250px;
                    flex-shrink: 0;
                    background-image: linear-gradient(to right, #70bafe 0%, #998dff 51%, #70bafe 100%);
                    /* box-shadow: 4px 13px 30px 1px rgba(170, 113, 38, 0.159); */
                    border-radius: 35px;
                    transform: translateX(-80px);
                    overflow: hidden;
                }

                .team-image-slider {
                    width: 150px;
                    /* Set width of the image */
                    height: 150px;
                    /* Set height of the image */
                    object-fit: cover;
                    /* Ensure the image covers the entire div */
                    border-radius: 50%;
                    margin-top: 5%;
                    margin-bottom: 5%;
                    /* Make the image circular */
                }

                .team-info-slider {
                    text-align: center;
                    padding-right: 176px;
                    opacity: 1;
                    transform: none;
                }


                .team-info-slider h4 {
                    font-size: 1.5rem;
                    margin-bottom: 10px;
                    color: #2C2C2C;
                }

                .team-info-slider .team-designation {
                    font-size: 2rem;
                    font-weight: 500;
                    color: #000;
                    margin-bottom: 10px;
                }

                .team-info-slider .team-description {
                    font-size: 13px;
                    line-height: 24px;
                    color: #232323;

                }



                /* Swiper specific styles */
                .swiper-container {
                    width: 100%;
                    height: 100%;

                }

                .swiper-slide {
                    display: flex;
                    justify-content: center;

                }

                .blog-slider__pagination {
                    position: absolute;
                    z-index: 21;
                    right: 90px;
                    width: 11px !important;
                    text-align: center;
                    left: auto !important;
                    top: 50%;
                    bottom: auto !important;
                    transform: translateY(-50%);
                    line-height: 14px;

                }

                .blog-slider__pagination .swiper-pagination-bullet {
                    background: #0000FF;
                    opacity: 0.7;
                }

                .blog-slider__pagination .swiper-pagination-bullet-active {
                    background: #00FFFF;
                    opacity: 1;
                }

                /* Responsive Design */
                @media (max-width: 768px) {
                    .main-heading1 {
                        font-size: 2rem;
                    }

                    .main-heading2 {
                        font-size: 1.2rem;
                    }
                }

                @media (max-width: 480px) {
                    .main-heading1 {
                        font-size: 1.75rem;
                    }

                    .main-heading2 {
                        font-size: 1rem;
                    }
                }
            </style>


            <!-- Swiper JS -->
            <script src="https://cdnjs.cloudflare.com/ajax/libs/Swiper/4.3.5/js/swiper.min.js"></script>
            <script>
                var swiper = new Swiper('.blog-slider', {
                    spaceBetween: 30,
                    effect: 'fade',
                    loop: true,
                    mousewheel: {
                        invert: false,
                    },
                    pagination: {
                        el: '.blog-slider__pagination',
                        clickable: true,
                    },
                    autoplay: {
                        delay: 5000,
                        disableOnInteraction: false,
                    },
                });
            </script>

            <style>
                /* Adjust header sizes for responsiveness */
                .main-heading1 {
                    font-size: 2.5rem;
                    font-weight: 700;
                    color: #333;
                    margin-bottom: 1rem;
                }

                .main-heading2 {
                    font-size: 1.5rem;
                    font-weight: 400;
                    color: #555;
                    margin-bottom: 2rem;
                }

                /* Responsive Design */
                @media (max-width: 768px) {
                    .main-heading1 {
                        font-size: 2rem;
                    }

                    .main-heading2 {
                        font-size: 1.2rem;
                    }
                }

                @media (max-width: 480px) {
                    .main-heading1 {
                        font-size: 1.75rem;
                    }

                    .main-heading2 {
                        font-size: 1rem;
                    }
                }
            </style>

            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    const readMoreButtons = document.querySelectorAll('.read-more-btn');

                    readMoreButtons.forEach(button => {
                        button.addEventListener('click', function() {
                            const fullDescription = this.previousElementSibling; // Get the full description element

                            if (fullDescription.style.display === 'none' || fullDescription.style.display === '') {
                                fullDescription.style.display = 'block'; // Show full description
                                this.innerText = 'Read Less'; // Change button text
                            } else {
                                fullDescription.style.display = 'none'; // Hide full description
                                this.innerText = 'Read More'; // Reset button text
                            }
                        });
                    });
                });
            </script>



        </div><!-- End Section Title -->


    </section><!-- /Team Section -->



    <?php $testimonial = $this->db->get_where('front_cms_home', array('item_type' => 'testimonial'))->row_array(); ?>

    <!-- Testimonials Section -->
    <section id="testimonials" class="testimonials section">

        <!-- Section Title -->
        <div class="container section-title" data-aos="fade-up">
            <h2>Testimonials</h2>
            <p><?php echo $testimonial['title'] ?><br></p>
            <h6><?php echo nl2br($testimonial['description']); ?><br></h6>

        </div><!-- End Section Title -->

        <div class="container" data-aos="fade-up" data-aos-delay="100">

            <div class="swiper init-swiper">
                <script type="application/json" class="swiper-config">
                    {
                        "loop": true,
                        "speed": 600,
                        "autoplay": {
                            "delay": 5000
                        },
                        "slidesPerView": "auto",
                        "pagination": {
                            "el": ".swiper-pagination",
                            "type": "bullets",
                            "clickable": true
                        },
                        "breakpoints": {
                            "320": {
                                "slidesPerView": 1,
                                "spaceBetween": 40
                            },
                            "1200": {
                                "slidesPerView": 3,
                                "spaceBetween": 1
                            }
                        }
                    }
                </script>
                <div class="swiper-wrapper">
                    <?php
                    $testimonials = $this->db->get('front_cms_testimonial')->result_array();
                    foreach ($testimonials as $value) {
                    ?>

                        <div class="swiper-slide">
                            <div class="testimonial-item">
                                <div class="stars">
                                    <?php
                                    for ($i = 1; $i < 6; $i++) {
                                        echo $i <= $value['rank'] ? '<i class="fas fa-star"></i>' : '<i class="far fa-star"></i>';
                                    }
                                    ?>
                                </div>
                                <p><?php echo nl2br($value['description']); ?></p>
                                <div class="profile mt-auto">
                                    <img src="<?php echo $this->app_lib->get_image_url('testimonial/' . $value['image']); ?>" class="testimonial-img" alt="" style="width: 90px; height: 90px;">
                                    <h3><?php echo $value['patient_name']; ?></h3>
                                    <h4><?php echo $value['surname']; ?></h4>
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                    <!-- End testimonial item -->


                </div>
                <div class="swiper-pagination"></div>
            </div>

        </div>

    </section><!-- /Testimonials Section -->



    <!-- Clients Section -->
    <section id="clients" class="clients section">

        <!-- Section Title -->
        <div class="container section-title" data-aos="fade-up">
            <h2>Clients</h2>
            <p>We work with best clients<br></p>
        </div><!-- End Section Title -->

        <div class="container my-5" id="team-section">
                <div class="row">
                    <!-- Team Member Loop Starts -->
                    <?php
                    $client = $this->db->get('front_cms_client_list')->result_array();
                    foreach ($client as $key => $value) {
                        $elements = json_decode($value['elements'], true);
                    ?>
                        <div class="col-md-3 mb-4">
                            <div class="client-card d-flex flex-column align-items-center p-4">
                                <div class="client-image-wrapper">
                                    <div class="client-image-div">
                                        <img src="<?php echo base_url('uploads/frontend/client/' . $elements['image']); ?>" alt="Client Member" class="client-image">
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    <!-- Team Member Loop Ends -->
                </div>

        </div>
        <style>
            /* Cover Background */
            .cover {
                background-color: #5a9cf7;
                padding: 60px 0;
            }

            /* Client Card Styles */
            .client-card {
                padding: 20px 20px;
                transition: all 0.35s cubic-bezier(0.4, 0, 0.2, 1);
                border: 1px solid #c3c3c3;
                background: #fff;
                /* Ensures the card has a white background */
                border-radius: 8px;
                /* Adds rounded corners */
                box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
                /* Subtle default shadow */
            }

            /* Hover Effect */
            .client-card:hover {
                box-shadow: 0 8px 16px rgba(90, 156, 247, 0.6);
                /* Sky blue shadow on hover */
                transform: translateY(-5px);
                /* Adds a slight lift effect */
                transition: all 0.3s ease-in-out;
                /* Smooth animation */
            }

            /* Image Styles */
            .client-image {
                height: 60px;
                /* Fixed height for the image */
                max-width: 100%;

                vertical-align: top;

            }

            /* Container Styling */
            .container {
                max-width: 1200px;
                margin: 0 auto;
            }
        </style>
     

    </section><!-- /Clients Section -->



    <!-- Faq Section -->
    <section id="faq" class="faq section">

        <!-- Section Title -->
        <div class="container section-title" data-aos="fade-up">
            <h2>F.A.Q</h2>
            <p>Frequently Asked Questions</p>
        </div><!-- End Section Title -->

        <div class="container">

            <div class="row">
                <?php
                $faq_list = $this->db->get('front_cms_faq_list')->result_array();
                foreach ($faq_list as $key => $value) {
                ?>
                    <div class="col-lg-6" data-aos="fade-up" data-aos-delay="100">

                        <div class="faq-container">

                            <div class="faq-item faq-active">
                                <h3><?php echo $value['title'] ?></h3>
                                <div class="faq-content">
                                    <p><?php echo $value['description']; ?></p>
                                </div>
                                <i class="faq-toggle bi bi-chevron-right"></i>
                            </div><!-- End Faq item-->

                        </div>

                    </div><!-- End Faq Column-->
                <?php } ?>

            </div>

        </div>
    </section><!-- /Faq Section -->

    <!-- Header Section -->

    <div class="footer-newsletter">
        <div class="container">
            <div class="row justify-content-center text-center">
                <div class="col-lg-6">
                    <h4><?php
                        $elements = json_decode($page_data['elements'], true);
                        echo $elements['cta_title'];
                        ?></h4>
                    <a href="<?php echo $elements['button_url'] ?>" class="btn btn-primary btn-lg text-uppercase" style="background-color:rgb(57, 146, 254); color: white; padding: 10px 10px; border-radius: 5px;">
                        <?php echo $elements['button_text']; ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <style>
        .container {
            padding: 20px;
        }

        .btn-primary {

            background-image: linear-gradient(to right, #70bafe 0%, #998dff 51%, #70bafe 100%);
            color: white;
            padding: 10px 22px;
            border-radius: 26px;
            color: var(--contrast-color);
            font-size: 11px;
            padding: 6px 21px;
            margin: 0 0 0 30px;
            border-radius: 4px;
            transition: 0.3s;
            font-weight: 300;
        }
    </style>


</main>