<div class="page-title">
    <div class="heading">
        <div class="container">
            <div class="row d-flex justify-content-center text-center">
                <div class="col-lg-8">
                    <h1><?php echo $page_data['page_title']; ?></h1>
                    <p class="mb-0"><?php echo $page_data['description']; ?></p>
                </div>
            </div>
        </div>
    </div>
    <nav class="breadcrumbs">
        <div class="container">
            <ol>
                <li><a href="<?php echo base_url('home') ?>">Home</a></li>
                <li class="current"><?php echo $page_data['page_title']; ?></li>
            </ol>
        </div>
    </nav>
</div>
<!-- End Page Title -->
<!-- Main Container Starts -->
<div class="container section-title" data-aos="fade-up">
    <h2><?php echo $page_data['page_title']; ?></h2>
</div><!-- End Section Title -->
<div class="container">

    <section class="team-section">

        <div class="row">
            <!-- Team Member Card Loop Starts -->
            <?php
            $payment = $this->db->get_where('front_cms_payment_list')->result_array();
            foreach ($payment as $key => $value) {
                $elements = json_decode($value['elements'], true);
                $unique_class = "payment-card-" . $key;
            ?>
                <div class="col-12 <?php echo $unique_class; ?>">
                    <div class="payment-card">
                        <!-- First Section: Payment Title -->
                        <div class="payment-title">
                            <h3><?php echo $value['title']; ?></h3>
                        </div>
                        <!-- Second Section: Payment Image -->
                        <div class="payment-image-wrapper">
                            <img src="<?php echo base_url('uploads/frontend/payment/' . $elements['image']); ?>" alt="Payment Member" class="img-fluid payment-image">
                        </div>
                        <!-- <div class="payment-content">
                            <p><?php echo $value['description']; ?></p>
                        </div> -->
                    </div>
                </div>


            <?php } ?>
            <!-- Team Member Card Loop Ends -->
        </div>

    </section>
    <div class="payment-button text-center mt-3">
        <a href="#" class="btn btn-primary btn-sm">PAY VIA CARD</a>
    </div>
</div>
<style>
    .payment-button .btn {
        background-color: #007bff;
        color: white;
        font-size: 0.9rem;
        font-weight: 600;
        padding: 8px 16px;
        border-radius: 20px;
        transition: background-color 0.3s ease;
        text-transform: uppercase;
    }

    .payment-button .btn:hover {
        background-color: #0056b3;
    }

    /* Payment Card Styling */
    .payment-card {
        width: 100%;
        background-color: #fff;
        border-radius: 8px;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        margin-bottom: 30px;
        overflow: hidden;
    }

    /* Payment Title Styling */
    .payment-title {
        background-color: rgba(27, 155, 224, 0.8);
        /* Light blue overlay */
        color: #003366;
        text-align: center;
        padding: 30px 0;
        font-size: 25px;
        font-weight: bold;
    }

    /* Payment Image Wrapper Styling */
    .payment-image-wrapper {
        width: 100%;
        overflow: hidden;
    }

    .payment-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        /* Ensures the image fills the container */
        transition: all 0.3s ease;
    }

    /* Payment Content Styling (Optional) */
    .payment-content {
        padding: 20px;
        background-color: #f8f9fa;
        /* Light gray background */
        text-align: center;
    }

    /* Responsive Styles */
    @media (max-width: 767px) {
        .payment-title {
            font-size: 1.25rem;
            padding: 20px 0;
        }

        .payment-image-wrapper {
            height: 250px;
            /* Adjust height for small screens */
        }
    }

    .col-12 {
        margin-bottom: 30px;
    }
</style>
<style>
    .breadcrumb {
        background-color: #97d5ff42;

        margin-bottom: 15px;
        /* Optional: Adds space below the breadcrumb */
        font-size: 1rem;
        /* Optional: Adjusts font size */
    }

    .contact-section {
        position: relative;
        padding: 4rem 0;
        background-color: #f8f9fa;
        /* Light background for contrast */
    }

    .main-banner {
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
        color: white;
        padding: 1rem;
    }

    .main-banner h2 {
        font-weight: bold;
        text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.7);
    }

    /* General Styling */
    body {
        font-family: 'Arial', sans-serif;
        background-color: #f4f8fb;
        /* Light background for contrast */
    }
</style>