<div class="container my-5">
  <div class="row justify-content-center">
    <!-- Left Side: Title + Description only -->
    <div class="col-lg-5 mb-4">
      <div class="p-4 rounded bg-white shadow-sm h-100 border border-light">
        <h1 class="fw-bold text-primary mb-3">
          <?php echo $page_data['page_title']; ?>
        </h1>
        <p class="text-muted fs-5">
          <?php echo nl2br($page_data['box_description']); ?>
        </p>
        
      </div>
    </div>
    <style>
  body {
    background: linear-gradient(135deg, #e0eafc, #cfdef3);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
  }

  .left-box {
    min-height: 400px;
    min-width: 400px;
    background: #ffffff;
    border-radius: 12px;
    box-shadow: 0 12px 24px rgba(0, 0, 0, 0.06);
    transition: all 0.3s ease-in-out;
  }

  .left-box:hover {
    box-shadow: 0 18px 32px rgba(0, 0, 0, 0.1);
    transform: translateY(-2px);
  }

  .right-box {
    max-height: 360px;
    border-radius: 16px;
    background: rgba(255, 255, 255, 0.85);
    backdrop-filter: blur(8px);
    box-shadow: 0 12px 24px rgba(0, 0, 0, 0.05);
  }

  .card-body h4 {
    font-weight: 700;
    font-size: 1.4rem;
    color: #444;
  }

  .d-grid .btn {
    border-radius: 12px;
    padding: 0.75rem 1rem;
    font-weight: 500;
    font-size: 1rem;
    transition: background 0.3s, transform 0.2s ease;
  }

  .btn-facebook {
    background: linear-gradient(45deg, #1877F2, #42A5F5);
    color: white;
    border: none;
  }

  .btn-facebook-alt {
    background: linear-gradient(45deg, #00C9FF, #92FE9D);
    color: white;
    border: none;
  }

  .btn-outline-facebook {
    background: white;
    color: #1877F2;
    border: 2px solid #1877F2;
  }

  .btn-outline-facebook:hover {
    background: #1877F2;
    color: white;
  }

  .btn-light {
    background: linear-gradient(45deg, #f0f0f0, #ffffff);
    color: #007bff;
    border: 2px solid #dce1e7;
  }

  .btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0, 0, 0, 0.1);
  }
</style>
    <!-- Right Side: Buttons + Forms -->
    <div class="col-lg-6">
      <div class="card shadow-sm border-0 mb-4">
        <div class="card-body p-4">
          <h4 class="mb-4 fw-semibold text-center text-secondary">Get Started</h4>
          <div class="d-grid gap-3">
            <button class="btn btn-facebook" onclick="toggleSection('createIDSection')">
              <i class="bi bi-person-plus me-2"></i> Create New Client ID
            </button>
            <button class="btn btn-facebook-alt" onclick="toggleSection('createBranchSection')">
              <i class="bi bi-building me-2"></i> Create New Branch
            </button>
            <button class="btn btn-outline-facebook" onclick="toggleSection('contactUsSection')">
              <i class="bi bi-envelope me-2"></i> Contact Us
            </button>
            <a href="http://202.72.233.241/food_v2/authentication" class="btn btn-light border text-primary fw-semibold">
              <i class="bi bi-box-arrow-in-right me-2"></i> Login
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Section Toggle Script -->
<script>
  function toggleSection(sectionId) {
    const sections = ['createIDSection', 'createBranchSection', 'contactUsSection'];
    sections.forEach(id => {
      const el = document.getElementById(id);
      if (el) el.style.display = (id === sectionId) ? 'block' : 'none';
    });

    const target = document.getElementById(sectionId);
    if (target) {
      window.scrollTo({ top: target.offsetTop - 50, behavior: 'smooth' });
    }
  }
</script>

<!-- Styles -->
<style>
  body {
    background-color: #f0f2f5;
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
    color: #1c1e21;
  }

  h1,
  h4 {
    font-weight: 700;
  }

  .text-primary {
    color: #1877f2 !important;
  }

  .text-muted {
    color: #606770 !important;
  }

  .card {
    background-color: #fff;
    border-radius: 10px;
    border: 1px solid #dddfe2;
    transition: all 0.3s ease-in-out;
  }

  .card:hover {
    box-shadow: 0 4px 16px rgba(0, 0, 0, 0.05);
  }

  .card-body {
    padding: 2rem;
  }

  .btn {
    font-weight: 600;
    padding: 12px 16px;
    border-radius: 6px;
    transition: all 0.25s ease;
    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.04);
  }

  .btn-facebook {
    background-color: #1877f2;
    color: #fff;
  }

  .btn-facebook:hover {
    background-color: #155dbb;
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(21, 93, 187, 0.2);
  }

  .btn-facebook-alt {
    background-color: #4267b2;
    color: #fff;
  }

  .btn-facebook-alt:hover {
    background-color: #385898;
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(56, 88, 152, 0.2);
  }

  .btn-outline-facebook {
    background-color: transparent;
    color: #1877f2;
    border: 2px solid #1877f2;
  }

  .btn-outline-facebook:hover {
    background-color: #1877f2;
    color: #fff;
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(24, 119, 242, 0.2);
  }

  .btn-light {
    background-color: #fff;
    border: 1px solid #ccc;
    color: #1877f2;
  }

  .btn-light:hover {
    background-color: #f0f2f5;
    color: #1877f2;
    transform: translateY(-1px);
    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
  }

  .form-control {
    border-radius: 6px;
    border: 1px solid #ccd0d5;
    transition: border-color 0.3s ease-in-out;
  }

  .form-control:focus {
    border-color: #1877f2;
    box-shadow: 0 0 0 0.15rem rgba(24, 119, 242, 0.25);
  }

  .rounded {
    border-radius: 10px !important;
  }

  .shadow-sm {
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04) !important;
  }

  .d-grid .btn {
    font-size: 16px;
  }

  .btn i {
    font-size: 18px;
    vertical-align: middle;
  }
  
</style>




<?php $submittedForm = $this->session->flashdata('form_type_submitted'); ?>

<div class="container my-5" id="contactUsSection"
  style="<?= ($submittedForm === 'contact_us') ? 'display: block;' : 'display: none;' ?>">

  <h2 class="mb-4">Contact Us</h2>

  <?php if ($this->session->flashdata('msg_success')): ?>
    <div class="alert alert-success"><?= $this->session->flashdata('msg_success') ?></div>
  <?php endif; ?>

  <?php if ($this->session->flashdata('msg_error')): ?>
    <div class="alert alert-danger"><?= $this->session->flashdata('msg_error') ?></div>
  <?php endif; ?>

  <form method="post" action="<?= base_url('home/contact') ?>" autocomplete="off" enctype="multipart/form-data">
    <input type="hidden" name="form_type" value="contact_us" />

    <div class="mb-3">
      <label>Name</label>
      <input type="text" name="name" class="form-control">
    </div>

    <div class="mb-3">
      <label>Email</label>
      <input type="email" name="email" class="form-control">
    </div>

    <div class="mb-3">
      <label>Phone</label>
      <input type="text" name="phoneno" class="form-control">
    </div>

    <div class="mb-3">
      <label>Subject</label>
      <input type="text" name="subject" class="form-control">
    </div>

    <div class="mb-3">
      <label>Message</label>
      <textarea name="message" class="form-control"></textarea>
    </div>

    <button type="submit" class="btn btn-primary">Submit</button>
  </form>
</div>

<?php $submittedForm = $this->session->flashdata('form_type_submitted'); ?>

<!-- Create ID Section -->
<div class="container my-5" id="createIDSection"
  style="<?= ($submittedForm === 'create_id') ? 'display: block;' : 'display: none;' ?>">
  <h2 class="mb-4">Create New Client ID</h2>

  <?php if ($this->session->flashdata('msg_success')): ?>
    <div class="alert alert-success"><?= $this->session->flashdata('msg_success') ?></div>
  <?php endif; ?>
  <?php if ($this->session->flashdata('msg_error')): ?>
    <div class="alert alert-danger"><?= $this->session->flashdata('msg_error') ?></div>
  <?php endif; ?>

  <form method="post" action="<?= base_url('home/contact') ?>" autocomplete="off" enctype="multipart/form-data">
    <input type="hidden" name="form_type" value="create_id" />

    <!-- 1. Select Branch -->
    <div class="mb-3">
      <label class="form-label"><?= translate('Branch_list'); ?> *</label>
      <div class="input-group">
        <span class="input-group-text"><i class="fas fa-users"></i></span>
        <select class="form-control" data-plugin-selectTwo data-width="100%" name="reseller_subreseller_id" id="reseller_subreseller_id" required>
          <?php if (empty($reseller_subreseller_list)): ?>
            <option value=""><?= translate('No Branch Found'); ?></option>
          <?php else: ?>
            <option value=""><?= translate('Select') ?></option>
            <?php foreach ($reseller_subreseller_list as $reseller_subreseller): ?>
              <option value="<?= $reseller_subreseller->id ?>" <?= set_select('reseller_subreseller_id', $reseller_subreseller->id) ?>>
                <?= html_escape($reseller_subreseller->name) ?>
              </option>
            <?php endforeach; ?>
          <?php endif; ?>
        </select>
      </div>
      <span class="text-danger"><?= form_error('reseller_subreseller_id'); ?></span>
    </div>

    <!-- 2. Client ID -->
    <div class="mb-3">
      <label>*Client ID</label>
      <input type="text" class="form-control" name="client_id" value="<?= html_escape($next_client_id) ?>" readonly>
    </div>

    <!-- 3. Client Name -->
    <div class="mb-3">
      <label>*Client Name</label>
      <input type="text" class="form-control" name="client_name" required>
    </div>

    <!-- 4. Username -->
    <div class="mb-3">
      <label>*Username</label>
      <input type="text" class="form-control" name="username" required>
    </div>

    <!-- 5. Password -->
    <div class="mb-3">
      <label>*Password</label>
      <input type="password" class="form-control" name="password" required>
    </div>

    <!-- 6. Gender -->
    <div class="mb-3">
      <label>Gender</label>
      <select name="gender" class="form-control">
        <option value="">-- Select Gender --</option>
        <option value="Male">Male</option>
        <option value="Female">Female</option>
        <option value="Other">Other</option>
      </select>
    </div>

    <!-- 7. Religion -->
    <div class="mb-3">
      <label for="religion" class="control-label"><?= translate('religion'); ?></label>
      <?= form_dropdown(
        "religion",
        ["islam" => translate('islam'), "hinduism" => translate('hinduism'), "christianity" => translate('christianity'), "other" => translate('other')],
        set_value("religion"),
        "class='form-control' data-plugin-selectTwo data-width='100%'"
      ); ?>
    </div>

    <!-- 8. Nationality -->
    <div class="mb-3">
      <label for="nationality">*Nationality</label>
      <select class="form-control" name="nationality" id="nationality" required onchange="setDialingCode()">
        <option value="">-- Select Nationality --</option>
        <option value="Afghan" data-code="+93">Afghan</option>
        <option value="Albanian" data-code="+355">Albanian</option>
        <option value="Algerian" data-code="+213">Algerian</option>
        <option value="American" data-code="+1">American</option>
        <option value="Andorran" data-code="+376">Andorran</option>
        <option value="Angolan" data-code="+244">Angolan</option>
        <option value="Argentine" data-code="+54">Argentine</option>
        <option value="Armenian" data-code="+374">Armenian</option>
        <option value="Australian" data-code="+61">Australian</option>
        <option value="Austrian" data-code="+43">Austrian</option>
        <option value="Azerbaijani" data-code="+994">Azerbaijani</option>
        <option value="Bahamian" data-code="+1-242">Bahamian</option>
        <option value="Bahraini" data-code="+973">Bahraini</option>
        <option value="Bangladeshi" data-code="+88">Bangladeshi</option>
        <option value="Barbadian" data-code="+1-246">Barbadian</option>
        <option value="Belarusian" data-code="+375">Belarusian</option>
        <option value="Belgian" data-code="+32">Belgian</option>
        <option value="Belizean" data-code="+501">Belizean</option>
        <option value="Beninese" data-code="+229">Beninese</option>
        <option value="Bhutanese" data-code="+975">Bhutanese</option>
        <option value="Bolivian" data-code="+591">Bolivian</option>
        <option value="Bosnian" data-code="+387">Bosnian</option>
        <option value="Brazilian" data-code="+55">Brazilian</option>
        <option value="British" data-code="+44">British</option>
        <option value="Bruneian" data-code="+673">Bruneian</option>
        <option value="Bulgarian" data-code="+359">Bulgarian</option>
        <option value="Burkinabé" data-code="+226">Burkinabé</option>
        <option value="Burmese" data-code="+95">Burmese</option>
        <option value="Burundian" data-code="+257">Burundian</option>
        <option value="Cambodian" data-code="+855">Cambodian</option>
        <option value="Cameroonian" data-code="+237">Cameroonian</option>
        <option value="Canadian" data-code="+1">Canadian</option>
        <option value="Cape Verdean" data-code="+238">Cape Verdean</option>
        <option value="Central African" data-code="+236">Central African</option>
        <option value="Chadian" data-code="+235">Chadian</option>
        <option value="Chilean" data-code="+56">Chilean</option>
        <option value="Chinese" data-code="+86">Chinese</option>
        <option value="Colombian" data-code="+57">Colombian</option>
        <option value="Comoran" data-code="+269">Comoran</option>
        <option value="Congolese" data-code="+242">Congolese</option>
        <option value="Costa Rican" data-code="+506">Costa Rican</option>
        <option value="Croatian" data-code="+385">Croatian</option>
        <option value="Cuban" data-code="+53">Cuban</option>
        <option value="Cypriot" data-code="+357">Cypriot</option>
        <option value="Czech" data-code="+420">Czech</option>
        <option value="Danish" data-code="+45">Danish</option>
        <option value="Djiboutian" data-code="+253">Djiboutian</option>
        <option value="Dominican" data-code="+1-809">Dominican</option>
        <option value="Dutch" data-code="+31">Dutch</option>
        <option value="Ecuadorian" data-code="+593">Ecuadorian</option>
        <option value="Egyptian" data-code="+20">Egyptian</option>
        <option value="Emirati" data-code="+971">Emirati</option>
        <option value="Equatoguinean" data-code="+240">Equatoguinean</option>
        <option value="Eritrean" data-code="+291">Eritrean</option>
        <option value="Estonian" data-code="+372">Estonian</option>
        <option value="Ethiopian" data-code="+251">Ethiopian</option>
        <option value="Fijian" data-code="+679">Fijian</option>
        <option value="Finnish" data-code="+358">Finnish</option>
        <option value="French" data-code="+33">French</option>
        <option value="Gabonese" data-code="+241">Gabonese</option>
        <option value="Gambian" data-code="+220">Gambian</option>
        <option value="Georgian" data-code="+995">Georgian</option>
        <option value="German" data-code="+49">German</option>
        <option value="Ghanaian" data-code="+233">Ghanaian</option>
        <option value="Greek" data-code="+30">Greek</option>
        <option value="Grenadian" data-code="+1-473">Grenadian</option>
        <option value="Guatemalan" data-code="+502">Guatemalan</option>
        <option value="Guinean" data-code="+224">Guinean</option>
        <option value="Guyanese" data-code="+592">Guyanese</option>
        <option value="Haitian" data-code="+509">Haitian</option>
        <option value="Honduran" data-code="+504">Honduran</option>
        <option value="Hungarian" data-code="+36">Hungarian</option>
        <option value="Icelandic" data-code="+354">Icelandic</option>
        <option value="Indian" data-code="+91">Indian</option>
        <option value="Indonesian" data-code="+62">Indonesian</option>
        <option value="Iranian" data-code="+98">Iranian</option>
        <option value="Iraqi" data-code="+964">Iraqi</option>
        <option value="Irish" data-code="+353">Irish</option>
        <option value="Israeli" data-code="+972">Israeli</option>
        <option value="Italian" data-code="+39">Italian</option>
        <option value="Ivorian" data-code="+225">Ivorian</option>
        <option value="Jamaican" data-code="+1-876">Jamaican</option>
        <option value="Japanese" data-code="+81">Japanese</option>
        <option value="Jordanian" data-code="+962">Jordanian</option>
        <option value="Kazakh" data-code="+7">Kazakh</option>
        <option value="Kenyan" data-code="+254">Kenyan</option>
        <option value="Kuwaiti" data-code="+965">Kuwaiti</option>
        <option value="Kyrgyz" data-code="+996">Kyrgyz</option>
        <option value="Laotian" data-code="+856">Laotian</option>
        <option value="Latvian" data-code="+371">Latvian</option>
        <option value="Lebanese" data-code="+961">Lebanese</option>
        <option value="Liberian" data-code="+231">Liberian</option>
        <option value="Libyan" data-code="+218">Libyan</option>
        <option value="Lithuanian" data-code="+370">Lithuanian</option>
        <option value="Luxembourgish" data-code="+352">Luxembourgish</option>
        <option value="Malagasy" data-code="+261">Malagasy</option>
        <option value="Malaysian" data-code="+60">Malaysian</option>
        <option value="Maldivian" data-code="+960">Maldivian</option>
        <option value="Malian" data-code="+223">Malian</option>
        <option value="Maltese" data-code="+356">Maltese</option>
        <option value="Mauritanian" data-code="+222">Mauritanian</option>
        <option value="Mauritian" data-code="+230">Mauritian</option>
        <option value="Mexican" data-code="+52">Mexican</option>
        <option value="Moldovan" data-code="+373">Moldovan</option>
        <option value="Mongolian" data-code="+976">Mongolian</option>
        <option value="Montenegrin" data-code="+382">Montenegrin</option>
        <option value="Moroccan" data-code="+212">Moroccan</option>
        <option value="Mozambican" data-code="+258">Mozambican</option>
        <option value="Namibian" data-code="+264">Namibian</option>
        <option value="Nepalese" data-code="+977">Nepalese</option>
        <option value="Netherlander" data-code="+31">Netherlander</option>
        <option value="New Zealander" data-code="+64">New Zealander</option>
        <option value="Nigerian" data-code="+234">Nigerian</option>
        <option value="North Korean" data-code="+850">North Korean</option>
        <option value="Norwegian" data-code="+47">Norwegian</option>
        <option value="Omani" data-code="+968">Omani</option>
        <option value="Pakistani" data-code="+92">Pakistani</option>
        <option value="Palestinian" data-code="+970">Palestinian</option>
        <option value="Panamanian" data-code="+507">Panamanian</option>
        <option value="Paraguayan" data-code="+595">Paraguayan</option>
        <option value="Peruvian" data-code="+51">Peruvian</option>
        <option value="Philippine" data-code="+63">Philippine</option>
        <option value="Polish" data-code="+48">Polish</option>
        <option value="Portuguese" data-code="+351">Portuguese</option>
        <option value="Qatari" data-code="+974">Qatari</option>
        <option value="Romanian" data-code="+40">Romanian</option>
        <option value="Russian" data-code="+7">Russian</option>
        <option value="Rwandan" data-code="+250">Rwandan</option>
        <option value="Saudi" data-code="+966">Saudi</option>
        <option value="Senegalese" data-code="+221">Senegalese</option>
        <option value="Serbian" data-code="+381">Serbian</option>
        <option value="Singaporean" data-code="+65">Singaporean</option>
        <option value="Slovak" data-code="+421">Slovak</option>
        <option value="Slovenian" data-code="+386">Slovenian</option>
        <option value="Somali" data-code="+252">Somali</option>
        <option value="South African" data-code="+27">South African</option>
        <option value="South Korean" data-code="+82">South Korean</option>
        <option value="Spanish" data-code="+34">Spanish</option>
        <option value="Sri Lankan" data-code="+94">Sri Lankan</option>
        <option value="Sudanese" data-code="+249">Sudanese</option>
        <option value="Swedish" data-code="+46">Swedish</option>
        <option value="Swiss" data-code="+41">Swiss</option>
        <option value="Syrian" data-code="+963">Syrian</option>
        <option value="Taiwanese" data-code="+886">Taiwanese</option>
        <option value="Tajik" data-code="+992">Tajik</option>
        <option value="Tanzanian" data-code="+255">Tanzanian</option>
        <option value="Thai" data-code="+66">Thai</option>
        <option value="Togolese" data-code="+228">Togolese</option>
        <option value="Tunisian" data-code="+216">Tunisian</option>
        <option value="Turkish" data-code="+90">Turkish</option>
        <option value="Turkmen" data-code="+993">Turkmen</option>
        <option value="Ugandan" data-code="+256">Ugandan</option>
        <option value="Ukrainian" data-code="+380">Ukrainian</option>
        <option value="Uruguayan" data-code="+598">Uruguayan</option>
        <option value="Uzbek" data-code="+998">Uzbek</option>
        <option value="Venezuelan" data-code="+58">Venezuelan</option>
        <option value="Vietnamese" data-code="+84">Vietnamese</option>
        <option value="Yemeni" data-code="+967">Yemeni</option>
        <option value="Zambian" data-code="+260">Zambian</option>
        <option value="Zimbabwean" data-code="+263">Zimbabwean</option>
      </select>
    </div>

    <!-- 9. Client Type -->
    <div class="mb-3">
      <label>*Client Type</label>
      <select name="client_type" class="form-control" required>
        <option value=""><?= translate('select') ?></option>
        <option value="common"><?= translate('common') ?></option>
        <option value="orphans"><?= translate('Orphan') ?></option>
        <option value="incapacitated"><?= translate('incapacitated') ?></option>
      </select>
    </div>

    <!-- 10. Mobile -->
    <div class="mb-3">
      <label>*Mobile No</label>
      <div class="input-group">
        <span class="input-group-text" id="mobile-code">+XXX</span>
        <input type="text" class="form-control" name="mobile" required>
      </div>
    </div>
    <input type="hidden" name="dial_code" id="dial_code" value="<?= set_value('dial_code', '+XXX'); ?>">

    <script>
      function setDialingCode() {
        const nationalitySelect = document.getElementById("nationality");
        const selectedOption = nationalitySelect.options[nationalitySelect.selectedIndex];
        const code = selectedOption.getAttribute("data-code") || "+XXX";
        document.getElementById("mobile-code").innerText = code;
        document.getElementById("dial_code").value = code;
      }
      document.addEventListener("DOMContentLoaded", setDialingCode);
    </script>

    <!-- 11. Email -->
    <div class="mb-3">
      <label>Email</label>
      <input type="email" class="form-control" name="email_client">
    </div>

    <!-- 12. Client Picture -->
    <div class="mb-3">
      <label for="user_photo"><?= translate('profile_picture'); ?></label><br>
      <input type="file" name="user_photo" class="form-control" accept=".jpg,.png" />
    </div>

    <!-- Agreement Checkbox -->
    <div class="mb-3 form-check">
      <input type="checkbox" class="form-check-input" id="agreementID" name="agreement" required>
      <label class="form-check-label" for="agreementID">
        I agree to all the terms and conditions of " FoodMD ".
      </label>
    </div>

    <button type="submit" class="btn btn-primary">Submit</button>
  </form>
</div>


<!-- Create Branch Section -->
<div class="container my-5" id="createBranchSection"
  style="<?= ($submittedForm === 'create_branch') ? 'display: block;' : 'display: none;' ?>">
  <h2 class="mb-4">Create Branch</h2>

  <?php if ($this->session->flashdata('msg_success')): ?>
    <div class="alert alert-success"><?= $this->session->flashdata('msg_success') ?></div>
  <?php endif; ?>
  <?php if ($this->session->flashdata('msg_error')): ?>
    <div class="alert alert-danger"><?= $this->session->flashdata('msg_error') ?></div>
  <?php endif; ?>

  <form method="post" action="<?= base_url('home/contact') ?>" autocomplete="off" enctype="multipart/form-data">
    <input type="hidden" name="form_type" value="create_branch" />

    <!-- Auto-generated Branch ID -->
    <div class="mb-3">
      <label>Branch ID</label>
      <input type="text" class="form-control" name="branch_id" value="<?= html_escape($next_merchant_no) ?>" readonly>
    </div>

    <div class="mb-3">
      <label>Branch Name</label>
      <input type="text" class="form-control" name="branch_name" required>
    </div>

    <div class="mb-3">
      <label>Trade Licence Number</label>
      <input type="text" class="form-control" name="trade_licence_number" required>
    </div>

    <div class="mb-3">
      <label>Branch Address (Details)</label>
      <textarea class="form-control" name="address" rows="3" required></textarea>
    </div>

    <div class="mb-3">
      <label>Mobile Number</label>
      <input type="tel" class="form-control" name="mobile_number" required>
    </div>

    <div class="mb-3">
      <label>Email</label>
      <input type="email" class="form-control" name="email" required>
    </div>

    <div class="mb-3">
      <label>Bkash/Nagad/Rocket/Account Number</label>
      <input type="text" class="form-control" name="payment_account" required>
    </div>

    <!-- Username -->
    <div class="mb-3">
      <label>*Username</label>
      <input type="text" class="form-control" name="username" required>
    </div>

    <!-- Password -->
    <div class="mb-3">
      <label>*Password</label>
      <input type="password" class="form-control" name="password" required>
    </div>

    <!-- Branch Logo -->
    <div class="mb-3">
      <label for="user_photo"><?= translate('branch_logo'); ?></label><br>
      <input type="file" name="user_photo" class="form-control" accept=".jpg,.png" />
    </div>

    <!-- Attach Document -->
    <div class="mb-3">
      <label>Attach Document</label>
      <input type="file" class="form-control" name="document" accept=".pdf,.jpg,.jpeg,.png" required>
    </div>

    <!-- Agreement Checkbox -->
    <div class="mb-3 form-check">
      <input type="checkbox" class="form-check-input" id="agreementBranch" name="agreement" required>
      <label class="form-check-label" for="agreementBranch">
        My / Our branch agree to all the terms and conditions of "FoodMD".
      </label>
    </div>

    <button type="submit" class="btn btn-success">Submit</button>
  </form>
</div>

<!-- Section Toggle Script -->
<script>
  function toggleSection(sectionId) {
    const sections = ['contactUsSection', 'createIDSection', 'createBranchSection'];
    sections.forEach(id => {
      const el = document.getElementById(id);
      if (el) {
        el.style.display = (id === sectionId) ? 'block' : 'none';
      }
    });

    const target = document.getElementById(sectionId);
    if (target) {
      window.scrollTo({
        top: target.offsetTop - 50,
        behavior: 'smooth'
      });
    }
  }
</script>

<!-- Footer Contact Info Section -->
<div class="container my-5" data-aos="fade-up" data-aos-delay="100">
  <div class="row text-center justify-content-center">
    <div class="col-md-3 mb-4">
      <div class="footer-info-box" data-aos="fade" data-aos-delay="200">
        <i class="bi bi-geo-alt"></i>
        <h5>Address</h5>
        <p><?php echo nl2br($page_data['address']); ?></p>
      </div>
    </div>

    <div class="col-md-3 mb-4">
      <div class="footer-info-box" data-aos="fade" data-aos-delay="300">
        <i class="bi bi-telephone"></i>
        <h5>Call Us</h5>
        <p><?php echo nl2br($page_data['phone']); ?></p>
      </div>
    </div>

    <div class="col-md-3 mb-4">
      <div class="footer-info-box" data-aos="fade" data-aos-delay="400">
        <i class="bi bi-envelope"></i>
        <h5>Email Us</h5>
        <p><?php echo nl2br($page_data['email']); ?></p>
      </div>
    </div>

    <div class="col-md-3 mb-4">
      <div class="footer-info-box" data-aos="fade" data-aos-delay="500">
        <i class="bi bi-clock"></i>
        <h5>Open Hours</h5>
        <p>Monday - Friday<br>9:00AM - 05:00PM</p>
      </div>
    </div>
  </div>
</div>

<style>
  .footer-info-box {
  background-color: #fff;
  border: 1px solid #e1e4e8;
  border-radius: 10px;
  box-shadow: 0 4px 15px rgba(0, 0, 0, 0.04);
  transition: all 0.3s ease;
  height: 100%;
}

.footer-info-box:hover {
  background-color: #e7f0fd; /* Light blue hover background */
  transform: translateY(-5px);
  box-shadow: 0 6px 18px rgba(0, 0, 0, 0.08);
}

.footer-info-box i {
  font-size: 22px;
  color: #1877f2;
  margin-bottom: 10px;
}

.footer-info-box h5 {
  font-size: 17px;
  font-weight: 400;
  color: #333;
  margin-bottom: 8px;
}

.footer-info-box p {
  font-size: 15px;
  color: #555;
  margin: 0;
  white-space: pre-line;
}

</style>