<!-- Page Title -->
<div class="page-title">
  <div class="heading">
    <div class="container">
      <div class="row d-flex justify-content-center text-center">
        <div class="col-lg-8">
          <h1><?php echo $page_data['page_title']; ?></h1>
          <p class="mb-0"><?php echo $page_data['description']; ?></p>
        </div>
      </div>
    </div>
  </div>
  <nav class="breadcrumbs">
    <div class="container">
      <ol>
        <li><a href="<?php echo base_url('home') ?>">Home</a></li>
        <li class="current"><?php echo $page_data['page_title']; ?></li>
      </ol>
    </div>
  </nav>
</div><!-- End Page Title -->


<!-- Pricing Section -->
<section id="pricing" class="pricing section">

  <!-- Section Title -->
  <div class="container section-title" data-aos="fade-up">
    <h2><?php echo $page_data['title']; ?></h2>
  </div><!-- End Section Title -->

  <div class="container">


    <div class="row gy-4">
      <?php foreach ($packages as $thisPackage) : ?>
        <?php if ($thisPackage->manager_id == 1 && $thisPackage->privacy === 'public') : ?>


          <div class="col-lg-3 col-md-6" data-aos="zoom-in" data-aos-delay="100">
            <div class="pricing-tem">
              <h3 style="color: #20c997;"><?php echo html_escape($thisPackage->name); ?></h3>
              <div class="price"><sup>৳</sup><?php echo html_escape($thisPackage->retail_price); ?><span> / mo</span></div>
              <div class="icon">
                <i class="bi bi-box" style="color: #20c997;"></i>
              </div>
              <ul>
                <li> Connection Charge: Free</li>
                <li> 24/7 Helpdesk Support</li>
                <li> Real IP on Demand</li>
                <li> Up to 200 Mbps</li>

              </ul>
              <a href="#" class="btn-buy">Buy Now</a>
            </div>
          </div><!-- End Pricing Item -->
        <?php endif; ?>
      <?php endforeach; ?>

    </div><!-- End pricing row -->

  </div>

</section><!-- /Pricing Section -->