<!-- Page Title -->
<div class="page-title">
  <div class="heading">
    <div class="container">
      <div class="row d-flex justify-content-center text-center">
        <div class="col-lg-8">
          <h1><?php echo $page_data['page_title']; ?></h1>
          <p class="mb-0"><?php echo $page_data['subtitle']; ?></p>
        </div>
      </div>
    </div>
  </div>
  <nav class="breadcrumbs">
    <div class="container">
      <ol>
        <li><a href="<?php echo base_url('home') ?>">Home</a></li>
        <li class="current"><?php echo $page_data['page_title']; ?></li>
      </ol>
    </div>
  </nav>
</div><!-- End Page Title -->
<?php
$service = $this->db->get_where('front_cms_services', array('id' => 1))->row_array();
?>
<div class="container my-5">
  <!-- About Intro Text Starts -->
  <section class="welcome-area about" style="background: url(<?php echo base_url('uploads/frontend/about/' . $page_data['about_image']); ?>) no-repeat right center; background-size: 50%; padding: 50px; border-radius: 25px; box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);">
    <div class="row">
      <div class="col-lg-6 col-sm-12">
        <h3 class="main-heading1"><?php echo $page_data['title']; ?></h3>
        <h3 class="main-heading2"><?php echo $page_data['subtitle']; ?></h3>
        <p><?php echo $page_data['content']; ?></p>
      </div>
      <div class="col-md-6 col-sm-12 d-none d-md-block"></div>
    </div>
  </section>
  <!-- About Intro Text Ends -->
</div>

<!-- Team Section -->
<section id="team" class="team section">

  <!-- Section Title -->
  <div class="container section-title" data-aos="fade-up">
    <h2><?php echo $page_data['page_title']; ?></h2>
  </div><!-- End Section Title -->

  <div class="container">
  <div class="row gy-4">
    <?php
    // Fetch all team members from the database
    $team = $this->db->get('front_cms_team_list')->result_array();
    
    if (!empty($team)) {
      foreach ($team as $key => $value) {
        $elements = json_decode($value['elements'], true); // Decode elements JSON for each row
    ?>
        <div class="col-lg-3 col-md-6 d-flex align-items-stretch" data-aos="fade-up" data-aos-delay="<?php echo ($key + 1) * 100; ?>">
          <div class="team-member">
            <div class="member-img">
              <img src="<?php echo base_url('uploads/frontend/team/' . $elements['image']); ?>" class="img-fluid" alt="Team Member">
              <div class="social">
                <a href=""><i class="bi bi-twitter"></i></a>
                <a href=""><i class="bi bi-facebook"></i></a>
                <a href=""><i class="bi bi-instagram"></i></a>
                <a href=""><i class="bi bi-linkedin"></i></a>
              </div>
            </div>
            <div class="member-info">
              <h4><?php echo htmlspecialchars($value['title']); ?></h4>
              <span style="font-weight: bold;"><?php echo htmlspecialchars($value['designation']); ?></span>
              <p><?php echo htmlspecialchars($value['description']); ?></p>
            </div>
          </div>
        </div>
    <?php 
      } 
    } else {
      echo "<p>No team members found.</p>";
    }
    ?>
  </div>
</div>


</section><!-- /Team Section -->