<?php $roleID = loggedin_role_id(); ?>

<div class="row">
    <div class="col-md-12">
        <section class="panel">
            <header class="panel-heading">
                <h4 class="panel-title"><?= translate('Help Line Number'); ?></h4>
            </header>
            <div class="panel-body">
                <table id="helplineTable" class="table table-bordered table-hover table-condensed">
                    <thead>
                        <tr>
                            <th><?= translate('Phone Number'); ?></th>
                            <th><?= translate('Description'); ?></th>
                            <?php if ($roleID != 4): ?>
                                <th><?= translate('Action'); ?></th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($logs)) : ?>
                            <?php foreach ($logs as $log) : ?>
                                <tr>
                                    <td><?= htmlspecialchars($log->phone_number); ?></td>
                                    <td><?= nl2br(htmlspecialchars($log->description)); ?></td>
                                    <?php if ($roleID != 4): ?>
                                        <td>
                                            <a href="<?= base_url('help/delete/' . $log->id); ?>" 
                                               class="btn btn-danger btn-sm"
                                               onclick="return confirm('Are you sure you want to delete this help line?');">
                                                <i class="fas fa-trash-alt"></i> <?= translate('Delete'); ?>
                                            </a>
                                        </td>
                                    <?php endif; ?>
                                </tr>
                            <?php endforeach; ?>
                        <?php else : ?>
                            <tr>
                                <td colspan="<?= $roleID != 4 ? 3 : 2 ?>" class="text-center"><?= translate('No records found'); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </section>
    </div>
</div>
