<?php $elements = json_decode($team['elements'], true); ?>
<section class="panel">
	<div class="tabs-custom">
		<ul class="nav nav-tabs">
			<li>
				<a href="<?php echo base_url('frontend/team'); ?>"><i class="fas fa-list-ul"></i> <?php echo translate('team') . " " . translate('list'); ?></a>
			</li>
			<li class="active">
				<a href="#edit" data-toggle="tab"><i class="far fa-edit"></i> <?php echo translate('edit') . " " . translate('team'); ?></a>
			</li>
		</ul>
		<div class="tab-content">
			<div class="tab-pane active" id="edit">
			    <?php echo form_open_multipart($this->uri->uri_string(), array('class' => 'form-horizontal form-bordered')); ?>
					<input type="hidden" name="team_id" value="<?php echo $team['id']; ?>">
					<div class="form-group">
						<label class="col-md-3 control-label"><?php echo translate('title'); ?></label>
						<div class="col-md-6">
							<input type="text" class="form-control" name="title" value="<?php echo set_value('title', $team['title']); ?>" />
							<span class="error"><?php echo form_error('title'); ?></span>
						</div>
					</div>

					<div class="form-group <?php if (form_error('designation')) echo 'has-error'; ?>">
						<label  class="col-md-3 control-label"><?php echo translate('designation'); ?> <span class="required">*</span></label>
						<div class="col-md-6">
							<input type="text" class="form-control" name="designation" value="<?php echo set_value('designation', $team['designation']); ?>" />
							<span class="error"><?php echo form_error('designation'); ?></span>
						</div>
					</div>
					
					<div class="form-group">
						<label class="col-md-3 control-label"><?php echo translate('description'); ?> <span class="required">*</span></label>
						<div class="col-md-6">
							<textarea class="form-control" id="description" name="description" placeholder="" rows="3" ><?php echo set_value('description', $team['description']); ?></textarea>
							<span class="error"><?php echo form_error('description'); ?></span>
						</div>
					</div>
				
					
					<div class="form-group">
						<label class="col-md-3 control-label"><?php echo translate('photo'); ?> </label>
						<div class="col-md-4">
							<input type="hidden" name="old_photo" value="<?php echo $elements['image']; ?>">
							<input type="file" name="photo" class="dropify" data-height="150" data-default-file="<?php echo base_url('uploads/frontend/team/' . $elements['image']); ?>" />
							<span class="error"><?php echo form_error('photo'); ?></span>
						</div>
					</div>
					<footer class="panel-footer mt-lg">
						<div class="row">
							<div class="col-md-2 col-md-offset-3">
								<button type="submit" class="btn btn-default btn-block" name="save" value="1">
									<i class="fas fa-edit"></i> <?php echo translate('update'); ?>
								</button>
							</div>
						</div>	
					</footer>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</section>