<?php $currency_symbol = $global_config['currency_symbol']; ?>
<?php if (loggedin_role_id() != ROLE_CUSTOMER_ID) : ?>
    <section class="panel-group" id="accordion">
        <div class="panel panel-accordion">
            <div class="panel-heading">
                <h4 class="panel-title">
                    <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion"
                        href="#meal_filter_field"><?php echo translate('Select Grounds For Filter'); ?></a>
                </h4>
            </div>

            <div id="meal_filter_field"
                class="accordion-body collapse <?php echo ($this->session->flashdata('active_box') == 1 ? 'in' : ''); ?>">
                <?php echo form_open($this->uri->uri_string()); ?>
                <div class="panel-body">
                    <?php if (!in_array(loggedin_role_id(), array(3, 4))) { ?>
                        <div class="col-md-3 mb-lg">
                            <div class="form-group <?= form_error('reseller_subreseller_id') ? 'has-error' : null ?>">
                                <label for="reseller_subreseller_id" class="control-label">
                                    <?php
                                    if (loggedin_role_id() != 2 && loggedin_role_id() != 4) {
                                        echo translate('Manager_list');
                                    } elseif (loggedin_role_id() == 2) {
                                        echo translate('Sub_manager_list');
                                    }
                                    ?>
                                    <span class="required"></span>
                                </label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fas fa-users"></i></span>
                                    <select class="form-control" data-plugin-selectTwo data-width="100%"
                                        name="reseller_subreseller_id"
                                        id="reseller_subreseller_id">
                                        <?php if (empty($reseller_subreseller_list)): ?>
                                            <option value=""><?= translate('No Manager Found'); ?></option>
                                        <?php else: ?>
                                            <option value=""><?= translate('Select A Manager') ?></option>
                                            <?php foreach ($reseller_subreseller_list as $reseller_subreseller): ?>
                                                <option value="<?= $reseller_subreseller->id ?>" <?= set_select('reseller_subreseller_id', $reseller_subreseller->id) ?>>
                                                    <?= html_escape($reseller_subreseller->name) ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                    <span class="error"><?= form_error('reseller_subreseller_id'); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                    <div class="col-md-3 mb-lg">
                        <div class="form-group <?= form_error('package_list_id') ? 'has-error' : null ?>">
                            <label for="package_list_id" class="control-label">
                                <?= translate('package_list'); ?>
                                <span class="required"></span>
                            </label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="fas fa-list-ul"></i></span>
                                <select class="form-control" data-plugin-selectTwo data-width="100%"
                                    name="package_list_id"
                                    id="package_list_id">
                                    <?php if (empty($package_list)): ?>
                                        <option value=""><?= translate('No Package Found'); ?></option>
                                    <?php else: ?>
                                        <option value=""><?= translate('Select A Package') ?></option>
                                        <?php foreach ($package_list as $package): ?>
                                            <option value="<?= $package->id ?>" <?= set_select('package_list_id', $package->id) ?>>
                                                <?= html_escape($package->name) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                                <span class="error"><?= form_error('package_list_id'); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 mb-lg">
                        <div class="form-group <?= form_error('student_id') ? 'has-error' : null ?>">
                            <label for="student_id" class="control-label">
                                <?= translate('select_student'); ?>
                                <span class="required"></span>
                            </label>

                            <div class="input-group">
                                <span class="input-group-addon"><i class="fas fa-user"></i></span>

                                <select class="form-control" data-plugin-selectTwo data-width="100%" name="student_id" id="student_id">
                                    <?php if (empty($students)): ?>
                                        <option value=""><?= translate('No Student Found'); ?></option>
                                    <?php else: ?>
                                        <option value=""><?= translate('Select A Student') ?></option>
                                        <?php foreach ($students as $student): ?>
                                            <option value="<?= $student->id ?>" <?= set_select('student_id', $student->id) ?>>
                                                <?= html_escape($student->name) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                                <span class="error"><?= form_error('student_id'); ?></span>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3 mb-lg">
                        <div class="form-group">
                            <label class="control-label"><?php echo translate('date'); ?> <span class="required"></span></label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="fas fa-calendar-check"></i></span>
                                <input type="text" class="form-control daterange" name="daterange" id="daterange"
                                    value="<?php echo set_value('daterange', date("2024/1/1") . ' - ' . date("Y/m/d")); ?>" />
                            </div>
                        </div>
                    </div>
                </div>
                <footer class="panel-footer">
                    <div class="row">
                        <div class="col-md-offset-10 col-md-2">
                            <button type="submit" name="btn-filter" id="btn-filter" value="1"
                                class="btn btn btn-default btn-block"><i
                                    class="fas fa-filter"></i> <?php echo translate('filter'); ?></button>
                        </div>
                    </div>
                </footer>
                <?php echo form_close(); ?>
            </div>
        </div>
    </section>
<?php endif ?>

<section class="panel">
    <header class="panel-heading">
        <div class="row">
            <div class="col-md-8">
                <h4 class="panel-title"><i class="fas fa-list-ul"></i> <?php echo translate('Booking') . " " . translate('list'); ?></h4>
            </div>
        </div>
    </header>
    <div class="panel-body">
        <div class="export_title"><?php echo translate('Booking') . " " . translate('list'); ?></div>
        <table class="table table-bordered table-hover table-condensed" cellspacing="0" width="100%" id="table-export">
            <thead>
                <tr>
                    <th><?php echo translate('id'); ?></th>
                    <th><?php echo translate('Booking Date'); ?></th>
                    <th><?php echo translate('student name'); ?></th>
                    <th><?php echo translate('Student ID'); ?></th>
                    <th><?php echo translate('Manager name'); ?></th>
                    <th><?php echo translate('Branch'); ?></th>
                    <th><?php echo translate('Package'); ?></th>
                    <th><?php echo translate('breakfast'); ?></th>
                    <th><?php echo translate('lunch'); ?></th>
                    <th><?php echo translate('dinner'); ?></th>
                    <th><?php echo translate('action'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($naslist)) {
                    foreach ($naslist as $row): ?>
                        <tr>
                            <td><?php echo html_escape($row['id']); ?></td>
                            <td><?php echo html_escape($row['selected_dates']); ?></td>
                            <td><?php echo html_escape($row['student_name']); ?></td>
                            <td><?php echo html_escape($row['idd']); ?></td>
                            <td><?php echo html_escape($row['manager_name']); ?></td>
                            <td><?php echo html_escape($row['zone_name']); ?></td>
                            <td><?php echo html_escape($row['package_name']); ?></td>
                            <td><?php echo html_escape($row['selected_breakfast']); ?></td>
                            <td><?php echo html_escape($row['selected_lunch']); ?></td>
                            <td><?php echo html_escape($row['selected_dinner']); ?></td>
                            <td>
                                <?php if (get_permission('nas', 'is_edit')): ?>
                                    <a href="<?php echo base_url('nas/edit/' . $row['id']); ?>" class="btn btn-circle icon btn-default" data-toggle="tooltip" data-original-title="<?php echo translate('edit'); ?>">
                                        <i class="fas fa-pen-nib"></i>
                                    </a>
                                <?php endif;
                                if (get_permission('nas', 'is_delete')): ?>
                                    <?php echo btn_delete('nas/delete/' . $row['id']); ?>
                                <?php endif; ?>
                            </td>
                        </tr>
                <?php endforeach;
                } ?>
            </tbody>
        </table>
    </div>

</section>