<div class="row">
    <div class="col-md-12">
        <section class="panel">
            <header class="panel-heading">
                <h4><?php echo translate('food') . " " . translate('donation_form'); ?></h4>
            </header>
            <div class="panel-body">
                <?php echo form_open('food/save_donation', ['class' => 'form-horizontal', 'id' => 'donationForm']); ?>

                <!-- Donor Name -->
                <div class="form-group">
                    <label class="col-md-2 control-label"><?php echo translate('donor_name'); ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <input type="text" name="donor_name" class="form-control" placeholder="Enter donor name" required />
                    </div>
                </div>

                <!-- Select Student -->
                <div class="form-group">
                    <label class="col-md-2 control-label"><?php echo translate('student'); ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <select name="student_id" class="form-control" required>
                            <option value=""><?php echo translate('select'); ?></option>
                            <?php foreach ($students as $student) { ?>
                                <option value="<?= $student['id']; ?>"><?= $student['name']; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <!-- Select Manager -->
                <div class="form-group">
                    <label class="col-md-2 control-label"><?php echo translate('manager'); ?> <span class="required">*</span></label>
                    <div class="col-md-6">
                        <select name="manager_id" class="form-control" required>
                            <option value=""><?php echo translate('select'); ?></option>
                            <?php foreach ($managers as $manager) { ?>
                                <option value="<?= $manager['id']; ?>"><?= $manager['name']; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <!-- Food Items -->
                <div id="foodItemWrapper">
                    <div class="form-group food-item-row">
                        <label class="col-md-2 control-label"><?php echo translate('food_item'); ?> <span class="required">*</span></label>
                        <div class="col-md-6">
                            <select name="food_items[]" class="form-control" required>
                                <option value=""><?php echo translate('select'); ?></option>
                                <?php foreach ($food_items as $item) { ?>
                                    <option value="<?= $item['id']; ?>"><?= $item['name']; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <button type="button" class="btn btn-success add-food-item"><i class="fas fa-plus"></i></button>
                        </div>
                    </div>
                </div>

                <!-- Submit -->
                <div class="form-group mt-4">
                    <div class="col-md-offset-2 col-md-6">
                        <button type="submit" class="btn btn-primary">
                            <?php echo translate('submit'); ?>
                        </button>
                    </div>
                </div>

                <?php echo form_close(); ?>
            </div>
        </section>
    </div>
</div>

<!-- JavaScript for Adding/Removing Food Items -->
<script>
    $(document).on('click', '.add-food-item', function () {
        var row = $(this).closest('.food-item-row').clone();
        row.find('select').val('');
        row.find('.add-food-item')
            .removeClass('btn-success add-food-item')
            .addClass('btn-danger remove-food-item')
            .html('<i class="fas fa-trash"></i>');
        $('#foodItemWrapper').append(row);
    });

    $(document).on('click', '.remove-food-item', function () {
        $(this).closest('.food-item-row').remove();
    });
</script>
