<script src="https://code.jquery.com/jquery.js"></script>
<?php if (loggedin_role_id() != 4) { ?>
    <section class="panel-group" id="accordion">
        <div class="panel panel-accordion">
            <div class="panel-heading">
                <h4 class="panel-title">
                    <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion"
                        href="#client_filter_field"><?php echo translate('Select Grounds For Filter'); ?></a>
                </h4>
            </div>

            <div id="client_filter_field"
                class="accordion-body collapse <?php echo ($this->session->flashdata('active_box') == 1 ? 'in' : ''); ?>">
                <?php echo form_open($this->uri->uri_string()); ?>
                <div class="panel-body">

                    <div class="col-md-6 mb-lg">
                        <div class="form-group">
                            <label class="control-label" for="daterange"><?php echo translate('date'); ?> <span class="required"></span></label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="fas fa-calendar-check"></i></span>
                                <input type="text" class="form-control daterange" id="daterange" name="daterange"
                                    value="<?php echo set_value('daterange', date("Y/m/1") . ' - ' . date("Y/m/d")); ?>"
                                    required />
                            </div>
                        </div>
                    </div>
                </div>

                <footer class="panel-footer">
                    <div class="row">
                        <div class="col-md-offset-10 col-md-2">
                            <button type="button" name="btn-filter" id="btn-filter" value="1"
                                class="btn btn btn-default btn-block"><i
                                    class="fas fa-filter"></i> <?php echo translate('filter'); ?></button>
                        </div>
                    </div>
                </footer>
                <?php echo form_close(); ?>
            </div>
        </div>
    </section>
<?php } ?>
<section class="panel">
    <div class="tabs-custom">
        <ul class="nav nav-tabs">
            <?php if (get_permission('refund', 'is_view')) { ?>
                <li class="<?php echo (!isset($validation_error) ? 'active' : ''); ?>">
                    <a href="#list" data-toggle="tab"><i
                            class="fas fa-list-ul"></i> <?php echo translate('Expense ') . " " . translate('History'); ?>
                    </a>
                </li>
            <?php } ?>
        </ul>
        <div class="alert alert-success text-center" style="font-size: 16px; font-weight: bold;">
            Total Expense: Tk <?= number_format($total_price, 2); ?>
        </div>

        <div class="tab-content">
            <div id="list" class="tab-pane <?php echo (!isset($validation_error) ? 'active' : ''); ?>">
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive mb-sm mt-xs">
                            <?php $this->datatables->generate('dt_authors'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
    // Datatable ajax
    $("#btn-filter").click(function() {
        erTable_dt_authors.ajax.reload();
    });
</script>


<!-- Jquery Datatables JS -->
<script src="<?php echo base_url('assets/vendor/datatables/media/js/jquery.dataTables.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/media/js/dataTables.bootstrap.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/dataTables.buttons.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.bootstrap.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.html5.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.print.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/Buttons-1.4.2/js/buttons.colVis.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/JSZip-2.5.0/jszip.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/pdfmake-0.1.32/pdfmake.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/vendor/datatables/extras/TableTools/pdfmake-0.1.32/vfs_fonts.js'); ?>"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" />

<?php $this->datatables->jquery('dt_authors'); ?>