
<div class="row">
	<div class="col-md-12">
		<section class="panel">
			<?php echo form_open_multipart($this->uri->uri_string(), array('class' => 'form-horizontal form-bordered validate')); ?>
			<div class="panel-heading">
				<h4 class="panel-title">
					<i class="fa fa-edit"></i> <?php echo translate('edit_expense'); ?>
				</h4>
			</div>
			<div class="panel-body">

				<!-- Hidden ID -->
				<input type="hidden" name="id" value="<?php echo html_escape($nas_data['id']); ?>" />

				<!-- Date -->
				<div class="form-group">
					<label class="col-md-3 control-label"><?php echo translate('Date & Time'); ?> <span class="required">*</span></label>
					<div class="col-md-6">
						<input type="datetime-local" class="form-control" name="date" value="<?php echo date('Y-m-d\TH:i', strtotime($nas_data['date'])); ?>" required />
					</div>
				</div>

				<!-- Product List -->
				<div class="form-group">
					<label class="col-md-3 control-label"><?php echo translate('product') . " " . translate('list'); ?> <span class="required">*</span></label>
					<div class="col-md-6">
						<input type="text" class="form-control" name="product_list" value="<?php echo html_escape($nas_data['product_list']); ?>" required />
					</div>
				</div>

				<!-- Quantity and Unit -->
				<div class="form-group">
					<label class="col-md-3 control-label"><?php echo translate('Quantity'); ?> <span class="required">*</span></label>
					<div class="col-md-3">
						<input type="number" step="0.01" class="form-control" name="quantity" value="<?php echo html_escape($nas_data['quantity']); ?>" required />
					</div>
					<div class="col-md-3">
						<select class="form-control" name="unit" required>
							<option value="">Select unit</option>
							<option value="kg" <?php if ($nas_data['unit'] == 'kg') echo 'selected'; ?>>kg</option>
							<option value="liter" <?php if ($nas_data['unit'] == 'liter') echo 'selected'; ?>>liter</option>
							<option value="pcs" <?php if ($nas_data['unit'] == 'pcs') echo 'selected'; ?>>pcs</option>
						</select>
					</div>
				</div>

				<!-- Total Price -->
				<div class="form-group">
					<label class="col-md-3 control-label"><?php echo translate('Total_Price'); ?> <span class="required">*</span></label>
					<div class="col-md-6">
						<input type="text" class="form-control" name="price" value="<?php echo html_escape($nas_data['price']); ?>" required />
					</div>
				</div>

				<!-- Company Name -->
				<div class="form-group">
					<label class="col-md-3 control-label"><?php echo translate('Shop/Market/Company'); ?> <span class="required">*</span></label>
					<div class="col-md-6">
						<input type="text" class="form-control" name="company_name" value="<?php echo html_escape($nas_data['company_name']); ?>" required />
					</div>
				</div>

				<!-- Address -->
				<div class="form-group">
					<label class="col-md-3 control-label"><?php echo translate('address'); ?></label>
					<div class="col-md-6 mb-md">
						<textarea class="form-control" rows="3" name="address"><?php echo html_escape($nas_data['address']); ?></textarea>
					</div>
				</div>
					<!-- Address -->
				<div class="form-group">
					<label class="col-md-3 control-label"><?php echo translate('Expense By'); ?></label>
					<div class="col-md-6 mb-md">
						<textarea class="form-control" rows="3" name="expense_by"><?php echo html_escape($nas_data['expense_by']); ?></textarea>
					</div>
				</div>
			</div>

			<!-- Form Footer -->
			<footer class="panel-footer">
				<div class="row">
					<div class="col-md-offset-10 col-md-2">
						<button type="submit" name="submit" value="update" class="btn btn-default btn-block">
							<i class="fas fa-sync-alt"></i> <?php echo translate('update'); ?>
						</button>
					</div>
				</div>
			</footer>
			<?php echo form_close(); ?>
		</section>
	</div>
</div>
