<div class="row">
	<div class="col-md-12">
		<section class="panel">
			<?php echo form_open_multipart($this->uri->uri_string(), array('class' => 'form-horizontal form-bordered validate')); ?>
			<div class="panel-heading">
				<h4 class="panel-title">
					<i class="fa fa-server"></i> <?php echo translate('add_expense'); ?>
				</h4>
			</div>
			<div class="panel-body">



				<!-- Date -->
				<div class="form-group">
					<label class="col-md-3 control-label"><?php echo translate('Date & Time'); ?> <span class="required">*</span></label>
					<div class="col-md-6">
						<input type="datetime-local" class="form-control" name="date" value="" required />
					</div>
				</div>

				<!-- Product List -->
				<div class="form-group">
					<label class="col-md-3 control-label"><?php echo translate('product') . " " . translate('list'); ?> <span class="required">*</span></label>
					<div class="col-md-6">
						<input type="text" class="form-control" name="product_list" value="" required />
					</div>
				</div>
				<!-- Quantity and Unit -->
				<div class="form-group">
					<label class="col-md-3 control-label"><?php echo translate('Quantity'); ?> <span class="required">*</span></label>
					<div class="col-md-3">
						<input type="number" step="0.01" class="form-control" name="quantity" value="" required />
					</div>
					<div class="col-md-3">
						<select class="form-control" name="unit" required>
							<option value="">Select unit</option>
							<option value="kg">kg</option>
							<option value="liter">liter</option>
							<option value="pcs">pcs</option>
							<!-- Add more units as needed -->
						</select>
					</div>
				</div>



				<!-- Total Price -->
				<div class="form-group">
					<label class="col-md-3 control-label"><?php echo translate('Total_Price'); ?> <span class="required">*</span></label>
					<div class="col-md-6">
						<input type="text" class="form-control" name="price" value="" required />
					</div>
				</div>




				<!-- Company Name -->
				<div class="form-group">
					<label class="col-md-3 control-label"><?php echo translate('Shop/Market/Company'); ?> <span class="required">*</span></label>
					<div class="col-md-6">
						<input type="text" class="form-control" name="company_name" value="" required />
					</div>
				</div>

				<!-- Address -->
				<div class="form-group">
					<label class="col-md-3 control-label"><?php echo translate('address'); ?></label>
					<div class="col-md-6 mb-md">
						<textarea class="form-control" rows="3" name="address" placeholder="<?php echo translate('address'); ?>"><?php echo set_value('address'); ?></textarea>
					</div>
				</div>

				<!-- Expense By -->
				<div class="form-group">
					<label class="col-md-3 control-label"><?php echo translate('Expense By'); ?> <span class="required">*</span></label>
					<div class="col-md-6">
						<input type="text" class="form-control" name="expense_by" value="" required />
					</div>
				</div>



			</div>

			<!-- Form Footer -->
			<footer class="panel-footer">
				<div class="row">
					<div class="col-md-offset-10 col-md-2">
						<button type="submit" name="submit" value="save" class="btn btn-default btn-block">
							<i class="fas fa-plus-circle"></i> <?php echo translate('save'); ?>
						</button>
					</div>
				</div>
			</footer>
			<?php echo form_close(); ?>
		</section>
	</div>
</div>