<section class="panel">
    <div class="tabs-custom">
        <ul class="nav nav-tabs">
            <?php
            $this->db->where_not_in('id', array(1, 4));



            $roles = $this->db->get('roles')->result();
            //print_r($roles);
            // Sort the roles array based on the role name in reverse order.
            usort($roles, function ($a, $b) {
                return strcmp($a->id, $b->id);
            });

            foreach ($roles as $role) {
                // Determine which tabs to display based on the logged-in user's role
                if (($RoleID == 1) || ($RoleID == 2 && ($role->id == 3 || $role->id == 4)) || ($RoleID == 3 && $role->id == 4)) {
                    // Display tabs for Super Admin (role 1), Reseller (role 2 - Sub-Reseller and Customer), and Sub-Reseller (role 3 - Customer)
            ?>
                    <li class="<?php if ($role->id == $act_role)
                                    echo 'active'; ?>">
                        <a href="<?php echo base_url('employee/view/' . $role->id); ?>">
                            <i class="far fa-user-circle"></i>
                            <span>
                                <?php echo html_escape($role->name) ?>
                            </span>
                        </a>
                    </li>
            <?php
                }
            }
            ?>
        </ul>
        <div class="tab-content">
            <div class="tab-pane box active">
                <div class="export_title">
                    <?php echo translate('employee') . " " . translate('list'); ?>
                </div>
                <table class="table table-bordered table-hover table-condensed" cellspacing="0" width="100%"
                    id="table-export">
                    <thead>
                        <tr>
                            <!-- <th><?php echo translate('sl'); ?></th> -->
                            <th><?php echo translate('User ID'); ?></th>
                            <th><?php echo translate('Branch Logo'); ?></th>
                            <th><?php echo translate('Branch name'); ?></th>
                            <th><?php echo translate('Branch ID'); ?></th>
                            <th><?php echo translate('User name'); ?></th>

                            <th><?php echo translate('trade_licence_number'); ?></th>
                            <th><?php echo translate('Creation Date'); ?></th>
                            <th><?php echo translate('Mobile Number'); ?></th>

                            <th><?php echo translate('status'); ?></th>
                            <!-- <th><?php echo translate('Department'); ?></th> -->
                            <!-- <th><?php echo translate('Designation'); ?></th> -->


                            <th><?php echo translate('action'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $i = 1;
                        foreach ($stafflist as $row): ?>
                            <tr>
                                <!-- <td><?php echo $i++; ?></td> -->
                                <td><?php echo html_escape($row->id); ?></td>
                                <td class="center">
                                    <img class="rounded" src="<?php echo $this->app_lib->get_image_url('staff/' . $row->photo); ?>" width="40" height="40" />
                                </td>
                                <td><?php echo html_escape($row->name); ?></td>
                                <td><?php echo html_escape($row->merchant_no); ?></td>
                                <td><?php echo html_escape($row->server_username); ?></td>

                                <td><?php echo html_escape($row->trade_licence_number); ?></td>
                                <td>
                                    <?php echo html_escape(date('d-m-Y h:i A', strtotime($row->created_at))); ?>
                                </td>

                                <td><?php echo html_escape($row->mobileno); ?></td>

                                <td>
                                    <?php if ($row->status == 'Active'): ?>
                                        <span class="badge badge-success" style="background-color: #d4edda; color: #155724;">
                                            Active
                                        </span>
                                    <?php else: ?>
                                        <span class="badge badge-danger" style="background-color: #f8d7da; color: #721c24;">
                                            Inactive
                                        </span>
                                    <?php endif; ?>
                                </td>

                                <td class="min-w-c">
                                    <?php
                                    if ($act_role == 3 && get_permission('doctor_short_bio', 'is_add')): ?>
                                        <a href="<?= base_url('employee/add_short_bio/' . $row->id); ?>"
                                            class="btn btn-circle btn-default icon" data-toggle="tooltip"
                                            data-original-title="Short Bio">
                                            <i class="fas fa-book-reader"></i>
                                        </a>
                                    <?php endif; ?>

                                    <?php if (get_permission('employee', 'is_edit')): ?>
                                        <a href="<?= base_url('employee/profile/' . $row->id); ?>"
                                            class="btn btn-circle btn-default icon" data-toggle="tooltip"
                                            data-original-title="<?= translate('profile'); ?>">
                                            <i class="far fa-arrow-alt-circle-right"></i>
                                        </a>
                                    <?php endif; ?>

                                    <?php if (get_permission('employee', 'is_delete')): ?>
                                        <?= btn_delete('employee/delete/' . $row->id); ?>
                                    <?php endif; ?>
                                    <!-- Toggle Active / Inactive -->
                                    <?php if (get_permission('employee', 'is_edit')): ?>
                                        <?php
                                        $new_status = ($row->status == 'Active') ? 'Inactive' : 'Active';
                                        $btn_class = ($row->status == 'Active') ? 'btn-danger' : 'btn-success';
                                        $icon = ($row->status == 'Active') ? 'fas fa-ban' : 'fas fa-check';
                                        $tooltip = ($row->status == 'Active') ? 'Set Inactive' : 'Set Active';
                                        ?>
                                        <a href="<?= base_url('employee/update_status/' . $row->id . '/' . $new_status); ?>"
                                            class="btn <?= $btn_class ?> btn-circle icon"
                                            data-toggle="tooltip"
                                            title="<?= $tooltip ?>">
                                            <i class="<?= $icon ?>"></i>
                                        </a>
                                    <?php endif; ?>

                                    <?php if (get_permission('employee', 'is_add')): ?>
                                        <a href="<?= base_url('employee/login_as_employee/' . $row->id); ?>"
                                            class="btn btn-circle btn-default icon login-employee-btn"
                                            data-toggle="tooltip"
                                            data-original-title="<?= translate('login_as_branch'); ?>">
                                            <i class="fas fa-sign-in-alt"></i>
                                        </a>
                                    <?php endif; ?>


                                </td>

                            </tr>
                        <?php endforeach; ?>
                    </tbody>

                </table>
            </div>
        </div>
    </div>
</section>

<style>
    #table-export th,
    #table-export td {
        text-align: center;
        vertical-align: middle;
    }
</style>
<!-- <div class="zoom-anim-dialog modal-block modal-block-lg mfp-hide payroll-t-modal" id="modal">
    <section class="panel">
        <header class="panel-heading">
            <h4 class="panel-title"><i class="fas fa-bars"></i>
                <?php //echo translate('Rate') . " " . translate('Profile'); 
                ?>
            </h4>
        </header>
        <div class="panel-body">
            <div id="quick_rate_profile">

            </div>
        </div>
        <footer class="panel-footer">
            <div class="row">
                <div class="col-md-12 text-right">
                    <button class="btn btn-default modal-dismiss">
                        <?php //echo translate('close'); 
                        ?>
                    </button>
                </div>
            </div>
        </footer>
    </section>
</div> -->


<div class="zoom-anim-dialog modal-block modal-block-lg mfp-hide payroll-t-modal" id="modal_emp"
    style="max-width: 500px !important;">
    <section class="panel">
        <header class="panel-heading">
            <h4 class="panel-title"><i class="fas fa-bars"></i>
                <?php echo translate('Add') . " " . translate('Payment'); ?>
            </h4>
        </header>
        <div class="panel-body">
            <div id="quick_add_payment_modal_emp">

            </div>
        </div>
        <footer class="panel-footer">
            <div class="row">
                <div class="col-md-12 text-right">
                    <button class="btn btn-default modal-dismiss">
                        <?php echo translate('close'); ?>
                    </button>
                </div>
            </div>
        </footer>
    </section>
</div>

<div class="zoom-anim-dialog modal-block modal-block-lg mfp-hide payroll-t-modal" id="deducePaymentModel_emp"
    style="max-width: 500px !important;">
    <section class="panel">
        <header class="panel-heading">
            <h4 class="panel-title"><i class="fas fa-bars"></i>
                <?= translate('deduce_payment') ?>
            </h4>
        </header>
        <div class="panel-body">
            <div id="quick_deduce_payment_emp">

            </div>
        </div>
        <footer class="panel-footer">
            <div class="row">
                <div class="col-md-12 text-right">
                    <button class="btn btn-default modal-dismiss">
                        <?php echo translate('close'); ?>
                    </button>
                </div>
            </div>
        </footer>
    </section>
</div>