<?php $currency_symbol = $global_config['currency_symbol']; ?>
<div class="row">
    <div class="col-md-12 mb-lg">
        <div class="profile-head social">
            <div class="col-md-12 col-lg-4 col-xl-3">
                <div class="image-content-center user-pro" style="height: 200px;">
                    <div class="preview">
                        <ul class="social-icon-one">
                            <li>
                                <a href="<?= (empty($staff['facebook_url']) ? '#' : $staff['facebook_url']); ?>">
                                    <span class="fab fa-facebook-f"></span>
                                </a>
                            </li>
                            <li>
                                <a href="<?= (empty($staff['twitter_url']) ? '#' : $staff['twitter_url']); ?>">
                                    <span class="fab fa-twitter"></span>
                                </a>
                            </li>
                            <li>
                                <a href="<?= (empty($staff['linkedin_url']) ? '#' : $staff['linkedin_url']); ?>">
                                    <span class="fab fa-linkedin-in"></span>
                                </a>
                            </li>
                        </ul>
                        <img src="<?= $this->app_lib->get_image_url('staff/' . $staff['photo']); ?>">
                    </div>
                </div>
                <style>
                    .profile-head {
                        background: linear-gradient(to right, #ffffff, #5fa4ff 100%);
                    }

                    .image-content-center .preview img {
                        max-width: 57%;
                        height: auto;
                        display: block;
                        margin: 0 auto;

                    }
                </style>
            </div>
            <div class="col-md-12 col-lg-5 col-xl-5">
                <h5><?= html_escape($staff['name']); ?> </h5>
                <p><?= ucfirst($staff['role']); ?> <?= html_escape($staff['designation_name']); ?></p>
                <ul>
                    <li>
                        <div class="icon-holder" data-toggle="tooltip"
                            data-original-title="<?= translate('Branch ID'); ?>"><i
                                class="fas fa-link"></i>
                        </div> <?= html_escape(!empty($staff['merchant_no']) ? $staff['merchant_no'] : 'N/A'); ?>
                    </li>

                    <!--    <li><div class="icon-holder" data-toggle="tooltip" data-original-title="<?= translate('department'); ?>"><i class="fas fa-user-tie"></i></div> <?= html_escape(!empty($staff['department_name']) ? $staff['department_name'] : 'N/A'); ?></li>	-->

                    <li>
                        <div class="icon-holder" data-toggle="tooltip"
                            data-original-title="<?= translate('mobile_number'); ?>"><i class="fas fa-phone"></i>
                        </div> <?= html_escape(!empty($staff['mobileno']) ? $staff['mobileno'] : 'N/A'); ?>
                    </li>
                    <li>
                        <div class="icon-holder" data-toggle="tooltip"
                            data-original-title="<?= translate('e-mail'); ?>"><i class="far fa-envelope"></i>
                        </div> <?= html_escape($staff['email']); ?>
                    </li>

                    <!--    <li><div class="icon-holder" data-toggle="tooltip" data-original-title="<?= translate('address'); ?>"><i class="fas fa-home"></i></div> <?= html_escape(!empty($staff['address']) ? $staff['address'] : 'N/A'); ?></li> -->
                </ul>
            </div>
        </div>
    </div>

    <div class="col-md-12">
        <div class="panel-group" id="accordion">
            <div class="panel panel-accordion">
                <div class="panel-heading">
                    <h4 class="panel-title">
                        <div class="auth-pan">
                            <button class="btn btn-default btn-circle" id="notify_btn">
                                <i class="fas fa-bell"></i> <?= translate('Notify'); ?>
                            </button>
                        </div>
                        <div class="auth-pan">
                            <button class="btn btn-default btn-circle" id="authentication_btn">
                                <i class="fas fa-unlock-alt"></i> <?= translate('Change Password'); ?>
                            </button>
                        </div>

                        <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#profile">
                            <i class="fas fa-user-edit"></i> <?= translate('profile'); ?>
                        </a>
                    </h4>
                </div>
                <div id="profile"
                    class="accordion-body collapse <?= ($this->session->flashdata('profile_tab') ? 'in' : ''); ?>">
                    <?= form_open_multipart($this->uri->uri_string()); ?>
                    <div class="panel-body">
                        <fieldset>
                            <?= form_hidden('user_id', get_loggedin_user_id()) ?>
                            <input type="hidden" name="staff_id" id="staff_id"
                                value="<?= html_escape($staff['id']); ?>">
                            <!-- Employee Details -->
                            <div class="headers-line mt-md"><i
                                    class="fas fa-user-check"></i> <?= translate('basic_details'); ?></div>
                            <div class="row">
                                <!-- Merchant number -->
                                <div class="col-md-6 mb-sm">
                                    <div class="form-group <?php if (form_error('merchant_no')) echo 'has-error'; ?>">
                                        <label class="control-label"><?= translate('Branch ID'); ?> <span
                                                class="required">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-addon"><i class="far fa-user"></i></span>
                                            <input type="text" class="form-control" name="merchant_no"
                                                value="<?= $staff['merchant_no']; ?>" required readonly />
                                        </div>
                                        <span class="error"><?= form_error('merchant_no'); ?></span>
                                    </div>
                                </div>
                                <!-- -->
                                <div class="col-md-6 mb-sm">
                                    <div class="form-group <?php if (form_error('name')) echo 'has-error'; ?>">
                                        <label class="control-label"><?= translate('Branch Name'); ?> <span
                                                class="required">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-addon"><i class="far fa-user"></i></span>
                                            <input type="text" class="form-control" name="name"
                                                value="<?= set_value('name', $staff['name']); ?>" />
                                        </div>
                                        <span class="error"><?= form_error('name'); ?></span>
                                    </div>
                                </div>
                                <!--    <div class="col-md-12 mb-sm">
                                        <div class="form-group">
                                            <label class="control-label"><?= translate('gender'); ?></label>
                                            <?php
                                            $gender_array = array(
                                                "" => translate('select'),
                                                "male" => translate('male'),
                                                "female" => translate('female')
                                            );
                                            echo form_dropdown("gender", $gender_array, set_value('gender', $staff['gender']), "class='form-control' data-plugin-selectTwo data-width='100%'
												data-minimum-results-for-search='Infinity'");
                                            ?>
                                        </div>
                                    </div> -->
                            </div>


                            <div class="row">
                                <div class="col-md-6 mb-sm">
                                    <div class="form-group <?php if (form_error('mobile_no')) echo 'has-error'; ?>">
                                        <label class="control-label"><?= translate('mobile_number'); ?></label>
                                        <div class="input-group">
                                            <span class="input-group-addon"><i class="fas fa-phone-volume"></i></span>
                                            <input class="form-control" name="mobile_no" type="text"
                                                value="<?= set_value('mobile_no', $staff['mobileno']); ?>">
                                        </div>
                                        <span class="error"><?= form_error('mobile_no'); ?></span>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-sm">
                                    <div class="form-group <?php if (form_error('email')) echo 'has-error'; ?>">
                                        <label class="control-label"><?= translate('e-mail'); ?> <span
                                                class="required">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-addon"><i class="far fa-envelope-open"></i></span>
                                            <input type="text" class="form-control" name="email" id="email"
                                                value="<?= set_value('email', $staff['email']); ?>" />
                                        </div>
                                        <span class="error"><?= form_error('email'); ?></span>
                                    </div>
                                </div>

                            </div>


                            <!----------- TODO:  address ------------->
                            <!-- <div class="row">
                                    <div class="col-md-12 mb-sm">
                                        <div class="form-group">
                                            <label class="control-label"><?= translate('address'); ?></label>
                                            <textarea class="form-control" rows="2" name="address" placeholder="<?= translate('address'); ?>" ><?= set_value('address', $staff['address']); ?></textarea>
                                        </div>
                                    </div>
                                </div> -->

                            <div class="row mb-md">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="input-file-now"><?= translate('Logo'); ?></label>
                                        <input type="file" name="user_photo" class="dropify"
                                            data-allowed-file-extensions="jpg png"
                                            data-default-file="<?= $this->app_lib->get_image_url('staff/' . $staff['photo']); ?>" />
                                    </div>
                                </div>
                                <input type="hidden" name="old_user_photo"
                                    value="<?= html_escape($staff['photo']); ?>" />
                            </div>

                            <!-- Login Details -->
                            <div class="headers-line"><i
                                    class="fas fa-user-lock"></i> <?= translate('login_details'); ?></div>

                            <div class="row mb-lg">
                                <div class="col-md-12 mb-sm">
                                    <div class="form-group <?php if (form_error('username')) echo 'has-error'; ?>">
                                        <label class="control-label"><?= translate('username'); ?> <span
                                                class="required">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-addon"><i class="fas fa-user-lock"></i></span>
                                            <input type="text" class="form-control" name="username" id="username"
                                                value="<?= set_value('username', $staff['username']); ?>" readonly />

                                        </div>
                                        <span class="error"><?= form_error('username'); ?></span>
                                    </div>
                                </div>
                            </div>

                            <!-- Office Details -->
                            <?php if ($RoleID != ROLE_ADMIN_ID) {
                                $hidden_div = "style=display:none";
                            } else {
                                $hidden_div = "";
                            } ?>
                            <div class="headers-line" <?= $hidden_div; ?>>
                                <i class="fas fa-school"></i>
                                <?= translate('office_details'); ?>
                            </div>

                            <div class="row" <?= $hidden_div; ?>>
                                <div class="col-md-6 mb-sm">
                                    <div class="form-group <?php if (form_error('user_role')) echo 'has-error'; ?>">
                                        <label class="control-label">
                                            <?= translate('role'); ?> <span class="required">*</span>
                                        </label>
                                        <?= form_dropdown(
                                            "user_role",
                                            $role_list,
                                            array_search($staff['role'], $role_list),
                                            "class='form-control' data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' id='user-role'"
                                        ) ?>
                                        <span class="error"><?= form_error('user_role'); ?></span>
                                    </div>
                                </div>



                                <?php if (loggedin_role_id() == 1): ?>
                                    <!-- Add the Assigned Admin field -->
                                    <div class="col-md-6 mb-sm" id="assigned_admin" style="display:none">
                                        <div class="form-group <?php if (form_error('assigned_admin')) echo 'has-error'; ?>">
                                            <label class="control-label">
                                                <?php echo translate('Assigned Admin'); ?>
                                                <span class="required">*</span>
                                            </label>
                                            <?php
                                            $all_admins_list = ["" => "Select Admin..."];
                                            foreach ($all_admins as $alist) {
                                                $admin_id = $alist->id;
                                                $admin_name = $alist->name;
                                                $admin_mno = $alist->merchant_no;
                                                $all_admins_list[$admin_id] = $admin_name;
                                            }
                                            echo form_dropdown(
                                                "assign_to",
                                                $all_admins_list,
                                                $staff['assign_to'],
                                                "class='form-control' id='assign_to'  data-plugin-selectTwo data-width='100%'"
                                            );
                                            ?>
                                            <span class="error"><?php echo form_error('assign_to'); ?></span>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <input type="hidden" name="assigned_admin"
                                        value="<?php echo get_loggedin_user_id(); ?>">
                                <?php endif; ?>


                            </div>



                            <!-- Add the Assigned Customer field -->
                            <div class="row" id="assigned_customer">

                                <!-- packages -->
                                <div class="col-sm-6 form-group <?= form_error('package_id') ? 'has-error' : null; ?>">
                                    <label for="package_id" class="control-label">
                                        <?= translate('package'); ?> <span class="required">*</span>
                                    </label>
                                    <select class='form-control' data-plugin-selectTwo data-width='100%'
                                        name="package_id"
                                        id="package_id">
                                        <?php if (empty($packages)): ?>
                                            <option value=""><?= translate('No Packages Found') ?></option>
                                        <?php else: ?>
                                            <option value=""><?= translate('Select Package') ?></option>
                                            <?php foreach ($packages as $package) { ?>
                                                <option value="<?= $package->id; ?>" <?= set_select('package_id', $package->id, $staff['package_id'] == $package->id) ?>>
                                                    <?= $package->name; ?>
                                                </option>
                                            <?php } ?>
                                        <?php endif; ?>
                                    </select>
                                    <span class="error"><?php echo form_error('package_id'); ?></span>
                                </div>

                                <!-- zone -->
                                <div class="col-sm-6 form-group <?= form_error('zone_id') ? 'has-error' : null; ?>">
                                    <label for="zone_id" class="control-label">
                                        <?= translate('zone'); ?> <span class="required">*</span>
                                    </label>
                                    <select class="form-group" data-plugin-selectTwo data-width='100%' name="zone_id"
                                        id="zone_id">
                                        <?php if (empty($zones)): ?>
                                            <option value=""><?= translate('No Zones Found') ?></option>
                                        <?php else: ?>
                                            <option value=""><?= translate('Select Zone') ?></option>
                                            <?php foreach ($zones as $zone) { ?>
                                                <option value="<?= $zone->id; ?>" <?= set_select('zone_id', $zone->id, $staff['zone_id'] == $zone->id) ?>>
                                                    <?= $zone->name; ?>
                                                </option>
                                            <?php } ?>
                                        <?php endif; ?>
                                    </select>
                                    <span class="error"><?php echo form_error('zone_id'); ?></span>
                                </div>
                            </div>
                        </fieldset>
                    </div>
                    <div class="panel-footer">
                        <div class="row">
                            <div class="col-md-offset-9 col-md-3">
                                <button type="submit" name="submit" value="update" class="btn btn-default btn-block">
                                    <?= translate('update') ?>
                                </button>
                            </div>
                        </div>
                    </div>
                    <?= form_close(); ?>
                </div>
            </div>
            <div class="panel panel-accordion">
                <div class="panel-heading">
                    <h4 class="panel-title">
                        <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion" href="#documents_details">
                            <i class="fas fa-folder-open"></i> <?php echo translate('document') . " " . translate('details'); ?>
                        </a>
                    </h4>
                </div>
                <div id="documents_details" class="accordion-body collapse <?php echo ($this->session->flashdata('documents_details') == 1 ? 'in' : ''); ?>">
                    <div class="panel-body">
                        <div class="text-right mb-sm">
                            <a href="javascript:void(0);" id="addStaffDocuments" class="btn btn-circle btn-default mb-sm">
                                <i class="fas fa-plus-circle"></i> <?php echo translate('add') . " " . translate('document'); ?>
                            </a>
                        </div>
                        <div class="table-responsive mb-md">
                            <table class="table table-bordered table-hover table-condensed mb-none">
                                <thead>
                                    <tr>
                                        <th><?php echo translate('sl'); ?></th>
                                        <th><?php echo translate('title'); ?></th>
                                        <th><?php echo translate('document') . " " . translate('type'); ?></th>
                                        <th><?php echo translate('file'); ?></th>
                                        <th><?php echo translate('remarks'); ?></th>
                                        <th><?php echo translate('created_at'); ?></th>
                                        <th><?php echo translate('actions'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $count = 1;
                                    $this->db->where('staff_id', $staff['id']);
                                    $documents = $this->db->get('staff_documents')->result();
                                    if (count($documents)) {
                                        foreach ($documents as $row):
                                    ?>
                                            <tr>
                                                <td><?php echo $count++ ?></td>
                                                <td><?php echo html_escape($row->title); ?></td>
                                                <td><?php echo html_escape($categorylist[$row->category_id]); ?></td>
                                                <td><?php echo html_escape($row->file_name); ?></td>
                                                <td><?php echo html_escape($row->remarks); ?></td>
                                                <td><?php echo html_escape(_d($row->created_at)); ?></td>
                                                <td class="min-w-c">
                                                    <a href="<?php echo base_url('employee/documents_download?file=' . $row->enc_name); ?>" class="btn btn-default btn-circle icon" data-toggle="tooltip" data-original-title="<?php echo translate('download'); ?>">
                                                        <i class="fas fa-cloud-download-alt"></i>
                                                    </a>
                                                    <a href="javascript:void(0);" data-id="<?php echo html_escape($row->id); ?>" class="btn btn-circle icon btn-default" onclick="editStaffDocument('<?php echo html_escape($row->id); ?>')">
                                                        <i class="fas fa-pen-nib"></i>
                                                    </a>
                                                    <?php echo btn_delete('employee/document_delete/' . $row->id); ?>
                                                </td>
                                            </tr>
                                    <?php
                                        endforeach;
                                    } else {
                                        echo '<tr> <td colspan="7"> <h5 class="text-danger text-center">' . translate('no_information_available') . '</h5> </td></tr>';
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>


<!-- Login Authentication And Account Inactive Modal -->
<div id="authentication_modal" class="zoom-anim-dialog modal-block modal-block-primary mfp-hide">
    <section class="panel">
        <header class="panel-heading">
            <h4 class="panel-title">
                <i class="fas fa-unlock-alt"></i> <?= translate('authentication'); ?>
            </h4>
        </header>
        <div class="panel-body">
            <div class="form-group">
                <label for="password" class="control-label"><?= translate('password'); ?> <span
                        class="required">*</span></label>
                <div class="input-group">
                    <input type="password" class="form-control password" name="password" id="reset_password" />
                    <span class="input-group-addon">
                        <a href="javascript:void(0);" id="showPassword"><i class="fa fa-eye"></i></a>
                    </span>
                </div>
                <span class="control-label" id="password-msg"></span>
            </div>
            <div class="form-group mb-md">
                <div class="checkbox-replace">
                    <label class="i-checks">
                        <input type="checkbox" name="authentication" id="cb_authentication">
                        <i></i> <?= translate('login_authentication_deactivate'); ?>
                    </label>
                </div>
            </div>
        </div>
        <footer class="panel-footer">
            <div class="text-right">
                <button class="btn btn-default mr-xs" id="staffPassUpdate"
                    data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing"><?= translate('update'); ?></button>
                <button class="btn btn-default modal-dismiss"><?= translate('close'); ?></button>
            </div>
        </footer>
    </section>
</div>


<!-- Documents Details Add Modal -->
<div id="add_documents_modal" class="zoom-anim-dialog modal-block modal-block-primary mfp-hide">
    <section class="panel">
        <div class="panel-heading">
            <h4 class="panel-title"><i class="fas fa-plus-circle"></i> <?php echo translate('add') . " " . translate('document'); ?></h4>
        </div>
        <?php echo form_open_multipart(base_url('employee/document_create'), array('class' => 'form-horizontal', 'id' => 'docaddfrm')); ?>
        <div class="panel-body">
            <input type="hidden" name="staff_id" value="<?php echo html_escape($staff['id']); ?>">
            <div class="form-group mt-md">
                <label class="col-md-3 control-label"><?php echo translate('title'); ?> <span class="required">*</span></label>
                <div class="col-md-9">
                    <input type="text" class="form-control" name="document_title" id="adocument_title" value="" />
                    <span class="error"></span>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3 control-label"><?php echo translate('category'); ?> <span class="required">*</span></label>
                <div class="col-md-9">
                    <?php
                    echo form_dropdown("document_category", $categorylist, set_value('document_category'), "class='form-control' data-plugin-selectTwo
                        data-width='100%' id='adocument_category' data-minimum-results-for-search='Infinity' ");
                    ?>
                    <span class="error"></span>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3 control-label"><?php echo translate('document') . " " . translate('file'); ?> <span class="required">*</span></label>
                <div class="col-md-9">
                    <input type="file" name="document_file" class="dropify" data-height="110" data-default-file="" id="adocument_file" />
                    <span class="error"></span>
                </div>
            </div>
            <div class="form-group mb-md">
                <label class="col-md-3 control-label"><?php echo translate('remarks'); ?></label>
                <div class="col-md-9">
                    <textarea class="form-control valid" rows="2" name="remarks"></textarea>
                </div>
            </div>
        </div>
        <footer class="panel-footer">
            <div class="row">
                <div class="col-md-12 text-right">
                    <button type="submit" id="docsavebtn" class="btn btn-default" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
                        <i class="fas fa-plus-circle"></i> <?php echo translate('save'); ?>
                    </button>
                    <button class="btn btn-default modal-dismiss"><?php echo translate('cancel'); ?></button>
                </div>
            </div>
        </footer>
        <?php echo form_close(); ?>
    </section>
</div>
<div id="notify_modal" class="zoom-anim-dialog modal-block modal-block-primary mfp-hide">
    <section class="panel">
        <header class="panel-heading">
            <h4 class="panel-title">
                <i class="fas fa-bell"></i> <?= translate('Send Notification'); ?>
            </h4>
        </header>
        <div class="panel-body">
            <input type="hidden" name="user_id" value="<?= $staff['id'] ?? ''; ?>">

            <div class="form-group">
                <label class="font-weight-bold"><?= translate('Choose Notification Method'); ?></label>
                <div class="d-flex justify-content-between p-3 border rounded bg-white shadow-sm">


                    <!-- Email Option -->
                    <div class="text-center p-2 flex-fill mx-2 border rounded notification-option" style="cursor: pointer;">
                        <input type="checkbox" id="notify_email" class="d-none">
                        <label for="notify_email" class="d-block">
                            <i class="fas fa-envelope fa-2x text-success"></i>
                            <p class="mb-0 mt-1"><?= translate('Send via Email'); ?></p>
                        </label>

                        <input type="checkbox" id="notify_sms" class="d-none">
                        <label for="notify_sms" class="d-block">
                            <i class="fas fa-sms fa-2x text-primary"></i>
                            <p class="mb-0 mt-1"><?= translate('Send via SMS'); ?></p>
                        </label>

                    </div>
                </div>
            </div>

        </div>
        <footer class="panel-footer">
            <div class="text-right">
                <button class="btn btn-default" id="send_notification" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Sending">
                    <?= translate('Send Notification'); ?>
                </button>
                <button class="btn btn-default modal-dismiss"><?= translate('Close'); ?></button>
            </div>
        </footer>
    </section>
</div>

<!-- Documents Details Edit Modal -->
<div id="editDocModal" class="zoom-anim-dialog modal-block modal-block-primary mfp-hide">
    <section class="panel">
        <div class="panel-heading">
            <h4 class="panel-title"><i class="far fa-edit"></i> <?php echo translate('edit') . " " . translate('document'); ?></h4>
        </div>
        <?php echo form_open_multipart(base_url('employee/document_update'), array('class' => 'form-horizontal', 'id' => 'doceditfrm')); ?>
        <div class="panel-body">
            <input type="hidden" name="document_id" id="edocument_id" value="">
            <div class="form-group mt-md">
                <label class="col-md-3 control-label"><?php echo translate('title'); ?> <span class="required">*</span></label>
                <div class="col-md-9">
                    <input type="text" class="form-control" name="document_title" id="edocument_title" value="" />
                    <span class="error"></span>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3 control-label"><?php echo translate('category'); ?> <span class="required">*</span></label>
                <div class="col-md-9">
                    <?php
                    echo form_dropdown("document_category", $categorylist, set_value('document_category'), "class='form-control' data-plugin-selectTwo id='edocument_category'
                            data-width='100%' data-minimum-results-for-search='Infinity' ");
                    ?>
                    <span class="error"></span>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-3 control-label"><?php echo translate('document') . " " . translate('file'); ?> <span class="required">*</span></label>
                <div class="col-md-9">
                    <input type="file" name="document_file" class="dropify" data-height="120" data-default-file="">
                    <input type="hidden" name="exist_file_name" id="exist_file_name" value="">
                </div>
            </div>
            <div class="form-group mb-md">
                <label class="col-md-3 control-label"><?php echo translate('remarks'); ?></label>
                <div class="col-md-9">
                    <textarea class="form-control valid" rows="2" name="remarks" id="edocuments_remarks"></textarea>
                </div>
            </div>
        </div>
        <footer class="panel-footer">
            <div class="row">
                <div class="col-md-12 text-right">
                    <button type="submit" class="btn btn-default" id="doceditbtn" data-loading-text="<i class='fas fa-spinner fa-spin'></i> Processing">
                        <?php echo translate('update'); ?>
                    </button>
                    <button class="btn btn-default modal-dismiss"><?php echo translate('cancel'); ?></button>
                </div>
            </div>
        </footer>
        <?php echo form_close(); ?>
    </section>
</div>
<!-- user authentication modal show -->
<script type="text/javascript">
    $(document).ready(function() {
        // user authentication modal show
        $('#authentication_btn').on('click', function() {
            var status = "<?= html_escape($staff['active']); ?>";
            if (status === '0') {
                $('#cb_authentication').prop('checked', true);
                $('#cb_authentication').prop('disabled', true);
                $('#reset_password').val("");
                $('#reset_password').prop('disabled', true);
            } else {
                $('#cb_authentication').prop('checked', false);
                $('#cb_authentication').prop('disabled', false);
                $('#reset_password').val("");
                $('#reset_password').prop('disabled', false);
            }
            mfp_modal('#authentication_modal');
        });
    });
</script>
<script type="text/javascript">
    $(document).ready(function() {
        // Show modal for notification options when clicking Notify button
        $('#notify_btn').on('click', function() {
            mfp_modal('#notify_modal'); // Open the new modal
        });

        // Handle notification type selection
        $('#send_notification').on('click', function() {
            var $this = $(this);
            var userId = $('input[name="user_id"]').val();
            var notifyBySms = $('#notify_sms').prop('checked') ? 1 : 0;
            var notifyByEmail = $('#notify_email').prop('checked') ? 1 : 0;

            if (notifyBySms === 0 && notifyByEmail === 0) {
                alert("Please select at least one notification method.");
                return;
            }

            // Add loading state to the button
            $this.button('loading');

            $.ajax({
                url: base_url + 'employee/update_notification_settings', // Updated URL to match your controller method
                type: 'POST',
                data: {
                    user_id: userId,
                    notify_sms: notifyBySms,
                    notify_email: notifyByEmail
                },
                dataType: 'json',
                success: function(response) {
                    $this.button('reset');
                    if (response.status === 'success') {
                        location.reload(); // Optionally reload the page or update UI
                    } else {

                    }
                },
                error: function() {
                    $this.button('reset');
                }
            });
        });
    });
</script>



<script type="text/javascript">
    $(document).ready(function() {
        // Show modal for expire time
        $('#expiretime_btn').on('click', function() {
            mfp_modal('#expiretime_modal');
        });

        // Handle the update button click
        $('#userchangeexpiretime').on('click', function() {
            var $this = $(this);
            var hour = $('select[name="hour"]').val();
            var minute = $('select[name="minute"]').val();
            var ampm = $('select[name="ampm"]').val();
            var userId = $('input[name="user_id"]').val();

            // Add loading state to the button
            $this.button('loading');

            $.ajax({
                url: base_url + 'employee/change_expiretime',
                type: 'POST',
                data: {
                    user_id: userId,
                    hour: hour,
                    minute: minute,
                    ampm: ampm
                },
                dataType: 'json',
                success: function(response) {
                    $this.button('reset');
                    if (response.status === 'success') {
                        location.reload(); // Reload to reflect changes
                    }
                },
                error: function() {
                    $this.button('reset');
                }
            });
        });
    });
</script>

<script>
    $(document).ready(function() {
        var roleDropdown = $("select[name='user_role']");
        var assignedAdmin = $("#assign_to");

        // Function to toggle the visibility of the Assigned Admin field
        function toggleAssignedAdmin() {
            var selectedRole = roleDropdown.val();
            if (selectedRole === "3") {
                assignedAdmin.show();
                assignedAdmin.find("select").prop("", true); // Make it required
            } else {
                assignedAdmin.hide().val('');
                assignedAdmin.find("select").prop("required", false); // Make it not required
            }
        }

        // Initial toggle based on the selected role
        toggleAssignedAdmin();

        // Attach an event listener to the role dropdown to toggle visibility on change
        roleDropdown.on("change", function() {
            toggleAssignedAdmin();
        });
    });
</script>

<script>
    // on change of a role, toggle the visibility of the Assigned customer field
    $(document).ready(function() {
        const roleDropdown = $("#user-role");
        const assignedCustomer = $("#assigned_customer");

        // Function to toggle the visibility of the Assigned customer field
        function toggleAssignedCustomer() {
            const selectedRole = roleDropdown.val();
            if (selectedRole === '<?= ROLE_CUSTOMER_ID ?>') {
                assignedCustomer.show();
                assignedCustomer.find("select").prop("required", true); // Make it required
            } else {
                assignedCustomer.hide().val('');
                assignedCustomer.find("select").prop("required", false); // Make it not required
            }
        }

        // Initial toggle based on the selected role
        toggleAssignedCustomer();

        // Attach an event listener to the role dropdown to toggle visibility on change
        roleDropdown.on("change", function() {
            toggleAssignedCustomer();
        });
    });

    // on change of a role, toggle the visibility of the recharge day field
    $(document).ready(function() {
        const roleDropdown = $("select[name='user_role']");
        const rechargeDay = $("#recharge_day");

        // Function to toggle the visibility of the Assigned customer field
        function toggleRechargeDay() {
            const selectedRole = roleDropdown.val();
            if (selectedRole == <?= ROLE_RESELLER_ID ?> || selectedRole == <?= ROLE_SUBRESELLER_ID ?>) {
                rechargeDay.show();
                rechargeDay.find("select").prop("required", true); // Make it required
            } else {
                rechargeDay.hide();
                rechargeDay.find("select").prop("required", false); // Make it not required
            }
        }

        // Initial toggle based on the selected role
        toggleRechargeDay();

        // Attach an event listener to the role dropdown to toggle visibility on change
        roleDropdown.on("change", function() {
            toggleRechargeDay();
        });
    });
</script>