<div class="row">
    <div class="col-md-12">
        <section class="panel">
            <?php echo form_open_multipart(current_url()); ?>
            <input type="hidden" name="user_id" value="<?php echo get_loggedin_user_id(); ?>">
            <div class="panel-heading">
                <h4 class="panel-title">
                    <i class="far fa-user-circle"></i> <?php echo translate('Branch Create'); ?>
                </h4>
            </div>
            <div class="panel-body">
                <!-- Basic Details -->
                <div class="headers-line mt-md">
                    <i class="fas fa-user-check"></i> <?php echo translate('basic_details'); ?>
                </div>
                <div class="row">
                    <div class="col-md-4 mb-sm">
                        <div class="form-group <?php if (form_error('merchant_no')) echo 'has-error'; ?>">
                            <label class="control-label"><?php echo translate('Branch ID'); ?> <span class="required">*</span></label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="far fa-user"></i></span>
                                <input class="form-control" name="merchant_no" type="text" value="<?php echo $next_merchant_no; ?>" required readonly>

                            </div>
                            <span class="error"><?php echo form_error('merchant_no'); ?></span>
                        </div>
                    </div>
                    <div class="col-md-4 mb-sm">
                        <div class="form-group <?php if (form_error('name')) echo 'has-error'; ?>">
                            <label class="control-label"><?php echo translate('Branch name'); ?> <span class="required">*</span></label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="far fa-user"></i></span>
                                <input class="form-control" name="name" type="text" value="<?php echo set_value('name'); ?>" placeholder="Foodexl">
                                </div>
                            <span class="error"><?php echo form_error('name'); ?></span>
                        </div>
                    </div>
                    <div class="col-md-4 mb-sm">
                        <div class="form-group <?= form_error('email') ? 'has-error' : '' ?>">
                            <label for="email" class="control-label"><?= translate('e-mail'); ?> <span class="required">*</span></label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="far fa-envelope-open"></i></span>
                                <input type="email" class="form-control" name="email" id="email" value="<?= set_value('email'); ?>" placeholder="branch@gmail.com" />
                                </div>
                            <span class="error"><?= form_error('email'); ?></span>
                        </div>
                    </div>
                </div>



                <div class="row">

                    <div class="col-md-4 mb-sm">
                        <div class="form-group <?php if (form_error('trade_licence_number')) echo 'has-error'; ?>">
                            <label class="control-label"><?php echo translate('trade_licence_number'); ?></label>
                            <input class="form-control" name="trade_licence_number" type="text" value="<?php echo set_value('trade_licence_number'); ?>" required placeholder="TLN-123456789">
                            <span class="error"><?php echo form_error('trade_licence_number'); ?></span>
                        </div>
                    </div>
                    <div class="col-md-4 mb-sm">
                        <div class="form-group <?php if (form_error('payment_account')) echo 'has-error'; ?>">
                            <label class="control-label"><?php echo translate('Account_number'); ?></label>
                            <input class="form-control" name="payment_account" type="text" value="<?php echo set_value('payment_account'); ?>" required placeholder=" bKash/Nagad/Rocket or Any Bank Account">
                            <span class="error"><?php echo form_error('payment_account'); ?></span>
                        </div>
                    </div>
                    <div class="col-md-4 mb-sm">
                        <div class="form-group <?php if (form_error('mobile_no')) echo 'has-error'; ?>">
                            <label class="control-label"><?php echo translate('mobile_number'); ?></label>
                            <input class="form-control" name="mobile_no" type="tel" value="<?php echo set_value('mobile_no'); ?>" required placeholder="+8801XXXXXXXXX">
                            <span class="error"><?php echo form_error('mobile_no'); ?></span>
                        </div>
                    </div>


                </div>
                <div class="row mb-md">

                    <div class="col-md-12 ">
                        <div class="form-group">
                            <label for="address" class="control-label"><?= translate('Branch Address (Details)'); ?></label>
                            <textarea class="form-control" rows="3" name="address" id="address" placeholder=" House/ Flat No: , Road/Street No: ,Post Code/Zip: , Local Area/Sub-district: , District/County: , Country: "><?= set_value('address'); ?></textarea>
                            </div>
                    </div>
                </div>


                <div class="row mb-md">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="input-file-now"><?= translate(' Logo'); ?></label>
                            <input type="file" name="user_photo" class="dropify" data-allowed-file-extensions="jpg png" data-height="120" />
                        </div>
                    </div>
                </div>

                <!-- Login Details -->
                <div class="headers-line">
                    <i class="fas fa-user-lock"></i> <?php echo translate('login_details'); ?>
                </div>
                <div class="row mb-lg">
                    <div class="col-md-6 mb-sm">
                        <div class="form-group <?php if (form_error('username')) echo 'has-error'; ?>">
                            <label class="control-label"><?php echo translate('username'); ?> <span
                                    class="required">*</span></label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="fas fa-user-lock"></i></span>
                                <input type="text" class="form-control" name="username" id="username"
                                    value="<?php echo set_value('username'); ?>" />
                            </div>
                            <span class="error"><?php echo form_error('username'); ?></span>
                        </div>
                    </div>
                    <div class="col-md-3 mb-sm">
                        <div class="form-group <?php if (form_error('password')) echo 'has-error'; ?>">
                            <label class="control-label"><?php echo translate('password'); ?> <span
                                    class="required">*</span></label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="fas fa-unlock-alt"></i></span>
                                <input type="password" class="form-control" name="password"
                                    value="<?php echo set_value('password'); ?>" />
                            </div>
                            <span class="error"><?php echo form_error('password'); ?></span>
                        </div>
                    </div>
                    <div class="col-md-3 mb-sm">
                        <div class="form-group <?php if (form_error('retype_password')) echo 'has-error'; ?>">
                            <label class="control-label"><?php echo translate('retype_password'); ?> <span
                                    class="required">*</span></label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="fas fa-unlock-alt"></i></span>
                                <input type="password" class="form-control" name="retype_password"
                                    value="<?php echo set_value('retype_password'); ?>" />
                            </div>
                            <span class="error"><?php echo form_error('retype_password'); ?></span>
                        </div>
                    </div>


                </div>

                <!-- Office Details -->
                <?php if ($RoleID != 1) {
                    $hidden_div = "style=display:none";
                } else {
                    $hidden_div = "";
                } ?>

                <div class="headers-line" <?php echo $hidden_div; ?>>
                    <i class="fas fa-school"></i> <?php echo translate('office_details'); ?>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-sm">
                        <div class="form-group <?php if (form_error('user_role')) echo 'has-error'; ?>">
                            <label class="control-label">
                                <?php echo translate('role'); ?> <span class="required">*</span>
                            </label>
                            <?= form_dropdown(
                                "user_role",
                                $role_list,
                                '',
                                "class='form-control' data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity' id='user-role'"
                            ) ?>
                            <span class="error"><?php echo form_error('user_role'); ?></span>
                        </div>
                    </div>

                    <?php if (loggedin_role_id() == 1): ?>
                        <!-- Add the Assigned Admin field -->
                        <div class="col-md-6 mb-sm" id="assigned_admin" style="display:none">
                            <div class="form-group <?php if (form_error('assigned_admin')) echo 'has-error'; ?>">
                                <label class="control-label"><?php echo translate('Assigned Admin'); ?> <span
                                        class="required">*</span></label>
                                <?php
                                $all_admins_list = ["" => "Select Admin..."];
                                foreach ($all_admins as $alist) {
                                    $admin_id = $alist->id;
                                    $admin_name = $alist->name;
                                    $admin_mno = $alist->merchant_no;
                                    $all_admins_list[$admin_mno] = $admin_name;
                                }
                                echo form_dropdown("assigned_admin", $all_admins_list, html_escape(set_value('assigned_admin')), "name='assigned_admin' class='form-control' id='assigned_admin'  data-plugin-selectTwo data-width='100%'");
                                ?>
                                <span class="error"><?php echo form_error('assigned_admin'); ?></span>
                            </div>
                        </div>
                    <?php else: ?>
                        <input type="hidden" name="assigned_admin" value="<?php echo get_loggedin_user_id(); ?>">
                    <?php endif; ?>
                </div>


                <div class="row" id="recharge_day" style="display: none">


                </div>
            </div>

            <footer class="panel-footer">
                <div class="row">
                    <div class="col-md-offset-10 col-md-2">
                        <button type="submit" name="submit" value="save" class="btn btn btn-default btn-block"><i
                                class="fas fa-plus-circle"></i> <?php echo translate('save'); ?></button>
                    </div>
                </div>
            </footer>

            <?php echo form_close(); ?>
        </section>
    </div>
</div>

<script>
    $(document).ready(function() {
        var roleDropdown = $("select[name='user_role']");
        var assignedAdmin = $("#assigned_admin");

        // Function to toggle the visibility of the Assigned Admin field
        function toggleAssignedAdmin() {
            var selectedRole = roleDropdown.val();
            if (selectedRole === "3") {
                assignedAdmin.show();
                assignedAdmin.find("select").prop("", true); // Make it required
            } else {
                assignedAdmin.hide().val('');
                assignedAdmin.find("select").prop("required", false); // Make it not required
            }
        }

        // Initial toggle based on the selected role
        toggleAssignedAdmin();

        // Attach an event listener to the role dropdown to toggle visibility on change
        roleDropdown.on("change", function() {
            toggleAssignedAdmin();
        });
    });
</script>

<script>
    // on change of a role, toggle the visibility of the Assigned customer field
    $(document).ready(function() {
        const roleDropdown = $("select[name='user_role']");
        const assignedDepdesig = $("#assigned_depdesig");

        // Function to toggle the visibility of the Assigned customer field
        function toggleAssignedCustomer() {
            const selectedRole = roleDropdown.val();
            if (selectedRole !== "2" && selectedRole !== "3") {
                assignedDepdesig.show();
                assignedDepdesig.find("select").prop("required", true); // Make it required
            } else {
                assignedDepdesig.hide().val('');
                assignedDepdesig.find("select").prop("required", false); // Make it not required
            }
        }

        // Initial toggle based on the selected role
        toggleAssignedCustomer();

        // Attach an event listener to the role dropdown to toggle visibility on change
        roleDropdown.on("change", function() {
            toggleAssignedCustomer();
        });
    });

    // on change of a role, toggle the visibility of the recharge day field
    $(document).ready(function() {
        const roleDropdown = $("select[name='user_role']");
        const rechargeDay = $("#recharge_day");

        // Function to toggle the visibility of the Assigned customer field
        function toggleRechargeDay() {
            const selectedRole = roleDropdown.val();
            if (selectedRole == <?= ROLE_RESELLER_ID ?> || selectedRole == <?= ROLE_SUBRESELLER_ID ?>) {
                rechargeDay.show();
                rechargeDay.find("select").prop("required", true); // Make it required
            } else {
                rechargeDay.hide();
                rechargeDay.find("select").prop("required", false); // Make it not required
            }
        }

        // Initial toggle based on the selected role
        toggleRechargeDay();

        // Attach an event listener to the role dropdown to toggle visibility on change
        roleDropdown.on("change", function() {
            toggleRechargeDay();
        });
    });
</script>