<?php
$currency_symbol = $global_config['currency_symbol'];
?>
<div class="dashboard-page">

    <div class="row">
        <div class="col-md-12">
            <div class="panel" style="background: transparent; border-color: transparent;">
                <div class="row widget-row-in">
                    <?php if (get_permission('new_clients_widget', 'is_view')) : ?>
                        <div class="col-lg-12 col-sm-12">
                            <div class="dashboard-card d-flex align-items-center position-relative" style="
                        background: linear-gradient(to right,rgb(47, 182, 245),rgb(150, 216, 247)); 
                        border-radius: 12px; 
                        padding: 15px 20px; 
                        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
                        color: #fff;
                        position: relative;
                            min-height: 150px;

                    ">
                                <?php
                                $userProfileImg = $this->app_lib->get_image_url('staff/' . $this->session->userdata('logger_photo'));
                                ?>

                                <!-- Staff Status Top Right -->
                                <p id="staffStatus" style="
                            position: absolute;
                            top: 10px;
                            right: 20px;
                            margin: 0;
                            font-weight: bold;
                            color: #fff;
                            background: rgba(255, 255, 255, 0.2);
                            padding: 3px 10px;
                            border-radius: 8px;
                            font-size: 13px;
                        ">
                                    Active
                                </p>

                                <!-- Left: Staff Photo -->
                                <!-- Left: Staff Photo -->
                                <div class="dashboard-icon me-3 d-flex align-items-center" style="height: 100%;">
                                    <img
                                        id="staffPhoto"
                                        src="<?= html_escape($userProfileImg); ?>"
                                        alt="Photo"
                                        style="
                                        width: 80px;
                                        height: 80px;
                                        border-radius: 50%;
                                        object-fit: cover;
                                        box-shadow: 0 0 8px rgba(0, 0, 0, 0.2);
                                        border: 3px solid #fff;
                                    ">
                                </div>

                                <!-- Right: Staff Info -->
                                <div class="dashboard-content d-flex flex-column justify-content-center" id="staffInfoBox" style="
    min-height: 100px;
">
                                    <h4 id="staffName" style="margin: 0 0 6px 0; font-weight: 600;">
                                        <?= html_escape($this->session->userdata('name') ?? '--'); ?>
                                    </h4>
                                    <?php if (loggedin_role_id() != 1): ?>
                                        <p><span id="staffBranchID" style="color: #fff;">--</span></p>
                                    <?php endif; ?>

                                    <?php if (loggedin_role_id() == 1): ?>
                                        <p style="color: #fff; font-weight: bold;"> Super Admin</p>
                                    <?php endif; ?>

                                    <?php if (loggedin_role_id() == 1): ?>

                                        <p id="staffAddress" style="margin: 4px 0; color: #fff;">Office Address</p>

                                        <p id="staffPaymentAccount" style="margin: 0; color: #fff;">Office Account</p>
                                    <?php endif; ?>

                                    <?php if (loggedin_role_id() != 1): ?>
                                        <p id="staffAddress" style="margin: 4px 0; color: #fff;"> --</p>

                                        <p id="staffPaymentAccount" style="margin: 0; color: #fff;"> --</p>
                                    <?php endif; ?>


                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="panel" style="background: transparent; border-color: transparent;">
                <div class="row widget-row-in">

                    <!-- Total Branch -->
                    <?php if (get_permission('reseller_count_widget', 'is_view')) : ?>
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #2196F3, #64B5F6); color: #fff; border-radius: 10%; padding: 15px; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; font-size: 20px; margin-right: 15px;">
                                    <i class="fas fa-code-branch"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="totalReseller">--</h4>
                                    <p><?= translate('Total Branch'); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Total Active Branch -->
                    <?php if (get_permission('branch_active_widget', 'is_view')) : ?>
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #4CAF50, #81C784); color: #fff; border-radius: 10%; padding: 15px; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; font-size: 20px; margin-right: 15px;">
                                    <i class="fas fa-check-circle"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="branchActive">--</h4>
                                    <p>Total Active Branch</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Total Inactive Branch -->
                    <?php if (get_permission('branch_active_widget', 'is_view')) : ?>
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #f44336, #e57373); color: #fff; border-radius: 10%; padding: 15px; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; font-size: 20px; margin-right: 15px;">
                                    <i class="fas fa-ban"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="branchInactive">--</h4>
                                    <p>Total Inactive Branch</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Total New Branch -->
                    <?php if (get_permission('branch_active_widget', 'is_view')) : ?>
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #FF9800, #FFB74D); color: #fff; border-radius: 10%; padding: 15px; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; font-size: 20px; margin-right: 15px;">
                                    <i class="fas fa-plus-circle"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="branchhold">--</h4>
                                    <p>Total New Branch</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>


    <div class="row">
        <div class="col-md-12">
            <div class="panel" style="background: transparent; border-color: transparent;">
                <div class="row widget-row-in">

                    <!-- Total Clients -->
                    <?php if (get_permission('total_student_widget', 'is_view')) : ?>
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #3f51b5, #5c6bc0); color: #fff; border-radius: 10%; padding: 15px; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; font-size: 20px; margin-right: 15px;">
                                    <i class="fas fa-user-friends"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="totalStudents">--</h4>
                                    <p><?= translate('Total Clients'); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Total Active Clients -->
                    <?php if (get_permission('total_active', 'is_view')) : ?>
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #4caf50, #81c784); color: #fff; border-radius: 10%; padding: 15px; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; font-size: 20px; margin-right: 15px;">
                                    <i class="fas fa-user-check"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="totalActive">--</h4>
                                    <p>Total Active Clients</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Total Inactive Clients -->
                    <?php if (get_permission('total_inactive', 'is_view')) : ?>
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #e53935, #ef5350); color: #fff; border-radius: 10%; padding: 15px; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; font-size: 20px; margin-right: 15px;">
                                    <i class="fas fa-user-slash"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="totalInactive">--</h4>
                                    <p>Total Inactive Clients</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Total New Clients -->
                    <?php if (get_permission('new_clients_widget', 'is_view')) : ?>
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #ff9800, #ffb74d); color: #fff; border-radius: 10%; padding: 15px; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; font-size: 20px; margin-right: 15px;">
                                    <i class="fas fa-user-plus"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="monthlyNewClientsCount">--</h4>
                                    <p><?= translate('Total New Clients'); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="panel" style="background: transparent; border-color: transparent;">
                <div class="row widget-row-in">

                    <?php if (get_permission('total_meal_widget', 'is_view')) : ?>
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" id="totalMealCard" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #9c27b0, #ba68c8); color: #fff; border-radius: 10%; padding: 15px; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; font-size: 20px; margin-right: 15px;">
                                    <i class="fas fa-concierge-bell"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="totalMeals">--</h4>
                                    <p>Total Booked Meal</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Total Breakfast -->
                    <?php if (get_permission('breakfast_widget', 'is_view')) : ?>
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" id="breakfastCard" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #ff9800, #ffb74d); color: #fff; border-radius: 10%; padding: 15px; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; font-size: 20px; margin-right: 15px;">
                                    <i class="fas fa-coffee"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="totalSelectedBreakfast">--</h4>
                                    <p>Total Breakfast</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Total Lunch -->
                    <?php if (get_permission('lunch_widget', 'is_view')) : ?>
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" id="lunchCard" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #03a9f4, #4fc3f7); color: #fff; border-radius: 10%; padding: 15px; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; font-size: 20px; margin-right: 15px;">
                                    <i class="fas fa-utensil-spoon"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="totalSelectedLunch">--</h4>
                                    <p>Total Lunch</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Total Dinner -->
                    <?php if (get_permission('dinner_widget', 'is_view')) : ?>
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" id="dinnerCard" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #e91e63, #f06292); color: #fff; border-radius: 10%; padding: 15px; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; font-size: 20px; margin-right: 15px;">
                                    <i class="fas fa-pizza-slice"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="totalSelectedDinner">--</h4>
                                    <p>Total Dinner</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>


    <div class="row">
        <div class="col-md-12">
            <div class="panel" style="background: transparent;border-color: transparent;">
                <div class="row widget-row-in">

                    <!-- <style>
                        .green-glow {
                            box-shadow: 0 0 20px 3px rgba(0, 255, 100, 0.5) !important;
                            transition: box-shadow 0.3s ease-in-out;
                            cursor: pointer;
                        }

                        .update-glow {
                            animation: greenFlash 1s ease-in-out;
                        }

                        @keyframes greenFlash {
                            0% {
                                box-shadow: 0 0 0 rgba(0, 255, 0, 0);
                            }

                            50% {
                                box-shadow: 0 0 20px 3px rgba(0, 255, 100, 0.7);
                            }

                            100% {
                                box-shadow: 0 0 0 rgba(0, 255, 0, 0);
                            }
                        }
                    </style>

                    <script>
                        let previousValues = {
                            breakfast: null,
                            lunch: null,
                            dinner: null,
                            totalMeals: null
                        };

                        // Check if glow has been manually dismissed
                        function shouldShowGlow(key) {
                            return localStorage.getItem(`glow_dismissed_${key}`) !== 'true';
                        }

                        // Mark as manually dismissed (after click)
                        function markGlowDismissed(key) {
                            localStorage.setItem(`glow_dismissed_${key}`, 'true');
                        }

                        // Apply persistent green glow if not dismissed
                        function applyGreenGlow(cardId, key) {
                            const card = document.getElementById(cardId);
                            if (!card || !shouldShowGlow(key)) return;

                            card.classList.add('green-glow');

                            // Remove glow manually on click
                            card.addEventListener('click', () => {
                                card.classList.remove('green-glow');
                                markGlowDismissed(key);
                            }, {
                                once: true
                            });
                        }

                        function updateCard(cardId, elementId, newValue, key) {
                            const card = document.getElementById(cardId);
                            const display = document.getElementById(elementId);

                            // Show glow if value increased
                            if (previousValues[key] !== null && newValue > previousValues[key]) {
                                localStorage.removeItem(`glow_dismissed_${key}`); // reset dismissed flag
                                card.classList.add('update-glow');
                                applyGreenGlow(cardId, key);
                                setTimeout(() => card.classList.remove('update-glow'), 1000);
                            }

                            // If it's the first time and glow was not dismissed
                            if (previousValues[key] === null && shouldShowGlow(key)) {
                                applyGreenGlow(cardId, key);
                            }

                            display.textContent = newValue;
                            previousValues[key] = newValue;
                        }
                        // Fetch all data via AJAX
                        function fetchDashboardData() {
                            $.getJSON('<?php echo base_url('dashboard/ajax_total_selected_breakfast'); ?>', function(data) {
                                const val = parseInt(data.TotalSelectedBreakfast) || 0;
                                updateCard('breakfastCard', 'totalSelectedBreakfast', val, 'breakfast');
                            });

                            $.getJSON('<?php echo base_url('dashboard/ajax_total_selected_lunch'); ?>', function(data) {
                                const val = parseInt(data.TotalSelectedLunch) || 0;
                                updateCard('lunchCard', 'totalSelectedLunch', val, 'lunch');
                            });

                            $.getJSON('<?php echo base_url('dashboard/ajax_total_selected_dinner'); ?>', function(data) {
                                const val = parseInt(data.TotalSelectedDinner) || 0;
                                updateCard('dinnerCard', 'totalSelectedDinner', val, 'dinner');
                            });

                            $.getJSON('<?php echo base_url('dashboard/ajax_total_meals'); ?>', function(data) {
                                const val = parseInt(data.TotalMeals) || 0;
                                updateCard('totalMealCard', 'totalMeals', val, 'totalMeals');
                            });
                        }

                        $(document).ready(function() {
                            fetchDashboardData();
                            setInterval(fetchDashboardData, 10000); // refresh every 10 seconds
                        });
                    </script> -->


                    <?php if (get_permission('total_meal_cost', 'is_view')) : ?>
                        <!-- Total Booked Meal Cost -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #4CAF50, #81C784); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-hand-holding-usd"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="totalMealCost">--</h4>
                                    <p>Total Booked Meal Cost / Income</p>
                                </div>
                            </div>
                        </div>

                        <!-- Breakfast Cost -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #FF9800, #FFB74D); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-mug-hot"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="breakfastMealCost">--</h4>
                                    <p>Total Breakfast Cost</p>
                                </div>
                            </div>
                        </div>

                        <!-- Lunch Cost -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #2196F3, #64B5F6); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-concierge-bell"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="lunchMealCost">--</h4>
                                    <p>Total Lunch Cost</p>
                                </div>
                            </div>
                        </div>

                        <!-- Dinner Cost -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #9C27B0, #BA68C8); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-fish"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="dinnerMealCost">--</h4>
                                    <p>Total Dinner Cost</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                </div>
            </div>

        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="panel" style="background: transparent;border-color: transparent;">
                <div class="row widget-row-in">

                    <?php if (get_permission('total_meal_widget', 'is_view')) : ?>
                        <!-- Total Pending Meals -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #607D8B, #90A4AE); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-hourglass-half"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="pendingMeal">--</h4>
                                    <p><?= translate('Total Pending meal'); ?></p>
                                </div>
                            </div>
                        </div>

                        <!-- Pending Breakfast -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #FFA726, #FFCC80); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-egg"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="pendingBreakfast">--</h4>
                                    <p>Total Pending Breakfast</p>
                                </div>
                            </div>
                        </div>

                        <!-- Pending Lunch -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #42A5F5, #90CAF9); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-lemon"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="pendingLunch">--</h4>
                                    <p>Total Pending Lunch</p>
                                </div>
                            </div>
                        </div>

                        <!-- Pending Dinner -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #8E24AA, #CE93D8); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-utensils"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="pendingDinner">--</h4>
                                    <p>Total Pending Dinner</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>


                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="panel" style="background: transparent; border-color: transparent;">
                <div class="row widget-row-in">

                    <?php if (get_permission('total_meal_widget', 'is_view')) : ?>
                        <!-- Total Pending Meal Cost -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #673AB7, #9575CD); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-receipt"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="totalPendingMealCost">--</h4>
                                    <p>Total Pending Meal Cost</p>
                                </div>
                            </div>
                        </div>

                        <!-- Pending Breakfast Cost -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #6D4C41, #A1887F); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-mug-hot"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="pendingBreakfastCost">--</h4>
                                    <p>Total Pending Breakfast Cost</p>
                                </div>
                            </div>
                        </div>

                        <!-- Pending Lunch Cost -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #388E3C, #81C784); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-concierge-bell"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="pendingLunchCost">--</h4>
                                    <p>Total Pending Lunch Cost</p>
                                </div>
                            </div>
                        </div>

                        <!-- Pending Dinner Cost -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #1976D2, #64B5F6); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-fish"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="pendingDinnerCost">--</h4>
                                    <p>Total Pending Dinner Cost</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>


    <div class="row">
        <div class="col-md-12">
            <div class="panel" style="background: transparent;border-color: transparent;">
                <div class="row widget-row-in">

                    <?php if (get_permission('new_clients_widget', 'is_view')) : ?>
                        <!-- Total Refund Meal -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #FF7043, #FFAB91); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-undo-alt"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="refundCount">--</h4>
                                    <p>Total Refund Meal</p>
                                </div>
                            </div>
                        </div>

                        <!-- Refund Breakfast -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #FFA726, #FFCC80); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-egg"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="refundBreakfast">--</h4>
                                    <p>Total Refund Breakfast</p>
                                </div>
                            </div>
                        </div>

                        <!-- Refund Lunch -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #42A5F5, #90CAF9); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-hamburger"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="refundLunch">--</h4>
                                    <p>Total Refund Lunch</p>
                                </div>
                            </div>
                        </div>

                        <!-- Refund Dinner -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #8E24AA, #CE93D8); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-drumstick-bite"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="refundDinner">--</h4>
                                    <p>Total Refund Dinner</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>



                </div>
            </div>

        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="panel" style="background: transparent; border-color: transparent;">
                <div class="row widget-row-in">
                    <?php if (get_permission('new_clients_widget', 'is_view')) : ?>
                        <!-- Total Refund Meal Cost -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #FF7043, #FFAB91); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-undo-alt"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="totalRefund">--</h4>
                                    <p>Total Refund Meal Cost</p>
                                </div>
                            </div>
                        </div>

                        <!-- Refund Breakfast Cost -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #FFA726, #FFCC80); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-coffee"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="refundBreakfastCost"> --</h4>
                                    <p>Total Refund Breakfast Cost</p>
                                </div>
                            </div>
                        </div>

                        <!-- Refund Lunch Cost -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #42A5F5, #90CAF9); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-hamburger"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="refundLunchCost">৳ --</h4>
                                    <p>Total Refund Lunch Cost</p>
                                </div>
                            </div>
                        </div>

                        <!-- Refund Dinner Cost -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #8E24AA, #CE93D8); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-drumstick-bite"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="refundDinnerCost">৳ --</h4>
                                    <p>Total Refund Dinner Cost</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="panel" style="background: transparent; border-color: transparent;">
                <div class="row widget-row-in">
                    <?php if (get_permission('new_clients_widget', 'is_view')) : ?>
                        <!-- Total Income -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #66BB6A, #A5D6A7); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-plus-circle"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="incometotal">--</h4>
                                    <p>Total Income / Booked Meal Cost</p>
                                </div>
                            </div>
                        </div>

                        <!-- Total Expense -->
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;">
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #EF5350, #EF9A9A); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-file-invoice-dollar"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="total_expense">--</h4>
                                    <p>Total Expense</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Total Profit -->
                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #42A5F5, #90CAF9); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-arrow-up"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="profitAmount">৳ --</h4>
                                <p>Total Profit</p>
                            </div>
                        </div>
                    </div>

                    <!-- Total Loss -->
                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #8E24AA, #CE93D8); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-arrow-down"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="lossAmount">৳ --</h4>
                                <p>Total Loss</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="panel" style="background: transparent;border-color: transparent;">
                <div class="row widget-row-in">


                    <?php if (get_permission('new_clients_widget', 'is_view')) : ?>
                        <div class="col-lg-3 col-sm-6">
                            <div class="dashboard-card" style="background-color: #fff;"> <!-- Amber Gradient -->
                                <div class="dashboard-icon" style="background: linear-gradient(to right, #FFA726, #FFCC80); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                    <i class="fas fa-coins"></i>
                                </div>
                                <div class="dashboard-content">
                                    <h4 id="totalBalance">--</h4>
                                    <p>Total Unused Client Balance</p>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <?php if (get_permission('meal_graph', 'is_view')) { ?>
            <div class="col-lg-8 col-md-8 col-sm-6">
                <section class="panel shadow-sm rounded-2xl border-0" style="background: #f9fafb;">
                    <div class="panel-bod p-4">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h4 class="chart-title fw-semibold text-gray-800" style="text-align: center; font-size: 2rem;">
                                <?= translate('Daily_Meal_Summary') . ' - ' . date("F Y"); ?>
                            </h4>

                            <i class="fa fa-utensils text-primary fs-4"></i>
                        </div>
                        <div class="pe-chart position-relative" style="height: 360px;">
                            <canvas id="mealChart"></canvas>
                        </div>
                    </div>
                </section>
            </div>

            <!-- Chart.js -->
            <script>
                fetch("<?= base_url('dashboard/ajax_meal_chart_data') ?>")
                    .then(res => res.json())
                    .then(data => {
                        const labels = data.map(item => item.date);
                        const breakfast = data.map(item => parseInt(item.breakfast));
                        const lunch = data.map(item => parseInt(item.lunch));
                        const dinner = data.map(item => parseInt(item.dinner));

                        new Chart(document.getElementById("mealChart"), {
                            type: "bar",
                            data: {
                                labels: labels,
                                datasets: [{
                                        label: "Breakfast",
                                        data: breakfast,
                                        backgroundColor: "rgba(250, 204, 21, 0.8)", // yellow
                                        borderRadius: 6,
                                        barThickness: 16,
                                    },
                                    {
                                        label: "Lunch",
                                        data: lunch,
                                        backgroundColor: "rgba(52, 211, 153, 0.8)", // green
                                        borderRadius: 6,
                                        barThickness: 16,
                                    },
                                    {
                                        label: "Dinner",
                                        data: dinner,
                                        backgroundColor: "rgba(96, 165, 250, 0.8)", // blue
                                        borderRadius: 6,
                                        barThickness: 16,
                                    }
                                ]
                            },
                            options: {
                                responsive: true,
                                maintainAspectRatio: false,
                                plugins: {
                                    legend: {
                                        position: "bottom",
                                        labels: {
                                            color: "#374151", // Tailwind slate
                                            font: {
                                                size: 14
                                            }
                                        }
                                    },
                                    title: {
                                        display: false
                                    }
                                },
                                scales: {
                                    x: {
                                        title: {
                                            display: true,
                                            text: "Date",
                                            color: "#6b7280"
                                        },
                                        ticks: {
                                            color: "#6b7280"
                                        },
                                        grid: {
                                            display: false
                                        }
                                    },
                                    y: {
                                        beginAtZero: true,
                                        title: {
                                            display: true,
                                            text: "Meals Ordered",
                                            color: "#6b7280"
                                        },
                                        ticks: {
                                            color: "#6b7280"
                                        },
                                        grid: {
                                            color: "#e5e7eb"
                                        }
                                    }
                                }
                            }
                        });
                    });
            </script>
        <?php } ?>

        <?php if (get_permission('client_status_pie_chart_widget', 'is_view')) { ?>

            <div class="<?php echo get_permission('client_status_pie_chart_widget', 'is_view') ? 'col-lg-4 col-md-5 col-sm-12' : 'col-md-12'; ?>">
                <section class="panel">
                    <div class="panell-body">
                        <h2 class="chart-title mb-md" style="text-align: center; font-size: 1.8rem;">
                            <?php echo translate('Clients_status_') . ' - ' . date("F Y"); ?>
                        </h2>
                        <div class="pe-chart">
                            <canvas id="clientvsStatus" style="height: 360px;"></canvas>
                        </div>
                    </div>
                </section>
            </div>
        <?php } ?>
    </div>



    <script type="application/javascript">
        $(document).ready(function() {
            // Student Balance
            $.ajax({
                url: '<?= base_url('dashboard/ajax_student_balance'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#ordercost').text(data.ordercost || 0);
                },
                error: function() {
                    console.error('Failed to load Student Balance');
                }
            });

            $.ajax({
                url: '<?= base_url('dashboard/ajax_total_balance'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#totalBalance').text((data.TotalBalance || '0') + ' Tk ');
                },
                error: function() {
                    console.error('Failed to load Total Balance');
                }
            });
            $.ajax({
                url: '<?= base_url('dashboard/ajax_profit_loss'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#profitAmount').text((data.profit || '0') + ' Tk ');
                    $('#lossAmount').text((data.loss || '0') + ' Tk ');
                },
                error: function() {
                    console.error('Failed to load profit/loss data');
                }
            });



            $(document).ready(function() {
                $.ajax({
                    url: "<?= base_url('dashboard/get_branch_active_count') ?>",
                    type: "GET",
                    dataType: "json",
                    success: function(response) {
                        if (response.branchActive !== undefined) {
                            $('#branchActive').text(response.branchActive);
                        } else {
                            $('#branchActive').text('--');
                        }
                    },
                    error: function() {
                        $('#branchActive').text('--');
                    }
                });
            });
            $.ajax({
                url: "<?= base_url('dashboard/get_total_expense') ?>",
                type: "GET",
                dataType: "json",
                success: function(response) {
                    if (response.totalExpense !== undefined) {
                        $('#total_expense').text(response.totalExpense + " Tk");
                    } else {
                        $('#total_expense').text('--');
                    }
                },
                error: function() {
                    $('#total_expense').text('--');
                }
            });


            $(document).ready(function() {
                $.ajax({
                    url: "<?= base_url('dashboard/get_branch_inactive_count') ?>",
                    type: "GET",
                    dataType: "json",
                    success: function(response) {
                        if (response.branchInactive !== undefined) {
                            $('#branchInactive').text(response.branchInactive);
                        } else {
                            $('#branchInactive').text('--');
                        }
                    },
                    error: function() {
                        $('#branchInactive').text('--');
                    }
                });
            });
            $(document).ready(function() {
                $.ajax({
                    url: "<?= base_url('dashboard/get_branch_hold_count') ?>",
                    type: "GET",
                    dataType: "json",
                    success: function(response) {
                        if (response.branchhold !== undefined) {
                            $('#branchhold').text(response.branchhold);
                        } else {
                            $('#branchhold').text('--');
                        }
                    },
                    error: function() {
                        $('#branchhold').text('--');
                    }
                });
            });
            $(document).ready(function() {
                $.ajax({
                    url: '<?= base_url('dashboard/ajax_pending_meal'); ?>',
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        $('#pendingMeal').text(data.pendingMeal || 0);
                    },
                    error: function() {
                        console.error('Failed to load Pending Meals');
                    }
                });
            });
            $(document).ready(function() {
                $.ajax({
                    url: '<?= base_url('dashboard/pending_meal'); ?>',
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        $('#pendingBreakfast').text(data.breakfast || 0);
                        $('#pendingLunch').text(data.lunch || 0);
                        $('#pendingDinner').text(data.dinner || 0);
                    },
                    error: function() {
                        console.error('Failed to load pending meals.');
                    }
                });
            });

            $.ajax({
                url: "<?= base_url('dashboard/get_total_income') ?>",
                type: "GET",
                dataType: "json",
                success: function(response) {
                    if (response.totalIncome !== undefined) {
                        $('#totalIncome').text(response.totalIncome);
                    } else {
                        $('#totalIncome').text('--');
                    }
                },
                error: function() {
                    $('#totalIncome').text('--');
                }
            });



            // Total Active
            $.ajax({
                url: '<?php echo base_url('dashboard/ajax_total_active'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#totalActive').text(data.TotalActive || 0);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching total active:', error);
                }
            });

            // Total Inactive
            $.ajax({
                url: '<?php echo base_url('dashboard/ajax_total_inactive'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#totalInactive').text(data.TotalInactive || 0);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching total inactive:', error);
                }
            });
        });



        $(document).ready(function() {
            $.ajax({
                url: '<?= base_url('dashboard/ajax_total_refund'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#totalRefund').text((data.TotalRefund || '0') + ' Tk ');
                },
                error: function() {
                    console.error('Failed to load Total Refund');
                }
            });

            $.ajax({
                url: '<?php echo base_url('dashboard/ajax_total_students'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log('Total Students:', data);

                    if (data.error) {
                        console.error('Error:', data.error);
                        return;
                    }

                    $('#totalStudents').text(data.totalStudents || 0);
                },
                error: function(xhr, status, error) {
                    console.error('AJAX error:', error);
                }
            });
        });

        $(document).ready(function() {
            $.ajax({
                url: '<?php echo base_url('dashboard/ajax_total_selected_breakfast'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log('Total Selected Breakfast:', data);

                    if (data.error) {
                        console.error('Error:', data.error);
                        return;
                    }

                    $('#totalSelectedBreakfast').text(data.TotalSelectedBreakfast || 0);
                },
                error: function(xhr, status, error) {
                    console.error('AJAX error:', error);
                }
            });
        });

        $(document).ready(function() {
            // Total Lunch
            $.ajax({
                url: '<?php echo base_url('dashboard/ajax_total_selected_lunch'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#totalSelectedLunch').text(data.TotalSelectedLunch || 0);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching total lunch:', error);
                }
            });
        });
        $(document).ready(function() {
            $.ajax({
                url: '<?= base_url('dashboard/ajax_refund_count'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#refundCount').text(data.TotalRefundCount || 0);
                },
                error: function() {
                    console.error('Failed to load refund count');
                }
            });

            // Total Dinner
            $.ajax({
                url: '<?php echo base_url('dashboard/ajax_total_selected_dinner'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#totalSelectedDinner').text(data.TotalSelectedDinner || 0);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching total dinner:', error);
                }
            });
        });
        $(document).ready(function() {
            $.ajax({
                url: '<?= base_url('dashboard/ajax_refund'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#refundBreakfast').text(data.breakfast || 0);
                    $('#refundLunch').text(data.lunch || 0);
                    $('#refundDinner').text(data.dinner || 0);
                },
                error: function() {
                    console.error('Failed to load refund count');
                }
            });
        });
        $(document).ready(function() {
            $.ajax({
                url: '<?= base_url('dashboard/ajax_refund_meal_costs'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#refundBreakfastCost').text((data.breakfast || '0') + ' Tk ');
                    $('#refundLunchCost').text((data.lunch || '0') + ' Tk ');
                    $('#refundDinnerCost').text((data.dinner || '0') + ' Tk ');
                },
                error: function() {
                    console.error('Failed to load refund costs');
                }
            });
        });

        $(document).ready(function() {
            $.ajax({
                url: '<?php echo base_url('dashboard/ajax_total_meals'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    $('#totalMeals').text(data.TotalMeals || 0);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching total meals:', error);
                }
            });
        });
        $(document).ready(function() {
            $.ajax({
                url: '<?php echo base_url('dashboard/ajax_total_meal_cost'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    let cost = data.TotalMealCost || 0;
                    $('#totalMealCost').text(parseFloat(cost).toFixed(2) + ' Tk ');
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching total meal cost:', error);
                }
            });
        });

        $(document).ready(function() {
            $.ajax({
                url: '<?php echo base_url('dashboard/ajax_income_meal_cost'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    let cost = data.IncomeTotal || 0;
                    $('#incometotal').text(parseFloat(cost).toFixed(2) + ' Tk ');
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching total meal cost:', error);
                }
            });
        });

        $(document).ready(function() {
            $.ajax({
                url: '<?php echo base_url('dashboard/ajax_meal_cost'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    let breakfast = data.BreakfastCost || 0;
                    let lunch = data.LunchCost || 0;
                    let dinner = data.DinnerCost || 0;

                    $('#breakfastMealCost').text(parseFloat(breakfast).toFixed(2) + ' Tk ');
                    $('#lunchMealCost').text(parseFloat(lunch).toFixed(2) + ' Tk ');
                    $('#dinnerMealCost').text(parseFloat(dinner).toFixed(2) + ' Tk ');
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching meal costs:', error);
                }
            });
        });




        // Annual Income Vs Expense JS
        var income = <?php echo json_encode($yearly_income_expense['income']); ?>;
        var expense = <?php echo json_encode($yearly_income_expense['expense']); ?>;

        var incomeVsExpense = {
            type: 'line',
            data: {
                labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                datasets: [{
                        label: "<?php echo translate('income'); ?>",
                        backgroundColor: 'rgba(0, 136, 204, .7)',
                        borderColor: '#F5F5F5',
                        borderWidth: 1,
                        data: income
                    },
                    {
                        label: "<?php echo translate('expense'); ?>",
                        backgroundColor: 'rgba(204, 61, 61, 0.7)',
                        borderColor: '#F5F5F5',
                        borderWidth: 1,
                        data: expense
                    }
                ]
            },
            options: {
                responsive: true,
                tooltips: {
                    mode: 'index',
                    bodySpacing: 4
                },
                title: {
                    display: false,
                    text: 'Income Expense'
                },
                legend: {
                    position: 'bottom',
                    labels: {
                        boxWidth: 12
                    }
                },
                scales: {
                    xAxes: [{
                        stacked: true,
                        scaleLabel: {
                            display: false,
                        }
                    }],
                    yAxes: [{
                        stacked: true,
                        scaleLabel: {
                            display: false,
                        },
                    }]
                }
            }
        };

        $.ajax({
            url: '<?php echo base_url('dashboard/get_income_vs_expense_data'); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                var income = response.income;
                var expense = response.expense;

                var incomeVsExpense = {
                    type: 'line',
                    data: {
                        labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                        datasets: [{
                                label: "<?php echo translate('income'); ?>",
                                backgroundColor: 'rgba(0, 136, 204, .7)',
                                borderColor: '#F5F5F5',
                                borderWidth: 1,
                                data: income,
                            },
                            {
                                label: "<?php echo translate('expense'); ?>",
                                backgroundColor: 'rgba(204, 61, 61, 0.7)',
                                borderColor: '#F5F5F5',
                                borderWidth: 1,
                                data: expense,
                            },
                        ],
                    },
                    options: {
                        responsive: true,
                        tooltips: {
                            mode: 'index',
                            bodySpacing: 4,
                        },
                        title: {
                            display: false,
                            text: 'Income vs Expense',
                        },
                        legend: {
                            position: 'bottom',
                            labels: {
                                boxWidth: 12,
                            },
                        },
                        scales: {
                            xAxes: [{
                                stacked: true,
                                scaleLabel: {
                                    display: false,
                                },
                            }, ],
                            yAxes: [{
                                stacked: true,
                                scaleLabel: {
                                    display: false,
                                },
                            }, ],
                        },
                    },
                };

                // Render the chart
                var ctx = document.getElementById('incomevsExpense').getContext('2d');
                new Chart(ctx, incomeVsExpense);
            },
            error: function() {
                console.error('Error fetching income vs expense data.');
            },
        });
        // Patient Fees Summary
        var days = <?php echo json_encode($patient_fees_summary['days']); ?>;
        var net_payable = <?php echo json_encode($patient_fees_summary['total_bill']); ?>;
        var total_paid = <?php echo json_encode($patient_fees_summary['total_paid']); ?>;
        var total_due = <?php echo json_encode($patient_fees_summary['total_due']); ?>;

        var barChartData = {
            type: 'bar',
            data: {
                labels: days,
                datasets: [{
                    label: "<?php echo translate('net') . ' ' . translate('payable'); ?>",
                    data: net_payable,
                    backgroundColor: 'rgba(216, 27, 96, .8)',
                    borderColor: '#F5F5F5',
                    borderWidth: 1
                }, {
                    label: "<?php echo translate('total') . ' ' . translate('paid'); ?>",
                    data: total_paid,
                    backgroundColor: 'rgba(0, 136, 204, .8)',
                    borderColor: '#F5F5F5',
                    borderWidth: 1
                }, {
                    label: "<?php echo translate('total') . ' ' . translate('due'); ?>",
                    data: total_due,
                    backgroundColor: 'rgba(204, 102, 102, .8)',
                    borderColor: '#F5F5F5',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                stacked: false,
                tooltips: {
                    mode: 'index',
                    bodySpacing: 4
                },
                title: {
                    display: false,
                    text: 'Income Expense'
                },
                legend: {
                    position: 'bottom',
                    labels: {
                        boxWidth: 12
                    }
                }
            }
        };



        <?php if (get_permission('appointment_status_chart', 'is_view')): ?>
        
            $(document).ready(function() {
                $.ajax({
                    url: '<?php echo base_url('dashboard/ajax_nas_meal_summary'); ?>',
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        console.log(data);

                        $('#breakfastCount').html(data.breakfast);
                        $('#lunchCount').html(data.lunch);
                        $('#dinnerCount').html(data.dinner);

                        const meals = [
                            parseInt(data.breakfast || 0),
                            parseInt(data.lunch || 0),
                            parseInt(data.dinner || 0)
                        ];

                        const labels = [
                            `Breakfast: ${data.breakfast || 0}`,
                            `Lunch: ${data.lunch || 0}`,
                            `Dinner: ${data.dinner || 0}`
                        ];

                        const backgroundColor = ['#FF8C00', '#1E90FF', '#8A2BE2'];

                        var mealDoughnut = {
                            type: 'doughnut',
                            data: {
                                datasets: [{
                                    data: meals,
                                    backgroundColor: backgroundColor,
                                    label: 'Meal Summary'
                                }],
                                labels: labels
                            },
                            options: {
                                responsive: true,
                                legend: {
                                    position: 'bottom',
                                    labels: {
                                        boxWidth: 12
                                    }
                                },
                                animation: {
                                    animateScale: true,
                                    animateRotate: true
                                }
                            }
                        };

                        var ctx = document.getElementById('mealChart').getContext('2d');
                        window.mealChart = new Chart(ctx, mealDoughnut);
                    }
                });


            });

        <?php endif ?>
        $(document).ready(function() {
            $.ajax({
                url: '<?php echo base_url('dashboard/ajax_client_count'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log(data);
                    // active, hold, and inactive clients
                    $('#active_Clients').html(data.Active);
                    $('#hold_Clients').html(data.Hold);
                    $('#total_InactiveClients').html(data.Inactive);

                    // json object values as number of array
                    const clients = [
                        parseInt(data.Active || 0),
                        parseInt(data.Hold || 0),
                        parseInt(data.Inactive || 0)
                    ];
                    const labels = [
                        `Active: ${data.Active || 0}`,
                        `Hold: ${data.Hold || 0}`,
                        `Inactive: ${data.Inactive || 0}`
                    ];

                    // different colors for labels
                    const backgroundColor = [
                        'green', // Active
                        'yellow', // Hold
                        'red' // Inactive
                    ];

                    var clientDoughnut = {
                        type: 'doughnut',
                        data: {
                            datasets: [{
                                data: clients,
                                backgroundColor: backgroundColor,
                                label: 'Client Status'
                            }],
                            labels: labels,
                        },
                        options: {
                            responsive: true,
                            legend: {
                                position: 'bottom',
                                labels: {
                                    boxWidth: 12
                                },
                            },
                            title: {
                                display: false,
                                text: 'Client Status Doughnut Chart'
                            },
                            animation: {
                                animateScale: true,
                                animateRotate: true
                            }
                        }
                    };

                    var ctx4 = document.getElementById('clientvsStatus').getContext('2d');
                    window.myDoughnut = new Chart(ctx4, clientDoughnut);
                }
            });

        });
        // get new client count
        $(document).ready(function() {

            $.ajax({
                url: '<?php echo base_url('dashboard/ajax_monthly_new_client_count'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log('Monthly New Client Count:', data);

                    // Check if an error is returned
                    if (data.error) {
                        console.error('Error fetching monthly new client count:', data.error);
                        return;
                    }

                    $('#monthlyNewClientsCount').text(data.NewClients || 0);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching monthly new client count:', error);
                }
            });
        });
        $(document).ready(function() {
            $.ajax({
                url: '<?= base_url('dashboard/ajax_staff_info'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log("Returned staff info:", data);

                    if (data && !data.error) {
                        // Name
                        $('#staffName').text(data.name || '--');

                        // Address
                        <?php if (loggedin_role_id() != 2): ?>
                            $('#staffAddress').html('<strong>Office Address :</strong> ' + data.address);
                        <?php endif; ?>
                        <?php if (loggedin_role_id() != 1): ?>
                            $('#staffAddress').html('<strong>Branch Address :</strong> ' + data.address);
                        <?php endif; ?>


                        // Mobile Number
                        const mobileNo = data.mobileno !== null && data.mobileno !== undefined ?
                            String(data.mobileno) :
                            '--';

                        $('#staffMobileNo').text('Mobile : ' + mobileNo);

                        // IDD
                        $('#staffIDD').text(data.idd || '--');

                        // Branch Name
                        $('#staffBranchName').text(data.branch_name || '--');

                        // ✅ Payment Account
                        const paymentAccount = data.payment_account !== null && data.payment_account !== undefined ?
                            String(data.payment_account) :
                            '--';
                        <?php if (loggedin_role_id() != 2): ?>

                            $('#staffPaymentAccount').html('<strong>Office Account Number :</strong> ' + paymentAccount);
                        <?php endif; ?>
                        <?php if (loggedin_role_id() != 1): ?>

                            $('#staffPaymentAccount').html('<strong>Branch Account Number :</strong> ' + paymentAccount);
                        <?php endif; ?>



                        // ✅ Branch ID
                        const branchId = data.merchant_no !== null && data.merchant_no !== undefined ?
                            String(data.merchant_no) :
                            '--';
                        $('#staffBranchID').html('<strong>Branch ID :</strong> ' + branchId);

                        // Status badge
                        const status = (data.status && data.status.toLowerCase() === 'active') ? 'Active' : 'Inactive';
                        const badgeColor = (status === 'Active') ? '#28a745' : '#dc3545'; // Green or Red

                        $('#staffStatus')
                            .text(status)
                            .css({
                                'display': 'inline-block',
                                'padding': '2px 8px',
                                'font-size': '12px',
                                'font-weight': '600',
                                'color': '#fff',
                                'border-radius': '12px',
                                'background-color': badgeColor,
                                'margin': '0'
                            });
                    } else {
                        console.warn("Staff not found or error returned.");
                    }
                },
                error: function(xhr, status, error) {
                    console.error("AJAX error fetching staff info:", error);
                }
            });
        });



        $(document).ready(function() {
            // get previous month income
            $.ajax({
                url: '<?= base_url('dashboard/ajax_previous_month_income'); ?>',
                type: 'GET',
                dataType: 'json',

                success: function(data) {
                    console.log("", data);
                    $('#previousMonthIncome').html(data);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching previous month income:', error);
                }
            });

            // get previous month total income

            $.ajax({
                url: '<?= base_url('dashboard/ajax_previous_month_total_income'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log("", data);
                    $('#previousMonthTotalIncome').html(data);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching previous month total income:', error);
                }
            });

            // get client status count
            $.ajax({
                url: '<?php echo base_url('dashboard/ajax_client_count'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log('Client Status:', data);

                    // Check if an error is returned
                    if (data.error) {
                        console.error('Error fetching client status:', data.error);
                        return;
                    }

                    // Update the UI with the returned data
                    $('#client_status_view').text(data.Active || 0); // Display Active clients
                    $('#inactiveClients').text(data.Inactive || 0); // Display Inactive clients
                    $('#client_status_hold').text(data.Hold || 0); // Display Hold clients
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching client status:', error);
                }
            });
            // get new client count
            $(document).ready(function() {
                $.ajax({
                    url: "<?= base_url('dashboard/pending_meal_cost'); ?>",
                    type: "GET",
                    dataType: "json",
                    success: function(data) {
                        const breakfast = data.breakfast ? parseFloat(data.breakfast) : 0;
                        const lunch = data.lunch ? parseFloat(data.lunch) : 0;
                        const dinner = data.dinner ? parseFloat(data.dinner) : 0;

                        const total = breakfast + lunch + dinner;

                        $('#pendingBreakfastCost').text(breakfast.toFixed(2) + ' Tk');
                        $('#pendingLunchCost').text(lunch.toFixed(2) + ' Tk');
                        $('#pendingDinnerCost').text(dinner.toFixed(2) + ' Tk');
                        $('#totalPendingMealCost').text(total.toFixed(2) + ' Tk');
                    },
                    error: function() {
                        $('#pendingBreakfastCost').text('--');
                        $('#pendingLunchCost').text('--');
                        $('#pendingDinnerCost').text('--');
                        $('#totalPendingMealCost').text('--');
                    }
                });
            });


            $.ajax({
                url: '<?= base_url('dashboard/ajax_total_zones'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(response) {
                    console.log('Total Zones:', response);

                    if (response.total_zones !== undefined) {
                        $('#totalZonesCount').text(response.total_zones);
                    } else {
                        console.error('Invalid response format:', response);
                        $('#totalZonesCount').text(0);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching total zone count:', xhr.responseText || error);
                    $('#totalZonesCount').text(0);
                }
            });


            // get this month income
            $.ajax({
                url: '<?= base_url('dashboard/ajax_this_month_income'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log("", data);
                    $('#thisMonthIncome').html(data);
                }
            });
            // get this month income total

            $.ajax({
                url: '<?= base_url('dashboard/ajax_this_month_income_total'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log("", data);
                    $('#thisMonthIncomeTotal').html(data);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching this month income:', error);
                }
            });


            $(document).ready(function() {
                $.ajax({
                    url: '<?= base_url('dashboard/get_billing_summary'); ?>',
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        console.log(data); // Log the response to verify the structure

                        // Prepare the data for the chart
                        var months = [];
                        var dailyBills = [];
                        var labels = [];

                        // Loop through the months and their daily data
                        for (var month in data) {
                            var days = [];
                            var totalBills = [];

                            // Get the number of days in the month
                            var daysInMonth = new Date(new Date().getFullYear(), month, 0).getDate(); // e.g., for January (month 1) it returns 31

                            // Loop through each day of the month (1 to daysInMonth)
                            for (var day = 1; day <= daysInMonth; day++) {
                                days.push('Day ' + day); // Add day label (e.g., "Day 1")
                                totalBills.push(data[month][day] || 0); // Add the total bill for that day (default to 0 if no data)
                            }

                            // Push the dataset for the month
                            dailyBills.push({
                                label: "Total Bill",
                                data: totalBills,
                                backgroundColor: 'rgba(226, 109, 255, 0.8)',
                                borderColor: '#F5F5F5',
                                borderWidth: 1
                            });

                            labels.push(days);
                        }

                        var barChartData = {
                            type: 'bar',
                            data: {
                                labels: labels.flat(),
                                datasets: dailyBills
                            },
                            options: {
                                responsive: true,
                                stacked: false,
                                tooltips: {
                                    mode: 'index',
                                    bodySpacing: 4
                                },
                                title: {
                                    display: false,
                                    text: 'Daily Billing Summary by Month'
                                },
                                legend: {
                                    position: 'bottom',
                                    labels: {
                                        boxWidth: 12
                                    }
                                }
                            }
                        };

                        // Render the chart on the canvas
                        var ctx = document.getElementById('monthlyBillChart').getContext('2d');
                        new Chart(ctx, barChartData);
                    },
                    error: function() {
                        console.error('Error fetching monthly billing data.');
                    }
                });
            });


            // get this Month Bill
            $.ajax({
                url: '<?= base_url('dashboard/ajax_this_month_bill'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log("", data);
                    $('#thisMonthBill').html(data);
                }
            });
            // get this Month Bill total

            $.ajax({
                url: '<?= base_url('dashboard/ajax_this_month_bill_total'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log("", data);
                    $('#thisMonthBillTotal').html(data);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching this month bill total:', error);
                }
            });

            // get previous Month Bill
            $.ajax({
                url: '<?= base_url('dashboard/ajax_previous_month_bill'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log("", data);
                    $('#previousMonthBill').html(data);

                },
                error: function(xhr, status, error) {
                    console.error("Error fetching previous month bill:", error);
                }
            });
            // get previous Month Total Bill

            $.ajax({
                url: '<?= base_url('dashboard/ajax_previous_month_total_bill'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log("", data);
                    $('#previousMonthTotalBill').html(data);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching previous month total bill:', error);
                }
            });


            // get this month expense
            $.ajax({
                url: '<?= base_url('dashboard/ajax_this_month_expense'); ?>', // Adjust the URL if needed
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log("", data);
                    $('#thisMonthExpense').html(data);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching this month\'s expense:', error);
                }
            });

            $.ajax({
                url: '<?= base_url('dashboard/ajax_online_and_offline_client_count'); ?>', // Adjust URL to the new controller method
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    // Update the online and offline counts on the page
                    $('#onlineCount').text(data.online_count);
                    $('#offlineCount').text(data.offline_count);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching client counts:', error);
                }
            });

            $.ajax({
                url: '<?= base_url('dashboard/ajax_auto_hold_client_count'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    if (data.auto_hold_count !== undefined) {
                        // Update the auto-hold count dynamically in the view
                        $('#autohold').text(data.auto_hold_count);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching auto-hold client count:', error);
                }
            });





            // get this month total expense


            // get previous month expense

            $.ajax({
                url: '<?= base_url('dashboard/ajax_previous_month_expense'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log("Previous Month's Expense:", data); // Debugging output
                    $('#previousMonthExpense').html(data); // Display the expense in the UI
                },
                error: function(xhr, status, error) {
                    console.error("Error fetching previous month's expense:", error);
                }
            });
            // get previous month total expense

            // get this month bill paid
            $.ajax({
                url: '<?= base_url('dashboard/ajax_this_month_bill_paid'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log("", data);
                    $('#thisMonthBillPaid').html(data);
                }
            });
            // get this month total bill paid

            $.ajax({
                url: '<?= base_url('dashboard/ajax_this_month_total_bill_paid'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log("", data);
                    $('#thisMonthTotalBillPaid').html(data);

                },
                error: function(xhr, status, error) {
                    console.error('Error fetching this month total bill paid:', error);
                }
            });

            // get previous month bill paid
            $.ajax({
                url: '<?= base_url('dashboard/ajax_previous_month_bill_paid'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log("Previous Month Bill Paid:", data);
                    $('#previousMonthBillPaid').html(data);
                },
                error: function(xhr, status, error) {
                    console.error("Error fetching previous month bill paid:", error);
                }
            });
            // get previous month total bill paid

            $.ajax({
                url: '<?= base_url('dashboard/ajax_previous_month_total_bill_paid'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log("Previous Month Bill Paid Total:", data);
                    $('#previousMonthTotalBillPaid').html(data);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching previous month total bill paid:', error);
                }
            });

            // get this month bill due
            $.ajax({
                url: '<?= base_url('dashboard/ajax_this_month_bill_due'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log("", data);
                    $('#thisMonthBillDue').html(data);
                }
            });
            // get this month total bill due

            $.ajax({
                url: '<?= base_url('dashboard/ajax_this_month_total_bill_due'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log("", data);
                    $('#thisMonthTotalBillDue').html(data);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching this month total bill due:', error);
                }
            });
            // get previous month bill due

            $.ajax({
                url: '<?= base_url('dashboard/ajax_previous_month_bill_due'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log("", data);
                    $('#previousMonthBillDue').html(data);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching previous month bill due:', error);
                }
            });
            // get previous month total bill due
            $.ajax({
                url: '<?= base_url('dashboard/ajax_previous_month_total_bill_due'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    console.log("", data);
                    $('#previousMonthTotalBillDue').html(data);
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching previous month total bill due:', error);
                }
            });

            $(document).ready(function() {
                $.ajax({
                    url: '<?= base_url('dashboard/ajax_total_reseller'); ?>',
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        $('#totalReseller').html(data);
                    },
                    error: function(xhr, status, error) {
                        console.error("AJAX Error: ", status, error);
                    }
                });
            });


            // get total sub reseller
            $.ajax({
                url: '<?php echo base_url('dashboard/ajax_total_sub_reseller'); ?>',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    if (data.error) {
                        console.error(data.error);
                        $('#totalSubReseller').html(0);
                    } else {
                        $('#totalSubReseller').html(data.total || 0);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching sub-reseller count:', error);
                    $('#totalSubReseller').html(0); // Default to 0 on error
                }
            });

        });


        /* appointment status pie chart */
        //var clients = <?php //echo json_encode($get_monthly_appointment); 
                        ?>//;
        //var labe = ['Confirmed', 'Pending', 'Canceled'];
        //var appointmentDoughnut = {
        //    type: 'doughnut',
        //    data: {
        //        datasets: [{
        //            data: clients,
        //            backgroundColor: [
        //                '#66aa18',
        //                '#4d5360',
        //                '#ff6384',
        //            ],
        //            label: 'Dataset 1'
        //        }],
        //        labels: labe,
        //    },
        //    options: {
        //        responsive: true,
        //        legend: {
        //            position: 'bottom',
        //            labels: {boxWidth: 12},
        //        },
        //        title: {
        //            display: false,
        //            text: 'Chart.js Doughnut Chart'
        //        },
        //        animation: {
        //            animateScale: true,
        //            animateRotate: true
        //        }
        //    }
        //};
        $.ajax({
            url: '<?= base_url('dashboard/ajax_meal_summary'); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                $('#breakfastCount').text(response.breakfast || 0);
                $('#lunchCount').text(response.lunch || 0);
                $('#dinnerCount').text(response.dinner || 0);
            },
            error: function(xhr, status, error) {
                console.error('Meal count error:', xhr.responseText);
            }
        });



        window.onload = function() {
            <?php if (get_permission('pathology_fees_summary_chart', 'is_view')): ?>
                var ctx = document.getElementById('incomeExpense').getContext('2d');
                window.myLine = new Chart(ctx, incomeVsExpense);
            <?php endif ?>
            <?php if (get_permission('annual_income_vs_expense_chart', 'is_view')): ?>
                var ctx2 = document.getElementById('monthlyBillsummary').getContext('2d');
                window.myBar = new Chart(ctx2, barChartData);
            <?php endif ?>
        };
    </script>

    <style>
        .dashboard-card {
            display: flex;
            align-items: center;
            padding: 10px;
            border-radius: 5px;
            color: #fff;
            margin-bottom: -6px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            transition: transform 0.2s ease;
        }

        .dashboard-card:hover {
            transform: translateY(-5px);
        }

        .dashboard-icon {
            background: rgba(255, 255, 255, 0.15);
            border-radius: 5px;
            padding: 10px;
            margin-right: 15px;
            font-size: 20px;
        }

        .dashboard-content h4 {
            margin: 0;
            font-size: 20px;
            font-weight: 600;
            color: #333;
        }

        .dashboard-content p {
            margin: 0;
            font-size: 14px;
            color: #337ab7;
        }

        .dashboard-link {
            text-decoration: none;
            display: block;
        }

        /* Optional enhancements */
        .panel-body {
            padding: 0px;
            transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
        }

        .panel-body:hover {
            transform: scale(1.05);
            box-shadow: 0 8px 15px rgba(0, 0, 0, 0.2);
        }

        .card-title {
            color: #000;
        }

        /* Body base style */
        body {
            color: #777;
            font-family: 'Signika', sans-serif;
            line-height: 20px;
            margin: 0;
            font-size: 11px;
        }
    </style>


    <style>
        .panel-body {
            padding: 0px;
            /* Slight padding for better aesthetics */
        }


        .card .col-md-4 h1 {
            font-size: 20px;
            /* Icon size */
            /
        }

        h4 {
            font-size: 1.5rem;
            /* Icon size */
            /
        }

        .chart-title {
            padding: 5px;
            font-size: 14px;

        }

        .chart-title:before {
            top: 27px;
        }

        .panel-body {
            transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
        }

        .panel-body:hover {
            transform: scale(1.05);
            box-shadow: 0 8px 15px rgba(0, 0, 0, 0.2);
        }

        .card-title {
            color: #000;
        }
    </style>

</div>