<?php
$currency_symbol = $global_config['currency_symbol'];
?>
<div class="row">
    <div class="col-md-12">
        <div class="panel" style="background: transparent; border-color: transparent;">
            <div class="row widget-row-in">
                <?php if (get_permission('breakfast_widget', 'is_view')) : ?>
                    <div class="col-lg-12 col-sm-12">
                        <div class="dashboard-card d-flex align-items-center position-relative" style="
                            background: linear-gradient(to right,rgb(47, 182, 245),rgb(150, 216, 247)); 
                            border-radius: 12px; 
                            padding: 15px 20px; 
                            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
                            color: #fff;
                            position: relative;
                                                        min-height: 150px;

                        ">
                            <?php
                            $userProfileImg = $this->app_lib->get_image_url('staff/' . $this->session->userdata('logger_photo'));
                            ?>

                            <!-- Staff Status Top Right -->
                            <p id="staffStatus" style="
                            position: absolute;
                            top: 10px;
                            right: 20px;
                            margin: 0;
                            font-weight: bold;
                            color: #fff;
                            background: rgba(255, 255, 255, 0.2);
                            padding: 3px 10px;
                            border-radius: 8px;
                            font-size: 13px;
                        ">
                                Active
                            </p>

                            <!-- Left: Staff Photo -->
                            <!-- Left: Staff Photo -->
                            <div class="dashboard-icon me-3 d-flex align-items-center" style="height: 100%;">
                                <img
                                    id="staffPhoto"
                                    src="<?= html_escape($userProfileImg); ?>"
                                    alt="Photo"
                                    style="
                                        width: 80px;
                                        height: 80px;
                                        border-radius: 50%;
                                        object-fit: cover;
                                        box-shadow: 0 0 8px rgba(0, 0, 0, 0.2);
                                        border: 3px solid #fff;
                                    ">
                            </div>


                            <!-- Right: Staff Info -->
                            <div class="dashboard-content d-flex flex-column justify-content-center" id="staffInfoBox" style="
    min-height: 100px;
">
                                <h4 id="staffName" style="margin: 0; font-weight: 600;">
                                    <?= html_escape($this->session->userdata('name') ?? '--'); ?>
                                </h4>
                                <p style="color: #fff;"><strong>Client ID :</strong> <span id="staffIDD" style="color: #fff;">--</span></p>
                                <p style="color: #fff;"><strong>Branch Name:</strong> <span id="staffBranchName" style="color: #fff;">--</span></p>
                                <p style="color: #fff;"><strong></strong> <span id="staffBranchID" style="color: #fff;">--</span></p>
                                <p style="color: #fff;"><strong></strong> <span id="staffBranchPayment" style="color: #fff;">--</span></p>


                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <style>
                    .dashboard-icon {
                        display: flex;
                        align-items: center;
                        justify-content: center;
                    }

                    .dashboard-card h4,
                    .dashboard-card p {
                        color: #fff;
                    }
                </style>
            </div>
        </div>
    </div>


</div>
<div class="row">
    <div class="col-md-12">
        <div class="panel" style="background: transparent; border-color: transparent;">
            <div class="row widget-row-in">
                <?php if (get_permission('total_meal_widget', 'is_view')) : ?>
                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #3f51b5, #5c6bc0); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-concierge-bell"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="totalMeals">--</h4>
                                <p>Total Meals</p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if (get_permission('breakfast_widget', 'is_view')) : ?>
                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #11cd6f, #66d9a0); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-utensils"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="totalSelectedBreakfast">--</h4>
                                <p>Total Breakfast</p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if (get_permission('lunch_widget', 'is_view')) : ?>
                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #a65900ff, #d69f00); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-hamburger"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="totalSelectedLunch">--</h4>
                                <p>Total Lunch</p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if (get_permission('dinner_widget', 'is_view')) : ?>
                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #5e35b1, #7e57c2); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-drumstick-bite"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="totalSelectedDinner">--</h4>
                                <p>Total Dinner</p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="panel" style="background: transparent; border-color: transparent;">
            <div class="row widget-row-in">

                <?php if (get_permission('total_meal_widget', 'is_view')) : ?>
                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #ef5350, #ef9a9a); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-money-bill-wave"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="totalMealCost">--</h4>
                                <p>Total Meal Cost</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #66bb6a, #a5d6a7); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-coffee"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="breakfastMealCost">--</h4>
                                <p>Total Breakfast Cost</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #ffa726, #ffd54f); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-utensils"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="lunchMealCost">--</h4>
                                <p>Total Lunch Cost</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #42a5f5, #90caf9); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-drumstick-bite"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="dinnerMealCost">--</h4>
                                <p>Total Dinner Cost</p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="panel" style="background: transparent; border-color: transparent;">
            <div class="row widget-row-in">

                <?php if (get_permission('total_meal_widget', 'is_view')) : ?>
                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #ffcc00, #ffd54f); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-utensils"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="pendingMeal">--</h4>
                                <p><?= translate('Total Pending meal'); ?></p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #ffcc00, #ffd54f); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-coffee"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="pendingBreakfast">--</h4>
                                <p>Total Pending Breakfast</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #ff9800, #ffb74d); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-utensils"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="pendingLunch">--</h4>
                                <p>Total Pending Lunch</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #f44336, #ef5350); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-drumstick-bite"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="pendingDinner">--</h4>
                                <p>Total Pending Dinner</p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="panel" style="background: transparent; border-color: transparent;">
            <div class="row widget-row-in">

                <?php if (get_permission('total_meal_widget', 'is_view')) : ?>

                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #9c27b0, #ba68c8); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-wallet"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="totalPendingMealCost">--</h4>
                                <p>Total Pending Meal Cost</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #ff9800, #ffb74d); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-coffee"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="pendingBreakfastCost">--</h4>
                                <p>Total Pending Breakfast Cost</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #4caf50, #81c784); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-utensils"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="pendingLunchCost">--</h4>
                                <p>Total Pending Lunch Cost</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #2196f3, #64b5f6); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-drumstick-bite"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="pendingDinnerCost">--</h4>
                                <p>Total Pending Dinner Cost</p>
                            </div>
                        </div>
                    </div>

                <?php endif; ?>

            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="panel" style="background: transparent; border-color: transparent;">
            <div class="row widget-row-in">

                <?php if (get_permission('total_meal_widget', 'is_view')) : ?>
                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, rgb(255, 183, 128), rgb(255, 224, 178)); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-undo"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="refundCount">--</h4>
                                <p>Total Refund Meal</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #ffcc80, #ffe0b2); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-coffee"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="refundBreakfast">--</h4>
                                <p>Total Refund Breakfast</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #ffb74d, #ffe082); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-utensils"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="refundLunch">--</h4>
                                <p>Total Refund Lunch</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #ff8a65, #ffab91); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-drumstick-bite"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="refundDinner">--</h4>
                                <p>Total Refund Dinner</p>
                            </div>
                        </div>
                    </div>

                <?php endif; ?>

            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="panel" style="background: transparent; border-color: transparent;">
            <div class="row widget-row-in">

                <?php if (get_permission('total_meal_widget', 'is_view')) : ?>
                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #ef5350, #ef9a9a); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-undo-alt"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="totalRefund">--</h4>
                                <p>Total Refund Meal Cost</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #73c500, #a8d84a); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-coffee"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="refundBreakfastCost">--</h4>
                                <p>Total Refund Breakfast Cost</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #9e8e00, #d1c631); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-hamburger"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="refundLunchCost"> --</h4>
                                <p>Total Refund Lunch Cost</p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #fff;">
                            <div class="dashboard-icon" style="background: linear-gradient(to right, #ae6800, #dba740); border-radius: 10%; color: #fff; width: 50px; height: 50px; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-drumstick-bite"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="refundDinnerCost"> --</h4>
                                <p>Total Refund Dinner Cost</p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
</div>

<!-- 
<div class="row">
    <div class="col-md-12">
        <div class="panel" style="background: transparent;border-color: transparent;">
            <div class="row widget-row-in">

                <?php if (get_permission('total_meal_widget', 'is_view')) : ?>
                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #4db6ac;"> 
                            <div class="dashboard-icon">
                                <i class="fas fa-dollar-sign"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="totalPaid">0</h4>
                                <p><?= translate('total_paid'); ?></p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if (get_permission('total_meal_widget', 'is_view')) : ?>
                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #ef5350;"> 
                            <div class="dashboard-icon">
                                <i class="fas fa-hand-holding-usd"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="totalDue">0</h4>
                                <p><?= translate('total_due'); ?></p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if (get_permission('total_meal_cost', 'is_view')) : ?>
                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #f06292;"> 
                            <div class="dashboard-icon">
                                <i class="fas fa-money-bill-wave"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="totalMealCost">--</h4>
                                <p>Total Meal Cost</p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>


                <?php if (get_permission('total_meal_widget', 'is_view')) : ?>
                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #ffb74d;"> 
                            <div class="dashboard-icon">
                                <i class="fas fa-utensils"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="pendingMeal">--</h4>
                                <p><?= translate('pending_meal'); ?></p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>


            </div>
        </div>
    </div>

</div>
<div class="row">
    <div class="col-md-12">
        <div class="panel" style="background: transparent;border-color: transparent;">
            <div class="row widget-row-in">

                <?php if (get_permission('total_meal_widget', 'is_view')) : ?>
                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color:rgb(255, 183, 128);"> 
                            <div class="dashboard-icon">
                                <i class="fas fa-undo"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="refundCount">--</h4>
                                <p> Total Refund Meal</p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if (get_permission('total_meal_widget', 'is_view')) : ?>
                    <div class="col-lg-3 col-sm-6">
                        <div class="dashboard-card" style="background-color: #e57373;"> 
                            <div class="dashboard-icon">
                                <i class="fas fa-undo-alt"></i>
                            </div>
                            <div class="dashboard-content">
                                <h4 id="totalRefund">--</h4>
                                <p>Total Refund Cost</p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>




            </div>
        </div>
    </div>

</div> -->
<div class="row">
    <div class="col-md-12">
        <div class="panel" style="background: transparent; border-color: transparent;">
            <div class="row widget-row-in">

                <?php if (get_permission('sms_notice', 'is_view')) :
                    $latest_notice = null;
                    if (!empty($sms_history)) {
                        usort($sms_history, function ($a, $b) {
                            return strtotime($b['created_at']) - strtotime($a['created_at']);
                        });
                        $latest_notice = $sms_history[0];
                    }

                    $bgColor = $latest_notice ? '#f8d7da' : '#d4edda';
                    $textColor = $latest_notice ? '#b70000' : '#b70000'
                ?>
                    <div class="col-md-12">
                        <div class="dashboard-card text-center" style="background-color: <?= $bgColor ?>;">
                            <div class="dashboard-content">
                                <h4 style="font-size: 16px; font-weight: bold; color: <?= $textColor ?>;">
                                    <?= translate('notice'); ?>
                                </h4>

                                <p style="font-size: 14px; color: <?= $textColor ?>;">
                                    <?= $latest_notice ? html_escape($latest_notice['sms_text']) : translate('no_notice_available'); ?>
                                </p>

                                <?php if ($latest_notice): ?>
                                    <small style="color: <?= $textColor ?>;">
                                        <?= date('d M Y, h:i A', strtotime($latest_notice['created_at'])); ?>
                                    </small>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                <?php endif; ?>

            </div>
        </div>
    </div>
</div>
<style>
    .dashboard-card {
        display: flex;
        align-items: center;
        padding: 10px;
        border-radius: 5px;
        color: #fff;
        margin-bottom: -6px;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        transition: transform 0.2s ease;
    }

    .dashboard-card:hover {
        transform: translateY(-5px);
    }

    .dashboard-icon {
        background: rgba(255, 255, 255, 0.15);
        border-radius: 5px;
        padding: 10px;
        margin-right: 15px;
        font-size: 20px;
    }

    .dashboard-content h4 {
        margin: 0;
        font-size: 20px;
        font-weight: 600;
        color: #333;
    }

    .dashboard-content p {
        margin: 0;
        font-size: 14px;
        color: #337ab7;
    }

    .dashboard-link {
        text-decoration: none;
        display: block;
    }

    /* Optional enhancements */
    .panel-body {
        padding: 0px;
        transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
    }

    .panel-body:hover {
        transform: scale(1.05);
        box-shadow: 0 8px 15px rgba(0, 0, 0, 0.2);
    }

    .card-title {
        color: #000;
    }

    /* Body base style */
    body {
        color: #777;
        font-family: 'Signika', sans-serif;
        line-height: 20px;
        margin: 0;
        font-size: 11px;
    }
</style>


<style>
    .panel-body {
        padding: 0px;
        /* Slight padding for better aesthetics */
    }


    .card .col-md-4 h1 {
        font-size: 20px;
        /* Icon size */
        /
    }

    h4 {
        font-size: 1.5rem;
        /* Icon size */
        /
    }

    .chart-title {
        padding: 5px;
        font-size: 14px;

    }

    .chart-title:before {
        top: 27px;
    }

    .panel-body {
        transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
    }

    .panel-body:hover {
        transform: scale(1.05);
        box-shadow: 0 8px 15px rgba(0, 0, 0, 0.2);
    }

    .card-title {
        color: #000;
    }
</style>

<?php
$meal_map = [];
if (!empty($meal_summary)) {
    foreach ($meal_summary as $row) {
        $meal_map[$row['date']] = [
            'breakfast' => $row['breakfast'],
            'lunch' => $row['lunch'],
            'dinner' => $row['dinner']
        ];
    }
}

$days_in_month = date('t');
$current_month = date('Y-m');
?>

<style>
    .calendar-container {
        display: grid;
        grid-template-columns: repeat(7, 1fr);
        gap: 2px;
        padding: 15px;
    }

    .calendar-day {
        background-color: #f9fafb;
        border: 1px solid #e5e7eb;
        padding: 10px;
        border-radius: 12px;
        min-height: 100px;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        font-size: 12px;
        color: #374151;
    }

    .meal-badge {
        display: inline-block;
        margin: 2px 0;
        padding: 2px 6px;
        border-radius: 8px;
        font-size: 12px;
        color: white;
    }

    .meal-badge.breakfast {
        background-color: #facc15;
        color: #000;
    }

    .meal-badge.lunch {
        background-color: #34d399;
    }

    .meal-badge.dinner {
        background-color: #60a5fa;
    }
</style>

<?php
$currentMonth = $_GET['month'] ?? date('Y-m');
$days_in_month = date('t', strtotime($currentMonth));
$nextMonth = date('Y-m', strtotime($currentMonth . ' +1 month'));

$hasPrevMonthMeals = false;
$hasNextMonthMeals = false;

foreach ($meal_map as $date => $meals) {
    if (strpos($date, $nextMonth) === 0) $hasNextMonthMeals = true;
}
?>

<div class="panel shadow-sm rounded-2xl border-0 mb-4" style="background: #bdd5ff;">
    <div class="panel-bod p-4">
        <h4 class="fw-bold text-center mb-3" style="font-size: 24px; color: #0056b3;">
            <span style="background: linear-gradient(to right, #00b4db, #0083b0); -webkit-background-clip: text; color: transparent; font-weight: 700;">
                <?= translate('Meal Calendar') ?>
            </span> -
            <span style="color: #333; font-weight: bold;"><?= date("F Y", strtotime($currentMonth)); ?></span>
        </h4>

        <div class="text-center mb-4">


            <?php if ($hasNextMonthMeals): ?>
                <a href="?month=<?= $nextMonth ?>" class="btn btn-sm btn-primary rounded">
                    <?= date('F', strtotime($nextMonth)) ?> &#8594;
                </a>
            <?php endif; ?>
        </div>

        <div class="calendar-container">
            <?php for ($day = 1; $day <= $days_in_month; $day++):
                $date = $currentMonth . '-' . str_pad($day, 2, '0', STR_PAD_LEFT);
                $meals = $meal_map[$date] ?? null;
                $day_name = date('l', strtotime($date));
            ?>
                <div class="calendar-day">
                    <strong><?= $day . ', ' . $day_name ?></strong>
                    <div>
                        <?php if ($meals): ?>
                            <?php if ($meals['breakfast']) echo '<div class="meal-badge breakfast">Breakfast</div>'; ?>
                            <?php if ($meals['lunch']) echo '<div class="meal-badge lunch">Lunch</div>'; ?>
                            <?php if ($meals['dinner']) echo '<div class="meal-badge dinner">Dinner</div>'; ?>
                        <?php else: ?>
                            <small class="text-muted">No meal</small>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endfor; ?>
        </div>
    </div>
</div>




<script type="application/javascript">
    $(document).ready(function() {
        $.ajax({
            url: '<?php echo base_url('dashboard/ajax_total_selected_breakfast'); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                console.log('Total Selected Breakfast:', data);

                if (data.error) {
                    console.error('Error:', data.error);
                    return;
                }

                $('#totalSelectedBreakfast').text(data.TotalSelectedBreakfast || 0);
            },
            error: function(xhr, status, error) {
                console.error('AJAX error:', error);
            }
        });
    });
    $(document).ready(function() {
        $.ajax({
            url: "<?= base_url('dashboard/pending_meal_cost'); ?>",
            type: "GET",
            dataType: "json",
            success: function(data) {
                const breakfast = data.breakfast ? parseFloat(data.breakfast) : 0;
                const lunch = data.lunch ? parseFloat(data.lunch) : 0;
                const dinner = data.dinner ? parseFloat(data.dinner) : 0;

                const total = breakfast + lunch + dinner;

                $('#pendingBreakfastCost').text(breakfast.toFixed(2) + ' Tk');
                $('#pendingLunchCost').text(lunch.toFixed(2) + ' Tk');
                $('#pendingDinnerCost').text(dinner.toFixed(2) + ' Tk');
                $('#totalPendingMealCost').text(total.toFixed(2) + ' Tk');
            },
            error: function() {
                $('#pendingBreakfastCost').text('--');
                $('#pendingLunchCost').text('--');
                $('#pendingDinnerCost').text('--');
                $('#totalPendingMealCost').text('--');
            }
        });
    });

    $(document).ready(function() {
        $.ajax({
            url: '<?php echo base_url('dashboard/ajax_meal_cost'); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                let breakfast = data.BreakfastCost || 0;
                let lunch = data.LunchCost || 0;
                let dinner = data.DinnerCost || 0;

                $('#breakfastMealCost').text(parseFloat(breakfast).toFixed(2) + ' Tk');
                $('#lunchMealCost').text(parseFloat(lunch).toFixed(2) + ' Tk');
                $('#dinnerMealCost').text(parseFloat(dinner).toFixed(2) + ' Tk');
            },
            error: function(xhr, status, error) {
                console.error('Error fetching meal costs:', error);
            }
        });
    });

    $(document).ready(function() {
        $.ajax({
            url: '<?= base_url('dashboard/ajax_refund'); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                $('#refundBreakfast').text(data.breakfast || 0);
                $('#refundLunch').text(data.lunch || 0);
                $('#refundDinner').text(data.dinner || 0);
            },
            error: function() {
                console.error('Failed to load refund count');
            }
        });
    });
    $(document).ready(function() {
        $.ajax({
            url: '<?= base_url('dashboard/ajax_refund_meal_costs'); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                $('#refundBreakfastCost').text((data.breakfast || '0') + ' Tk');
                $('#refundLunchCost').text((data.lunch || '0') + ' Tk');
                $('#refundDinnerCost').text((data.dinner || '0') + ' Tk');
            },
            error: function() {
                console.error('Failed to load refund costs');
            }
        });
    });
    $(document).ready(function() {
        $.ajax({
            url: '<?= base_url('dashboard/ajax_refund_count'); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                $('#refundCount').text(data.TotalRefundCount || 0);
            },
            error: function() {
                console.error('Failed to load refund count');
            }
        });

        // Total Dinner
        $.ajax({
            url: '<?php echo base_url('dashboard/ajax_total_selected_dinner'); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                $('#totalSelectedDinner').text(data.TotalSelectedDinner || 0);
            },
            error: function(xhr, status, error) {
                console.error('Error fetching total dinner:', error);
            }
        });
    });
    $(document).ready(function() {
        $.ajax({
            url: '<?= base_url('dashboard/ajax_total_refund'); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                $('#totalRefund').text((data.TotalRefund || 0) + ' Tk');
            },
            error: function() {
                console.error('Failed to load Total Refund');
            }
        });

        $.ajax({
            url: '<?php echo base_url('dashboard/ajax_total_students'); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                console.log('Total Students:', data);

                if (data.error) {
                    console.error('Error:', data.error);
                    return;
                }

                $('#totalStudents').text(data.totalStudents || 0);
            },
            error: function(xhr, status, error) {
                console.error('AJAX error:', error);
            }
        });

    });
    $(document).ready(function() {
        $.ajax({
            url: '<?= base_url('dashboard/ajax_pending_meal'); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                $('#pendingMeal').text(data.pendingMeal || 0);
            },
            error: function() {
                console.error('Failed to load Pending Meals');
            }
        });
    });
    $(document).ready(function() {
        $.ajax({
            url: '<?= base_url('dashboard/pending_meal'); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                $('#pendingBreakfast').text(data.breakfast || 0);
                $('#pendingLunch').text(data.lunch || 0);
                $('#pendingDinner').text(data.dinner || 0);
            },
            error: function() {
                console.error('Failed to load pending meals.');
            }
        });
    });
    $(document).ready(function() {
        $.ajax({
            url: '<?= base_url('dashboard/ajax_staff_info'); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                console.log("Returned staff info:", data);

                if (data && !data.error) {
                    // Staff Name
                    $('#staffName').text(data.name || '--');

                    // Mobile Number
                    const mobileNo = data.mobileno !== null && data.mobileno !== undefined ?
                        String(data.mobileno) :
                        '--';
                    $('#staffPaymentAccount').text(mobileNo);

                    // IDD
                    $('#staffIDD').text(data.idd || '--');

                    // Branch Name
                    $('#staffBranchName').text(data.branch_name || '--');

                    // ✅ Staff Payment Account
                    const paymentAccount = data.payment_account !== null && data.payment_account !== undefined ?
                        String(data.payment_account) :
                        '--';
                    $('#staffAccount').text('Account: ' + paymentAccount);

                    // ✅ Branch ID
                    const branchId = data.branch_id !== null && data.branch_id !== undefined ?
                        String(data.branch_id) :
                        '--';
                    $('#staffBranchID').html('<strong>Branch ID :</strong> ' + branchId);

                    // ✅ Branch Payment Account
                    const branchPayment = data.branch_payment_account !== null && data.branch_payment_account !== undefined ?
                        String(data.branch_payment_account) :
                        '--';
                    $('#staffBranchPayment').html('<strong>Branch Account Number :</strong> ' + branchPayment);


                    // Status Badge
                    const status = (data.status && data.status.toLowerCase() === 'active') ? 'Active' : 'Inactive';
                    const badgeColor = (status === 'Active') ? '#28a745' : '#dc3545';

                    $('#staffStatus')
                        .text(status)
                        .css({
                            'display': 'inline-block',
                            'padding': '2px 8px',
                            'font-size': '12px',
                            'font-weight': '600',
                            'color': '#fff',
                            'border-radius': '12px',
                            'background-color': badgeColor,
                            'margin': '0'
                        });
                }
            },
            error: function(xhr, status, error) {
                console.error("AJAX error fetching staff info:", error);
            }
        });
    });

    $(document).ready(function() {
        $.ajax({
            url: '<?php echo base_url('dashboard/ajax_total_selected_lunch'); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                $('#totalSelectedLunch').text(data.TotalSelectedLunch || 0);
            },
            error: function(xhr, status, error) {
                console.error('Error fetching total lunch:', error);
            }
        });

        $.ajax({
            url: '<?php echo base_url('dashboard/ajax_total_selected_dinner'); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                $('#totalSelectedDinner').text(data.TotalSelectedDinner || 0);
            },
            error: function(xhr, status, error) {
                console.error('Error fetching total dinner:', error);
            }
        });
    });

    $(document).ready(function() {
        $.ajax({
            url: '<?php echo base_url('dashboard/ajax_total_meals'); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                $('#totalMeals').text(data.TotalMeals || 0);
            },
            error: function(xhr, status, error) {
                console.error('Error fetching total meals:', error);
            }
        });
    });

    $(document).ready(function() {
        $.ajax({
            url: '<?php echo base_url('dashboard/ajax_total_meal_cost'); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                let cost = data.TotalMealCost || 0;
                $('#totalMealCost').text(parseFloat(cost).toFixed(2) + ' Tk');
            },
            error: function(xhr, status, error) {
                console.error('Error fetching total meal cost:', error);
            }
        });
    });
</script>