<div class="row">
    <div class="col-md-12">
        <section class="panel">
            <?= form_open_multipart($this->uri->uri_string()); ?>
            <div class="panel-heading">
                <h4 class="panel-title"><i
                        class="fas fa-wheelchair"></i> <?= translate('create') . " " . translate('client'); ?>
                </h4>
            </div>

            <div class="panel-body">
                <?= validation_errors(); ?>

                <!-- basic details -->
                <div class="headers-line mt-md">
                    <i class="fas fa-user-check"></i> <?= translate('basic') . " " . translate('details'); ?>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-sm">
                        <div class="form-group <?php if (form_error('name')) echo 'has-error'; ?>">
                            <label for="name" class="control-label">
                                <?= translate('name'); ?> <span class="required">*</span>
                            </label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="far fa-user"></i></span>
                                <input class="form-control" name="name" id="name" type="text"
                                    value="<?= set_value('name'); ?>">
                            </div>
                            <span class="error"><?= form_error('name'); ?></span>
                        </div>
                    </div>
                    <div class="col-md-6 mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?= translate('gender'); ?></label>
                            <?= form_dropdown(
                                "gender",
                                [
                                    "" => translate('select'),
                                    "male" => translate('male'),
                                    "female" => translate('female')
                                ],
                                set_value('gender'),
                                "class='form-control' data-plugin-selectTwo data-width='100%'	data-minimum-results-for-search='Infinity'"
                            );
                            ?>
                            <span class="error"><?= form_error('gender'); ?></span>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4 mb-sm">
                        <div class="form-group">
                            <label for="birthday" class="control-label"><?= translate('birthday'); ?></label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="fas fa-birthday-cake"></i></span>
                                <input class="form-control" name="birthday" id="birthday"
                                    value="<?= set_value('birthday'); ?>" data-plugin-datepicker
                                    data-plugin-options='{ "startView": 2 }' type="text">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 mb-sm">
                        <div class="form-group <?php if (form_error('age')) echo 'has-error'; ?>">
                            <label for="age" class="control-label"><?= translate('age'); ?> <span
                                    class="required">*</span></label>
                            <input type="text" class="form-control" name="age" id="age"
                                value="<?= set_value('age'); ?>">
                            <span class="error"><?= form_error('age'); ?></span>
                        </div>
                    </div>
                    <div class="col-md-4 mb-sm">
                        <div class="form-group">
                            <label class="control-label"><?= translate('marital_status'); ?></label>
                            <?= form_dropdown(
                                "marital_status",
                                $maritalStatus ?? [],
                                set_value("marital_status"),
                                "class='form-control' data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity'"
                            );
                            ?>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 mb-sm">
                        <div class="form-group <?= form_error('mobile_no') ? 'has-error' : '' ?>">
                            <label for="mobile_no" class="control-label">
                                <?= translate('mobile_no'); ?>
                                <span class="required">*</span>
                            </label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="fas fa-phone-volume"></i></span>
                                <input class="form-control" name="mobile_no" id="mobile_no" type="text"
                                    value="<?= set_value('mobile_no'); ?>">
                            </div>
                            <span class="error"><?= form_error('mobile_no'); ?></span>
                        </div>
                    </div>
                    <div class="col-md-6 mb-sm">
                        <div class="form-group <?= form_error('email') ? 'has-error' : '' ?>">
                            <label for="email" class="control-label">
                                <?= translate('email'); ?>
                                <span class="required">*</span>
                            </label>
                            <div class="input-group">
                                <span class="input-group-addon"><i class="far fa-envelope-open"></i></span>
                                <input type="email" class="form-control" name="email" id="email"
                                    value="<?= set_value('email'); ?>" />
                            </div>
                            <span class="error"><?= form_error('email'); ?></span>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-sm">
                        <div class="form-group">
                            <label for="address" class="control-label"><?= translate('address'); ?></label>
                            <textarea class="form-control" rows="3" name="address" id="address"
                                placeholder="<?= translate('address'); ?>"><?= set_value('address'); ?></textarea>
                        </div>
                    </div>
                </div>

                <div class="row mb-md">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="input-file-now"><?= translate('profile_picture'); ?></label>
                            <input type="file" name="user_photo" class="dropify" data-allowed-file-extensions="jpg png"
                                data-height="120" />
                        </div>
                    </div>
                </div>

                <!-- emergency contact -->
                <div class="headers-line">
                    <i class="fas fa-pencil-ruler"></i> <?= translate('emergency_contact'); ?>
                </div>

                <div class="row">
                    <div class="col-md-4 mb-sm">
                        <div class="form-group">
                            <label for="guardian" class="control-label"><?= translate('guardian'); ?></label>
                            <input class="form-control" name="guardian" id="guardian" type="text"
                                value="<?= set_value('guardian'); ?>">
                        </div>
                    </div>
                    <div class="col-md-4 mb-sm">
                        <div class="form-group>">
                            <label for="relationship" class="control-label"><?= translate('relationship'); ?></label>
                            <input class="form-control" name="relationship" id="relationship" type="text"
                                value="<?= set_value('relationship'); ?>">
                        </div>
                    </div>
                    <div class="col-md-4 mb-sm">
                        <div class="form-group">
                            <label for="guardian_mobile_no" class="control-label">
                                <?= translate('guardian_mobile_no'); ?>
                            </label>
                            <input
                                type="text"
                                class="form-control"
                                name="guardian_mobile_no" id="guardian_mobile_no"
                                value="<?= set_value('guardian_mobile_no'); ?>">
                        </div>
                    </div>

                </div>

                <!-- login details -->
                <section>
                    <div class="headers-line">
                        <i class="fas fa-user-lock"></i> <?= translate('login_details'); ?>
                    </div>

                    <div class="row mb-lg">
                        <div class="col-md-6 mb-sm">
                            <div class="form-group <?= form_error('username') ? 'has-error' : '' ?>">
                                <label for="username" class="control-label">
                                    <?= translate('username'); ?>
                                    <span class="required">*</span>
                                </label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fas fa-user-lock"></i></span>
                                    <input
                                        type="text"
                                        class="form-control"
                                        name="username" id="username"
                                        value="<?= set_value('username'); ?>" />
                                </div>
                                <span class="error"><?= form_error('username'); ?></span>
                            </div>
                        </div>
                        <div class="col-md-3 mb-sm">
                            <div class="form-group <?php if (form_error('password')) echo 'has-error'; ?>">
                                <label for="password" class="control-label"><?= translate('password'); ?> <span
                                        class="required">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fas fa-unlock-alt"></i></span>
                                    <input type="password" class="form-control" name="password" id="password"
                                        value="<?= set_value('password'); ?>" />
                                </div>
                                <span class="error"><?= form_error('password'); ?></span>
                            </div>
                        </div>
                        <div class="col-md-3 mb-sm">
                            <div class="form-group <?= form_error('retype_password') ? 'has-error' : '' ?>">
                                <label for="retype_password" class="control-label">
                                    <?= translate('retype_password'); ?>
                                    <span class="required">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fas fa-unlock-alt"></i></span>
                                    <input type="password"
                                        class="form-control"
                                        name="retype_password" id="retype_password"
                                        value="<?= set_value('retype_password'); ?>" />
                                </div>
                                <span class="error"><?= form_error('retype_password'); ?></span>
                            </div>
                        </div>
                    </div>
                </section>

                <!-- Network & Product Information -->
                <section>
                    <div class="headers-line">
                        <i class="fas fa-wifi"></i> <?= translate('Network & Product Information'); ?>
                    </div>
                    <div class="row">
                        <?php if (!in_array(loggedin_role_id(), [ROLE_RESELLER_ID, ROLE_SUBRESELLER_ID])): ?>
                            <div class="col-sm-3 mb-sm">
                                <div class="form-group">
                                    <label for="nas_id" class="control-label">
                                        <?= translate('server'); ?>
                                        <span class="required">*</span>
                                    </label>
                                    <select name="nas_id" id="nas_id" class='form-control' data-plugin-selectTwo>
                                        <option value=""><?= translate('select') ?></option>
                                        <?php if (!empty($nasList)): ?>
                                            <?php foreach ($nasList as $server): ?>
                                                <?php $server = (object)$server; ?>
                                                <option value="<?= $server->id ?>" <?= set_select('nas_id', $server->id) ?>>
                                                    <?= $server->name ?>
                                                </option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                        <?php endif; ?>


                        <div class="col-sm-3 mb-sm">
                            <div class="form-group">
                                <label for="olt_id" class="control-label">
                                    <?= translate('OLT') ?>
                                    <span class="required">*</span>
                                </label>
                                <select
                                    class='form-control'
                                    name="olt_id" id="olt_id"
                                    data-plugin-selectTwo
                                    data-width='100%'>
                                    <option value=""><?= translate('select') ?></option>
                                    <?php if (!empty($olts)): ?>
                                        <?php foreach ($olts as $olt): ?>
                                            <option value="<?= $olt->id ?>" <?= set_select('olt_id', $olt->id) ?>>
                                                <?= $olt->name ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-3 mb-sm">
                            <div class="form-group">
                                <label for="onu_type" class="control-label">
                                    <?= translate('ONU Type') ?>
                                    <span class="required">*</span>
                                </label>
                                <select class="form-control" name="onu_type" id="onu_type" data-plugin-selectTwo data-width="100%" required>
                                    <option value=""><?= translate('select') ?></option>
                                    <option value="GPON" <?= set_select('onu_type', 'GPON', ($thisOlt->onu_type ?? null) == 'GPON') ?>>GPON</option>
                                    <option value="EPON" <?= set_select('onu_type', 'EPON', ($thisOlt->onu_type ?? null) == 'EPON') ?>>EPON</option>
                                    <option value="XPON" <?= set_select('onu_type', 'XPON', ($thisOlt->onu_type ?? null) == 'XPON') ?>>XPON</option>
                                </select>
                            </div>
                        </div>



                        <div class="col-sm-3 mb-sm">
                            <div class="form-group">
                                <label for="zone_id" class="control-label">
                                    <?= translate('zone') ?>
                                    <span class="required">*</span>
                                </label>
                                <select
                                    class='form-control'
                                    name="zone_id" id="zone_id"
                                    data-plugin-selectTwo
                                    data-width='100%'>
                                    <option value=""><?= translate('select') ?></option>
                                    <?php if (!empty($zones)): ?>
                                        <?php foreach ($zones as $zone): ?>
                                            <option value="<?= $zone->id ?>" <?= set_select('zone_id', $zone->id) ?>>
                                                <?= $zone->name ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div>


                    </div>

                    <div class="row">
                        <div class="col-sm-4 mb-sm">
                            <div class="form-group">
                                <label for="box" class="control-label">
                                    <?= translate('box'); ?>
                                </label>
                                <input class="form-control" name="box" id="box" type="text"
                                    value="<?= set_value('box'); ?>">
                            </div>
                        </div>

                        <div class="col-sm-4 mb-sm">
                            <div class="form-group">
                                <label for="onu_serial" class="control-label">
                                    <?= translate('onu_serial'); ?>
                                </label>
                                <input class="form-control" name="onu_serial" id="onu_serial" type="text"
                                    value="<?= set_value('onu_serial'); ?>">
                            </div>
                        </div>

                        <div class="col-sm-4 mb-sm">
                            <div class="form-group">
                                <label class="control-label">
                                    <?= translate('connection_type'); ?>
                                    <span class="required">*</span>
                                </label>
                                <?= form_dropdown(
                                    "connection_type",
                                    [
                                        '' => translate('select'),
                                        'pppoe' => 'PPPOE'
                                    ],
                                    set_value('connection_type'),
                                    "class='form-control' data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity'"
                                ); ?>
                            </div>
                        </div>
                    </div>

                    <div class="row">

                        <div class="col-sm-3 mb-sm">
                            <div class="form-group">
                                <label for="cable_requirement" class="control-label">
                                    <?= translate('cable_requirement_in_metre'); ?>
                                </label>
                                <input
                                    type="number"
                                    class="form-control"
                                    name="cable_requirement" id="cable_requirement"
                                    value="<?= set_value('cable_requirement'); ?>">
                            </div>
                        </div>
                        <div class="col-sm-3 mb-sm">
                            <div class="form-group">
                                <label for="fiber_code" class="control-label">
                                    <?= translate('fiber_code'); ?>
                                </label>
                                <input type="text"
                                    class="form-control"
                                    name="fiber_code" id="fiber_code"
                                    value="<?= set_value('fiber_code'); ?>">
                            </div>
                        </div>
                        <div class="col-sm-3 mb-sm">
                            <div class="form-group">
                                <label for="number_of_core" class="control-label">
                                    <?= translate('number_of_core'); ?>
                                </label>
                                <input type="number"
                                    class="form-control"
                                    name="number_of_core" id="number_of_core"
                                    value="<?= set_value('number_of_core'); ?>">
                            </div>
                        </div>
                        <div class="col-sm-3 mb-sm">
                            <div class="form-group">
                                <label for="core_color" class="control-label">
                                    <?= translate('core_color'); ?>
                                </label>
                                <input
                                    type="text"
                                    class="form-control"
                                    name="core_color" id="core_color"
                                    value="<?= set_value('core_color'); ?>">
                            </div>
                        </div>
                    </div>
                </section>

                <!-- Service Information -->
                <section>
                    <div class="headers-line">
                        <i class="fas fa-toolbox"></i> <?= translate('Service Information'); ?>
                    </div>

                    <div class="row">

                        <!-- package -->
                        <div class="col-sm-6 mb-sm">
                            <div class="form-group">
                                <label for="package_id" class="control-label">
                                    <?= translate('package') ?>
                                    <span class="required">*</span>
                                </label>
                                <select name="package_id" id="package_id" class='form-control' data-plugin-selectTwo
                                    data-width='100%' data-minimum-results-for-search='Infinity'>
                                    <option value=""><?= translate('select') ?></option>
                                    <?php if (!empty($packages)): ?>
                                        <?php foreach ($packages as $package): ?>
                                            <option value="<?= $package->id ?>" <?= set_select('package_id', $package->id) ?>>
                                                <?= $package->name ?> (<?= $package->type ?>)
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div>

                        <!-- client_type -->
                        <div class="col-sm-6 mb-sm">
                            <div class="form-group">
                                <label for="client_type" class="control-label"><?= translate('client_type'); ?>
                                    <span class="required">*</span></label>
                                <?= form_dropdown(
                                    "client_type",
                                    [
                                        "" => translate('select'),
                                        "home" => translate('home'),
                                        "corporate" => translate('corporate')
                                    ],
                                    set_value('client_type'),
                                    "id='client_type' class='form-control' data-plugin-selectTwo data-width='100%' data-minimum-results-for-search='Infinity'"
                                ); ?>
                            </div>
                        </div>

                    </div>

                    <div class="row">

                        <!-- server_username -->
                        <div class="col-sm-3 mb-sm">
                            <div class="form-group <?= form_error('server_username') ? 'has-error' : '' ?>">
                                <label for="server_username" class="control-label">
                                    <?= translate('server_username'); ?>
                                    <span class="required">*</span>
                                </label>
                                <input id="server_username" type="text" class="form-control" name="server_username"
                                    value="<?= set_value('server_username'); ?>">
                                <span class="error"><?= form_error('server_username'); ?></span>
                            </div>
                        </div>

                        <!-- server_password -->
                        <div class="col-sm-3 mb-sm">
                            <div class="form-group <?= form_error('server_password') ? 'has-error' : '' ?>">
                                <label for="server_password" class="control-label">
                                    <?= translate('server_password'); ?>
                                    <span class="required">*</span>
                                </label>
                                <input
                                    type="password"
                                    class="form-control"
                                    name="server_password" id="server_password"
                                    value="<?= set_value('server_password'); ?>">
                                <span class="error"><?= form_error('server_password'); ?></span>
                            </div>
                        </div>

                        <div class="col-sm-3 mb-sm">
                            <div class="form-group">
                                <label for="expire_date" class="control-label">
                                    <?= translate('expire_date'); ?>
                                    <span class="required">*</span>
                                </label>
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fas fa-calendar-alt"></i></span>
                                    <input id="expire_date" class="form-control" name="expire_date"
                                        value="<?= set_value('expire_date'); ?>" data-plugin-datepicker
                                        type="text">
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-3 mb-sm">
                            <div class="form-group">
                                <label for="reference_by"
                                    class="control-label"><?= translate('reference_by'); ?></label>
                                <input id="reference_by" class="form-control" name="reference_by" type="text"
                                    value="<?= set_value('reference_by'); ?>">
                            </div>
                        </div>
                    </div>
                </section>


            </div>
            <footer class="panel-footer">
                <div class="row">
                    <div class="col-md-offset-10 col-md-2">
                        <button type="submit" name="save" value="1" class="btn btn btn-default btn-block"><i
                                class="fas fa-plus-circle"></i> <?= translate('save'); ?></button>
                    </div>
                </div>
            </footer>
            <?= form_close(); ?>
        </section>
    </div>
</div>